---
title: AZU015
summary: The minimum TLS version for Storage Accounts should be TLS1_2 [azurerm_storage_account] 
resources: 
permalink: /docs/azure/AZU015/
nav_order: 2
parent: AZURE Checks
---

## The minimum TLS version for Storage Accounts should be TLS1_2

### Explanation


Azure Storage currently supports three versions of the TLS protocol: 1.0, 1.1, and 1.2. 

Azure Storage uses TLS 1.2 on public HTTPS endpoints, but TLS 1.0 and TLS 1.1 are still supported for backward compatibility.

This check will warn if the minimum TLS is not set to TLS1_2.



### Insecure Example

The following example will fail the AZU015 check.

{% highlight terraform %}

resource "azurerm_storage_account" "bad_example" {
  name                     = "storageaccountname"
  resource_group_name      = azurerm_resource_group.example.name
  location                 = azurerm_resource_group.example.location
}

{% endhighlight %}



### Secure Example

The following example will pass the AZU015 check.

{% highlight terraform %}

resource "azurerm_storage_account" "good_example" {
  name                     = "storageaccountname"
  resource_group_name      = azurerm_resource_group.example.name
  location                 = azurerm_resource_group.example.location
  min_tls_version          = "TLS1_2"
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/storage_account#min_tls_version](https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/storage_account#min_tls_version){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.microsoft.com/en-us/azure/storage/common/transport-layer-security-configure-minimum-version](https://docs.microsoft.com/en-us/azure/storage/common/transport-layer-security-configure-minimum-version){:target="_blank" rel="nofollow noreferrer noopener"}

