---
title: AZU007
summary: Ensure RBAC is enabled on AKS clusters [azurerm_kubernetes_cluster role_based_access_control] 
resources: 
permalink: /docs/azure/AZU007/
nav_order: 2
parent: AZURE Checks
---

## Ensure RBAC is enabled on AKS clusters

### Explanation


Using Kubernetes role-based access control (RBAC), you can grant users, groups, and service accounts access to only the resources they need.



### Insecure Example

The following example will fail the AZU007 check.

{% highlight terraform %}

resource "azurerm_kubernetes_cluster" "my-aks-cluster" {
	role_based_access_control {
		enabled = false
	}
}

{% endhighlight %}



### Secure Example

The following example will pass the AZU007 check.

{% highlight terraform %}

resource "azurerm_kubernetes_cluster" "my-aks-cluster" {
	role_based_access_control {
		enabled = true
	}
}

{% endhighlight %}


### Related Links


- [https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#role_based_access_control](https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#role_based_access_control){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.microsoft.com/en-us/azure/aks/concepts-identity](https://docs.microsoft.com/en-us/azure/aks/concepts-identity){:target="_blank" rel="nofollow noreferrer noopener"}

