---
title: AZU004
summary: Unencrypted data lake storage. [azurerm_data_lake_store] 
resources: 
permalink: /docs/azure/AZU004/
nav_order: 2
parent: AZURE Checks
---

## Unencrypted data lake storage.

### Explanation


Datalake storage encryption defaults to Enabled, it shouldn't be overridden to Disabled.



### Insecure Example

The following example will fail the AZU004 check.

{% highlight terraform %}

resource "azurerm_data_lake_store" "my-lake-store" {
	encryption_state = "Disabled"
}
{% endhighlight %}



### Secure Example

The following example will pass the AZU004 check.

{% highlight terraform %}

resource "azurerm_data_lake_store" "my-lake-store" {
	encryption_state = "Enabled"
}
{% endhighlight %}


### Related Links


- [https://docs.microsoft.com/en-us/azure/data-lake-store/data-lake-store-security-overview](https://docs.microsoft.com/en-us/azure/data-lake-store/data-lake-store-security-overview){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/azurerm/r/data_lake_store.html](https://www.terraform.io/docs/providers/azurerm/r/data_lake_store.html){:target="_blank" rel="nofollow noreferrer noopener"}

