---
title: AWS050
summary: An ingress Network ACL rule allows ALL ports from `/0`. [aws_network_acl_rule] 
resources: 
permalink: /docs/aws/AWS050/
nav_order: 2
parent: AWS Checks
---

## An ingress Network ACL rule allows ALL ports from `/0`.

### Explanation


Opening up ACLs to the public internet is potentially dangerous. You should restrict access to IP addresses or ranges that explicitly require it where possible, and ensure that you specify required ports.




### Insecure Example

The following example will fail the AWS050 check.

{% highlight terraform %}

resource "aws_network_acl_rule" "my-rule" {
  egress         = false
  protocol       = "all"
  rule_action    = "allow"
  cidr_block     = "0.0.0.0/0"
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS050 check.

{% highlight terraform %}

resource "aws_network_acl_rule" "my-rule" {
  egress         = false
  protocol       = "tcp"
  from_port      = 22
  to_port        = 22
  rule_action    = "allow"
  cidr_block     = "0.0.0.0/0"
}

{% endhighlight %}


### Related Links


- [https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html){:target="_blank" rel="nofollow noreferrer noopener"}

