---
title: AWS047
summary: AWS SQS policy document has wildcard action statement. [aws_sqs_queue_policy] 
resources: 
permalink: /docs/aws/AWS047/
nav_order: 2
parent: AWS Checks
---

## AWS SQS policy document has wildcard action statement.

### Explanation


SQS Policy actions should always be restricted to a specific set.

This ensures that the queue itself cannot be modified or deleted, and prevents possible future additions to queue actions to be implicitly allowed.



### Insecure Example

The following example will fail the AWS047 check.

{% highlight terraform %}

resource "aws_sqs_queue_policy" "test" {
  queue_url = aws_sqs_queue.q.id

  policy = <<POLICY
{
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": "*",
      "Action": "*"
    }
  ]
}
POLICY
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS047 check.

{% highlight terraform %}

resource "aws_sqs_queue_policy" "test" {
  queue_url = aws_sqs_queue.q.id

  policy = <<POLICY
{
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": "*",
      "Action": "sqs:SendMessage"
    }
  ]
}
POLICY
}

{% endhighlight %}


### Related Links


- [https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-security-best-practices.html](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-security-best-practices.html){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/sqs_queue_policy](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/sqs_queue_policy){:target="_blank" rel="nofollow noreferrer noopener"}

