---
title: AWS041
summary: IAM Password policy should have requirement for at least one number in the password. [aws_iam_account_password_policy] 
resources: 
permalink: /docs/aws/AWS041/
nav_order: 2
parent: AWS Checks
---

## IAM Password policy should have requirement for at least one number in the password.

### Explanation


IAM account password policies should ensure that passwords content including at least one number.



### Insecure Example

The following example will fail the AWS041 check.

{% highlight terraform %}

resource "aws_iam_account_password_policy" "strict" {
	# ...
	# require_numbers not set
	# ...
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS041 check.

{% highlight terraform %}

resource "aws_iam_account_password_policy" "strict" {
	# ...
	require_numbers = true
	# ...
}

{% endhighlight %}


### Related Links


- [https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html#password-policy-details](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html#password-policy-details){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_account_password_policy](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_account_password_policy){:target="_blank" rel="nofollow noreferrer noopener"}

