---
title: AWS040
summary: IAM Password policy should have requirement for at least one symbol in the password. [aws_iam_account_password_policy] 
resources: 
permalink: /docs/aws/AWS040/
nav_order: 2
parent: AWS Checks
---

## IAM Password policy should have requirement for at least one symbol in the password.

### Explanation


IAM account password policies should ensure that passwords content including a symbol.



### Insecure Example

The following example will fail the AWS040 check.

{% highlight terraform %}

resource "aws_iam_account_password_policy" "strict" {
	# ...
	# require_symbols not set
	# ...
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS040 check.

{% highlight terraform %}

resource "aws_iam_account_password_policy" "strict" {
	# ...
	require_symbols = true
	# ...
}

{% endhighlight %}


### Related Links


- [https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html#password-policy-details](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html#password-policy-details){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_account_password_policy](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_account_password_policy){:target="_blank" rel="nofollow noreferrer noopener"}

