---
title: AWS035
summary: Unencrypted Elasticache Replication Group. [aws_elasticache_replication_group] 
resources: 
permalink: /docs/aws/AWS035/
nav_order: 2
parent: AWS Checks
---

## Unencrypted Elasticache Replication Group.

### Explanation


You should ensure your Elasticache data is encrypted at rest to help prevent sensitive information from being read by unauthorised users.



### Insecure Example

The following example will fail the AWS035 check.

{% highlight terraform %}

resource "aws_elasticache_replication_group" "my-resource" {
        replication_group_id = "foo"
        replication_group_description = "my foo cluster"

        at_rest_encryption_enabled = false
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS035 check.

{% highlight terraform %}

resource "aws_elasticache_replication_group" "my-resource" {
        replication_group_id = "foo"
        replication_group_description = "my foo cluster"

        at_rest_encryption_enabled = true
}

{% endhighlight %}


### Related Links


