---
title: AWS031
summary: Elasticsearch domain isn't encrypted at rest. [aws_elasticsearch_domain] 
resources: 
permalink: /docs/aws/AWS031/
nav_order: 2
parent: AWS Checks
---

## Elasticsearch domain isn't encrypted at rest.

### Explanation


You should ensure your Elasticsearch data is encrypted at rest to help prevent sensitive information from being read by unauthorised users. 



### Insecure Example

The following example will fail the AWS031 check.

{% highlight terraform %}

resource "aws_elasticsearch_domain" "my_elasticsearch_domain" {
  domain_name = "domain-foo"

  encrypt_at_rest {
    enabled = false
  }
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS031 check.

{% highlight terraform %}

resource "aws_elasticsearch_domain" "my_elasticsearch_domain" {
  domain_name = "domain-foo"

  encrypt_at_rest {
    enabled = true
  }
}

{% endhighlight %}


### Related Links


