---
title: AWS021
summary: CloudFront distribution uses outdated SSL/TLS protocols. [aws_cloudfront_distribution] 
resources: 
permalink: /docs/aws/AWS021/
nav_order: 2
parent: AWS Checks
---

## CloudFront distribution uses outdated SSL/TLS protocols.

### Explanation


You should not use outdated/insecure TLS versions for encryption. You should be using TLS v1.2+.



### Insecure Example

The following example will fail the AWS021 check.

{% highlight terraform %}

resource "aws_cloudfront_distribution" "s3_distribution" {
  viewer_certificate {
    cloudfront_default_certificate = true
	minimum_protocol_version = "TLSv1.0"
  }
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS021 check.

{% highlight terraform %}

resource "aws_cloudfront_distribution" "s3_distribution" {
  viewer_certificate {
    cloudfront_default_certificate = true
	minimum_protocol_version = "TLSv1.2_2019"
  }
}

{% endhighlight %}


### Related Links


