---
title: AWS012
summary: A resource has a public IP address. [aws_launch_configuration aws_instance] 
resources: 
permalink: /docs/aws/AWS012/
nav_order: 2
parent: AWS Checks
---

## A resource has a public IP address.

### Explanation


You should limit the provision of public IP addresses for resources. Resources should not be exposed on the public internet, but should have access limited to consumers required for the function of your application. 



### Insecure Example

The following example will fail the AWS012 check.

{% highlight terraform %}

resource "aws_launch_configuration" "my-resource" {
	associate_public_ip_address = true
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS012 check.

{% highlight terraform %}

resource "aws_launch_configuration" "my-resource" {
	associate_public_ip_address = false
}

{% endhighlight %}


### Related Links


