---
title: AWS011
summary: A resource is marked as publicly accessible. [aws_db_instance aws_dms_replication_instance aws_rds_cluster_instance aws_redshift_cluster] 
resources: 
permalink: /docs/aws/AWS011/
nav_order: 2
parent: AWS Checks
---

## A resource is marked as publicly accessible.

### Explanation


Database resources should not publicly available. You should limit all access to the minimum that is required for your application to function. 



### Insecure Example

The following example will fail the AWS011 check.

{% highlight terraform %}

resource "aws_db_instance" "my-resource" {
	publicly_accessible = true
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS011 check.

{% highlight terraform %}

resource "aws_db_instance" "my-resource" {
	publicly_accessible = false
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/db_instance](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/db_instance){:target="_blank" rel="nofollow noreferrer noopener"}

