---
title: AWS008
summary: An inline ingress security group rule allows traffic from `/0`. [aws_security_group] 
resources: 
permalink: /docs/aws/AWS008/
nav_order: 2
parent: AWS Checks
---

## An inline ingress security group rule allows traffic from `/0`.

### Explanation


Opening up ports to the public internet is generally to be avoided. You should restrict access to IP addresses or ranges that explicitly require it where possible.



### Insecure Example

The following example will fail the AWS008 check.

{% highlight terraform %}

resource "aws_security_group" "my-group" {
	ingress {
		cidr_blocks = ["0.0.0.0/0"]
	}
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS008 check.

{% highlight terraform %}

resource "aws_security_group" "my-group" {
	ingress {
		cidr_blocks = ["1.2.3.4/32"]
	}
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/security_group](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/security_group){:target="_blank" rel="nofollow noreferrer noopener"}

