---
title: AWS005
summary: Load balancer is exposed to the internet. [aws_alb aws_elb aws_lb] 
resources: 
permalink: /docs/aws/AWS005/
nav_order: 2
parent: AWS Checks
---

## Load balancer is exposed to the internet.

### Explanation


There are many scenarios in which you would want to expose a load balancer to the wider internet, but this check exists as a warning to prevent accidental exposure of internal assets. You should ensure that this resource should be exposed publicly.



### Insecure Example

The following example will fail the AWS005 check.

{% highlight terraform %}

resource "aws_alb" "my-resource" {
	internal = false
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS005 check.

{% highlight terraform %}

resource "aws_alb" "my-resource" {
	internal = true
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/lb](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/lb){:target="_blank" rel="nofollow noreferrer noopener"}

