---
title: AWS001
summary: S3 Bucket has an ACL defined which allows public access. [aws_s3_bucket] 
resources: 
permalink: /docs/aws/AWS001/
nav_order: 2
parent: AWS Checks
---

## S3 Bucket has an ACL defined which allows public access.

### Explanation


S3 bucket permissions should be set to deny public access unless explicitly required.

Granting write access publicly with <code>public-read-write</code> is especially dangerous as you will be billed for any uploaded files.

Additionally, you should not use the <code>authenticated-read</code> canned ACL, as this provides read access to any authenticated AWS user, not just AWS users within your organisation.



### Insecure Example

The following example will fail the AWS001 check.

{% highlight terraform %}

resource "aws_s3_bucket" "my-bucket" {
	acl = "public-read"
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS001 check.

{% highlight terraform %}

resource "aws_s3_bucket" "my-bucket" {
	acl = "private"
}

{% endhighlight %}


### Related Links


- [https://aws.amazon.com/premiumsupport/knowledge-center/secure-s3-resources/](https://aws.amazon.com/premiumsupport/knowledge-center/secure-s3-resources/){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/s3_bucket](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/s3_bucket){:target="_blank" rel="nofollow noreferrer noopener"}

