/*
    Copyright (C) 2021 Accurics, Inc.

	Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

		http://www.apache.org/licenses/LICENSE-2.0

	Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

package config

// Config holds the common resource config fields
type Config struct {
	Tags interface{} `json:"tags"`
	Name string      `json:"name"`
}

// AWSResourceConfig helps define type and name for sub-resources if nedded
type AWSResourceConfig struct {
	Resource interface{}
	Metadata map[string]interface{}
	Name     string
	Type     string
}
