package accurics

{{.prefix}}s3Versioning[bucket.id] {
    bucket := input.aws_s3_bucket[_]
    checkBucketVersioning(bucket)
}

checkBucketVersioning(bucket) {
    object.get(bucket.config, "versioning", "undefined") != [[], null, "undefined"][_]

    bucket.config.versioning[_] != true
}

checkBucketVersioning(bucket) {
    object.get(bucket.config, "versioning", "undefined") == [[], null, "undefined"][_]

    versioning := input.aws_s3_bucket_versioning[_]

    cleanID := cleanVersioningBucketID(versioning.config.bucket)
    bucket.id == cleanID

    versioning_status := lower(versioning.config.versioning_configuration[_].status)
    versioning_status != "enabled"
}

# remove all id related prefix and suffix characters generated by terrascan
cleanVersioningBucketID(sseBucketID) = cleanID {
    v1 := trim_left(sseBucketID, "$")
    v2 := trim_left(v1, "{")
    v3 := trim_right(v2, "}")
    cleanID = cleanEnd(v3)
}

cleanEnd(sseBucketID_v3) = cleanID {
    endswith(sseBucketID_v3, ".id")
    cleanID = trim_right(sseBucketID_v3, ".id")
}

cleanEnd(sseBucketID_v3) = cleanID {
    endswith(sseBucketID_v3, ".bucket")
    cleanID = trim_right(sseBucketID_v3, ".bucket")
}