// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/namespace/v1/message.proto

package namespace

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"

	proto "github.com/gogo/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type NamespaceCacheInfo struct {
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "in" and "by" are needed here. --)
	ItemsInCacheByIdCount int64 `protobuf:"varint,1,opt,name=items_in_cache_by_id_count,json=itemsInCacheByIdCount,proto3" json:"items_in_cache_by_id_count,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "in" and "by" are needed here. --)
	ItemsInCacheByNameCount int64 `protobuf:"varint,2,opt,name=items_in_cache_by_name_count,json=itemsInCacheByNameCount,proto3" json:"items_in_cache_by_name_count,omitempty"`
}

func (m *NamespaceCacheInfo) Reset()      { *m = NamespaceCacheInfo{} }
func (*NamespaceCacheInfo) ProtoMessage() {}
func (*NamespaceCacheInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_bd829fe44a7a2771, []int{0}
}
func (m *NamespaceCacheInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceCacheInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceCacheInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceCacheInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceCacheInfo.Merge(m, src)
}
func (m *NamespaceCacheInfo) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceCacheInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceCacheInfo.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceCacheInfo proto.InternalMessageInfo

func (m *NamespaceCacheInfo) GetItemsInCacheByIdCount() int64 {
	if m != nil {
		return m.ItemsInCacheByIdCount
	}
	return 0
}

func (m *NamespaceCacheInfo) GetItemsInCacheByNameCount() int64 {
	if m != nil {
		return m.ItemsInCacheByNameCount
	}
	return 0
}

func init() {
	proto.RegisterType((*NamespaceCacheInfo)(nil), "temporal.server.api.namespace.v1.NamespaceCacheInfo")
}

func init() {
	proto.RegisterFile("temporal/server/api/namespace/v1/message.proto", fileDescriptor_bd829fe44a7a2771)
}

var fileDescriptor_bd829fe44a7a2771 = []byte{
	// 253 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0xd2, 0x2b, 0x49, 0xcd, 0x2d,
	0xc8, 0x2f, 0x4a, 0xcc, 0xd1, 0x2f, 0x4e, 0x2d, 0x2a, 0x4b, 0x2d, 0xd2, 0x4f, 0x2c, 0xc8, 0xd4,
	0xcf, 0x4b, 0xcc, 0x4d, 0x2d, 0x2e, 0x48, 0x4c, 0x4e, 0xd5, 0x2f, 0x33, 0xd4, 0xcf, 0x4d, 0x2d,
	0x2e, 0x4e, 0x4c, 0x4f, 0xd5, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0x17, 0x52, 0x80, 0xa9, 0xd7, 0x83,
	0xa8, 0xd7, 0x4b, 0x2c, 0xc8, 0xd4, 0x83, 0xab, 0xd7, 0x2b, 0x33, 0x54, 0xea, 0x63, 0xe4, 0x12,
	0xf2, 0x83, 0x09, 0x38, 0x27, 0x26, 0x67, 0xa4, 0x7a, 0xe6, 0xa5, 0xe5, 0x0b, 0x59, 0x72, 0x49,
	0x65, 0x96, 0xa4, 0xe6, 0x16, 0xc7, 0x67, 0xe6, 0xc5, 0x27, 0x83, 0x44, 0xe3, 0x93, 0x2a, 0xe3,
	0x33, 0x53, 0xe2, 0x93, 0xf3, 0x4b, 0xf3, 0x4a, 0x24, 0x18, 0x15, 0x18, 0x35, 0x98, 0x83, 0x44,
	0xc1, 0x2a, 0x3c, 0xf3, 0xc0, 0xba, 0x9c, 0x2a, 0x3d, 0x53, 0x9c, 0x41, 0x92, 0x42, 0xb6, 0x5c,
	0x32, 0x98, 0x5a, 0x41, 0x76, 0x42, 0x35, 0x33, 0x81, 0x35, 0x8b, 0xa3, 0x6a, 0x06, 0x39, 0x01,
	0xac, 0xdd, 0x29, 0xed, 0xc2, 0x43, 0x39, 0x86, 0x1b, 0x0f, 0xe5, 0x18, 0x3e, 0x3c, 0x94, 0x63,
	0x6c, 0x78, 0x24, 0xc7, 0xb8, 0xe2, 0x91, 0x1c, 0xe3, 0x89, 0x47, 0x72, 0x8c, 0x17, 0x1e, 0xc9,
	0x31, 0x3e, 0x78, 0x24, 0xc7, 0xf8, 0xe2, 0x91, 0x1c, 0xc3, 0x87, 0x47, 0x72, 0x8c, 0x13, 0x1e,
	0xcb, 0x31, 0x5c, 0x78, 0x2c, 0xc7, 0x70, 0xe3, 0xb1, 0x1c, 0x43, 0x94, 0x41, 0x7a, 0x3e, 0x3c,
	0x6c, 0xf4, 0x32, 0xf3, 0x71, 0x05, 0x8f, 0x35, 0x9c, 0x93, 0xc4, 0x06, 0x0e, 0x21, 0x63, 0x40,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x31, 0xe9, 0x71, 0x89, 0x53, 0x01, 0x00, 0x00,
}

func (this *NamespaceCacheInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NamespaceCacheInfo)
	if !ok {
		that2, ok := that.(NamespaceCacheInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ItemsInCacheByIdCount != that1.ItemsInCacheByIdCount {
		return false
	}
	if this.ItemsInCacheByNameCount != that1.ItemsInCacheByNameCount {
		return false
	}
	return true
}
func (this *NamespaceCacheInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&namespace.NamespaceCacheInfo{")
	s = append(s, "ItemsInCacheByIdCount: "+fmt.Sprintf("%#v", this.ItemsInCacheByIdCount)+",\n")
	s = append(s, "ItemsInCacheByNameCount: "+fmt.Sprintf("%#v", this.ItemsInCacheByNameCount)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringMessage(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *NamespaceCacheInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceCacheInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceCacheInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ItemsInCacheByNameCount != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ItemsInCacheByNameCount))
		i--
		dAtA[i] = 0x10
	}
	if m.ItemsInCacheByIdCount != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ItemsInCacheByIdCount))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintMessage(dAtA []byte, offset int, v uint64) int {
	offset -= sovMessage(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *NamespaceCacheInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ItemsInCacheByIdCount != 0 {
		n += 1 + sovMessage(uint64(m.ItemsInCacheByIdCount))
	}
	if m.ItemsInCacheByNameCount != 0 {
		n += 1 + sovMessage(uint64(m.ItemsInCacheByNameCount))
	}
	return n
}

func sovMessage(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMessage(x uint64) (n int) {
	return sovMessage(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *NamespaceCacheInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NamespaceCacheInfo{`,
		`ItemsInCacheByIdCount:` + fmt.Sprintf("%v", this.ItemsInCacheByIdCount) + `,`,
		`ItemsInCacheByNameCount:` + fmt.Sprintf("%v", this.ItemsInCacheByNameCount) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMessage(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *NamespaceCacheInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NamespaceCacheInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NamespaceCacheInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ItemsInCacheByIdCount", wireType)
			}
			m.ItemsInCacheByIdCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ItemsInCacheByIdCount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ItemsInCacheByNameCount", wireType)
			}
			m.ItemsInCacheByNameCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ItemsInCacheByNameCount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMessage(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMessage
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMessage
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMessage
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMessage        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMessage          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMessage = fmt.Errorf("proto: unexpected end of group")
)
