// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package mocks

import (
	mock "github.com/stretchr/testify/mock"

	persistence "go.temporal.io/server/common/persistence"
)

// MetadataManager is an autogenerated mock type for the MetadataManager type
type MetadataManager struct {
	mock.Mock
}

func (_m *MetadataManager) InitializeSystemNamespaces(currentClusterName string) error {
	panic("implement me")
}

// GetName provides a mock function with given fields:
func (_m *MetadataManager) GetName() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// Close provides a mock function with given fields:
func (_m *MetadataManager) Close() {
	_m.Called()
}

// CreateNamespace provides a mock function with given fields: request
func (_m *MetadataManager) CreateNamespace(request *persistence.CreateNamespaceRequest) (*persistence.CreateNamespaceResponse, error) {
	ret := _m.Called(request)

	var r0 *persistence.CreateNamespaceResponse
	if rf, ok := ret.Get(0).(func(*persistence.CreateNamespaceRequest) *persistence.CreateNamespaceResponse); ok {
		r0 = rf(request)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.CreateNamespaceResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*persistence.CreateNamespaceRequest) error); ok {
		r1 = rf(request)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteNamespace provides a mock function with given fields: request
func (_m *MetadataManager) DeleteNamespace(request *persistence.DeleteNamespaceRequest) error {
	ret := _m.Called(request)

	var r0 error
	if rf, ok := ret.Get(0).(func(*persistence.DeleteNamespaceRequest) error); ok {
		r0 = rf(request)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteNamespaceByName provides a mock function with given fields: request
func (_m *MetadataManager) DeleteNamespaceByName(request *persistence.DeleteNamespaceByNameRequest) error {
	ret := _m.Called(request)

	var r0 error
	if rf, ok := ret.Get(0).(func(*persistence.DeleteNamespaceByNameRequest) error); ok {
		r0 = rf(request)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetNamespace provides a mock function with given fields: request
func (_m *MetadataManager) GetNamespace(request *persistence.GetNamespaceRequest) (*persistence.GetNamespaceResponse, error) {
	ret := _m.Called(request)

	var r0 *persistence.GetNamespaceResponse
	if rf, ok := ret.Get(0).(func(*persistence.GetNamespaceRequest) *persistence.GetNamespaceResponse); ok {
		r0 = rf(request)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.GetNamespaceResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*persistence.GetNamespaceRequest) error); ok {
		r1 = rf(request)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateNamespace provides a mock function with given fields: request
func (_m *MetadataManager) UpdateNamespace(request *persistence.UpdateNamespaceRequest) error {
	ret := _m.Called(request)

	var r0 error
	if rf, ok := ret.Get(0).(func(*persistence.UpdateNamespaceRequest) error); ok {
		r0 = rf(request)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ListNamespaces provides a mock function with given fields: request
func (_m *MetadataManager) ListNamespaces(request *persistence.ListNamespacesRequest) (*persistence.ListNamespacesResponse, error) {
	ret := _m.Called(request)

	var r0 *persistence.ListNamespacesResponse
	if rf, ok := ret.Get(0).(func(*persistence.ListNamespacesRequest) *persistence.ListNamespacesResponse); ok {
		r0 = rf(request)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.ListNamespacesResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*persistence.ListNamespacesRequest) error); ok {
		r1 = rf(request)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMetadata provides a mock function with given fields: request
func (_m *MetadataManager) GetMetadata() (*persistence.GetMetadataResponse, error) {
	ret := _m.Called()

	var r0 *persistence.GetMetadataResponse
	if rf, ok := ret.Get(0).(func() *persistence.GetMetadataResponse); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.GetMetadataResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
