// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/token/v1/message.proto

package token

import (
	bytes "bytes"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"

	proto "github.com/gogo/protobuf/proto"
	v1 "go.temporal.io/server/api/history/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type HistoryContinuation struct {
	RunId                 string                        `protobuf:"bytes,1,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	FirstEventId          int64                         `protobuf:"varint,2,opt,name=first_event_id,json=firstEventId,proto3" json:"first_event_id,omitempty"`
	NextEventId           int64                         `protobuf:"varint,3,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	IsWorkflowRunning     bool                          `protobuf:"varint,5,opt,name=is_workflow_running,json=isWorkflowRunning,proto3" json:"is_workflow_running,omitempty"`
	PersistenceToken      []byte                        `protobuf:"bytes,6,opt,name=persistence_token,json=persistenceToken,proto3" json:"persistence_token,omitempty"`
	TransientWorkflowTask *v1.TransientWorkflowTaskInfo `protobuf:"bytes,7,opt,name=transient_workflow_task,json=transientWorkflowTask,proto3" json:"transient_workflow_task,omitempty"`
	BranchToken           []byte                        `protobuf:"bytes,8,opt,name=branch_token,json=branchToken,proto3" json:"branch_token,omitempty"`
}

func (m *HistoryContinuation) Reset()      { *m = HistoryContinuation{} }
func (*HistoryContinuation) ProtoMessage() {}
func (*HistoryContinuation) Descriptor() ([]byte, []int) {
	return fileDescriptor_020fff7d28118bec, []int{0}
}
func (m *HistoryContinuation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistoryContinuation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistoryContinuation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistoryContinuation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistoryContinuation.Merge(m, src)
}
func (m *HistoryContinuation) XXX_Size() int {
	return m.Size()
}
func (m *HistoryContinuation) XXX_DiscardUnknown() {
	xxx_messageInfo_HistoryContinuation.DiscardUnknown(m)
}

var xxx_messageInfo_HistoryContinuation proto.InternalMessageInfo

func (m *HistoryContinuation) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *HistoryContinuation) GetFirstEventId() int64 {
	if m != nil {
		return m.FirstEventId
	}
	return 0
}

func (m *HistoryContinuation) GetNextEventId() int64 {
	if m != nil {
		return m.NextEventId
	}
	return 0
}

func (m *HistoryContinuation) GetIsWorkflowRunning() bool {
	if m != nil {
		return m.IsWorkflowRunning
	}
	return false
}

func (m *HistoryContinuation) GetPersistenceToken() []byte {
	if m != nil {
		return m.PersistenceToken
	}
	return nil
}

func (m *HistoryContinuation) GetTransientWorkflowTask() *v1.TransientWorkflowTaskInfo {
	if m != nil {
		return m.TransientWorkflowTask
	}
	return nil
}

func (m *HistoryContinuation) GetBranchToken() []byte {
	if m != nil {
		return m.BranchToken
	}
	return nil
}

type RawHistoryContinuation struct {
	Namespace         string               `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	WorkflowId        string               `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId             string               `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	StartEventId      int64                `protobuf:"varint,4,opt,name=start_event_id,json=startEventId,proto3" json:"start_event_id,omitempty"`
	StartEventVersion int64                `protobuf:"varint,5,opt,name=start_event_version,json=startEventVersion,proto3" json:"start_event_version,omitempty"`
	EndEventId        int64                `protobuf:"varint,6,opt,name=end_event_id,json=endEventId,proto3" json:"end_event_id,omitempty"`
	EndEventVersion   int64                `protobuf:"varint,7,opt,name=end_event_version,json=endEventVersion,proto3" json:"end_event_version,omitempty"`
	PersistenceToken  []byte               `protobuf:"bytes,8,opt,name=persistence_token,json=persistenceToken,proto3" json:"persistence_token,omitempty"`
	VersionHistories  *v1.VersionHistories `protobuf:"bytes,9,opt,name=version_histories,json=versionHistories,proto3" json:"version_histories,omitempty"`
}

func (m *RawHistoryContinuation) Reset()      { *m = RawHistoryContinuation{} }
func (*RawHistoryContinuation) ProtoMessage() {}
func (*RawHistoryContinuation) Descriptor() ([]byte, []int) {
	return fileDescriptor_020fff7d28118bec, []int{1}
}
func (m *RawHistoryContinuation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawHistoryContinuation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawHistoryContinuation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawHistoryContinuation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawHistoryContinuation.Merge(m, src)
}
func (m *RawHistoryContinuation) XXX_Size() int {
	return m.Size()
}
func (m *RawHistoryContinuation) XXX_DiscardUnknown() {
	xxx_messageInfo_RawHistoryContinuation.DiscardUnknown(m)
}

var xxx_messageInfo_RawHistoryContinuation proto.InternalMessageInfo

func (m *RawHistoryContinuation) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *RawHistoryContinuation) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *RawHistoryContinuation) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *RawHistoryContinuation) GetStartEventId() int64 {
	if m != nil {
		return m.StartEventId
	}
	return 0
}

func (m *RawHistoryContinuation) GetStartEventVersion() int64 {
	if m != nil {
		return m.StartEventVersion
	}
	return 0
}

func (m *RawHistoryContinuation) GetEndEventId() int64 {
	if m != nil {
		return m.EndEventId
	}
	return 0
}

func (m *RawHistoryContinuation) GetEndEventVersion() int64 {
	if m != nil {
		return m.EndEventVersion
	}
	return 0
}

func (m *RawHistoryContinuation) GetPersistenceToken() []byte {
	if m != nil {
		return m.PersistenceToken
	}
	return nil
}

func (m *RawHistoryContinuation) GetVersionHistories() *v1.VersionHistories {
	if m != nil {
		return m.VersionHistories
	}
	return nil
}

type Task struct {
	NamespaceId     string `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId      string `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId           string `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	ScheduleId      int64  `protobuf:"varint,4,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	ScheduleAttempt int32  `protobuf:"varint,5,opt,name=schedule_attempt,json=scheduleAttempt,proto3" json:"schedule_attempt,omitempty"`
	ActivityId      string `protobuf:"bytes,6,opt,name=activity_id,json=activityId,proto3" json:"activity_id,omitempty"`
	WorkflowType    string `protobuf:"bytes,7,opt,name=workflow_type,json=workflowType,proto3" json:"workflow_type,omitempty"`
	ActivityType    string `protobuf:"bytes,8,opt,name=activity_type,json=activityType,proto3" json:"activity_type,omitempty"`
}

func (m *Task) Reset()      { *m = Task{} }
func (*Task) ProtoMessage() {}
func (*Task) Descriptor() ([]byte, []int) {
	return fileDescriptor_020fff7d28118bec, []int{2}
}
func (m *Task) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Task) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Task.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Task) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Task.Merge(m, src)
}
func (m *Task) XXX_Size() int {
	return m.Size()
}
func (m *Task) XXX_DiscardUnknown() {
	xxx_messageInfo_Task.DiscardUnknown(m)
}

var xxx_messageInfo_Task proto.InternalMessageInfo

func (m *Task) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *Task) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *Task) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *Task) GetScheduleId() int64 {
	if m != nil {
		return m.ScheduleId
	}
	return 0
}

func (m *Task) GetScheduleAttempt() int32 {
	if m != nil {
		return m.ScheduleAttempt
	}
	return 0
}

func (m *Task) GetActivityId() string {
	if m != nil {
		return m.ActivityId
	}
	return ""
}

func (m *Task) GetWorkflowType() string {
	if m != nil {
		return m.WorkflowType
	}
	return ""
}

func (m *Task) GetActivityType() string {
	if m != nil {
		return m.ActivityType
	}
	return ""
}

type QueryTask struct {
	NamespaceId string `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	TaskQueue   string `protobuf:"bytes,2,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	TaskId      string `protobuf:"bytes,3,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
}

func (m *QueryTask) Reset()      { *m = QueryTask{} }
func (*QueryTask) ProtoMessage() {}
func (*QueryTask) Descriptor() ([]byte, []int) {
	return fileDescriptor_020fff7d28118bec, []int{3}
}
func (m *QueryTask) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryTask) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryTask.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryTask) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryTask.Merge(m, src)
}
func (m *QueryTask) XXX_Size() int {
	return m.Size()
}
func (m *QueryTask) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryTask.DiscardUnknown(m)
}

var xxx_messageInfo_QueryTask proto.InternalMessageInfo

func (m *QueryTask) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *QueryTask) GetTaskQueue() string {
	if m != nil {
		return m.TaskQueue
	}
	return ""
}

func (m *QueryTask) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func init() {
	proto.RegisterType((*HistoryContinuation)(nil), "temporal.server.api.token.v1.HistoryContinuation")
	proto.RegisterType((*RawHistoryContinuation)(nil), "temporal.server.api.token.v1.RawHistoryContinuation")
	proto.RegisterType((*Task)(nil), "temporal.server.api.token.v1.Task")
	proto.RegisterType((*QueryTask)(nil), "temporal.server.api.token.v1.QueryTask")
}

func init() {
	proto.RegisterFile("temporal/server/api/token/v1/message.proto", fileDescriptor_020fff7d28118bec)
}

var fileDescriptor_020fff7d28118bec = []byte{
	// 665 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x94, 0x41, 0x6f, 0xd3, 0x3c,
	0x1c, 0xc6, 0x9b, 0x75, 0xeb, 0x9a, 0x7f, 0xbb, 0x77, 0x6d, 0xa6, 0xbd, 0xab, 0xd0, 0xc8, 0x4a,
	0xe1, 0x50, 0x06, 0x4a, 0x19, 0x9c, 0x10, 0x27, 0x40, 0x48, 0x0b, 0xb7, 0x45, 0x15, 0x48, 0x48,
	0x10, 0x79, 0x8d, 0xbb, 0x59, 0xdd, 0x9c, 0xcc, 0x76, 0x32, 0x7a, 0xe3, 0x23, 0x70, 0xe4, 0xc4,
	0x99, 0x8f, 0xc2, 0x71, 0xc7, 0x1d, 0x59, 0x76, 0xe1, 0xc6, 0x3e, 0x02, 0xb2, 0x13, 0x27, 0xd5,
	0x28, 0x02, 0x71, 0x6b, 0x9f, 0xff, 0x93, 0xc7, 0xf6, 0xf3, 0x93, 0x0d, 0xdb, 0x02, 0x1f, 0x47,
	0x21, 0x43, 0x47, 0x03, 0x8e, 0x59, 0x82, 0xd9, 0x00, 0x45, 0x64, 0x20, 0xc2, 0x09, 0xa6, 0x83,
	0x64, 0x67, 0x70, 0x8c, 0x39, 0x47, 0x07, 0xd8, 0x89, 0x58, 0x28, 0x42, 0x6b, 0x53, 0x7b, 0x9d,
	0xcc, 0xeb, 0xa0, 0x88, 0x38, 0xca, 0xeb, 0x24, 0x3b, 0x37, 0xee, 0xcf, 0x4b, 0x3a, 0x24, 0x5c,
	0x84, 0x6c, 0xfa, 0x4b, 0x56, 0xef, 0xc7, 0x02, 0xac, 0xed, 0x66, 0xc3, 0xe7, 0x21, 0x15, 0x84,
	0xc6, 0x48, 0x90, 0x90, 0x5a, 0xeb, 0x50, 0x63, 0x31, 0xf5, 0x49, 0xd0, 0x31, 0xba, 0x46, 0xdf,
	0xf4, 0x96, 0x58, 0x4c, 0xdd, 0xc0, 0xba, 0x03, 0xff, 0x8d, 0x09, 0xe3, 0xc2, 0xc7, 0x09, 0xa6,
	0x42, 0x8e, 0x17, 0xba, 0x46, 0xbf, 0xea, 0x35, 0x95, 0xfa, 0x42, 0x8a, 0x6e, 0x60, 0xf5, 0x60,
	0x85, 0xe2, 0xf7, 0x33, 0xa6, 0xaa, 0x32, 0x35, 0xa4, 0xa8, 0x3d, 0x0e, 0xac, 0x11, 0xee, 0x9f,
	0x86, 0x6c, 0x32, 0x3e, 0x0a, 0x4f, 0x7d, 0x16, 0x53, 0x4a, 0xe8, 0x41, 0x67, 0xa9, 0x6b, 0xf4,
	0xeb, 0x5e, 0x9b, 0xf0, 0xd7, 0xf9, 0xc4, 0xcb, 0x06, 0xd6, 0x3d, 0x68, 0x47, 0x98, 0x71, 0xc2,
	0x05, 0xa6, 0x23, 0xec, 0xab, 0xe3, 0x76, 0x6a, 0x5d, 0xa3, 0xdf, 0xf4, 0x5a, 0x33, 0x83, 0xa1,
	0xd4, 0xad, 0x13, 0xd8, 0x10, 0x0c, 0x51, 0x4e, 0xe4, 0xfa, 0xc5, 0x1a, 0x02, 0xf1, 0x49, 0x67,
	0xb9, 0x6b, 0xf4, 0x1b, 0x0f, 0x1f, 0x3b, 0xf3, 0x3a, 0xcc, 0x5b, 0x72, 0x92, 0x1d, 0x67, 0xa8,
	0x3f, 0xd7, 0xfb, 0x18, 0x22, 0x3e, 0x71, 0xe9, 0x38, 0xf4, 0xd6, 0xc5, 0xbc, 0x91, 0x75, 0x0b,
	0x9a, 0xfb, 0x0c, 0xd1, 0xd1, 0x61, 0xbe, 0xb5, 0xba, 0xda, 0x5a, 0x23, 0xd3, 0xd4, 0xae, 0x5e,
	0x2e, 0xd6, 0xcd, 0x16, 0xf4, 0x3e, 0x57, 0xe1, 0x7f, 0x0f, 0x9d, 0xce, 0x2b, 0x7d, 0x13, 0x4c,
	0x8a, 0x8e, 0x31, 0x8f, 0xd0, 0x08, 0xe7, 0xbd, 0x97, 0x82, 0xb5, 0x05, 0x8d, 0xe2, 0x28, 0x79,
	0xf1, 0xa6, 0x07, 0x5a, 0x72, 0x83, 0x19, 0x66, 0xd5, 0x6b, 0xcc, 0xb8, 0x40, 0x6c, 0x06, 0xc7,
	0x62, 0xc6, 0x4c, 0xa9, 0x33, 0x3c, 0x66, 0x5d, 0x89, 0xac, 0x34, 0xa4, 0x8a, 0x47, 0xd5, 0x6b,
	0x97, 0xd6, 0x57, 0xd9, 0xc0, 0xea, 0x42, 0x13, 0xd3, 0xa0, 0xcc, 0xac, 0x29, 0x23, 0x60, 0x1a,
	0xe8, 0xc4, 0x6d, 0x68, 0x97, 0x0e, 0x9d, 0xb7, 0xac, 0x6c, 0xab, 0xda, 0xa6, 0xd3, 0xe6, 0xd2,
	0xad, 0xff, 0x86, 0xee, 0x5b, 0x68, 0xe7, 0x71, 0x7e, 0x46, 0x8c, 0x60, 0xde, 0x31, 0x15, 0xd7,
	0x07, 0x7f, 0xe2, 0x9a, 0x2f, 0xb8, 0xab, 0xbf, 0xf3, 0x5a, 0xc9, 0x35, 0xa5, 0xf7, 0x69, 0x01,
	0x16, 0x35, 0xd2, 0xa2, 0xfd, 0xf2, 0x26, 0x34, 0x0a, 0xcd, 0x0d, 0xfe, 0x99, 0xc9, 0x16, 0x34,
	0xf8, 0xe8, 0x10, 0x07, 0xf1, 0x11, 0x2e, 0x81, 0x80, 0x96, 0xdc, 0xc0, 0xba, 0x0b, 0xad, 0xc2,
	0x80, 0x84, 0x3c, 0x94, 0x50, 0x2c, 0x96, 0xbc, 0x55, 0xad, 0x3f, 0xcd, 0x64, 0x99, 0x85, 0x46,
	0x82, 0x24, 0x44, 0x4c, 0x35, 0x08, 0xd3, 0x03, 0x2d, 0xb9, 0x81, 0x75, 0x1b, 0x56, 0xca, 0x3b,
	0x30, 0x8d, 0xb0, 0x82, 0x60, 0x7a, 0x4d, 0x2d, 0x0e, 0xa7, 0x11, 0x96, 0xa6, 0x22, 0x45, 0x99,
	0xea, 0x99, 0x49, 0x8b, 0xd2, 0xd4, 0x1b, 0x83, 0xb9, 0x17, 0x63, 0x36, 0xfd, 0xdb, 0x7a, 0x6e,
	0x02, 0xc8, 0x4b, 0xe7, 0x9f, 0xc4, 0x38, 0xc6, 0x79, 0x3b, 0xa6, 0x54, 0xf6, 0xa4, 0x60, 0x6d,
	0xc0, 0xb2, 0x1a, 0x17, 0xed, 0xd4, 0xe4, 0x5f, 0x37, 0x78, 0xf6, 0xee, 0xec, 0xc2, 0xae, 0x9c,
	0x5f, 0xd8, 0x95, 0xab, 0x0b, 0xdb, 0xf8, 0x90, 0xda, 0xc6, 0x97, 0xd4, 0x36, 0xbe, 0xa6, 0xb6,
	0x71, 0x96, 0xda, 0xc6, 0xb7, 0xd4, 0x36, 0xbe, 0xa7, 0x76, 0xe5, 0x2a, 0xb5, 0x8d, 0x8f, 0x97,
	0x76, 0xe5, 0xec, 0xd2, 0xae, 0x9c, 0x5f, 0xda, 0x95, 0x37, 0xfd, 0x83, 0xb0, 0xc4, 0x4f, 0xc2,
	0x79, 0x2f, 0xe9, 0x13, 0xf5, 0x63, 0xbf, 0xa6, 0x1e, 0xbf, 0x47, 0x3f, 0x03, 0x00, 0x00, 0xff,
	0xff, 0x82, 0x84, 0xbc, 0x27, 0x76, 0x05, 0x00, 0x00,
}

func (this *HistoryContinuation) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryContinuation)
	if !ok {
		that2, ok := that.(HistoryContinuation)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.FirstEventId != that1.FirstEventId {
		return false
	}
	if this.NextEventId != that1.NextEventId {
		return false
	}
	if this.IsWorkflowRunning != that1.IsWorkflowRunning {
		return false
	}
	if !bytes.Equal(this.PersistenceToken, that1.PersistenceToken) {
		return false
	}
	if !this.TransientWorkflowTask.Equal(that1.TransientWorkflowTask) {
		return false
	}
	if !bytes.Equal(this.BranchToken, that1.BranchToken) {
		return false
	}
	return true
}
func (this *RawHistoryContinuation) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RawHistoryContinuation)
	if !ok {
		that2, ok := that.(RawHistoryContinuation)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.StartEventId != that1.StartEventId {
		return false
	}
	if this.StartEventVersion != that1.StartEventVersion {
		return false
	}
	if this.EndEventId != that1.EndEventId {
		return false
	}
	if this.EndEventVersion != that1.EndEventVersion {
		return false
	}
	if !bytes.Equal(this.PersistenceToken, that1.PersistenceToken) {
		return false
	}
	if !this.VersionHistories.Equal(that1.VersionHistories) {
		return false
	}
	return true
}
func (this *Task) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Task)
	if !ok {
		that2, ok := that.(Task)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.ScheduleId != that1.ScheduleId {
		return false
	}
	if this.ScheduleAttempt != that1.ScheduleAttempt {
		return false
	}
	if this.ActivityId != that1.ActivityId {
		return false
	}
	if this.WorkflowType != that1.WorkflowType {
		return false
	}
	if this.ActivityType != that1.ActivityType {
		return false
	}
	return true
}
func (this *QueryTask) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryTask)
	if !ok {
		that2, ok := that.(QueryTask)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.TaskQueue != that1.TaskQueue {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	return true
}
func (this *HistoryContinuation) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&token.HistoryContinuation{")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "FirstEventId: "+fmt.Sprintf("%#v", this.FirstEventId)+",\n")
	s = append(s, "NextEventId: "+fmt.Sprintf("%#v", this.NextEventId)+",\n")
	s = append(s, "IsWorkflowRunning: "+fmt.Sprintf("%#v", this.IsWorkflowRunning)+",\n")
	s = append(s, "PersistenceToken: "+fmt.Sprintf("%#v", this.PersistenceToken)+",\n")
	if this.TransientWorkflowTask != nil {
		s = append(s, "TransientWorkflowTask: "+fmt.Sprintf("%#v", this.TransientWorkflowTask)+",\n")
	}
	s = append(s, "BranchToken: "+fmt.Sprintf("%#v", this.BranchToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RawHistoryContinuation) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&token.RawHistoryContinuation{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "StartEventId: "+fmt.Sprintf("%#v", this.StartEventId)+",\n")
	s = append(s, "StartEventVersion: "+fmt.Sprintf("%#v", this.StartEventVersion)+",\n")
	s = append(s, "EndEventId: "+fmt.Sprintf("%#v", this.EndEventId)+",\n")
	s = append(s, "EndEventVersion: "+fmt.Sprintf("%#v", this.EndEventVersion)+",\n")
	s = append(s, "PersistenceToken: "+fmt.Sprintf("%#v", this.PersistenceToken)+",\n")
	if this.VersionHistories != nil {
		s = append(s, "VersionHistories: "+fmt.Sprintf("%#v", this.VersionHistories)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Task) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&token.Task{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "ScheduleId: "+fmt.Sprintf("%#v", this.ScheduleId)+",\n")
	s = append(s, "ScheduleAttempt: "+fmt.Sprintf("%#v", this.ScheduleAttempt)+",\n")
	s = append(s, "ActivityId: "+fmt.Sprintf("%#v", this.ActivityId)+",\n")
	s = append(s, "WorkflowType: "+fmt.Sprintf("%#v", this.WorkflowType)+",\n")
	s = append(s, "ActivityType: "+fmt.Sprintf("%#v", this.ActivityType)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryTask) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&token.QueryTask{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringMessage(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *HistoryContinuation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryContinuation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistoryContinuation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.BranchToken) > 0 {
		i -= len(m.BranchToken)
		copy(dAtA[i:], m.BranchToken)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.BranchToken)))
		i--
		dAtA[i] = 0x42
	}
	if m.TransientWorkflowTask != nil {
		{
			size, err := m.TransientWorkflowTask.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.PersistenceToken) > 0 {
		i -= len(m.PersistenceToken)
		copy(dAtA[i:], m.PersistenceToken)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.PersistenceToken)))
		i--
		dAtA[i] = 0x32
	}
	if m.IsWorkflowRunning {
		i--
		if m.IsWorkflowRunning {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.NextEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.NextEventId))
		i--
		dAtA[i] = 0x18
	}
	if m.FirstEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.FirstEventId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawHistoryContinuation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawHistoryContinuation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawHistoryContinuation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VersionHistories != nil {
		{
			size, err := m.VersionHistories.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if len(m.PersistenceToken) > 0 {
		i -= len(m.PersistenceToken)
		copy(dAtA[i:], m.PersistenceToken)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.PersistenceToken)))
		i--
		dAtA[i] = 0x42
	}
	if m.EndEventVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.EndEventVersion))
		i--
		dAtA[i] = 0x38
	}
	if m.EndEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.EndEventId))
		i--
		dAtA[i] = 0x30
	}
	if m.StartEventVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.StartEventVersion))
		i--
		dAtA[i] = 0x28
	}
	if m.StartEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.StartEventId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Task) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Task) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Task) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ActivityType) > 0 {
		i -= len(m.ActivityType)
		copy(dAtA[i:], m.ActivityType)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ActivityType)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.WorkflowType) > 0 {
		i -= len(m.WorkflowType)
		copy(dAtA[i:], m.WorkflowType)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowType)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.ActivityId) > 0 {
		i -= len(m.ActivityId)
		copy(dAtA[i:], m.ActivityId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ActivityId)))
		i--
		dAtA[i] = 0x32
	}
	if m.ScheduleAttempt != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ScheduleAttempt))
		i--
		dAtA[i] = 0x28
	}
	if m.ScheduleId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ScheduleId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QueryTask) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryTask) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryTask) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TaskId) > 0 {
		i -= len(m.TaskId)
		copy(dAtA[i:], m.TaskId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.TaskId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.TaskQueue) > 0 {
		i -= len(m.TaskQueue)
		copy(dAtA[i:], m.TaskQueue)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.TaskQueue)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintMessage(dAtA []byte, offset int, v uint64) int {
	offset -= sovMessage(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *HistoryContinuation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.FirstEventId != 0 {
		n += 1 + sovMessage(uint64(m.FirstEventId))
	}
	if m.NextEventId != 0 {
		n += 1 + sovMessage(uint64(m.NextEventId))
	}
	if m.IsWorkflowRunning {
		n += 2
	}
	l = len(m.PersistenceToken)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.TransientWorkflowTask != nil {
		l = m.TransientWorkflowTask.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.BranchToken)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *RawHistoryContinuation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.StartEventId != 0 {
		n += 1 + sovMessage(uint64(m.StartEventId))
	}
	if m.StartEventVersion != 0 {
		n += 1 + sovMessage(uint64(m.StartEventVersion))
	}
	if m.EndEventId != 0 {
		n += 1 + sovMessage(uint64(m.EndEventId))
	}
	if m.EndEventVersion != 0 {
		n += 1 + sovMessage(uint64(m.EndEventVersion))
	}
	l = len(m.PersistenceToken)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.VersionHistories != nil {
		l = m.VersionHistories.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *Task) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ScheduleId != 0 {
		n += 1 + sovMessage(uint64(m.ScheduleId))
	}
	if m.ScheduleAttempt != 0 {
		n += 1 + sovMessage(uint64(m.ScheduleAttempt))
	}
	l = len(m.ActivityId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowType)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.ActivityType)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *QueryTask) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.TaskQueue)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.TaskId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func sovMessage(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMessage(x uint64) (n int) {
	return sovMessage(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HistoryContinuation) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HistoryContinuation{`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`FirstEventId:` + fmt.Sprintf("%v", this.FirstEventId) + `,`,
		`NextEventId:` + fmt.Sprintf("%v", this.NextEventId) + `,`,
		`IsWorkflowRunning:` + fmt.Sprintf("%v", this.IsWorkflowRunning) + `,`,
		`PersistenceToken:` + fmt.Sprintf("%v", this.PersistenceToken) + `,`,
		`TransientWorkflowTask:` + strings.Replace(fmt.Sprintf("%v", this.TransientWorkflowTask), "TransientWorkflowTaskInfo", "v1.TransientWorkflowTaskInfo", 1) + `,`,
		`BranchToken:` + fmt.Sprintf("%v", this.BranchToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RawHistoryContinuation) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RawHistoryContinuation{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`StartEventId:` + fmt.Sprintf("%v", this.StartEventId) + `,`,
		`StartEventVersion:` + fmt.Sprintf("%v", this.StartEventVersion) + `,`,
		`EndEventId:` + fmt.Sprintf("%v", this.EndEventId) + `,`,
		`EndEventVersion:` + fmt.Sprintf("%v", this.EndEventVersion) + `,`,
		`PersistenceToken:` + fmt.Sprintf("%v", this.PersistenceToken) + `,`,
		`VersionHistories:` + strings.Replace(fmt.Sprintf("%v", this.VersionHistories), "VersionHistories", "v1.VersionHistories", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Task) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Task{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`ScheduleId:` + fmt.Sprintf("%v", this.ScheduleId) + `,`,
		`ScheduleAttempt:` + fmt.Sprintf("%v", this.ScheduleAttempt) + `,`,
		`ActivityId:` + fmt.Sprintf("%v", this.ActivityId) + `,`,
		`WorkflowType:` + fmt.Sprintf("%v", this.WorkflowType) + `,`,
		`ActivityType:` + fmt.Sprintf("%v", this.ActivityType) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryTask) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryTask{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`TaskQueue:` + fmt.Sprintf("%v", this.TaskQueue) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMessage(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HistoryContinuation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryContinuation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryContinuation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstEventId", wireType)
			}
			m.FirstEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FirstEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextEventId", wireType)
			}
			m.NextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsWorkflowRunning", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsWorkflowRunning = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PersistenceToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PersistenceToken = append(m.PersistenceToken[:0], dAtA[iNdEx:postIndex]...)
			if m.PersistenceToken == nil {
				m.PersistenceToken = []byte{}
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransientWorkflowTask", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TransientWorkflowTask == nil {
				m.TransientWorkflowTask = &v1.TransientWorkflowTaskInfo{}
			}
			if err := m.TransientWorkflowTask.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BranchToken = append(m.BranchToken[:0], dAtA[iNdEx:postIndex]...)
			if m.BranchToken == nil {
				m.BranchToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawHistoryContinuation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawHistoryContinuation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawHistoryContinuation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartEventId", wireType)
			}
			m.StartEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartEventVersion", wireType)
			}
			m.StartEventVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartEventVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndEventId", wireType)
			}
			m.EndEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndEventVersion", wireType)
			}
			m.EndEventVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndEventVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PersistenceToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PersistenceToken = append(m.PersistenceToken[:0], dAtA[iNdEx:postIndex]...)
			if m.PersistenceToken == nil {
				m.PersistenceToken = []byte{}
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionHistories", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionHistories == nil {
				m.VersionHistories = &v1.VersionHistories{}
			}
			if err := m.VersionHistories.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Task) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Task: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Task: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleId", wireType)
			}
			m.ScheduleId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleAttempt", wireType)
			}
			m.ScheduleAttempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleAttempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActivityId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActivityId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActivityType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActivityType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryTask) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryTask: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryTask: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskQueue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMessage(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMessage
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMessage
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMessage
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMessage        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMessage          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMessage = fmt.Errorf("proto: unexpected end of group")
)
