// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by mockery v1.0.0. DO NOT EDIT.

package mocks

import (
	context "context"

	connector "go.temporal.io/server/common/archiver/gcloud/connector"

	mock "github.com/stretchr/testify/mock"

	storage "cloud.google.com/go/storage"
)

// BucketHandleWrapper is an autogenerated mock type for the BucketHandleWrapper type
type BucketHandleWrapper struct {
	mock.Mock
}

// Attrs provides a mock function with given fields: ctx
func (_m *BucketHandleWrapper) Attrs(ctx context.Context) (*storage.BucketAttrs, error) {
	ret := _m.Called(ctx)

	var r0 *storage.BucketAttrs
	if rf, ok := ret.Get(0).(func(context.Context) *storage.BucketAttrs); ok {
		r0 = rf(ctx)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*storage.BucketAttrs)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = rf(ctx)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Object provides a mock function with given fields: name
func (_m *BucketHandleWrapper) Object(name string) connector.ObjectHandleWrapper {
	ret := _m.Called(name)

	var r0 connector.ObjectHandleWrapper
	if rf, ok := ret.Get(0).(func(string) connector.ObjectHandleWrapper); ok {
		r0 = rf(name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(connector.ObjectHandleWrapper)
		}
	}

	return r0
}

// Objects provides a mock function with given fields: ctx, q
func (_m *BucketHandleWrapper) Objects(ctx context.Context, q *storage.Query) connector.ObjectIteratorWrapper {
	ret := _m.Called(ctx, q)

	var r0 connector.ObjectIteratorWrapper
	if rf, ok := ret.Get(0).(func(context.Context, *storage.Query) connector.ObjectIteratorWrapper); ok {
		r0 = rf(ctx, q)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(connector.ObjectIteratorWrapper)
		}
	}

	return r0
}
