Temporal Worker
==============

Temporal Worker is a role for Temporal service used for hosting any
components responsible for performing background processing on the Temporal
cluster.

Replicator
----------

Replicator is a background worker responsible for consuming replication tasks
generated by remote Temporal clusters and pass it down to processor so they
can be applied to local Temporal cluster.

It uses Kafka as the replication tasks buffer and relies on
[kafka-client library] (https://github.com/temporalio/kafka-client/) for consuming
messages from Kafka.


Quickstart for localhost development
====================================

1. Setup Kafka by following instructions:
[Kafka Quickstart](https://kafka.apache.org/quickstart)
2. Create Kafka topic for active and standby clusters if needed. By default the development Kafka should create topics in- flight (with 1 partition). If not, then use the follow command to create topics:
```
bin/kafka-topics.sh --create --zookeeper localhost:2181 --replication-factor 1 --partitions 1 --topic active
```
and 
```
bin/kafka-topics.sh --create --zookeeper localhost:2181 --replication-factor 1 --partitions 1 --topic standby
```
3. Start Temporal development server for active zone:
```
./temporal-server --zone active start
```

4. Start Temporal development server for standby(passive) zone:
```
./temporal-server --zone standby start
```

5. Create global namespaces
```
tctl --ns sample namespace register --gd true --ac active --cl active standby
```

6. Failover between zones:

Failover to standby:
```
tctl --ns sample namespace update --ac standby
```
Failback to active:
```
tctl --ns sample namespace update --ac active
```

Create replication task using CLI
---------------------------------

Kafka CLI can be used to generate a replication task for testing purpose:

```
bin/kafka-console-producer.sh --broker-list localhost:9092 --topic standby
```

Replication task message:
```
{taskType: 0}
```

Archiver
--------

Archiver is used to handle archival of workflow execution histories. It does this by hosting a temporal client worker
and running an archival system workflow. The archival client gets used to initiate archival through signal sending. The archiver
shards work across several workflows. 
