// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/persistence/v1/queue_metadata.proto

package persistence

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"

	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// data column
type QueueMetadata struct {
	ClusterAckLevels map[string]int64 `protobuf:"bytes,1,rep,name=cluster_ack_levels,json=clusterAckLevels,proto3" json:"cluster_ack_levels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (m *QueueMetadata) Reset()      { *m = QueueMetadata{} }
func (*QueueMetadata) ProtoMessage() {}
func (*QueueMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_2664d86473ff3b34, []int{0}
}
func (m *QueueMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueueMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueueMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueueMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueueMetadata.Merge(m, src)
}
func (m *QueueMetadata) XXX_Size() int {
	return m.Size()
}
func (m *QueueMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_QueueMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_QueueMetadata proto.InternalMessageInfo

func (m *QueueMetadata) GetClusterAckLevels() map[string]int64 {
	if m != nil {
		return m.ClusterAckLevels
	}
	return nil
}

func init() {
	proto.RegisterType((*QueueMetadata)(nil), "temporal.server.api.persistence.v1.QueueMetadata")
	proto.RegisterMapType((map[string]int64)(nil), "temporal.server.api.persistence.v1.QueueMetadata.ClusterAckLevelsEntry")
}

func init() {
	proto.RegisterFile("temporal/server/api/persistence/v1/queue_metadata.proto", fileDescriptor_2664d86473ff3b34)
}

var fileDescriptor_2664d86473ff3b34 = []byte{
	// 286 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0x32, 0x2f, 0x49, 0xcd, 0x2d,
	0xc8, 0x2f, 0x4a, 0xcc, 0xd1, 0x2f, 0x4e, 0x2d, 0x2a, 0x4b, 0x2d, 0xd2, 0x4f, 0x2c, 0xc8, 0xd4,
	0x2f, 0x48, 0x2d, 0x2a, 0xce, 0x2c, 0x2e, 0x49, 0xcd, 0x4b, 0x4e, 0xd5, 0x2f, 0x33, 0xd4, 0x2f,
	0x2c, 0x4d, 0x2d, 0x4d, 0x8d, 0xcf, 0x4d, 0x2d, 0x49, 0x4c, 0x49, 0x2c, 0x49, 0xd4, 0x2b, 0x28,
	0xca, 0x2f, 0xc9, 0x17, 0x52, 0x82, 0x69, 0xd4, 0x83, 0x68, 0xd4, 0x4b, 0x2c, 0xc8, 0xd4, 0x43,
	0xd2, 0xa8, 0x57, 0x66, 0xa8, 0x74, 0x9a, 0x91, 0x8b, 0x37, 0x10, 0xa4, 0xd9, 0x17, 0xaa, 0x57,
	0xa8, 0x94, 0x4b, 0x28, 0x39, 0xa7, 0xb4, 0xb8, 0x24, 0xb5, 0x28, 0x3e, 0x31, 0x39, 0x3b, 0x3e,
	0x27, 0xb5, 0x2c, 0x35, 0xa7, 0x58, 0x82, 0x51, 0x81, 0x59, 0x83, 0xdb, 0xc8, 0x5d, 0x8f, 0xb0,
	0x91, 0x7a, 0x28, 0xc6, 0xe9, 0x39, 0x43, 0xcc, 0x72, 0x4c, 0xce, 0xf6, 0x01, 0x9b, 0xe4, 0x9a,
	0x57, 0x52, 0x54, 0x19, 0x24, 0x90, 0x8c, 0x26, 0x2c, 0xe5, 0xcc, 0x25, 0x8a, 0x55, 0xa9, 0x90,
	0x00, 0x17, 0x73, 0x76, 0x6a, 0xa5, 0x04, 0xa3, 0x02, 0xa3, 0x06, 0x67, 0x10, 0x88, 0x29, 0x24,
	0xc2, 0xc5, 0x5a, 0x96, 0x98, 0x53, 0x9a, 0x2a, 0xc1, 0xa4, 0xc0, 0xa8, 0xc1, 0x1c, 0x04, 0xe1,
	0x58, 0x31, 0x59, 0x30, 0x3a, 0x65, 0x5d, 0x78, 0x28, 0xc7, 0x70, 0xe3, 0xa1, 0x1c, 0xc3, 0x87,
	0x87, 0x72, 0x8c, 0x0d, 0x8f, 0xe4, 0x18, 0x57, 0x3c, 0x92, 0x63, 0x3c, 0xf1, 0x48, 0x8e, 0xf1,
	0xc2, 0x23, 0x39, 0xc6, 0x07, 0x8f, 0xe4, 0x18, 0x5f, 0x3c, 0x92, 0x63, 0xf8, 0xf0, 0x48, 0x8e,
	0x71, 0xc2, 0x63, 0x39, 0x86, 0x0b, 0x8f, 0xe5, 0x18, 0x6e, 0x3c, 0x96, 0x63, 0x88, 0x32, 0x49,
	0xcf, 0x47, 0xf8, 0x2b, 0x33, 0x1f, 0x77, 0x30, 0x5b, 0x23, 0x71, 0x93, 0xd8, 0xc0, 0x81, 0x6c,
	0x0c, 0x08, 0x00, 0x00, 0xff, 0xff, 0x3d, 0x87, 0x8a, 0x10, 0x9f, 0x01, 0x00, 0x00,
}

func (this *QueueMetadata) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueueMetadata)
	if !ok {
		that2, ok := that.(QueueMetadata)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ClusterAckLevels) != len(that1.ClusterAckLevels) {
		return false
	}
	for i := range this.ClusterAckLevels {
		if this.ClusterAckLevels[i] != that1.ClusterAckLevels[i] {
			return false
		}
	}
	return true
}
func (this *QueueMetadata) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&persistence.QueueMetadata{")
	keysForClusterAckLevels := make([]string, 0, len(this.ClusterAckLevels))
	for k, _ := range this.ClusterAckLevels {
		keysForClusterAckLevels = append(keysForClusterAckLevels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterAckLevels)
	mapStringForClusterAckLevels := "map[string]int64{"
	for _, k := range keysForClusterAckLevels {
		mapStringForClusterAckLevels += fmt.Sprintf("%#v: %#v,", k, this.ClusterAckLevels[k])
	}
	mapStringForClusterAckLevels += "}"
	if this.ClusterAckLevels != nil {
		s = append(s, "ClusterAckLevels: "+mapStringForClusterAckLevels+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringQueueMetadata(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *QueueMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueueMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueueMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ClusterAckLevels) > 0 {
		for k := range m.ClusterAckLevels {
			v := m.ClusterAckLevels[k]
			baseI := i
			i = encodeVarintQueueMetadata(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintQueueMetadata(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintQueueMetadata(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintQueueMetadata(dAtA []byte, offset int, v uint64) int {
	offset -= sovQueueMetadata(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *QueueMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ClusterAckLevels) > 0 {
		for k, v := range m.ClusterAckLevels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovQueueMetadata(uint64(len(k))) + 1 + sovQueueMetadata(uint64(v))
			n += mapEntrySize + 1 + sovQueueMetadata(uint64(mapEntrySize))
		}
	}
	return n
}

func sovQueueMetadata(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozQueueMetadata(x uint64) (n int) {
	return sovQueueMetadata(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *QueueMetadata) String() string {
	if this == nil {
		return "nil"
	}
	keysForClusterAckLevels := make([]string, 0, len(this.ClusterAckLevels))
	for k, _ := range this.ClusterAckLevels {
		keysForClusterAckLevels = append(keysForClusterAckLevels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterAckLevels)
	mapStringForClusterAckLevels := "map[string]int64{"
	for _, k := range keysForClusterAckLevels {
		mapStringForClusterAckLevels += fmt.Sprintf("%v: %v,", k, this.ClusterAckLevels[k])
	}
	mapStringForClusterAckLevels += "}"
	s := strings.Join([]string{`&QueueMetadata{`,
		`ClusterAckLevels:` + mapStringForClusterAckLevels + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringQueueMetadata(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *QueueMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQueueMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueueMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueueMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterAckLevels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueueMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueueMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueueMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClusterAckLevels == nil {
				m.ClusterAckLevels = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowQueueMetadata
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQueueMetadata
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthQueueMetadata
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthQueueMetadata
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQueueMetadata
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipQueueMetadata(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthQueueMetadata
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ClusterAckLevels[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQueueMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQueueMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQueueMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipQueueMetadata(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowQueueMetadata
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQueueMetadata
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQueueMetadata
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthQueueMetadata
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupQueueMetadata
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthQueueMetadata
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthQueueMetadata        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowQueueMetadata          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupQueueMetadata = fmt.Errorf("proto: unexpected end of group")
)
