// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/persistence/v1/history_tree.proto

package persistence

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// branch column
type HistoryTreeInfo struct {
	BranchInfo *HistoryBranch `protobuf:"bytes,1,opt,name=branch_info,json=branchInfo,proto3" json:"branch_info,omitempty"`
	// For fork operation to prevent race condition of leaking event data when forking branches fail. Also can be used for clean up leaked data.
	ForkTime *time.Time `protobuf:"bytes,2,opt,name=fork_time,json=forkTime,proto3,stdtime" json:"fork_time,omitempty"`
	// For lookup back to workflow during debugging, also background cleanup when fork operation cannot finish self cleanup due to crash.
	Info string `protobuf:"bytes,3,opt,name=info,proto3" json:"info,omitempty"`
}

func (m *HistoryTreeInfo) Reset()      { *m = HistoryTreeInfo{} }
func (*HistoryTreeInfo) ProtoMessage() {}
func (*HistoryTreeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_fbea3422efb43fb8, []int{0}
}
func (m *HistoryTreeInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistoryTreeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistoryTreeInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistoryTreeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistoryTreeInfo.Merge(m, src)
}
func (m *HistoryTreeInfo) XXX_Size() int {
	return m.Size()
}
func (m *HistoryTreeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HistoryTreeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HistoryTreeInfo proto.InternalMessageInfo

func (m *HistoryTreeInfo) GetBranchInfo() *HistoryBranch {
	if m != nil {
		return m.BranchInfo
	}
	return nil
}

func (m *HistoryTreeInfo) GetForkTime() *time.Time {
	if m != nil {
		return m.ForkTime
	}
	return nil
}

func (m *HistoryTreeInfo) GetInfo() string {
	if m != nil {
		return m.Info
	}
	return ""
}

// For history persistence to serialize/deserialize branch details.
type HistoryBranch struct {
	TreeId    string                `protobuf:"bytes,1,opt,name=tree_id,json=treeId,proto3" json:"tree_id,omitempty"`
	BranchId  string                `protobuf:"bytes,2,opt,name=branch_id,json=branchId,proto3" json:"branch_id,omitempty"`
	Ancestors []*HistoryBranchRange `protobuf:"bytes,3,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
}

func (m *HistoryBranch) Reset()      { *m = HistoryBranch{} }
func (*HistoryBranch) ProtoMessage() {}
func (*HistoryBranch) Descriptor() ([]byte, []int) {
	return fileDescriptor_fbea3422efb43fb8, []int{1}
}
func (m *HistoryBranch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistoryBranch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistoryBranch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistoryBranch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistoryBranch.Merge(m, src)
}
func (m *HistoryBranch) XXX_Size() int {
	return m.Size()
}
func (m *HistoryBranch) XXX_DiscardUnknown() {
	xxx_messageInfo_HistoryBranch.DiscardUnknown(m)
}

var xxx_messageInfo_HistoryBranch proto.InternalMessageInfo

func (m *HistoryBranch) GetTreeId() string {
	if m != nil {
		return m.TreeId
	}
	return ""
}

func (m *HistoryBranch) GetBranchId() string {
	if m != nil {
		return m.BranchId
	}
	return ""
}

func (m *HistoryBranch) GetAncestors() []*HistoryBranchRange {
	if m != nil {
		return m.Ancestors
	}
	return nil
}

// HistoryBranchRange represents a piece of range for a branch.
type HistoryBranchRange struct {
	// BranchId of original branch forked from.
	BranchId string `protobuf:"bytes,1,opt,name=branch_id,json=branchId,proto3" json:"branch_id,omitempty"`
	// Beginning node for the range, inclusive.
	BeginNodeId int64 `protobuf:"varint,2,opt,name=begin_node_id,json=beginNodeId,proto3" json:"begin_node_id,omitempty"`
	// Ending node for the range, exclusive.
	EndNodeId int64 `protobuf:"varint,3,opt,name=end_node_id,json=endNodeId,proto3" json:"end_node_id,omitempty"`
}

func (m *HistoryBranchRange) Reset()      { *m = HistoryBranchRange{} }
func (*HistoryBranchRange) ProtoMessage() {}
func (*HistoryBranchRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_fbea3422efb43fb8, []int{2}
}
func (m *HistoryBranchRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistoryBranchRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistoryBranchRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistoryBranchRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistoryBranchRange.Merge(m, src)
}
func (m *HistoryBranchRange) XXX_Size() int {
	return m.Size()
}
func (m *HistoryBranchRange) XXX_DiscardUnknown() {
	xxx_messageInfo_HistoryBranchRange.DiscardUnknown(m)
}

var xxx_messageInfo_HistoryBranchRange proto.InternalMessageInfo

func (m *HistoryBranchRange) GetBranchId() string {
	if m != nil {
		return m.BranchId
	}
	return ""
}

func (m *HistoryBranchRange) GetBeginNodeId() int64 {
	if m != nil {
		return m.BeginNodeId
	}
	return 0
}

func (m *HistoryBranchRange) GetEndNodeId() int64 {
	if m != nil {
		return m.EndNodeId
	}
	return 0
}

func init() {
	proto.RegisterType((*HistoryTreeInfo)(nil), "temporal.server.api.persistence.v1.HistoryTreeInfo")
	proto.RegisterType((*HistoryBranch)(nil), "temporal.server.api.persistence.v1.HistoryBranch")
	proto.RegisterType((*HistoryBranchRange)(nil), "temporal.server.api.persistence.v1.HistoryBranchRange")
}

func init() {
	proto.RegisterFile("temporal/server/api/persistence/v1/history_tree.proto", fileDescriptor_fbea3422efb43fb8)
}

var fileDescriptor_fbea3422efb43fb8 = []byte{
	// 431 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x92, 0x3f, 0x8f, 0xd3, 0x30,
	0x18, 0xc6, 0x63, 0x72, 0x3a, 0x2e, 0x8e, 0x4e, 0x48, 0x5e, 0xa8, 0x8a, 0xe4, 0x2b, 0x99, 0x3a,
	0xd9, 0xea, 0xf1, 0x67, 0x41, 0x2c, 0x9d, 0xb8, 0x85, 0xc1, 0xea, 0xc4, 0x12, 0x25, 0xf1, 0x9b,
	0x9c, 0xe1, 0x6a, 0x47, 0x4e, 0xae, 0x12, 0x1b, 0x1f, 0xe1, 0x76, 0xbe, 0x00, 0x1f, 0x81, 0x8f,
	0xc0, 0xd8, 0xb1, 0x1b, 0x34, 0x5d, 0x18, 0xfb, 0x11, 0x50, 0x9c, 0x86, 0xb6, 0x20, 0x84, 0x6e,
	0xb3, 0xdf, 0x3c, 0xcf, 0xf3, 0xfe, 0x9e, 0x24, 0xf8, 0x45, 0x0d, 0xf3, 0xd2, 0xd8, 0xe4, 0x86,
	0x57, 0x60, 0x17, 0x60, 0x79, 0x52, 0x2a, 0x5e, 0x82, 0xad, 0x54, 0x55, 0x83, 0xce, 0x80, 0x2f,
	0x26, 0xfc, 0x5a, 0x55, 0xb5, 0xb1, 0x1f, 0xe3, 0xda, 0x02, 0xb0, 0xd2, 0x9a, 0xda, 0x90, 0xa8,
	0xb7, 0xb1, 0xce, 0xc6, 0x92, 0x52, 0xb1, 0x03, 0x1b, 0x5b, 0x4c, 0x86, 0x17, 0x85, 0x31, 0xc5,
	0x0d, 0x70, 0xe7, 0x48, 0x6f, 0x73, 0x5e, 0xab, 0x39, 0x54, 0x75, 0x32, 0x2f, 0xbb, 0x90, 0xe1,
	0x53, 0x09, 0x25, 0x68, 0x09, 0x3a, 0x53, 0x50, 0xf1, 0xc2, 0x14, 0xc6, 0xcd, 0xdd, 0xa9, 0x93,
	0x44, 0x5f, 0x11, 0x7e, 0xf4, 0xa6, 0x5b, 0x3f, 0xb3, 0x00, 0x57, 0x3a, 0x37, 0x44, 0xe0, 0x30,
	0xb5, 0x89, 0xce, 0xae, 0x63, 0xa5, 0x73, 0x33, 0x40, 0x23, 0x34, 0x0e, 0x2f, 0x27, 0xec, 0xff,
	0x44, 0x6c, 0x97, 0x34, 0x75, 0x6e, 0x81, 0xbb, 0x14, 0x97, 0xf9, 0x1a, 0x07, 0xb9, 0xb1, 0x1f,
	0xe2, 0x16, 0x71, 0xf0, 0xc0, 0x25, 0x0e, 0x59, 0xc7, 0xcf, 0x7a, 0x7e, 0x36, 0xeb, 0xf9, 0xa7,
	0x27, 0x77, 0xdf, 0x2f, 0x90, 0x38, 0x6b, 0x2d, 0xed, 0x90, 0x10, 0x7c, 0xe2, 0x58, 0xfc, 0x11,
	0x1a, 0x07, 0xc2, 0x9d, 0xa3, 0xcf, 0x08, 0x9f, 0x1f, 0x2d, 0x24, 0x8f, 0xf1, 0xc3, 0xf6, 0x15,
	0xc6, 0x4a, 0x3a, 0xe8, 0x40, 0x9c, 0xb6, 0xd7, 0x2b, 0x49, 0x9e, 0xe0, 0xa0, 0x6f, 0x24, 0xdd,
	0xf6, 0x40, 0x9c, 0xed, 0xe0, 0x24, 0x99, 0xe1, 0x20, 0xd1, 0x19, 0xb4, 0x41, 0xd5, 0xc0, 0x1f,
	0xf9, 0xe3, 0xf0, 0xf2, 0xe5, 0xfd, 0xcb, 0x26, 0xba, 0x00, 0xb1, 0x0f, 0x8a, 0x6e, 0x31, 0xf9,
	0x5b, 0x70, 0x0c, 0x82, 0xfe, 0x00, 0x89, 0xf0, 0x79, 0x0a, 0x85, 0xd2, 0xb1, 0x36, 0x12, 0x7a,
	0x52, 0x5f, 0x84, 0x6e, 0xf8, 0xd6, 0xc8, 0xb6, 0x09, 0xc5, 0x21, 0x68, 0xf9, 0x5b, 0xe1, 0x3b,
	0x45, 0x00, 0x5a, 0x76, 0xcf, 0xa7, 0xef, 0x97, 0x6b, 0xea, 0xad, 0xd6, 0xd4, 0xdb, 0xae, 0x29,
	0xfa, 0xd4, 0x50, 0xf4, 0xa5, 0xa1, 0xe8, 0x5b, 0x43, 0xd1, 0xb2, 0xa1, 0xe8, 0x47, 0x43, 0xd1,
	0xcf, 0x86, 0x7a, 0xdb, 0x86, 0xa2, 0xbb, 0x0d, 0xf5, 0x96, 0x1b, 0xea, 0xad, 0x36, 0xd4, 0x7b,
	0xf7, 0xbc, 0x30, 0xfb, 0xc6, 0xca, 0xfc, 0xfb, 0x57, 0x7d, 0x75, 0x70, 0x4d, 0x4f, 0xdd, 0x87,
	0x7b, 0xf6, 0x2b, 0x00, 0x00, 0xff, 0xff, 0x8b, 0x34, 0xd4, 0xd5, 0xe3, 0x02, 0x00, 0x00,
}

func (this *HistoryTreeInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryTreeInfo)
	if !ok {
		that2, ok := that.(HistoryTreeInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.BranchInfo.Equal(that1.BranchInfo) {
		return false
	}
	if that1.ForkTime == nil {
		if this.ForkTime != nil {
			return false
		}
	} else if !this.ForkTime.Equal(*that1.ForkTime) {
		return false
	}
	if this.Info != that1.Info {
		return false
	}
	return true
}
func (this *HistoryBranch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryBranch)
	if !ok {
		that2, ok := that.(HistoryBranch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TreeId != that1.TreeId {
		return false
	}
	if this.BranchId != that1.BranchId {
		return false
	}
	if len(this.Ancestors) != len(that1.Ancestors) {
		return false
	}
	for i := range this.Ancestors {
		if !this.Ancestors[i].Equal(that1.Ancestors[i]) {
			return false
		}
	}
	return true
}
func (this *HistoryBranchRange) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryBranchRange)
	if !ok {
		that2, ok := that.(HistoryBranchRange)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.BranchId != that1.BranchId {
		return false
	}
	if this.BeginNodeId != that1.BeginNodeId {
		return false
	}
	if this.EndNodeId != that1.EndNodeId {
		return false
	}
	return true
}
func (this *HistoryTreeInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&persistence.HistoryTreeInfo{")
	if this.BranchInfo != nil {
		s = append(s, "BranchInfo: "+fmt.Sprintf("%#v", this.BranchInfo)+",\n")
	}
	s = append(s, "ForkTime: "+fmt.Sprintf("%#v", this.ForkTime)+",\n")
	s = append(s, "Info: "+fmt.Sprintf("%#v", this.Info)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HistoryBranch) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&persistence.HistoryBranch{")
	s = append(s, "TreeId: "+fmt.Sprintf("%#v", this.TreeId)+",\n")
	s = append(s, "BranchId: "+fmt.Sprintf("%#v", this.BranchId)+",\n")
	if this.Ancestors != nil {
		s = append(s, "Ancestors: "+fmt.Sprintf("%#v", this.Ancestors)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HistoryBranchRange) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&persistence.HistoryBranchRange{")
	s = append(s, "BranchId: "+fmt.Sprintf("%#v", this.BranchId)+",\n")
	s = append(s, "BeginNodeId: "+fmt.Sprintf("%#v", this.BeginNodeId)+",\n")
	s = append(s, "EndNodeId: "+fmt.Sprintf("%#v", this.EndNodeId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringHistoryTree(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *HistoryTreeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryTreeInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistoryTreeInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Info) > 0 {
		i -= len(m.Info)
		copy(dAtA[i:], m.Info)
		i = encodeVarintHistoryTree(dAtA, i, uint64(len(m.Info)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ForkTime != nil {
		n1, err1 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ForkTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ForkTime):])
		if err1 != nil {
			return 0, err1
		}
		i -= n1
		i = encodeVarintHistoryTree(dAtA, i, uint64(n1))
		i--
		dAtA[i] = 0x12
	}
	if m.BranchInfo != nil {
		{
			size, err := m.BranchInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintHistoryTree(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HistoryBranch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryBranch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistoryBranch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Ancestors) > 0 {
		for iNdEx := len(m.Ancestors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ancestors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintHistoryTree(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.BranchId) > 0 {
		i -= len(m.BranchId)
		copy(dAtA[i:], m.BranchId)
		i = encodeVarintHistoryTree(dAtA, i, uint64(len(m.BranchId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.TreeId) > 0 {
		i -= len(m.TreeId)
		copy(dAtA[i:], m.TreeId)
		i = encodeVarintHistoryTree(dAtA, i, uint64(len(m.TreeId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HistoryBranchRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryBranchRange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistoryBranchRange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.EndNodeId != 0 {
		i = encodeVarintHistoryTree(dAtA, i, uint64(m.EndNodeId))
		i--
		dAtA[i] = 0x18
	}
	if m.BeginNodeId != 0 {
		i = encodeVarintHistoryTree(dAtA, i, uint64(m.BeginNodeId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.BranchId) > 0 {
		i -= len(m.BranchId)
		copy(dAtA[i:], m.BranchId)
		i = encodeVarintHistoryTree(dAtA, i, uint64(len(m.BranchId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintHistoryTree(dAtA []byte, offset int, v uint64) int {
	offset -= sovHistoryTree(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *HistoryTreeInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BranchInfo != nil {
		l = m.BranchInfo.Size()
		n += 1 + l + sovHistoryTree(uint64(l))
	}
	if m.ForkTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ForkTime)
		n += 1 + l + sovHistoryTree(uint64(l))
	}
	l = len(m.Info)
	if l > 0 {
		n += 1 + l + sovHistoryTree(uint64(l))
	}
	return n
}

func (m *HistoryBranch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TreeId)
	if l > 0 {
		n += 1 + l + sovHistoryTree(uint64(l))
	}
	l = len(m.BranchId)
	if l > 0 {
		n += 1 + l + sovHistoryTree(uint64(l))
	}
	if len(m.Ancestors) > 0 {
		for _, e := range m.Ancestors {
			l = e.Size()
			n += 1 + l + sovHistoryTree(uint64(l))
		}
	}
	return n
}

func (m *HistoryBranchRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.BranchId)
	if l > 0 {
		n += 1 + l + sovHistoryTree(uint64(l))
	}
	if m.BeginNodeId != 0 {
		n += 1 + sovHistoryTree(uint64(m.BeginNodeId))
	}
	if m.EndNodeId != 0 {
		n += 1 + sovHistoryTree(uint64(m.EndNodeId))
	}
	return n
}

func sovHistoryTree(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozHistoryTree(x uint64) (n int) {
	return sovHistoryTree(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HistoryTreeInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HistoryTreeInfo{`,
		`BranchInfo:` + strings.Replace(this.BranchInfo.String(), "HistoryBranch", "HistoryBranch", 1) + `,`,
		`ForkTime:` + strings.Replace(fmt.Sprintf("%v", this.ForkTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Info:` + fmt.Sprintf("%v", this.Info) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HistoryBranch) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForAncestors := "[]*HistoryBranchRange{"
	for _, f := range this.Ancestors {
		repeatedStringForAncestors += strings.Replace(f.String(), "HistoryBranchRange", "HistoryBranchRange", 1) + ","
	}
	repeatedStringForAncestors += "}"
	s := strings.Join([]string{`&HistoryBranch{`,
		`TreeId:` + fmt.Sprintf("%v", this.TreeId) + `,`,
		`BranchId:` + fmt.Sprintf("%v", this.BranchId) + `,`,
		`Ancestors:` + repeatedStringForAncestors + `,`,
		`}`,
	}, "")
	return s
}
func (this *HistoryBranchRange) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HistoryBranchRange{`,
		`BranchId:` + fmt.Sprintf("%v", this.BranchId) + `,`,
		`BeginNodeId:` + fmt.Sprintf("%v", this.BeginNodeId) + `,`,
		`EndNodeId:` + fmt.Sprintf("%v", this.EndNodeId) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringHistoryTree(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HistoryTreeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHistoryTree
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryTreeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryTreeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHistoryTree
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHistoryTree
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHistoryTree
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BranchInfo == nil {
				m.BranchInfo = &HistoryBranch{}
			}
			if err := m.BranchInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForkTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHistoryTree
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHistoryTree
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHistoryTree
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ForkTime == nil {
				m.ForkTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ForkTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHistoryTree
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHistoryTree
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHistoryTree
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Info = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHistoryTree(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHistoryTree
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHistoryTree
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistoryBranch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHistoryTree
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryBranch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryBranch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TreeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHistoryTree
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHistoryTree
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHistoryTree
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TreeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHistoryTree
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHistoryTree
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHistoryTree
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BranchId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ancestors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHistoryTree
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHistoryTree
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHistoryTree
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ancestors = append(m.Ancestors, &HistoryBranchRange{})
			if err := m.Ancestors[len(m.Ancestors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHistoryTree(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHistoryTree
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHistoryTree
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistoryBranchRange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHistoryTree
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryBranchRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryBranchRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHistoryTree
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHistoryTree
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHistoryTree
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BranchId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BeginNodeId", wireType)
			}
			m.BeginNodeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHistoryTree
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BeginNodeId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndNodeId", wireType)
			}
			m.EndNodeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHistoryTree
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndNodeId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipHistoryTree(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHistoryTree
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHistoryTree
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipHistoryTree(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowHistoryTree
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHistoryTree
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHistoryTree
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthHistoryTree
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupHistoryTree
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthHistoryTree
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthHistoryTree        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowHistoryTree          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupHistoryTree = fmt.Errorf("proto: unexpected end of group")
)
