// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/cli/v1/message.proto

package cli

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	v11 "go.temporal.io/api/common/v1"
	v12 "go.temporal.io/api/enums/v1"
	v1 "go.temporal.io/api/workflow/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type DescribeWorkflowExecutionResponse struct {
	ExecutionConfig       *v1.WorkflowExecutionConfig     `protobuf:"bytes,1,opt,name=execution_config,json=executionConfig,proto3" json:"execution_config,omitempty"`
	WorkflowExecutionInfo *WorkflowExecutionInfo          `protobuf:"bytes,2,opt,name=workflow_execution_info,json=workflowExecutionInfo,proto3" json:"workflow_execution_info,omitempty"`
	PendingActivities     []*PendingActivityInfo          `protobuf:"bytes,3,rep,name=pending_activities,json=pendingActivities,proto3" json:"pending_activities,omitempty"`
	PendingChildren       []*v1.PendingChildExecutionInfo `protobuf:"bytes,4,rep,name=pending_children,json=pendingChildren,proto3" json:"pending_children,omitempty"`
}

func (m *DescribeWorkflowExecutionResponse) Reset()      { *m = DescribeWorkflowExecutionResponse{} }
func (*DescribeWorkflowExecutionResponse) ProtoMessage() {}
func (*DescribeWorkflowExecutionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad471f2cfe5ee207, []int{0}
}
func (m *DescribeWorkflowExecutionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeWorkflowExecutionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeWorkflowExecutionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeWorkflowExecutionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeWorkflowExecutionResponse.Merge(m, src)
}
func (m *DescribeWorkflowExecutionResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeWorkflowExecutionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeWorkflowExecutionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeWorkflowExecutionResponse proto.InternalMessageInfo

func (m *DescribeWorkflowExecutionResponse) GetExecutionConfig() *v1.WorkflowExecutionConfig {
	if m != nil {
		return m.ExecutionConfig
	}
	return nil
}

func (m *DescribeWorkflowExecutionResponse) GetWorkflowExecutionInfo() *WorkflowExecutionInfo {
	if m != nil {
		return m.WorkflowExecutionInfo
	}
	return nil
}

func (m *DescribeWorkflowExecutionResponse) GetPendingActivities() []*PendingActivityInfo {
	if m != nil {
		return m.PendingActivities
	}
	return nil
}

func (m *DescribeWorkflowExecutionResponse) GetPendingChildren() []*v1.PendingChildExecutionInfo {
	if m != nil {
		return m.PendingChildren
	}
	return nil
}

type WorkflowExecutionInfo struct {
	Execution         *v11.WorkflowExecution      `protobuf:"bytes,1,opt,name=execution,proto3" json:"execution,omitempty"`
	Type              *v11.WorkflowType           `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	StartTime         *time.Time                  `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3,stdtime" json:"start_time,omitempty"`
	CloseTime         *time.Time                  `protobuf:"bytes,4,opt,name=close_time,json=closeTime,proto3,stdtime" json:"close_time,omitempty"`
	Status            v12.WorkflowExecutionStatus `protobuf:"varint,5,opt,name=status,proto3,enum=temporal.api.enums.v1.WorkflowExecutionStatus" json:"status,omitempty"`
	HistoryLength     int64                       `protobuf:"varint,6,opt,name=history_length,json=historyLength,proto3" json:"history_length,omitempty"`
	ParentNamespaceId string                      `protobuf:"bytes,7,opt,name=parent_namespace_id,json=parentNamespaceId,proto3" json:"parent_namespace_id,omitempty"`
	ParentExecution   *v11.WorkflowExecution      `protobuf:"bytes,8,opt,name=parent_execution,json=parentExecution,proto3" json:"parent_execution,omitempty"`
	ExecutionTime     *time.Time                  `protobuf:"bytes,9,opt,name=execution_time,json=executionTime,proto3,stdtime" json:"execution_time,omitempty"`
	Memo              *v11.Memo                   `protobuf:"bytes,10,opt,name=memo,proto3" json:"memo,omitempty"`
	SearchAttributes  *SearchAttributes           `protobuf:"bytes,11,opt,name=search_attributes,json=searchAttributes,proto3" json:"search_attributes,omitempty"`
	AutoResetPoints   *v1.ResetPoints             `protobuf:"bytes,12,opt,name=auto_reset_points,json=autoResetPoints,proto3" json:"auto_reset_points,omitempty"`
}

func (m *WorkflowExecutionInfo) Reset()      { *m = WorkflowExecutionInfo{} }
func (*WorkflowExecutionInfo) ProtoMessage() {}
func (*WorkflowExecutionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad471f2cfe5ee207, []int{1}
}
func (m *WorkflowExecutionInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WorkflowExecutionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WorkflowExecutionInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WorkflowExecutionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowExecutionInfo.Merge(m, src)
}
func (m *WorkflowExecutionInfo) XXX_Size() int {
	return m.Size()
}
func (m *WorkflowExecutionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowExecutionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowExecutionInfo proto.InternalMessageInfo

func (m *WorkflowExecutionInfo) GetExecution() *v11.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetType() *v11.WorkflowType {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetStartTime() *time.Time {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetCloseTime() *time.Time {
	if m != nil {
		return m.CloseTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetStatus() v12.WorkflowExecutionStatus {
	if m != nil {
		return m.Status
	}
	return v12.WORKFLOW_EXECUTION_STATUS_UNSPECIFIED
}

func (m *WorkflowExecutionInfo) GetHistoryLength() int64 {
	if m != nil {
		return m.HistoryLength
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetParentNamespaceId() string {
	if m != nil {
		return m.ParentNamespaceId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetParentExecution() *v11.WorkflowExecution {
	if m != nil {
		return m.ParentExecution
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetExecutionTime() *time.Time {
	if m != nil {
		return m.ExecutionTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetMemo() *v11.Memo {
	if m != nil {
		return m.Memo
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetSearchAttributes() *SearchAttributes {
	if m != nil {
		return m.SearchAttributes
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetAutoResetPoints() *v1.ResetPoints {
	if m != nil {
		return m.AutoResetPoints
	}
	return nil
}

type PendingActivityInfo struct {
	ActivityId         string                   `protobuf:"bytes,1,opt,name=activity_id,json=activityId,proto3" json:"activity_id,omitempty"`
	ActivityType       *v11.ActivityType        `protobuf:"bytes,2,opt,name=activity_type,json=activityType,proto3" json:"activity_type,omitempty"`
	State              v12.PendingActivityState `protobuf:"varint,3,opt,name=state,proto3,enum=temporal.api.enums.v1.PendingActivityState" json:"state,omitempty"`
	HeartbeatDetails   string                   `protobuf:"bytes,4,opt,name=heartbeat_details,json=heartbeatDetails,proto3" json:"heartbeat_details,omitempty"`
	LastHeartbeatTime  *time.Time               `protobuf:"bytes,5,opt,name=last_heartbeat_time,json=lastHeartbeatTime,proto3,stdtime" json:"last_heartbeat_time,omitempty"`
	LastStartedTime    *time.Time               `protobuf:"bytes,6,opt,name=last_started_time,json=lastStartedTime,proto3,stdtime" json:"last_started_time,omitempty"`
	Attempt            int32                    `protobuf:"varint,7,opt,name=attempt,proto3" json:"attempt,omitempty"`
	MaximumAttempts    int32                    `protobuf:"varint,8,opt,name=maximum_attempts,json=maximumAttempts,proto3" json:"maximum_attempts,omitempty"`
	ScheduledTime      *time.Time               `protobuf:"bytes,9,opt,name=scheduled_time,json=scheduledTime,proto3,stdtime" json:"scheduled_time,omitempty"`
	ExpirationTime     *time.Time               `protobuf:"bytes,10,opt,name=expiration_time,json=expirationTime,proto3,stdtime" json:"expiration_time,omitempty"`
	LastFailure        *Failure                 `protobuf:"bytes,11,opt,name=last_failure,json=lastFailure,proto3" json:"last_failure,omitempty"`
	LastWorkerIdentity string                   `protobuf:"bytes,12,opt,name=last_worker_identity,json=lastWorkerIdentity,proto3" json:"last_worker_identity,omitempty"`
}

func (m *PendingActivityInfo) Reset()      { *m = PendingActivityInfo{} }
func (*PendingActivityInfo) ProtoMessage() {}
func (*PendingActivityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad471f2cfe5ee207, []int{2}
}
func (m *PendingActivityInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PendingActivityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PendingActivityInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PendingActivityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PendingActivityInfo.Merge(m, src)
}
func (m *PendingActivityInfo) XXX_Size() int {
	return m.Size()
}
func (m *PendingActivityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_PendingActivityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_PendingActivityInfo proto.InternalMessageInfo

func (m *PendingActivityInfo) GetActivityId() string {
	if m != nil {
		return m.ActivityId
	}
	return ""
}

func (m *PendingActivityInfo) GetActivityType() *v11.ActivityType {
	if m != nil {
		return m.ActivityType
	}
	return nil
}

func (m *PendingActivityInfo) GetState() v12.PendingActivityState {
	if m != nil {
		return m.State
	}
	return v12.PENDING_ACTIVITY_STATE_UNSPECIFIED
}

func (m *PendingActivityInfo) GetHeartbeatDetails() string {
	if m != nil {
		return m.HeartbeatDetails
	}
	return ""
}

func (m *PendingActivityInfo) GetLastHeartbeatTime() *time.Time {
	if m != nil {
		return m.LastHeartbeatTime
	}
	return nil
}

func (m *PendingActivityInfo) GetLastStartedTime() *time.Time {
	if m != nil {
		return m.LastStartedTime
	}
	return nil
}

func (m *PendingActivityInfo) GetAttempt() int32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

func (m *PendingActivityInfo) GetMaximumAttempts() int32 {
	if m != nil {
		return m.MaximumAttempts
	}
	return 0
}

func (m *PendingActivityInfo) GetScheduledTime() *time.Time {
	if m != nil {
		return m.ScheduledTime
	}
	return nil
}

func (m *PendingActivityInfo) GetExpirationTime() *time.Time {
	if m != nil {
		return m.ExpirationTime
	}
	return nil
}

func (m *PendingActivityInfo) GetLastFailure() *Failure {
	if m != nil {
		return m.LastFailure
	}
	return nil
}

func (m *PendingActivityInfo) GetLastWorkerIdentity() string {
	if m != nil {
		return m.LastWorkerIdentity
	}
	return ""
}

type SearchAttributes struct {
	IndexedFields map[string]string `protobuf:"bytes,1,rep,name=indexed_fields,json=indexedFields,proto3" json:"indexed_fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *SearchAttributes) Reset()      { *m = SearchAttributes{} }
func (*SearchAttributes) ProtoMessage() {}
func (*SearchAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad471f2cfe5ee207, []int{3}
}
func (m *SearchAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SearchAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SearchAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SearchAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAttributes.Merge(m, src)
}
func (m *SearchAttributes) XXX_Size() int {
	return m.Size()
}
func (m *SearchAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAttributes proto.InternalMessageInfo

func (m *SearchAttributes) GetIndexedFields() map[string]string {
	if m != nil {
		return m.IndexedFields
	}
	return nil
}

type Failure struct {
	Message     string   `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	Source      string   `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	StackTrace  string   `protobuf:"bytes,3,opt,name=stack_trace,json=stackTrace,proto3" json:"stack_trace,omitempty"`
	Cause       *Failure `protobuf:"bytes,4,opt,name=cause,proto3" json:"cause,omitempty"`
	FailureType string   `protobuf:"bytes,5,opt,name=failure_type,json=failureType,proto3" json:"failure_type,omitempty"`
}

func (m *Failure) Reset()      { *m = Failure{} }
func (*Failure) ProtoMessage() {}
func (*Failure) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad471f2cfe5ee207, []int{4}
}
func (m *Failure) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Failure) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Failure.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Failure) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Failure.Merge(m, src)
}
func (m *Failure) XXX_Size() int {
	return m.Size()
}
func (m *Failure) XXX_DiscardUnknown() {
	xxx_messageInfo_Failure.DiscardUnknown(m)
}

var xxx_messageInfo_Failure proto.InternalMessageInfo

func (m *Failure) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Failure) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *Failure) GetStackTrace() string {
	if m != nil {
		return m.StackTrace
	}
	return ""
}

func (m *Failure) GetCause() *Failure {
	if m != nil {
		return m.Cause
	}
	return nil
}

func (m *Failure) GetFailureType() string {
	if m != nil {
		return m.FailureType
	}
	return ""
}

func init() {
	proto.RegisterType((*DescribeWorkflowExecutionResponse)(nil), "temporal.server.api.cli.v1.DescribeWorkflowExecutionResponse")
	proto.RegisterType((*WorkflowExecutionInfo)(nil), "temporal.server.api.cli.v1.WorkflowExecutionInfo")
	proto.RegisterType((*PendingActivityInfo)(nil), "temporal.server.api.cli.v1.PendingActivityInfo")
	proto.RegisterType((*SearchAttributes)(nil), "temporal.server.api.cli.v1.SearchAttributes")
	proto.RegisterMapType((map[string]string)(nil), "temporal.server.api.cli.v1.SearchAttributes.IndexedFieldsEntry")
	proto.RegisterType((*Failure)(nil), "temporal.server.api.cli.v1.Failure")
}

func init() {
	proto.RegisterFile("temporal/server/api/cli/v1/message.proto", fileDescriptor_ad471f2cfe5ee207)
}

var fileDescriptor_ad471f2cfe5ee207 = []byte{
	// 1107 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0xcb, 0x6e, 0xdb, 0x46,
	0x14, 0x15, 0x23, 0x4b, 0xae, 0x46, 0xb6, 0x1e, 0x93, 0xa4, 0x25, 0x8c, 0x82, 0xb1, 0x5d, 0xa7,
	0x50, 0x90, 0x82, 0x8a, 0x9d, 0x4d, 0xda, 0x2e, 0x52, 0xe7, 0xe1, 0x54, 0x40, 0x5a, 0xb8, 0xb4,
	0x81, 0xa0, 0x41, 0x11, 0x62, 0x4c, 0x5e, 0x49, 0x03, 0x93, 0x1c, 0x82, 0x33, 0x94, 0xad, 0x5d,
	0x3f, 0x21, 0x9f, 0xd1, 0x45, 0xbf, 0x20, 0xe8, 0x07, 0x74, 0xe9, 0x65, 0x76, 0xad, 0xe5, 0x2e,
	0xba, 0xcc, 0x27, 0x14, 0x33, 0x1c, 0x4a, 0x96, 0x65, 0xbb, 0xca, 0x4e, 0x73, 0xe6, 0x9c, 0x33,
	0x97, 0x77, 0xee, 0xa1, 0x88, 0x5a, 0x02, 0xc2, 0x98, 0x25, 0x24, 0x68, 0x73, 0x48, 0x06, 0x90,
	0xb4, 0x49, 0x4c, 0xdb, 0x5e, 0x40, 0xdb, 0x83, 0xcd, 0x76, 0x08, 0x9c, 0x93, 0x1e, 0xd8, 0x71,
	0xc2, 0x04, 0xc3, 0x2b, 0x39, 0xd3, 0xce, 0x98, 0x36, 0x89, 0xa9, 0xed, 0x05, 0xd4, 0x1e, 0x6c,
	0xae, 0xdc, 0xe9, 0x31, 0xd6, 0x0b, 0xa0, 0xad, 0x98, 0x07, 0x69, 0xb7, 0x2d, 0x68, 0x08, 0x5c,
	0x90, 0x30, 0xce, 0xc4, 0x2b, 0x6b, 0x3e, 0xc4, 0x10, 0xf9, 0x10, 0x79, 0x14, 0x78, 0xbb, 0xc7,
	0x7a, 0x4c, 0xe1, 0xea, 0x97, 0xa6, 0x6c, 0x8c, 0x2b, 0x51, 0x25, 0xb0, 0x30, 0x64, 0xd1, 0x4c,
	0x15, 0x17, 0x58, 0x10, 0xa5, 0x21, 0x97, 0xa4, 0x23, 0x96, 0x1c, 0x76, 0x03, 0x76, 0xa4, 0x59,
	0x5f, 0x4e, 0xb1, 0xf2, 0xcd, 0x19, 0xb7, 0xf5, 0xdf, 0x8b, 0x68, 0xed, 0x19, 0x70, 0x2f, 0xa1,
	0x07, 0xf0, 0x4a, 0xb3, 0x9e, 0x1f, 0x83, 0x97, 0x0a, 0xca, 0x22, 0x07, 0x78, 0xcc, 0x22, 0x0e,
	0xf8, 0x17, 0xd4, 0x80, 0x1c, 0x74, 0x3d, 0x16, 0x75, 0x69, 0xcf, 0x34, 0x56, 0x8d, 0x56, 0x75,
	0x6b, 0xd3, 0x1e, 0x37, 0x45, 0x76, 0x63, 0x5c, 0xc5, 0x60, 0xd3, 0x9e, 0xb1, 0x7b, 0xaa, 0x84,
	0x4e, 0x1d, 0xa6, 0x01, 0x4c, 0xd1, 0x67, 0xb9, 0xce, 0x9d, 0x1c, 0x43, 0xa3, 0x2e, 0x33, 0x6f,
	0x5c, 0x3c, 0x64, 0xa6, 0xf3, 0xb3, 0xc7, 0x74, 0xa2, 0x2e, 0x73, 0x6e, 0x1f, 0x5d, 0x06, 0xe3,
	0x37, 0x08, 0xcb, 0x5b, 0xa0, 0x51, 0xcf, 0x25, 0x9e, 0xa0, 0x03, 0x2a, 0x28, 0x70, 0xb3, 0xb8,
	0x5a, 0x6c, 0x55, 0xb7, 0xda, 0xd7, 0x9d, 0xb2, 0x9b, 0xa9, 0xb6, 0x33, 0xd1, 0x50, 0x9d, 0xd1,
	0x8c, 0xa7, 0x40, 0x0a, 0x1c, 0xbf, 0x41, 0x8d, 0xdc, 0xdf, 0xeb, 0xd3, 0xc0, 0x4f, 0x20, 0x32,
	0x17, 0x94, 0xfb, 0xc3, 0xab, 0x1b, 0xa5, 0xbd, 0x9f, 0x4a, 0xc1, 0xf4, 0x53, 0xd4, 0xe3, 0x73,
	0x5b, 0x09, 0x44, 0xeb, 0xef, 0xca, 0xe8, 0xf6, 0xa5, 0x0f, 0x8c, 0x5f, 0xa0, 0xca, 0xb8, 0x77,
	0xfa, 0x6e, 0xee, 0x4d, 0x1f, 0x99, 0x0d, 0xd4, 0xa5, 0x2d, 0x73, 0x26, 0x5a, 0xfc, 0x08, 0x2d,
	0x88, 0x61, 0x0c, 0xba, 0xf5, 0x1b, 0xff, 0xe7, 0xb1, 0x3f, 0x8c, 0xc1, 0x51, 0x0a, 0xfc, 0x18,
	0x21, 0x2e, 0x48, 0x22, 0x5c, 0x39, 0xfb, 0x66, 0x51, 0xe9, 0x57, 0xec, 0x2c, 0x18, 0x76, 0x1e,
	0x0c, 0x7b, 0x3f, 0x0f, 0xc6, 0x93, 0x85, 0xb7, 0x7f, 0xdd, 0x31, 0x9c, 0x8a, 0xd2, 0x48, 0x54,
	0x1a, 0x78, 0x01, 0xe3, 0x90, 0x19, 0x2c, 0xcc, 0x6b, 0xa0, 0x34, 0xca, 0x60, 0x07, 0x95, 0xb9,
	0x20, 0x22, 0xe5, 0x66, 0x69, 0xd5, 0x68, 0xd5, 0xb6, 0xec, 0xe9, 0xea, 0x55, 0x58, 0x2e, 0x6d,
	0xc0, 0x9e, 0x52, 0x39, 0x5a, 0x8d, 0xef, 0xa2, 0x5a, 0x9f, 0x72, 0xc1, 0x92, 0xa1, 0x1b, 0x40,
	0xd4, 0x13, 0x7d, 0xb3, 0xbc, 0x6a, 0xb4, 0x8a, 0xce, 0xb2, 0x46, 0x5f, 0x2a, 0x10, 0xdb, 0xe8,
	0x66, 0x4c, 0x12, 0x88, 0x84, 0x1b, 0x91, 0x10, 0x78, 0x4c, 0x3c, 0x70, 0xa9, 0x6f, 0x2e, 0xae,
	0x1a, 0xad, 0x8a, 0xd3, 0xcc, 0xb6, 0x7e, 0xcc, 0x77, 0x3a, 0x3e, 0xde, 0x47, 0x0d, 0xcd, 0x9f,
	0x5c, 0xd5, 0x27, 0x1f, 0x7b, 0x55, 0xf5, 0xcc, 0x62, 0x0c, 0xe0, 0x17, 0xa8, 0x36, 0x49, 0x8d,
	0xea, 0x5c, 0x65, 0xce, 0xce, 0x2d, 0x8f, 0x75, 0xaa, 0x7b, 0x0f, 0xd0, 0x42, 0x08, 0x21, 0x33,
	0x91, 0x92, 0x7f, 0x7e, 0x55, 0x49, 0x3f, 0x40, 0xc8, 0x1c, 0xc5, 0xc4, 0x3f, 0xa3, 0x26, 0x07,
	0x92, 0x78, 0x7d, 0x97, 0x08, 0x91, 0xd0, 0x83, 0x54, 0x00, 0x37, 0xab, 0x4a, 0xfe, 0xd5, 0x75,
	0x69, 0xda, 0x53, 0xa2, 0xed, 0xb1, 0xc6, 0x69, 0xf0, 0x0b, 0x08, 0xfe, 0x09, 0x35, 0x49, 0x2a,
	0x98, 0x9b, 0x00, 0x07, 0xe1, 0xc6, 0x8c, 0x46, 0x82, 0x9b, 0x4b, 0xca, 0xfa, 0xee, 0xd5, 0x51,
	0x72, 0x24, 0x7b, 0x57, 0x91, 0x9d, 0xba, 0xd4, 0x9f, 0x03, 0xd6, 0xff, 0x29, 0xa1, 0x9b, 0x97,
	0xe4, 0x18, 0xdf, 0x41, 0x55, 0xfd, 0x32, 0x18, 0xca, 0xeb, 0x33, 0xd4, 0xf5, 0xa1, 0x1c, 0xea,
	0xf8, 0xb8, 0x83, 0x96, 0xc7, 0x84, 0x79, 0xb2, 0x91, 0xbb, 0xab, 0x6c, 0x2c, 0x91, 0x73, 0x2b,
	0xbc, 0x8d, 0x4a, 0x72, 0xc6, 0xb2, 0x78, 0xd4, 0xb6, 0xee, 0x5f, 0x31, 0xa0, 0x17, 0xca, 0x94,
	0xe3, 0x09, 0x4e, 0xa6, 0xc4, 0xf7, 0x51, 0xb3, 0x0f, 0x24, 0x11, 0x07, 0x40, 0x84, 0xeb, 0x83,
	0x20, 0x34, 0xe0, 0x2a, 0x2c, 0x15, 0xa7, 0x31, 0xde, 0x78, 0x96, 0xe1, 0x78, 0x17, 0xdd, 0x0c,
	0x08, 0x17, 0xee, 0x44, 0xa1, 0x26, 0xa4, 0x34, 0xe7, 0x84, 0x34, 0xa5, 0xf8, 0xfb, 0x5c, 0xab,
	0xa6, 0xe4, 0x25, 0x52, 0xa0, 0xab, 0x62, 0x0b, 0x7e, 0xe6, 0x57, 0x9e, 0xd3, 0xaf, 0x2e, 0xa5,
	0x7b, 0x99, 0x52, 0xb9, 0x99, 0x68, 0x91, 0x08, 0xd9, 0x03, 0xa1, 0x62, 0x53, 0x72, 0xf2, 0x25,
	0xbe, 0x87, 0x1a, 0x21, 0x39, 0xa6, 0x61, 0x1a, 0xba, 0x1a, 0xe2, 0x2a, 0x2c, 0x25, 0xa7, 0xae,
	0xf1, 0x6d, 0x0d, 0xcb, 0x04, 0x70, 0xaf, 0x0f, 0x7e, 0x1a, 0xe4, 0xf5, 0xcc, 0x9d, 0x80, 0xb1,
	0x4e, 0x55, 0xd3, 0x41, 0x75, 0x38, 0x8e, 0x69, 0x42, 0x26, 0x59, 0x42, 0x73, 0x3a, 0xd5, 0x26,
	0x42, 0xfd, 0x2a, 0x5a, 0x52, 0x6d, 0xea, 0x12, 0x1a, 0xa4, 0x09, 0xe8, 0x54, 0x7c, 0x71, 0x5d,
	0x2a, 0x76, 0x32, 0xaa, 0x53, 0x95, 0x42, 0xbd, 0xc0, 0x0f, 0xd0, 0x2d, 0xe5, 0x23, 0xa7, 0x1c,
	0x12, 0x97, 0xfa, 0x10, 0x09, 0x2a, 0x86, 0x2a, 0x0a, 0x15, 0x07, 0xcb, 0xbd, 0x57, 0x6a, 0xab,
	0xa3, 0x77, 0xd6, 0xff, 0x30, 0x50, 0xe3, 0x62, 0xc0, 0x70, 0x17, 0xd5, 0x68, 0xe4, 0xc3, 0x31,
	0xf8, 0x6e, 0x97, 0x42, 0xe0, 0x73, 0xd3, 0x50, 0x7f, 0x4b, 0x8f, 0x3f, 0x26, 0xa6, 0x76, 0x27,
	0xb3, 0xd8, 0x51, 0x0e, 0xcf, 0x23, 0x91, 0x0c, 0x9d, 0x65, 0x7a, 0x1e, 0x5b, 0xf9, 0x0e, 0xe1,
	0x59, 0x12, 0x6e, 0xa0, 0xe2, 0x21, 0x0c, 0x75, 0xb2, 0xe4, 0x4f, 0x7c, 0x0b, 0x95, 0x06, 0x24,
	0x48, 0xb3, 0x28, 0x55, 0x9c, 0x6c, 0xf1, 0xcd, 0x8d, 0x47, 0xc6, 0xfa, 0x3b, 0x03, 0x2d, 0xe6,
	0x0f, 0x6f, 0xa2, 0x45, 0xfd, 0xb9, 0xa2, 0xb5, 0xf9, 0x12, 0x7f, 0x8a, 0xca, 0x9c, 0xa5, 0x89,
	0x97, 0x1b, 0xe8, 0x95, 0xcc, 0x32, 0x17, 0xc4, 0x3b, 0x74, 0x45, 0x42, 0xbc, 0x2c, 0x65, 0x15,
	0x07, 0x29, 0x68, 0x5f, 0x22, 0xf8, 0x6b, 0x54, 0xf2, 0x48, 0xca, 0xf3, 0xbf, 0x97, 0xb9, 0x2e,
	0x24, 0x53, 0xe0, 0x35, 0xb4, 0xa4, 0x6f, 0x33, 0x7b, 0x0b, 0x94, 0x94, 0x79, 0x55, 0x63, 0x32,
	0xde, 0x4f, 0x5e, 0x9f, 0x9c, 0x5a, 0x85, 0xf7, 0xa7, 0x56, 0xe1, 0xc3, 0xa9, 0x65, 0xfc, 0x3a,
	0xb2, 0x8c, 0xdf, 0x46, 0x96, 0xf1, 0xe7, 0xc8, 0x32, 0x4e, 0x46, 0x96, 0xf1, 0xf7, 0xc8, 0x32,
	0xfe, 0x1d, 0x59, 0x85, 0x0f, 0x23, 0xcb, 0x78, 0x7b, 0x66, 0x15, 0x4e, 0xce, 0xac, 0xc2, 0xfb,
	0x33, 0xab, 0xf0, 0x7a, 0xa3, 0xc7, 0x26, 0x65, 0x50, 0x36, 0xfb, 0x21, 0xfa, 0xad, 0x17, 0xd0,
	0x83, 0xb2, 0x9a, 0xbd, 0x87, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0xcb, 0x47, 0x4a, 0x2e, 0xb1,
	0x0a, 0x00, 0x00,
}

func (this *DescribeWorkflowExecutionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeWorkflowExecutionResponse)
	if !ok {
		that2, ok := that.(DescribeWorkflowExecutionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ExecutionConfig.Equal(that1.ExecutionConfig) {
		return false
	}
	if !this.WorkflowExecutionInfo.Equal(that1.WorkflowExecutionInfo) {
		return false
	}
	if len(this.PendingActivities) != len(that1.PendingActivities) {
		return false
	}
	for i := range this.PendingActivities {
		if !this.PendingActivities[i].Equal(that1.PendingActivities[i]) {
			return false
		}
	}
	if len(this.PendingChildren) != len(that1.PendingChildren) {
		return false
	}
	for i := range this.PendingChildren {
		if !this.PendingChildren[i].Equal(that1.PendingChildren[i]) {
			return false
		}
	}
	return true
}
func (this *WorkflowExecutionInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WorkflowExecutionInfo)
	if !ok {
		that2, ok := that.(WorkflowExecutionInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	if !this.Type.Equal(that1.Type) {
		return false
	}
	if that1.StartTime == nil {
		if this.StartTime != nil {
			return false
		}
	} else if !this.StartTime.Equal(*that1.StartTime) {
		return false
	}
	if that1.CloseTime == nil {
		if this.CloseTime != nil {
			return false
		}
	} else if !this.CloseTime.Equal(*that1.CloseTime) {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.HistoryLength != that1.HistoryLength {
		return false
	}
	if this.ParentNamespaceId != that1.ParentNamespaceId {
		return false
	}
	if !this.ParentExecution.Equal(that1.ParentExecution) {
		return false
	}
	if that1.ExecutionTime == nil {
		if this.ExecutionTime != nil {
			return false
		}
	} else if !this.ExecutionTime.Equal(*that1.ExecutionTime) {
		return false
	}
	if !this.Memo.Equal(that1.Memo) {
		return false
	}
	if !this.SearchAttributes.Equal(that1.SearchAttributes) {
		return false
	}
	if !this.AutoResetPoints.Equal(that1.AutoResetPoints) {
		return false
	}
	return true
}
func (this *PendingActivityInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PendingActivityInfo)
	if !ok {
		that2, ok := that.(PendingActivityInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ActivityId != that1.ActivityId {
		return false
	}
	if !this.ActivityType.Equal(that1.ActivityType) {
		return false
	}
	if this.State != that1.State {
		return false
	}
	if this.HeartbeatDetails != that1.HeartbeatDetails {
		return false
	}
	if that1.LastHeartbeatTime == nil {
		if this.LastHeartbeatTime != nil {
			return false
		}
	} else if !this.LastHeartbeatTime.Equal(*that1.LastHeartbeatTime) {
		return false
	}
	if that1.LastStartedTime == nil {
		if this.LastStartedTime != nil {
			return false
		}
	} else if !this.LastStartedTime.Equal(*that1.LastStartedTime) {
		return false
	}
	if this.Attempt != that1.Attempt {
		return false
	}
	if this.MaximumAttempts != that1.MaximumAttempts {
		return false
	}
	if that1.ScheduledTime == nil {
		if this.ScheduledTime != nil {
			return false
		}
	} else if !this.ScheduledTime.Equal(*that1.ScheduledTime) {
		return false
	}
	if that1.ExpirationTime == nil {
		if this.ExpirationTime != nil {
			return false
		}
	} else if !this.ExpirationTime.Equal(*that1.ExpirationTime) {
		return false
	}
	if !this.LastFailure.Equal(that1.LastFailure) {
		return false
	}
	if this.LastWorkerIdentity != that1.LastWorkerIdentity {
		return false
	}
	return true
}
func (this *SearchAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SearchAttributes)
	if !ok {
		that2, ok := that.(SearchAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.IndexedFields) != len(that1.IndexedFields) {
		return false
	}
	for i := range this.IndexedFields {
		if this.IndexedFields[i] != that1.IndexedFields[i] {
			return false
		}
	}
	return true
}
func (this *Failure) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Failure)
	if !ok {
		that2, ok := that.(Failure)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	if this.Source != that1.Source {
		return false
	}
	if this.StackTrace != that1.StackTrace {
		return false
	}
	if !this.Cause.Equal(that1.Cause) {
		return false
	}
	if this.FailureType != that1.FailureType {
		return false
	}
	return true
}
func (this *DescribeWorkflowExecutionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&cli.DescribeWorkflowExecutionResponse{")
	if this.ExecutionConfig != nil {
		s = append(s, "ExecutionConfig: "+fmt.Sprintf("%#v", this.ExecutionConfig)+",\n")
	}
	if this.WorkflowExecutionInfo != nil {
		s = append(s, "WorkflowExecutionInfo: "+fmt.Sprintf("%#v", this.WorkflowExecutionInfo)+",\n")
	}
	if this.PendingActivities != nil {
		s = append(s, "PendingActivities: "+fmt.Sprintf("%#v", this.PendingActivities)+",\n")
	}
	if this.PendingChildren != nil {
		s = append(s, "PendingChildren: "+fmt.Sprintf("%#v", this.PendingChildren)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WorkflowExecutionInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 16)
	s = append(s, "&cli.WorkflowExecutionInfo{")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	if this.Type != nil {
		s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	}
	s = append(s, "StartTime: "+fmt.Sprintf("%#v", this.StartTime)+",\n")
	s = append(s, "CloseTime: "+fmt.Sprintf("%#v", this.CloseTime)+",\n")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	s = append(s, "HistoryLength: "+fmt.Sprintf("%#v", this.HistoryLength)+",\n")
	s = append(s, "ParentNamespaceId: "+fmt.Sprintf("%#v", this.ParentNamespaceId)+",\n")
	if this.ParentExecution != nil {
		s = append(s, "ParentExecution: "+fmt.Sprintf("%#v", this.ParentExecution)+",\n")
	}
	s = append(s, "ExecutionTime: "+fmt.Sprintf("%#v", this.ExecutionTime)+",\n")
	if this.Memo != nil {
		s = append(s, "Memo: "+fmt.Sprintf("%#v", this.Memo)+",\n")
	}
	if this.SearchAttributes != nil {
		s = append(s, "SearchAttributes: "+fmt.Sprintf("%#v", this.SearchAttributes)+",\n")
	}
	if this.AutoResetPoints != nil {
		s = append(s, "AutoResetPoints: "+fmt.Sprintf("%#v", this.AutoResetPoints)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PendingActivityInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 16)
	s = append(s, "&cli.PendingActivityInfo{")
	s = append(s, "ActivityId: "+fmt.Sprintf("%#v", this.ActivityId)+",\n")
	if this.ActivityType != nil {
		s = append(s, "ActivityType: "+fmt.Sprintf("%#v", this.ActivityType)+",\n")
	}
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "HeartbeatDetails: "+fmt.Sprintf("%#v", this.HeartbeatDetails)+",\n")
	s = append(s, "LastHeartbeatTime: "+fmt.Sprintf("%#v", this.LastHeartbeatTime)+",\n")
	s = append(s, "LastStartedTime: "+fmt.Sprintf("%#v", this.LastStartedTime)+",\n")
	s = append(s, "Attempt: "+fmt.Sprintf("%#v", this.Attempt)+",\n")
	s = append(s, "MaximumAttempts: "+fmt.Sprintf("%#v", this.MaximumAttempts)+",\n")
	s = append(s, "ScheduledTime: "+fmt.Sprintf("%#v", this.ScheduledTime)+",\n")
	s = append(s, "ExpirationTime: "+fmt.Sprintf("%#v", this.ExpirationTime)+",\n")
	if this.LastFailure != nil {
		s = append(s, "LastFailure: "+fmt.Sprintf("%#v", this.LastFailure)+",\n")
	}
	s = append(s, "LastWorkerIdentity: "+fmt.Sprintf("%#v", this.LastWorkerIdentity)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SearchAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&cli.SearchAttributes{")
	keysForIndexedFields := make([]string, 0, len(this.IndexedFields))
	for k, _ := range this.IndexedFields {
		keysForIndexedFields = append(keysForIndexedFields, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForIndexedFields)
	mapStringForIndexedFields := "map[string]string{"
	for _, k := range keysForIndexedFields {
		mapStringForIndexedFields += fmt.Sprintf("%#v: %#v,", k, this.IndexedFields[k])
	}
	mapStringForIndexedFields += "}"
	if this.IndexedFields != nil {
		s = append(s, "IndexedFields: "+mapStringForIndexedFields+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Failure) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&cli.Failure{")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "Source: "+fmt.Sprintf("%#v", this.Source)+",\n")
	s = append(s, "StackTrace: "+fmt.Sprintf("%#v", this.StackTrace)+",\n")
	if this.Cause != nil {
		s = append(s, "Cause: "+fmt.Sprintf("%#v", this.Cause)+",\n")
	}
	s = append(s, "FailureType: "+fmt.Sprintf("%#v", this.FailureType)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringMessage(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *DescribeWorkflowExecutionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeWorkflowExecutionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeWorkflowExecutionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PendingChildren) > 0 {
		for iNdEx := len(m.PendingChildren) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PendingChildren[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMessage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.PendingActivities) > 0 {
		for iNdEx := len(m.PendingActivities) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PendingActivities[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMessage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.WorkflowExecutionInfo != nil {
		{
			size, err := m.WorkflowExecutionInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ExecutionConfig != nil {
		{
			size, err := m.ExecutionConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WorkflowExecutionInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WorkflowExecutionInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WorkflowExecutionInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AutoResetPoints != nil {
		{
			size, err := m.AutoResetPoints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.SearchAttributes != nil {
		{
			size, err := m.SearchAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.Memo != nil {
		{
			size, err := m.Memo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.ExecutionTime != nil {
		n6, err6 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ExecutionTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExecutionTime):])
		if err6 != nil {
			return 0, err6
		}
		i -= n6
		i = encodeVarintMessage(dAtA, i, uint64(n6))
		i--
		dAtA[i] = 0x4a
	}
	if m.ParentExecution != nil {
		{
			size, err := m.ParentExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.ParentNamespaceId) > 0 {
		i -= len(m.ParentNamespaceId)
		copy(dAtA[i:], m.ParentNamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ParentNamespaceId)))
		i--
		dAtA[i] = 0x3a
	}
	if m.HistoryLength != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.HistoryLength))
		i--
		dAtA[i] = 0x30
	}
	if m.Status != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x28
	}
	if m.CloseTime != nil {
		n8, err8 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.CloseTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.CloseTime):])
		if err8 != nil {
			return 0, err8
		}
		i -= n8
		i = encodeVarintMessage(dAtA, i, uint64(n8))
		i--
		dAtA[i] = 0x22
	}
	if m.StartTime != nil {
		n9, err9 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartTime):])
		if err9 != nil {
			return 0, err9
		}
		i -= n9
		i = encodeVarintMessage(dAtA, i, uint64(n9))
		i--
		dAtA[i] = 0x1a
	}
	if m.Type != nil {
		{
			size, err := m.Type.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PendingActivityInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PendingActivityInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PendingActivityInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LastWorkerIdentity) > 0 {
		i -= len(m.LastWorkerIdentity)
		copy(dAtA[i:], m.LastWorkerIdentity)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.LastWorkerIdentity)))
		i--
		dAtA[i] = 0x62
	}
	if m.LastFailure != nil {
		{
			size, err := m.LastFailure.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.ExpirationTime != nil {
		n13, err13 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ExpirationTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExpirationTime):])
		if err13 != nil {
			return 0, err13
		}
		i -= n13
		i = encodeVarintMessage(dAtA, i, uint64(n13))
		i--
		dAtA[i] = 0x52
	}
	if m.ScheduledTime != nil {
		n14, err14 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime):])
		if err14 != nil {
			return 0, err14
		}
		i -= n14
		i = encodeVarintMessage(dAtA, i, uint64(n14))
		i--
		dAtA[i] = 0x4a
	}
	if m.MaximumAttempts != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.MaximumAttempts))
		i--
		dAtA[i] = 0x40
	}
	if m.Attempt != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x38
	}
	if m.LastStartedTime != nil {
		n15, err15 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.LastStartedTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastStartedTime):])
		if err15 != nil {
			return 0, err15
		}
		i -= n15
		i = encodeVarintMessage(dAtA, i, uint64(n15))
		i--
		dAtA[i] = 0x32
	}
	if m.LastHeartbeatTime != nil {
		n16, err16 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.LastHeartbeatTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbeatTime):])
		if err16 != nil {
			return 0, err16
		}
		i -= n16
		i = encodeVarintMessage(dAtA, i, uint64(n16))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.HeartbeatDetails) > 0 {
		i -= len(m.HeartbeatDetails)
		copy(dAtA[i:], m.HeartbeatDetails)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.HeartbeatDetails)))
		i--
		dAtA[i] = 0x22
	}
	if m.State != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x18
	}
	if m.ActivityType != nil {
		{
			size, err := m.ActivityType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ActivityId) > 0 {
		i -= len(m.ActivityId)
		copy(dAtA[i:], m.ActivityId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ActivityId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SearchAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SearchAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SearchAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.IndexedFields) > 0 {
		for k := range m.IndexedFields {
			v := m.IndexedFields[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintMessage(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Failure) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Failure) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Failure) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.FailureType) > 0 {
		i -= len(m.FailureType)
		copy(dAtA[i:], m.FailureType)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.FailureType)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Cause != nil {
		{
			size, err := m.Cause.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.StackTrace) > 0 {
		i -= len(m.StackTrace)
		copy(dAtA[i:], m.StackTrace)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.StackTrace)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Source) > 0 {
		i -= len(m.Source)
		copy(dAtA[i:], m.Source)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Source)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintMessage(dAtA []byte, offset int, v uint64) int {
	offset -= sovMessage(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *DescribeWorkflowExecutionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExecutionConfig != nil {
		l = m.ExecutionConfig.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.WorkflowExecutionInfo != nil {
		l = m.WorkflowExecutionInfo.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if len(m.PendingActivities) > 0 {
		for _, e := range m.PendingActivities {
			l = e.Size()
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	if len(m.PendingChildren) > 0 {
		for _, e := range m.PendingChildren {
			l = e.Size()
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	return n
}

func (m *WorkflowExecutionInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Type != nil {
		l = m.Type.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.StartTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.CloseTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.CloseTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovMessage(uint64(m.Status))
	}
	if m.HistoryLength != 0 {
		n += 1 + sovMessage(uint64(m.HistoryLength))
	}
	l = len(m.ParentNamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ParentExecution != nil {
		l = m.ParentExecution.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ExecutionTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExecutionTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Memo != nil {
		l = m.Memo.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.SearchAttributes != nil {
		l = m.SearchAttributes.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.AutoResetPoints != nil {
		l = m.AutoResetPoints.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *PendingActivityInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ActivityId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ActivityType != nil {
		l = m.ActivityType.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovMessage(uint64(m.State))
	}
	l = len(m.HeartbeatDetails)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.LastHeartbeatTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbeatTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.LastStartedTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastStartedTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Attempt != 0 {
		n += 1 + sovMessage(uint64(m.Attempt))
	}
	if m.MaximumAttempts != 0 {
		n += 1 + sovMessage(uint64(m.MaximumAttempts))
	}
	if m.ScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ExpirationTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExpirationTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.LastFailure != nil {
		l = m.LastFailure.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.LastWorkerIdentity)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *SearchAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.IndexedFields) > 0 {
		for k, v := range m.IndexedFields {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + 1 + len(v) + sovMessage(uint64(len(v)))
			n += mapEntrySize + 1 + sovMessage(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Failure) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.StackTrace)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Cause != nil {
		l = m.Cause.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.FailureType)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func sovMessage(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMessage(x uint64) (n int) {
	return sovMessage(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *DescribeWorkflowExecutionResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForPendingActivities := "[]*PendingActivityInfo{"
	for _, f := range this.PendingActivities {
		repeatedStringForPendingActivities += strings.Replace(f.String(), "PendingActivityInfo", "PendingActivityInfo", 1) + ","
	}
	repeatedStringForPendingActivities += "}"
	repeatedStringForPendingChildren := "[]*PendingChildExecutionInfo{"
	for _, f := range this.PendingChildren {
		repeatedStringForPendingChildren += strings.Replace(fmt.Sprintf("%v", f), "PendingChildExecutionInfo", "v1.PendingChildExecutionInfo", 1) + ","
	}
	repeatedStringForPendingChildren += "}"
	s := strings.Join([]string{`&DescribeWorkflowExecutionResponse{`,
		`ExecutionConfig:` + strings.Replace(fmt.Sprintf("%v", this.ExecutionConfig), "WorkflowExecutionConfig", "v1.WorkflowExecutionConfig", 1) + `,`,
		`WorkflowExecutionInfo:` + strings.Replace(this.WorkflowExecutionInfo.String(), "WorkflowExecutionInfo", "WorkflowExecutionInfo", 1) + `,`,
		`PendingActivities:` + repeatedStringForPendingActivities + `,`,
		`PendingChildren:` + repeatedStringForPendingChildren + `,`,
		`}`,
	}, "")
	return s
}
func (this *WorkflowExecutionInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WorkflowExecutionInfo{`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v11.WorkflowExecution", 1) + `,`,
		`Type:` + strings.Replace(fmt.Sprintf("%v", this.Type), "WorkflowType", "v11.WorkflowType", 1) + `,`,
		`StartTime:` + strings.Replace(fmt.Sprintf("%v", this.StartTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`CloseTime:` + strings.Replace(fmt.Sprintf("%v", this.CloseTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`HistoryLength:` + fmt.Sprintf("%v", this.HistoryLength) + `,`,
		`ParentNamespaceId:` + fmt.Sprintf("%v", this.ParentNamespaceId) + `,`,
		`ParentExecution:` + strings.Replace(fmt.Sprintf("%v", this.ParentExecution), "WorkflowExecution", "v11.WorkflowExecution", 1) + `,`,
		`ExecutionTime:` + strings.Replace(fmt.Sprintf("%v", this.ExecutionTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Memo:` + strings.Replace(fmt.Sprintf("%v", this.Memo), "Memo", "v11.Memo", 1) + `,`,
		`SearchAttributes:` + strings.Replace(this.SearchAttributes.String(), "SearchAttributes", "SearchAttributes", 1) + `,`,
		`AutoResetPoints:` + strings.Replace(fmt.Sprintf("%v", this.AutoResetPoints), "ResetPoints", "v1.ResetPoints", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PendingActivityInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PendingActivityInfo{`,
		`ActivityId:` + fmt.Sprintf("%v", this.ActivityId) + `,`,
		`ActivityType:` + strings.Replace(fmt.Sprintf("%v", this.ActivityType), "ActivityType", "v11.ActivityType", 1) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`HeartbeatDetails:` + fmt.Sprintf("%v", this.HeartbeatDetails) + `,`,
		`LastHeartbeatTime:` + strings.Replace(fmt.Sprintf("%v", this.LastHeartbeatTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`LastStartedTime:` + strings.Replace(fmt.Sprintf("%v", this.LastStartedTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`MaximumAttempts:` + fmt.Sprintf("%v", this.MaximumAttempts) + `,`,
		`ScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.ScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`ExpirationTime:` + strings.Replace(fmt.Sprintf("%v", this.ExpirationTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`LastFailure:` + strings.Replace(this.LastFailure.String(), "Failure", "Failure", 1) + `,`,
		`LastWorkerIdentity:` + fmt.Sprintf("%v", this.LastWorkerIdentity) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SearchAttributes) String() string {
	if this == nil {
		return "nil"
	}
	keysForIndexedFields := make([]string, 0, len(this.IndexedFields))
	for k, _ := range this.IndexedFields {
		keysForIndexedFields = append(keysForIndexedFields, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForIndexedFields)
	mapStringForIndexedFields := "map[string]string{"
	for _, k := range keysForIndexedFields {
		mapStringForIndexedFields += fmt.Sprintf("%v: %v,", k, this.IndexedFields[k])
	}
	mapStringForIndexedFields += "}"
	s := strings.Join([]string{`&SearchAttributes{`,
		`IndexedFields:` + mapStringForIndexedFields + `,`,
		`}`,
	}, "")
	return s
}
func (this *Failure) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Failure{`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`Source:` + fmt.Sprintf("%v", this.Source) + `,`,
		`StackTrace:` + fmt.Sprintf("%v", this.StackTrace) + `,`,
		`Cause:` + strings.Replace(this.Cause.String(), "Failure", "Failure", 1) + `,`,
		`FailureType:` + fmt.Sprintf("%v", this.FailureType) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMessage(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *DescribeWorkflowExecutionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeWorkflowExecutionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeWorkflowExecutionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutionConfig == nil {
				m.ExecutionConfig = &v1.WorkflowExecutionConfig{}
			}
			if err := m.ExecutionConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecutionInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecutionInfo == nil {
				m.WorkflowExecutionInfo = &WorkflowExecutionInfo{}
			}
			if err := m.WorkflowExecutionInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingActivities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PendingActivities = append(m.PendingActivities, &PendingActivityInfo{})
			if err := m.PendingActivities[len(m.PendingActivities)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingChildren", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PendingChildren = append(m.PendingChildren, &v1.PendingChildExecutionInfo{})
			if err := m.PendingChildren[len(m.PendingChildren)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WorkflowExecutionInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WorkflowExecutionInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WorkflowExecutionInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v11.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Type == nil {
				m.Type = &v11.WorkflowType{}
			}
			if err := m.Type.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartTime == nil {
				m.StartTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloseTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CloseTime == nil {
				m.CloseTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.CloseTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= v12.WorkflowExecutionStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryLength", wireType)
			}
			m.HistoryLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HistoryLength |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentNamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentNamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ParentExecution == nil {
				m.ParentExecution = &v11.WorkflowExecution{}
			}
			if err := m.ParentExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutionTime == nil {
				m.ExecutionTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ExecutionTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Memo == nil {
				m.Memo = &v11.Memo{}
			}
			if err := m.Memo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SearchAttributes == nil {
				m.SearchAttributes = &SearchAttributes{}
			}
			if err := m.SearchAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AutoResetPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AutoResetPoints == nil {
				m.AutoResetPoints = &v1.ResetPoints{}
			}
			if err := m.AutoResetPoints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PendingActivityInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PendingActivityInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PendingActivityInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActivityId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActivityId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActivityType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ActivityType == nil {
				m.ActivityType = &v11.ActivityType{}
			}
			if err := m.ActivityType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= v12.PendingActivityState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatDetails", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeartbeatDetails = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeatTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastHeartbeatTime == nil {
				m.LastHeartbeatTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.LastHeartbeatTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastStartedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastStartedTime == nil {
				m.LastStartedTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.LastStartedTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumAttempts", wireType)
			}
			m.MaximumAttempts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaximumAttempts |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduledTime == nil {
				m.ScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpirationTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpirationTime == nil {
				m.ExpirationTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ExpirationTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastFailure", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastFailure == nil {
				m.LastFailure = &Failure{}
			}
			if err := m.LastFailure.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastWorkerIdentity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastWorkerIdentity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SearchAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SearchAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SearchAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexedFields", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IndexedFields == nil {
				m.IndexedFields = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.IndexedFields[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Failure) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Failure: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Failure: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StackTrace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StackTrace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cause", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cause == nil {
				m.Cause = &Failure{}
			}
			if err := m.Cause.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailureType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FailureType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMessage(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMessage
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMessage
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMessage
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMessage        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMessage          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMessage = fmt.Errorf("proto: unexpected end of group")
)
