// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/historyservice/v1/service.proto

package historyservice

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

func init() {
	proto.RegisterFile("temporal/server/api/historyservice/v1/service.proto", fileDescriptor_655983da427ae822)
}

var fileDescriptor_655983da427ae822 = []byte{
	// 1034 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x99, 0xcd, 0x8b, 0x23, 0x45,
	0x18, 0x87, 0x53, 0x17, 0x0f, 0x85, 0xae, 0xda, 0x8a, 0x1f, 0xa3, 0x36, 0x22, 0x78, 0x4d, 0xd8,
	0xdd, 0xcb, 0x7e, 0xcc, 0xba, 0xee, 0x64, 0x66, 0x32, 0xb3, 0x3b, 0xa3, 0x4e, 0xb2, 0x28, 0x78,
	0x91, 0x9a, 0xce, 0xbb, 0x93, 0x62, 0x7a, 0x52, 0x6d, 0x55, 0x25, 0x9a, 0x9b, 0xe0, 0x49, 0x58,
	0x50, 0x04, 0xc1, 0x93, 0xe0, 0x49, 0x11, 0x04, 0x41, 0x10, 0x04, 0xc1, 0x93, 0xe0, 0x71, 0x8e,
	0x7b, 0x74, 0x32, 0x17, 0x8f, 0xfb, 0x27, 0x2c, 0x49, 0xa7, 0x6a, 0x52, 0xdd, 0xd5, 0xa1, 0xaa,
	0x92, 0xdb, 0x6e, 0xa6, 0x7e, 0x4f, 0x3f, 0x5d, 0x5f, 0x6f, 0xa5, 0x82, 0xaf, 0x4a, 0x38, 0xc9,
	0x18, 0x27, 0x69, 0x43, 0x00, 0x1f, 0x02, 0x6f, 0x90, 0x8c, 0x36, 0x7a, 0x54, 0x48, 0xc6, 0x47,
	0x93, 0x4f, 0x68, 0x02, 0x8d, 0xe1, 0xe5, 0xc6, 0xec, 0x9f, 0xf5, 0x8c, 0x33, 0xc9, 0xa2, 0xb7,
	0x55, 0xa8, 0x9e, 0x87, 0xea, 0x24, 0xa3, 0x75, 0x33, 0x54, 0x1f, 0x5e, 0x5e, 0x5b, 0x77, 0x63,
	0x73, 0xf8, 0x74, 0x00, 0x42, 0x7e, 0xc2, 0x41, 0x64, 0xac, 0x2f, 0x66, 0x0f, 0xb9, 0xf2, 0xb0,
	0x81, 0x2f, 0xed, 0xe4, 0x8d, 0x3b, 0x79, 0xe3, 0xe8, 0x27, 0x84, 0x5f, 0xea, 0x48, 0xc2, 0xe5,
	0x47, 0x8c, 0x1f, 0x3f, 0x48, 0xd9, 0x67, 0x5b, 0x9f, 0x43, 0x32, 0x90, 0x94, 0xf5, 0xa3, 0xcd,
	0xba, 0x93, 0x53, 0xdd, 0x1e, 0x6f, 0xe7, 0x0a, 0x6b, 0x5b, 0x4b, 0x52, 0xf2, 0x17, 0x78, 0xab,
	0x16, 0x7d, 0x8b, 0xf0, 0xb3, 0x2d, 0x90, 0xfb, 0x03, 0x49, 0x0e, 0x53, 0xe8, 0x48, 0x22, 0x21,
	0xba, 0xe5, 0x08, 0x2f, 0xe4, 0x94, 0xdb, 0x3b, 0xa1, 0x71, 0x2d, 0xf5, 0x1d, 0xc2, 0xcf, 0x7d,
	0xc0, 0xd2, 0xd4, 0xb0, 0x72, 0xc5, 0x16, 0x83, 0x4a, 0xeb, 0x76, 0x70, 0x5e, 0x7b, 0xfd, 0x88,
	0xf0, 0x8b, 0x6d, 0x10, 0x20, 0x3b, 0x92, 0x26, 0xc7, 0xa3, 0xfb, 0x44, 0x1c, 0x1f, 0x0c, 0x60,
	0x00, 0xd1, 0x86, 0x23, 0xdb, 0x16, 0x56, 0x7e, 0xcd, 0xa5, 0x18, 0xda, 0xf1, 0x37, 0x84, 0x5f,
	0x6d, 0x43, 0xc2, 0x78, 0x57, 0x0d, 0xfb, 0xa4, 0xd5, 0x74, 0x1e, 0x40, 0x37, 0x6a, 0x39, 0x3f,
	0xa4, 0x82, 0xa0, 0x6c, 0x77, 0x96, 0x07, 0x59, 0x94, 0xef, 0x24, 0x92, 0x0e, 0xa9, 0x1c, 0x85,
	0x2b, 0x5b, 0x08, 0x61, 0xca, 0x56, 0x90, 0x56, 0xfe, 0x13, 0xe1, 0xd7, 0xf3, 0xff, 0x1a, 0xef,
	0xd6, 0x64, 0x27, 0x59, 0x0a, 0x13, 0xeb, 0xbb, 0xee, 0xa3, 0x59, 0x09, 0x51, 0xe2, 0xf7, 0x56,
	0xc2, 0x2a, 0x74, 0x77, 0xa9, 0xe9, 0x36, 0xa1, 0xa9, 0x57, 0x77, 0x57, 0x10, 0xfc, 0xbb, 0xbb,
	0x12, 0xa4, 0x95, 0xff, 0x40, 0xf8, 0xb5, 0xf2, 0xb0, 0xec, 0x00, 0xe1, 0xf2, 0x10, 0x88, 0x8c,
	0x76, 0x83, 0x87, 0x56, 0x33, 0x94, 0xf6, 0xdd, 0x55, 0xa0, 0x6c, 0xf3, 0x64, 0xbe, 0x69, 0xf0,
	0x3c, 0xb1, 0x42, 0x02, 0xe7, 0x49, 0x05, 0xcb, 0x36, 0x4f, 0xe6, 0x9b, 0x86, 0xcd, 0x93, 0x32,
	0x21, 0x70, 0x9e, 0xd8, 0x40, 0x85, 0x79, 0x52, 0x7e, 0x3b, 0xd2, 0x4f, 0x60, 0x22, 0xbd, 0xbb,
	0x44, 0x0f, 0xcd, 0x18, 0xfe, 0xf3, 0x64, 0x01, 0x4a, 0x8b, 0xff, 0x82, 0xf0, 0xcb, 0x1d, 0x7a,
	0xd4, 0x27, 0x69, 0xf9, 0xc4, 0xe0, 0x5c, 0xeb, 0xed, 0x79, 0x25, 0xbc, 0xbd, 0x2c, 0x46, 0xcb,
	0xfe, 0x83, 0xf0, 0x9b, 0xb3, 0x56, 0x54, 0xf6, 0x2a, 0xce, 0x39, 0xef, 0xf9, 0x3d, 0xae, 0x12,
	0xa4, 0xf4, 0xdf, 0x5f, 0x19, 0x4f, 0xbf, 0xc7, 0xaf, 0x08, 0xbf, 0xd2, 0x86, 0x13, 0x36, 0x84,
	0x3c, 0x64, 0x1c, 0x37, 0xb6, 0x9d, 0xc7, 0xd7, 0x0e, 0x50, 0xde, 0xad, 0xa5, 0x39, 0xda, 0xf7,
	0x77, 0x84, 0xd7, 0xee, 0x03, 0x3f, 0xa1, 0x7d, 0x22, 0xa1, 0xdc, 0xe3, 0xae, 0x0b, 0xa9, 0x1a,
	0xa1, 0x9c, 0x77, 0x57, 0x40, 0xd2, 0xd6, 0x93, 0xb3, 0xf0, 0xf4, 0xcc, 0x12, 0x7e, 0x16, 0xb6,
	0xc7, 0x7d, 0xcf, 0xc2, 0x55, 0x14, 0x6d, 0xfa, 0x37, 0xc2, 0xf1, 0x0c, 0x9a, 0x2f, 0xd1, 0xb2,
	0xf1, 0x9e, 0xf3, 0xb3, 0x16, 0x61, 0x94, 0xf9, 0xfe, 0x8a, 0x68, 0xc6, 0x01, 0xb5, 0x93, 0xf4,
	0xa0, 0x3b, 0x48, 0x61, 0xbe, 0xa0, 0x3a, 0x1f, 0x50, 0x6d, 0x61, 0xdf, 0x03, 0xaa, 0x9d, 0xa1,
	0x1d, 0xff, 0x42, 0xf8, 0x8d, 0xbc, 0x78, 0x36, 0x7b, 0x34, 0xed, 0xea, 0xd7, 0xb8, 0xa8, 0x89,
	0xf7, 0xbc, 0x4a, 0x70, 0x05, 0x45, 0x59, 0xef, 0xad, 0x06, 0x66, 0x54, 0xc5, 0x4d, 0x10, 0x09,
	0xa7, 0x87, 0x96, 0x35, 0xe8, 0xba, 0xda, 0x2b, 0x09, 0xbe, 0x55, 0x71, 0x01, 0x48, 0x2b, 0x7f,
	0x8f, 0xf0, 0xf3, 0x6d, 0xc8, 0x52, 0x9a, 0x10, 0x09, 0x5b, 0x43, 0xe8, 0x4b, 0xf1, 0xe1, 0x95,
	0xe8, 0xb6, 0x73, 0xc7, 0x14, 0x92, 0x4a, 0xf1, 0xdd, 0x70, 0x80, 0xf1, 0xf5, 0xb3, 0x33, 0xea,
	0x27, 0x9d, 0x1e, 0xe1, 0xdd, 0xc9, 0x7e, 0x37, 0x10, 0xce, 0x5f, 0x3f, 0x0b, 0x39, 0xdf, 0xaf,
	0x9f, 0xa5, 0xb8, 0x96, 0xfa, 0x0a, 0xe1, 0xa7, 0x27, 0x7f, 0x55, 0x35, 0x3b, 0xba, 0xe1, 0x81,
	0x54, 0x21, 0xa5, 0x73, 0x33, 0x28, 0x6b, 0xac, 0x68, 0x35, 0xc6, 0x46, 0x7d, 0xda, 0xf0, 0x9c,
	0x20, 0xb6, 0xda, 0xd4, 0x5c, 0x8a, 0xa1, 0x1d, 0x7f, 0x40, 0xf8, 0x05, 0xd5, 0x64, 0x76, 0x11,
	0xb2, 0xc3, 0x84, 0x8c, 0xee, 0x78, 0xe2, 0xe7, 0xb2, 0xca, 0x70, 0x63, 0x19, 0x84, 0x16, 0xfc,
	0x12, 0x61, 0xdc, 0x4c, 0x99, 0x80, 0xe9, 0x78, 0x47, 0xd7, 0x1c, 0xa1, 0x17, 0x11, 0xa5, 0x73,
	0x3d, 0x20, 0x69, 0x58, 0xe4, 0x55, 0x7e, 0xba, 0x25, 0x5f, 0xf3, 0x3a, 0x18, 0xcc, 0x6f, 0xc4,
	0xd7, 0x03, 0x92, 0x46, 0x39, 0x6e, 0x81, 0x54, 0x8b, 0x92, 0xb2, 0xfe, 0x3e, 0x08, 0x41, 0x8e,
	0x40, 0x38, 0x97, 0x63, 0x7b, 0xdc, 0xb7, 0x1c, 0x57, 0x51, 0x8c, 0x9d, 0xb6, 0x05, 0x72, 0x73,
	0xef, 0xc0, 0x26, 0xdb, 0x72, 0x7f, 0x8c, 0x9d, 0xe0, 0xbb, 0xd3, 0x2e, 0x00, 0x69, 0xe5, 0x87,
	0x08, 0x3f, 0x73, 0x30, 0x00, 0x3e, 0x52, 0xdb, 0x71, 0xe4, 0xba, 0xfc, 0x8d, 0x94, 0x52, 0x5b,
	0x0f, 0x0b, 0x1b, 0x3a, 0x6d, 0x20, 0x59, 0x96, 0x8e, 0xf2, 0xbd, 0xd7, 0x59, 0xc7, 0x48, 0xf9,
	0xea, 0x14, 0xc2, 0x5a, 0xe7, 0x6b, 0x84, 0x2f, 0xe5, 0xbd, 0xa8, 0x47, 0x71, 0xdd, 0xab, 0xf3,
	0x8b, 0x43, 0x77, 0x2b, 0x30, 0x6d, 0x5e, 0x34, 0x0e, 0xf8, 0x11, 0xcc, 0x3b, 0x39, 0x5f, 0x34,
	0x16, 0x82, 0xde, 0x17, 0x8d, 0xa5, 0xbc, 0xe1, 0xb5, 0x0f, 0x81, 0x5e, 0xc5, 0xa0, 0xaf, 0x57,
	0x39, 0x5f, 0xb8, 0x00, 0x7d, 0xc0, 0x41, 0xf4, 0xe6, 0x4f, 0x77, 0xc2, 0xe3, 0x02, 0xb4, 0x1c,
	0xf6, 0xbf, 0x00, 0xb5, 0x31, 0x94, 0xe3, 0x46, 0x76, 0x7a, 0x16, 0xd7, 0x1e, 0x9d, 0xc5, 0xb5,
	0xc7, 0x67, 0x31, 0xfa, 0x62, 0x1c, 0xa3, 0x9f, 0xc7, 0x31, 0xfa, 0x77, 0x1c, 0xa3, 0xd3, 0x71,
	0x8c, 0xfe, 0x1b, 0xc7, 0xe8, 0xff, 0x71, 0x5c, 0x7b, 0x3c, 0x8e, 0xd1, 0x37, 0xe7, 0x71, 0xed,
	0xf4, 0x3c, 0xae, 0x3d, 0x3a, 0x8f, 0x6b, 0x1f, 0xdf, 0x38, 0x62, 0x17, 0x8f, 0xa7, 0x6c, 0xe1,
	0x0f, 0x01, 0x37, 0xcd, 0x4f, 0x0e, 0x9f, 0x9a, 0xfe, 0x0e, 0x70, 0xf5, 0x49, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x3e, 0xd6, 0x58, 0xf3, 0xa3, 0x18, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// HistoryServiceClient is the client API for HistoryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type HistoryServiceClient interface {
	// StartWorkflowExecution starts a new long running workflow instance.  It will create the instance with
	// 'WorkflowExecutionStarted' event in history and also schedule the first WorkflowTask for the worker to produce the
	// initial list of commands for this instance.  It will return 'WorkflowExecutionAlreadyStartedError', if an instance already
	// exists with same workflowId.
	StartWorkflowExecution(ctx context.Context, in *StartWorkflowExecutionRequest, opts ...grpc.CallOption) (*StartWorkflowExecutionResponse, error)
	// Returns the information from mutable state of workflow execution.
	// It fails with 'EntityNotExistError' if specified workflow execution in unknown to the service.
	// It returns CurrentBranchChangedError if the workflow version branch has changed.
	GetMutableState(ctx context.Context, in *GetMutableStateRequest, opts ...grpc.CallOption) (*GetMutableStateResponse, error)
	// Returns the information from mutable state of workflow execution.
	// It fails with 'EntityNotExistError' if specified workflow execution in unknown to the service.
	// It returns CurrentBranchChangedError if the workflow version branch has changed.
	PollMutableState(ctx context.Context, in *PollMutableStateRequest, opts ...grpc.CallOption) (*PollMutableStateResponse, error)
	// Reset the sticky task queue related information in mutable state of a given workflow.
	// Things cleared are:
	// 1. StickyTaskQueue
	// 2. StickyScheduleToStartTimeout
	ResetStickyTaskQueue(ctx context.Context, in *ResetStickyTaskQueueRequest, opts ...grpc.CallOption) (*ResetStickyTaskQueueResponse, error)
	// RecordWorkflowTaskStarted is called by the Matchingservice before it hands a workflow task to the application worker in response to
	// a PollWorkflowTaskQueue call. It records in the history the event that the workflow task has started. It will return 'TaskAlreadyStartedError',
	// if the workflow's execution history already includes a record of the event starting.
	RecordWorkflowTaskStarted(ctx context.Context, in *RecordWorkflowTaskStartedRequest, opts ...grpc.CallOption) (*RecordWorkflowTaskStartedResponse, error)
	// RecordActivityTaskStarted is called by the Matchingservice before it hands a workflow task to the application worker in response to
	// a PollActivityTaskQueue call. It records in the history the event that the workflow task has started. It will return 'TaskAlreadyStartedError',
	// if the workflow's execution history already includes a record of the event starting.
	RecordActivityTaskStarted(ctx context.Context, in *RecordActivityTaskStartedRequest, opts ...grpc.CallOption) (*RecordActivityTaskStartedResponse, error)
	// RespondWorkflowTaskCompleted is called by application worker to complete a WorkflowTask handed as a result of
	// 'PollWorkflowTaskQueue' API call.  Completing a WorkflowTask will result in new result in new commands for the
	// workflow execution and potentially new ActivityTasks created for correspondent commands. It will also create a
	// WorkflowTaskCompleted event in the history for that session.  Use the 'taskToken' provided as response of
	// PollWorkflowTaskQueue API call for completing the WorkflowTask.
	RespondWorkflowTaskCompleted(ctx context.Context, in *RespondWorkflowTaskCompletedRequest, opts ...grpc.CallOption) (*RespondWorkflowTaskCompletedResponse, error)
	// RespondWorkflowTaskFailed is called by application worker to indicate failure.  This results in
	// WorkflowTaskFailedEvent written to the history and a new WorkflowTask created.  This API can be used by client to
	// either clear sticky task queue or report ny panics during WorkflowTask processing.
	RespondWorkflowTaskFailed(ctx context.Context, in *RespondWorkflowTaskFailedRequest, opts ...grpc.CallOption) (*RespondWorkflowTaskFailedResponse, error)
	// RecordActivityTaskHeartbeat is called by application worker while it is processing an ActivityTask.  If worker fails
	// to heartbeat within 'heartbeatTimeoutSeconds' interval for the ActivityTask, then it will be marked as timedout and
	// 'ActivityTaskTimedOut' event will be written to the workflow history.  Calling 'RecordActivityTaskHeartbeat' will
	// fail with 'EntityNotExistsError' in such situations.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for heartbeating.
	RecordActivityTaskHeartbeat(ctx context.Context, in *RecordActivityTaskHeartbeatRequest, opts ...grpc.CallOption) (*RecordActivityTaskHeartbeatResponse, error)
	// RespondActivityTaskCompleted is called by application worker when it is done processing an ActivityTask.  It will
	// result in a new 'ActivityTaskCompleted' event being written to the workflow history and a new WorkflowTask
	// created for the workflow so new commands could be made.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for completion. It fails with 'EntityNotExistsError' if the taskToken is not valid
	// anymore due to activity timeout.
	RespondActivityTaskCompleted(ctx context.Context, in *RespondActivityTaskCompletedRequest, opts ...grpc.CallOption) (*RespondActivityTaskCompletedResponse, error)
	// RespondActivityTaskFailed is called by application worker when it is done processing an ActivityTask.  It will
	// result in a new 'ActivityTaskFailed' event being written to the workflow history and a new WorkflowTask
	// created for the workflow instance so new commands could be made.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for completion. It fails with 'EntityNotExistsError' if the taskToken is not valid
	// anymore due to activity timeout.
	RespondActivityTaskFailed(ctx context.Context, in *RespondActivityTaskFailedRequest, opts ...grpc.CallOption) (*RespondActivityTaskFailedResponse, error)
	// RespondActivityTaskCanceled is called by application worker when it is successfully canceled an ActivityTask.  It will
	// result in a new 'ActivityTaskCanceled' event being written to the workflow history and a new WorkflowTask
	// created for the workflow instance so new commands could be made.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for completion. It fails with 'EntityNotExistsError' if the taskToken is not valid
	// anymore due to activity timeout.
	RespondActivityTaskCanceled(ctx context.Context, in *RespondActivityTaskCanceledRequest, opts ...grpc.CallOption) (*RespondActivityTaskCanceledResponse, error)
	// SignalWorkflowExecution is used to send a signal event to running workflow execution.  This results in
	// WorkflowExecutionSignaled event recorded in the history and a workflow task being created for the execution.
	SignalWorkflowExecution(ctx context.Context, in *SignalWorkflowExecutionRequest, opts ...grpc.CallOption) (*SignalWorkflowExecutionResponse, error)
	// (-- api-linter: core::0136::prepositions=disabled
	//     aip.dev/not-precedent: "With" is needed here. --)
	// SignalWithStartWorkflowExecution is used to ensure sending a signal event to a workflow execution.
	// If workflow is running, this results in WorkflowExecutionSignaled event recorded in the history
	// and a workflow task being created for the execution.
	// If workflow is not running or not found, it will first try start workflow with given WorkflowIdResuePolicy,
	// and record WorkflowExecutionStarted and WorkflowExecutionSignaled event in case of success.
	// It will return `WorkflowExecutionAlreadyStartedError` if start workflow failed with given policy.
	SignalWithStartWorkflowExecution(ctx context.Context, in *SignalWithStartWorkflowExecutionRequest, opts ...grpc.CallOption) (*SignalWithStartWorkflowExecutionResponse, error)
	// RemoveSignalMutableState is used to remove a signal request Id that was previously recorded.  This is currently
	// used to clean execution info when signal workflow task finished.
	RemoveSignalMutableState(ctx context.Context, in *RemoveSignalMutableStateRequest, opts ...grpc.CallOption) (*RemoveSignalMutableStateResponse, error)
	// TerminateWorkflowExecution terminates an existing workflow execution by recording WorkflowExecutionTerminated event
	// in the history and immediately terminating the execution instance.
	TerminateWorkflowExecution(ctx context.Context, in *TerminateWorkflowExecutionRequest, opts ...grpc.CallOption) (*TerminateWorkflowExecutionResponse, error)
	// ResetWorkflowExecution reset an existing workflow execution by a firstEventId of a existing event batch
	// in the history and immediately terminating the current execution instance.
	// After reset, the history will grow from nextFirstEventId.
	ResetWorkflowExecution(ctx context.Context, in *ResetWorkflowExecutionRequest, opts ...grpc.CallOption) (*ResetWorkflowExecutionResponse, error)
	// RequestCancelWorkflowExecution is called by application worker when it wants to request cancellation of a workflow instance.
	// It will result in a new 'WorkflowExecutionCancelRequested' event being written to the workflow history and a new WorkflowTask
	// created for the workflow instance so new commands could be made. It fails with 'EntityNotExistsError' if the workflow is not valid
	// anymore due to completion or doesn't exist.
	RequestCancelWorkflowExecution(ctx context.Context, in *RequestCancelWorkflowExecutionRequest, opts ...grpc.CallOption) (*RequestCancelWorkflowExecutionResponse, error)
	// ScheduleWorkflowTask is used for creating a workflow task for already started workflow execution.  This is mainly
	// used by transfer queue processor during the processing of StartChildWorkflowExecution task, where it first starts
	// child execution without creating the workflow task and then calls this API after updating the mutable state of
	// parent execution.
	ScheduleWorkflowTask(ctx context.Context, in *ScheduleWorkflowTaskRequest, opts ...grpc.CallOption) (*ScheduleWorkflowTaskResponse, error)
	// RecordChildExecutionCompleted is used for reporting the completion of child workflow execution to parent.
	// This is mainly called by transfer queue processor during the processing of DeleteExecution task.
	RecordChildExecutionCompleted(ctx context.Context, in *RecordChildExecutionCompletedRequest, opts ...grpc.CallOption) (*RecordChildExecutionCompletedResponse, error)
	// DescribeWorkflowExecution returns information about the specified workflow execution.
	DescribeWorkflowExecution(ctx context.Context, in *DescribeWorkflowExecutionRequest, opts ...grpc.CallOption) (*DescribeWorkflowExecutionResponse, error)
	ReplicateEventsV2(ctx context.Context, in *ReplicateEventsV2Request, opts ...grpc.CallOption) (*ReplicateEventsV2Response, error)
	// SyncShardStatus sync the status between shards.
	SyncShardStatus(ctx context.Context, in *SyncShardStatusRequest, opts ...grpc.CallOption) (*SyncShardStatusResponse, error)
	// SyncActivity sync the activity status.
	SyncActivity(ctx context.Context, in *SyncActivityRequest, opts ...grpc.CallOption) (*SyncActivityResponse, error)
	// DescribeMutableState returns information about the internal states of workflow mutable state.
	DescribeMutableState(ctx context.Context, in *DescribeMutableStateRequest, opts ...grpc.CallOption) (*DescribeMutableStateResponse, error)
	// DescribeHistoryHost returns information about the internal states of a history host.
	DescribeHistoryHost(ctx context.Context, in *DescribeHistoryHostRequest, opts ...grpc.CallOption) (*DescribeHistoryHostResponse, error)
	// CloseShard close the shard.
	CloseShard(ctx context.Context, in *CloseShardRequest, opts ...grpc.CallOption) (*CloseShardResponse, error)
	// RemoveTask remove task based on type, taskid, shardid.
	RemoveTask(ctx context.Context, in *RemoveTaskRequest, opts ...grpc.CallOption) (*RemoveTaskResponse, error)
	// GetReplicationMessages return replication messages based on the read level
	GetReplicationMessages(ctx context.Context, in *GetReplicationMessagesRequest, opts ...grpc.CallOption) (*GetReplicationMessagesResponse, error)
	// GetDLQReplicationMessages return replication messages based on dlq info
	GetDLQReplicationMessages(ctx context.Context, in *GetDLQReplicationMessagesRequest, opts ...grpc.CallOption) (*GetDLQReplicationMessagesResponse, error)
	// QueryWorkflow returns query result for a specified workflow execution.
	QueryWorkflow(ctx context.Context, in *QueryWorkflowRequest, opts ...grpc.CallOption) (*QueryWorkflowResponse, error)
	// ReapplyEvents applies stale events to the current workflow and current run.
	ReapplyEvents(ctx context.Context, in *ReapplyEventsRequest, opts ...grpc.CallOption) (*ReapplyEventsResponse, error)
	// GetDLQMessages returns messages from DLQ.
	GetDLQMessages(ctx context.Context, in *GetDLQMessagesRequest, opts ...grpc.CallOption) (*GetDLQMessagesResponse, error)
	// PurgeDLQMessages purges messages from DLQ.
	PurgeDLQMessages(ctx context.Context, in *PurgeDLQMessagesRequest, opts ...grpc.CallOption) (*PurgeDLQMessagesResponse, error)
	// MergeDLQMessages merges messages from DLQ.
	MergeDLQMessages(ctx context.Context, in *MergeDLQMessagesRequest, opts ...grpc.CallOption) (*MergeDLQMessagesResponse, error)
	// RefreshWorkflowTasks refreshes all tasks of a workflow.
	RefreshWorkflowTasks(ctx context.Context, in *RefreshWorkflowTasksRequest, opts ...grpc.CallOption) (*RefreshWorkflowTasksResponse, error)
}

type historyServiceClient struct {
	cc *grpc.ClientConn
}

func NewHistoryServiceClient(cc *grpc.ClientConn) HistoryServiceClient {
	return &historyServiceClient{cc}
}

func (c *historyServiceClient) StartWorkflowExecution(ctx context.Context, in *StartWorkflowExecutionRequest, opts ...grpc.CallOption) (*StartWorkflowExecutionResponse, error) {
	out := new(StartWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/StartWorkflowExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetMutableState(ctx context.Context, in *GetMutableStateRequest, opts ...grpc.CallOption) (*GetMutableStateResponse, error) {
	out := new(GetMutableStateResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/GetMutableState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) PollMutableState(ctx context.Context, in *PollMutableStateRequest, opts ...grpc.CallOption) (*PollMutableStateResponse, error) {
	out := new(PollMutableStateResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/PollMutableState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ResetStickyTaskQueue(ctx context.Context, in *ResetStickyTaskQueueRequest, opts ...grpc.CallOption) (*ResetStickyTaskQueueResponse, error) {
	out := new(ResetStickyTaskQueueResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/ResetStickyTaskQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RecordWorkflowTaskStarted(ctx context.Context, in *RecordWorkflowTaskStartedRequest, opts ...grpc.CallOption) (*RecordWorkflowTaskStartedResponse, error) {
	out := new(RecordWorkflowTaskStartedResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/RecordWorkflowTaskStarted", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RecordActivityTaskStarted(ctx context.Context, in *RecordActivityTaskStartedRequest, opts ...grpc.CallOption) (*RecordActivityTaskStartedResponse, error) {
	out := new(RecordActivityTaskStartedResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/RecordActivityTaskStarted", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RespondWorkflowTaskCompleted(ctx context.Context, in *RespondWorkflowTaskCompletedRequest, opts ...grpc.CallOption) (*RespondWorkflowTaskCompletedResponse, error) {
	out := new(RespondWorkflowTaskCompletedResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/RespondWorkflowTaskCompleted", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RespondWorkflowTaskFailed(ctx context.Context, in *RespondWorkflowTaskFailedRequest, opts ...grpc.CallOption) (*RespondWorkflowTaskFailedResponse, error) {
	out := new(RespondWorkflowTaskFailedResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/RespondWorkflowTaskFailed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RecordActivityTaskHeartbeat(ctx context.Context, in *RecordActivityTaskHeartbeatRequest, opts ...grpc.CallOption) (*RecordActivityTaskHeartbeatResponse, error) {
	out := new(RecordActivityTaskHeartbeatResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/RecordActivityTaskHeartbeat", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RespondActivityTaskCompleted(ctx context.Context, in *RespondActivityTaskCompletedRequest, opts ...grpc.CallOption) (*RespondActivityTaskCompletedResponse, error) {
	out := new(RespondActivityTaskCompletedResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/RespondActivityTaskCompleted", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RespondActivityTaskFailed(ctx context.Context, in *RespondActivityTaskFailedRequest, opts ...grpc.CallOption) (*RespondActivityTaskFailedResponse, error) {
	out := new(RespondActivityTaskFailedResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/RespondActivityTaskFailed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RespondActivityTaskCanceled(ctx context.Context, in *RespondActivityTaskCanceledRequest, opts ...grpc.CallOption) (*RespondActivityTaskCanceledResponse, error) {
	out := new(RespondActivityTaskCanceledResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/RespondActivityTaskCanceled", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) SignalWorkflowExecution(ctx context.Context, in *SignalWorkflowExecutionRequest, opts ...grpc.CallOption) (*SignalWorkflowExecutionResponse, error) {
	out := new(SignalWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/SignalWorkflowExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) SignalWithStartWorkflowExecution(ctx context.Context, in *SignalWithStartWorkflowExecutionRequest, opts ...grpc.CallOption) (*SignalWithStartWorkflowExecutionResponse, error) {
	out := new(SignalWithStartWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/SignalWithStartWorkflowExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RemoveSignalMutableState(ctx context.Context, in *RemoveSignalMutableStateRequest, opts ...grpc.CallOption) (*RemoveSignalMutableStateResponse, error) {
	out := new(RemoveSignalMutableStateResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/RemoveSignalMutableState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) TerminateWorkflowExecution(ctx context.Context, in *TerminateWorkflowExecutionRequest, opts ...grpc.CallOption) (*TerminateWorkflowExecutionResponse, error) {
	out := new(TerminateWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/TerminateWorkflowExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ResetWorkflowExecution(ctx context.Context, in *ResetWorkflowExecutionRequest, opts ...grpc.CallOption) (*ResetWorkflowExecutionResponse, error) {
	out := new(ResetWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/ResetWorkflowExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RequestCancelWorkflowExecution(ctx context.Context, in *RequestCancelWorkflowExecutionRequest, opts ...grpc.CallOption) (*RequestCancelWorkflowExecutionResponse, error) {
	out := new(RequestCancelWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/RequestCancelWorkflowExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ScheduleWorkflowTask(ctx context.Context, in *ScheduleWorkflowTaskRequest, opts ...grpc.CallOption) (*ScheduleWorkflowTaskResponse, error) {
	out := new(ScheduleWorkflowTaskResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/ScheduleWorkflowTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RecordChildExecutionCompleted(ctx context.Context, in *RecordChildExecutionCompletedRequest, opts ...grpc.CallOption) (*RecordChildExecutionCompletedResponse, error) {
	out := new(RecordChildExecutionCompletedResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/RecordChildExecutionCompleted", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) DescribeWorkflowExecution(ctx context.Context, in *DescribeWorkflowExecutionRequest, opts ...grpc.CallOption) (*DescribeWorkflowExecutionResponse, error) {
	out := new(DescribeWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/DescribeWorkflowExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ReplicateEventsV2(ctx context.Context, in *ReplicateEventsV2Request, opts ...grpc.CallOption) (*ReplicateEventsV2Response, error) {
	out := new(ReplicateEventsV2Response)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/ReplicateEventsV2", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) SyncShardStatus(ctx context.Context, in *SyncShardStatusRequest, opts ...grpc.CallOption) (*SyncShardStatusResponse, error) {
	out := new(SyncShardStatusResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/SyncShardStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) SyncActivity(ctx context.Context, in *SyncActivityRequest, opts ...grpc.CallOption) (*SyncActivityResponse, error) {
	out := new(SyncActivityResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/SyncActivity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) DescribeMutableState(ctx context.Context, in *DescribeMutableStateRequest, opts ...grpc.CallOption) (*DescribeMutableStateResponse, error) {
	out := new(DescribeMutableStateResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/DescribeMutableState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) DescribeHistoryHost(ctx context.Context, in *DescribeHistoryHostRequest, opts ...grpc.CallOption) (*DescribeHistoryHostResponse, error) {
	out := new(DescribeHistoryHostResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/DescribeHistoryHost", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) CloseShard(ctx context.Context, in *CloseShardRequest, opts ...grpc.CallOption) (*CloseShardResponse, error) {
	out := new(CloseShardResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/CloseShard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RemoveTask(ctx context.Context, in *RemoveTaskRequest, opts ...grpc.CallOption) (*RemoveTaskResponse, error) {
	out := new(RemoveTaskResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/RemoveTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetReplicationMessages(ctx context.Context, in *GetReplicationMessagesRequest, opts ...grpc.CallOption) (*GetReplicationMessagesResponse, error) {
	out := new(GetReplicationMessagesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/GetReplicationMessages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetDLQReplicationMessages(ctx context.Context, in *GetDLQReplicationMessagesRequest, opts ...grpc.CallOption) (*GetDLQReplicationMessagesResponse, error) {
	out := new(GetDLQReplicationMessagesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/GetDLQReplicationMessages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) QueryWorkflow(ctx context.Context, in *QueryWorkflowRequest, opts ...grpc.CallOption) (*QueryWorkflowResponse, error) {
	out := new(QueryWorkflowResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/QueryWorkflow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ReapplyEvents(ctx context.Context, in *ReapplyEventsRequest, opts ...grpc.CallOption) (*ReapplyEventsResponse, error) {
	out := new(ReapplyEventsResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/ReapplyEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetDLQMessages(ctx context.Context, in *GetDLQMessagesRequest, opts ...grpc.CallOption) (*GetDLQMessagesResponse, error) {
	out := new(GetDLQMessagesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/GetDLQMessages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) PurgeDLQMessages(ctx context.Context, in *PurgeDLQMessagesRequest, opts ...grpc.CallOption) (*PurgeDLQMessagesResponse, error) {
	out := new(PurgeDLQMessagesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/PurgeDLQMessages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) MergeDLQMessages(ctx context.Context, in *MergeDLQMessagesRequest, opts ...grpc.CallOption) (*MergeDLQMessagesResponse, error) {
	out := new(MergeDLQMessagesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/MergeDLQMessages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RefreshWorkflowTasks(ctx context.Context, in *RefreshWorkflowTasksRequest, opts ...grpc.CallOption) (*RefreshWorkflowTasksResponse, error) {
	out := new(RefreshWorkflowTasksResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.historyservice.v1.HistoryService/RefreshWorkflowTasks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HistoryServiceServer is the server API for HistoryService service.
type HistoryServiceServer interface {
	// StartWorkflowExecution starts a new long running workflow instance.  It will create the instance with
	// 'WorkflowExecutionStarted' event in history and also schedule the first WorkflowTask for the worker to produce the
	// initial list of commands for this instance.  It will return 'WorkflowExecutionAlreadyStartedError', if an instance already
	// exists with same workflowId.
	StartWorkflowExecution(context.Context, *StartWorkflowExecutionRequest) (*StartWorkflowExecutionResponse, error)
	// Returns the information from mutable state of workflow execution.
	// It fails with 'EntityNotExistError' if specified workflow execution in unknown to the service.
	// It returns CurrentBranchChangedError if the workflow version branch has changed.
	GetMutableState(context.Context, *GetMutableStateRequest) (*GetMutableStateResponse, error)
	// Returns the information from mutable state of workflow execution.
	// It fails with 'EntityNotExistError' if specified workflow execution in unknown to the service.
	// It returns CurrentBranchChangedError if the workflow version branch has changed.
	PollMutableState(context.Context, *PollMutableStateRequest) (*PollMutableStateResponse, error)
	// Reset the sticky task queue related information in mutable state of a given workflow.
	// Things cleared are:
	// 1. StickyTaskQueue
	// 2. StickyScheduleToStartTimeout
	ResetStickyTaskQueue(context.Context, *ResetStickyTaskQueueRequest) (*ResetStickyTaskQueueResponse, error)
	// RecordWorkflowTaskStarted is called by the Matchingservice before it hands a workflow task to the application worker in response to
	// a PollWorkflowTaskQueue call. It records in the history the event that the workflow task has started. It will return 'TaskAlreadyStartedError',
	// if the workflow's execution history already includes a record of the event starting.
	RecordWorkflowTaskStarted(context.Context, *RecordWorkflowTaskStartedRequest) (*RecordWorkflowTaskStartedResponse, error)
	// RecordActivityTaskStarted is called by the Matchingservice before it hands a workflow task to the application worker in response to
	// a PollActivityTaskQueue call. It records in the history the event that the workflow task has started. It will return 'TaskAlreadyStartedError',
	// if the workflow's execution history already includes a record of the event starting.
	RecordActivityTaskStarted(context.Context, *RecordActivityTaskStartedRequest) (*RecordActivityTaskStartedResponse, error)
	// RespondWorkflowTaskCompleted is called by application worker to complete a WorkflowTask handed as a result of
	// 'PollWorkflowTaskQueue' API call.  Completing a WorkflowTask will result in new result in new commands for the
	// workflow execution and potentially new ActivityTasks created for correspondent commands. It will also create a
	// WorkflowTaskCompleted event in the history for that session.  Use the 'taskToken' provided as response of
	// PollWorkflowTaskQueue API call for completing the WorkflowTask.
	RespondWorkflowTaskCompleted(context.Context, *RespondWorkflowTaskCompletedRequest) (*RespondWorkflowTaskCompletedResponse, error)
	// RespondWorkflowTaskFailed is called by application worker to indicate failure.  This results in
	// WorkflowTaskFailedEvent written to the history and a new WorkflowTask created.  This API can be used by client to
	// either clear sticky task queue or report ny panics during WorkflowTask processing.
	RespondWorkflowTaskFailed(context.Context, *RespondWorkflowTaskFailedRequest) (*RespondWorkflowTaskFailedResponse, error)
	// RecordActivityTaskHeartbeat is called by application worker while it is processing an ActivityTask.  If worker fails
	// to heartbeat within 'heartbeatTimeoutSeconds' interval for the ActivityTask, then it will be marked as timedout and
	// 'ActivityTaskTimedOut' event will be written to the workflow history.  Calling 'RecordActivityTaskHeartbeat' will
	// fail with 'EntityNotExistsError' in such situations.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for heartbeating.
	RecordActivityTaskHeartbeat(context.Context, *RecordActivityTaskHeartbeatRequest) (*RecordActivityTaskHeartbeatResponse, error)
	// RespondActivityTaskCompleted is called by application worker when it is done processing an ActivityTask.  It will
	// result in a new 'ActivityTaskCompleted' event being written to the workflow history and a new WorkflowTask
	// created for the workflow so new commands could be made.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for completion. It fails with 'EntityNotExistsError' if the taskToken is not valid
	// anymore due to activity timeout.
	RespondActivityTaskCompleted(context.Context, *RespondActivityTaskCompletedRequest) (*RespondActivityTaskCompletedResponse, error)
	// RespondActivityTaskFailed is called by application worker when it is done processing an ActivityTask.  It will
	// result in a new 'ActivityTaskFailed' event being written to the workflow history and a new WorkflowTask
	// created for the workflow instance so new commands could be made.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for completion. It fails with 'EntityNotExistsError' if the taskToken is not valid
	// anymore due to activity timeout.
	RespondActivityTaskFailed(context.Context, *RespondActivityTaskFailedRequest) (*RespondActivityTaskFailedResponse, error)
	// RespondActivityTaskCanceled is called by application worker when it is successfully canceled an ActivityTask.  It will
	// result in a new 'ActivityTaskCanceled' event being written to the workflow history and a new WorkflowTask
	// created for the workflow instance so new commands could be made.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for completion. It fails with 'EntityNotExistsError' if the taskToken is not valid
	// anymore due to activity timeout.
	RespondActivityTaskCanceled(context.Context, *RespondActivityTaskCanceledRequest) (*RespondActivityTaskCanceledResponse, error)
	// SignalWorkflowExecution is used to send a signal event to running workflow execution.  This results in
	// WorkflowExecutionSignaled event recorded in the history and a workflow task being created for the execution.
	SignalWorkflowExecution(context.Context, *SignalWorkflowExecutionRequest) (*SignalWorkflowExecutionResponse, error)
	// (-- api-linter: core::0136::prepositions=disabled
	//     aip.dev/not-precedent: "With" is needed here. --)
	// SignalWithStartWorkflowExecution is used to ensure sending a signal event to a workflow execution.
	// If workflow is running, this results in WorkflowExecutionSignaled event recorded in the history
	// and a workflow task being created for the execution.
	// If workflow is not running or not found, it will first try start workflow with given WorkflowIdResuePolicy,
	// and record WorkflowExecutionStarted and WorkflowExecutionSignaled event in case of success.
	// It will return `WorkflowExecutionAlreadyStartedError` if start workflow failed with given policy.
	SignalWithStartWorkflowExecution(context.Context, *SignalWithStartWorkflowExecutionRequest) (*SignalWithStartWorkflowExecutionResponse, error)
	// RemoveSignalMutableState is used to remove a signal request Id that was previously recorded.  This is currently
	// used to clean execution info when signal workflow task finished.
	RemoveSignalMutableState(context.Context, *RemoveSignalMutableStateRequest) (*RemoveSignalMutableStateResponse, error)
	// TerminateWorkflowExecution terminates an existing workflow execution by recording WorkflowExecutionTerminated event
	// in the history and immediately terminating the execution instance.
	TerminateWorkflowExecution(context.Context, *TerminateWorkflowExecutionRequest) (*TerminateWorkflowExecutionResponse, error)
	// ResetWorkflowExecution reset an existing workflow execution by a firstEventId of a existing event batch
	// in the history and immediately terminating the current execution instance.
	// After reset, the history will grow from nextFirstEventId.
	ResetWorkflowExecution(context.Context, *ResetWorkflowExecutionRequest) (*ResetWorkflowExecutionResponse, error)
	// RequestCancelWorkflowExecution is called by application worker when it wants to request cancellation of a workflow instance.
	// It will result in a new 'WorkflowExecutionCancelRequested' event being written to the workflow history and a new WorkflowTask
	// created for the workflow instance so new commands could be made. It fails with 'EntityNotExistsError' if the workflow is not valid
	// anymore due to completion or doesn't exist.
	RequestCancelWorkflowExecution(context.Context, *RequestCancelWorkflowExecutionRequest) (*RequestCancelWorkflowExecutionResponse, error)
	// ScheduleWorkflowTask is used for creating a workflow task for already started workflow execution.  This is mainly
	// used by transfer queue processor during the processing of StartChildWorkflowExecution task, where it first starts
	// child execution without creating the workflow task and then calls this API after updating the mutable state of
	// parent execution.
	ScheduleWorkflowTask(context.Context, *ScheduleWorkflowTaskRequest) (*ScheduleWorkflowTaskResponse, error)
	// RecordChildExecutionCompleted is used for reporting the completion of child workflow execution to parent.
	// This is mainly called by transfer queue processor during the processing of DeleteExecution task.
	RecordChildExecutionCompleted(context.Context, *RecordChildExecutionCompletedRequest) (*RecordChildExecutionCompletedResponse, error)
	// DescribeWorkflowExecution returns information about the specified workflow execution.
	DescribeWorkflowExecution(context.Context, *DescribeWorkflowExecutionRequest) (*DescribeWorkflowExecutionResponse, error)
	ReplicateEventsV2(context.Context, *ReplicateEventsV2Request) (*ReplicateEventsV2Response, error)
	// SyncShardStatus sync the status between shards.
	SyncShardStatus(context.Context, *SyncShardStatusRequest) (*SyncShardStatusResponse, error)
	// SyncActivity sync the activity status.
	SyncActivity(context.Context, *SyncActivityRequest) (*SyncActivityResponse, error)
	// DescribeMutableState returns information about the internal states of workflow mutable state.
	DescribeMutableState(context.Context, *DescribeMutableStateRequest) (*DescribeMutableStateResponse, error)
	// DescribeHistoryHost returns information about the internal states of a history host.
	DescribeHistoryHost(context.Context, *DescribeHistoryHostRequest) (*DescribeHistoryHostResponse, error)
	// CloseShard close the shard.
	CloseShard(context.Context, *CloseShardRequest) (*CloseShardResponse, error)
	// RemoveTask remove task based on type, taskid, shardid.
	RemoveTask(context.Context, *RemoveTaskRequest) (*RemoveTaskResponse, error)
	// GetReplicationMessages return replication messages based on the read level
	GetReplicationMessages(context.Context, *GetReplicationMessagesRequest) (*GetReplicationMessagesResponse, error)
	// GetDLQReplicationMessages return replication messages based on dlq info
	GetDLQReplicationMessages(context.Context, *GetDLQReplicationMessagesRequest) (*GetDLQReplicationMessagesResponse, error)
	// QueryWorkflow returns query result for a specified workflow execution.
	QueryWorkflow(context.Context, *QueryWorkflowRequest) (*QueryWorkflowResponse, error)
	// ReapplyEvents applies stale events to the current workflow and current run.
	ReapplyEvents(context.Context, *ReapplyEventsRequest) (*ReapplyEventsResponse, error)
	// GetDLQMessages returns messages from DLQ.
	GetDLQMessages(context.Context, *GetDLQMessagesRequest) (*GetDLQMessagesResponse, error)
	// PurgeDLQMessages purges messages from DLQ.
	PurgeDLQMessages(context.Context, *PurgeDLQMessagesRequest) (*PurgeDLQMessagesResponse, error)
	// MergeDLQMessages merges messages from DLQ.
	MergeDLQMessages(context.Context, *MergeDLQMessagesRequest) (*MergeDLQMessagesResponse, error)
	// RefreshWorkflowTasks refreshes all tasks of a workflow.
	RefreshWorkflowTasks(context.Context, *RefreshWorkflowTasksRequest) (*RefreshWorkflowTasksResponse, error)
}

// UnimplementedHistoryServiceServer can be embedded to have forward compatible implementations.
type UnimplementedHistoryServiceServer struct {
}

func (*UnimplementedHistoryServiceServer) StartWorkflowExecution(ctx context.Context, req *StartWorkflowExecutionRequest) (*StartWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartWorkflowExecution not implemented")
}
func (*UnimplementedHistoryServiceServer) GetMutableState(ctx context.Context, req *GetMutableStateRequest) (*GetMutableStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMutableState not implemented")
}
func (*UnimplementedHistoryServiceServer) PollMutableState(ctx context.Context, req *PollMutableStateRequest) (*PollMutableStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PollMutableState not implemented")
}
func (*UnimplementedHistoryServiceServer) ResetStickyTaskQueue(ctx context.Context, req *ResetStickyTaskQueueRequest) (*ResetStickyTaskQueueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetStickyTaskQueue not implemented")
}
func (*UnimplementedHistoryServiceServer) RecordWorkflowTaskStarted(ctx context.Context, req *RecordWorkflowTaskStartedRequest) (*RecordWorkflowTaskStartedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecordWorkflowTaskStarted not implemented")
}
func (*UnimplementedHistoryServiceServer) RecordActivityTaskStarted(ctx context.Context, req *RecordActivityTaskStartedRequest) (*RecordActivityTaskStartedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecordActivityTaskStarted not implemented")
}
func (*UnimplementedHistoryServiceServer) RespondWorkflowTaskCompleted(ctx context.Context, req *RespondWorkflowTaskCompletedRequest) (*RespondWorkflowTaskCompletedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondWorkflowTaskCompleted not implemented")
}
func (*UnimplementedHistoryServiceServer) RespondWorkflowTaskFailed(ctx context.Context, req *RespondWorkflowTaskFailedRequest) (*RespondWorkflowTaskFailedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondWorkflowTaskFailed not implemented")
}
func (*UnimplementedHistoryServiceServer) RecordActivityTaskHeartbeat(ctx context.Context, req *RecordActivityTaskHeartbeatRequest) (*RecordActivityTaskHeartbeatResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecordActivityTaskHeartbeat not implemented")
}
func (*UnimplementedHistoryServiceServer) RespondActivityTaskCompleted(ctx context.Context, req *RespondActivityTaskCompletedRequest) (*RespondActivityTaskCompletedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondActivityTaskCompleted not implemented")
}
func (*UnimplementedHistoryServiceServer) RespondActivityTaskFailed(ctx context.Context, req *RespondActivityTaskFailedRequest) (*RespondActivityTaskFailedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondActivityTaskFailed not implemented")
}
func (*UnimplementedHistoryServiceServer) RespondActivityTaskCanceled(ctx context.Context, req *RespondActivityTaskCanceledRequest) (*RespondActivityTaskCanceledResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondActivityTaskCanceled not implemented")
}
func (*UnimplementedHistoryServiceServer) SignalWorkflowExecution(ctx context.Context, req *SignalWorkflowExecutionRequest) (*SignalWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignalWorkflowExecution not implemented")
}
func (*UnimplementedHistoryServiceServer) SignalWithStartWorkflowExecution(ctx context.Context, req *SignalWithStartWorkflowExecutionRequest) (*SignalWithStartWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignalWithStartWorkflowExecution not implemented")
}
func (*UnimplementedHistoryServiceServer) RemoveSignalMutableState(ctx context.Context, req *RemoveSignalMutableStateRequest) (*RemoveSignalMutableStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveSignalMutableState not implemented")
}
func (*UnimplementedHistoryServiceServer) TerminateWorkflowExecution(ctx context.Context, req *TerminateWorkflowExecutionRequest) (*TerminateWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TerminateWorkflowExecution not implemented")
}
func (*UnimplementedHistoryServiceServer) ResetWorkflowExecution(ctx context.Context, req *ResetWorkflowExecutionRequest) (*ResetWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetWorkflowExecution not implemented")
}
func (*UnimplementedHistoryServiceServer) RequestCancelWorkflowExecution(ctx context.Context, req *RequestCancelWorkflowExecutionRequest) (*RequestCancelWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RequestCancelWorkflowExecution not implemented")
}
func (*UnimplementedHistoryServiceServer) ScheduleWorkflowTask(ctx context.Context, req *ScheduleWorkflowTaskRequest) (*ScheduleWorkflowTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ScheduleWorkflowTask not implemented")
}
func (*UnimplementedHistoryServiceServer) RecordChildExecutionCompleted(ctx context.Context, req *RecordChildExecutionCompletedRequest) (*RecordChildExecutionCompletedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecordChildExecutionCompleted not implemented")
}
func (*UnimplementedHistoryServiceServer) DescribeWorkflowExecution(ctx context.Context, req *DescribeWorkflowExecutionRequest) (*DescribeWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeWorkflowExecution not implemented")
}
func (*UnimplementedHistoryServiceServer) ReplicateEventsV2(ctx context.Context, req *ReplicateEventsV2Request) (*ReplicateEventsV2Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplicateEventsV2 not implemented")
}
func (*UnimplementedHistoryServiceServer) SyncShardStatus(ctx context.Context, req *SyncShardStatusRequest) (*SyncShardStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SyncShardStatus not implemented")
}
func (*UnimplementedHistoryServiceServer) SyncActivity(ctx context.Context, req *SyncActivityRequest) (*SyncActivityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SyncActivity not implemented")
}
func (*UnimplementedHistoryServiceServer) DescribeMutableState(ctx context.Context, req *DescribeMutableStateRequest) (*DescribeMutableStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeMutableState not implemented")
}
func (*UnimplementedHistoryServiceServer) DescribeHistoryHost(ctx context.Context, req *DescribeHistoryHostRequest) (*DescribeHistoryHostResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeHistoryHost not implemented")
}
func (*UnimplementedHistoryServiceServer) CloseShard(ctx context.Context, req *CloseShardRequest) (*CloseShardResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloseShard not implemented")
}
func (*UnimplementedHistoryServiceServer) RemoveTask(ctx context.Context, req *RemoveTaskRequest) (*RemoveTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveTask not implemented")
}
func (*UnimplementedHistoryServiceServer) GetReplicationMessages(ctx context.Context, req *GetReplicationMessagesRequest) (*GetReplicationMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReplicationMessages not implemented")
}
func (*UnimplementedHistoryServiceServer) GetDLQReplicationMessages(ctx context.Context, req *GetDLQReplicationMessagesRequest) (*GetDLQReplicationMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDLQReplicationMessages not implemented")
}
func (*UnimplementedHistoryServiceServer) QueryWorkflow(ctx context.Context, req *QueryWorkflowRequest) (*QueryWorkflowResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryWorkflow not implemented")
}
func (*UnimplementedHistoryServiceServer) ReapplyEvents(ctx context.Context, req *ReapplyEventsRequest) (*ReapplyEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReapplyEvents not implemented")
}
func (*UnimplementedHistoryServiceServer) GetDLQMessages(ctx context.Context, req *GetDLQMessagesRequest) (*GetDLQMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDLQMessages not implemented")
}
func (*UnimplementedHistoryServiceServer) PurgeDLQMessages(ctx context.Context, req *PurgeDLQMessagesRequest) (*PurgeDLQMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeDLQMessages not implemented")
}
func (*UnimplementedHistoryServiceServer) MergeDLQMessages(ctx context.Context, req *MergeDLQMessagesRequest) (*MergeDLQMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeDLQMessages not implemented")
}
func (*UnimplementedHistoryServiceServer) RefreshWorkflowTasks(ctx context.Context, req *RefreshWorkflowTasksRequest) (*RefreshWorkflowTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RefreshWorkflowTasks not implemented")
}

func RegisterHistoryServiceServer(s *grpc.Server, srv HistoryServiceServer) {
	s.RegisterService(&_HistoryService_serviceDesc, srv)
}

func _HistoryService_StartWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).StartWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/StartWorkflowExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).StartWorkflowExecution(ctx, req.(*StartWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetMutableState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMutableStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetMutableState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/GetMutableState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetMutableState(ctx, req.(*GetMutableStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_PollMutableState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PollMutableStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).PollMutableState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/PollMutableState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).PollMutableState(ctx, req.(*PollMutableStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ResetStickyTaskQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetStickyTaskQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ResetStickyTaskQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/ResetStickyTaskQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ResetStickyTaskQueue(ctx, req.(*ResetStickyTaskQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RecordWorkflowTaskStarted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecordWorkflowTaskStartedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RecordWorkflowTaskStarted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/RecordWorkflowTaskStarted",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RecordWorkflowTaskStarted(ctx, req.(*RecordWorkflowTaskStartedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RecordActivityTaskStarted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecordActivityTaskStartedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RecordActivityTaskStarted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/RecordActivityTaskStarted",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RecordActivityTaskStarted(ctx, req.(*RecordActivityTaskStartedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RespondWorkflowTaskCompleted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondWorkflowTaskCompletedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RespondWorkflowTaskCompleted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/RespondWorkflowTaskCompleted",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RespondWorkflowTaskCompleted(ctx, req.(*RespondWorkflowTaskCompletedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RespondWorkflowTaskFailed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondWorkflowTaskFailedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RespondWorkflowTaskFailed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/RespondWorkflowTaskFailed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RespondWorkflowTaskFailed(ctx, req.(*RespondWorkflowTaskFailedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RecordActivityTaskHeartbeat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecordActivityTaskHeartbeatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RecordActivityTaskHeartbeat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/RecordActivityTaskHeartbeat",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RecordActivityTaskHeartbeat(ctx, req.(*RecordActivityTaskHeartbeatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RespondActivityTaskCompleted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondActivityTaskCompletedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RespondActivityTaskCompleted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/RespondActivityTaskCompleted",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RespondActivityTaskCompleted(ctx, req.(*RespondActivityTaskCompletedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RespondActivityTaskFailed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondActivityTaskFailedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RespondActivityTaskFailed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/RespondActivityTaskFailed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RespondActivityTaskFailed(ctx, req.(*RespondActivityTaskFailedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RespondActivityTaskCanceled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondActivityTaskCanceledRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RespondActivityTaskCanceled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/RespondActivityTaskCanceled",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RespondActivityTaskCanceled(ctx, req.(*RespondActivityTaskCanceledRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_SignalWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignalWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).SignalWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/SignalWorkflowExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).SignalWorkflowExecution(ctx, req.(*SignalWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_SignalWithStartWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignalWithStartWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).SignalWithStartWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/SignalWithStartWorkflowExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).SignalWithStartWorkflowExecution(ctx, req.(*SignalWithStartWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RemoveSignalMutableState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveSignalMutableStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RemoveSignalMutableState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/RemoveSignalMutableState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RemoveSignalMutableState(ctx, req.(*RemoveSignalMutableStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_TerminateWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TerminateWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).TerminateWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/TerminateWorkflowExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).TerminateWorkflowExecution(ctx, req.(*TerminateWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ResetWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ResetWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/ResetWorkflowExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ResetWorkflowExecution(ctx, req.(*ResetWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RequestCancelWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RequestCancelWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RequestCancelWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/RequestCancelWorkflowExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RequestCancelWorkflowExecution(ctx, req.(*RequestCancelWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ScheduleWorkflowTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ScheduleWorkflowTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ScheduleWorkflowTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/ScheduleWorkflowTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ScheduleWorkflowTask(ctx, req.(*ScheduleWorkflowTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RecordChildExecutionCompleted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecordChildExecutionCompletedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RecordChildExecutionCompleted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/RecordChildExecutionCompleted",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RecordChildExecutionCompleted(ctx, req.(*RecordChildExecutionCompletedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_DescribeWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).DescribeWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/DescribeWorkflowExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).DescribeWorkflowExecution(ctx, req.(*DescribeWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ReplicateEventsV2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicateEventsV2Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ReplicateEventsV2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/ReplicateEventsV2",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ReplicateEventsV2(ctx, req.(*ReplicateEventsV2Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_SyncShardStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SyncShardStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).SyncShardStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/SyncShardStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).SyncShardStatus(ctx, req.(*SyncShardStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_SyncActivity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SyncActivityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).SyncActivity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/SyncActivity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).SyncActivity(ctx, req.(*SyncActivityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_DescribeMutableState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeMutableStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).DescribeMutableState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/DescribeMutableState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).DescribeMutableState(ctx, req.(*DescribeMutableStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_DescribeHistoryHost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeHistoryHostRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).DescribeHistoryHost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/DescribeHistoryHost",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).DescribeHistoryHost(ctx, req.(*DescribeHistoryHostRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_CloseShard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseShardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).CloseShard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/CloseShard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).CloseShard(ctx, req.(*CloseShardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RemoveTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RemoveTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/RemoveTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RemoveTask(ctx, req.(*RemoveTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetReplicationMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReplicationMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetReplicationMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/GetReplicationMessages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetReplicationMessages(ctx, req.(*GetReplicationMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetDLQReplicationMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDLQReplicationMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetDLQReplicationMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/GetDLQReplicationMessages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetDLQReplicationMessages(ctx, req.(*GetDLQReplicationMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_QueryWorkflow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryWorkflowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).QueryWorkflow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/QueryWorkflow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).QueryWorkflow(ctx, req.(*QueryWorkflowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ReapplyEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReapplyEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ReapplyEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/ReapplyEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ReapplyEvents(ctx, req.(*ReapplyEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetDLQMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDLQMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetDLQMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/GetDLQMessages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetDLQMessages(ctx, req.(*GetDLQMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_PurgeDLQMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeDLQMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).PurgeDLQMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/PurgeDLQMessages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).PurgeDLQMessages(ctx, req.(*PurgeDLQMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_MergeDLQMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeDLQMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).MergeDLQMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/MergeDLQMessages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).MergeDLQMessages(ctx, req.(*MergeDLQMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RefreshWorkflowTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RefreshWorkflowTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RefreshWorkflowTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.historyservice.v1.HistoryService/RefreshWorkflowTasks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RefreshWorkflowTasks(ctx, req.(*RefreshWorkflowTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HistoryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "temporal.server.api.historyservice.v1.HistoryService",
	HandlerType: (*HistoryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "StartWorkflowExecution",
			Handler:    _HistoryService_StartWorkflowExecution_Handler,
		},
		{
			MethodName: "GetMutableState",
			Handler:    _HistoryService_GetMutableState_Handler,
		},
		{
			MethodName: "PollMutableState",
			Handler:    _HistoryService_PollMutableState_Handler,
		},
		{
			MethodName: "ResetStickyTaskQueue",
			Handler:    _HistoryService_ResetStickyTaskQueue_Handler,
		},
		{
			MethodName: "RecordWorkflowTaskStarted",
			Handler:    _HistoryService_RecordWorkflowTaskStarted_Handler,
		},
		{
			MethodName: "RecordActivityTaskStarted",
			Handler:    _HistoryService_RecordActivityTaskStarted_Handler,
		},
		{
			MethodName: "RespondWorkflowTaskCompleted",
			Handler:    _HistoryService_RespondWorkflowTaskCompleted_Handler,
		},
		{
			MethodName: "RespondWorkflowTaskFailed",
			Handler:    _HistoryService_RespondWorkflowTaskFailed_Handler,
		},
		{
			MethodName: "RecordActivityTaskHeartbeat",
			Handler:    _HistoryService_RecordActivityTaskHeartbeat_Handler,
		},
		{
			MethodName: "RespondActivityTaskCompleted",
			Handler:    _HistoryService_RespondActivityTaskCompleted_Handler,
		},
		{
			MethodName: "RespondActivityTaskFailed",
			Handler:    _HistoryService_RespondActivityTaskFailed_Handler,
		},
		{
			MethodName: "RespondActivityTaskCanceled",
			Handler:    _HistoryService_RespondActivityTaskCanceled_Handler,
		},
		{
			MethodName: "SignalWorkflowExecution",
			Handler:    _HistoryService_SignalWorkflowExecution_Handler,
		},
		{
			MethodName: "SignalWithStartWorkflowExecution",
			Handler:    _HistoryService_SignalWithStartWorkflowExecution_Handler,
		},
		{
			MethodName: "RemoveSignalMutableState",
			Handler:    _HistoryService_RemoveSignalMutableState_Handler,
		},
		{
			MethodName: "TerminateWorkflowExecution",
			Handler:    _HistoryService_TerminateWorkflowExecution_Handler,
		},
		{
			MethodName: "ResetWorkflowExecution",
			Handler:    _HistoryService_ResetWorkflowExecution_Handler,
		},
		{
			MethodName: "RequestCancelWorkflowExecution",
			Handler:    _HistoryService_RequestCancelWorkflowExecution_Handler,
		},
		{
			MethodName: "ScheduleWorkflowTask",
			Handler:    _HistoryService_ScheduleWorkflowTask_Handler,
		},
		{
			MethodName: "RecordChildExecutionCompleted",
			Handler:    _HistoryService_RecordChildExecutionCompleted_Handler,
		},
		{
			MethodName: "DescribeWorkflowExecution",
			Handler:    _HistoryService_DescribeWorkflowExecution_Handler,
		},
		{
			MethodName: "ReplicateEventsV2",
			Handler:    _HistoryService_ReplicateEventsV2_Handler,
		},
		{
			MethodName: "SyncShardStatus",
			Handler:    _HistoryService_SyncShardStatus_Handler,
		},
		{
			MethodName: "SyncActivity",
			Handler:    _HistoryService_SyncActivity_Handler,
		},
		{
			MethodName: "DescribeMutableState",
			Handler:    _HistoryService_DescribeMutableState_Handler,
		},
		{
			MethodName: "DescribeHistoryHost",
			Handler:    _HistoryService_DescribeHistoryHost_Handler,
		},
		{
			MethodName: "CloseShard",
			Handler:    _HistoryService_CloseShard_Handler,
		},
		{
			MethodName: "RemoveTask",
			Handler:    _HistoryService_RemoveTask_Handler,
		},
		{
			MethodName: "GetReplicationMessages",
			Handler:    _HistoryService_GetReplicationMessages_Handler,
		},
		{
			MethodName: "GetDLQReplicationMessages",
			Handler:    _HistoryService_GetDLQReplicationMessages_Handler,
		},
		{
			MethodName: "QueryWorkflow",
			Handler:    _HistoryService_QueryWorkflow_Handler,
		},
		{
			MethodName: "ReapplyEvents",
			Handler:    _HistoryService_ReapplyEvents_Handler,
		},
		{
			MethodName: "GetDLQMessages",
			Handler:    _HistoryService_GetDLQMessages_Handler,
		},
		{
			MethodName: "PurgeDLQMessages",
			Handler:    _HistoryService_PurgeDLQMessages_Handler,
		},
		{
			MethodName: "MergeDLQMessages",
			Handler:    _HistoryService_MergeDLQMessages_Handler,
		},
		{
			MethodName: "RefreshWorkflowTasks",
			Handler:    _HistoryService_RefreshWorkflowTasks_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "temporal/server/api/historyservice/v1/service.proto",
}
