# Temporal Worker

Temporal Worker is a role for Temporal service used for hosting any
components responsible for performing background processing on the Temporal
cluster.

## Replicator

Replicator is a background worker responsible for consuming replication tasks
generated by remote Temporal clusters and pass it down to processor, so they
can be applied to local Temporal cluster.

### Quickstart for localhost development

1. Start Temporal development server for active zone:
    ```
    ./temporal-server --zone active start
    ```

1. Start Temporal development server for standby(passive) zone:
    ```
    ./temporal-server --zone standby start
    ```

1. Create global namespaces
    ```
    tctl --ns sample namespace register --gd true --ac active --cl active standby
    ```

1. Failover between zones:

    Failover to standby:
    ```
    tctl --ns sample namespace update --ac standby
    ```
    Failback to active:
    ```
    tctl --ns sample namespace update --ac active
    ```

## Archiver

Archiver is used to handle archival of workflow execution histories. It does this by hosting a Temporal client worker
and running an archival system workflow. The archival client gets used to initiate archival through signal sending. The archiver
shards work across several workflows. 
