// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/persistence/v1/cluster_metadata.proto

package persistence

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"

	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	v11 "go.temporal.io/api/enums/v1"
	v1 "go.temporal.io/api/version/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// data column
type ClusterMetadata struct {
	ClusterName              string                            `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	HistoryShardCount        int32                             `protobuf:"varint,2,opt,name=history_shard_count,json=historyShardCount,proto3" json:"history_shard_count,omitempty"`
	ClusterId                string                            `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	VersionInfo              *v1.VersionInfo                   `protobuf:"bytes,4,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	IndexSearchAttributes    map[string]*IndexSearchAttributes `protobuf:"bytes,5,rep,name=index_search_attributes,json=indexSearchAttributes,proto3" json:"index_search_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ClusterAddress           string                            `protobuf:"bytes,6,opt,name=cluster_address,json=clusterAddress,proto3" json:"cluster_address,omitempty"`
	FailoverVersionIncrement int64                             `protobuf:"varint,7,opt,name=failover_version_increment,json=failoverVersionIncrement,proto3" json:"failover_version_increment,omitempty"`
	InitialFailoverVersion   int64                             `protobuf:"varint,8,opt,name=initial_failover_version,json=initialFailoverVersion,proto3" json:"initial_failover_version,omitempty"`
	IsGlobalNamespaceEnabled bool                              `protobuf:"varint,9,opt,name=is_global_namespace_enabled,json=isGlobalNamespaceEnabled,proto3" json:"is_global_namespace_enabled,omitempty"`
	IsConnectionEnabled      bool                              `protobuf:"varint,10,opt,name=is_connection_enabled,json=isConnectionEnabled,proto3" json:"is_connection_enabled,omitempty"`
}

func (m *ClusterMetadata) Reset()      { *m = ClusterMetadata{} }
func (*ClusterMetadata) ProtoMessage() {}
func (*ClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f4771d63f405884, []int{0}
}
func (m *ClusterMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterMetadata.Merge(m, src)
}
func (m *ClusterMetadata) XXX_Size() int {
	return m.Size()
}
func (m *ClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterMetadata proto.InternalMessageInfo

func (m *ClusterMetadata) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *ClusterMetadata) GetHistoryShardCount() int32 {
	if m != nil {
		return m.HistoryShardCount
	}
	return 0
}

func (m *ClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ClusterMetadata) GetVersionInfo() *v1.VersionInfo {
	if m != nil {
		return m.VersionInfo
	}
	return nil
}

func (m *ClusterMetadata) GetIndexSearchAttributes() map[string]*IndexSearchAttributes {
	if m != nil {
		return m.IndexSearchAttributes
	}
	return nil
}

func (m *ClusterMetadata) GetClusterAddress() string {
	if m != nil {
		return m.ClusterAddress
	}
	return ""
}

func (m *ClusterMetadata) GetFailoverVersionIncrement() int64 {
	if m != nil {
		return m.FailoverVersionIncrement
	}
	return 0
}

func (m *ClusterMetadata) GetInitialFailoverVersion() int64 {
	if m != nil {
		return m.InitialFailoverVersion
	}
	return 0
}

func (m *ClusterMetadata) GetIsGlobalNamespaceEnabled() bool {
	if m != nil {
		return m.IsGlobalNamespaceEnabled
	}
	return false
}

func (m *ClusterMetadata) GetIsConnectionEnabled() bool {
	if m != nil {
		return m.IsConnectionEnabled
	}
	return false
}

type IndexSearchAttributes struct {
	CustomSearchAttributes map[string]v11.IndexedValueType `protobuf:"bytes,1,rep,name=custom_search_attributes,json=customSearchAttributes,proto3" json:"custom_search_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=temporal.api.enums.v1.IndexedValueType"`
}

func (m *IndexSearchAttributes) Reset()      { *m = IndexSearchAttributes{} }
func (*IndexSearchAttributes) ProtoMessage() {}
func (*IndexSearchAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f4771d63f405884, []int{1}
}
func (m *IndexSearchAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IndexSearchAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IndexSearchAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IndexSearchAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IndexSearchAttributes.Merge(m, src)
}
func (m *IndexSearchAttributes) XXX_Size() int {
	return m.Size()
}
func (m *IndexSearchAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_IndexSearchAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_IndexSearchAttributes proto.InternalMessageInfo

func (m *IndexSearchAttributes) GetCustomSearchAttributes() map[string]v11.IndexedValueType {
	if m != nil {
		return m.CustomSearchAttributes
	}
	return nil
}

func init() {
	proto.RegisterType((*ClusterMetadata)(nil), "temporal.server.api.persistence.v1.ClusterMetadata")
	proto.RegisterMapType((map[string]*IndexSearchAttributes)(nil), "temporal.server.api.persistence.v1.ClusterMetadata.IndexSearchAttributesEntry")
	proto.RegisterType((*IndexSearchAttributes)(nil), "temporal.server.api.persistence.v1.IndexSearchAttributes")
	proto.RegisterMapType((map[string]v11.IndexedValueType)(nil), "temporal.server.api.persistence.v1.IndexSearchAttributes.CustomSearchAttributesEntry")
}

func init() {
	proto.RegisterFile("temporal/server/api/persistence/v1/cluster_metadata.proto", fileDescriptor_1f4771d63f405884)
}

var fileDescriptor_1f4771d63f405884 = []byte{
	// 641 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0x4f, 0x4f, 0xd4, 0x40,
	0x14, 0xdf, 0x61, 0x5d, 0x84, 0x59, 0x02, 0x3a, 0x04, 0x6c, 0x96, 0xd8, 0xac, 0x44, 0xc3, 0x9e,
	0xba, 0x61, 0xf5, 0x00, 0x2a, 0x07, 0xdc, 0x20, 0xe1, 0x20, 0x26, 0x8b, 0x72, 0xf0, 0xd2, 0xcc,
	0xb6, 0x0f, 0x18, 0x6d, 0x67, 0x9a, 0x99, 0xd9, 0xc6, 0xbd, 0x99, 0x98, 0x78, 0xd5, 0x2f, 0xe0,
	0xdd, 0x8f, 0xe2, 0x91, 0x23, 0x47, 0x29, 0x17, 0x6f, 0xf2, 0x11, 0x4c, 0xa7, 0xed, 0xb2, 0x90,
	0xa2, 0xc6, 0x5b, 0xe7, 0xfd, 0xfe, 0xcc, 0x9b, 0xdf, 0xbc, 0x0e, 0x5e, 0xd7, 0x10, 0x46, 0x42,
	0xd2, 0xa0, 0xad, 0x40, 0xc6, 0x20, 0xdb, 0x34, 0x62, 0xed, 0x08, 0xa4, 0x62, 0x4a, 0x03, 0xf7,
	0xa0, 0x1d, 0xaf, 0xb6, 0xbd, 0x60, 0xa0, 0x34, 0x48, 0x37, 0x04, 0x4d, 0x7d, 0xaa, 0xa9, 0x13,
	0x49, 0xa1, 0x05, 0x59, 0x2e, 0xa4, 0x4e, 0x26, 0x75, 0x68, 0xc4, 0x9c, 0x31, 0xa9, 0x13, 0xaf,
	0x36, 0x46, 0x1c, 0xe3, 0x0b, 0x7c, 0x10, 0x2a, 0xe3, 0x28, 0xc2, 0x50, 0xf0, 0xcc, 0xa7, 0xf1,
	0xe0, 0x12, 0x27, 0x4e, 0x0d, 0x04, 0x4f, 0x59, 0x21, 0x28, 0x45, 0x0f, 0x21, 0xa3, 0x2d, 0xff,
	0xaa, 0xe1, 0xb9, 0x6e, 0xd6, 0xc9, 0x8b, 0xbc, 0x11, 0x72, 0x0f, 0xcf, 0x14, 0xcd, 0x71, 0x1a,
	0x82, 0x85, 0x9a, 0xa8, 0x35, 0xdd, 0xab, 0xe7, 0xb5, 0x5d, 0x1a, 0x02, 0x71, 0xf0, 0xfc, 0x11,
	0x53, 0x5a, 0xc8, 0xa1, 0xab, 0x8e, 0xa8, 0xf4, 0x5d, 0x4f, 0x0c, 0xb8, 0xb6, 0x26, 0x9a, 0xa8,
	0x55, 0xeb, 0xdd, 0xce, 0xa1, 0xbd, 0x14, 0xe9, 0xa6, 0x00, 0xb9, 0x8b, 0x71, 0x61, 0xc9, 0x7c,
	0xab, 0x6a, 0x0c, 0xa7, 0xf3, 0xca, 0x8e, 0x4f, 0xb6, 0xf1, 0x4c, 0xde, 0xa1, 0xcb, 0xf8, 0x81,
	0xb0, 0x6e, 0x34, 0x51, 0xab, 0xde, 0xb9, 0xef, 0x8c, 0xb2, 0x48, 0x43, 0xc8, 0x19, 0x4e, 0xbc,
	0xea, 0xec, 0x67, 0x9f, 0x3b, 0xfc, 0x40, 0xf4, 0xea, 0xf1, 0xc5, 0x82, 0x7c, 0x42, 0xf8, 0x0e,
	0xe3, 0x3e, 0xbc, 0x77, 0x15, 0x50, 0xe9, 0x1d, 0xb9, 0x54, 0x6b, 0xc9, 0xfa, 0x03, 0x0d, 0xca,
	0xaa, 0x35, 0xab, 0xad, 0x7a, 0x67, 0xd7, 0xf9, 0x7b, 0xc0, 0xce, 0x95, 0x44, 0x9c, 0x9d, 0xd4,
	0x72, 0xcf, 0x38, 0x6e, 0x8e, 0x0c, 0xb7, 0xb8, 0x96, 0xc3, 0xde, 0x02, 0x2b, 0xc3, 0xc8, 0x0a,
	0x9e, 0x2b, 0x0e, 0x4c, 0x7d, 0x5f, 0x82, 0x52, 0xd6, 0xa4, 0x39, 0xf5, 0x6c, 0x5e, 0xde, 0xcc,
	0xaa, 0xe4, 0x29, 0x6e, 0x1c, 0x50, 0x16, 0x88, 0x18, 0xa4, 0x7b, 0x91, 0x81, 0x27, 0x21, 0x04,
	0xae, 0xad, 0x9b, 0x4d, 0xd4, 0xaa, 0xf6, 0xac, 0x82, 0x31, 0x3a, 0x77, 0x8e, 0x93, 0x35, 0x6c,
	0x31, 0xce, 0x34, 0xa3, 0x81, 0x7b, 0xd5, 0xc5, 0x9a, 0x32, 0xda, 0xc5, 0x1c, 0x7f, 0x7e, 0xd9,
	0x82, 0x6c, 0xe0, 0x25, 0xa6, 0xdc, 0xc3, 0x40, 0xf4, 0x69, 0x60, 0xae, 0x59, 0x45, 0xd4, 0x03,
	0x17, 0x38, 0xed, 0x07, 0xe0, 0x5b, 0xd3, 0x4d, 0xd4, 0x9a, 0xea, 0x59, 0x4c, 0x6d, 0x1b, 0xc6,
	0x6e, 0x41, 0xd8, 0xca, 0x70, 0xd2, 0xc1, 0x0b, 0x4c, 0xb9, 0x9e, 0xe0, 0x1c, 0x3c, 0x9d, 0xf6,
	0x5c, 0x08, 0xb1, 0x11, 0xce, 0x33, 0xd5, 0x1d, 0x61, 0xb9, 0xa6, 0xf1, 0x11, 0xe1, 0xc6, 0xf5,
	0x49, 0x92, 0x5b, 0xb8, 0xfa, 0x0e, 0x86, 0xf9, 0xb4, 0xa5, 0x9f, 0xe4, 0x25, 0xae, 0xc5, 0x34,
	0x18, 0x80, 0x99, 0xab, 0x7a, 0x67, 0xfd, 0x5f, 0xae, 0xae, 0x74, 0x83, 0x5e, 0xe6, 0xf3, 0x78,
	0x62, 0x0d, 0x2d, 0x7f, 0x9d, 0xc0, 0x0b, 0xa5, 0x24, 0xf2, 0x19, 0x61, 0xcb, 0x1b, 0x28, 0x2d,
	0xc2, 0x92, 0xe9, 0x41, 0x66, 0x7a, 0x5e, 0xff, 0x77, 0x0b, 0x4e, 0xd7, 0x38, 0x97, 0x0f, 0xd1,
	0xa2, 0x57, 0x0a, 0x36, 0x24, 0x5e, 0xfa, 0x83, 0xac, 0x24, 0xb1, 0x8d, 0xf1, 0xc4, 0x66, 0x3b,
	0x2b, 0x97, 0xff, 0x20, 0xf3, 0x52, 0x8c, 0x3a, 0x04, 0x7f, 0x3f, 0xa5, 0xbe, 0x1a, 0x46, 0x30,
	0x96, 0xcf, 0xb3, 0xb7, 0xc7, 0xa7, 0x76, 0xe5, 0xe4, 0xd4, 0xae, 0x9c, 0x9f, 0xda, 0xe8, 0x43,
	0x62, 0xa3, 0x6f, 0x89, 0x8d, 0xbe, 0x27, 0x36, 0x3a, 0x4e, 0x6c, 0xf4, 0x23, 0xb1, 0xd1, 0xcf,
	0xc4, 0xae, 0x9c, 0x27, 0x36, 0xfa, 0x72, 0x66, 0x57, 0x8e, 0xcf, 0xec, 0xca, 0xc9, 0x99, 0x5d,
	0x79, 0xf3, 0xe8, 0x50, 0x5c, 0xec, 0xc5, 0xc4, 0xf5, 0xef, 0xde, 0x93, 0xb1, 0x65, 0x7f, 0xd2,
	0x3c, 0x42, 0x0f, 0x7f, 0x07, 0x00, 0x00, 0xff, 0xff, 0xd6, 0xa5, 0x06, 0xa7, 0x30, 0x05, 0x00,
	0x00,
}

func (this *ClusterMetadata) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ClusterMetadata)
	if !ok {
		that2, ok := that.(ClusterMetadata)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	if this.HistoryShardCount != that1.HistoryShardCount {
		return false
	}
	if this.ClusterId != that1.ClusterId {
		return false
	}
	if !this.VersionInfo.Equal(that1.VersionInfo) {
		return false
	}
	if len(this.IndexSearchAttributes) != len(that1.IndexSearchAttributes) {
		return false
	}
	for i := range this.IndexSearchAttributes {
		if !this.IndexSearchAttributes[i].Equal(that1.IndexSearchAttributes[i]) {
			return false
		}
	}
	if this.ClusterAddress != that1.ClusterAddress {
		return false
	}
	if this.FailoverVersionIncrement != that1.FailoverVersionIncrement {
		return false
	}
	if this.InitialFailoverVersion != that1.InitialFailoverVersion {
		return false
	}
	if this.IsGlobalNamespaceEnabled != that1.IsGlobalNamespaceEnabled {
		return false
	}
	if this.IsConnectionEnabled != that1.IsConnectionEnabled {
		return false
	}
	return true
}
func (this *IndexSearchAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*IndexSearchAttributes)
	if !ok {
		that2, ok := that.(IndexSearchAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.CustomSearchAttributes) != len(that1.CustomSearchAttributes) {
		return false
	}
	for i := range this.CustomSearchAttributes {
		if this.CustomSearchAttributes[i] != that1.CustomSearchAttributes[i] {
			return false
		}
	}
	return true
}
func (this *ClusterMetadata) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 14)
	s = append(s, "&persistence.ClusterMetadata{")
	s = append(s, "ClusterName: "+fmt.Sprintf("%#v", this.ClusterName)+",\n")
	s = append(s, "HistoryShardCount: "+fmt.Sprintf("%#v", this.HistoryShardCount)+",\n")
	s = append(s, "ClusterId: "+fmt.Sprintf("%#v", this.ClusterId)+",\n")
	if this.VersionInfo != nil {
		s = append(s, "VersionInfo: "+fmt.Sprintf("%#v", this.VersionInfo)+",\n")
	}
	keysForIndexSearchAttributes := make([]string, 0, len(this.IndexSearchAttributes))
	for k, _ := range this.IndexSearchAttributes {
		keysForIndexSearchAttributes = append(keysForIndexSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForIndexSearchAttributes)
	mapStringForIndexSearchAttributes := "map[string]*IndexSearchAttributes{"
	for _, k := range keysForIndexSearchAttributes {
		mapStringForIndexSearchAttributes += fmt.Sprintf("%#v: %#v,", k, this.IndexSearchAttributes[k])
	}
	mapStringForIndexSearchAttributes += "}"
	if this.IndexSearchAttributes != nil {
		s = append(s, "IndexSearchAttributes: "+mapStringForIndexSearchAttributes+",\n")
	}
	s = append(s, "ClusterAddress: "+fmt.Sprintf("%#v", this.ClusterAddress)+",\n")
	s = append(s, "FailoverVersionIncrement: "+fmt.Sprintf("%#v", this.FailoverVersionIncrement)+",\n")
	s = append(s, "InitialFailoverVersion: "+fmt.Sprintf("%#v", this.InitialFailoverVersion)+",\n")
	s = append(s, "IsGlobalNamespaceEnabled: "+fmt.Sprintf("%#v", this.IsGlobalNamespaceEnabled)+",\n")
	s = append(s, "IsConnectionEnabled: "+fmt.Sprintf("%#v", this.IsConnectionEnabled)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *IndexSearchAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&persistence.IndexSearchAttributes{")
	keysForCustomSearchAttributes := make([]string, 0, len(this.CustomSearchAttributes))
	for k, _ := range this.CustomSearchAttributes {
		keysForCustomSearchAttributes = append(keysForCustomSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForCustomSearchAttributes)
	mapStringForCustomSearchAttributes := "map[string]v11.IndexedValueType{"
	for _, k := range keysForCustomSearchAttributes {
		mapStringForCustomSearchAttributes += fmt.Sprintf("%#v: %#v,", k, this.CustomSearchAttributes[k])
	}
	mapStringForCustomSearchAttributes += "}"
	if this.CustomSearchAttributes != nil {
		s = append(s, "CustomSearchAttributes: "+mapStringForCustomSearchAttributes+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringClusterMetadata(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *ClusterMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClusterMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.IsConnectionEnabled {
		i--
		if m.IsConnectionEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.IsGlobalNamespaceEnabled {
		i--
		if m.IsGlobalNamespaceEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.InitialFailoverVersion != 0 {
		i = encodeVarintClusterMetadata(dAtA, i, uint64(m.InitialFailoverVersion))
		i--
		dAtA[i] = 0x40
	}
	if m.FailoverVersionIncrement != 0 {
		i = encodeVarintClusterMetadata(dAtA, i, uint64(m.FailoverVersionIncrement))
		i--
		dAtA[i] = 0x38
	}
	if len(m.ClusterAddress) > 0 {
		i -= len(m.ClusterAddress)
		copy(dAtA[i:], m.ClusterAddress)
		i = encodeVarintClusterMetadata(dAtA, i, uint64(len(m.ClusterAddress)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.IndexSearchAttributes) > 0 {
		for k := range m.IndexSearchAttributes {
			v := m.IndexSearchAttributes[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintClusterMetadata(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintClusterMetadata(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintClusterMetadata(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.VersionInfo != nil {
		{
			size, err := m.VersionInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClusterMetadata(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintClusterMetadata(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.HistoryShardCount != 0 {
		i = encodeVarintClusterMetadata(dAtA, i, uint64(m.HistoryShardCount))
		i--
		dAtA[i] = 0x10
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintClusterMetadata(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IndexSearchAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IndexSearchAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IndexSearchAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.CustomSearchAttributes) > 0 {
		for k := range m.CustomSearchAttributes {
			v := m.CustomSearchAttributes[k]
			baseI := i
			i = encodeVarintClusterMetadata(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintClusterMetadata(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintClusterMetadata(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintClusterMetadata(dAtA []byte, offset int, v uint64) int {
	offset -= sovClusterMetadata(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ClusterMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovClusterMetadata(uint64(l))
	}
	if m.HistoryShardCount != 0 {
		n += 1 + sovClusterMetadata(uint64(m.HistoryShardCount))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovClusterMetadata(uint64(l))
	}
	if m.VersionInfo != nil {
		l = m.VersionInfo.Size()
		n += 1 + l + sovClusterMetadata(uint64(l))
	}
	if len(m.IndexSearchAttributes) > 0 {
		for k, v := range m.IndexSearchAttributes {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovClusterMetadata(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovClusterMetadata(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovClusterMetadata(uint64(mapEntrySize))
		}
	}
	l = len(m.ClusterAddress)
	if l > 0 {
		n += 1 + l + sovClusterMetadata(uint64(l))
	}
	if m.FailoverVersionIncrement != 0 {
		n += 1 + sovClusterMetadata(uint64(m.FailoverVersionIncrement))
	}
	if m.InitialFailoverVersion != 0 {
		n += 1 + sovClusterMetadata(uint64(m.InitialFailoverVersion))
	}
	if m.IsGlobalNamespaceEnabled {
		n += 2
	}
	if m.IsConnectionEnabled {
		n += 2
	}
	return n
}

func (m *IndexSearchAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.CustomSearchAttributes) > 0 {
		for k, v := range m.CustomSearchAttributes {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovClusterMetadata(uint64(len(k))) + 1 + sovClusterMetadata(uint64(v))
			n += mapEntrySize + 1 + sovClusterMetadata(uint64(mapEntrySize))
		}
	}
	return n
}

func sovClusterMetadata(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozClusterMetadata(x uint64) (n int) {
	return sovClusterMetadata(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ClusterMetadata) String() string {
	if this == nil {
		return "nil"
	}
	keysForIndexSearchAttributes := make([]string, 0, len(this.IndexSearchAttributes))
	for k, _ := range this.IndexSearchAttributes {
		keysForIndexSearchAttributes = append(keysForIndexSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForIndexSearchAttributes)
	mapStringForIndexSearchAttributes := "map[string]*IndexSearchAttributes{"
	for _, k := range keysForIndexSearchAttributes {
		mapStringForIndexSearchAttributes += fmt.Sprintf("%v: %v,", k, this.IndexSearchAttributes[k])
	}
	mapStringForIndexSearchAttributes += "}"
	s := strings.Join([]string{`&ClusterMetadata{`,
		`ClusterName:` + fmt.Sprintf("%v", this.ClusterName) + `,`,
		`HistoryShardCount:` + fmt.Sprintf("%v", this.HistoryShardCount) + `,`,
		`ClusterId:` + fmt.Sprintf("%v", this.ClusterId) + `,`,
		`VersionInfo:` + strings.Replace(fmt.Sprintf("%v", this.VersionInfo), "VersionInfo", "v1.VersionInfo", 1) + `,`,
		`IndexSearchAttributes:` + mapStringForIndexSearchAttributes + `,`,
		`ClusterAddress:` + fmt.Sprintf("%v", this.ClusterAddress) + `,`,
		`FailoverVersionIncrement:` + fmt.Sprintf("%v", this.FailoverVersionIncrement) + `,`,
		`InitialFailoverVersion:` + fmt.Sprintf("%v", this.InitialFailoverVersion) + `,`,
		`IsGlobalNamespaceEnabled:` + fmt.Sprintf("%v", this.IsGlobalNamespaceEnabled) + `,`,
		`IsConnectionEnabled:` + fmt.Sprintf("%v", this.IsConnectionEnabled) + `,`,
		`}`,
	}, "")
	return s
}
func (this *IndexSearchAttributes) String() string {
	if this == nil {
		return "nil"
	}
	keysForCustomSearchAttributes := make([]string, 0, len(this.CustomSearchAttributes))
	for k, _ := range this.CustomSearchAttributes {
		keysForCustomSearchAttributes = append(keysForCustomSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForCustomSearchAttributes)
	mapStringForCustomSearchAttributes := "map[string]v11.IndexedValueType{"
	for _, k := range keysForCustomSearchAttributes {
		mapStringForCustomSearchAttributes += fmt.Sprintf("%v: %v,", k, this.CustomSearchAttributes[k])
	}
	mapStringForCustomSearchAttributes += "}"
	s := strings.Join([]string{`&IndexSearchAttributes{`,
		`CustomSearchAttributes:` + mapStringForCustomSearchAttributes + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringClusterMetadata(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ClusterMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClusterMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryShardCount", wireType)
			}
			m.HistoryShardCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HistoryShardCount |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionInfo == nil {
				m.VersionInfo = &v1.VersionInfo{}
			}
			if err := m.VersionInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexSearchAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IndexSearchAttributes == nil {
				m.IndexSearchAttributes = make(map[string]*IndexSearchAttributes)
			}
			var mapkey string
			var mapvalue *IndexSearchAttributes
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowClusterMetadata
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClusterMetadata
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClusterMetadata
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &IndexSearchAttributes{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipClusterMetadata(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.IndexSearchAttributes[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailoverVersionIncrement", wireType)
			}
			m.FailoverVersionIncrement = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FailoverVersionIncrement |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialFailoverVersion", wireType)
			}
			m.InitialFailoverVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitialFailoverVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsGlobalNamespaceEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsGlobalNamespaceEnabled = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsConnectionEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsConnectionEnabled = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipClusterMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IndexSearchAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClusterMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IndexSearchAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IndexSearchAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomSearchAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CustomSearchAttributes == nil {
				m.CustomSearchAttributes = make(map[string]v11.IndexedValueType)
			}
			var mapkey string
			var mapvalue v11.IndexedValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowClusterMetadata
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClusterMetadata
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClusterMetadata
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v11.IndexedValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipClusterMetadata(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CustomSearchAttributes[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClusterMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipClusterMetadata(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowClusterMetadata
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthClusterMetadata
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupClusterMetadata
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthClusterMetadata
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthClusterMetadata        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowClusterMetadata          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupClusterMetadata = fmt.Errorf("proto: unexpected end of group")
)
