// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by MockGen. DO NOT EDIT.
// Source: timer_sequence.go

// Package workflow is a generated GoMock package.
package workflow

import (
	reflect "reflect"
	time "time"

	gomock "github.com/golang/mock/gomock"
)

// MockTimerSequence is a mock of TimerSequence interface.
type MockTimerSequence struct {
	ctrl     *gomock.Controller
	recorder *MockTimerSequenceMockRecorder
}

// MockTimerSequenceMockRecorder is the mock recorder for MockTimerSequence.
type MockTimerSequenceMockRecorder struct {
	mock *MockTimerSequence
}

// NewMockTimerSequence creates a new mock instance.
func NewMockTimerSequence(ctrl *gomock.Controller) *MockTimerSequence {
	mock := &MockTimerSequence{ctrl: ctrl}
	mock.recorder = &MockTimerSequenceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockTimerSequence) EXPECT() *MockTimerSequenceMockRecorder {
	return m.recorder
}

// CreateNextActivityTimer mocks base method.
func (m *MockTimerSequence) CreateNextActivityTimer() (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNextActivityTimer")
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNextActivityTimer indicates an expected call of CreateNextActivityTimer.
func (mr *MockTimerSequenceMockRecorder) CreateNextActivityTimer() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNextActivityTimer", reflect.TypeOf((*MockTimerSequence)(nil).CreateNextActivityTimer))
}

// CreateNextUserTimer mocks base method.
func (m *MockTimerSequence) CreateNextUserTimer() (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNextUserTimer")
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNextUserTimer indicates an expected call of CreateNextUserTimer.
func (mr *MockTimerSequenceMockRecorder) CreateNextUserTimer() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNextUserTimer", reflect.TypeOf((*MockTimerSequence)(nil).CreateNextUserTimer))
}

// IsExpired mocks base method.
func (m *MockTimerSequence) IsExpired(referenceTime time.Time, timerSequenceID TimerSequenceID) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsExpired", referenceTime, timerSequenceID)
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsExpired indicates an expected call of IsExpired.
func (mr *MockTimerSequenceMockRecorder) IsExpired(referenceTime, timerSequenceID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsExpired", reflect.TypeOf((*MockTimerSequence)(nil).IsExpired), referenceTime, timerSequenceID)
}

// LoadAndSortActivityTimers mocks base method.
func (m *MockTimerSequence) LoadAndSortActivityTimers() []TimerSequenceID {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LoadAndSortActivityTimers")
	ret0, _ := ret[0].([]TimerSequenceID)
	return ret0
}

// LoadAndSortActivityTimers indicates an expected call of LoadAndSortActivityTimers.
func (mr *MockTimerSequenceMockRecorder) LoadAndSortActivityTimers() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LoadAndSortActivityTimers", reflect.TypeOf((*MockTimerSequence)(nil).LoadAndSortActivityTimers))
}

// LoadAndSortUserTimers mocks base method.
func (m *MockTimerSequence) LoadAndSortUserTimers() []TimerSequenceID {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LoadAndSortUserTimers")
	ret0, _ := ret[0].([]TimerSequenceID)
	return ret0
}

// LoadAndSortUserTimers indicates an expected call of LoadAndSortUserTimers.
func (mr *MockTimerSequenceMockRecorder) LoadAndSortUserTimers() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LoadAndSortUserTimers", reflect.TypeOf((*MockTimerSequence)(nil).LoadAndSortUserTimers))
}
