// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/persistence/v1/executions.proto

package persistence

import (
	bytes "bytes"
	encoding_binary "encoding/binary"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	v11 "go.temporal.io/api/common/v1"
	v14 "go.temporal.io/api/enums/v1"
	v15 "go.temporal.io/api/failure/v1"
	_ "go.temporal.io/api/history/v1"
	v1 "go.temporal.io/api/workflow/v1"
	v13 "go.temporal.io/server/api/enums/v1"
	v12 "go.temporal.io/server/api/history/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// shard column
type ShardInfo struct {
	ShardId             int32  `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	RangeId             int64  `protobuf:"varint,2,opt,name=range_id,json=rangeId,proto3" json:"range_id,omitempty"`
	Owner               string `protobuf:"bytes,3,opt,name=owner,proto3" json:"owner,omitempty"`
	ReplicationAckLevel int64  `protobuf:"varint,4,opt,name=replication_ack_level,json=replicationAckLevel,proto3" json:"replication_ack_level,omitempty"`
	TransferAckLevel    int64  `protobuf:"varint,5,opt,name=transfer_ack_level,json=transferAckLevel,proto3" json:"transfer_ack_level,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "since" is needed here. --)
	StolenSinceRenew             int32                 `protobuf:"varint,6,opt,name=stolen_since_renew,json=stolenSinceRenew,proto3" json:"stolen_since_renew,omitempty"`
	UpdateTime                   *time.Time            `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3,stdtime" json:"update_time,omitempty"`
	TimerAckLevelTime            *time.Time            `protobuf:"bytes,8,opt,name=timer_ack_level_time,json=timerAckLevelTime,proto3,stdtime" json:"timer_ack_level_time,omitempty"`
	NamespaceNotificationVersion int64                 `protobuf:"varint,9,opt,name=namespace_notification_version,json=namespaceNotificationVersion,proto3" json:"namespace_notification_version,omitempty"`
	ClusterTransferAckLevel      map[string]int64      `protobuf:"bytes,10,rep,name=cluster_transfer_ack_level,json=clusterTransferAckLevel,proto3" json:"cluster_transfer_ack_level,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	ClusterTimerAckLevel         map[string]*time.Time `protobuf:"bytes,11,rep,name=cluster_timer_ack_level,json=clusterTimerAckLevel,proto3,stdtime" json:"cluster_timer_ack_level,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ClusterReplicationLevel      map[string]int64      `protobuf:"bytes,12,rep,name=cluster_replication_level,json=clusterReplicationLevel,proto3" json:"cluster_replication_level,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	ReplicationDlqAckLevel       map[string]int64      `protobuf:"bytes,13,rep,name=replication_dlq_ack_level,json=replicationDlqAckLevel,proto3" json:"replication_dlq_ack_level,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	VisibilityAckLevel           int64                 `protobuf:"varint,14,opt,name=visibility_ack_level,json=visibilityAckLevel,proto3" json:"visibility_ack_level,omitempty"`
	TieredStorageAckLevel        int64                 `protobuf:"varint,15,opt,name=tiered_storage_ack_level,json=tieredStorageAckLevel,proto3" json:"tiered_storage_ack_level,omitempty"`
}

func (m *ShardInfo) Reset()      { *m = ShardInfo{} }
func (*ShardInfo) ProtoMessage() {}
func (*ShardInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{0}
}
func (m *ShardInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ShardInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ShardInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ShardInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardInfo.Merge(m, src)
}
func (m *ShardInfo) XXX_Size() int {
	return m.Size()
}
func (m *ShardInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ShardInfo proto.InternalMessageInfo

func (m *ShardInfo) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *ShardInfo) GetRangeId() int64 {
	if m != nil {
		return m.RangeId
	}
	return 0
}

func (m *ShardInfo) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *ShardInfo) GetReplicationAckLevel() int64 {
	if m != nil {
		return m.ReplicationAckLevel
	}
	return 0
}

func (m *ShardInfo) GetTransferAckLevel() int64 {
	if m != nil {
		return m.TransferAckLevel
	}
	return 0
}

func (m *ShardInfo) GetStolenSinceRenew() int32 {
	if m != nil {
		return m.StolenSinceRenew
	}
	return 0
}

func (m *ShardInfo) GetUpdateTime() *time.Time {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *ShardInfo) GetTimerAckLevelTime() *time.Time {
	if m != nil {
		return m.TimerAckLevelTime
	}
	return nil
}

func (m *ShardInfo) GetNamespaceNotificationVersion() int64 {
	if m != nil {
		return m.NamespaceNotificationVersion
	}
	return 0
}

func (m *ShardInfo) GetClusterTransferAckLevel() map[string]int64 {
	if m != nil {
		return m.ClusterTransferAckLevel
	}
	return nil
}

func (m *ShardInfo) GetClusterTimerAckLevel() map[string]*time.Time {
	if m != nil {
		return m.ClusterTimerAckLevel
	}
	return nil
}

func (m *ShardInfo) GetClusterReplicationLevel() map[string]int64 {
	if m != nil {
		return m.ClusterReplicationLevel
	}
	return nil
}

func (m *ShardInfo) GetReplicationDlqAckLevel() map[string]int64 {
	if m != nil {
		return m.ReplicationDlqAckLevel
	}
	return nil
}

func (m *ShardInfo) GetVisibilityAckLevel() int64 {
	if m != nil {
		return m.VisibilityAckLevel
	}
	return 0
}

func (m *ShardInfo) GetTieredStorageAckLevel() int64 {
	if m != nil {
		return m.TieredStorageAckLevel
	}
	return 0
}

// execution column
type WorkflowExecutionInfo struct {
	NamespaceId                       string         `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId                        string         `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	ParentNamespaceId                 string         `protobuf:"bytes,3,opt,name=parent_namespace_id,json=parentNamespaceId,proto3" json:"parent_namespace_id,omitempty"`
	ParentWorkflowId                  string         `protobuf:"bytes,4,opt,name=parent_workflow_id,json=parentWorkflowId,proto3" json:"parent_workflow_id,omitempty"`
	ParentRunId                       string         `protobuf:"bytes,5,opt,name=parent_run_id,json=parentRunId,proto3" json:"parent_run_id,omitempty"`
	InitiatedId                       int64          `protobuf:"varint,6,opt,name=initiated_id,json=initiatedId,proto3" json:"initiated_id,omitempty"`
	CompletionEventBatchId            int64          `protobuf:"varint,7,opt,name=completion_event_batch_id,json=completionEventBatchId,proto3" json:"completion_event_batch_id,omitempty"`
	TaskQueue                         string         `protobuf:"bytes,9,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	WorkflowTypeName                  string         `protobuf:"bytes,10,opt,name=workflow_type_name,json=workflowTypeName,proto3" json:"workflow_type_name,omitempty"`
	WorkflowExecutionTimeout          *time.Duration `protobuf:"bytes,11,opt,name=workflow_execution_timeout,json=workflowExecutionTimeout,proto3,stdduration" json:"workflow_execution_timeout,omitempty"`
	WorkflowRunTimeout                *time.Duration `protobuf:"bytes,12,opt,name=workflow_run_timeout,json=workflowRunTimeout,proto3,stdduration" json:"workflow_run_timeout,omitempty"`
	DefaultWorkflowTaskTimeout        *time.Duration `protobuf:"bytes,13,opt,name=default_workflow_task_timeout,json=defaultWorkflowTaskTimeout,proto3,stdduration" json:"default_workflow_task_timeout,omitempty"`
	LastEventTaskId                   int64          `protobuf:"varint,17,opt,name=last_event_task_id,json=lastEventTaskId,proto3" json:"last_event_task_id,omitempty"`
	LastFirstEventId                  int64          `protobuf:"varint,18,opt,name=last_first_event_id,json=lastFirstEventId,proto3" json:"last_first_event_id,omitempty"`
	LastWorkflowTaskStartId           int64          `protobuf:"varint,19,opt,name=last_workflow_task_start_id,json=lastWorkflowTaskStartId,proto3" json:"last_workflow_task_start_id,omitempty"`
	StartTime                         *time.Time     `protobuf:"bytes,20,opt,name=start_time,json=startTime,proto3,stdtime" json:"start_time,omitempty"`
	LastUpdateTime                    *time.Time     `protobuf:"bytes,21,opt,name=last_update_time,json=lastUpdateTime,proto3,stdtime" json:"last_update_time,omitempty"`
	WorkflowTaskVersion               int64          `protobuf:"varint,22,opt,name=workflow_task_version,json=workflowTaskVersion,proto3" json:"workflow_task_version,omitempty"`
	WorkflowTaskScheduleId            int64          `protobuf:"varint,23,opt,name=workflow_task_schedule_id,json=workflowTaskScheduleId,proto3" json:"workflow_task_schedule_id,omitempty"`
	WorkflowTaskStartedId             int64          `protobuf:"varint,24,opt,name=workflow_task_started_id,json=workflowTaskStartedId,proto3" json:"workflow_task_started_id,omitempty"`
	WorkflowTaskTimeout               *time.Duration `protobuf:"bytes,25,opt,name=workflow_task_timeout,json=workflowTaskTimeout,proto3,stdduration" json:"workflow_task_timeout,omitempty"`
	WorkflowTaskAttempt               int32          `protobuf:"varint,26,opt,name=workflow_task_attempt,json=workflowTaskAttempt,proto3" json:"workflow_task_attempt,omitempty"`
	WorkflowTaskStartedTime           *time.Time     `protobuf:"bytes,27,opt,name=workflow_task_started_time,json=workflowTaskStartedTime,proto3,stdtime" json:"workflow_task_started_time,omitempty"`
	WorkflowTaskScheduledTime         *time.Time     `protobuf:"bytes,28,opt,name=workflow_task_scheduled_time,json=workflowTaskScheduledTime,proto3,stdtime" json:"workflow_task_scheduled_time,omitempty"`
	CancelRequested                   bool           `protobuf:"varint,29,opt,name=cancel_requested,json=cancelRequested,proto3" json:"cancel_requested,omitempty"`
	WorkflowTaskOriginalScheduledTime *time.Time     `protobuf:"bytes,30,opt,name=workflow_task_original_scheduled_time,json=workflowTaskOriginalScheduledTime,proto3,stdtime" json:"workflow_task_original_scheduled_time,omitempty"`
	WorkflowTaskRequestId             string         `protobuf:"bytes,31,opt,name=workflow_task_request_id,json=workflowTaskRequestId,proto3" json:"workflow_task_request_id,omitempty"`
	CancelRequestId                   string         `protobuf:"bytes,32,opt,name=cancel_request_id,json=cancelRequestId,proto3" json:"cancel_request_id,omitempty"`
	StickyTaskQueue                   string         `protobuf:"bytes,33,opt,name=sticky_task_queue,json=stickyTaskQueue,proto3" json:"sticky_task_queue,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	StickyScheduleToStartTimeout    *time.Duration          `protobuf:"bytes,34,opt,name=sticky_schedule_to_start_timeout,json=stickyScheduleToStartTimeout,proto3,stdduration" json:"sticky_schedule_to_start_timeout,omitempty"`
	Attempt                         int32                   `protobuf:"varint,35,opt,name=attempt,proto3" json:"attempt,omitempty"`
	RetryInitialInterval            *time.Duration          `protobuf:"bytes,36,opt,name=retry_initial_interval,json=retryInitialInterval,proto3,stdduration" json:"retry_initial_interval,omitempty"`
	RetryMaximumInterval            *time.Duration          `protobuf:"bytes,37,opt,name=retry_maximum_interval,json=retryMaximumInterval,proto3,stdduration" json:"retry_maximum_interval,omitempty"`
	RetryMaximumAttempts            int32                   `protobuf:"varint,38,opt,name=retry_maximum_attempts,json=retryMaximumAttempts,proto3" json:"retry_maximum_attempts,omitempty"`
	RetryBackoffCoefficient         float64                 `protobuf:"fixed64,39,opt,name=retry_backoff_coefficient,json=retryBackoffCoefficient,proto3" json:"retry_backoff_coefficient,omitempty"`
	WorkflowExecutionExpirationTime *time.Time              `protobuf:"bytes,40,opt,name=workflow_execution_expiration_time,json=workflowExecutionExpirationTime,proto3,stdtime" json:"workflow_execution_expiration_time,omitempty"`
	RetryNonRetryableErrorTypes     []string                `protobuf:"bytes,41,rep,name=retry_non_retryable_error_types,json=retryNonRetryableErrorTypes,proto3" json:"retry_non_retryable_error_types,omitempty"`
	HasRetryPolicy                  bool                    `protobuf:"varint,42,opt,name=has_retry_policy,json=hasRetryPolicy,proto3" json:"has_retry_policy,omitempty"`
	CronSchedule                    string                  `protobuf:"bytes,43,opt,name=cron_schedule,json=cronSchedule,proto3" json:"cron_schedule,omitempty"`
	SignalCount                     int64                   `protobuf:"varint,46,opt,name=signal_count,json=signalCount,proto3" json:"signal_count,omitempty"`
	AutoResetPoints                 *v1.ResetPoints         `protobuf:"bytes,51,opt,name=auto_reset_points,json=autoResetPoints,proto3" json:"auto_reset_points,omitempty"`
	SearchAttributes                map[string]*v11.Payload `protobuf:"bytes,52,rep,name=search_attributes,json=searchAttributes,proto3" json:"search_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Memo                            map[string]*v11.Payload `protobuf:"bytes,53,rep,name=memo,proto3" json:"memo,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	VersionHistories                *v12.VersionHistories   `protobuf:"bytes,54,opt,name=version_histories,json=versionHistories,proto3" json:"version_histories,omitempty"`
	FirstExecutionRunId             string                  `protobuf:"bytes,55,opt,name=first_execution_run_id,json=firstExecutionRunId,proto3" json:"first_execution_run_id,omitempty"`
	ExecutionStats                  *ExecutionStats         `protobuf:"bytes,56,opt,name=execution_stats,json=executionStats,proto3" json:"execution_stats,omitempty"`
	WorkflowRunExpirationTime       *time.Time              `protobuf:"bytes,57,opt,name=workflow_run_expiration_time,json=workflowRunExpirationTime,proto3,stdtime" json:"workflow_run_expiration_time,omitempty"`
	// Transaction Id of the first event in the last batch of events.
	LastFirstEventTxnId  int64      `protobuf:"varint,58,opt,name=last_first_event_txn_id,json=lastFirstEventTxnId,proto3" json:"last_first_event_txn_id,omitempty"`
	StateTransitionCount int64      `protobuf:"varint,59,opt,name=state_transition_count,json=stateTransitionCount,proto3" json:"state_transition_count,omitempty"`
	ExecutionTime        *time.Time `protobuf:"bytes,60,opt,name=execution_time,json=executionTime,proto3,stdtime" json:"execution_time,omitempty"`
	// If continued-as-new, or retried, or cron, holds the new run id.
	NewExecutionRunId string `protobuf:"bytes,61,opt,name=new_execution_run_id,json=newExecutionRunId,proto3" json:"new_execution_run_id,omitempty"`
}

func (m *WorkflowExecutionInfo) Reset()      { *m = WorkflowExecutionInfo{} }
func (*WorkflowExecutionInfo) ProtoMessage() {}
func (*WorkflowExecutionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{1}
}
func (m *WorkflowExecutionInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WorkflowExecutionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WorkflowExecutionInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WorkflowExecutionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowExecutionInfo.Merge(m, src)
}
func (m *WorkflowExecutionInfo) XXX_Size() int {
	return m.Size()
}
func (m *WorkflowExecutionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowExecutionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowExecutionInfo proto.InternalMessageInfo

func (m *WorkflowExecutionInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetParentNamespaceId() string {
	if m != nil {
		return m.ParentNamespaceId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetParentWorkflowId() string {
	if m != nil {
		return m.ParentWorkflowId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetParentRunId() string {
	if m != nil {
		return m.ParentRunId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetInitiatedId() int64 {
	if m != nil {
		return m.InitiatedId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetCompletionEventBatchId() int64 {
	if m != nil {
		return m.CompletionEventBatchId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetTaskQueue() string {
	if m != nil {
		return m.TaskQueue
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetWorkflowTypeName() string {
	if m != nil {
		return m.WorkflowTypeName
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetWorkflowExecutionTimeout() *time.Duration {
	if m != nil {
		return m.WorkflowExecutionTimeout
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetWorkflowRunTimeout() *time.Duration {
	if m != nil {
		return m.WorkflowRunTimeout
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetDefaultWorkflowTaskTimeout() *time.Duration {
	if m != nil {
		return m.DefaultWorkflowTaskTimeout
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetLastEventTaskId() int64 {
	if m != nil {
		return m.LastEventTaskId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetLastFirstEventId() int64 {
	if m != nil {
		return m.LastFirstEventId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetLastWorkflowTaskStartId() int64 {
	if m != nil {
		return m.LastWorkflowTaskStartId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetStartTime() *time.Time {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetLastUpdateTime() *time.Time {
	if m != nil {
		return m.LastUpdateTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskVersion() int64 {
	if m != nil {
		return m.WorkflowTaskVersion
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskScheduleId() int64 {
	if m != nil {
		return m.WorkflowTaskScheduleId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskStartedId() int64 {
	if m != nil {
		return m.WorkflowTaskStartedId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskTimeout() *time.Duration {
	if m != nil {
		return m.WorkflowTaskTimeout
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskAttempt() int32 {
	if m != nil {
		return m.WorkflowTaskAttempt
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskStartedTime() *time.Time {
	if m != nil {
		return m.WorkflowTaskStartedTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskScheduledTime() *time.Time {
	if m != nil {
		return m.WorkflowTaskScheduledTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetCancelRequested() bool {
	if m != nil {
		return m.CancelRequested
	}
	return false
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskOriginalScheduledTime() *time.Time {
	if m != nil {
		return m.WorkflowTaskOriginalScheduledTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskRequestId() string {
	if m != nil {
		return m.WorkflowTaskRequestId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetCancelRequestId() string {
	if m != nil {
		return m.CancelRequestId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetStickyTaskQueue() string {
	if m != nil {
		return m.StickyTaskQueue
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetStickyScheduleToStartTimeout() *time.Duration {
	if m != nil {
		return m.StickyScheduleToStartTimeout
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetAttempt() int32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetRetryInitialInterval() *time.Duration {
	if m != nil {
		return m.RetryInitialInterval
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetRetryMaximumInterval() *time.Duration {
	if m != nil {
		return m.RetryMaximumInterval
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetRetryMaximumAttempts() int32 {
	if m != nil {
		return m.RetryMaximumAttempts
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetRetryBackoffCoefficient() float64 {
	if m != nil {
		return m.RetryBackoffCoefficient
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetWorkflowExecutionExpirationTime() *time.Time {
	if m != nil {
		return m.WorkflowExecutionExpirationTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetRetryNonRetryableErrorTypes() []string {
	if m != nil {
		return m.RetryNonRetryableErrorTypes
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetHasRetryPolicy() bool {
	if m != nil {
		return m.HasRetryPolicy
	}
	return false
}

func (m *WorkflowExecutionInfo) GetCronSchedule() string {
	if m != nil {
		return m.CronSchedule
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetSignalCount() int64 {
	if m != nil {
		return m.SignalCount
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetAutoResetPoints() *v1.ResetPoints {
	if m != nil {
		return m.AutoResetPoints
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetSearchAttributes() map[string]*v11.Payload {
	if m != nil {
		return m.SearchAttributes
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetMemo() map[string]*v11.Payload {
	if m != nil {
		return m.Memo
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetVersionHistories() *v12.VersionHistories {
	if m != nil {
		return m.VersionHistories
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetFirstExecutionRunId() string {
	if m != nil {
		return m.FirstExecutionRunId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetExecutionStats() *ExecutionStats {
	if m != nil {
		return m.ExecutionStats
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetWorkflowRunExpirationTime() *time.Time {
	if m != nil {
		return m.WorkflowRunExpirationTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetLastFirstEventTxnId() int64 {
	if m != nil {
		return m.LastFirstEventTxnId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetStateTransitionCount() int64 {
	if m != nil {
		return m.StateTransitionCount
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetExecutionTime() *time.Time {
	if m != nil {
		return m.ExecutionTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetNewExecutionRunId() string {
	if m != nil {
		return m.NewExecutionRunId
	}
	return ""
}

type ExecutionStats struct {
	HistorySize int64 `protobuf:"varint,1,opt,name=history_size,json=historySize,proto3" json:"history_size,omitempty"`
}

func (m *ExecutionStats) Reset()      { *m = ExecutionStats{} }
func (*ExecutionStats) ProtoMessage() {}
func (*ExecutionStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{2}
}
func (m *ExecutionStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExecutionStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExecutionStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExecutionStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecutionStats.Merge(m, src)
}
func (m *ExecutionStats) XXX_Size() int {
	return m.Size()
}
func (m *ExecutionStats) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecutionStats.DiscardUnknown(m)
}

var xxx_messageInfo_ExecutionStats proto.InternalMessageInfo

func (m *ExecutionStats) GetHistorySize() int64 {
	if m != nil {
		return m.HistorySize
	}
	return 0
}

// execution_state column
type WorkflowExecutionState struct {
	CreateRequestId string                      `protobuf:"bytes,1,opt,name=create_request_id,json=createRequestId,proto3" json:"create_request_id,omitempty"`
	RunId           string                      `protobuf:"bytes,2,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	State           v13.WorkflowExecutionState  `protobuf:"varint,3,opt,name=state,proto3,enum=temporal.server.api.enums.v1.WorkflowExecutionState" json:"state,omitempty"`
	Status          v14.WorkflowExecutionStatus `protobuf:"varint,4,opt,name=status,proto3,enum=temporal.api.enums.v1.WorkflowExecutionStatus" json:"status,omitempty"`
}

func (m *WorkflowExecutionState) Reset()      { *m = WorkflowExecutionState{} }
func (*WorkflowExecutionState) ProtoMessage() {}
func (*WorkflowExecutionState) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{3}
}
func (m *WorkflowExecutionState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WorkflowExecutionState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WorkflowExecutionState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WorkflowExecutionState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowExecutionState.Merge(m, src)
}
func (m *WorkflowExecutionState) XXX_Size() int {
	return m.Size()
}
func (m *WorkflowExecutionState) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowExecutionState.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowExecutionState proto.InternalMessageInfo

func (m *WorkflowExecutionState) GetCreateRequestId() string {
	if m != nil {
		return m.CreateRequestId
	}
	return ""
}

func (m *WorkflowExecutionState) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *WorkflowExecutionState) GetState() v13.WorkflowExecutionState {
	if m != nil {
		return m.State
	}
	return v13.WORKFLOW_EXECUTION_STATE_UNSPECIFIED
}

func (m *WorkflowExecutionState) GetStatus() v14.WorkflowExecutionStatus {
	if m != nil {
		return m.Status
	}
	return v14.WORKFLOW_EXECUTION_STATUS_UNSPECIFIED
}

// transfer column
type TransferTaskInfo struct {
	NamespaceId             string       `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId              string       `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId                   string       `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	TaskType                v13.TaskType `protobuf:"varint,4,opt,name=task_type,json=taskType,proto3,enum=temporal.server.api.enums.v1.TaskType" json:"task_type,omitempty"`
	TargetNamespaceId       string       `protobuf:"bytes,5,opt,name=target_namespace_id,json=targetNamespaceId,proto3" json:"target_namespace_id,omitempty"`
	TargetWorkflowId        string       `protobuf:"bytes,6,opt,name=target_workflow_id,json=targetWorkflowId,proto3" json:"target_workflow_id,omitempty"`
	TargetRunId             string       `protobuf:"bytes,7,opt,name=target_run_id,json=targetRunId,proto3" json:"target_run_id,omitempty"`
	TaskQueue               string       `protobuf:"bytes,8,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	TargetChildWorkflowOnly bool         `protobuf:"varint,9,opt,name=target_child_workflow_only,json=targetChildWorkflowOnly,proto3" json:"target_child_workflow_only,omitempty"`
	ScheduleId              int64        `protobuf:"varint,10,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	Version                 int64        `protobuf:"varint,11,opt,name=version,proto3" json:"version,omitempty"`
	TaskId                  int64        `protobuf:"varint,12,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	VisibilityTime          *time.Time   `protobuf:"bytes,13,opt,name=visibility_time,json=visibilityTime,proto3,stdtime" json:"visibility_time,omitempty"`
}

func (m *TransferTaskInfo) Reset()      { *m = TransferTaskInfo{} }
func (*TransferTaskInfo) ProtoMessage() {}
func (*TransferTaskInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{4}
}
func (m *TransferTaskInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TransferTaskInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TransferTaskInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TransferTaskInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransferTaskInfo.Merge(m, src)
}
func (m *TransferTaskInfo) XXX_Size() int {
	return m.Size()
}
func (m *TransferTaskInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TransferTaskInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TransferTaskInfo proto.InternalMessageInfo

func (m *TransferTaskInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *TransferTaskInfo) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *TransferTaskInfo) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *TransferTaskInfo) GetTaskType() v13.TaskType {
	if m != nil {
		return m.TaskType
	}
	return v13.TASK_TYPE_UNSPECIFIED
}

func (m *TransferTaskInfo) GetTargetNamespaceId() string {
	if m != nil {
		return m.TargetNamespaceId
	}
	return ""
}

func (m *TransferTaskInfo) GetTargetWorkflowId() string {
	if m != nil {
		return m.TargetWorkflowId
	}
	return ""
}

func (m *TransferTaskInfo) GetTargetRunId() string {
	if m != nil {
		return m.TargetRunId
	}
	return ""
}

func (m *TransferTaskInfo) GetTaskQueue() string {
	if m != nil {
		return m.TaskQueue
	}
	return ""
}

func (m *TransferTaskInfo) GetTargetChildWorkflowOnly() bool {
	if m != nil {
		return m.TargetChildWorkflowOnly
	}
	return false
}

func (m *TransferTaskInfo) GetScheduleId() int64 {
	if m != nil {
		return m.ScheduleId
	}
	return 0
}

func (m *TransferTaskInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *TransferTaskInfo) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *TransferTaskInfo) GetVisibilityTime() *time.Time {
	if m != nil {
		return m.VisibilityTime
	}
	return nil
}

// replication column
type ReplicationTaskInfo struct {
	NamespaceId       string       `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId        string       `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId             string       `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	TaskType          v13.TaskType `protobuf:"varint,4,opt,name=task_type,json=taskType,proto3,enum=temporal.server.api.enums.v1.TaskType" json:"task_type,omitempty"`
	Version           int64        `protobuf:"varint,5,opt,name=version,proto3" json:"version,omitempty"`
	FirstEventId      int64        `protobuf:"varint,6,opt,name=first_event_id,json=firstEventId,proto3" json:"first_event_id,omitempty"`
	NextEventId       int64        `protobuf:"varint,7,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	ScheduledId       int64        `protobuf:"varint,8,opt,name=scheduled_id,json=scheduledId,proto3" json:"scheduled_id,omitempty"`
	BranchToken       []byte       `protobuf:"bytes,11,opt,name=branch_token,json=branchToken,proto3" json:"branch_token,omitempty"`
	NewRunBranchToken []byte       `protobuf:"bytes,13,opt,name=new_run_branch_token,json=newRunBranchToken,proto3" json:"new_run_branch_token,omitempty"`
	TaskId            int64        `protobuf:"varint,15,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	VisibilityTime    *time.Time   `protobuf:"bytes,16,opt,name=visibility_time,json=visibilityTime,proto3,stdtime" json:"visibility_time,omitempty"`
}

func (m *ReplicationTaskInfo) Reset()      { *m = ReplicationTaskInfo{} }
func (*ReplicationTaskInfo) ProtoMessage() {}
func (*ReplicationTaskInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{5}
}
func (m *ReplicationTaskInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicationTaskInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationTaskInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicationTaskInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationTaskInfo.Merge(m, src)
}
func (m *ReplicationTaskInfo) XXX_Size() int {
	return m.Size()
}
func (m *ReplicationTaskInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationTaskInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationTaskInfo proto.InternalMessageInfo

func (m *ReplicationTaskInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ReplicationTaskInfo) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *ReplicationTaskInfo) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *ReplicationTaskInfo) GetTaskType() v13.TaskType {
	if m != nil {
		return m.TaskType
	}
	return v13.TASK_TYPE_UNSPECIFIED
}

func (m *ReplicationTaskInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *ReplicationTaskInfo) GetFirstEventId() int64 {
	if m != nil {
		return m.FirstEventId
	}
	return 0
}

func (m *ReplicationTaskInfo) GetNextEventId() int64 {
	if m != nil {
		return m.NextEventId
	}
	return 0
}

func (m *ReplicationTaskInfo) GetScheduledId() int64 {
	if m != nil {
		return m.ScheduledId
	}
	return 0
}

func (m *ReplicationTaskInfo) GetBranchToken() []byte {
	if m != nil {
		return m.BranchToken
	}
	return nil
}

func (m *ReplicationTaskInfo) GetNewRunBranchToken() []byte {
	if m != nil {
		return m.NewRunBranchToken
	}
	return nil
}

func (m *ReplicationTaskInfo) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *ReplicationTaskInfo) GetVisibilityTime() *time.Time {
	if m != nil {
		return m.VisibilityTime
	}
	return nil
}

// visibility_task_data column
type VisibilityTaskInfo struct {
	NamespaceId    string       `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId     string       `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId          string       `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	TaskType       v13.TaskType `protobuf:"varint,4,opt,name=task_type,json=taskType,proto3,enum=temporal.server.api.enums.v1.TaskType" json:"task_type,omitempty"`
	Version        int64        `protobuf:"varint,5,opt,name=version,proto3" json:"version,omitempty"`
	TaskId         int64        `protobuf:"varint,6,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	VisibilityTime *time.Time   `protobuf:"bytes,7,opt,name=visibility_time,json=visibilityTime,proto3,stdtime" json:"visibility_time,omitempty"`
}

func (m *VisibilityTaskInfo) Reset()      { *m = VisibilityTaskInfo{} }
func (*VisibilityTaskInfo) ProtoMessage() {}
func (*VisibilityTaskInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{6}
}
func (m *VisibilityTaskInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VisibilityTaskInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VisibilityTaskInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VisibilityTaskInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VisibilityTaskInfo.Merge(m, src)
}
func (m *VisibilityTaskInfo) XXX_Size() int {
	return m.Size()
}
func (m *VisibilityTaskInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VisibilityTaskInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VisibilityTaskInfo proto.InternalMessageInfo

func (m *VisibilityTaskInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *VisibilityTaskInfo) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *VisibilityTaskInfo) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *VisibilityTaskInfo) GetTaskType() v13.TaskType {
	if m != nil {
		return m.TaskType
	}
	return v13.TASK_TYPE_UNSPECIFIED
}

func (m *VisibilityTaskInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *VisibilityTaskInfo) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *VisibilityTaskInfo) GetVisibilityTime() *time.Time {
	if m != nil {
		return m.VisibilityTime
	}
	return nil
}

// tiered_storage_task_data column
type TieredStorageTaskInfo struct {
	NamespaceId    string       `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId     string       `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId          string       `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	TaskType       v13.TaskType `protobuf:"varint,4,opt,name=task_type,json=taskType,proto3,enum=temporal.server.api.enums.v1.TaskType" json:"task_type,omitempty"`
	Version        int64        `protobuf:"varint,5,opt,name=version,proto3" json:"version,omitempty"`
	TaskId         int64        `protobuf:"varint,6,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	VisibilityTime *time.Time   `protobuf:"bytes,7,opt,name=visibility_time,json=visibilityTime,proto3,stdtime" json:"visibility_time,omitempty"`
}

func (m *TieredStorageTaskInfo) Reset()      { *m = TieredStorageTaskInfo{} }
func (*TieredStorageTaskInfo) ProtoMessage() {}
func (*TieredStorageTaskInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{7}
}
func (m *TieredStorageTaskInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TieredStorageTaskInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TieredStorageTaskInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TieredStorageTaskInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TieredStorageTaskInfo.Merge(m, src)
}
func (m *TieredStorageTaskInfo) XXX_Size() int {
	return m.Size()
}
func (m *TieredStorageTaskInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TieredStorageTaskInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TieredStorageTaskInfo proto.InternalMessageInfo

func (m *TieredStorageTaskInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *TieredStorageTaskInfo) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *TieredStorageTaskInfo) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *TieredStorageTaskInfo) GetTaskType() v13.TaskType {
	if m != nil {
		return m.TaskType
	}
	return v13.TASK_TYPE_UNSPECIFIED
}

func (m *TieredStorageTaskInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *TieredStorageTaskInfo) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *TieredStorageTaskInfo) GetVisibilityTime() *time.Time {
	if m != nil {
		return m.VisibilityTime
	}
	return nil
}

// timer column
type TimerTaskInfo struct {
	NamespaceId         string                  `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId          string                  `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId               string                  `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	TaskType            v13.TaskType            `protobuf:"varint,4,opt,name=task_type,json=taskType,proto3,enum=temporal.server.api.enums.v1.TaskType" json:"task_type,omitempty"`
	TimeoutType         v14.TimeoutType         `protobuf:"varint,5,opt,name=timeout_type,json=timeoutType,proto3,enum=temporal.api.enums.v1.TimeoutType" json:"timeout_type,omitempty"`
	WorkflowBackoffType v13.WorkflowBackoffType `protobuf:"varint,6,opt,name=workflow_backoff_type,json=workflowBackoffType,proto3,enum=temporal.server.api.enums.v1.WorkflowBackoffType" json:"workflow_backoff_type,omitempty"`
	Version             int64                   `protobuf:"varint,7,opt,name=version,proto3" json:"version,omitempty"`
	ScheduleAttempt     int32                   `protobuf:"varint,8,opt,name=schedule_attempt,json=scheduleAttempt,proto3" json:"schedule_attempt,omitempty"`
	EventId             int64                   `protobuf:"varint,9,opt,name=event_id,json=eventId,proto3" json:"event_id,omitempty"`
	TaskId              int64                   `protobuf:"varint,10,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	VisibilityTime      *time.Time              `protobuf:"bytes,11,opt,name=visibility_time,json=visibilityTime,proto3,stdtime" json:"visibility_time,omitempty"`
}

func (m *TimerTaskInfo) Reset()      { *m = TimerTaskInfo{} }
func (*TimerTaskInfo) ProtoMessage() {}
func (*TimerTaskInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{8}
}
func (m *TimerTaskInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimerTaskInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimerTaskInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimerTaskInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimerTaskInfo.Merge(m, src)
}
func (m *TimerTaskInfo) XXX_Size() int {
	return m.Size()
}
func (m *TimerTaskInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TimerTaskInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TimerTaskInfo proto.InternalMessageInfo

func (m *TimerTaskInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *TimerTaskInfo) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *TimerTaskInfo) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *TimerTaskInfo) GetTaskType() v13.TaskType {
	if m != nil {
		return m.TaskType
	}
	return v13.TASK_TYPE_UNSPECIFIED
}

func (m *TimerTaskInfo) GetTimeoutType() v14.TimeoutType {
	if m != nil {
		return m.TimeoutType
	}
	return v14.TIMEOUT_TYPE_UNSPECIFIED
}

func (m *TimerTaskInfo) GetWorkflowBackoffType() v13.WorkflowBackoffType {
	if m != nil {
		return m.WorkflowBackoffType
	}
	return v13.WORKFLOW_BACKOFF_TYPE_UNSPECIFIED
}

func (m *TimerTaskInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *TimerTaskInfo) GetScheduleAttempt() int32 {
	if m != nil {
		return m.ScheduleAttempt
	}
	return 0
}

func (m *TimerTaskInfo) GetEventId() int64 {
	if m != nil {
		return m.EventId
	}
	return 0
}

func (m *TimerTaskInfo) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *TimerTaskInfo) GetVisibilityTime() *time.Time {
	if m != nil {
		return m.VisibilityTime
	}
	return nil
}

// activity_map column
type ActivityInfo struct {
	Version               int64      `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	ScheduledEventBatchId int64      `protobuf:"varint,2,opt,name=scheduled_event_batch_id,json=scheduledEventBatchId,proto3" json:"scheduled_event_batch_id,omitempty"`
	ScheduledTime         *time.Time `protobuf:"bytes,4,opt,name=scheduled_time,json=scheduledTime,proto3,stdtime" json:"scheduled_time,omitempty"`
	StartedId             int64      `protobuf:"varint,5,opt,name=started_id,json=startedId,proto3" json:"started_id,omitempty"`
	StartedTime           *time.Time `protobuf:"bytes,7,opt,name=started_time,json=startedTime,proto3,stdtime" json:"started_time,omitempty"`
	ActivityId            string     `protobuf:"bytes,8,opt,name=activity_id,json=activityId,proto3" json:"activity_id,omitempty"`
	RequestId             string     `protobuf:"bytes,9,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	ScheduleToStartTimeout *time.Duration `protobuf:"bytes,10,opt,name=schedule_to_start_timeout,json=scheduleToStartTimeout,proto3,stdduration" json:"schedule_to_start_timeout,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	ScheduleToCloseTimeout *time.Duration `protobuf:"bytes,11,opt,name=schedule_to_close_timeout,json=scheduleToCloseTimeout,proto3,stdduration" json:"schedule_to_close_timeout,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	StartToCloseTimeout         *time.Duration `protobuf:"bytes,12,opt,name=start_to_close_timeout,json=startToCloseTimeout,proto3,stdduration" json:"start_to_close_timeout,omitempty"`
	HeartbeatTimeout            *time.Duration `protobuf:"bytes,13,opt,name=heartbeat_timeout,json=heartbeatTimeout,proto3,stdduration" json:"heartbeat_timeout,omitempty"`
	CancelRequested             bool           `protobuf:"varint,14,opt,name=cancel_requested,json=cancelRequested,proto3" json:"cancel_requested,omitempty"`
	CancelRequestId             int64          `protobuf:"varint,15,opt,name=cancel_request_id,json=cancelRequestId,proto3" json:"cancel_request_id,omitempty"`
	TimerTaskStatus             int32          `protobuf:"varint,16,opt,name=timer_task_status,json=timerTaskStatus,proto3" json:"timer_task_status,omitempty"`
	Attempt                     int32          `protobuf:"varint,17,opt,name=attempt,proto3" json:"attempt,omitempty"`
	TaskQueue                   string         `protobuf:"bytes,18,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	StartedIdentity             string         `protobuf:"bytes,19,opt,name=started_identity,json=startedIdentity,proto3" json:"started_identity,omitempty"`
	HasRetryPolicy              bool           `protobuf:"varint,20,opt,name=has_retry_policy,json=hasRetryPolicy,proto3" json:"has_retry_policy,omitempty"`
	RetryInitialInterval        *time.Duration `protobuf:"bytes,21,opt,name=retry_initial_interval,json=retryInitialInterval,proto3,stdduration" json:"retry_initial_interval,omitempty"`
	RetryMaximumInterval        *time.Duration `protobuf:"bytes,22,opt,name=retry_maximum_interval,json=retryMaximumInterval,proto3,stdduration" json:"retry_maximum_interval,omitempty"`
	RetryMaximumAttempts        int32          `protobuf:"varint,23,opt,name=retry_maximum_attempts,json=retryMaximumAttempts,proto3" json:"retry_maximum_attempts,omitempty"`
	RetryExpirationTime         *time.Time     `protobuf:"bytes,24,opt,name=retry_expiration_time,json=retryExpirationTime,proto3,stdtime" json:"retry_expiration_time,omitempty"`
	RetryBackoffCoefficient     float64        `protobuf:"fixed64,25,opt,name=retry_backoff_coefficient,json=retryBackoffCoefficient,proto3" json:"retry_backoff_coefficient,omitempty"`
	RetryNonRetryableErrorTypes []string       `protobuf:"bytes,26,rep,name=retry_non_retryable_error_types,json=retryNonRetryableErrorTypes,proto3" json:"retry_non_retryable_error_types,omitempty"`
	RetryLastFailure            *v15.Failure   `protobuf:"bytes,27,opt,name=retry_last_failure,json=retryLastFailure,proto3" json:"retry_last_failure,omitempty"`
	RetryLastWorkerIdentity     string         `protobuf:"bytes,28,opt,name=retry_last_worker_identity,json=retryLastWorkerIdentity,proto3" json:"retry_last_worker_identity,omitempty"`
	NamespaceId                 string         `protobuf:"bytes,29,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	ScheduleId                  int64          `protobuf:"varint,30,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	LastHeartbeatDetails        *v11.Payloads  `protobuf:"bytes,31,opt,name=last_heartbeat_details,json=lastHeartbeatDetails,proto3" json:"last_heartbeat_details,omitempty"`
	LastHeartbeatUpdateTime     *time.Time     `protobuf:"bytes,32,opt,name=last_heartbeat_update_time,json=lastHeartbeatUpdateTime,proto3,stdtime" json:"last_heartbeat_update_time,omitempty"`
}

func (m *ActivityInfo) Reset()      { *m = ActivityInfo{} }
func (*ActivityInfo) ProtoMessage() {}
func (*ActivityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{9}
}
func (m *ActivityInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ActivityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ActivityInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ActivityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActivityInfo.Merge(m, src)
}
func (m *ActivityInfo) XXX_Size() int {
	return m.Size()
}
func (m *ActivityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ActivityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ActivityInfo proto.InternalMessageInfo

func (m *ActivityInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *ActivityInfo) GetScheduledEventBatchId() int64 {
	if m != nil {
		return m.ScheduledEventBatchId
	}
	return 0
}

func (m *ActivityInfo) GetScheduledTime() *time.Time {
	if m != nil {
		return m.ScheduledTime
	}
	return nil
}

func (m *ActivityInfo) GetStartedId() int64 {
	if m != nil {
		return m.StartedId
	}
	return 0
}

func (m *ActivityInfo) GetStartedTime() *time.Time {
	if m != nil {
		return m.StartedTime
	}
	return nil
}

func (m *ActivityInfo) GetActivityId() string {
	if m != nil {
		return m.ActivityId
	}
	return ""
}

func (m *ActivityInfo) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *ActivityInfo) GetScheduleToStartTimeout() *time.Duration {
	if m != nil {
		return m.ScheduleToStartTimeout
	}
	return nil
}

func (m *ActivityInfo) GetScheduleToCloseTimeout() *time.Duration {
	if m != nil {
		return m.ScheduleToCloseTimeout
	}
	return nil
}

func (m *ActivityInfo) GetStartToCloseTimeout() *time.Duration {
	if m != nil {
		return m.StartToCloseTimeout
	}
	return nil
}

func (m *ActivityInfo) GetHeartbeatTimeout() *time.Duration {
	if m != nil {
		return m.HeartbeatTimeout
	}
	return nil
}

func (m *ActivityInfo) GetCancelRequested() bool {
	if m != nil {
		return m.CancelRequested
	}
	return false
}

func (m *ActivityInfo) GetCancelRequestId() int64 {
	if m != nil {
		return m.CancelRequestId
	}
	return 0
}

func (m *ActivityInfo) GetTimerTaskStatus() int32 {
	if m != nil {
		return m.TimerTaskStatus
	}
	return 0
}

func (m *ActivityInfo) GetAttempt() int32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

func (m *ActivityInfo) GetTaskQueue() string {
	if m != nil {
		return m.TaskQueue
	}
	return ""
}

func (m *ActivityInfo) GetStartedIdentity() string {
	if m != nil {
		return m.StartedIdentity
	}
	return ""
}

func (m *ActivityInfo) GetHasRetryPolicy() bool {
	if m != nil {
		return m.HasRetryPolicy
	}
	return false
}

func (m *ActivityInfo) GetRetryInitialInterval() *time.Duration {
	if m != nil {
		return m.RetryInitialInterval
	}
	return nil
}

func (m *ActivityInfo) GetRetryMaximumInterval() *time.Duration {
	if m != nil {
		return m.RetryMaximumInterval
	}
	return nil
}

func (m *ActivityInfo) GetRetryMaximumAttempts() int32 {
	if m != nil {
		return m.RetryMaximumAttempts
	}
	return 0
}

func (m *ActivityInfo) GetRetryExpirationTime() *time.Time {
	if m != nil {
		return m.RetryExpirationTime
	}
	return nil
}

func (m *ActivityInfo) GetRetryBackoffCoefficient() float64 {
	if m != nil {
		return m.RetryBackoffCoefficient
	}
	return 0
}

func (m *ActivityInfo) GetRetryNonRetryableErrorTypes() []string {
	if m != nil {
		return m.RetryNonRetryableErrorTypes
	}
	return nil
}

func (m *ActivityInfo) GetRetryLastFailure() *v15.Failure {
	if m != nil {
		return m.RetryLastFailure
	}
	return nil
}

func (m *ActivityInfo) GetRetryLastWorkerIdentity() string {
	if m != nil {
		return m.RetryLastWorkerIdentity
	}
	return ""
}

func (m *ActivityInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ActivityInfo) GetScheduleId() int64 {
	if m != nil {
		return m.ScheduleId
	}
	return 0
}

func (m *ActivityInfo) GetLastHeartbeatDetails() *v11.Payloads {
	if m != nil {
		return m.LastHeartbeatDetails
	}
	return nil
}

func (m *ActivityInfo) GetLastHeartbeatUpdateTime() *time.Time {
	if m != nil {
		return m.LastHeartbeatUpdateTime
	}
	return nil
}

// timer_map column
type TimerInfo struct {
	Version    int64      `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	StartedId  int64      `protobuf:"varint,2,opt,name=started_id,json=startedId,proto3" json:"started_id,omitempty"`
	ExpiryTime *time.Time `protobuf:"bytes,3,opt,name=expiry_time,json=expiryTime,proto3,stdtime" json:"expiry_time,omitempty"`
	TaskStatus int64      `protobuf:"varint,4,opt,name=task_status,json=taskStatus,proto3" json:"task_status,omitempty"`
	// timerId serves the purpose of indicating whether a timer task is generated for this timer info.
	TimerId string `protobuf:"bytes,5,opt,name=timer_id,json=timerId,proto3" json:"timer_id,omitempty"`
}

func (m *TimerInfo) Reset()      { *m = TimerInfo{} }
func (*TimerInfo) ProtoMessage() {}
func (*TimerInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{10}
}
func (m *TimerInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimerInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimerInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimerInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimerInfo.Merge(m, src)
}
func (m *TimerInfo) XXX_Size() int {
	return m.Size()
}
func (m *TimerInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TimerInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TimerInfo proto.InternalMessageInfo

func (m *TimerInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *TimerInfo) GetStartedId() int64 {
	if m != nil {
		return m.StartedId
	}
	return 0
}

func (m *TimerInfo) GetExpiryTime() *time.Time {
	if m != nil {
		return m.ExpiryTime
	}
	return nil
}

func (m *TimerInfo) GetTaskStatus() int64 {
	if m != nil {
		return m.TaskStatus
	}
	return 0
}

func (m *TimerInfo) GetTimerId() string {
	if m != nil {
		return m.TimerId
	}
	return ""
}

// child_executions_map column
type ChildExecutionInfo struct {
	Version               int64                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	InitiatedEventBatchId int64                 `protobuf:"varint,2,opt,name=initiated_event_batch_id,json=initiatedEventBatchId,proto3" json:"initiated_event_batch_id,omitempty"`
	StartedId             int64                 `protobuf:"varint,3,opt,name=started_id,json=startedId,proto3" json:"started_id,omitempty"`
	StartedWorkflowId     string                `protobuf:"bytes,5,opt,name=started_workflow_id,json=startedWorkflowId,proto3" json:"started_workflow_id,omitempty"`
	StartedRunId          string                `protobuf:"bytes,6,opt,name=started_run_id,json=startedRunId,proto3" json:"started_run_id,omitempty"`
	CreateRequestId       string                `protobuf:"bytes,8,opt,name=create_request_id,json=createRequestId,proto3" json:"create_request_id,omitempty"`
	Namespace             string                `protobuf:"bytes,9,opt,name=namespace,proto3" json:"namespace,omitempty"`
	WorkflowTypeName      string                `protobuf:"bytes,10,opt,name=workflow_type_name,json=workflowTypeName,proto3" json:"workflow_type_name,omitempty"`
	ParentClosePolicy     v14.ParentClosePolicy `protobuf:"varint,11,opt,name=parent_close_policy,json=parentClosePolicy,proto3,enum=temporal.api.enums.v1.ParentClosePolicy" json:"parent_close_policy,omitempty"`
	InitiatedId           int64                 `protobuf:"varint,12,opt,name=initiated_id,json=initiatedId,proto3" json:"initiated_id,omitempty"`
}

func (m *ChildExecutionInfo) Reset()      { *m = ChildExecutionInfo{} }
func (*ChildExecutionInfo) ProtoMessage() {}
func (*ChildExecutionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{11}
}
func (m *ChildExecutionInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ChildExecutionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ChildExecutionInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ChildExecutionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChildExecutionInfo.Merge(m, src)
}
func (m *ChildExecutionInfo) XXX_Size() int {
	return m.Size()
}
func (m *ChildExecutionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ChildExecutionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ChildExecutionInfo proto.InternalMessageInfo

func (m *ChildExecutionInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *ChildExecutionInfo) GetInitiatedEventBatchId() int64 {
	if m != nil {
		return m.InitiatedEventBatchId
	}
	return 0
}

func (m *ChildExecutionInfo) GetStartedId() int64 {
	if m != nil {
		return m.StartedId
	}
	return 0
}

func (m *ChildExecutionInfo) GetStartedWorkflowId() string {
	if m != nil {
		return m.StartedWorkflowId
	}
	return ""
}

func (m *ChildExecutionInfo) GetStartedRunId() string {
	if m != nil {
		return m.StartedRunId
	}
	return ""
}

func (m *ChildExecutionInfo) GetCreateRequestId() string {
	if m != nil {
		return m.CreateRequestId
	}
	return ""
}

func (m *ChildExecutionInfo) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ChildExecutionInfo) GetWorkflowTypeName() string {
	if m != nil {
		return m.WorkflowTypeName
	}
	return ""
}

func (m *ChildExecutionInfo) GetParentClosePolicy() v14.ParentClosePolicy {
	if m != nil {
		return m.ParentClosePolicy
	}
	return v14.PARENT_CLOSE_POLICY_UNSPECIFIED
}

func (m *ChildExecutionInfo) GetInitiatedId() int64 {
	if m != nil {
		return m.InitiatedId
	}
	return 0
}

// request_cancel_map column
type RequestCancelInfo struct {
	Version               int64  `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	InitiatedEventBatchId int64  `protobuf:"varint,2,opt,name=initiated_event_batch_id,json=initiatedEventBatchId,proto3" json:"initiated_event_batch_id,omitempty"`
	CancelRequestId       string `protobuf:"bytes,3,opt,name=cancel_request_id,json=cancelRequestId,proto3" json:"cancel_request_id,omitempty"`
	InitiatedId           int64  `protobuf:"varint,4,opt,name=initiated_id,json=initiatedId,proto3" json:"initiated_id,omitempty"`
}

func (m *RequestCancelInfo) Reset()      { *m = RequestCancelInfo{} }
func (*RequestCancelInfo) ProtoMessage() {}
func (*RequestCancelInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{12}
}
func (m *RequestCancelInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestCancelInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RequestCancelInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RequestCancelInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestCancelInfo.Merge(m, src)
}
func (m *RequestCancelInfo) XXX_Size() int {
	return m.Size()
}
func (m *RequestCancelInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestCancelInfo.DiscardUnknown(m)
}

var xxx_messageInfo_RequestCancelInfo proto.InternalMessageInfo

func (m *RequestCancelInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *RequestCancelInfo) GetInitiatedEventBatchId() int64 {
	if m != nil {
		return m.InitiatedEventBatchId
	}
	return 0
}

func (m *RequestCancelInfo) GetCancelRequestId() string {
	if m != nil {
		return m.CancelRequestId
	}
	return ""
}

func (m *RequestCancelInfo) GetInitiatedId() int64 {
	if m != nil {
		return m.InitiatedId
	}
	return 0
}

// signal_map column
type SignalInfo struct {
	Version               int64         `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	InitiatedEventBatchId int64         `protobuf:"varint,2,opt,name=initiated_event_batch_id,json=initiatedEventBatchId,proto3" json:"initiated_event_batch_id,omitempty"`
	RequestId             string        `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	Name                  string        `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	Input                 *v11.Payloads `protobuf:"bytes,5,opt,name=input,proto3" json:"input,omitempty"`
	Control               string        `protobuf:"bytes,6,opt,name=control,proto3" json:"control,omitempty"`
	InitiatedId           int64         `protobuf:"varint,7,opt,name=initiated_id,json=initiatedId,proto3" json:"initiated_id,omitempty"`
	Header                *v11.Header   `protobuf:"bytes,8,opt,name=header,proto3" json:"header,omitempty"`
}

func (m *SignalInfo) Reset()      { *m = SignalInfo{} }
func (*SignalInfo) ProtoMessage() {}
func (*SignalInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{13}
}
func (m *SignalInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SignalInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SignalInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SignalInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignalInfo.Merge(m, src)
}
func (m *SignalInfo) XXX_Size() int {
	return m.Size()
}
func (m *SignalInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SignalInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SignalInfo proto.InternalMessageInfo

func (m *SignalInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *SignalInfo) GetInitiatedEventBatchId() int64 {
	if m != nil {
		return m.InitiatedEventBatchId
	}
	return 0
}

func (m *SignalInfo) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *SignalInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SignalInfo) GetInput() *v11.Payloads {
	if m != nil {
		return m.Input
	}
	return nil
}

func (m *SignalInfo) GetControl() string {
	if m != nil {
		return m.Control
	}
	return ""
}

func (m *SignalInfo) GetInitiatedId() int64 {
	if m != nil {
		return m.InitiatedId
	}
	return 0
}

func (m *SignalInfo) GetHeader() *v11.Header {
	if m != nil {
		return m.Header
	}
	return nil
}

// checksum column
type Checksum struct {
	Version int32              `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Flavor  v13.ChecksumFlavor `protobuf:"varint,2,opt,name=flavor,proto3,enum=temporal.server.api.enums.v1.ChecksumFlavor" json:"flavor,omitempty"`
	Value   []byte             `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Checksum) Reset()      { *m = Checksum{} }
func (*Checksum) ProtoMessage() {}
func (*Checksum) Descriptor() ([]byte, []int) {
	return fileDescriptor_67a714d0e7ba9f37, []int{14}
}
func (m *Checksum) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Checksum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Checksum.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Checksum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Checksum.Merge(m, src)
}
func (m *Checksum) XXX_Size() int {
	return m.Size()
}
func (m *Checksum) XXX_DiscardUnknown() {
	xxx_messageInfo_Checksum.DiscardUnknown(m)
}

var xxx_messageInfo_Checksum proto.InternalMessageInfo

func (m *Checksum) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *Checksum) GetFlavor() v13.ChecksumFlavor {
	if m != nil {
		return m.Flavor
	}
	return v13.CHECKSUM_FLAVOR_UNSPECIFIED
}

func (m *Checksum) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func init() {
	proto.RegisterType((*ShardInfo)(nil), "temporal.server.api.persistence.v1.ShardInfo")
	proto.RegisterMapType((map[string]int64)(nil), "temporal.server.api.persistence.v1.ShardInfo.ClusterReplicationLevelEntry")
	proto.RegisterMapType((map[string]*time.Time)(nil), "temporal.server.api.persistence.v1.ShardInfo.ClusterTimerAckLevelEntry")
	proto.RegisterMapType((map[string]int64)(nil), "temporal.server.api.persistence.v1.ShardInfo.ClusterTransferAckLevelEntry")
	proto.RegisterMapType((map[string]int64)(nil), "temporal.server.api.persistence.v1.ShardInfo.ReplicationDlqAckLevelEntry")
	proto.RegisterType((*WorkflowExecutionInfo)(nil), "temporal.server.api.persistence.v1.WorkflowExecutionInfo")
	proto.RegisterMapType((map[string]*v11.Payload)(nil), "temporal.server.api.persistence.v1.WorkflowExecutionInfo.MemoEntry")
	proto.RegisterMapType((map[string]*v11.Payload)(nil), "temporal.server.api.persistence.v1.WorkflowExecutionInfo.SearchAttributesEntry")
	proto.RegisterType((*ExecutionStats)(nil), "temporal.server.api.persistence.v1.ExecutionStats")
	proto.RegisterType((*WorkflowExecutionState)(nil), "temporal.server.api.persistence.v1.WorkflowExecutionState")
	proto.RegisterType((*TransferTaskInfo)(nil), "temporal.server.api.persistence.v1.TransferTaskInfo")
	proto.RegisterType((*ReplicationTaskInfo)(nil), "temporal.server.api.persistence.v1.ReplicationTaskInfo")
	proto.RegisterType((*VisibilityTaskInfo)(nil), "temporal.server.api.persistence.v1.VisibilityTaskInfo")
	proto.RegisterType((*TieredStorageTaskInfo)(nil), "temporal.server.api.persistence.v1.TieredStorageTaskInfo")
	proto.RegisterType((*TimerTaskInfo)(nil), "temporal.server.api.persistence.v1.TimerTaskInfo")
	proto.RegisterType((*ActivityInfo)(nil), "temporal.server.api.persistence.v1.ActivityInfo")
	proto.RegisterType((*TimerInfo)(nil), "temporal.server.api.persistence.v1.TimerInfo")
	proto.RegisterType((*ChildExecutionInfo)(nil), "temporal.server.api.persistence.v1.ChildExecutionInfo")
	proto.RegisterType((*RequestCancelInfo)(nil), "temporal.server.api.persistence.v1.RequestCancelInfo")
	proto.RegisterType((*SignalInfo)(nil), "temporal.server.api.persistence.v1.SignalInfo")
	proto.RegisterType((*Checksum)(nil), "temporal.server.api.persistence.v1.Checksum")
}

func init() {
	proto.RegisterFile("temporal/server/api/persistence/v1/executions.proto", fileDescriptor_67a714d0e7ba9f37)
}

var fileDescriptor_67a714d0e7ba9f37 = []byte{
	// 3234 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x3a, 0x4d, 0x73, 0xdb, 0xd6,
	0xb5, 0xa6, 0x05, 0x89, 0xe0, 0xa1, 0x44, 0x41, 0xd0, 0x17, 0x24, 0xcb, 0x94, 0xcc, 0xd8, 0x89,
	0x9c, 0x38, 0x94, 0x2d, 0x3b, 0xdf, 0x79, 0xf3, 0xc6, 0x96, 0xed, 0x84, 0x9c, 0xc4, 0x71, 0x20,
	0x25, 0xce, 0xe4, 0x4d, 0x86, 0x03, 0x01, 0x57, 0x12, 0x9e, 0x40, 0x80, 0x06, 0x2e, 0x29, 0x33,
	0xf3, 0x16, 0x59, 0xbc, 0x69, 0x17, 0xed, 0x22, 0xd3, 0x4d, 0xbb, 0xed, 0xae, 0xeb, 0xce, 0x64,
	0xdd, 0x45, 0x37, 0x5d, 0x66, 0x99, 0x4d, 0xa7, 0x8d, 0xb2, 0xe9, 0xae, 0xf9, 0x09, 0x9d, 0x7b,
	0xee, 0x05, 0x78, 0x01, 0x42, 0x32, 0xe5, 0xc6, 0x8b, 0xcc, 0x74, 0x07, 0xdc, 0xf3, 0x81, 0x73,
	0xce, 0x3d, 0xf7, 0x7c, 0x5d, 0xc0, 0x4d, 0x4a, 0xda, 0x9d, 0x20, 0xb4, 0xbc, 0x8d, 0x88, 0x84,
	0x3d, 0x12, 0x6e, 0x58, 0x1d, 0x77, 0xa3, 0x43, 0xc2, 0xc8, 0x8d, 0x28, 0xf1, 0x6d, 0xb2, 0xd1,
	0xbb, 0xb1, 0x41, 0x9e, 0x10, 0xbb, 0x4b, 0xdd, 0xc0, 0x8f, 0xea, 0x9d, 0x30, 0xa0, 0x81, 0x5e,
	0x8b, 0x89, 0xea, 0x9c, 0xa8, 0x6e, 0x75, 0xdc, 0xba, 0x44, 0x54, 0xef, 0xdd, 0x58, 0xae, 0xee,
	0x07, 0xc1, 0xbe, 0x47, 0x36, 0x90, 0x62, 0xb7, 0xbb, 0xb7, 0xe1, 0x74, 0x43, 0x8b, 0x31, 0xe1,
	0x3c, 0x96, 0x57, 0xb3, 0x70, 0xea, 0xb6, 0x49, 0x44, 0xad, 0x76, 0x47, 0x20, 0x5c, 0x72, 0x48,
	0x87, 0xf8, 0x0e, 0xf1, 0x6d, 0x97, 0x44, 0x1b, 0xfb, 0xc1, 0x7e, 0x80, 0xeb, 0xf8, 0x24, 0x50,
	0x2e, 0x27, 0xc2, 0x33, 0xa9, 0xed, 0xa0, 0xdd, 0x0e, 0x7c, 0x26, 0x70, 0x9b, 0x44, 0x91, 0xb5,
	0x4f, 0x72, 0xb1, 0x88, 0xdf, 0x6d, 0x47, 0x0c, 0xe9, 0x28, 0x08, 0x0f, 0xf7, 0xbc, 0xe0, 0x48,
	0x60, 0x5d, 0x49, 0x61, 0xed, 0x59, 0xae, 0xd7, 0x0d, 0xc9, 0x30, 0xb3, 0x34, 0xda, 0x81, 0x1b,
	0xd1, 0x20, 0xec, 0x0f, 0xa3, 0xbd, 0x98, 0x42, 0x8b, 0x3f, 0x35, 0x8c, 0x77, 0x35, 0xcf, 0xfc,
	0x89, 0x88, 0x5c, 0x23, 0x81, 0xfa, 0xca, 0xa9, 0xa8, 0x19, 0x6d, 0x5e, 0x3a, 0x15, 0x99, 0x5a,
	0xd1, 0xa1, 0x40, 0xbc, 0x96, 0x87, 0x78, 0x92, 0x5a, 0xb5, 0xdf, 0x96, 0xa1, 0xb4, 0x7d, 0x60,
	0x85, 0x4e, 0xc3, 0xdf, 0x0b, 0xf4, 0x25, 0x50, 0x23, 0xf6, 0xd2, 0x72, 0x1d, 0xa3, 0xb0, 0x56,
	0x58, 0x1f, 0x37, 0x8b, 0xf8, 0xde, 0x70, 0x18, 0x28, 0xb4, 0xfc, 0x7d, 0xc2, 0x40, 0xe7, 0xd7,
	0x0a, 0xeb, 0x63, 0x66, 0x11, 0xdf, 0x1b, 0x8e, 0x3e, 0x07, 0xe3, 0xc1, 0x91, 0x4f, 0x42, 0x63,
	0x6c, 0xad, 0xb0, 0x5e, 0x32, 0xf9, 0x8b, 0xbe, 0x09, 0xf3, 0x21, 0xe9, 0x78, 0xae, 0x8d, 0x3e,
	0xd2, 0xb2, 0xec, 0xc3, 0x96, 0x47, 0x7a, 0xc4, 0x33, 0x14, 0xa4, 0x9e, 0x95, 0x80, 0xb7, 0xed,
	0xc3, 0x0f, 0x18, 0x48, 0xbf, 0x06, 0x3a, 0x0d, 0x2d, 0x3f, 0xda, 0x23, 0xa1, 0x44, 0x30, 0x8e,
	0x04, 0x5a, 0x0c, 0x91, 0xb1, 0x23, 0x1a, 0x78, 0xc4, 0x6f, 0x45, 0xae, 0x6f, 0x93, 0x56, 0x48,
	0x7c, 0x72, 0x64, 0x4c, 0xa0, 0xdc, 0x1a, 0x87, 0x6c, 0x33, 0x80, 0xc9, 0xd6, 0xf5, 0xdb, 0x50,
	0xee, 0x76, 0x1c, 0x8b, 0x92, 0x16, 0xf3, 0x4b, 0xa3, 0xb8, 0x56, 0x58, 0x2f, 0x6f, 0x2e, 0xd7,
	0xb9, 0xd3, 0xd6, 0x63, 0xa7, 0xad, 0xef, 0xc4, 0x4e, 0x7b, 0x47, 0xf9, 0xfa, 0x6f, 0xab, 0x05,
	0x13, 0x38, 0x11, 0x5b, 0xd6, 0x3f, 0x86, 0x39, 0x46, 0x2b, 0xc9, 0xc6, 0x79, 0xa9, 0x23, 0xf2,
	0x9a, 0x41, 0xea, 0x58, 0x7e, 0x64, 0x79, 0x17, 0xaa, 0xbe, 0xd5, 0x26, 0x51, 0xc7, 0xb2, 0x49,
	0xcb, 0x0f, 0xa8, 0xbb, 0x17, 0x1b, 0xac, 0xc7, 0x4e, 0x5f, 0xe0, 0x1b, 0x25, 0xd4, 0x7e, 0x25,
	0xc1, 0x7a, 0x20, 0x21, 0x7d, 0xca, 0x71, 0xf4, 0x5f, 0x16, 0x60, 0xd9, 0xf6, 0xba, 0x11, 0x25,
	0x61, 0x2b, 0xc7, 0x80, 0xb0, 0x36, 0xb6, 0x5e, 0xde, 0x6c, 0xd6, 0x9f, 0x7e, 0xc8, 0xeb, 0x89,
	0x2f, 0xd4, 0xb7, 0x38, 0xbf, 0x9d, 0x8c, 0xd5, 0xef, 0xf9, 0x34, 0xec, 0x9b, 0x8b, 0x76, 0x3e,
	0x54, 0xff, 0xff, 0x02, 0x2c, 0x26, 0x92, 0xa4, 0x6d, 0x65, 0x94, 0x51, 0x8c, 0xf7, 0x9e, 0x4d,
	0x0c, 0xd9, 0x72, 0x28, 0x83, 0xb0, 0xe9, 0x9c, 0x9d, 0x83, 0xa0, 0xff, 0xa2, 0x00, 0x4b, 0xb1,
	0x18, 0xb2, 0x17, 0x72, 0x41, 0x26, 0xff, 0x0d, 0x7b, 0x98, 0x03, 0x6e, 0x39, 0xf6, 0xc8, 0x42,
	0x99, 0x3d, 0x96, 0x64, 0x01, 0x1c, 0xef, 0xb1, 0x64, 0x91, 0x29, 0x14, 0xa4, 0x71, 0x36, 0x41,
	0xa4, 0x6f, 0xdc, 0xf5, 0x1e, 0xa7, 0xf7, 0x65, 0x21, 0xcc, 0x05, 0xea, 0xd7, 0x61, 0xae, 0xe7,
	0x46, 0xee, 0xae, 0xeb, 0xb9, 0xb4, 0x2f, 0x09, 0x50, 0x41, 0xe7, 0xd2, 0x07, 0xb0, 0x84, 0xe2,
	0x0d, 0x30, 0xa8, 0x4b, 0x42, 0xe2, 0xb4, 0x58, 0xe4, 0xb0, 0xf6, 0x89, 0x44, 0x35, 0x8d, 0x54,
	0xf3, 0x1c, 0xbe, 0xcd, 0xc1, 0x31, 0xe1, 0x72, 0x13, 0x56, 0x4e, 0x73, 0x1d, 0x5d, 0x83, 0xb1,
	0x43, 0xd2, 0xc7, 0xf0, 0x52, 0x32, 0xd9, 0x23, 0x8b, 0x1f, 0x3d, 0xcb, 0xeb, 0x12, 0x11, 0x57,
	0xf8, 0xcb, 0xdb, 0xe7, 0xdf, 0x2c, 0x2c, 0xdb, 0xb0, 0x74, 0xe2, 0xfe, 0xe7, 0x30, 0xba, 0x2e,
	0x33, 0x3a, 0xf5, 0x40, 0xca, 0x1f, 0x19, 0x08, 0x9c, 0xbb, 0xb7, 0x67, 0x12, 0xb8, 0x01, 0x17,
	0x4e, 0xd9, 0x9e, 0xb3, 0xb0, 0xaa, 0xfd, 0x66, 0x05, 0xe6, 0x1f, 0x89, 0x1c, 0x70, 0x2f, 0xce,
	0xd7, 0x18, 0xa5, 0x2f, 0xc1, 0xe4, 0x20, 0x66, 0x88, 0x48, 0x5d, 0x32, 0xcb, 0xc9, 0x5a, 0xc3,
	0xd1, 0x57, 0xa1, 0x1c, 0xe7, 0x8f, 0x38, 0x60, 0x97, 0x4c, 0x88, 0x97, 0x1a, 0x8e, 0x5e, 0x87,
	0xd9, 0x8e, 0x15, 0x12, 0x9f, 0xb6, 0x52, 0xac, 0x78, 0x04, 0x9f, 0xe1, 0xa0, 0x07, 0x12, 0xc3,
	0x6b, 0xa0, 0x0b, 0x7c, 0x99, 0xaf, 0x82, 0xe8, 0x1a, 0x87, 0x3c, 0x1a, 0x70, 0xaf, 0xc1, 0x94,
	0xc0, 0x0e, 0xbb, 0x3e, 0x43, 0x1c, 0xe7, 0x22, 0xf2, 0x45, 0xb3, 0xeb, 0x37, 0x1c, 0xa6, 0x85,
	0xeb, 0xbb, 0xd4, 0xb5, 0x28, 0xc1, 0x7c, 0x33, 0x81, 0x06, 0x28, 0x27, 0x6b, 0x0d, 0x47, 0x7f,
	0x0b, 0x96, 0xec, 0xa0, 0xdd, 0xf1, 0x08, 0x1e, 0x1d, 0xd2, 0x63, 0x0c, 0x77, 0x2d, 0x6a, 0x1f,
	0x30, 0xfc, 0x22, 0xe2, 0x2f, 0x0c, 0x10, 0xee, 0x31, 0xf8, 0x1d, 0x06, 0x6e, 0x38, 0xfa, 0x45,
	0x00, 0x96, 0x13, 0x5b, 0x8f, 0xbb, 0xa4, 0x4b, 0x30, 0x86, 0x96, 0xcc, 0x12, 0x5b, 0xf9, 0x98,
	0x2d, 0x30, 0x75, 0x12, 0x3d, 0x68, 0xbf, 0x43, 0xd0, 0x0a, 0x06, 0x70, 0x75, 0x62, 0xc8, 0x4e,
	0xbf, 0x43, 0x98, 0x0d, 0xf4, 0x2f, 0x60, 0x39, 0xc1, 0x4e, 0x4a, 0x27, 0x0c, 0x6f, 0x41, 0x97,
	0x1a, 0x65, 0x74, 0xb6, 0xa5, 0x21, 0x67, 0xbb, 0x2b, 0xca, 0xa3, 0x3b, 0xca, 0xef, 0x58, 0xa0,
	0x32, 0x8e, 0xb2, 0x9b, 0xb9, 0xc3, 0x19, 0xb0, 0xb4, 0x92, 0xb0, 0x67, 0xf6, 0x8a, 0x19, 0x4f,
	0x8e, 0xc6, 0x38, 0xd1, 0xc4, 0xec, 0x26, 0x2c, 0x77, 0xe1, 0xa2, 0x43, 0xf6, 0xac, 0xae, 0x27,
	0xed, 0x17, 0xda, 0x23, 0xe6, 0x3d, 0x35, 0x1a, 0xef, 0x65, 0xc1, 0x25, 0xde, 0xdb, 0x1d, 0x2b,
	0x3a, 0x8c, 0xbf, 0xf1, 0x0a, 0xe8, 0x9e, 0x15, 0x51, 0xb1, 0x2f, 0xc8, 0xdd, 0x75, 0x8c, 0x19,
	0xdc, 0x96, 0x69, 0x06, 0xc1, 0x0d, 0x61, 0x14, 0x0d, 0x47, 0x7f, 0x15, 0x66, 0x11, 0x79, 0xcf,
	0x0d, 0x13, 0x12, 0xd7, 0x31, 0x74, 0x9e, 0xda, 0x19, 0xe8, 0x3e, 0x83, 0x20, 0x49, 0xc3, 0xd1,
	0xdf, 0x85, 0x0b, 0x88, 0x9e, 0x16, 0x3e, 0xa2, 0x56, 0x88, 0x64, 0xb3, 0x48, 0xb6, 0xc8, 0x50,
	0x64, 0xc9, 0xb6, 0x19, 0xbc, 0xe1, 0xe8, 0xff, 0x0d, 0xc0, 0x51, 0x31, 0x3b, 0xcf, 0x8d, 0x98,
	0x9d, 0x4b, 0x48, 0x83, 0x59, 0xb9, 0x09, 0x28, 0x52, 0x4b, 0x2e, 0x18, 0xe6, 0x47, 0x64, 0x53,
	0x61, 0x94, 0x9f, 0x0c, 0x8a, 0x86, 0x4d, 0x98, 0x4f, 0x6b, 0x11, 0x27, 0xf6, 0x05, 0x5e, 0x07,
	0x1d, 0x49, 0x0a, 0xc4, 0xf9, 0xfc, 0x2d, 0x58, 0xca, 0x68, 0x6e, 0x1f, 0x10, 0xa7, 0xeb, 0xe1,
	0x19, 0x5d, 0xe4, 0x8e, 0x2f, 0xd3, 0x6d, 0x0b, 0x70, 0xc3, 0x61, 0x71, 0x3b, 0xc7, 0x68, 0xfc,
	0x88, 0x19, 0x3c, 0x6e, 0x1f, 0x65, 0x4d, 0x86, 0x87, 0x6d, 0x3b, 0x2b, 0x67, 0xec, 0x2a, 0x4b,
	0xa3, 0xb9, 0x4a, 0x4a, 0x91, 0xd8, 0x47, 0x86, 0x94, 0xb7, 0x28, 0xcb, 0x75, 0xd4, 0x58, 0xc6,
	0x2a, 0x2d, 0x45, 0x73, 0x9b, 0x83, 0x52, 0xa7, 0x2d, 0xa5, 0x01, 0x6e, 0xc3, 0x85, 0x11, 0xb7,
	0x61, 0x31, 0x47, 0x4b, 0xdc, 0x0f, 0x0b, 0x56, 0xf2, 0x6d, 0x2b, 0x3e, 0xb0, 0x32, 0xe2, 0x07,
	0x96, 0xf2, 0x36, 0x80, 0x7f, 0xe2, 0x2a, 0x68, 0xb6, 0xe5, 0xdb, 0xc4, 0x6b, 0x85, 0xe4, 0x71,
	0x97, 0x44, 0x94, 0x38, 0xc6, 0xc5, 0xb5, 0xc2, 0xba, 0x6a, 0x4e, 0xf3, 0x75, 0x33, 0x5e, 0xd6,
	0x43, 0xb8, 0x92, 0x96, 0x26, 0x08, 0xdd, 0x7d, 0xd7, 0xb7, 0xbc, 0xac, 0x58, 0xd5, 0x11, 0xc5,
	0xba, 0x24, 0x8b, 0xf5, 0x91, 0x60, 0x96, 0x16, 0x6f, 0xc8, 0x45, 0x84, 0x94, 0xcc, 0x45, 0x56,
	0x31, 0x04, 0xa6, 0x5c, 0x44, 0x08, 0xdb, 0x70, 0xf4, 0x97, 0x61, 0x26, 0xad, 0x17, 0xa3, 0x58,
	0x43, 0x8a, 0xb4, 0x62, 0x1c, 0x37, 0xa2, 0xae, 0x7d, 0xd8, 0x6f, 0x49, 0x71, 0xf8, 0x12, 0xc7,
	0xe5, 0x80, 0x9d, 0x24, 0x1a, 0xef, 0xc3, 0x9a, 0xc0, 0x4d, 0xfc, 0x9c, 0x06, 0xad, 0xc1, 0x11,
	0x66, 0x5e, 0x58, 0x1b, 0xcd, 0x0b, 0x57, 0x38, 0xa3, 0x58, 0xe1, 0x9d, 0x60, 0x3b, 0x3e, 0xd4,
	0xcc, 0x1d, 0x0d, 0x28, 0xc6, 0x0e, 0xf8, 0x02, 0x6f, 0x6f, 0xc4, 0xab, 0xfe, 0x09, 0x2c, 0x84,
	0x84, 0x86, 0xfd, 0x16, 0xcf, 0x3f, 0x5e, 0xcb, 0xf5, 0x29, 0x09, 0x7b, 0x96, 0x67, 0x5c, 0x1e,
	0xed, 0xc3, 0x73, 0x48, 0xde, 0xe0, 0xd4, 0x0d, 0x41, 0x3c, 0x60, 0xdb, 0xb6, 0x9e, 0xb8, 0xed,
	0x6e, 0x7b, 0xc0, 0xf6, 0xca, 0x59, 0xd8, 0x7e, 0xc8, 0xa9, 0x13, 0xb6, 0xb7, 0xb2, 0x6c, 0x85,
	0x1a, 0x91, 0xf1, 0x22, 0xaa, 0x95, 0xa2, 0x12, 0xe7, 0x2a, 0xd2, 0xdf, 0x66, 0xa5, 0x28, 0xa3,
	0xda, 0xb5, 0xec, 0xc3, 0x60, 0x6f, 0xaf, 0x65, 0x07, 0x64, 0x6f, 0xcf, 0xb5, 0x5d, 0xe2, 0x53,
	0xe3, 0xa5, 0xb5, 0xc2, 0x7a, 0xc1, 0x5c, 0x44, 0x84, 0x3b, 0x1c, 0xbe, 0x35, 0x00, 0xeb, 0x6d,
	0xa8, 0xe5, 0xa4, 0x40, 0xf2, 0xa4, 0xe3, 0x72, 0x71, 0xb9, 0x93, 0xae, 0x8f, 0xe8, 0xa4, 0xab,
	0x43, 0xb9, 0xf0, 0x5e, 0xc2, 0x49, 0xb4, 0x45, 0xab, 0x5c, 0x54, 0x3f, 0xf0, 0x5b, 0xf8, 0x64,
	0xed, 0x7a, 0xa4, 0x45, 0xc2, 0x30, 0x08, 0x31, 0x61, 0x47, 0xc6, 0xd5, 0xb5, 0xb1, 0xf5, 0x92,
	0x79, 0x01, 0x81, 0x0f, 0x02, 0xdf, 0x8c, 0x91, 0xee, 0x31, 0x1c, 0x96, 0xba, 0x23, 0x7d, 0x1d,
	0xb4, 0x03, 0x2b, 0xe2, 0xf4, 0xad, 0x4e, 0xe0, 0xb9, 0x76, 0xdf, 0x78, 0x19, 0xcf, 0x61, 0xe5,
	0xc0, 0x8a, 0x90, 0xe2, 0x21, 0xae, 0xea, 0x2f, 0xc0, 0x94, 0x1d, 0x06, 0x7e, 0xe2, 0x7f, 0xc6,
	0x2b, 0xe8, 0xa9, 0x93, 0x6c, 0x31, 0xf6, 0x25, 0x56, 0xb1, 0x44, 0xee, 0x3e, 0x3b, 0x9b, 0x76,
	0xd0, 0xf5, 0xa9, 0x51, 0xe7, 0x15, 0x0b, 0x5f, 0xdb, 0x62, 0x4b, 0xfa, 0xc7, 0x30, 0x63, 0x75,
	0x69, 0xd0, 0x0a, 0x49, 0x44, 0x68, 0xab, 0x13, 0xb8, 0x3e, 0x8d, 0x8c, 0x9b, 0x68, 0x95, 0x2b,
	0x83, 0x2a, 0x9f, 0x95, 0xf7, 0x49, 0x7b, 0xdf, 0xbb, 0x51, 0x37, 0x19, 0xf6, 0x43, 0x44, 0x36,
	0xa7, 0x19, 0xbd, 0xb4, 0xa0, 0xff, 0x1f, 0xcc, 0x44, 0xc4, 0x0a, 0xed, 0x03, 0xb6, 0xc9, 0xa1,
	0xbb, 0xdb, 0xa5, 0x24, 0x32, 0x6e, 0x61, 0xe3, 0xf0, 0xd1, 0x28, 0x8d, 0x43, 0x6e, 0x0d, 0x59,
	0xdf, 0x46, 0x96, 0xb7, 0x13, 0x8e, 0xbc, 0x7d, 0xd0, 0xa2, 0xcc, 0xb2, 0xfe, 0x08, 0x94, 0x36,
	0x69, 0x07, 0xc6, 0x6b, 0xf8, 0xc1, 0xad, 0x67, 0xff, 0xe0, 0x87, 0xa4, 0x1d, 0xf0, 0x8f, 0x20,
	0x43, 0xfd, 0x0b, 0x98, 0x11, 0x89, 0xb0, 0xc5, 0x87, 0x13, 0x2e, 0x89, 0x8c, 0xd7, 0xd1, 0x52,
	0xd7, 0x73, 0xbf, 0x22, 0x46, 0x18, 0xec, 0x0b, 0x22, 0x4d, 0xbe, 0x1f, 0xd3, 0x99, 0x5a, 0x2f,
	0xb3, 0xa2, 0xdf, 0x84, 0x05, 0x51, 0x6a, 0x24, 0xce, 0x2a, 0x4a, 0xd1, 0x37, 0x70, 0x67, 0x67,
	0x11, 0x9a, 0x88, 0xc8, 0x4b, 0xd2, 0xff, 0x81, 0xe9, 0x01, 0x7a, 0x44, 0x2d, 0x1a, 0x19, 0x6f,
	0xa2, 0x44, 0x9b, 0xa3, 0xe8, 0x9d, 0x30, 0xdb, 0x66, 0x94, 0x66, 0x85, 0xa4, 0xde, 0x53, 0x79,
	0x87, 0x89, 0x92, 0x3d, 0x3b, 0x6f, 0x9d, 0x35, 0xef, 0x98, 0xdd, 0xec, 0xa9, 0xb9, 0x05, 0x8b,
	0x43, 0x45, 0x16, 0x7d, 0x82, 0x5a, 0xbf, 0xcd, 0x8b, 0x8d, 0x74, 0xa1, 0xb5, 0xf3, 0x84, 0x69,
	0x7d, 0x0b, 0x16, 0x98, 0xae, 0x84, 0x4f, 0x0e, 0x5c, 0x94, 0x88, 0x3b, 0xf8, 0x3b, 0x48, 0x34,
	0x87, 0xd0, 0x9d, 0x04, 0xc8, 0x3d, 0xfd, 0x3d, 0xa8, 0xa4, 0x4b, 0x61, 0xe3, 0xdd, 0x11, 0x15,
	0x98, 0x22, 0x72, 0x01, 0xac, 0x6f, 0xc0, 0x9c, 0x4f, 0x8e, 0x86, 0xf7, 0xe9, 0xbf, 0x78, 0x2b,
	0xe2, 0x93, 0xa3, 0xf4, 0x2e, 0x2d, 0x3b, 0x30, 0x9f, 0xeb, 0xbd, 0x39, 0xdd, 0xd5, 0x6b, 0xe9,
	0x86, 0x70, 0x35, 0x7d, 0x04, 0xc5, 0x30, 0xae, 0x77, 0xa3, 0xfe, 0xd0, 0xea, 0x7b, 0x81, 0xe5,
	0xc8, 0x9d, 0xdc, 0x67, 0x50, 0x4a, 0x5c, 0xf6, 0x27, 0xe5, 0xdc, 0x54, 0x54, 0x55, 0x2b, 0x35,
	0x15, 0xb5, 0xa2, 0x4d, 0x37, 0x15, 0x75, 0x5a, 0xd3, 0x9a, 0x8a, 0xaa, 0x69, 0x33, 0x4d, 0x45,
	0xbd, 0xa6, 0xbd, 0xda, 0x54, 0xd4, 0x57, 0xb5, 0x7a, 0x53, 0x51, 0x37, 0xb4, 0xeb, 0x4d, 0x45,
	0xbd, 0xae, 0xdd, 0x68, 0x2a, 0xea, 0x0d, 0x6d, 0xb3, 0xa9, 0xa8, 0x9b, 0xda, 0xcd, 0xda, 0x4d,
	0xa8, 0xa4, 0xdd, 0x8c, 0x05, 0x25, 0x71, 0x32, 0x5a, 0x91, 0xfb, 0x25, 0x41, 0x19, 0xc7, 0xcc,
	0xb2, 0x58, 0xdb, 0x76, 0xbf, 0x24, 0xb5, 0x7f, 0x16, 0x60, 0x61, 0xe8, 0x50, 0x32, 0x6a, 0x82,
	0x19, 0x3d, 0x24, 0x6c, 0xf3, 0xa5, 0x8c, 0x5e, 0x10, 0x19, 0x1d, 0x01, 0x83, 0x8c, 0x3e, 0x0f,
	0x13, 0x62, 0x6b, 0x78, 0x3b, 0x39, 0x1e, 0xe2, 0xa1, 0x69, 0xc2, 0x38, 0x3a, 0x08, 0xf6, 0x8e,
	0x95, 0xcd, 0x5b, 0xb9, 0x47, 0x05, 0x07, 0x95, 0xb9, 0xc1, 0x01, 0xe5, 0x30, 0x39, 0x0b, 0xfd,
	0x3e, 0x4c, 0xb0, 0x87, 0x6e, 0x84, 0x9d, 0x65, 0x65, 0xb3, 0x9e, 0x36, 0xeb, 0xe9, 0x5c, 0xba,
	0x91, 0x29, 0xa8, 0x6b, 0xdf, 0x28, 0xa0, 0xc5, 0xd3, 0x07, 0x6c, 0x40, 0x7e, 0xaa, 0xb6, 0x79,
	0x60, 0x83, 0x31, 0xd9, 0x06, 0x5b, 0x50, 0xe2, 0x25, 0x73, 0xbf, 0x43, 0x84, 0xe8, 0x2f, 0x9e,
	0x6e, 0x07, 0x2c, 0x92, 0xfb, 0x1d, 0x62, 0xaa, 0x54, 0x3c, 0xb1, 0x96, 0x9c, 0x5a, 0xe1, 0x3e,
	0xc9, 0xb4, 0xe4, 0xbc, 0x75, 0x9e, 0xe1, 0xa0, 0x4c, 0x4b, 0x2e, 0xf0, 0x65, 0x99, 0x27, 0x78,
	0x0f, 0xcb, 0x21, 0xe9, 0x96, 0x5c, 0x60, 0x0b, 0x05, 0x8a, 0x5c, 0x7d, 0xbe, 0xc8, 0xe3, 0x5f,
	0xba, 0x69, 0x56, 0xb3, 0x4d, 0xf3, 0x3b, 0xb0, 0x2c, 0x58, 0xd8, 0x07, 0xae, 0xe7, 0x0c, 0x3e,
	0x1b, 0xf8, 0x5e, 0x1f, 0x7b, 0x6c, 0xd5, 0x5c, 0xe4, 0x18, 0x5b, 0x0c, 0x21, 0xfe, 0xfa, 0x47,
	0xbe, 0xd7, 0x67, 0xa6, 0x95, 0x9b, 0x18, 0x40, 0x37, 0x85, 0x68, 0xd0, 0xb8, 0x18, 0x50, 0x8c,
	0x3b, 0xa3, 0x32, 0x9f, 0x2f, 0x8b, 0x57, 0x7d, 0x11, 0x8a, 0x71, 0x77, 0x39, 0x89, 0x90, 0x09,
	0xca, 0x9b, 0xca, 0x06, 0x4c, 0x4b, 0x53, 0x2d, 0x0c, 0x42, 0x53, 0xa3, 0x76, 0x69, 0x03, 0x42,
	0x06, 0xe2, 0xc7, 0xb1, 0xf6, 0x6b, 0x05, 0x66, 0xa5, 0xf9, 0xcd, 0xcf, 0xc6, 0x75, 0x24, 0xdb,
	0x8d, 0xa7, 0x6d, 0x77, 0x19, 0x2a, 0x99, 0x96, 0x9b, 0xcf, 0x59, 0x26, 0xf7, 0xe4, 0x76, 0xbb,
	0x06, 0x53, 0x3e, 0x79, 0x22, 0x21, 0xf1, 0xe1, 0x4a, 0x99, 0x2d, 0xc6, 0x38, 0xac, 0xfa, 0x49,
	0x5a, 0x12, 0xd7, 0x41, 0xf7, 0x60, 0xd5, 0x4f, 0xbc, 0xc6, 0x51, 0x76, 0x43, 0xcb, 0xb7, 0x0f,
	0x5a, 0x34, 0x38, 0x24, 0x7c, 0x1f, 0x27, 0xcd, 0x32, 0x5f, 0xdb, 0x61, 0x4b, 0x71, 0xb4, 0x67,
	0x96, 0x48, 0xa1, 0x4e, 0x21, 0x2a, 0x8b, 0xf6, 0x66, 0xd7, 0xbf, 0x23, 0x11, 0x48, 0x9b, 0x3f,
	0xfd, 0xb4, 0xcd, 0xd7, 0x9e, 0x79, 0xf3, 0x4b, 0x1a, 0x34, 0x15, 0x15, 0xb4, 0x72, 0x53, 0x51,
	0x27, 0xb5, 0x29, 0xe1, 0x0e, 0x7f, 0x3c, 0x0f, 0xfa, 0xa7, 0x03, 0xd4, 0x9f, 0xbf, 0x37, 0x48,
	0xc6, 0x9c, 0x78, 0x9a, 0x31, 0x8b, 0xcf, 0x66, 0xcc, 0xda, 0x37, 0xe7, 0x61, 0x7e, 0x47, 0x9e,
	0x0c, 0xff, 0xc7, 0x6e, 0x23, 0xd9, 0xed, 0xf7, 0x0a, 0x4c, 0xe1, 0x94, 0xfb, 0x67, 0x63, 0xaf,
	0x7b, 0x30, 0x29, 0xba, 0x73, 0xce, 0x67, 0x1c, 0xf9, 0xd4, 0x4e, 0xc8, 0xd9, 0xa2, 0x07, 0x47,
	0x1e, 0x65, 0x3a, 0x78, 0xd1, 0x89, 0x34, 0x23, 0x8a, 0x3b, 0x53, 0xe4, 0x37, 0x81, 0xfc, 0x6e,
	0x8c, 0x56, 0x50, 0x88, 0x9e, 0x15, 0xd9, 0x27, 0x63, 0x25, 0x69, 0x51, 0xde, 0xdd, 0x62, 0x7a,
	0x77, 0xaf, 0x82, 0x96, 0xa4, 0xa6, 0x78, 0x3c, 0xa0, 0x62, 0x1f, 0x3d, 0x1d, 0xaf, 0xc7, 0xb3,
	0xa9, 0x25, 0x50, 0x93, 0x18, 0xc9, 0x2f, 0xe6, 0x8a, 0x44, 0xc4, 0x47, 0xc9, 0x47, 0xe0, 0x69,
	0x3e, 0x52, 0x7e, 0x46, 0x1f, 0xf9, 0x55, 0x05, 0x26, 0x6f, 0xdb, 0xd4, 0xed, 0xb9, 0xb4, 0x8f,
	0x2e, 0x22, 0x29, 0x55, 0x48, 0x2b, 0xf5, 0x06, 0x18, 0x83, 0x70, 0x9d, 0x19, 0x9d, 0xf3, 0xbb,
	0x86, 0xf9, 0x04, 0x9e, 0x9a, 0x9c, 0xbf, 0x07, 0x95, 0xcc, 0xe8, 0x49, 0x19, 0xb5, 0xb0, 0x8f,
	0x52, 0x63, 0xa6, 0x8b, 0x62, 0x0a, 0xcb, 0xd3, 0x05, 0x3f, 0x51, 0xa5, 0x28, 0x99, 0x37, 0x6e,
	0xc1, 0x64, 0x6a, 0xb0, 0x37, 0xea, 0xb9, 0x29, 0x47, 0xd2, 0x30, 0x6f, 0x15, 0xca, 0x96, 0xb0,
	0x47, 0x9c, 0x93, 0x4a, 0x26, 0xc4, 0x4b, 0xbc, 0xa4, 0x91, 0x2a, 0x5b, 0x71, 0x0f, 0x10, 0x26,
	0x35, 0xed, 0xe7, 0xb0, 0x74, 0xf2, 0xc8, 0x09, 0x46, 0x1b, 0xd1, 0x2c, 0x44, 0xf9, 0xc3, 0xa6,
	0x0c, 0x6f, 0xdb, 0x0b, 0x22, 0x72, 0xd6, 0x4b, 0x03, 0x89, 0xf7, 0x16, 0xa3, 0x8f, 0x79, 0xef,
	0x60, 0xcf, 0xc6, 0x64, 0xcd, 0x32, 0x1e, 0xf1, 0xd2, 0x60, 0x96, 0x0f, 0xbb, 0xd3, 0x5c, 0x3f,
	0x80, 0x99, 0x03, 0x62, 0x85, 0x74, 0x97, 0x58, 0xf4, 0xac, 0x37, 0x05, 0x5a, 0x42, 0x19, 0x73,
	0xcb, 0x9b, 0x82, 0x56, 0xf2, 0xa7, 0xa0, 0xb9, 0x83, 0x45, 0x9e, 0xee, 0xf3, 0x06, 0x8b, 0xfc,
	0x62, 0x39, 0x9e, 0x0d, 0xb3, 0x76, 0x41, 0xe3, 0xc7, 0x95, 0xc6, 0xf1, 0x93, 0xf7, 0x03, 0xf2,
	0xbc, 0x6f, 0x26, 0x3d, 0xef, 0x4b, 0x97, 0xba, 0x7a, 0xb6, 0xd4, 0x65, 0x21, 0x21, 0xf1, 0x5d,
	0xe2, 0x53, 0x97, 0xf6, 0xf1, 0xd2, 0x01, 0x87, 0x97, 0xc2, 0x83, 0xf9, 0x72, 0xee, 0x90, 0x69,
	0x2e, 0x77, 0xc8, 0x74, 0xf2, 0x8c, 0x71, 0xfe, 0xf9, 0xcc, 0x18, 0x17, 0x9e, 0xcf, 0x8c, 0x71,
	0xf1, 0x94, 0x19, 0xe3, 0x0e, 0xcc, 0x73, 0xaa, 0xec, 0x78, 0xc3, 0x18, 0xf1, 0x78, 0xcf, 0x22,
	0x79, 0x66, 0xb0, 0x71, 0xea, 0xe4, 0x72, 0xe9, 0xf4, 0xc9, 0xe5, 0x08, 0xa3, 0xc4, 0xe5, 0xa7,
	0x8f, 0x12, 0x1f, 0x80, 0xce, 0xb9, 0xf0, 0x01, 0x0b, 0xff, 0x99, 0x48, 0x5c, 0x46, 0xac, 0xa5,
	0x33, 0x9e, 0x00, 0xb2, 0xe4, 0x74, 0x9f, 0x3f, 0x9a, 0x1a, 0xd2, 0x7e, 0x60, 0x45, 0x54, 0xac,
	0xb0, 0x5e, 0x4a, 0xe2, 0xc7, 0xf2, 0x15, 0x09, 0x07, 0xae, 0xb6, 0x82, 0xae, 0xb6, 0x98, 0x50,
	0x3d, 0x42, 0x78, 0xe2, 0x72, 0xd9, 0xc2, 0xe0, 0x62, 0x6e, 0x61, 0x20, 0xb7, 0x5b, 0xd5, 0xa1,
	0x76, 0xeb, 0x53, 0x58, 0xc0, 0x4f, 0x0f, 0x0e, 0xbc, 0x43, 0xa8, 0xe5, 0x7a, 0x11, 0x5e, 0x01,
	0x0c, 0x29, 0x35, 0x34, 0xd1, 0x88, 0xcc, 0x39, 0x46, 0xff, 0x7e, 0x4c, 0x7e, 0x97, 0x53, 0xeb,
	0x5f, 0xc0, 0x72, 0x86, 0xaf, 0x7c, 0x89, 0xb6, 0x36, 0xea, 0xed, 0x4d, 0x8a, 0xf7, 0xe0, 0x36,
	0xad, 0xa9, 0xa8, 0x63, 0x9a, 0xd2, 0x54, 0xd4, 0x09, 0xad, 0x58, 0xfb, 0x73, 0x01, 0x4a, 0x58,
	0x31, 0x3d, 0x25, 0x15, 0xa6, 0x13, 0xd1, 0xf9, 0x6c, 0x22, 0xba, 0x0d, 0x65, 0x74, 0x56, 0x91,
	0x9b, 0xc7, 0x46, 0xfd, 0x31, 0x88, 0x13, 0xc5, 0x69, 0x48, 0x8e, 0x46, 0xfc, 0x0f, 0x27, 0x0c,
	0x30, 0x22, 0x10, 0x2d, 0x81, 0xca, 0x83, 0x56, 0xd2, 0xd0, 0x17, 0xf1, 0xbd, 0xe1, 0xd4, 0xfe,
	0x3a, 0x06, 0x3a, 0xb6, 0xcb, 0xe9, 0x4b, 0xfe, 0x53, 0x33, 0xfb, 0xe0, 0xe2, 0x3c, 0x3f, 0xb3,
	0x27, 0xf0, 0xec, 0x9d, 0xb8, 0x64, 0x87, 0xb1, 0xac, 0x1d, 0xea, 0x30, 0x1b, 0x83, 0xe5, 0x9a,
	0x52, 0xcc, 0x1f, 0x04, 0x48, 0x9a, 0x28, 0x5c, 0x86, 0x4a, 0x8c, 0x2f, 0x4a, 0x4c, 0x3e, 0x7b,
	0x88, 0xd3, 0x3a, 0x9f, 0x29, 0xe4, 0x4e, 0x98, 0xd4, 0xfc, 0x09, 0xd3, 0x0a, 0x94, 0x12, 0x1f,
	0x8e, 0x73, 0x75, 0xb2, 0x70, 0xc6, 0x3b, 0xfb, 0xcf, 0x92, 0x1f, 0x1c, 0x78, 0x7e, 0x14, 0x91,
	0xb9, 0x8c, 0x35, 0xe5, 0xfa, 0x09, 0x35, 0xea, 0x43, 0xa4, 0xc0, 0x9c, 0xc8, 0x63, 0x76, 0xfc,
	0x2b, 0x84, 0xb4, 0x34, 0xf4, 0xe3, 0xc2, 0xe4, 0xd0, 0x8f, 0x0b, 0x4d, 0x45, 0x55, 0xb4, 0xf1,
	0xa6, 0xa2, 0x16, 0x35, 0xb5, 0xf6, 0x4d, 0x01, 0x66, 0x84, 0x8a, 0x5b, 0x98, 0xca, 0x9e, 0xd7,
	0xf6, 0xe6, 0x26, 0xd1, 0xb1, 0xfc, 0xdb, 0xb9, 0xac, 0x0e, 0xca, 0x90, 0x0e, 0xb5, 0x3f, 0x9d,
	0x07, 0xd8, 0xc6, 0xab, 0x8d, 0xe7, 0xe8, 0x8f, 0x43, 0x92, 0x4a, 0xb5, 0x99, 0x0e, 0x0a, 0xee,
	0x30, 0xff, 0xc9, 0x04, 0x9f, 0xf5, 0xd7, 0x61, 0xdc, 0xf5, 0x3b, 0x5d, 0x8a, 0x5e, 0x39, 0x4a,
	0x90, 0xe2, 0xe8, 0x4c, 0x7a, 0x3b, 0xf0, 0x69, 0x18, 0x78, 0xc2, 0x49, 0xe3, 0xd7, 0x21, 0x4b,
	0x14, 0x87, 0x7f, 0x43, 0x79, 0x1d, 0x26, 0x0e, 0x88, 0xe5, 0x90, 0x50, 0xfc, 0xe8, 0x57, 0x3d,
	0xe9, 0xab, 0xef, 0x23, 0x96, 0x29, 0xb0, 0x6b, 0x5f, 0x15, 0x40, 0xdd, 0x3a, 0x20, 0xf6, 0x61,
	0xd4, 0x6d, 0x67, 0xed, 0x37, 0x3e, 0xb0, 0xdf, 0x5d, 0x98, 0xd8, 0xf3, 0xac, 0x5e, 0x10, 0xa2,
	0xb5, 0x2a, 0x9b, 0xd7, 0x4e, 0x6f, 0x78, 0x62, 0x8e, 0xf7, 0x91, 0xc6, 0x14, 0xb4, 0x83, 0x1f,
	0x89, 0xc6, 0x70, 0x92, 0xc2, 0x5f, 0xee, 0xfc, 0xef, 0xb7, 0xdf, 0x57, 0xcf, 0x7d, 0xf7, 0x7d,
	0xf5, 0xdc, 0x8f, 0xdf, 0x57, 0x0b, 0x5f, 0x1d, 0x57, 0x0b, 0x7f, 0x38, 0xae, 0x16, 0xfe, 0x72,
	0x5c, 0x2d, 0x7c, 0x7b, 0x5c, 0x2d, 0xfc, 0xfd, 0xb8, 0x5a, 0xf8, 0xc7, 0x71, 0xf5, 0xdc, 0x8f,
	0xc7, 0xd5, 0xc2, 0xd7, 0x3f, 0x54, 0xcf, 0x7d, 0xfb, 0x43, 0xf5, 0xdc, 0x77, 0x3f, 0x54, 0xcf,
	0x7d, 0x7e, 0x6b, 0x3f, 0x18, 0xc8, 0xe0, 0x06, 0x27, 0xff, 0x48, 0xfc, 0x8e, 0xf4, 0xba, 0x3b,
	0x81, 0xa1, 0xf2, 0xe6, 0xbf, 0x02, 0x00, 0x00, 0xff, 0xff, 0x72, 0x9c, 0x1c, 0xdf, 0x81, 0x2c,
	0x00, 0x00,
}

func (this *ShardInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ShardInfo)
	if !ok {
		that2, ok := that.(ShardInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.RangeId != that1.RangeId {
		return false
	}
	if this.Owner != that1.Owner {
		return false
	}
	if this.ReplicationAckLevel != that1.ReplicationAckLevel {
		return false
	}
	if this.TransferAckLevel != that1.TransferAckLevel {
		return false
	}
	if this.StolenSinceRenew != that1.StolenSinceRenew {
		return false
	}
	if that1.UpdateTime == nil {
		if this.UpdateTime != nil {
			return false
		}
	} else if !this.UpdateTime.Equal(*that1.UpdateTime) {
		return false
	}
	if that1.TimerAckLevelTime == nil {
		if this.TimerAckLevelTime != nil {
			return false
		}
	} else if !this.TimerAckLevelTime.Equal(*that1.TimerAckLevelTime) {
		return false
	}
	if this.NamespaceNotificationVersion != that1.NamespaceNotificationVersion {
		return false
	}
	if len(this.ClusterTransferAckLevel) != len(that1.ClusterTransferAckLevel) {
		return false
	}
	for i := range this.ClusterTransferAckLevel {
		if this.ClusterTransferAckLevel[i] != that1.ClusterTransferAckLevel[i] {
			return false
		}
	}
	if len(this.ClusterTimerAckLevel) != len(that1.ClusterTimerAckLevel) {
		return false
	}
	for i := range this.ClusterTimerAckLevel {
		if !this.ClusterTimerAckLevel[i].Equal(*that1.ClusterTimerAckLevel[i]) {
			return false
		}
	}
	if len(this.ClusterReplicationLevel) != len(that1.ClusterReplicationLevel) {
		return false
	}
	for i := range this.ClusterReplicationLevel {
		if this.ClusterReplicationLevel[i] != that1.ClusterReplicationLevel[i] {
			return false
		}
	}
	if len(this.ReplicationDlqAckLevel) != len(that1.ReplicationDlqAckLevel) {
		return false
	}
	for i := range this.ReplicationDlqAckLevel {
		if this.ReplicationDlqAckLevel[i] != that1.ReplicationDlqAckLevel[i] {
			return false
		}
	}
	if this.VisibilityAckLevel != that1.VisibilityAckLevel {
		return false
	}
	if this.TieredStorageAckLevel != that1.TieredStorageAckLevel {
		return false
	}
	return true
}
func (this *WorkflowExecutionInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WorkflowExecutionInfo)
	if !ok {
		that2, ok := that.(WorkflowExecutionInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.ParentNamespaceId != that1.ParentNamespaceId {
		return false
	}
	if this.ParentWorkflowId != that1.ParentWorkflowId {
		return false
	}
	if this.ParentRunId != that1.ParentRunId {
		return false
	}
	if this.InitiatedId != that1.InitiatedId {
		return false
	}
	if this.CompletionEventBatchId != that1.CompletionEventBatchId {
		return false
	}
	if this.TaskQueue != that1.TaskQueue {
		return false
	}
	if this.WorkflowTypeName != that1.WorkflowTypeName {
		return false
	}
	if this.WorkflowExecutionTimeout != nil && that1.WorkflowExecutionTimeout != nil {
		if *this.WorkflowExecutionTimeout != *that1.WorkflowExecutionTimeout {
			return false
		}
	} else if this.WorkflowExecutionTimeout != nil {
		return false
	} else if that1.WorkflowExecutionTimeout != nil {
		return false
	}
	if this.WorkflowRunTimeout != nil && that1.WorkflowRunTimeout != nil {
		if *this.WorkflowRunTimeout != *that1.WorkflowRunTimeout {
			return false
		}
	} else if this.WorkflowRunTimeout != nil {
		return false
	} else if that1.WorkflowRunTimeout != nil {
		return false
	}
	if this.DefaultWorkflowTaskTimeout != nil && that1.DefaultWorkflowTaskTimeout != nil {
		if *this.DefaultWorkflowTaskTimeout != *that1.DefaultWorkflowTaskTimeout {
			return false
		}
	} else if this.DefaultWorkflowTaskTimeout != nil {
		return false
	} else if that1.DefaultWorkflowTaskTimeout != nil {
		return false
	}
	if this.LastEventTaskId != that1.LastEventTaskId {
		return false
	}
	if this.LastFirstEventId != that1.LastFirstEventId {
		return false
	}
	if this.LastWorkflowTaskStartId != that1.LastWorkflowTaskStartId {
		return false
	}
	if that1.StartTime == nil {
		if this.StartTime != nil {
			return false
		}
	} else if !this.StartTime.Equal(*that1.StartTime) {
		return false
	}
	if that1.LastUpdateTime == nil {
		if this.LastUpdateTime != nil {
			return false
		}
	} else if !this.LastUpdateTime.Equal(*that1.LastUpdateTime) {
		return false
	}
	if this.WorkflowTaskVersion != that1.WorkflowTaskVersion {
		return false
	}
	if this.WorkflowTaskScheduleId != that1.WorkflowTaskScheduleId {
		return false
	}
	if this.WorkflowTaskStartedId != that1.WorkflowTaskStartedId {
		return false
	}
	if this.WorkflowTaskTimeout != nil && that1.WorkflowTaskTimeout != nil {
		if *this.WorkflowTaskTimeout != *that1.WorkflowTaskTimeout {
			return false
		}
	} else if this.WorkflowTaskTimeout != nil {
		return false
	} else if that1.WorkflowTaskTimeout != nil {
		return false
	}
	if this.WorkflowTaskAttempt != that1.WorkflowTaskAttempt {
		return false
	}
	if that1.WorkflowTaskStartedTime == nil {
		if this.WorkflowTaskStartedTime != nil {
			return false
		}
	} else if !this.WorkflowTaskStartedTime.Equal(*that1.WorkflowTaskStartedTime) {
		return false
	}
	if that1.WorkflowTaskScheduledTime == nil {
		if this.WorkflowTaskScheduledTime != nil {
			return false
		}
	} else if !this.WorkflowTaskScheduledTime.Equal(*that1.WorkflowTaskScheduledTime) {
		return false
	}
	if this.CancelRequested != that1.CancelRequested {
		return false
	}
	if that1.WorkflowTaskOriginalScheduledTime == nil {
		if this.WorkflowTaskOriginalScheduledTime != nil {
			return false
		}
	} else if !this.WorkflowTaskOriginalScheduledTime.Equal(*that1.WorkflowTaskOriginalScheduledTime) {
		return false
	}
	if this.WorkflowTaskRequestId != that1.WorkflowTaskRequestId {
		return false
	}
	if this.CancelRequestId != that1.CancelRequestId {
		return false
	}
	if this.StickyTaskQueue != that1.StickyTaskQueue {
		return false
	}
	if this.StickyScheduleToStartTimeout != nil && that1.StickyScheduleToStartTimeout != nil {
		if *this.StickyScheduleToStartTimeout != *that1.StickyScheduleToStartTimeout {
			return false
		}
	} else if this.StickyScheduleToStartTimeout != nil {
		return false
	} else if that1.StickyScheduleToStartTimeout != nil {
		return false
	}
	if this.Attempt != that1.Attempt {
		return false
	}
	if this.RetryInitialInterval != nil && that1.RetryInitialInterval != nil {
		if *this.RetryInitialInterval != *that1.RetryInitialInterval {
			return false
		}
	} else if this.RetryInitialInterval != nil {
		return false
	} else if that1.RetryInitialInterval != nil {
		return false
	}
	if this.RetryMaximumInterval != nil && that1.RetryMaximumInterval != nil {
		if *this.RetryMaximumInterval != *that1.RetryMaximumInterval {
			return false
		}
	} else if this.RetryMaximumInterval != nil {
		return false
	} else if that1.RetryMaximumInterval != nil {
		return false
	}
	if this.RetryMaximumAttempts != that1.RetryMaximumAttempts {
		return false
	}
	if this.RetryBackoffCoefficient != that1.RetryBackoffCoefficient {
		return false
	}
	if that1.WorkflowExecutionExpirationTime == nil {
		if this.WorkflowExecutionExpirationTime != nil {
			return false
		}
	} else if !this.WorkflowExecutionExpirationTime.Equal(*that1.WorkflowExecutionExpirationTime) {
		return false
	}
	if len(this.RetryNonRetryableErrorTypes) != len(that1.RetryNonRetryableErrorTypes) {
		return false
	}
	for i := range this.RetryNonRetryableErrorTypes {
		if this.RetryNonRetryableErrorTypes[i] != that1.RetryNonRetryableErrorTypes[i] {
			return false
		}
	}
	if this.HasRetryPolicy != that1.HasRetryPolicy {
		return false
	}
	if this.CronSchedule != that1.CronSchedule {
		return false
	}
	if this.SignalCount != that1.SignalCount {
		return false
	}
	if !this.AutoResetPoints.Equal(that1.AutoResetPoints) {
		return false
	}
	if len(this.SearchAttributes) != len(that1.SearchAttributes) {
		return false
	}
	for i := range this.SearchAttributes {
		if !this.SearchAttributes[i].Equal(that1.SearchAttributes[i]) {
			return false
		}
	}
	if len(this.Memo) != len(that1.Memo) {
		return false
	}
	for i := range this.Memo {
		if !this.Memo[i].Equal(that1.Memo[i]) {
			return false
		}
	}
	if !this.VersionHistories.Equal(that1.VersionHistories) {
		return false
	}
	if this.FirstExecutionRunId != that1.FirstExecutionRunId {
		return false
	}
	if !this.ExecutionStats.Equal(that1.ExecutionStats) {
		return false
	}
	if that1.WorkflowRunExpirationTime == nil {
		if this.WorkflowRunExpirationTime != nil {
			return false
		}
	} else if !this.WorkflowRunExpirationTime.Equal(*that1.WorkflowRunExpirationTime) {
		return false
	}
	if this.LastFirstEventTxnId != that1.LastFirstEventTxnId {
		return false
	}
	if this.StateTransitionCount != that1.StateTransitionCount {
		return false
	}
	if that1.ExecutionTime == nil {
		if this.ExecutionTime != nil {
			return false
		}
	} else if !this.ExecutionTime.Equal(*that1.ExecutionTime) {
		return false
	}
	if this.NewExecutionRunId != that1.NewExecutionRunId {
		return false
	}
	return true
}
func (this *ExecutionStats) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExecutionStats)
	if !ok {
		that2, ok := that.(ExecutionStats)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.HistorySize != that1.HistorySize {
		return false
	}
	return true
}
func (this *WorkflowExecutionState) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WorkflowExecutionState)
	if !ok {
		that2, ok := that.(WorkflowExecutionState)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.CreateRequestId != that1.CreateRequestId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.State != that1.State {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	return true
}
func (this *TransferTaskInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TransferTaskInfo)
	if !ok {
		that2, ok := that.(TransferTaskInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.TaskType != that1.TaskType {
		return false
	}
	if this.TargetNamespaceId != that1.TargetNamespaceId {
		return false
	}
	if this.TargetWorkflowId != that1.TargetWorkflowId {
		return false
	}
	if this.TargetRunId != that1.TargetRunId {
		return false
	}
	if this.TaskQueue != that1.TaskQueue {
		return false
	}
	if this.TargetChildWorkflowOnly != that1.TargetChildWorkflowOnly {
		return false
	}
	if this.ScheduleId != that1.ScheduleId {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if that1.VisibilityTime == nil {
		if this.VisibilityTime != nil {
			return false
		}
	} else if !this.VisibilityTime.Equal(*that1.VisibilityTime) {
		return false
	}
	return true
}
func (this *ReplicationTaskInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationTaskInfo)
	if !ok {
		that2, ok := that.(ReplicationTaskInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.TaskType != that1.TaskType {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.FirstEventId != that1.FirstEventId {
		return false
	}
	if this.NextEventId != that1.NextEventId {
		return false
	}
	if this.ScheduledId != that1.ScheduledId {
		return false
	}
	if !bytes.Equal(this.BranchToken, that1.BranchToken) {
		return false
	}
	if !bytes.Equal(this.NewRunBranchToken, that1.NewRunBranchToken) {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if that1.VisibilityTime == nil {
		if this.VisibilityTime != nil {
			return false
		}
	} else if !this.VisibilityTime.Equal(*that1.VisibilityTime) {
		return false
	}
	return true
}
func (this *VisibilityTaskInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*VisibilityTaskInfo)
	if !ok {
		that2, ok := that.(VisibilityTaskInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.TaskType != that1.TaskType {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if that1.VisibilityTime == nil {
		if this.VisibilityTime != nil {
			return false
		}
	} else if !this.VisibilityTime.Equal(*that1.VisibilityTime) {
		return false
	}
	return true
}
func (this *TieredStorageTaskInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TieredStorageTaskInfo)
	if !ok {
		that2, ok := that.(TieredStorageTaskInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.TaskType != that1.TaskType {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if that1.VisibilityTime == nil {
		if this.VisibilityTime != nil {
			return false
		}
	} else if !this.VisibilityTime.Equal(*that1.VisibilityTime) {
		return false
	}
	return true
}
func (this *TimerTaskInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TimerTaskInfo)
	if !ok {
		that2, ok := that.(TimerTaskInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.TaskType != that1.TaskType {
		return false
	}
	if this.TimeoutType != that1.TimeoutType {
		return false
	}
	if this.WorkflowBackoffType != that1.WorkflowBackoffType {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.ScheduleAttempt != that1.ScheduleAttempt {
		return false
	}
	if this.EventId != that1.EventId {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if that1.VisibilityTime == nil {
		if this.VisibilityTime != nil {
			return false
		}
	} else if !this.VisibilityTime.Equal(*that1.VisibilityTime) {
		return false
	}
	return true
}
func (this *ActivityInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ActivityInfo)
	if !ok {
		that2, ok := that.(ActivityInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.ScheduledEventBatchId != that1.ScheduledEventBatchId {
		return false
	}
	if that1.ScheduledTime == nil {
		if this.ScheduledTime != nil {
			return false
		}
	} else if !this.ScheduledTime.Equal(*that1.ScheduledTime) {
		return false
	}
	if this.StartedId != that1.StartedId {
		return false
	}
	if that1.StartedTime == nil {
		if this.StartedTime != nil {
			return false
		}
	} else if !this.StartedTime.Equal(*that1.StartedTime) {
		return false
	}
	if this.ActivityId != that1.ActivityId {
		return false
	}
	if this.RequestId != that1.RequestId {
		return false
	}
	if this.ScheduleToStartTimeout != nil && that1.ScheduleToStartTimeout != nil {
		if *this.ScheduleToStartTimeout != *that1.ScheduleToStartTimeout {
			return false
		}
	} else if this.ScheduleToStartTimeout != nil {
		return false
	} else if that1.ScheduleToStartTimeout != nil {
		return false
	}
	if this.ScheduleToCloseTimeout != nil && that1.ScheduleToCloseTimeout != nil {
		if *this.ScheduleToCloseTimeout != *that1.ScheduleToCloseTimeout {
			return false
		}
	} else if this.ScheduleToCloseTimeout != nil {
		return false
	} else if that1.ScheduleToCloseTimeout != nil {
		return false
	}
	if this.StartToCloseTimeout != nil && that1.StartToCloseTimeout != nil {
		if *this.StartToCloseTimeout != *that1.StartToCloseTimeout {
			return false
		}
	} else if this.StartToCloseTimeout != nil {
		return false
	} else if that1.StartToCloseTimeout != nil {
		return false
	}
	if this.HeartbeatTimeout != nil && that1.HeartbeatTimeout != nil {
		if *this.HeartbeatTimeout != *that1.HeartbeatTimeout {
			return false
		}
	} else if this.HeartbeatTimeout != nil {
		return false
	} else if that1.HeartbeatTimeout != nil {
		return false
	}
	if this.CancelRequested != that1.CancelRequested {
		return false
	}
	if this.CancelRequestId != that1.CancelRequestId {
		return false
	}
	if this.TimerTaskStatus != that1.TimerTaskStatus {
		return false
	}
	if this.Attempt != that1.Attempt {
		return false
	}
	if this.TaskQueue != that1.TaskQueue {
		return false
	}
	if this.StartedIdentity != that1.StartedIdentity {
		return false
	}
	if this.HasRetryPolicy != that1.HasRetryPolicy {
		return false
	}
	if this.RetryInitialInterval != nil && that1.RetryInitialInterval != nil {
		if *this.RetryInitialInterval != *that1.RetryInitialInterval {
			return false
		}
	} else if this.RetryInitialInterval != nil {
		return false
	} else if that1.RetryInitialInterval != nil {
		return false
	}
	if this.RetryMaximumInterval != nil && that1.RetryMaximumInterval != nil {
		if *this.RetryMaximumInterval != *that1.RetryMaximumInterval {
			return false
		}
	} else if this.RetryMaximumInterval != nil {
		return false
	} else if that1.RetryMaximumInterval != nil {
		return false
	}
	if this.RetryMaximumAttempts != that1.RetryMaximumAttempts {
		return false
	}
	if that1.RetryExpirationTime == nil {
		if this.RetryExpirationTime != nil {
			return false
		}
	} else if !this.RetryExpirationTime.Equal(*that1.RetryExpirationTime) {
		return false
	}
	if this.RetryBackoffCoefficient != that1.RetryBackoffCoefficient {
		return false
	}
	if len(this.RetryNonRetryableErrorTypes) != len(that1.RetryNonRetryableErrorTypes) {
		return false
	}
	for i := range this.RetryNonRetryableErrorTypes {
		if this.RetryNonRetryableErrorTypes[i] != that1.RetryNonRetryableErrorTypes[i] {
			return false
		}
	}
	if !this.RetryLastFailure.Equal(that1.RetryLastFailure) {
		return false
	}
	if this.RetryLastWorkerIdentity != that1.RetryLastWorkerIdentity {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.ScheduleId != that1.ScheduleId {
		return false
	}
	if !this.LastHeartbeatDetails.Equal(that1.LastHeartbeatDetails) {
		return false
	}
	if that1.LastHeartbeatUpdateTime == nil {
		if this.LastHeartbeatUpdateTime != nil {
			return false
		}
	} else if !this.LastHeartbeatUpdateTime.Equal(*that1.LastHeartbeatUpdateTime) {
		return false
	}
	return true
}
func (this *TimerInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TimerInfo)
	if !ok {
		that2, ok := that.(TimerInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.StartedId != that1.StartedId {
		return false
	}
	if that1.ExpiryTime == nil {
		if this.ExpiryTime != nil {
			return false
		}
	} else if !this.ExpiryTime.Equal(*that1.ExpiryTime) {
		return false
	}
	if this.TaskStatus != that1.TaskStatus {
		return false
	}
	if this.TimerId != that1.TimerId {
		return false
	}
	return true
}
func (this *ChildExecutionInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ChildExecutionInfo)
	if !ok {
		that2, ok := that.(ChildExecutionInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.InitiatedEventBatchId != that1.InitiatedEventBatchId {
		return false
	}
	if this.StartedId != that1.StartedId {
		return false
	}
	if this.StartedWorkflowId != that1.StartedWorkflowId {
		return false
	}
	if this.StartedRunId != that1.StartedRunId {
		return false
	}
	if this.CreateRequestId != that1.CreateRequestId {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.WorkflowTypeName != that1.WorkflowTypeName {
		return false
	}
	if this.ParentClosePolicy != that1.ParentClosePolicy {
		return false
	}
	if this.InitiatedId != that1.InitiatedId {
		return false
	}
	return true
}
func (this *RequestCancelInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RequestCancelInfo)
	if !ok {
		that2, ok := that.(RequestCancelInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.InitiatedEventBatchId != that1.InitiatedEventBatchId {
		return false
	}
	if this.CancelRequestId != that1.CancelRequestId {
		return false
	}
	if this.InitiatedId != that1.InitiatedId {
		return false
	}
	return true
}
func (this *SignalInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SignalInfo)
	if !ok {
		that2, ok := that.(SignalInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.InitiatedEventBatchId != that1.InitiatedEventBatchId {
		return false
	}
	if this.RequestId != that1.RequestId {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.Input.Equal(that1.Input) {
		return false
	}
	if this.Control != that1.Control {
		return false
	}
	if this.InitiatedId != that1.InitiatedId {
		return false
	}
	if !this.Header.Equal(that1.Header) {
		return false
	}
	return true
}
func (this *Checksum) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Checksum)
	if !ok {
		that2, ok := that.(Checksum)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.Flavor != that1.Flavor {
		return false
	}
	if !bytes.Equal(this.Value, that1.Value) {
		return false
	}
	return true
}
func (this *ShardInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 19)
	s = append(s, "&persistence.ShardInfo{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "RangeId: "+fmt.Sprintf("%#v", this.RangeId)+",\n")
	s = append(s, "Owner: "+fmt.Sprintf("%#v", this.Owner)+",\n")
	s = append(s, "ReplicationAckLevel: "+fmt.Sprintf("%#v", this.ReplicationAckLevel)+",\n")
	s = append(s, "TransferAckLevel: "+fmt.Sprintf("%#v", this.TransferAckLevel)+",\n")
	s = append(s, "StolenSinceRenew: "+fmt.Sprintf("%#v", this.StolenSinceRenew)+",\n")
	s = append(s, "UpdateTime: "+fmt.Sprintf("%#v", this.UpdateTime)+",\n")
	s = append(s, "TimerAckLevelTime: "+fmt.Sprintf("%#v", this.TimerAckLevelTime)+",\n")
	s = append(s, "NamespaceNotificationVersion: "+fmt.Sprintf("%#v", this.NamespaceNotificationVersion)+",\n")
	keysForClusterTransferAckLevel := make([]string, 0, len(this.ClusterTransferAckLevel))
	for k, _ := range this.ClusterTransferAckLevel {
		keysForClusterTransferAckLevel = append(keysForClusterTransferAckLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterTransferAckLevel)
	mapStringForClusterTransferAckLevel := "map[string]int64{"
	for _, k := range keysForClusterTransferAckLevel {
		mapStringForClusterTransferAckLevel += fmt.Sprintf("%#v: %#v,", k, this.ClusterTransferAckLevel[k])
	}
	mapStringForClusterTransferAckLevel += "}"
	if this.ClusterTransferAckLevel != nil {
		s = append(s, "ClusterTransferAckLevel: "+mapStringForClusterTransferAckLevel+",\n")
	}
	keysForClusterTimerAckLevel := make([]string, 0, len(this.ClusterTimerAckLevel))
	for k, _ := range this.ClusterTimerAckLevel {
		keysForClusterTimerAckLevel = append(keysForClusterTimerAckLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterTimerAckLevel)
	mapStringForClusterTimerAckLevel := "map[string]*time.Time{"
	for _, k := range keysForClusterTimerAckLevel {
		mapStringForClusterTimerAckLevel += fmt.Sprintf("%#v: %#v,", k, this.ClusterTimerAckLevel[k])
	}
	mapStringForClusterTimerAckLevel += "}"
	if this.ClusterTimerAckLevel != nil {
		s = append(s, "ClusterTimerAckLevel: "+mapStringForClusterTimerAckLevel+",\n")
	}
	keysForClusterReplicationLevel := make([]string, 0, len(this.ClusterReplicationLevel))
	for k, _ := range this.ClusterReplicationLevel {
		keysForClusterReplicationLevel = append(keysForClusterReplicationLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterReplicationLevel)
	mapStringForClusterReplicationLevel := "map[string]int64{"
	for _, k := range keysForClusterReplicationLevel {
		mapStringForClusterReplicationLevel += fmt.Sprintf("%#v: %#v,", k, this.ClusterReplicationLevel[k])
	}
	mapStringForClusterReplicationLevel += "}"
	if this.ClusterReplicationLevel != nil {
		s = append(s, "ClusterReplicationLevel: "+mapStringForClusterReplicationLevel+",\n")
	}
	keysForReplicationDlqAckLevel := make([]string, 0, len(this.ReplicationDlqAckLevel))
	for k, _ := range this.ReplicationDlqAckLevel {
		keysForReplicationDlqAckLevel = append(keysForReplicationDlqAckLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForReplicationDlqAckLevel)
	mapStringForReplicationDlqAckLevel := "map[string]int64{"
	for _, k := range keysForReplicationDlqAckLevel {
		mapStringForReplicationDlqAckLevel += fmt.Sprintf("%#v: %#v,", k, this.ReplicationDlqAckLevel[k])
	}
	mapStringForReplicationDlqAckLevel += "}"
	if this.ReplicationDlqAckLevel != nil {
		s = append(s, "ReplicationDlqAckLevel: "+mapStringForReplicationDlqAckLevel+",\n")
	}
	s = append(s, "VisibilityAckLevel: "+fmt.Sprintf("%#v", this.VisibilityAckLevel)+",\n")
	s = append(s, "TieredStorageAckLevel: "+fmt.Sprintf("%#v", this.TieredStorageAckLevel)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WorkflowExecutionInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 55)
	s = append(s, "&persistence.WorkflowExecutionInfo{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "ParentNamespaceId: "+fmt.Sprintf("%#v", this.ParentNamespaceId)+",\n")
	s = append(s, "ParentWorkflowId: "+fmt.Sprintf("%#v", this.ParentWorkflowId)+",\n")
	s = append(s, "ParentRunId: "+fmt.Sprintf("%#v", this.ParentRunId)+",\n")
	s = append(s, "InitiatedId: "+fmt.Sprintf("%#v", this.InitiatedId)+",\n")
	s = append(s, "CompletionEventBatchId: "+fmt.Sprintf("%#v", this.CompletionEventBatchId)+",\n")
	s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	s = append(s, "WorkflowTypeName: "+fmt.Sprintf("%#v", this.WorkflowTypeName)+",\n")
	s = append(s, "WorkflowExecutionTimeout: "+fmt.Sprintf("%#v", this.WorkflowExecutionTimeout)+",\n")
	s = append(s, "WorkflowRunTimeout: "+fmt.Sprintf("%#v", this.WorkflowRunTimeout)+",\n")
	s = append(s, "DefaultWorkflowTaskTimeout: "+fmt.Sprintf("%#v", this.DefaultWorkflowTaskTimeout)+",\n")
	s = append(s, "LastEventTaskId: "+fmt.Sprintf("%#v", this.LastEventTaskId)+",\n")
	s = append(s, "LastFirstEventId: "+fmt.Sprintf("%#v", this.LastFirstEventId)+",\n")
	s = append(s, "LastWorkflowTaskStartId: "+fmt.Sprintf("%#v", this.LastWorkflowTaskStartId)+",\n")
	s = append(s, "StartTime: "+fmt.Sprintf("%#v", this.StartTime)+",\n")
	s = append(s, "LastUpdateTime: "+fmt.Sprintf("%#v", this.LastUpdateTime)+",\n")
	s = append(s, "WorkflowTaskVersion: "+fmt.Sprintf("%#v", this.WorkflowTaskVersion)+",\n")
	s = append(s, "WorkflowTaskScheduleId: "+fmt.Sprintf("%#v", this.WorkflowTaskScheduleId)+",\n")
	s = append(s, "WorkflowTaskStartedId: "+fmt.Sprintf("%#v", this.WorkflowTaskStartedId)+",\n")
	s = append(s, "WorkflowTaskTimeout: "+fmt.Sprintf("%#v", this.WorkflowTaskTimeout)+",\n")
	s = append(s, "WorkflowTaskAttempt: "+fmt.Sprintf("%#v", this.WorkflowTaskAttempt)+",\n")
	s = append(s, "WorkflowTaskStartedTime: "+fmt.Sprintf("%#v", this.WorkflowTaskStartedTime)+",\n")
	s = append(s, "WorkflowTaskScheduledTime: "+fmt.Sprintf("%#v", this.WorkflowTaskScheduledTime)+",\n")
	s = append(s, "CancelRequested: "+fmt.Sprintf("%#v", this.CancelRequested)+",\n")
	s = append(s, "WorkflowTaskOriginalScheduledTime: "+fmt.Sprintf("%#v", this.WorkflowTaskOriginalScheduledTime)+",\n")
	s = append(s, "WorkflowTaskRequestId: "+fmt.Sprintf("%#v", this.WorkflowTaskRequestId)+",\n")
	s = append(s, "CancelRequestId: "+fmt.Sprintf("%#v", this.CancelRequestId)+",\n")
	s = append(s, "StickyTaskQueue: "+fmt.Sprintf("%#v", this.StickyTaskQueue)+",\n")
	s = append(s, "StickyScheduleToStartTimeout: "+fmt.Sprintf("%#v", this.StickyScheduleToStartTimeout)+",\n")
	s = append(s, "Attempt: "+fmt.Sprintf("%#v", this.Attempt)+",\n")
	s = append(s, "RetryInitialInterval: "+fmt.Sprintf("%#v", this.RetryInitialInterval)+",\n")
	s = append(s, "RetryMaximumInterval: "+fmt.Sprintf("%#v", this.RetryMaximumInterval)+",\n")
	s = append(s, "RetryMaximumAttempts: "+fmt.Sprintf("%#v", this.RetryMaximumAttempts)+",\n")
	s = append(s, "RetryBackoffCoefficient: "+fmt.Sprintf("%#v", this.RetryBackoffCoefficient)+",\n")
	s = append(s, "WorkflowExecutionExpirationTime: "+fmt.Sprintf("%#v", this.WorkflowExecutionExpirationTime)+",\n")
	s = append(s, "RetryNonRetryableErrorTypes: "+fmt.Sprintf("%#v", this.RetryNonRetryableErrorTypes)+",\n")
	s = append(s, "HasRetryPolicy: "+fmt.Sprintf("%#v", this.HasRetryPolicy)+",\n")
	s = append(s, "CronSchedule: "+fmt.Sprintf("%#v", this.CronSchedule)+",\n")
	s = append(s, "SignalCount: "+fmt.Sprintf("%#v", this.SignalCount)+",\n")
	if this.AutoResetPoints != nil {
		s = append(s, "AutoResetPoints: "+fmt.Sprintf("%#v", this.AutoResetPoints)+",\n")
	}
	keysForSearchAttributes := make([]string, 0, len(this.SearchAttributes))
	for k, _ := range this.SearchAttributes {
		keysForSearchAttributes = append(keysForSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSearchAttributes)
	mapStringForSearchAttributes := "map[string]*v11.Payload{"
	for _, k := range keysForSearchAttributes {
		mapStringForSearchAttributes += fmt.Sprintf("%#v: %#v,", k, this.SearchAttributes[k])
	}
	mapStringForSearchAttributes += "}"
	if this.SearchAttributes != nil {
		s = append(s, "SearchAttributes: "+mapStringForSearchAttributes+",\n")
	}
	keysForMemo := make([]string, 0, len(this.Memo))
	for k, _ := range this.Memo {
		keysForMemo = append(keysForMemo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMemo)
	mapStringForMemo := "map[string]*v11.Payload{"
	for _, k := range keysForMemo {
		mapStringForMemo += fmt.Sprintf("%#v: %#v,", k, this.Memo[k])
	}
	mapStringForMemo += "}"
	if this.Memo != nil {
		s = append(s, "Memo: "+mapStringForMemo+",\n")
	}
	if this.VersionHistories != nil {
		s = append(s, "VersionHistories: "+fmt.Sprintf("%#v", this.VersionHistories)+",\n")
	}
	s = append(s, "FirstExecutionRunId: "+fmt.Sprintf("%#v", this.FirstExecutionRunId)+",\n")
	if this.ExecutionStats != nil {
		s = append(s, "ExecutionStats: "+fmt.Sprintf("%#v", this.ExecutionStats)+",\n")
	}
	s = append(s, "WorkflowRunExpirationTime: "+fmt.Sprintf("%#v", this.WorkflowRunExpirationTime)+",\n")
	s = append(s, "LastFirstEventTxnId: "+fmt.Sprintf("%#v", this.LastFirstEventTxnId)+",\n")
	s = append(s, "StateTransitionCount: "+fmt.Sprintf("%#v", this.StateTransitionCount)+",\n")
	s = append(s, "ExecutionTime: "+fmt.Sprintf("%#v", this.ExecutionTime)+",\n")
	s = append(s, "NewExecutionRunId: "+fmt.Sprintf("%#v", this.NewExecutionRunId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ExecutionStats) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&persistence.ExecutionStats{")
	s = append(s, "HistorySize: "+fmt.Sprintf("%#v", this.HistorySize)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WorkflowExecutionState) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&persistence.WorkflowExecutionState{")
	s = append(s, "CreateRequestId: "+fmt.Sprintf("%#v", this.CreateRequestId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TransferTaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 17)
	s = append(s, "&persistence.TransferTaskInfo{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "TaskType: "+fmt.Sprintf("%#v", this.TaskType)+",\n")
	s = append(s, "TargetNamespaceId: "+fmt.Sprintf("%#v", this.TargetNamespaceId)+",\n")
	s = append(s, "TargetWorkflowId: "+fmt.Sprintf("%#v", this.TargetWorkflowId)+",\n")
	s = append(s, "TargetRunId: "+fmt.Sprintf("%#v", this.TargetRunId)+",\n")
	s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	s = append(s, "TargetChildWorkflowOnly: "+fmt.Sprintf("%#v", this.TargetChildWorkflowOnly)+",\n")
	s = append(s, "ScheduleId: "+fmt.Sprintf("%#v", this.ScheduleId)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "VisibilityTime: "+fmt.Sprintf("%#v", this.VisibilityTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReplicationTaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 16)
	s = append(s, "&persistence.ReplicationTaskInfo{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "TaskType: "+fmt.Sprintf("%#v", this.TaskType)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "FirstEventId: "+fmt.Sprintf("%#v", this.FirstEventId)+",\n")
	s = append(s, "NextEventId: "+fmt.Sprintf("%#v", this.NextEventId)+",\n")
	s = append(s, "ScheduledId: "+fmt.Sprintf("%#v", this.ScheduledId)+",\n")
	s = append(s, "BranchToken: "+fmt.Sprintf("%#v", this.BranchToken)+",\n")
	s = append(s, "NewRunBranchToken: "+fmt.Sprintf("%#v", this.NewRunBranchToken)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "VisibilityTime: "+fmt.Sprintf("%#v", this.VisibilityTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *VisibilityTaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&persistence.VisibilityTaskInfo{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "TaskType: "+fmt.Sprintf("%#v", this.TaskType)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "VisibilityTime: "+fmt.Sprintf("%#v", this.VisibilityTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TieredStorageTaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&persistence.TieredStorageTaskInfo{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "TaskType: "+fmt.Sprintf("%#v", this.TaskType)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "VisibilityTime: "+fmt.Sprintf("%#v", this.VisibilityTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TimerTaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&persistence.TimerTaskInfo{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "TaskType: "+fmt.Sprintf("%#v", this.TaskType)+",\n")
	s = append(s, "TimeoutType: "+fmt.Sprintf("%#v", this.TimeoutType)+",\n")
	s = append(s, "WorkflowBackoffType: "+fmt.Sprintf("%#v", this.WorkflowBackoffType)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "ScheduleAttempt: "+fmt.Sprintf("%#v", this.ScheduleAttempt)+",\n")
	s = append(s, "EventId: "+fmt.Sprintf("%#v", this.EventId)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "VisibilityTime: "+fmt.Sprintf("%#v", this.VisibilityTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ActivityInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 34)
	s = append(s, "&persistence.ActivityInfo{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "ScheduledEventBatchId: "+fmt.Sprintf("%#v", this.ScheduledEventBatchId)+",\n")
	s = append(s, "ScheduledTime: "+fmt.Sprintf("%#v", this.ScheduledTime)+",\n")
	s = append(s, "StartedId: "+fmt.Sprintf("%#v", this.StartedId)+",\n")
	s = append(s, "StartedTime: "+fmt.Sprintf("%#v", this.StartedTime)+",\n")
	s = append(s, "ActivityId: "+fmt.Sprintf("%#v", this.ActivityId)+",\n")
	s = append(s, "RequestId: "+fmt.Sprintf("%#v", this.RequestId)+",\n")
	s = append(s, "ScheduleToStartTimeout: "+fmt.Sprintf("%#v", this.ScheduleToStartTimeout)+",\n")
	s = append(s, "ScheduleToCloseTimeout: "+fmt.Sprintf("%#v", this.ScheduleToCloseTimeout)+",\n")
	s = append(s, "StartToCloseTimeout: "+fmt.Sprintf("%#v", this.StartToCloseTimeout)+",\n")
	s = append(s, "HeartbeatTimeout: "+fmt.Sprintf("%#v", this.HeartbeatTimeout)+",\n")
	s = append(s, "CancelRequested: "+fmt.Sprintf("%#v", this.CancelRequested)+",\n")
	s = append(s, "CancelRequestId: "+fmt.Sprintf("%#v", this.CancelRequestId)+",\n")
	s = append(s, "TimerTaskStatus: "+fmt.Sprintf("%#v", this.TimerTaskStatus)+",\n")
	s = append(s, "Attempt: "+fmt.Sprintf("%#v", this.Attempt)+",\n")
	s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	s = append(s, "StartedIdentity: "+fmt.Sprintf("%#v", this.StartedIdentity)+",\n")
	s = append(s, "HasRetryPolicy: "+fmt.Sprintf("%#v", this.HasRetryPolicy)+",\n")
	s = append(s, "RetryInitialInterval: "+fmt.Sprintf("%#v", this.RetryInitialInterval)+",\n")
	s = append(s, "RetryMaximumInterval: "+fmt.Sprintf("%#v", this.RetryMaximumInterval)+",\n")
	s = append(s, "RetryMaximumAttempts: "+fmt.Sprintf("%#v", this.RetryMaximumAttempts)+",\n")
	s = append(s, "RetryExpirationTime: "+fmt.Sprintf("%#v", this.RetryExpirationTime)+",\n")
	s = append(s, "RetryBackoffCoefficient: "+fmt.Sprintf("%#v", this.RetryBackoffCoefficient)+",\n")
	s = append(s, "RetryNonRetryableErrorTypes: "+fmt.Sprintf("%#v", this.RetryNonRetryableErrorTypes)+",\n")
	if this.RetryLastFailure != nil {
		s = append(s, "RetryLastFailure: "+fmt.Sprintf("%#v", this.RetryLastFailure)+",\n")
	}
	s = append(s, "RetryLastWorkerIdentity: "+fmt.Sprintf("%#v", this.RetryLastWorkerIdentity)+",\n")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "ScheduleId: "+fmt.Sprintf("%#v", this.ScheduleId)+",\n")
	if this.LastHeartbeatDetails != nil {
		s = append(s, "LastHeartbeatDetails: "+fmt.Sprintf("%#v", this.LastHeartbeatDetails)+",\n")
	}
	s = append(s, "LastHeartbeatUpdateTime: "+fmt.Sprintf("%#v", this.LastHeartbeatUpdateTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TimerInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&persistence.TimerInfo{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "StartedId: "+fmt.Sprintf("%#v", this.StartedId)+",\n")
	s = append(s, "ExpiryTime: "+fmt.Sprintf("%#v", this.ExpiryTime)+",\n")
	s = append(s, "TaskStatus: "+fmt.Sprintf("%#v", this.TaskStatus)+",\n")
	s = append(s, "TimerId: "+fmt.Sprintf("%#v", this.TimerId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ChildExecutionInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 14)
	s = append(s, "&persistence.ChildExecutionInfo{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "InitiatedEventBatchId: "+fmt.Sprintf("%#v", this.InitiatedEventBatchId)+",\n")
	s = append(s, "StartedId: "+fmt.Sprintf("%#v", this.StartedId)+",\n")
	s = append(s, "StartedWorkflowId: "+fmt.Sprintf("%#v", this.StartedWorkflowId)+",\n")
	s = append(s, "StartedRunId: "+fmt.Sprintf("%#v", this.StartedRunId)+",\n")
	s = append(s, "CreateRequestId: "+fmt.Sprintf("%#v", this.CreateRequestId)+",\n")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	s = append(s, "WorkflowTypeName: "+fmt.Sprintf("%#v", this.WorkflowTypeName)+",\n")
	s = append(s, "ParentClosePolicy: "+fmt.Sprintf("%#v", this.ParentClosePolicy)+",\n")
	s = append(s, "InitiatedId: "+fmt.Sprintf("%#v", this.InitiatedId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RequestCancelInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&persistence.RequestCancelInfo{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "InitiatedEventBatchId: "+fmt.Sprintf("%#v", this.InitiatedEventBatchId)+",\n")
	s = append(s, "CancelRequestId: "+fmt.Sprintf("%#v", this.CancelRequestId)+",\n")
	s = append(s, "InitiatedId: "+fmt.Sprintf("%#v", this.InitiatedId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SignalInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&persistence.SignalInfo{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "InitiatedEventBatchId: "+fmt.Sprintf("%#v", this.InitiatedEventBatchId)+",\n")
	s = append(s, "RequestId: "+fmt.Sprintf("%#v", this.RequestId)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.Input != nil {
		s = append(s, "Input: "+fmt.Sprintf("%#v", this.Input)+",\n")
	}
	s = append(s, "Control: "+fmt.Sprintf("%#v", this.Control)+",\n")
	s = append(s, "InitiatedId: "+fmt.Sprintf("%#v", this.InitiatedId)+",\n")
	if this.Header != nil {
		s = append(s, "Header: "+fmt.Sprintf("%#v", this.Header)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Checksum) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&persistence.Checksum{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "Flavor: "+fmt.Sprintf("%#v", this.Flavor)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringExecutions(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *ShardInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ShardInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ShardInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TieredStorageAckLevel != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TieredStorageAckLevel))
		i--
		dAtA[i] = 0x78
	}
	if m.VisibilityAckLevel != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.VisibilityAckLevel))
		i--
		dAtA[i] = 0x70
	}
	if len(m.ReplicationDlqAckLevel) > 0 {
		for k := range m.ReplicationDlqAckLevel {
			v := m.ReplicationDlqAckLevel[k]
			baseI := i
			i = encodeVarintExecutions(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintExecutions(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintExecutions(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x6a
		}
	}
	if len(m.ClusterReplicationLevel) > 0 {
		for k := range m.ClusterReplicationLevel {
			v := m.ClusterReplicationLevel[k]
			baseI := i
			i = encodeVarintExecutions(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintExecutions(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintExecutions(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x62
		}
	}
	if len(m.ClusterTimerAckLevel) > 0 {
		for k := range m.ClusterTimerAckLevel {
			v := m.ClusterTimerAckLevel[k]
			baseI := i
			if v != nil {
				n1, err1 := github_com_gogo_protobuf_types.StdTimeMarshalTo((*v), dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime((*v)):])
				if err1 != nil {
					return 0, err1
				}
				i -= n1
				i = encodeVarintExecutions(dAtA, i, uint64(n1))
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintExecutions(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintExecutions(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x5a
		}
	}
	if len(m.ClusterTransferAckLevel) > 0 {
		for k := range m.ClusterTransferAckLevel {
			v := m.ClusterTransferAckLevel[k]
			baseI := i
			i = encodeVarintExecutions(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintExecutions(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintExecutions(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x52
		}
	}
	if m.NamespaceNotificationVersion != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.NamespaceNotificationVersion))
		i--
		dAtA[i] = 0x48
	}
	if m.TimerAckLevelTime != nil {
		n2, err2 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.TimerAckLevelTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.TimerAckLevelTime):])
		if err2 != nil {
			return 0, err2
		}
		i -= n2
		i = encodeVarintExecutions(dAtA, i, uint64(n2))
		i--
		dAtA[i] = 0x42
	}
	if m.UpdateTime != nil {
		n3, err3 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.UpdateTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.UpdateTime):])
		if err3 != nil {
			return 0, err3
		}
		i -= n3
		i = encodeVarintExecutions(dAtA, i, uint64(n3))
		i--
		dAtA[i] = 0x3a
	}
	if m.StolenSinceRenew != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.StolenSinceRenew))
		i--
		dAtA[i] = 0x30
	}
	if m.TransferAckLevel != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TransferAckLevel))
		i--
		dAtA[i] = 0x28
	}
	if m.ReplicationAckLevel != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.ReplicationAckLevel))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Owner) > 0 {
		i -= len(m.Owner)
		copy(dAtA[i:], m.Owner)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.Owner)))
		i--
		dAtA[i] = 0x1a
	}
	if m.RangeId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.RangeId))
		i--
		dAtA[i] = 0x10
	}
	if m.ShardId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *WorkflowExecutionInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WorkflowExecutionInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WorkflowExecutionInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NewExecutionRunId) > 0 {
		i -= len(m.NewExecutionRunId)
		copy(dAtA[i:], m.NewExecutionRunId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.NewExecutionRunId)))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xea
	}
	if m.ExecutionTime != nil {
		n4, err4 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ExecutionTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExecutionTime):])
		if err4 != nil {
			return 0, err4
		}
		i -= n4
		i = encodeVarintExecutions(dAtA, i, uint64(n4))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xe2
	}
	if m.StateTransitionCount != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.StateTransitionCount))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xd8
	}
	if m.LastFirstEventTxnId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.LastFirstEventTxnId))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xd0
	}
	if m.WorkflowRunExpirationTime != nil {
		n5, err5 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.WorkflowRunExpirationTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowRunExpirationTime):])
		if err5 != nil {
			return 0, err5
		}
		i -= n5
		i = encodeVarintExecutions(dAtA, i, uint64(n5))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xca
	}
	if m.ExecutionStats != nil {
		{
			size, err := m.ExecutionStats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExecutions(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xc2
	}
	if len(m.FirstExecutionRunId) > 0 {
		i -= len(m.FirstExecutionRunId)
		copy(dAtA[i:], m.FirstExecutionRunId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.FirstExecutionRunId)))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xba
	}
	if m.VersionHistories != nil {
		{
			size, err := m.VersionHistories.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExecutions(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xb2
	}
	if len(m.Memo) > 0 {
		for k := range m.Memo {
			v := m.Memo[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintExecutions(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintExecutions(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintExecutions(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3
			i--
			dAtA[i] = 0xaa
		}
	}
	if len(m.SearchAttributes) > 0 {
		for k := range m.SearchAttributes {
			v := m.SearchAttributes[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintExecutions(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintExecutions(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintExecutions(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3
			i--
			dAtA[i] = 0xa2
		}
	}
	if m.AutoResetPoints != nil {
		{
			size, err := m.AutoResetPoints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExecutions(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x9a
	}
	if m.SignalCount != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.SignalCount))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xf0
	}
	if len(m.CronSchedule) > 0 {
		i -= len(m.CronSchedule)
		copy(dAtA[i:], m.CronSchedule)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.CronSchedule)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xda
	}
	if m.HasRetryPolicy {
		i--
		if m.HasRetryPolicy {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xd0
	}
	if len(m.RetryNonRetryableErrorTypes) > 0 {
		for iNdEx := len(m.RetryNonRetryableErrorTypes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RetryNonRetryableErrorTypes[iNdEx])
			copy(dAtA[i:], m.RetryNonRetryableErrorTypes[iNdEx])
			i = encodeVarintExecutions(dAtA, i, uint64(len(m.RetryNonRetryableErrorTypes[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xca
		}
	}
	if m.WorkflowExecutionExpirationTime != nil {
		n11, err11 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.WorkflowExecutionExpirationTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowExecutionExpirationTime):])
		if err11 != nil {
			return 0, err11
		}
		i -= n11
		i = encodeVarintExecutions(dAtA, i, uint64(n11))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xc2
	}
	if m.RetryBackoffCoefficient != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.RetryBackoffCoefficient))))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xb9
	}
	if m.RetryMaximumAttempts != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.RetryMaximumAttempts))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xb0
	}
	if m.RetryMaximumInterval != nil {
		n12, err12 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.RetryMaximumInterval, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryMaximumInterval):])
		if err12 != nil {
			return 0, err12
		}
		i -= n12
		i = encodeVarintExecutions(dAtA, i, uint64(n12))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xaa
	}
	if m.RetryInitialInterval != nil {
		n13, err13 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.RetryInitialInterval, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryInitialInterval):])
		if err13 != nil {
			return 0, err13
		}
		i -= n13
		i = encodeVarintExecutions(dAtA, i, uint64(n13))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xa2
	}
	if m.Attempt != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x98
	}
	if m.StickyScheduleToStartTimeout != nil {
		n14, err14 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.StickyScheduleToStartTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StickyScheduleToStartTimeout):])
		if err14 != nil {
			return 0, err14
		}
		i -= n14
		i = encodeVarintExecutions(dAtA, i, uint64(n14))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x92
	}
	if len(m.StickyTaskQueue) > 0 {
		i -= len(m.StickyTaskQueue)
		copy(dAtA[i:], m.StickyTaskQueue)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.StickyTaskQueue)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x8a
	}
	if len(m.CancelRequestId) > 0 {
		i -= len(m.CancelRequestId)
		copy(dAtA[i:], m.CancelRequestId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.CancelRequestId)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x82
	}
	if len(m.WorkflowTaskRequestId) > 0 {
		i -= len(m.WorkflowTaskRequestId)
		copy(dAtA[i:], m.WorkflowTaskRequestId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.WorkflowTaskRequestId)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xfa
	}
	if m.WorkflowTaskOriginalScheduledTime != nil {
		n15, err15 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.WorkflowTaskOriginalScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowTaskOriginalScheduledTime):])
		if err15 != nil {
			return 0, err15
		}
		i -= n15
		i = encodeVarintExecutions(dAtA, i, uint64(n15))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf2
	}
	if m.CancelRequested {
		i--
		if m.CancelRequested {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe8
	}
	if m.WorkflowTaskScheduledTime != nil {
		n16, err16 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.WorkflowTaskScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowTaskScheduledTime):])
		if err16 != nil {
			return 0, err16
		}
		i -= n16
		i = encodeVarintExecutions(dAtA, i, uint64(n16))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe2
	}
	if m.WorkflowTaskStartedTime != nil {
		n17, err17 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.WorkflowTaskStartedTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowTaskStartedTime):])
		if err17 != nil {
			return 0, err17
		}
		i -= n17
		i = encodeVarintExecutions(dAtA, i, uint64(n17))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xda
	}
	if m.WorkflowTaskAttempt != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.WorkflowTaskAttempt))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd0
	}
	if m.WorkflowTaskTimeout != nil {
		n18, err18 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.WorkflowTaskTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.WorkflowTaskTimeout):])
		if err18 != nil {
			return 0, err18
		}
		i -= n18
		i = encodeVarintExecutions(dAtA, i, uint64(n18))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xca
	}
	if m.WorkflowTaskStartedId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.WorkflowTaskStartedId))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc0
	}
	if m.WorkflowTaskScheduleId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.WorkflowTaskScheduleId))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if m.WorkflowTaskVersion != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.WorkflowTaskVersion))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if m.LastUpdateTime != nil {
		n19, err19 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.LastUpdateTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastUpdateTime):])
		if err19 != nil {
			return 0, err19
		}
		i -= n19
		i = encodeVarintExecutions(dAtA, i, uint64(n19))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.StartTime != nil {
		n20, err20 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartTime):])
		if err20 != nil {
			return 0, err20
		}
		i -= n20
		i = encodeVarintExecutions(dAtA, i, uint64(n20))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if m.LastWorkflowTaskStartId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.LastWorkflowTaskStartId))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if m.LastFirstEventId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.LastFirstEventId))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if m.LastEventTaskId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.LastEventTaskId))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.DefaultWorkflowTaskTimeout != nil {
		n21, err21 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.DefaultWorkflowTaskTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DefaultWorkflowTaskTimeout):])
		if err21 != nil {
			return 0, err21
		}
		i -= n21
		i = encodeVarintExecutions(dAtA, i, uint64(n21))
		i--
		dAtA[i] = 0x6a
	}
	if m.WorkflowRunTimeout != nil {
		n22, err22 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.WorkflowRunTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.WorkflowRunTimeout):])
		if err22 != nil {
			return 0, err22
		}
		i -= n22
		i = encodeVarintExecutions(dAtA, i, uint64(n22))
		i--
		dAtA[i] = 0x62
	}
	if m.WorkflowExecutionTimeout != nil {
		n23, err23 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.WorkflowExecutionTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.WorkflowExecutionTimeout):])
		if err23 != nil {
			return 0, err23
		}
		i -= n23
		i = encodeVarintExecutions(dAtA, i, uint64(n23))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.WorkflowTypeName) > 0 {
		i -= len(m.WorkflowTypeName)
		copy(dAtA[i:], m.WorkflowTypeName)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.WorkflowTypeName)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.TaskQueue) > 0 {
		i -= len(m.TaskQueue)
		copy(dAtA[i:], m.TaskQueue)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.TaskQueue)))
		i--
		dAtA[i] = 0x4a
	}
	if m.CompletionEventBatchId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.CompletionEventBatchId))
		i--
		dAtA[i] = 0x38
	}
	if m.InitiatedId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.InitiatedId))
		i--
		dAtA[i] = 0x30
	}
	if len(m.ParentRunId) > 0 {
		i -= len(m.ParentRunId)
		copy(dAtA[i:], m.ParentRunId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.ParentRunId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ParentWorkflowId) > 0 {
		i -= len(m.ParentWorkflowId)
		copy(dAtA[i:], m.ParentWorkflowId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.ParentWorkflowId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ParentNamespaceId) > 0 {
		i -= len(m.ParentNamespaceId)
		copy(dAtA[i:], m.ParentNamespaceId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.ParentNamespaceId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExecutionStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecutionStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExecutionStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.HistorySize != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.HistorySize))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *WorkflowExecutionState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WorkflowExecutionState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WorkflowExecutionState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Status != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x20
	}
	if m.State != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x18
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.CreateRequestId) > 0 {
		i -= len(m.CreateRequestId)
		copy(dAtA[i:], m.CreateRequestId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.CreateRequestId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TransferTaskInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransferTaskInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TransferTaskInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VisibilityTime != nil {
		n24, err24 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.VisibilityTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime):])
		if err24 != nil {
			return 0, err24
		}
		i -= n24
		i = encodeVarintExecutions(dAtA, i, uint64(n24))
		i--
		dAtA[i] = 0x6a
	}
	if m.TaskId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x60
	}
	if m.Version != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x58
	}
	if m.ScheduleId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.ScheduleId))
		i--
		dAtA[i] = 0x50
	}
	if m.TargetChildWorkflowOnly {
		i--
		if m.TargetChildWorkflowOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if len(m.TaskQueue) > 0 {
		i -= len(m.TaskQueue)
		copy(dAtA[i:], m.TaskQueue)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.TaskQueue)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.TargetRunId) > 0 {
		i -= len(m.TargetRunId)
		copy(dAtA[i:], m.TargetRunId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.TargetRunId)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.TargetWorkflowId) > 0 {
		i -= len(m.TargetWorkflowId)
		copy(dAtA[i:], m.TargetWorkflowId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.TargetWorkflowId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.TargetNamespaceId) > 0 {
		i -= len(m.TargetNamespaceId)
		copy(dAtA[i:], m.TargetNamespaceId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.TargetNamespaceId)))
		i--
		dAtA[i] = 0x2a
	}
	if m.TaskType != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TaskType))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReplicationTaskInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationTaskInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationTaskInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VisibilityTime != nil {
		n25, err25 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.VisibilityTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime):])
		if err25 != nil {
			return 0, err25
		}
		i -= n25
		i = encodeVarintExecutions(dAtA, i, uint64(n25))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.TaskId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x78
	}
	if len(m.NewRunBranchToken) > 0 {
		i -= len(m.NewRunBranchToken)
		copy(dAtA[i:], m.NewRunBranchToken)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.NewRunBranchToken)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.BranchToken) > 0 {
		i -= len(m.BranchToken)
		copy(dAtA[i:], m.BranchToken)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.BranchToken)))
		i--
		dAtA[i] = 0x5a
	}
	if m.ScheduledId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.ScheduledId))
		i--
		dAtA[i] = 0x40
	}
	if m.NextEventId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.NextEventId))
		i--
		dAtA[i] = 0x38
	}
	if m.FirstEventId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.FirstEventId))
		i--
		dAtA[i] = 0x30
	}
	if m.Version != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x28
	}
	if m.TaskType != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TaskType))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VisibilityTaskInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VisibilityTaskInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VisibilityTaskInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VisibilityTime != nil {
		n26, err26 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.VisibilityTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime):])
		if err26 != nil {
			return 0, err26
		}
		i -= n26
		i = encodeVarintExecutions(dAtA, i, uint64(n26))
		i--
		dAtA[i] = 0x3a
	}
	if m.TaskId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x30
	}
	if m.Version != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x28
	}
	if m.TaskType != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TaskType))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TieredStorageTaskInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TieredStorageTaskInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TieredStorageTaskInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VisibilityTime != nil {
		n27, err27 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.VisibilityTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime):])
		if err27 != nil {
			return 0, err27
		}
		i -= n27
		i = encodeVarintExecutions(dAtA, i, uint64(n27))
		i--
		dAtA[i] = 0x3a
	}
	if m.TaskId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x30
	}
	if m.Version != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x28
	}
	if m.TaskType != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TaskType))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TimerTaskInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimerTaskInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TimerTaskInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VisibilityTime != nil {
		n28, err28 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.VisibilityTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime):])
		if err28 != nil {
			return 0, err28
		}
		i -= n28
		i = encodeVarintExecutions(dAtA, i, uint64(n28))
		i--
		dAtA[i] = 0x5a
	}
	if m.TaskId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x50
	}
	if m.EventId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.EventId))
		i--
		dAtA[i] = 0x48
	}
	if m.ScheduleAttempt != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.ScheduleAttempt))
		i--
		dAtA[i] = 0x40
	}
	if m.Version != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x38
	}
	if m.WorkflowBackoffType != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.WorkflowBackoffType))
		i--
		dAtA[i] = 0x30
	}
	if m.TimeoutType != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TimeoutType))
		i--
		dAtA[i] = 0x28
	}
	if m.TaskType != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TaskType))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ActivityInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ActivityInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ActivityInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.LastHeartbeatUpdateTime != nil {
		n29, err29 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.LastHeartbeatUpdateTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbeatUpdateTime):])
		if err29 != nil {
			return 0, err29
		}
		i -= n29
		i = encodeVarintExecutions(dAtA, i, uint64(n29))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x82
	}
	if m.LastHeartbeatDetails != nil {
		{
			size, err := m.LastHeartbeatDetails.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExecutions(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xfa
	}
	if m.ScheduleId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.ScheduleId))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf0
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xea
	}
	if len(m.RetryLastWorkerIdentity) > 0 {
		i -= len(m.RetryLastWorkerIdentity)
		copy(dAtA[i:], m.RetryLastWorkerIdentity)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.RetryLastWorkerIdentity)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe2
	}
	if m.RetryLastFailure != nil {
		{
			size, err := m.RetryLastFailure.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExecutions(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xda
	}
	if len(m.RetryNonRetryableErrorTypes) > 0 {
		for iNdEx := len(m.RetryNonRetryableErrorTypes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RetryNonRetryableErrorTypes[iNdEx])
			copy(dAtA[i:], m.RetryNonRetryableErrorTypes[iNdEx])
			i = encodeVarintExecutions(dAtA, i, uint64(len(m.RetryNonRetryableErrorTypes[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xd2
		}
	}
	if m.RetryBackoffCoefficient != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.RetryBackoffCoefficient))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc9
	}
	if m.RetryExpirationTime != nil {
		n32, err32 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.RetryExpirationTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.RetryExpirationTime):])
		if err32 != nil {
			return 0, err32
		}
		i -= n32
		i = encodeVarintExecutions(dAtA, i, uint64(n32))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc2
	}
	if m.RetryMaximumAttempts != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.RetryMaximumAttempts))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if m.RetryMaximumInterval != nil {
		n33, err33 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.RetryMaximumInterval, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryMaximumInterval):])
		if err33 != nil {
			return 0, err33
		}
		i -= n33
		i = encodeVarintExecutions(dAtA, i, uint64(n33))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if m.RetryInitialInterval != nil {
		n34, err34 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.RetryInitialInterval, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryInitialInterval):])
		if err34 != nil {
			return 0, err34
		}
		i -= n34
		i = encodeVarintExecutions(dAtA, i, uint64(n34))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.HasRetryPolicy {
		i--
		if m.HasRetryPolicy {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if len(m.StartedIdentity) > 0 {
		i -= len(m.StartedIdentity)
		copy(dAtA[i:], m.StartedIdentity)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.StartedIdentity)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if len(m.TaskQueue) > 0 {
		i -= len(m.TaskQueue)
		copy(dAtA[i:], m.TaskQueue)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.TaskQueue)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if m.Attempt != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.TimerTaskStatus != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TimerTaskStatus))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.CancelRequestId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.CancelRequestId))
		i--
		dAtA[i] = 0x78
	}
	if m.CancelRequested {
		i--
		if m.CancelRequested {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x70
	}
	if m.HeartbeatTimeout != nil {
		n35, err35 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.HeartbeatTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.HeartbeatTimeout):])
		if err35 != nil {
			return 0, err35
		}
		i -= n35
		i = encodeVarintExecutions(dAtA, i, uint64(n35))
		i--
		dAtA[i] = 0x6a
	}
	if m.StartToCloseTimeout != nil {
		n36, err36 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.StartToCloseTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StartToCloseTimeout):])
		if err36 != nil {
			return 0, err36
		}
		i -= n36
		i = encodeVarintExecutions(dAtA, i, uint64(n36))
		i--
		dAtA[i] = 0x62
	}
	if m.ScheduleToCloseTimeout != nil {
		n37, err37 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.ScheduleToCloseTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToCloseTimeout):])
		if err37 != nil {
			return 0, err37
		}
		i -= n37
		i = encodeVarintExecutions(dAtA, i, uint64(n37))
		i--
		dAtA[i] = 0x5a
	}
	if m.ScheduleToStartTimeout != nil {
		n38, err38 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.ScheduleToStartTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToStartTimeout):])
		if err38 != nil {
			return 0, err38
		}
		i -= n38
		i = encodeVarintExecutions(dAtA, i, uint64(n38))
		i--
		dAtA[i] = 0x52
	}
	if len(m.RequestId) > 0 {
		i -= len(m.RequestId)
		copy(dAtA[i:], m.RequestId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.RequestId)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.ActivityId) > 0 {
		i -= len(m.ActivityId)
		copy(dAtA[i:], m.ActivityId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.ActivityId)))
		i--
		dAtA[i] = 0x42
	}
	if m.StartedTime != nil {
		n39, err39 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartedTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime):])
		if err39 != nil {
			return 0, err39
		}
		i -= n39
		i = encodeVarintExecutions(dAtA, i, uint64(n39))
		i--
		dAtA[i] = 0x3a
	}
	if m.StartedId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.StartedId))
		i--
		dAtA[i] = 0x28
	}
	if m.ScheduledTime != nil {
		n40, err40 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime):])
		if err40 != nil {
			return 0, err40
		}
		i -= n40
		i = encodeVarintExecutions(dAtA, i, uint64(n40))
		i--
		dAtA[i] = 0x22
	}
	if m.ScheduledEventBatchId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.ScheduledEventBatchId))
		i--
		dAtA[i] = 0x10
	}
	if m.Version != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TimerInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimerInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TimerInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TimerId) > 0 {
		i -= len(m.TimerId)
		copy(dAtA[i:], m.TimerId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.TimerId)))
		i--
		dAtA[i] = 0x2a
	}
	if m.TaskStatus != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.TaskStatus))
		i--
		dAtA[i] = 0x20
	}
	if m.ExpiryTime != nil {
		n41, err41 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ExpiryTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExpiryTime):])
		if err41 != nil {
			return 0, err41
		}
		i -= n41
		i = encodeVarintExecutions(dAtA, i, uint64(n41))
		i--
		dAtA[i] = 0x1a
	}
	if m.StartedId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.StartedId))
		i--
		dAtA[i] = 0x10
	}
	if m.Version != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ChildExecutionInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChildExecutionInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ChildExecutionInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InitiatedId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.InitiatedId))
		i--
		dAtA[i] = 0x60
	}
	if m.ParentClosePolicy != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.ParentClosePolicy))
		i--
		dAtA[i] = 0x58
	}
	if len(m.WorkflowTypeName) > 0 {
		i -= len(m.WorkflowTypeName)
		copy(dAtA[i:], m.WorkflowTypeName)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.WorkflowTypeName)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.CreateRequestId) > 0 {
		i -= len(m.CreateRequestId)
		copy(dAtA[i:], m.CreateRequestId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.CreateRequestId)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.StartedRunId) > 0 {
		i -= len(m.StartedRunId)
		copy(dAtA[i:], m.StartedRunId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.StartedRunId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.StartedWorkflowId) > 0 {
		i -= len(m.StartedWorkflowId)
		copy(dAtA[i:], m.StartedWorkflowId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.StartedWorkflowId)))
		i--
		dAtA[i] = 0x2a
	}
	if m.StartedId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.StartedId))
		i--
		dAtA[i] = 0x18
	}
	if m.InitiatedEventBatchId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.InitiatedEventBatchId))
		i--
		dAtA[i] = 0x10
	}
	if m.Version != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RequestCancelInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestCancelInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RequestCancelInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InitiatedId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.InitiatedId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.CancelRequestId) > 0 {
		i -= len(m.CancelRequestId)
		copy(dAtA[i:], m.CancelRequestId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.CancelRequestId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.InitiatedEventBatchId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.InitiatedEventBatchId))
		i--
		dAtA[i] = 0x10
	}
	if m.Version != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SignalInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SignalInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SignalInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Header != nil {
		{
			size, err := m.Header.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExecutions(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.InitiatedId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.InitiatedId))
		i--
		dAtA[i] = 0x38
	}
	if len(m.Control) > 0 {
		i -= len(m.Control)
		copy(dAtA[i:], m.Control)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.Control)))
		i--
		dAtA[i] = 0x32
	}
	if m.Input != nil {
		{
			size, err := m.Input.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExecutions(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.RequestId) > 0 {
		i -= len(m.RequestId)
		copy(dAtA[i:], m.RequestId)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.RequestId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.InitiatedEventBatchId != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.InitiatedEventBatchId))
		i--
		dAtA[i] = 0x10
	}
	if m.Version != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Checksum) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Checksum) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Checksum) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintExecutions(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Flavor != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Flavor))
		i--
		dAtA[i] = 0x10
	}
	if m.Version != 0 {
		i = encodeVarintExecutions(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintExecutions(dAtA []byte, offset int, v uint64) int {
	offset -= sovExecutions(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ShardInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovExecutions(uint64(m.ShardId))
	}
	if m.RangeId != 0 {
		n += 1 + sovExecutions(uint64(m.RangeId))
	}
	l = len(m.Owner)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.ReplicationAckLevel != 0 {
		n += 1 + sovExecutions(uint64(m.ReplicationAckLevel))
	}
	if m.TransferAckLevel != 0 {
		n += 1 + sovExecutions(uint64(m.TransferAckLevel))
	}
	if m.StolenSinceRenew != 0 {
		n += 1 + sovExecutions(uint64(m.StolenSinceRenew))
	}
	if m.UpdateTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.UpdateTime)
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.TimerAckLevelTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.TimerAckLevelTime)
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.NamespaceNotificationVersion != 0 {
		n += 1 + sovExecutions(uint64(m.NamespaceNotificationVersion))
	}
	if len(m.ClusterTransferAckLevel) > 0 {
		for k, v := range m.ClusterTransferAckLevel {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovExecutions(uint64(len(k))) + 1 + sovExecutions(uint64(v))
			n += mapEntrySize + 1 + sovExecutions(uint64(mapEntrySize))
		}
	}
	if len(m.ClusterTimerAckLevel) > 0 {
		for k, v := range m.ClusterTimerAckLevel {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = github_com_gogo_protobuf_types.SizeOfStdTime(*v)
				l += 1 + sovExecutions(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovExecutions(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovExecutions(uint64(mapEntrySize))
		}
	}
	if len(m.ClusterReplicationLevel) > 0 {
		for k, v := range m.ClusterReplicationLevel {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovExecutions(uint64(len(k))) + 1 + sovExecutions(uint64(v))
			n += mapEntrySize + 1 + sovExecutions(uint64(mapEntrySize))
		}
	}
	if len(m.ReplicationDlqAckLevel) > 0 {
		for k, v := range m.ReplicationDlqAckLevel {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovExecutions(uint64(len(k))) + 1 + sovExecutions(uint64(v))
			n += mapEntrySize + 1 + sovExecutions(uint64(mapEntrySize))
		}
	}
	if m.VisibilityAckLevel != 0 {
		n += 1 + sovExecutions(uint64(m.VisibilityAckLevel))
	}
	if m.TieredStorageAckLevel != 0 {
		n += 1 + sovExecutions(uint64(m.TieredStorageAckLevel))
	}
	return n
}

func (m *WorkflowExecutionInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.ParentNamespaceId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.ParentWorkflowId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.ParentRunId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.InitiatedId != 0 {
		n += 1 + sovExecutions(uint64(m.InitiatedId))
	}
	if m.CompletionEventBatchId != 0 {
		n += 1 + sovExecutions(uint64(m.CompletionEventBatchId))
	}
	l = len(m.TaskQueue)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.WorkflowTypeName)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.WorkflowExecutionTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.WorkflowExecutionTimeout)
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.WorkflowRunTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.WorkflowRunTimeout)
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.DefaultWorkflowTaskTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DefaultWorkflowTaskTimeout)
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.LastEventTaskId != 0 {
		n += 2 + sovExecutions(uint64(m.LastEventTaskId))
	}
	if m.LastFirstEventId != 0 {
		n += 2 + sovExecutions(uint64(m.LastFirstEventId))
	}
	if m.LastWorkflowTaskStartId != 0 {
		n += 2 + sovExecutions(uint64(m.LastWorkflowTaskStartId))
	}
	if m.StartTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartTime)
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.LastUpdateTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastUpdateTime)
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.WorkflowTaskVersion != 0 {
		n += 2 + sovExecutions(uint64(m.WorkflowTaskVersion))
	}
	if m.WorkflowTaskScheduleId != 0 {
		n += 2 + sovExecutions(uint64(m.WorkflowTaskScheduleId))
	}
	if m.WorkflowTaskStartedId != 0 {
		n += 2 + sovExecutions(uint64(m.WorkflowTaskStartedId))
	}
	if m.WorkflowTaskTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.WorkflowTaskTimeout)
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.WorkflowTaskAttempt != 0 {
		n += 2 + sovExecutions(uint64(m.WorkflowTaskAttempt))
	}
	if m.WorkflowTaskStartedTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowTaskStartedTime)
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.WorkflowTaskScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowTaskScheduledTime)
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.CancelRequested {
		n += 3
	}
	if m.WorkflowTaskOriginalScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowTaskOriginalScheduledTime)
		n += 2 + l + sovExecutions(uint64(l))
	}
	l = len(m.WorkflowTaskRequestId)
	if l > 0 {
		n += 2 + l + sovExecutions(uint64(l))
	}
	l = len(m.CancelRequestId)
	if l > 0 {
		n += 2 + l + sovExecutions(uint64(l))
	}
	l = len(m.StickyTaskQueue)
	if l > 0 {
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.StickyScheduleToStartTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StickyScheduleToStartTimeout)
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.Attempt != 0 {
		n += 2 + sovExecutions(uint64(m.Attempt))
	}
	if m.RetryInitialInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryInitialInterval)
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.RetryMaximumInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryMaximumInterval)
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.RetryMaximumAttempts != 0 {
		n += 2 + sovExecutions(uint64(m.RetryMaximumAttempts))
	}
	if m.RetryBackoffCoefficient != 0 {
		n += 10
	}
	if m.WorkflowExecutionExpirationTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowExecutionExpirationTime)
		n += 2 + l + sovExecutions(uint64(l))
	}
	if len(m.RetryNonRetryableErrorTypes) > 0 {
		for _, s := range m.RetryNonRetryableErrorTypes {
			l = len(s)
			n += 2 + l + sovExecutions(uint64(l))
		}
	}
	if m.HasRetryPolicy {
		n += 3
	}
	l = len(m.CronSchedule)
	if l > 0 {
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.SignalCount != 0 {
		n += 2 + sovExecutions(uint64(m.SignalCount))
	}
	if m.AutoResetPoints != nil {
		l = m.AutoResetPoints.Size()
		n += 2 + l + sovExecutions(uint64(l))
	}
	if len(m.SearchAttributes) > 0 {
		for k, v := range m.SearchAttributes {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovExecutions(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovExecutions(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovExecutions(uint64(mapEntrySize))
		}
	}
	if len(m.Memo) > 0 {
		for k, v := range m.Memo {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovExecutions(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovExecutions(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovExecutions(uint64(mapEntrySize))
		}
	}
	if m.VersionHistories != nil {
		l = m.VersionHistories.Size()
		n += 2 + l + sovExecutions(uint64(l))
	}
	l = len(m.FirstExecutionRunId)
	if l > 0 {
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.ExecutionStats != nil {
		l = m.ExecutionStats.Size()
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.WorkflowRunExpirationTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowRunExpirationTime)
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.LastFirstEventTxnId != 0 {
		n += 2 + sovExecutions(uint64(m.LastFirstEventTxnId))
	}
	if m.StateTransitionCount != 0 {
		n += 2 + sovExecutions(uint64(m.StateTransitionCount))
	}
	if m.ExecutionTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExecutionTime)
		n += 2 + l + sovExecutions(uint64(l))
	}
	l = len(m.NewExecutionRunId)
	if l > 0 {
		n += 2 + l + sovExecutions(uint64(l))
	}
	return n
}

func (m *ExecutionStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HistorySize != 0 {
		n += 1 + sovExecutions(uint64(m.HistorySize))
	}
	return n
}

func (m *WorkflowExecutionState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CreateRequestId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovExecutions(uint64(m.State))
	}
	if m.Status != 0 {
		n += 1 + sovExecutions(uint64(m.Status))
	}
	return n
}

func (m *TransferTaskInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.TaskType != 0 {
		n += 1 + sovExecutions(uint64(m.TaskType))
	}
	l = len(m.TargetNamespaceId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.TargetWorkflowId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.TargetRunId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.TaskQueue)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.TargetChildWorkflowOnly {
		n += 2
	}
	if m.ScheduleId != 0 {
		n += 1 + sovExecutions(uint64(m.ScheduleId))
	}
	if m.Version != 0 {
		n += 1 + sovExecutions(uint64(m.Version))
	}
	if m.TaskId != 0 {
		n += 1 + sovExecutions(uint64(m.TaskId))
	}
	if m.VisibilityTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime)
		n += 1 + l + sovExecutions(uint64(l))
	}
	return n
}

func (m *ReplicationTaskInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.TaskType != 0 {
		n += 1 + sovExecutions(uint64(m.TaskType))
	}
	if m.Version != 0 {
		n += 1 + sovExecutions(uint64(m.Version))
	}
	if m.FirstEventId != 0 {
		n += 1 + sovExecutions(uint64(m.FirstEventId))
	}
	if m.NextEventId != 0 {
		n += 1 + sovExecutions(uint64(m.NextEventId))
	}
	if m.ScheduledId != 0 {
		n += 1 + sovExecutions(uint64(m.ScheduledId))
	}
	l = len(m.BranchToken)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.NewRunBranchToken)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.TaskId != 0 {
		n += 1 + sovExecutions(uint64(m.TaskId))
	}
	if m.VisibilityTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime)
		n += 2 + l + sovExecutions(uint64(l))
	}
	return n
}

func (m *VisibilityTaskInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.TaskType != 0 {
		n += 1 + sovExecutions(uint64(m.TaskType))
	}
	if m.Version != 0 {
		n += 1 + sovExecutions(uint64(m.Version))
	}
	if m.TaskId != 0 {
		n += 1 + sovExecutions(uint64(m.TaskId))
	}
	if m.VisibilityTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime)
		n += 1 + l + sovExecutions(uint64(l))
	}
	return n
}

func (m *TieredStorageTaskInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.TaskType != 0 {
		n += 1 + sovExecutions(uint64(m.TaskType))
	}
	if m.Version != 0 {
		n += 1 + sovExecutions(uint64(m.Version))
	}
	if m.TaskId != 0 {
		n += 1 + sovExecutions(uint64(m.TaskId))
	}
	if m.VisibilityTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime)
		n += 1 + l + sovExecutions(uint64(l))
	}
	return n
}

func (m *TimerTaskInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.TaskType != 0 {
		n += 1 + sovExecutions(uint64(m.TaskType))
	}
	if m.TimeoutType != 0 {
		n += 1 + sovExecutions(uint64(m.TimeoutType))
	}
	if m.WorkflowBackoffType != 0 {
		n += 1 + sovExecutions(uint64(m.WorkflowBackoffType))
	}
	if m.Version != 0 {
		n += 1 + sovExecutions(uint64(m.Version))
	}
	if m.ScheduleAttempt != 0 {
		n += 1 + sovExecutions(uint64(m.ScheduleAttempt))
	}
	if m.EventId != 0 {
		n += 1 + sovExecutions(uint64(m.EventId))
	}
	if m.TaskId != 0 {
		n += 1 + sovExecutions(uint64(m.TaskId))
	}
	if m.VisibilityTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime)
		n += 1 + l + sovExecutions(uint64(l))
	}
	return n
}

func (m *ActivityInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovExecutions(uint64(m.Version))
	}
	if m.ScheduledEventBatchId != 0 {
		n += 1 + sovExecutions(uint64(m.ScheduledEventBatchId))
	}
	if m.ScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime)
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.StartedId != 0 {
		n += 1 + sovExecutions(uint64(m.StartedId))
	}
	if m.StartedTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime)
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.ActivityId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.RequestId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.ScheduleToStartTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToStartTimeout)
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.ScheduleToCloseTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToCloseTimeout)
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.StartToCloseTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StartToCloseTimeout)
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.HeartbeatTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.HeartbeatTimeout)
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.CancelRequested {
		n += 2
	}
	if m.CancelRequestId != 0 {
		n += 1 + sovExecutions(uint64(m.CancelRequestId))
	}
	if m.TimerTaskStatus != 0 {
		n += 2 + sovExecutions(uint64(m.TimerTaskStatus))
	}
	if m.Attempt != 0 {
		n += 2 + sovExecutions(uint64(m.Attempt))
	}
	l = len(m.TaskQueue)
	if l > 0 {
		n += 2 + l + sovExecutions(uint64(l))
	}
	l = len(m.StartedIdentity)
	if l > 0 {
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.HasRetryPolicy {
		n += 3
	}
	if m.RetryInitialInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryInitialInterval)
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.RetryMaximumInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryMaximumInterval)
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.RetryMaximumAttempts != 0 {
		n += 2 + sovExecutions(uint64(m.RetryMaximumAttempts))
	}
	if m.RetryExpirationTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.RetryExpirationTime)
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.RetryBackoffCoefficient != 0 {
		n += 10
	}
	if len(m.RetryNonRetryableErrorTypes) > 0 {
		for _, s := range m.RetryNonRetryableErrorTypes {
			l = len(s)
			n += 2 + l + sovExecutions(uint64(l))
		}
	}
	if m.RetryLastFailure != nil {
		l = m.RetryLastFailure.Size()
		n += 2 + l + sovExecutions(uint64(l))
	}
	l = len(m.RetryLastWorkerIdentity)
	if l > 0 {
		n += 2 + l + sovExecutions(uint64(l))
	}
	l = len(m.NamespaceId)
	if l > 0 {
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.ScheduleId != 0 {
		n += 2 + sovExecutions(uint64(m.ScheduleId))
	}
	if m.LastHeartbeatDetails != nil {
		l = m.LastHeartbeatDetails.Size()
		n += 2 + l + sovExecutions(uint64(l))
	}
	if m.LastHeartbeatUpdateTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbeatUpdateTime)
		n += 2 + l + sovExecutions(uint64(l))
	}
	return n
}

func (m *TimerInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovExecutions(uint64(m.Version))
	}
	if m.StartedId != 0 {
		n += 1 + sovExecutions(uint64(m.StartedId))
	}
	if m.ExpiryTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExpiryTime)
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.TaskStatus != 0 {
		n += 1 + sovExecutions(uint64(m.TaskStatus))
	}
	l = len(m.TimerId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	return n
}

func (m *ChildExecutionInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovExecutions(uint64(m.Version))
	}
	if m.InitiatedEventBatchId != 0 {
		n += 1 + sovExecutions(uint64(m.InitiatedEventBatchId))
	}
	if m.StartedId != 0 {
		n += 1 + sovExecutions(uint64(m.StartedId))
	}
	l = len(m.StartedWorkflowId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.StartedRunId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.CreateRequestId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.WorkflowTypeName)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.ParentClosePolicy != 0 {
		n += 1 + sovExecutions(uint64(m.ParentClosePolicy))
	}
	if m.InitiatedId != 0 {
		n += 1 + sovExecutions(uint64(m.InitiatedId))
	}
	return n
}

func (m *RequestCancelInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovExecutions(uint64(m.Version))
	}
	if m.InitiatedEventBatchId != 0 {
		n += 1 + sovExecutions(uint64(m.InitiatedEventBatchId))
	}
	l = len(m.CancelRequestId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.InitiatedId != 0 {
		n += 1 + sovExecutions(uint64(m.InitiatedId))
	}
	return n
}

func (m *SignalInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovExecutions(uint64(m.Version))
	}
	if m.InitiatedEventBatchId != 0 {
		n += 1 + sovExecutions(uint64(m.InitiatedEventBatchId))
	}
	l = len(m.RequestId)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.Input != nil {
		l = m.Input.Size()
		n += 1 + l + sovExecutions(uint64(l))
	}
	l = len(m.Control)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	if m.InitiatedId != 0 {
		n += 1 + sovExecutions(uint64(m.InitiatedId))
	}
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovExecutions(uint64(l))
	}
	return n
}

func (m *Checksum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovExecutions(uint64(m.Version))
	}
	if m.Flavor != 0 {
		n += 1 + sovExecutions(uint64(m.Flavor))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovExecutions(uint64(l))
	}
	return n
}

func sovExecutions(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozExecutions(x uint64) (n int) {
	return sovExecutions(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ShardInfo) String() string {
	if this == nil {
		return "nil"
	}
	keysForClusterTransferAckLevel := make([]string, 0, len(this.ClusterTransferAckLevel))
	for k, _ := range this.ClusterTransferAckLevel {
		keysForClusterTransferAckLevel = append(keysForClusterTransferAckLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterTransferAckLevel)
	mapStringForClusterTransferAckLevel := "map[string]int64{"
	for _, k := range keysForClusterTransferAckLevel {
		mapStringForClusterTransferAckLevel += fmt.Sprintf("%v: %v,", k, this.ClusterTransferAckLevel[k])
	}
	mapStringForClusterTransferAckLevel += "}"
	keysForClusterTimerAckLevel := make([]string, 0, len(this.ClusterTimerAckLevel))
	for k, _ := range this.ClusterTimerAckLevel {
		keysForClusterTimerAckLevel = append(keysForClusterTimerAckLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterTimerAckLevel)
	mapStringForClusterTimerAckLevel := "map[string]*time.Time{"
	for _, k := range keysForClusterTimerAckLevel {
		mapStringForClusterTimerAckLevel += fmt.Sprintf("%v: %v,", k, this.ClusterTimerAckLevel[k])
	}
	mapStringForClusterTimerAckLevel += "}"
	keysForClusterReplicationLevel := make([]string, 0, len(this.ClusterReplicationLevel))
	for k, _ := range this.ClusterReplicationLevel {
		keysForClusterReplicationLevel = append(keysForClusterReplicationLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterReplicationLevel)
	mapStringForClusterReplicationLevel := "map[string]int64{"
	for _, k := range keysForClusterReplicationLevel {
		mapStringForClusterReplicationLevel += fmt.Sprintf("%v: %v,", k, this.ClusterReplicationLevel[k])
	}
	mapStringForClusterReplicationLevel += "}"
	keysForReplicationDlqAckLevel := make([]string, 0, len(this.ReplicationDlqAckLevel))
	for k, _ := range this.ReplicationDlqAckLevel {
		keysForReplicationDlqAckLevel = append(keysForReplicationDlqAckLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForReplicationDlqAckLevel)
	mapStringForReplicationDlqAckLevel := "map[string]int64{"
	for _, k := range keysForReplicationDlqAckLevel {
		mapStringForReplicationDlqAckLevel += fmt.Sprintf("%v: %v,", k, this.ReplicationDlqAckLevel[k])
	}
	mapStringForReplicationDlqAckLevel += "}"
	s := strings.Join([]string{`&ShardInfo{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`RangeId:` + fmt.Sprintf("%v", this.RangeId) + `,`,
		`Owner:` + fmt.Sprintf("%v", this.Owner) + `,`,
		`ReplicationAckLevel:` + fmt.Sprintf("%v", this.ReplicationAckLevel) + `,`,
		`TransferAckLevel:` + fmt.Sprintf("%v", this.TransferAckLevel) + `,`,
		`StolenSinceRenew:` + fmt.Sprintf("%v", this.StolenSinceRenew) + `,`,
		`UpdateTime:` + strings.Replace(fmt.Sprintf("%v", this.UpdateTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`TimerAckLevelTime:` + strings.Replace(fmt.Sprintf("%v", this.TimerAckLevelTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`NamespaceNotificationVersion:` + fmt.Sprintf("%v", this.NamespaceNotificationVersion) + `,`,
		`ClusterTransferAckLevel:` + mapStringForClusterTransferAckLevel + `,`,
		`ClusterTimerAckLevel:` + mapStringForClusterTimerAckLevel + `,`,
		`ClusterReplicationLevel:` + mapStringForClusterReplicationLevel + `,`,
		`ReplicationDlqAckLevel:` + mapStringForReplicationDlqAckLevel + `,`,
		`VisibilityAckLevel:` + fmt.Sprintf("%v", this.VisibilityAckLevel) + `,`,
		`TieredStorageAckLevel:` + fmt.Sprintf("%v", this.TieredStorageAckLevel) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WorkflowExecutionInfo) String() string {
	if this == nil {
		return "nil"
	}
	keysForSearchAttributes := make([]string, 0, len(this.SearchAttributes))
	for k, _ := range this.SearchAttributes {
		keysForSearchAttributes = append(keysForSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSearchAttributes)
	mapStringForSearchAttributes := "map[string]*v11.Payload{"
	for _, k := range keysForSearchAttributes {
		mapStringForSearchAttributes += fmt.Sprintf("%v: %v,", k, this.SearchAttributes[k])
	}
	mapStringForSearchAttributes += "}"
	keysForMemo := make([]string, 0, len(this.Memo))
	for k, _ := range this.Memo {
		keysForMemo = append(keysForMemo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMemo)
	mapStringForMemo := "map[string]*v11.Payload{"
	for _, k := range keysForMemo {
		mapStringForMemo += fmt.Sprintf("%v: %v,", k, this.Memo[k])
	}
	mapStringForMemo += "}"
	s := strings.Join([]string{`&WorkflowExecutionInfo{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`ParentNamespaceId:` + fmt.Sprintf("%v", this.ParentNamespaceId) + `,`,
		`ParentWorkflowId:` + fmt.Sprintf("%v", this.ParentWorkflowId) + `,`,
		`ParentRunId:` + fmt.Sprintf("%v", this.ParentRunId) + `,`,
		`InitiatedId:` + fmt.Sprintf("%v", this.InitiatedId) + `,`,
		`CompletionEventBatchId:` + fmt.Sprintf("%v", this.CompletionEventBatchId) + `,`,
		`TaskQueue:` + fmt.Sprintf("%v", this.TaskQueue) + `,`,
		`WorkflowTypeName:` + fmt.Sprintf("%v", this.WorkflowTypeName) + `,`,
		`WorkflowExecutionTimeout:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecutionTimeout), "Duration", "types.Duration", 1) + `,`,
		`WorkflowRunTimeout:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowRunTimeout), "Duration", "types.Duration", 1) + `,`,
		`DefaultWorkflowTaskTimeout:` + strings.Replace(fmt.Sprintf("%v", this.DefaultWorkflowTaskTimeout), "Duration", "types.Duration", 1) + `,`,
		`LastEventTaskId:` + fmt.Sprintf("%v", this.LastEventTaskId) + `,`,
		`LastFirstEventId:` + fmt.Sprintf("%v", this.LastFirstEventId) + `,`,
		`LastWorkflowTaskStartId:` + fmt.Sprintf("%v", this.LastWorkflowTaskStartId) + `,`,
		`StartTime:` + strings.Replace(fmt.Sprintf("%v", this.StartTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`LastUpdateTime:` + strings.Replace(fmt.Sprintf("%v", this.LastUpdateTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`WorkflowTaskVersion:` + fmt.Sprintf("%v", this.WorkflowTaskVersion) + `,`,
		`WorkflowTaskScheduleId:` + fmt.Sprintf("%v", this.WorkflowTaskScheduleId) + `,`,
		`WorkflowTaskStartedId:` + fmt.Sprintf("%v", this.WorkflowTaskStartedId) + `,`,
		`WorkflowTaskTimeout:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowTaskTimeout), "Duration", "types.Duration", 1) + `,`,
		`WorkflowTaskAttempt:` + fmt.Sprintf("%v", this.WorkflowTaskAttempt) + `,`,
		`WorkflowTaskStartedTime:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowTaskStartedTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`WorkflowTaskScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowTaskScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`CancelRequested:` + fmt.Sprintf("%v", this.CancelRequested) + `,`,
		`WorkflowTaskOriginalScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowTaskOriginalScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`WorkflowTaskRequestId:` + fmt.Sprintf("%v", this.WorkflowTaskRequestId) + `,`,
		`CancelRequestId:` + fmt.Sprintf("%v", this.CancelRequestId) + `,`,
		`StickyTaskQueue:` + fmt.Sprintf("%v", this.StickyTaskQueue) + `,`,
		`StickyScheduleToStartTimeout:` + strings.Replace(fmt.Sprintf("%v", this.StickyScheduleToStartTimeout), "Duration", "types.Duration", 1) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`RetryInitialInterval:` + strings.Replace(fmt.Sprintf("%v", this.RetryInitialInterval), "Duration", "types.Duration", 1) + `,`,
		`RetryMaximumInterval:` + strings.Replace(fmt.Sprintf("%v", this.RetryMaximumInterval), "Duration", "types.Duration", 1) + `,`,
		`RetryMaximumAttempts:` + fmt.Sprintf("%v", this.RetryMaximumAttempts) + `,`,
		`RetryBackoffCoefficient:` + fmt.Sprintf("%v", this.RetryBackoffCoefficient) + `,`,
		`WorkflowExecutionExpirationTime:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecutionExpirationTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`RetryNonRetryableErrorTypes:` + fmt.Sprintf("%v", this.RetryNonRetryableErrorTypes) + `,`,
		`HasRetryPolicy:` + fmt.Sprintf("%v", this.HasRetryPolicy) + `,`,
		`CronSchedule:` + fmt.Sprintf("%v", this.CronSchedule) + `,`,
		`SignalCount:` + fmt.Sprintf("%v", this.SignalCount) + `,`,
		`AutoResetPoints:` + strings.Replace(fmt.Sprintf("%v", this.AutoResetPoints), "ResetPoints", "v1.ResetPoints", 1) + `,`,
		`SearchAttributes:` + mapStringForSearchAttributes + `,`,
		`Memo:` + mapStringForMemo + `,`,
		`VersionHistories:` + strings.Replace(fmt.Sprintf("%v", this.VersionHistories), "VersionHistories", "v12.VersionHistories", 1) + `,`,
		`FirstExecutionRunId:` + fmt.Sprintf("%v", this.FirstExecutionRunId) + `,`,
		`ExecutionStats:` + strings.Replace(this.ExecutionStats.String(), "ExecutionStats", "ExecutionStats", 1) + `,`,
		`WorkflowRunExpirationTime:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowRunExpirationTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`LastFirstEventTxnId:` + fmt.Sprintf("%v", this.LastFirstEventTxnId) + `,`,
		`StateTransitionCount:` + fmt.Sprintf("%v", this.StateTransitionCount) + `,`,
		`ExecutionTime:` + strings.Replace(fmt.Sprintf("%v", this.ExecutionTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`NewExecutionRunId:` + fmt.Sprintf("%v", this.NewExecutionRunId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ExecutionStats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ExecutionStats{`,
		`HistorySize:` + fmt.Sprintf("%v", this.HistorySize) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WorkflowExecutionState) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WorkflowExecutionState{`,
		`CreateRequestId:` + fmt.Sprintf("%v", this.CreateRequestId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TransferTaskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TransferTaskInfo{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`TaskType:` + fmt.Sprintf("%v", this.TaskType) + `,`,
		`TargetNamespaceId:` + fmt.Sprintf("%v", this.TargetNamespaceId) + `,`,
		`TargetWorkflowId:` + fmt.Sprintf("%v", this.TargetWorkflowId) + `,`,
		`TargetRunId:` + fmt.Sprintf("%v", this.TargetRunId) + `,`,
		`TaskQueue:` + fmt.Sprintf("%v", this.TaskQueue) + `,`,
		`TargetChildWorkflowOnly:` + fmt.Sprintf("%v", this.TargetChildWorkflowOnly) + `,`,
		`ScheduleId:` + fmt.Sprintf("%v", this.ScheduleId) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`VisibilityTime:` + strings.Replace(fmt.Sprintf("%v", this.VisibilityTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicationTaskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicationTaskInfo{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`TaskType:` + fmt.Sprintf("%v", this.TaskType) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`FirstEventId:` + fmt.Sprintf("%v", this.FirstEventId) + `,`,
		`NextEventId:` + fmt.Sprintf("%v", this.NextEventId) + `,`,
		`ScheduledId:` + fmt.Sprintf("%v", this.ScheduledId) + `,`,
		`BranchToken:` + fmt.Sprintf("%v", this.BranchToken) + `,`,
		`NewRunBranchToken:` + fmt.Sprintf("%v", this.NewRunBranchToken) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`VisibilityTime:` + strings.Replace(fmt.Sprintf("%v", this.VisibilityTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *VisibilityTaskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&VisibilityTaskInfo{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`TaskType:` + fmt.Sprintf("%v", this.TaskType) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`VisibilityTime:` + strings.Replace(fmt.Sprintf("%v", this.VisibilityTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TieredStorageTaskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TieredStorageTaskInfo{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`TaskType:` + fmt.Sprintf("%v", this.TaskType) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`VisibilityTime:` + strings.Replace(fmt.Sprintf("%v", this.VisibilityTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TimerTaskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TimerTaskInfo{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`TaskType:` + fmt.Sprintf("%v", this.TaskType) + `,`,
		`TimeoutType:` + fmt.Sprintf("%v", this.TimeoutType) + `,`,
		`WorkflowBackoffType:` + fmt.Sprintf("%v", this.WorkflowBackoffType) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`ScheduleAttempt:` + fmt.Sprintf("%v", this.ScheduleAttempt) + `,`,
		`EventId:` + fmt.Sprintf("%v", this.EventId) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`VisibilityTime:` + strings.Replace(fmt.Sprintf("%v", this.VisibilityTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ActivityInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ActivityInfo{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`ScheduledEventBatchId:` + fmt.Sprintf("%v", this.ScheduledEventBatchId) + `,`,
		`ScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.ScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`StartedId:` + fmt.Sprintf("%v", this.StartedId) + `,`,
		`StartedTime:` + strings.Replace(fmt.Sprintf("%v", this.StartedTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`ActivityId:` + fmt.Sprintf("%v", this.ActivityId) + `,`,
		`RequestId:` + fmt.Sprintf("%v", this.RequestId) + `,`,
		`ScheduleToStartTimeout:` + strings.Replace(fmt.Sprintf("%v", this.ScheduleToStartTimeout), "Duration", "types.Duration", 1) + `,`,
		`ScheduleToCloseTimeout:` + strings.Replace(fmt.Sprintf("%v", this.ScheduleToCloseTimeout), "Duration", "types.Duration", 1) + `,`,
		`StartToCloseTimeout:` + strings.Replace(fmt.Sprintf("%v", this.StartToCloseTimeout), "Duration", "types.Duration", 1) + `,`,
		`HeartbeatTimeout:` + strings.Replace(fmt.Sprintf("%v", this.HeartbeatTimeout), "Duration", "types.Duration", 1) + `,`,
		`CancelRequested:` + fmt.Sprintf("%v", this.CancelRequested) + `,`,
		`CancelRequestId:` + fmt.Sprintf("%v", this.CancelRequestId) + `,`,
		`TimerTaskStatus:` + fmt.Sprintf("%v", this.TimerTaskStatus) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`TaskQueue:` + fmt.Sprintf("%v", this.TaskQueue) + `,`,
		`StartedIdentity:` + fmt.Sprintf("%v", this.StartedIdentity) + `,`,
		`HasRetryPolicy:` + fmt.Sprintf("%v", this.HasRetryPolicy) + `,`,
		`RetryInitialInterval:` + strings.Replace(fmt.Sprintf("%v", this.RetryInitialInterval), "Duration", "types.Duration", 1) + `,`,
		`RetryMaximumInterval:` + strings.Replace(fmt.Sprintf("%v", this.RetryMaximumInterval), "Duration", "types.Duration", 1) + `,`,
		`RetryMaximumAttempts:` + fmt.Sprintf("%v", this.RetryMaximumAttempts) + `,`,
		`RetryExpirationTime:` + strings.Replace(fmt.Sprintf("%v", this.RetryExpirationTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`RetryBackoffCoefficient:` + fmt.Sprintf("%v", this.RetryBackoffCoefficient) + `,`,
		`RetryNonRetryableErrorTypes:` + fmt.Sprintf("%v", this.RetryNonRetryableErrorTypes) + `,`,
		`RetryLastFailure:` + strings.Replace(fmt.Sprintf("%v", this.RetryLastFailure), "Failure", "v15.Failure", 1) + `,`,
		`RetryLastWorkerIdentity:` + fmt.Sprintf("%v", this.RetryLastWorkerIdentity) + `,`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`ScheduleId:` + fmt.Sprintf("%v", this.ScheduleId) + `,`,
		`LastHeartbeatDetails:` + strings.Replace(fmt.Sprintf("%v", this.LastHeartbeatDetails), "Payloads", "v11.Payloads", 1) + `,`,
		`LastHeartbeatUpdateTime:` + strings.Replace(fmt.Sprintf("%v", this.LastHeartbeatUpdateTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TimerInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TimerInfo{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`StartedId:` + fmt.Sprintf("%v", this.StartedId) + `,`,
		`ExpiryTime:` + strings.Replace(fmt.Sprintf("%v", this.ExpiryTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`TaskStatus:` + fmt.Sprintf("%v", this.TaskStatus) + `,`,
		`TimerId:` + fmt.Sprintf("%v", this.TimerId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ChildExecutionInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ChildExecutionInfo{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`InitiatedEventBatchId:` + fmt.Sprintf("%v", this.InitiatedEventBatchId) + `,`,
		`StartedId:` + fmt.Sprintf("%v", this.StartedId) + `,`,
		`StartedWorkflowId:` + fmt.Sprintf("%v", this.StartedWorkflowId) + `,`,
		`StartedRunId:` + fmt.Sprintf("%v", this.StartedRunId) + `,`,
		`CreateRequestId:` + fmt.Sprintf("%v", this.CreateRequestId) + `,`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`WorkflowTypeName:` + fmt.Sprintf("%v", this.WorkflowTypeName) + `,`,
		`ParentClosePolicy:` + fmt.Sprintf("%v", this.ParentClosePolicy) + `,`,
		`InitiatedId:` + fmt.Sprintf("%v", this.InitiatedId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RequestCancelInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RequestCancelInfo{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`InitiatedEventBatchId:` + fmt.Sprintf("%v", this.InitiatedEventBatchId) + `,`,
		`CancelRequestId:` + fmt.Sprintf("%v", this.CancelRequestId) + `,`,
		`InitiatedId:` + fmt.Sprintf("%v", this.InitiatedId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SignalInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SignalInfo{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`InitiatedEventBatchId:` + fmt.Sprintf("%v", this.InitiatedEventBatchId) + `,`,
		`RequestId:` + fmt.Sprintf("%v", this.RequestId) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Input:` + strings.Replace(fmt.Sprintf("%v", this.Input), "Payloads", "v11.Payloads", 1) + `,`,
		`Control:` + fmt.Sprintf("%v", this.Control) + `,`,
		`InitiatedId:` + fmt.Sprintf("%v", this.InitiatedId) + `,`,
		`Header:` + strings.Replace(fmt.Sprintf("%v", this.Header), "Header", "v11.Header", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Checksum) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Checksum{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`Flavor:` + fmt.Sprintf("%v", this.Flavor) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringExecutions(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ShardInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ShardInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ShardInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeId", wireType)
			}
			m.RangeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Owner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Owner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationAckLevel", wireType)
			}
			m.ReplicationAckLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicationAckLevel |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransferAckLevel", wireType)
			}
			m.TransferAckLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TransferAckLevel |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StolenSinceRenew", wireType)
			}
			m.StolenSinceRenew = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StolenSinceRenew |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpdateTime == nil {
				m.UpdateTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.UpdateTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimerAckLevelTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimerAckLevelTime == nil {
				m.TimerAckLevelTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.TimerAckLevelTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceNotificationVersion", wireType)
			}
			m.NamespaceNotificationVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NamespaceNotificationVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterTransferAckLevel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClusterTransferAckLevel == nil {
				m.ClusterTransferAckLevel = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowExecutions
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowExecutions
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthExecutions
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthExecutions
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowExecutions
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipExecutions(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthExecutions
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ClusterTransferAckLevel[mapkey] = mapvalue
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterTimerAckLevel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClusterTimerAckLevel == nil {
				m.ClusterTimerAckLevel = make(map[string]*time.Time)
			}
			var mapkey string
			mapvalue := new(time.Time)
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowExecutions
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowExecutions
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthExecutions
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthExecutions
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowExecutions
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthExecutions
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthExecutions
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(mapvalue, dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipExecutions(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthExecutions
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ClusterTimerAckLevel[mapkey] = mapvalue
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterReplicationLevel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClusterReplicationLevel == nil {
				m.ClusterReplicationLevel = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowExecutions
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowExecutions
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthExecutions
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthExecutions
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowExecutions
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipExecutions(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthExecutions
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ClusterReplicationLevel[mapkey] = mapvalue
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationDlqAckLevel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReplicationDlqAckLevel == nil {
				m.ReplicationDlqAckLevel = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowExecutions
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowExecutions
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthExecutions
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthExecutions
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowExecutions
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipExecutions(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthExecutions
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ReplicationDlqAckLevel[mapkey] = mapvalue
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityAckLevel", wireType)
			}
			m.VisibilityAckLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.VisibilityAckLevel |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TieredStorageAckLevel", wireType)
			}
			m.TieredStorageAckLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TieredStorageAckLevel |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WorkflowExecutionInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WorkflowExecutionInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WorkflowExecutionInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentNamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentNamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentWorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentWorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentRunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentRunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedId", wireType)
			}
			m.InitiatedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletionEventBatchId", wireType)
			}
			m.CompletionEventBatchId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CompletionEventBatchId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskQueue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTypeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowTypeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecutionTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecutionTimeout == nil {
				m.WorkflowExecutionTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.WorkflowExecutionTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowRunTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowRunTimeout == nil {
				m.WorkflowRunTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.WorkflowRunTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultWorkflowTaskTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DefaultWorkflowTaskTimeout == nil {
				m.DefaultWorkflowTaskTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.DefaultWorkflowTaskTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastEventTaskId", wireType)
			}
			m.LastEventTaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastEventTaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastFirstEventId", wireType)
			}
			m.LastFirstEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastFirstEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastWorkflowTaskStartId", wireType)
			}
			m.LastWorkflowTaskStartId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastWorkflowTaskStartId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartTime == nil {
				m.StartTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdateTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdateTime == nil {
				m.LastUpdateTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.LastUpdateTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskVersion", wireType)
			}
			m.WorkflowTaskVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowTaskVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskScheduleId", wireType)
			}
			m.WorkflowTaskScheduleId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowTaskScheduleId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 24:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskStartedId", wireType)
			}
			m.WorkflowTaskStartedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowTaskStartedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowTaskTimeout == nil {
				m.WorkflowTaskTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.WorkflowTaskTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskAttempt", wireType)
			}
			m.WorkflowTaskAttempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowTaskAttempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskStartedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowTaskStartedTime == nil {
				m.WorkflowTaskStartedTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.WorkflowTaskStartedTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowTaskScheduledTime == nil {
				m.WorkflowTaskScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.WorkflowTaskScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 29:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequested", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CancelRequested = bool(v != 0)
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskOriginalScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowTaskOriginalScheduledTime == nil {
				m.WorkflowTaskOriginalScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.WorkflowTaskOriginalScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskRequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowTaskRequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CancelRequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StickyTaskQueue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StickyTaskQueue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StickyScheduleToStartTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StickyScheduleToStartTimeout == nil {
				m.StickyScheduleToStartTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.StickyScheduleToStartTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 35:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryInitialInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryInitialInterval == nil {
				m.RetryInitialInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.RetryInitialInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryMaximumInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryMaximumInterval == nil {
				m.RetryMaximumInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.RetryMaximumInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 38:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryMaximumAttempts", wireType)
			}
			m.RetryMaximumAttempts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RetryMaximumAttempts |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 39:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryBackoffCoefficient", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.RetryBackoffCoefficient = float64(math.Float64frombits(v))
		case 40:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecutionExpirationTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecutionExpirationTime == nil {
				m.WorkflowExecutionExpirationTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.WorkflowExecutionExpirationTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 41:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryNonRetryableErrorTypes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RetryNonRetryableErrorTypes = append(m.RetryNonRetryableErrorTypes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 42:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasRetryPolicy", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasRetryPolicy = bool(v != 0)
		case 43:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CronSchedule", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CronSchedule = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 46:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignalCount", wireType)
			}
			m.SignalCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SignalCount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 51:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AutoResetPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AutoResetPoints == nil {
				m.AutoResetPoints = &v1.ResetPoints{}
			}
			if err := m.AutoResetPoints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 52:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SearchAttributes == nil {
				m.SearchAttributes = make(map[string]*v11.Payload)
			}
			var mapkey string
			var mapvalue *v11.Payload
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowExecutions
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowExecutions
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthExecutions
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthExecutions
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowExecutions
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthExecutions
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthExecutions
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v11.Payload{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipExecutions(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthExecutions
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SearchAttributes[mapkey] = mapvalue
			iNdEx = postIndex
		case 53:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Memo == nil {
				m.Memo = make(map[string]*v11.Payload)
			}
			var mapkey string
			var mapvalue *v11.Payload
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowExecutions
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowExecutions
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthExecutions
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthExecutions
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowExecutions
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthExecutions
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthExecutions
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v11.Payload{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipExecutions(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthExecutions
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Memo[mapkey] = mapvalue
			iNdEx = postIndex
		case 54:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionHistories", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionHistories == nil {
				m.VersionHistories = &v12.VersionHistories{}
			}
			if err := m.VersionHistories.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 55:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstExecutionRunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FirstExecutionRunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 56:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutionStats == nil {
				m.ExecutionStats = &ExecutionStats{}
			}
			if err := m.ExecutionStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 57:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowRunExpirationTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowRunExpirationTime == nil {
				m.WorkflowRunExpirationTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.WorkflowRunExpirationTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 58:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastFirstEventTxnId", wireType)
			}
			m.LastFirstEventTxnId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastFirstEventTxnId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 59:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StateTransitionCount", wireType)
			}
			m.StateTransitionCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StateTransitionCount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 60:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutionTime == nil {
				m.ExecutionTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ExecutionTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 61:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewExecutionRunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NewExecutionRunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExecutionStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExecutionStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExecutionStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistorySize", wireType)
			}
			m.HistorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HistorySize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WorkflowExecutionState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WorkflowExecutionState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WorkflowExecutionState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreateRequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreateRequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= v13.WorkflowExecutionState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= v14.WorkflowExecutionStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransferTaskInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransferTaskInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransferTaskInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskType", wireType)
			}
			m.TaskType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskType |= v13.TaskType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetNamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetNamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetWorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetWorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetRunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetRunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskQueue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetChildWorkflowOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TargetChildWorkflowOnly = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleId", wireType)
			}
			m.ScheduleId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VisibilityTime == nil {
				m.VisibilityTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.VisibilityTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicationTaskInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicationTaskInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicationTaskInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskType", wireType)
			}
			m.TaskType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskType |= v13.TaskType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstEventId", wireType)
			}
			m.FirstEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FirstEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextEventId", wireType)
			}
			m.NextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledId", wireType)
			}
			m.ScheduledId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduledId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BranchToken = append(m.BranchToken[:0], dAtA[iNdEx:postIndex]...)
			if m.BranchToken == nil {
				m.BranchToken = []byte{}
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewRunBranchToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NewRunBranchToken = append(m.NewRunBranchToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NewRunBranchToken == nil {
				m.NewRunBranchToken = []byte{}
			}
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VisibilityTime == nil {
				m.VisibilityTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.VisibilityTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VisibilityTaskInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VisibilityTaskInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VisibilityTaskInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskType", wireType)
			}
			m.TaskType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskType |= v13.TaskType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VisibilityTime == nil {
				m.VisibilityTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.VisibilityTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TieredStorageTaskInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TieredStorageTaskInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TieredStorageTaskInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskType", wireType)
			}
			m.TaskType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskType |= v13.TaskType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VisibilityTime == nil {
				m.VisibilityTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.VisibilityTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimerTaskInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimerTaskInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimerTaskInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskType", wireType)
			}
			m.TaskType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskType |= v13.TaskType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeoutType", wireType)
			}
			m.TimeoutType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeoutType |= v14.TimeoutType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowBackoffType", wireType)
			}
			m.WorkflowBackoffType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowBackoffType |= v13.WorkflowBackoffType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleAttempt", wireType)
			}
			m.ScheduleAttempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleAttempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventId", wireType)
			}
			m.EventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VisibilityTime == nil {
				m.VisibilityTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.VisibilityTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ActivityInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ActivityInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ActivityInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledEventBatchId", wireType)
			}
			m.ScheduledEventBatchId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduledEventBatchId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduledTime == nil {
				m.ScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedId", wireType)
			}
			m.StartedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedTime == nil {
				m.StartedTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartedTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActivityId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActivityId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleToStartTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduleToStartTimeout == nil {
				m.ScheduleToStartTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.ScheduleToStartTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleToCloseTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduleToCloseTimeout == nil {
				m.ScheduleToCloseTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.ScheduleToCloseTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartToCloseTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartToCloseTimeout == nil {
				m.StartToCloseTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.StartToCloseTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HeartbeatTimeout == nil {
				m.HeartbeatTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.HeartbeatTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequested", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CancelRequested = bool(v != 0)
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequestId", wireType)
			}
			m.CancelRequestId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CancelRequestId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimerTaskStatus", wireType)
			}
			m.TimerTaskStatus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimerTaskStatus |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskQueue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedIdentity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartedIdentity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasRetryPolicy", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasRetryPolicy = bool(v != 0)
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryInitialInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryInitialInterval == nil {
				m.RetryInitialInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.RetryInitialInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryMaximumInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryMaximumInterval == nil {
				m.RetryMaximumInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.RetryMaximumInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryMaximumAttempts", wireType)
			}
			m.RetryMaximumAttempts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RetryMaximumAttempts |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryExpirationTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryExpirationTime == nil {
				m.RetryExpirationTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.RetryExpirationTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 25:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryBackoffCoefficient", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.RetryBackoffCoefficient = float64(math.Float64frombits(v))
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryNonRetryableErrorTypes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RetryNonRetryableErrorTypes = append(m.RetryNonRetryableErrorTypes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryLastFailure", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryLastFailure == nil {
				m.RetryLastFailure = &v15.Failure{}
			}
			if err := m.RetryLastFailure.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryLastWorkerIdentity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RetryLastWorkerIdentity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 30:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleId", wireType)
			}
			m.ScheduleId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeatDetails", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastHeartbeatDetails == nil {
				m.LastHeartbeatDetails = &v11.Payloads{}
			}
			if err := m.LastHeartbeatDetails.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeatUpdateTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastHeartbeatUpdateTime == nil {
				m.LastHeartbeatUpdateTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.LastHeartbeatUpdateTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimerInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimerInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimerInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedId", wireType)
			}
			m.StartedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiryTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpiryTime == nil {
				m.ExpiryTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ExpiryTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskStatus", wireType)
			}
			m.TaskStatus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskStatus |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TimerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChildExecutionInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChildExecutionInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChildExecutionInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedEventBatchId", wireType)
			}
			m.InitiatedEventBatchId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedEventBatchId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedId", wireType)
			}
			m.StartedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedWorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartedWorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedRunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartedRunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreateRequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreateRequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTypeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowTypeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentClosePolicy", wireType)
			}
			m.ParentClosePolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ParentClosePolicy |= v14.ParentClosePolicy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedId", wireType)
			}
			m.InitiatedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestCancelInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestCancelInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestCancelInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedEventBatchId", wireType)
			}
			m.InitiatedEventBatchId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedEventBatchId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CancelRequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedId", wireType)
			}
			m.InitiatedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SignalInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SignalInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SignalInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedEventBatchId", wireType)
			}
			m.InitiatedEventBatchId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedEventBatchId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Input", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Input == nil {
				m.Input = &v11.Payloads{}
			}
			if err := m.Input.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Control", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Control = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedId", wireType)
			}
			m.InitiatedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &v11.Header{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Checksum) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Checksum: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Checksum: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flavor", wireType)
			}
			m.Flavor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flavor |= v13.ChecksumFlavor(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthExecutions
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthExecutions
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutions(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExecutions
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipExecutions(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowExecutions
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowExecutions
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthExecutions
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupExecutions
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthExecutions
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthExecutions        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowExecutions          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupExecutions = fmt.Errorf("proto: unexpected end of group")
)
