// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/matchingservice/v1/service.proto

package matchingservice

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

func init() {
	proto.RegisterFile("temporal/server/api/matchingservice/v1/service.proto", fileDescriptor_1a5c83076e651916)
}

var fileDescriptor_1a5c83076e651916 = []byte{
	// 456 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x95, 0xbf, 0x6e, 0x1a, 0x31,
	0x1c, 0x80, 0xcf, 0x4b, 0x07, 0x57, 0x15, 0xea, 0x49, 0x55, 0x55, 0x06, 0x0f, 0x1d, 0x3a, 0xde,
	0x89, 0xb6, 0x5b, 0xa1, 0x2d, 0x85, 0xfe, 0x93, 0x5a, 0x15, 0xda, 0x4a, 0x95, 0xba, 0x54, 0xe6,
	0xce, 0xa5, 0x16, 0xc7, 0xf9, 0x6a, 0xfb, 0x2e, 0x62, 0xcb, 0x13, 0x44, 0x19, 0x32, 0xe5, 0x01,
	0xa2, 0x0c, 0x99, 0xf2, 0x14, 0x19, 0x32, 0x30, 0x32, 0x86, 0x63, 0xc9, 0xc8, 0x23, 0x44, 0x70,
	0xf8, 0x80, 0x03, 0x22, 0x73, 0x64, 0x03, 0xe3, 0xef, 0xf3, 0x67, 0x89, 0x9f, 0x0c, 0x5f, 0x4a,
	0xd2, 0x0d, 0x18, 0xc7, 0x9e, 0x2d, 0x08, 0x8f, 0x08, 0xb7, 0x71, 0x40, 0xed, 0x2e, 0x96, 0xce,
	0x3f, 0xea, 0xb7, 0x27, 0x4b, 0xd4, 0x21, 0x76, 0x54, 0xb2, 0x67, 0x1f, 0xad, 0x80, 0x33, 0xc9,
	0xcc, 0x67, 0x8a, 0xb2, 0x12, 0xca, 0xc2, 0x01, 0xb5, 0x32, 0x94, 0x15, 0x95, 0x8a, 0x15, 0x4d,
	0x3b, 0x27, 0xff, 0x43, 0x22, 0xe4, 0x1f, 0x4e, 0x44, 0xc0, 0x7c, 0x31, 0x3b, 0xe6, 0xf9, 0xe5,
	0x7d, 0x58, 0xf8, 0x3a, 0xdb, 0xfd, 0x23, 0xd9, 0x6d, 0x9e, 0x00, 0xf8, 0xa8, 0xc1, 0x3c, 0xef,
	0x17, 0xe3, 0x9d, 0xbf, 0x1e, 0xdb, 0xfb, 0x89, 0x45, 0xa7, 0x19, 0x92, 0x90, 0x98, 0x75, 0x4b,
	0xaf, 0xca, 0x5a, 0x8b, 0x7f, 0x4f, 0x12, 0x8a, 0xef, 0x77, 0xb4, 0x24, 0x17, 0x78, 0x6a, 0xa4,
	0xa1, 0x55, 0x47, 0xd2, 0x88, 0xca, 0x5e, 0xce, 0xd0, 0x15, 0x3c, 0x57, 0xe8, 0x1a, 0x4b, 0x1a,
	0x7a, 0x04, 0x60, 0xa1, 0xea, 0xba, 0x8b, 0x77, 0x31, 0x5f, 0xeb, 0xca, 0x33, 0xa0, 0x8a, 0x7b,
	0x93, 0x9b, 0xcf, 0x66, 0x2d, 0x96, 0x6f, 0x95, 0xb5, 0x08, 0xe6, 0xc9, 0x5a, 0xe6, 0xd3, 0xac,
	0x03, 0x00, 0x1f, 0x34, 0x43, 0xc2, 0x7b, 0x2a, 0xdb, 0x2c, 0xeb, 0x4a, 0x97, 0x30, 0x95, 0x54,
	0xc9, 0x49, 0xa7, 0x41, 0xe7, 0x00, 0x3e, 0x49, 0xbe, 0xba, 0xd3, 0x2d, 0x93, 0xde, 0x1a, 0xeb,
	0x06, 0x1e, 0x91, 0xc4, 0x35, 0x3f, 0xe9, 0xea, 0x37, 0x2a, 0x54, 0xe8, 0xe7, 0x3b, 0x30, 0x2d,
	0x0d, 0x47, 0x0d, 0xfb, 0x0e, 0xf1, 0xbe, 0x85, 0x52, 0x48, 0xec, 0xbb, 0xd4, 0x6f, 0x4f, 0xfe,
	0xa8, 0xfa, 0xc3, 0xb1, 0x16, 0xdf, 0x7a, 0x38, 0x36, 0x58, 0xd2, 0xd0, 0x63, 0x00, 0x1f, 0xd6,
	0x89, 0x70, 0x38, 0x6d, 0x91, 0xf9, 0x04, 0xbf, 0xd5, 0xd5, 0xaf, 0xa0, 0x2a, 0xb0, 0xba, 0x83,
	0x21, 0x8d, 0x3b, 0x03, 0xf0, 0xf1, 0x17, 0x2a, 0x64, 0xfa, 0x5b, 0x03, 0x73, 0x49, 0x25, 0x65,
	0xbe, 0x30, 0x3f, 0xe8, 0x1e, 0xb0, 0x41, 0xa0, 0x42, 0x3f, 0xee, 0xec, 0x51, 0xb9, 0xef, 0x78,
	0x7f, 0x88, 0x8c, 0xc1, 0x10, 0x19, 0xe3, 0x21, 0x02, 0xfb, 0x31, 0x02, 0xa7, 0x31, 0x02, 0x17,
	0x31, 0x02, 0xfd, 0x18, 0x81, 0xab, 0x18, 0x81, 0xeb, 0x18, 0x19, 0xe3, 0x18, 0x81, 0xc3, 0x11,
	0x32, 0xfa, 0x23, 0x64, 0x0c, 0x46, 0xc8, 0xf8, 0x5d, 0x6e, 0xb3, 0x79, 0x02, 0x65, 0xb7, 0xbf,
	0x24, 0xaf, 0x32, 0x4b, 0xad, 0x7b, 0xd3, 0x97, 0xe4, 0xc5, 0x4d, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x04, 0x9e, 0xce, 0x0a, 0xe8, 0x06, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// MatchingServiceClient is the client API for MatchingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MatchingServiceClient interface {
	// PollWorkflowTaskQueue is called by frontend to process WorkflowTask from a specific task queue.  A
	// WorkflowTask is dispatched to callers for active workflow executions, with pending workflow tasks.
	PollWorkflowTaskQueue(ctx context.Context, in *PollWorkflowTaskQueueRequest, opts ...grpc.CallOption) (*PollWorkflowTaskQueueResponse, error)
	// PollActivityTaskQueue is called by frontend to process ActivityTask from a specific task queue.  ActivityTask
	// is dispatched to callers whenever a ScheduleTask command is made for a workflow execution.
	PollActivityTaskQueue(ctx context.Context, in *PollActivityTaskQueueRequest, opts ...grpc.CallOption) (*PollActivityTaskQueueResponse, error)
	// AddWorkflowTask is called by the history service when a workflow task is scheduled, so that it can be dispatched
	// by the MatchingEngine.
	AddWorkflowTask(ctx context.Context, in *AddWorkflowTaskRequest, opts ...grpc.CallOption) (*AddWorkflowTaskResponse, error)
	// AddActivityTask is called by the history service when a workflow task is scheduled, so that it can be dispatched
	// by the MatchingEngine.
	AddActivityTask(ctx context.Context, in *AddActivityTaskRequest, opts ...grpc.CallOption) (*AddActivityTaskResponse, error)
	// QueryWorkflow is called by frontend to query a workflow.
	QueryWorkflow(ctx context.Context, in *QueryWorkflowRequest, opts ...grpc.CallOption) (*QueryWorkflowResponse, error)
	// RespondQueryTaskCompleted is called by frontend to respond query completed.
	RespondQueryTaskCompleted(ctx context.Context, in *RespondQueryTaskCompletedRequest, opts ...grpc.CallOption) (*RespondQueryTaskCompletedResponse, error)
	// CancelOutstandingPoll is called by frontend to unblock long polls on matching for zombie pollers.
	// Our rpc stack does not support context propagation, so when a client connection goes away frontend sees
	// cancellation of context for that handler, but any corresponding calls (long-poll) to matching service does not
	// see the cancellation propagated so it can unblock corresponding long-polls on its end.  This results is tasks
	// being dispatched to zombie pollers in this situation.  This API is added so every time frontend makes a long-poll
	// api call to matching it passes in a pollerId and then calls this API when it detects client connection is closed
	// to unblock long polls for this poller and prevent tasks being sent to these zombie pollers.
	CancelOutstandingPoll(ctx context.Context, in *CancelOutstandingPollRequest, opts ...grpc.CallOption) (*CancelOutstandingPollResponse, error)
	// DescribeTaskQueue returns information about the target task queue, right now this API returns the
	// pollers which polled this task queue in last few minutes.
	DescribeTaskQueue(ctx context.Context, in *DescribeTaskQueueRequest, opts ...grpc.CallOption) (*DescribeTaskQueueResponse, error)
	// ListTaskQueuePartitions returns a map of partitionKey and hostAddress for a task queue.
	ListTaskQueuePartitions(ctx context.Context, in *ListTaskQueuePartitionsRequest, opts ...grpc.CallOption) (*ListTaskQueuePartitionsResponse, error)
}

type matchingServiceClient struct {
	cc *grpc.ClientConn
}

func NewMatchingServiceClient(cc *grpc.ClientConn) MatchingServiceClient {
	return &matchingServiceClient{cc}
}

func (c *matchingServiceClient) PollWorkflowTaskQueue(ctx context.Context, in *PollWorkflowTaskQueueRequest, opts ...grpc.CallOption) (*PollWorkflowTaskQueueResponse, error) {
	out := new(PollWorkflowTaskQueueResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.matchingservice.v1.MatchingService/PollWorkflowTaskQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) PollActivityTaskQueue(ctx context.Context, in *PollActivityTaskQueueRequest, opts ...grpc.CallOption) (*PollActivityTaskQueueResponse, error) {
	out := new(PollActivityTaskQueueResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.matchingservice.v1.MatchingService/PollActivityTaskQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) AddWorkflowTask(ctx context.Context, in *AddWorkflowTaskRequest, opts ...grpc.CallOption) (*AddWorkflowTaskResponse, error) {
	out := new(AddWorkflowTaskResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.matchingservice.v1.MatchingService/AddWorkflowTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) AddActivityTask(ctx context.Context, in *AddActivityTaskRequest, opts ...grpc.CallOption) (*AddActivityTaskResponse, error) {
	out := new(AddActivityTaskResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.matchingservice.v1.MatchingService/AddActivityTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) QueryWorkflow(ctx context.Context, in *QueryWorkflowRequest, opts ...grpc.CallOption) (*QueryWorkflowResponse, error) {
	out := new(QueryWorkflowResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.matchingservice.v1.MatchingService/QueryWorkflow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) RespondQueryTaskCompleted(ctx context.Context, in *RespondQueryTaskCompletedRequest, opts ...grpc.CallOption) (*RespondQueryTaskCompletedResponse, error) {
	out := new(RespondQueryTaskCompletedResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.matchingservice.v1.MatchingService/RespondQueryTaskCompleted", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) CancelOutstandingPoll(ctx context.Context, in *CancelOutstandingPollRequest, opts ...grpc.CallOption) (*CancelOutstandingPollResponse, error) {
	out := new(CancelOutstandingPollResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.matchingservice.v1.MatchingService/CancelOutstandingPoll", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) DescribeTaskQueue(ctx context.Context, in *DescribeTaskQueueRequest, opts ...grpc.CallOption) (*DescribeTaskQueueResponse, error) {
	out := new(DescribeTaskQueueResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.matchingservice.v1.MatchingService/DescribeTaskQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) ListTaskQueuePartitions(ctx context.Context, in *ListTaskQueuePartitionsRequest, opts ...grpc.CallOption) (*ListTaskQueuePartitionsResponse, error) {
	out := new(ListTaskQueuePartitionsResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.matchingservice.v1.MatchingService/ListTaskQueuePartitions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MatchingServiceServer is the server API for MatchingService service.
type MatchingServiceServer interface {
	// PollWorkflowTaskQueue is called by frontend to process WorkflowTask from a specific task queue.  A
	// WorkflowTask is dispatched to callers for active workflow executions, with pending workflow tasks.
	PollWorkflowTaskQueue(context.Context, *PollWorkflowTaskQueueRequest) (*PollWorkflowTaskQueueResponse, error)
	// PollActivityTaskQueue is called by frontend to process ActivityTask from a specific task queue.  ActivityTask
	// is dispatched to callers whenever a ScheduleTask command is made for a workflow execution.
	PollActivityTaskQueue(context.Context, *PollActivityTaskQueueRequest) (*PollActivityTaskQueueResponse, error)
	// AddWorkflowTask is called by the history service when a workflow task is scheduled, so that it can be dispatched
	// by the MatchingEngine.
	AddWorkflowTask(context.Context, *AddWorkflowTaskRequest) (*AddWorkflowTaskResponse, error)
	// AddActivityTask is called by the history service when a workflow task is scheduled, so that it can be dispatched
	// by the MatchingEngine.
	AddActivityTask(context.Context, *AddActivityTaskRequest) (*AddActivityTaskResponse, error)
	// QueryWorkflow is called by frontend to query a workflow.
	QueryWorkflow(context.Context, *QueryWorkflowRequest) (*QueryWorkflowResponse, error)
	// RespondQueryTaskCompleted is called by frontend to respond query completed.
	RespondQueryTaskCompleted(context.Context, *RespondQueryTaskCompletedRequest) (*RespondQueryTaskCompletedResponse, error)
	// CancelOutstandingPoll is called by frontend to unblock long polls on matching for zombie pollers.
	// Our rpc stack does not support context propagation, so when a client connection goes away frontend sees
	// cancellation of context for that handler, but any corresponding calls (long-poll) to matching service does not
	// see the cancellation propagated so it can unblock corresponding long-polls on its end.  This results is tasks
	// being dispatched to zombie pollers in this situation.  This API is added so every time frontend makes a long-poll
	// api call to matching it passes in a pollerId and then calls this API when it detects client connection is closed
	// to unblock long polls for this poller and prevent tasks being sent to these zombie pollers.
	CancelOutstandingPoll(context.Context, *CancelOutstandingPollRequest) (*CancelOutstandingPollResponse, error)
	// DescribeTaskQueue returns information about the target task queue, right now this API returns the
	// pollers which polled this task queue in last few minutes.
	DescribeTaskQueue(context.Context, *DescribeTaskQueueRequest) (*DescribeTaskQueueResponse, error)
	// ListTaskQueuePartitions returns a map of partitionKey and hostAddress for a task queue.
	ListTaskQueuePartitions(context.Context, *ListTaskQueuePartitionsRequest) (*ListTaskQueuePartitionsResponse, error)
}

// UnimplementedMatchingServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMatchingServiceServer struct {
}

func (*UnimplementedMatchingServiceServer) PollWorkflowTaskQueue(ctx context.Context, req *PollWorkflowTaskQueueRequest) (*PollWorkflowTaskQueueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PollWorkflowTaskQueue not implemented")
}
func (*UnimplementedMatchingServiceServer) PollActivityTaskQueue(ctx context.Context, req *PollActivityTaskQueueRequest) (*PollActivityTaskQueueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PollActivityTaskQueue not implemented")
}
func (*UnimplementedMatchingServiceServer) AddWorkflowTask(ctx context.Context, req *AddWorkflowTaskRequest) (*AddWorkflowTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddWorkflowTask not implemented")
}
func (*UnimplementedMatchingServiceServer) AddActivityTask(ctx context.Context, req *AddActivityTaskRequest) (*AddActivityTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddActivityTask not implemented")
}
func (*UnimplementedMatchingServiceServer) QueryWorkflow(ctx context.Context, req *QueryWorkflowRequest) (*QueryWorkflowResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryWorkflow not implemented")
}
func (*UnimplementedMatchingServiceServer) RespondQueryTaskCompleted(ctx context.Context, req *RespondQueryTaskCompletedRequest) (*RespondQueryTaskCompletedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondQueryTaskCompleted not implemented")
}
func (*UnimplementedMatchingServiceServer) CancelOutstandingPoll(ctx context.Context, req *CancelOutstandingPollRequest) (*CancelOutstandingPollResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelOutstandingPoll not implemented")
}
func (*UnimplementedMatchingServiceServer) DescribeTaskQueue(ctx context.Context, req *DescribeTaskQueueRequest) (*DescribeTaskQueueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeTaskQueue not implemented")
}
func (*UnimplementedMatchingServiceServer) ListTaskQueuePartitions(ctx context.Context, req *ListTaskQueuePartitionsRequest) (*ListTaskQueuePartitionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTaskQueuePartitions not implemented")
}

func RegisterMatchingServiceServer(s *grpc.Server, srv MatchingServiceServer) {
	s.RegisterService(&_MatchingService_serviceDesc, srv)
}

func _MatchingService_PollWorkflowTaskQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PollWorkflowTaskQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).PollWorkflowTaskQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.matchingservice.v1.MatchingService/PollWorkflowTaskQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).PollWorkflowTaskQueue(ctx, req.(*PollWorkflowTaskQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_PollActivityTaskQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PollActivityTaskQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).PollActivityTaskQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.matchingservice.v1.MatchingService/PollActivityTaskQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).PollActivityTaskQueue(ctx, req.(*PollActivityTaskQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_AddWorkflowTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddWorkflowTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).AddWorkflowTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.matchingservice.v1.MatchingService/AddWorkflowTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).AddWorkflowTask(ctx, req.(*AddWorkflowTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_AddActivityTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddActivityTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).AddActivityTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.matchingservice.v1.MatchingService/AddActivityTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).AddActivityTask(ctx, req.(*AddActivityTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_QueryWorkflow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryWorkflowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).QueryWorkflow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.matchingservice.v1.MatchingService/QueryWorkflow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).QueryWorkflow(ctx, req.(*QueryWorkflowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_RespondQueryTaskCompleted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondQueryTaskCompletedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).RespondQueryTaskCompleted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.matchingservice.v1.MatchingService/RespondQueryTaskCompleted",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).RespondQueryTaskCompleted(ctx, req.(*RespondQueryTaskCompletedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_CancelOutstandingPoll_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelOutstandingPollRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).CancelOutstandingPoll(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.matchingservice.v1.MatchingService/CancelOutstandingPoll",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).CancelOutstandingPoll(ctx, req.(*CancelOutstandingPollRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_DescribeTaskQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeTaskQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).DescribeTaskQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.matchingservice.v1.MatchingService/DescribeTaskQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).DescribeTaskQueue(ctx, req.(*DescribeTaskQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_ListTaskQueuePartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTaskQueuePartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).ListTaskQueuePartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.matchingservice.v1.MatchingService/ListTaskQueuePartitions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).ListTaskQueuePartitions(ctx, req.(*ListTaskQueuePartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MatchingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "temporal.server.api.matchingservice.v1.MatchingService",
	HandlerType: (*MatchingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "PollWorkflowTaskQueue",
			Handler:    _MatchingService_PollWorkflowTaskQueue_Handler,
		},
		{
			MethodName: "PollActivityTaskQueue",
			Handler:    _MatchingService_PollActivityTaskQueue_Handler,
		},
		{
			MethodName: "AddWorkflowTask",
			Handler:    _MatchingService_AddWorkflowTask_Handler,
		},
		{
			MethodName: "AddActivityTask",
			Handler:    _MatchingService_AddActivityTask_Handler,
		},
		{
			MethodName: "QueryWorkflow",
			Handler:    _MatchingService_QueryWorkflow_Handler,
		},
		{
			MethodName: "RespondQueryTaskCompleted",
			Handler:    _MatchingService_RespondQueryTaskCompleted_Handler,
		},
		{
			MethodName: "CancelOutstandingPoll",
			Handler:    _MatchingService_CancelOutstandingPoll_Handler,
		},
		{
			MethodName: "DescribeTaskQueue",
			Handler:    _MatchingService_DescribeTaskQueue_Handler,
		},
		{
			MethodName: "ListTaskQueuePartitions",
			Handler:    _MatchingService_ListTaskQueuePartitions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "temporal/server/api/matchingservice/v1/service.proto",
}
