// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/cluster/v1/message.proto

package cluster

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	v1 "go.temporal.io/server/api/enums/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type HostInfo struct {
	Identity string `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
}

func (m *HostInfo) Reset()      { *m = HostInfo{} }
func (*HostInfo) ProtoMessage() {}
func (*HostInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_fcc65697c8eece3a, []int{0}
}
func (m *HostInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HostInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HostInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HostInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostInfo.Merge(m, src)
}
func (m *HostInfo) XXX_Size() int {
	return m.Size()
}
func (m *HostInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HostInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HostInfo proto.InternalMessageInfo

func (m *HostInfo) GetIdentity() string {
	if m != nil {
		return m.Identity
	}
	return ""
}

type RingInfo struct {
	Role        string      `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	MemberCount int32       `protobuf:"varint,2,opt,name=member_count,json=memberCount,proto3" json:"member_count,omitempty"`
	Members     []*HostInfo `protobuf:"bytes,3,rep,name=members,proto3" json:"members,omitempty"`
}

func (m *RingInfo) Reset()      { *m = RingInfo{} }
func (*RingInfo) ProtoMessage() {}
func (*RingInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_fcc65697c8eece3a, []int{1}
}
func (m *RingInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RingInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RingInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RingInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RingInfo.Merge(m, src)
}
func (m *RingInfo) XXX_Size() int {
	return m.Size()
}
func (m *RingInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_RingInfo.DiscardUnknown(m)
}

var xxx_messageInfo_RingInfo proto.InternalMessageInfo

func (m *RingInfo) GetRole() string {
	if m != nil {
		return m.Role
	}
	return ""
}

func (m *RingInfo) GetMemberCount() int32 {
	if m != nil {
		return m.MemberCount
	}
	return 0
}

func (m *RingInfo) GetMembers() []*HostInfo {
	if m != nil {
		return m.Members
	}
	return nil
}

type MembershipInfo struct {
	CurrentHost      *HostInfo   `protobuf:"bytes,1,opt,name=current_host,json=currentHost,proto3" json:"current_host,omitempty"`
	ReachableMembers []string    `protobuf:"bytes,2,rep,name=reachable_members,json=reachableMembers,proto3" json:"reachable_members,omitempty"`
	Rings            []*RingInfo `protobuf:"bytes,3,rep,name=rings,proto3" json:"rings,omitempty"`
}

func (m *MembershipInfo) Reset()      { *m = MembershipInfo{} }
func (*MembershipInfo) ProtoMessage() {}
func (*MembershipInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_fcc65697c8eece3a, []int{2}
}
func (m *MembershipInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MembershipInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MembershipInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MembershipInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MembershipInfo.Merge(m, src)
}
func (m *MembershipInfo) XXX_Size() int {
	return m.Size()
}
func (m *MembershipInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_MembershipInfo.DiscardUnknown(m)
}

var xxx_messageInfo_MembershipInfo proto.InternalMessageInfo

func (m *MembershipInfo) GetCurrentHost() *HostInfo {
	if m != nil {
		return m.CurrentHost
	}
	return nil
}

func (m *MembershipInfo) GetReachableMembers() []string {
	if m != nil {
		return m.ReachableMembers
	}
	return nil
}

func (m *MembershipInfo) GetRings() []*RingInfo {
	if m != nil {
		return m.Rings
	}
	return nil
}

type ClusterMember struct {
	Role             v1.ClusterMemberRole `protobuf:"varint,1,opt,name=role,proto3,enum=temporal.server.api.enums.v1.ClusterMemberRole" json:"role,omitempty"`
	HostId           string               `protobuf:"bytes,2,opt,name=host_id,json=hostId,proto3" json:"host_id,omitempty"`
	RpcAddress       string               `protobuf:"bytes,3,opt,name=rpc_address,json=rpcAddress,proto3" json:"rpc_address,omitempty"`
	RpcPort          int32                `protobuf:"varint,4,opt,name=rpc_port,json=rpcPort,proto3" json:"rpc_port,omitempty"`
	SessionStartTime *time.Time           `protobuf:"bytes,5,opt,name=session_start_time,json=sessionStartTime,proto3,stdtime" json:"session_start_time,omitempty"`
	LastHeartbitTime *time.Time           `protobuf:"bytes,6,opt,name=last_heartbit_time,json=lastHeartbitTime,proto3,stdtime" json:"last_heartbit_time,omitempty"`
	RecordExpiryTime *time.Time           `protobuf:"bytes,7,opt,name=record_expiry_time,json=recordExpiryTime,proto3,stdtime" json:"record_expiry_time,omitempty"`
}

func (m *ClusterMember) Reset()      { *m = ClusterMember{} }
func (*ClusterMember) ProtoMessage() {}
func (*ClusterMember) Descriptor() ([]byte, []int) {
	return fileDescriptor_fcc65697c8eece3a, []int{3}
}
func (m *ClusterMember) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterMember) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterMember.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterMember) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterMember.Merge(m, src)
}
func (m *ClusterMember) XXX_Size() int {
	return m.Size()
}
func (m *ClusterMember) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterMember.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterMember proto.InternalMessageInfo

func (m *ClusterMember) GetRole() v1.ClusterMemberRole {
	if m != nil {
		return m.Role
	}
	return v1.CLUSTER_MEMBER_ROLE_UNSPECIFIED
}

func (m *ClusterMember) GetHostId() string {
	if m != nil {
		return m.HostId
	}
	return ""
}

func (m *ClusterMember) GetRpcAddress() string {
	if m != nil {
		return m.RpcAddress
	}
	return ""
}

func (m *ClusterMember) GetRpcPort() int32 {
	if m != nil {
		return m.RpcPort
	}
	return 0
}

func (m *ClusterMember) GetSessionStartTime() *time.Time {
	if m != nil {
		return m.SessionStartTime
	}
	return nil
}

func (m *ClusterMember) GetLastHeartbitTime() *time.Time {
	if m != nil {
		return m.LastHeartbitTime
	}
	return nil
}

func (m *ClusterMember) GetRecordExpiryTime() *time.Time {
	if m != nil {
		return m.RecordExpiryTime
	}
	return nil
}

func init() {
	proto.RegisterType((*HostInfo)(nil), "temporal.server.api.cluster.v1.HostInfo")
	proto.RegisterType((*RingInfo)(nil), "temporal.server.api.cluster.v1.RingInfo")
	proto.RegisterType((*MembershipInfo)(nil), "temporal.server.api.cluster.v1.MembershipInfo")
	proto.RegisterType((*ClusterMember)(nil), "temporal.server.api.cluster.v1.ClusterMember")
}

func init() {
	proto.RegisterFile("temporal/server/api/cluster/v1/message.proto", fileDescriptor_fcc65697c8eece3a)
}

var fileDescriptor_fcc65697c8eece3a = []byte{
	// 571 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xbd, 0x6e, 0x13, 0x4d,
	0x14, 0xdd, 0x89, 0x93, 0xd8, 0x19, 0xe7, 0x8b, 0xf2, 0x4d, 0x83, 0x71, 0x31, 0x71, 0x5c, 0x20,
	0x0b, 0xa2, 0x5d, 0x25, 0x94, 0x48, 0x48, 0x24, 0x42, 0x4a, 0x84, 0x40, 0x68, 0xa1, 0xa2, 0x59,
	0xed, 0xcf, 0xcd, 0x7a, 0xa4, 0xdd, 0x9d, 0xd1, 0xcc, 0x38, 0x22, 0x1d, 0x0d, 0x7d, 0x5a, 0xde,
	0x80, 0x47, 0x41, 0x54, 0x29, 0xd3, 0x81, 0xd7, 0x0d, 0x65, 0x1e, 0x01, 0xcd, 0xcc, 0x6e, 0x00,
	0xc9, 0x42, 0xa6, 0xbb, 0x3f, 0xe7, 0x9c, 0x3d, 0x7b, 0xef, 0xd5, 0xe0, 0x03, 0x0d, 0xa5, 0xe0,
	0x32, 0x2e, 0x02, 0x05, 0xf2, 0x02, 0x64, 0x10, 0x0b, 0x16, 0xa4, 0xc5, 0x4c, 0x69, 0x90, 0xc1,
	0xc5, 0x61, 0x50, 0x82, 0x52, 0x71, 0x0e, 0xbe, 0x90, 0x5c, 0x73, 0x42, 0x5b, 0xb4, 0xef, 0xd0,
	0x7e, 0x2c, 0x98, 0xdf, 0xa0, 0xfd, 0x8b, 0xc3, 0xe1, 0x5e, 0xce, 0x79, 0x5e, 0x40, 0x60, 0xd1,
	0xc9, 0xec, 0x3c, 0xd0, 0xac, 0x04, 0xa5, 0xe3, 0x52, 0x38, 0x81, 0xe1, 0x7e, 0x06, 0x02, 0xaa,
	0x0c, 0xaa, 0x94, 0x81, 0x0a, 0x72, 0x9e, 0x73, 0x5b, 0xb7, 0x51, 0x03, 0x79, 0xb8, 0xcc, 0x11,
	0x54, 0xb3, 0x52, 0x19, 0x3f, 0xed, 0xc7, 0x2c, 0x76, 0xfc, 0x00, 0xf7, 0x4e, 0xb9, 0xd2, 0x67,
	0xd5, 0x39, 0x27, 0x43, 0xdc, 0x63, 0x19, 0x54, 0x9a, 0xe9, 0xcb, 0x01, 0x1a, 0xa1, 0xc9, 0x56,
	0x78, 0x97, 0x8f, 0x3f, 0x22, 0xdc, 0x0b, 0x59, 0x95, 0x5b, 0x20, 0xc1, 0xeb, 0x92, 0x17, 0xd0,
	0x80, 0x6c, 0x4c, 0xf6, 0xf1, 0x76, 0x09, 0x65, 0x02, 0x32, 0x4a, 0xf9, 0xac, 0xd2, 0x83, 0xb5,
	0x11, 0x9a, 0x6c, 0x84, 0x7d, 0x57, 0x3b, 0x31, 0x25, 0x72, 0x8c, 0xbb, 0x2e, 0x55, 0x83, 0xce,
	0xa8, 0x33, 0xe9, 0x1f, 0x4d, 0xfc, 0xbf, 0x4f, 0xc3, 0x6f, 0xad, 0x85, 0x2d, 0x71, 0xfc, 0x15,
	0xe1, 0x9d, 0x97, 0x2e, 0x9e, 0x32, 0x61, 0xdd, 0xbc, 0xc0, 0xdb, 0xe9, 0x4c, 0x4a, 0xa8, 0x74,
	0x34, 0xe5, 0x4a, 0x5b, 0x57, 0xff, 0xa2, 0xdd, 0x6f, 0xd8, 0xa6, 0x40, 0x1e, 0xe1, 0xff, 0x25,
	0xc4, 0xe9, 0x34, 0x4e, 0x0a, 0x88, 0x5a, 0xb7, 0x6b, 0xa3, 0xce, 0x64, 0x2b, 0xdc, 0xbd, 0x6b,
	0x34, 0x06, 0xc8, 0x53, 0xbc, 0x21, 0x59, 0x95, 0xaf, 0xfc, 0x3b, 0xed, 0x00, 0x43, 0x47, 0x1b,
	0x7f, 0xea, 0xe0, 0xff, 0x4e, 0x5c, 0xdb, 0x49, 0x92, 0x93, 0xdf, 0x26, 0xbb, 0x73, 0x14, 0x2c,
	0x15, 0xb4, 0x9b, 0x34, 0x72, 0x7f, 0x50, 0x43, 0x5e, 0x40, 0xb3, 0x8a, 0x7b, 0xb8, 0x6b, 0x06,
	0x11, 0xb1, 0xcc, 0x6e, 0x61, 0x2b, 0xdc, 0x34, 0xe9, 0x59, 0x46, 0xf6, 0x70, 0x5f, 0x8a, 0x34,
	0x8a, 0xb3, 0x4c, 0x82, 0x32, 0xae, 0x4d, 0x13, 0x4b, 0x91, 0x3e, 0x73, 0x15, 0x72, 0x1f, 0xf7,
	0x0c, 0x40, 0x70, 0xa9, 0x07, 0xeb, 0x76, 0x81, 0x5d, 0x29, 0xd2, 0xd7, 0x5c, 0x6a, 0xf2, 0x0a,
	0x13, 0x05, 0x4a, 0x31, 0x5e, 0x45, 0x4a, 0xc7, 0x52, 0x47, 0xe6, 0x30, 0x07, 0x1b, 0x76, 0xd6,
	0x43, 0xdf, 0x5d, 0xad, 0xdf, 0x5e, 0xad, 0xff, 0xb6, 0xbd, 0xda, 0xe3, 0xf5, 0xab, 0x6f, 0x7b,
	0x28, 0xdc, 0x6d, 0xb8, 0x6f, 0x0c, 0xd5, 0x34, 0x8d, 0x5e, 0x11, 0x2b, 0x1d, 0x4d, 0x21, 0x96,
	0x3a, 0x61, 0x8d, 0xde, 0xe6, 0xaa, 0x7a, 0x86, 0x7b, 0xda, 0x50, 0x5b, 0x3d, 0x09, 0x29, 0x97,
	0x59, 0x04, 0xef, 0x05, 0x93, 0x97, 0x4e, 0xaf, 0xbb, 0xaa, 0x9e, 0xe3, 0x3e, 0xb7, 0x54, 0xd3,
	0x3c, 0x4e, 0xae, 0xe7, 0xd4, 0xbb, 0x99, 0x53, 0xef, 0x76, 0x4e, 0xd1, 0x87, 0x9a, 0xa2, 0xcf,
	0x35, 0x45, 0x5f, 0x6a, 0x8a, 0xae, 0x6b, 0x8a, 0xbe, 0xd7, 0x14, 0xfd, 0xa8, 0xa9, 0x77, 0x5b,
	0x53, 0x74, 0xb5, 0xa0, 0xde, 0xf5, 0x82, 0x7a, 0x37, 0x0b, 0xea, 0xbd, 0x3b, 0xc8, 0xf9, 0xaf,
	0x9d, 0x31, 0xbe, 0xfc, 0x49, 0x78, 0xd2, 0x84, 0xc9, 0xa6, 0xf5, 0xf3, 0xf8, 0x67, 0x00, 0x00,
	0x00, 0xff, 0xff, 0xa4, 0x67, 0x85, 0x8f, 0x43, 0x04, 0x00, 0x00,
}

func (this *HostInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HostInfo)
	if !ok {
		that2, ok := that.(HostInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Identity != that1.Identity {
		return false
	}
	return true
}
func (this *RingInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RingInfo)
	if !ok {
		that2, ok := that.(RingInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Role != that1.Role {
		return false
	}
	if this.MemberCount != that1.MemberCount {
		return false
	}
	if len(this.Members) != len(that1.Members) {
		return false
	}
	for i := range this.Members {
		if !this.Members[i].Equal(that1.Members[i]) {
			return false
		}
	}
	return true
}
func (this *MembershipInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MembershipInfo)
	if !ok {
		that2, ok := that.(MembershipInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.CurrentHost.Equal(that1.CurrentHost) {
		return false
	}
	if len(this.ReachableMembers) != len(that1.ReachableMembers) {
		return false
	}
	for i := range this.ReachableMembers {
		if this.ReachableMembers[i] != that1.ReachableMembers[i] {
			return false
		}
	}
	if len(this.Rings) != len(that1.Rings) {
		return false
	}
	for i := range this.Rings {
		if !this.Rings[i].Equal(that1.Rings[i]) {
			return false
		}
	}
	return true
}
func (this *ClusterMember) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ClusterMember)
	if !ok {
		that2, ok := that.(ClusterMember)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Role != that1.Role {
		return false
	}
	if this.HostId != that1.HostId {
		return false
	}
	if this.RpcAddress != that1.RpcAddress {
		return false
	}
	if this.RpcPort != that1.RpcPort {
		return false
	}
	if that1.SessionStartTime == nil {
		if this.SessionStartTime != nil {
			return false
		}
	} else if !this.SessionStartTime.Equal(*that1.SessionStartTime) {
		return false
	}
	if that1.LastHeartbitTime == nil {
		if this.LastHeartbitTime != nil {
			return false
		}
	} else if !this.LastHeartbitTime.Equal(*that1.LastHeartbitTime) {
		return false
	}
	if that1.RecordExpiryTime == nil {
		if this.RecordExpiryTime != nil {
			return false
		}
	} else if !this.RecordExpiryTime.Equal(*that1.RecordExpiryTime) {
		return false
	}
	return true
}
func (this *HostInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&cluster.HostInfo{")
	s = append(s, "Identity: "+fmt.Sprintf("%#v", this.Identity)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RingInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&cluster.RingInfo{")
	s = append(s, "Role: "+fmt.Sprintf("%#v", this.Role)+",\n")
	s = append(s, "MemberCount: "+fmt.Sprintf("%#v", this.MemberCount)+",\n")
	if this.Members != nil {
		s = append(s, "Members: "+fmt.Sprintf("%#v", this.Members)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MembershipInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&cluster.MembershipInfo{")
	if this.CurrentHost != nil {
		s = append(s, "CurrentHost: "+fmt.Sprintf("%#v", this.CurrentHost)+",\n")
	}
	s = append(s, "ReachableMembers: "+fmt.Sprintf("%#v", this.ReachableMembers)+",\n")
	if this.Rings != nil {
		s = append(s, "Rings: "+fmt.Sprintf("%#v", this.Rings)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ClusterMember) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&cluster.ClusterMember{")
	s = append(s, "Role: "+fmt.Sprintf("%#v", this.Role)+",\n")
	s = append(s, "HostId: "+fmt.Sprintf("%#v", this.HostId)+",\n")
	s = append(s, "RpcAddress: "+fmt.Sprintf("%#v", this.RpcAddress)+",\n")
	s = append(s, "RpcPort: "+fmt.Sprintf("%#v", this.RpcPort)+",\n")
	s = append(s, "SessionStartTime: "+fmt.Sprintf("%#v", this.SessionStartTime)+",\n")
	s = append(s, "LastHeartbitTime: "+fmt.Sprintf("%#v", this.LastHeartbitTime)+",\n")
	s = append(s, "RecordExpiryTime: "+fmt.Sprintf("%#v", this.RecordExpiryTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringMessage(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *HostInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HostInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HostInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Identity) > 0 {
		i -= len(m.Identity)
		copy(dAtA[i:], m.Identity)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Identity)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RingInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RingInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RingInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Members) > 0 {
		for iNdEx := len(m.Members) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Members[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMessage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.MemberCount != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.MemberCount))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Role) > 0 {
		i -= len(m.Role)
		copy(dAtA[i:], m.Role)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Role)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MembershipInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MembershipInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MembershipInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Rings) > 0 {
		for iNdEx := len(m.Rings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Rings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMessage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.ReachableMembers) > 0 {
		for iNdEx := len(m.ReachableMembers) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ReachableMembers[iNdEx])
			copy(dAtA[i:], m.ReachableMembers[iNdEx])
			i = encodeVarintMessage(dAtA, i, uint64(len(m.ReachableMembers[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.CurrentHost != nil {
		{
			size, err := m.CurrentHost.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ClusterMember) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterMember) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClusterMember) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RecordExpiryTime != nil {
		n2, err2 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.RecordExpiryTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.RecordExpiryTime):])
		if err2 != nil {
			return 0, err2
		}
		i -= n2
		i = encodeVarintMessage(dAtA, i, uint64(n2))
		i--
		dAtA[i] = 0x3a
	}
	if m.LastHeartbitTime != nil {
		n3, err3 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.LastHeartbitTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbitTime):])
		if err3 != nil {
			return 0, err3
		}
		i -= n3
		i = encodeVarintMessage(dAtA, i, uint64(n3))
		i--
		dAtA[i] = 0x32
	}
	if m.SessionStartTime != nil {
		n4, err4 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.SessionStartTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.SessionStartTime):])
		if err4 != nil {
			return 0, err4
		}
		i -= n4
		i = encodeVarintMessage(dAtA, i, uint64(n4))
		i--
		dAtA[i] = 0x2a
	}
	if m.RpcPort != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.RpcPort))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RpcAddress) > 0 {
		i -= len(m.RpcAddress)
		copy(dAtA[i:], m.RpcAddress)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RpcAddress)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.HostId) > 0 {
		i -= len(m.HostId)
		copy(dAtA[i:], m.HostId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.HostId)))
		i--
		dAtA[i] = 0x12
	}
	if m.Role != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Role))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintMessage(dAtA []byte, offset int, v uint64) int {
	offset -= sovMessage(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *HostInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Identity)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *RingInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Role)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.MemberCount != 0 {
		n += 1 + sovMessage(uint64(m.MemberCount))
	}
	if len(m.Members) > 0 {
		for _, e := range m.Members {
			l = e.Size()
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	return n
}

func (m *MembershipInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CurrentHost != nil {
		l = m.CurrentHost.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if len(m.ReachableMembers) > 0 {
		for _, s := range m.ReachableMembers {
			l = len(s)
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	if len(m.Rings) > 0 {
		for _, e := range m.Rings {
			l = e.Size()
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	return n
}

func (m *ClusterMember) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Role != 0 {
		n += 1 + sovMessage(uint64(m.Role))
	}
	l = len(m.HostId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RpcAddress)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.RpcPort != 0 {
		n += 1 + sovMessage(uint64(m.RpcPort))
	}
	if m.SessionStartTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.SessionStartTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.LastHeartbitTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbitTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.RecordExpiryTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.RecordExpiryTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func sovMessage(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMessage(x uint64) (n int) {
	return sovMessage(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HostInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HostInfo{`,
		`Identity:` + fmt.Sprintf("%v", this.Identity) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RingInfo) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForMembers := "[]*HostInfo{"
	for _, f := range this.Members {
		repeatedStringForMembers += strings.Replace(f.String(), "HostInfo", "HostInfo", 1) + ","
	}
	repeatedStringForMembers += "}"
	s := strings.Join([]string{`&RingInfo{`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`MemberCount:` + fmt.Sprintf("%v", this.MemberCount) + `,`,
		`Members:` + repeatedStringForMembers + `,`,
		`}`,
	}, "")
	return s
}
func (this *MembershipInfo) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForRings := "[]*RingInfo{"
	for _, f := range this.Rings {
		repeatedStringForRings += strings.Replace(f.String(), "RingInfo", "RingInfo", 1) + ","
	}
	repeatedStringForRings += "}"
	s := strings.Join([]string{`&MembershipInfo{`,
		`CurrentHost:` + strings.Replace(this.CurrentHost.String(), "HostInfo", "HostInfo", 1) + `,`,
		`ReachableMembers:` + fmt.Sprintf("%v", this.ReachableMembers) + `,`,
		`Rings:` + repeatedStringForRings + `,`,
		`}`,
	}, "")
	return s
}
func (this *ClusterMember) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ClusterMember{`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`HostId:` + fmt.Sprintf("%v", this.HostId) + `,`,
		`RpcAddress:` + fmt.Sprintf("%v", this.RpcAddress) + `,`,
		`RpcPort:` + fmt.Sprintf("%v", this.RpcPort) + `,`,
		`SessionStartTime:` + strings.Replace(fmt.Sprintf("%v", this.SessionStartTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`LastHeartbitTime:` + strings.Replace(fmt.Sprintf("%v", this.LastHeartbitTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`RecordExpiryTime:` + strings.Replace(fmt.Sprintf("%v", this.RecordExpiryTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMessage(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HostInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HostInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HostInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Identity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Identity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RingInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RingInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RingInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Role = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberCount", wireType)
			}
			m.MemberCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemberCount |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Members", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Members = append(m.Members, &HostInfo{})
			if err := m.Members[len(m.Members)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MembershipInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MembershipInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MembershipInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentHost", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CurrentHost == nil {
				m.CurrentHost = &HostInfo{}
			}
			if err := m.CurrentHost.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReachableMembers", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReachableMembers = append(m.ReachableMembers, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rings = append(m.Rings, &RingInfo{})
			if err := m.Rings[len(m.Rings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterMember) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterMember: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterMember: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			m.Role = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Role |= v1.ClusterMemberRole(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RpcAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RpcAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RpcPort", wireType)
			}
			m.RpcPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RpcPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionStartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SessionStartTime == nil {
				m.SessionStartTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.SessionStartTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbitTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastHeartbitTime == nil {
				m.LastHeartbitTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.LastHeartbitTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecordExpiryTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RecordExpiryTime == nil {
				m.RecordExpiryTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.RecordExpiryTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMessage(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMessage
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMessage
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMessage
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMessage        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMessage          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMessage = fmt.Errorf("proto: unexpected end of group")
)
