// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/cli/v1/message.proto

package cli

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	v11 "go.temporal.io/api/common/v1"
	v12 "go.temporal.io/api/enums/v1"
	v1 "go.temporal.io/api/workflow/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type DescribeWorkflowExecutionResponse struct {
	ExecutionConfig       *v1.WorkflowExecutionConfig     `protobuf:"bytes,1,opt,name=execution_config,json=executionConfig,proto3" json:"execution_config,omitempty"`
	WorkflowExecutionInfo *WorkflowExecutionInfo          `protobuf:"bytes,2,opt,name=workflow_execution_info,json=workflowExecutionInfo,proto3" json:"workflow_execution_info,omitempty"`
	PendingActivities     []*PendingActivityInfo          `protobuf:"bytes,3,rep,name=pending_activities,json=pendingActivities,proto3" json:"pending_activities,omitempty"`
	PendingChildren       []*v1.PendingChildExecutionInfo `protobuf:"bytes,4,rep,name=pending_children,json=pendingChildren,proto3" json:"pending_children,omitempty"`
}

func (m *DescribeWorkflowExecutionResponse) Reset()      { *m = DescribeWorkflowExecutionResponse{} }
func (*DescribeWorkflowExecutionResponse) ProtoMessage() {}
func (*DescribeWorkflowExecutionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad471f2cfe5ee207, []int{0}
}
func (m *DescribeWorkflowExecutionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeWorkflowExecutionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeWorkflowExecutionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeWorkflowExecutionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeWorkflowExecutionResponse.Merge(m, src)
}
func (m *DescribeWorkflowExecutionResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeWorkflowExecutionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeWorkflowExecutionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeWorkflowExecutionResponse proto.InternalMessageInfo

func (m *DescribeWorkflowExecutionResponse) GetExecutionConfig() *v1.WorkflowExecutionConfig {
	if m != nil {
		return m.ExecutionConfig
	}
	return nil
}

func (m *DescribeWorkflowExecutionResponse) GetWorkflowExecutionInfo() *WorkflowExecutionInfo {
	if m != nil {
		return m.WorkflowExecutionInfo
	}
	return nil
}

func (m *DescribeWorkflowExecutionResponse) GetPendingActivities() []*PendingActivityInfo {
	if m != nil {
		return m.PendingActivities
	}
	return nil
}

func (m *DescribeWorkflowExecutionResponse) GetPendingChildren() []*v1.PendingChildExecutionInfo {
	if m != nil {
		return m.PendingChildren
	}
	return nil
}

type WorkflowExecutionInfo struct {
	Execution            *v11.WorkflowExecution      `protobuf:"bytes,1,opt,name=execution,proto3" json:"execution,omitempty"`
	Type                 *v11.WorkflowType           `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	StartTime            *time.Time                  `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3,stdtime" json:"start_time,omitempty"`
	CloseTime            *time.Time                  `protobuf:"bytes,4,opt,name=close_time,json=closeTime,proto3,stdtime" json:"close_time,omitempty"`
	Status               v12.WorkflowExecutionStatus `protobuf:"varint,5,opt,name=status,proto3,enum=temporal.api.enums.v1.WorkflowExecutionStatus" json:"status,omitempty"`
	HistoryLength        int64                       `protobuf:"varint,6,opt,name=history_length,json=historyLength,proto3" json:"history_length,omitempty"`
	ParentNamespaceId    string                      `protobuf:"bytes,7,opt,name=parent_namespace_id,json=parentNamespaceId,proto3" json:"parent_namespace_id,omitempty"`
	ParentExecution      *v11.WorkflowExecution      `protobuf:"bytes,8,opt,name=parent_execution,json=parentExecution,proto3" json:"parent_execution,omitempty"`
	ExecutionTime        *time.Time                  `protobuf:"bytes,9,opt,name=execution_time,json=executionTime,proto3,stdtime" json:"execution_time,omitempty"`
	Memo                 *v11.Memo                   `protobuf:"bytes,10,opt,name=memo,proto3" json:"memo,omitempty"`
	SearchAttributes     *SearchAttributes           `protobuf:"bytes,11,opt,name=search_attributes,json=searchAttributes,proto3" json:"search_attributes,omitempty"`
	AutoResetPoints      *v1.ResetPoints             `protobuf:"bytes,12,opt,name=auto_reset_points,json=autoResetPoints,proto3" json:"auto_reset_points,omitempty"`
	StateTransitionCount int64                       `protobuf:"varint,13,opt,name=state_transition_count,json=stateTransitionCount,proto3" json:"state_transition_count,omitempty"`
}

func (m *WorkflowExecutionInfo) Reset()      { *m = WorkflowExecutionInfo{} }
func (*WorkflowExecutionInfo) ProtoMessage() {}
func (*WorkflowExecutionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad471f2cfe5ee207, []int{1}
}
func (m *WorkflowExecutionInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WorkflowExecutionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WorkflowExecutionInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WorkflowExecutionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowExecutionInfo.Merge(m, src)
}
func (m *WorkflowExecutionInfo) XXX_Size() int {
	return m.Size()
}
func (m *WorkflowExecutionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowExecutionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowExecutionInfo proto.InternalMessageInfo

func (m *WorkflowExecutionInfo) GetExecution() *v11.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetType() *v11.WorkflowType {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetStartTime() *time.Time {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetCloseTime() *time.Time {
	if m != nil {
		return m.CloseTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetStatus() v12.WorkflowExecutionStatus {
	if m != nil {
		return m.Status
	}
	return v12.WORKFLOW_EXECUTION_STATUS_UNSPECIFIED
}

func (m *WorkflowExecutionInfo) GetHistoryLength() int64 {
	if m != nil {
		return m.HistoryLength
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetParentNamespaceId() string {
	if m != nil {
		return m.ParentNamespaceId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetParentExecution() *v11.WorkflowExecution {
	if m != nil {
		return m.ParentExecution
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetExecutionTime() *time.Time {
	if m != nil {
		return m.ExecutionTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetMemo() *v11.Memo {
	if m != nil {
		return m.Memo
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetSearchAttributes() *SearchAttributes {
	if m != nil {
		return m.SearchAttributes
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetAutoResetPoints() *v1.ResetPoints {
	if m != nil {
		return m.AutoResetPoints
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetStateTransitionCount() int64 {
	if m != nil {
		return m.StateTransitionCount
	}
	return 0
}

type PendingActivityInfo struct {
	ActivityId         string                   `protobuf:"bytes,1,opt,name=activity_id,json=activityId,proto3" json:"activity_id,omitempty"`
	ActivityType       *v11.ActivityType        `protobuf:"bytes,2,opt,name=activity_type,json=activityType,proto3" json:"activity_type,omitempty"`
	State              v12.PendingActivityState `protobuf:"varint,3,opt,name=state,proto3,enum=temporal.api.enums.v1.PendingActivityState" json:"state,omitempty"`
	HeartbeatDetails   string                   `protobuf:"bytes,4,opt,name=heartbeat_details,json=heartbeatDetails,proto3" json:"heartbeat_details,omitempty"`
	LastHeartbeatTime  *time.Time               `protobuf:"bytes,5,opt,name=last_heartbeat_time,json=lastHeartbeatTime,proto3,stdtime" json:"last_heartbeat_time,omitempty"`
	LastStartedTime    *time.Time               `protobuf:"bytes,6,opt,name=last_started_time,json=lastStartedTime,proto3,stdtime" json:"last_started_time,omitempty"`
	Attempt            int32                    `protobuf:"varint,7,opt,name=attempt,proto3" json:"attempt,omitempty"`
	MaximumAttempts    int32                    `protobuf:"varint,8,opt,name=maximum_attempts,json=maximumAttempts,proto3" json:"maximum_attempts,omitempty"`
	ScheduledTime      *time.Time               `protobuf:"bytes,9,opt,name=scheduled_time,json=scheduledTime,proto3,stdtime" json:"scheduled_time,omitempty"`
	ExpirationTime     *time.Time               `protobuf:"bytes,10,opt,name=expiration_time,json=expirationTime,proto3,stdtime" json:"expiration_time,omitempty"`
	LastFailure        *Failure                 `protobuf:"bytes,11,opt,name=last_failure,json=lastFailure,proto3" json:"last_failure,omitempty"`
	LastWorkerIdentity string                   `protobuf:"bytes,12,opt,name=last_worker_identity,json=lastWorkerIdentity,proto3" json:"last_worker_identity,omitempty"`
}

func (m *PendingActivityInfo) Reset()      { *m = PendingActivityInfo{} }
func (*PendingActivityInfo) ProtoMessage() {}
func (*PendingActivityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad471f2cfe5ee207, []int{2}
}
func (m *PendingActivityInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PendingActivityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PendingActivityInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PendingActivityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PendingActivityInfo.Merge(m, src)
}
func (m *PendingActivityInfo) XXX_Size() int {
	return m.Size()
}
func (m *PendingActivityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_PendingActivityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_PendingActivityInfo proto.InternalMessageInfo

func (m *PendingActivityInfo) GetActivityId() string {
	if m != nil {
		return m.ActivityId
	}
	return ""
}

func (m *PendingActivityInfo) GetActivityType() *v11.ActivityType {
	if m != nil {
		return m.ActivityType
	}
	return nil
}

func (m *PendingActivityInfo) GetState() v12.PendingActivityState {
	if m != nil {
		return m.State
	}
	return v12.PENDING_ACTIVITY_STATE_UNSPECIFIED
}

func (m *PendingActivityInfo) GetHeartbeatDetails() string {
	if m != nil {
		return m.HeartbeatDetails
	}
	return ""
}

func (m *PendingActivityInfo) GetLastHeartbeatTime() *time.Time {
	if m != nil {
		return m.LastHeartbeatTime
	}
	return nil
}

func (m *PendingActivityInfo) GetLastStartedTime() *time.Time {
	if m != nil {
		return m.LastStartedTime
	}
	return nil
}

func (m *PendingActivityInfo) GetAttempt() int32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

func (m *PendingActivityInfo) GetMaximumAttempts() int32 {
	if m != nil {
		return m.MaximumAttempts
	}
	return 0
}

func (m *PendingActivityInfo) GetScheduledTime() *time.Time {
	if m != nil {
		return m.ScheduledTime
	}
	return nil
}

func (m *PendingActivityInfo) GetExpirationTime() *time.Time {
	if m != nil {
		return m.ExpirationTime
	}
	return nil
}

func (m *PendingActivityInfo) GetLastFailure() *Failure {
	if m != nil {
		return m.LastFailure
	}
	return nil
}

func (m *PendingActivityInfo) GetLastWorkerIdentity() string {
	if m != nil {
		return m.LastWorkerIdentity
	}
	return ""
}

type SearchAttributes struct {
	IndexedFields map[string]string `protobuf:"bytes,1,rep,name=indexed_fields,json=indexedFields,proto3" json:"indexed_fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *SearchAttributes) Reset()      { *m = SearchAttributes{} }
func (*SearchAttributes) ProtoMessage() {}
func (*SearchAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad471f2cfe5ee207, []int{3}
}
func (m *SearchAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SearchAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SearchAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SearchAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAttributes.Merge(m, src)
}
func (m *SearchAttributes) XXX_Size() int {
	return m.Size()
}
func (m *SearchAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAttributes proto.InternalMessageInfo

func (m *SearchAttributes) GetIndexedFields() map[string]string {
	if m != nil {
		return m.IndexedFields
	}
	return nil
}

type Failure struct {
	Message     string   `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	Source      string   `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	StackTrace  string   `protobuf:"bytes,3,opt,name=stack_trace,json=stackTrace,proto3" json:"stack_trace,omitempty"`
	Cause       *Failure `protobuf:"bytes,4,opt,name=cause,proto3" json:"cause,omitempty"`
	FailureType string   `protobuf:"bytes,5,opt,name=failure_type,json=failureType,proto3" json:"failure_type,omitempty"`
}

func (m *Failure) Reset()      { *m = Failure{} }
func (*Failure) ProtoMessage() {}
func (*Failure) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad471f2cfe5ee207, []int{4}
}
func (m *Failure) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Failure) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Failure.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Failure) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Failure.Merge(m, src)
}
func (m *Failure) XXX_Size() int {
	return m.Size()
}
func (m *Failure) XXX_DiscardUnknown() {
	xxx_messageInfo_Failure.DiscardUnknown(m)
}

var xxx_messageInfo_Failure proto.InternalMessageInfo

func (m *Failure) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Failure) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *Failure) GetStackTrace() string {
	if m != nil {
		return m.StackTrace
	}
	return ""
}

func (m *Failure) GetCause() *Failure {
	if m != nil {
		return m.Cause
	}
	return nil
}

func (m *Failure) GetFailureType() string {
	if m != nil {
		return m.FailureType
	}
	return ""
}

type AddSearchAttributesResponse struct {
	IndexName                string                 `protobuf:"bytes,1,opt,name=index_name,json=indexName,proto3" json:"index_name,omitempty"`
	CustomSearchAttributes   map[string]string      `protobuf:"bytes,2,rep,name=custom_search_attributes,json=customSearchAttributes,proto3" json:"custom_search_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	SystemSearchAttributes   map[string]string      `protobuf:"bytes,3,rep,name=system_search_attributes,json=systemSearchAttributes,proto3" json:"system_search_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Mapping                  map[string]string      `protobuf:"bytes,4,rep,name=mapping,proto3" json:"mapping,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	AddWorkflowExecutionInfo *WorkflowExecutionInfo `protobuf:"bytes,5,opt,name=add_workflow_execution_info,json=addWorkflowExecutionInfo,proto3" json:"add_workflow_execution_info,omitempty"`
}

func (m *AddSearchAttributesResponse) Reset()      { *m = AddSearchAttributesResponse{} }
func (*AddSearchAttributesResponse) ProtoMessage() {}
func (*AddSearchAttributesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad471f2cfe5ee207, []int{5}
}
func (m *AddSearchAttributesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddSearchAttributesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddSearchAttributesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddSearchAttributesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddSearchAttributesResponse.Merge(m, src)
}
func (m *AddSearchAttributesResponse) XXX_Size() int {
	return m.Size()
}
func (m *AddSearchAttributesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddSearchAttributesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddSearchAttributesResponse proto.InternalMessageInfo

func (m *AddSearchAttributesResponse) GetIndexName() string {
	if m != nil {
		return m.IndexName
	}
	return ""
}

func (m *AddSearchAttributesResponse) GetCustomSearchAttributes() map[string]string {
	if m != nil {
		return m.CustomSearchAttributes
	}
	return nil
}

func (m *AddSearchAttributesResponse) GetSystemSearchAttributes() map[string]string {
	if m != nil {
		return m.SystemSearchAttributes
	}
	return nil
}

func (m *AddSearchAttributesResponse) GetMapping() map[string]string {
	if m != nil {
		return m.Mapping
	}
	return nil
}

func (m *AddSearchAttributesResponse) GetAddWorkflowExecutionInfo() *WorkflowExecutionInfo {
	if m != nil {
		return m.AddWorkflowExecutionInfo
	}
	return nil
}

func init() {
	proto.RegisterType((*DescribeWorkflowExecutionResponse)(nil), "temporal.server.api.cli.v1.DescribeWorkflowExecutionResponse")
	proto.RegisterType((*WorkflowExecutionInfo)(nil), "temporal.server.api.cli.v1.WorkflowExecutionInfo")
	proto.RegisterType((*PendingActivityInfo)(nil), "temporal.server.api.cli.v1.PendingActivityInfo")
	proto.RegisterType((*SearchAttributes)(nil), "temporal.server.api.cli.v1.SearchAttributes")
	proto.RegisterMapType((map[string]string)(nil), "temporal.server.api.cli.v1.SearchAttributes.IndexedFieldsEntry")
	proto.RegisterType((*Failure)(nil), "temporal.server.api.cli.v1.Failure")
	proto.RegisterType((*AddSearchAttributesResponse)(nil), "temporal.server.api.cli.v1.AddSearchAttributesResponse")
	proto.RegisterMapType((map[string]string)(nil), "temporal.server.api.cli.v1.AddSearchAttributesResponse.CustomSearchAttributesEntry")
	proto.RegisterMapType((map[string]string)(nil), "temporal.server.api.cli.v1.AddSearchAttributesResponse.MappingEntry")
	proto.RegisterMapType((map[string]string)(nil), "temporal.server.api.cli.v1.AddSearchAttributesResponse.SystemSearchAttributesEntry")
}

func init() {
	proto.RegisterFile("temporal/server/api/cli/v1/message.proto", fileDescriptor_ad471f2cfe5ee207)
}

var fileDescriptor_ad471f2cfe5ee207 = []byte{
	// 1279 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x57, 0xcb, 0x6e, 0xdb, 0x46,
	0x17, 0x36, 0x63, 0x4b, 0xfe, 0x75, 0x7c, 0x91, 0x3c, 0xb9, 0xfc, 0x84, 0xd3, 0x32, 0x8e, 0x9b,
	0x14, 0x0e, 0x52, 0x50, 0xb1, 0xd3, 0x45, 0x9a, 0x2e, 0x52, 0xc7, 0xb9, 0x54, 0x40, 0x52, 0xa4,
	0xb4, 0x81, 0xa0, 0x41, 0x11, 0x62, 0x4c, 0x1e, 0xc9, 0x83, 0xf0, 0x06, 0xce, 0xd0, 0xb1, 0x76,
	0x79, 0x81, 0x02, 0x79, 0x8c, 0x2e, 0xfa, 0x04, 0x45, 0x1f, 0xa0, 0xcb, 0x2c, 0xb3, 0x6b, 0xa3,
	0x74, 0xd1, 0x65, 0x1e, 0xa1, 0x98, 0x43, 0x52, 0xb2, 0x2d, 0x59, 0x95, 0xd3, 0x9d, 0xe6, 0x3b,
	0xe7, 0xfb, 0xe6, 0xf0, 0x9c, 0xf9, 0x86, 0x14, 0xac, 0x29, 0x0c, 0x93, 0x38, 0xe5, 0x41, 0x53,
	0x62, 0xba, 0x8f, 0x69, 0x93, 0x27, 0xa2, 0xe9, 0x05, 0xa2, 0xb9, 0xbf, 0xde, 0x0c, 0x51, 0x4a,
	0xde, 0x41, 0x3b, 0x49, 0x63, 0x15, 0xb3, 0xe5, 0x32, 0xd3, 0xce, 0x33, 0x6d, 0x9e, 0x08, 0xdb,
	0x0b, 0x84, 0xbd, 0xbf, 0xbe, 0x7c, 0xa9, 0x13, 0xc7, 0x9d, 0x00, 0x9b, 0x94, 0xb9, 0x9b, 0xb5,
	0x9b, 0x4a, 0x84, 0x28, 0x15, 0x0f, 0x93, 0x9c, 0xbc, 0x7c, 0xd9, 0xc7, 0x04, 0x23, 0x1f, 0x23,
	0x4f, 0xa0, 0x6c, 0x76, 0xe2, 0x4e, 0x4c, 0x38, 0xfd, 0x2a, 0x52, 0xae, 0xf4, 0x2b, 0xa1, 0x12,
	0xe2, 0x30, 0x8c, 0xa3, 0xa1, 0x2a, 0x8e, 0x65, 0x61, 0x94, 0x85, 0x52, 0x27, 0xbd, 0x8c, 0xd3,
	0x17, 0xed, 0x20, 0x7e, 0x59, 0x64, 0x7d, 0x7e, 0x24, 0xab, 0x0c, 0x0e, 0xa9, 0xad, 0xfe, 0x32,
	0x0d, 0x97, 0xef, 0xa1, 0xf4, 0x52, 0xb1, 0x8b, 0x4f, 0x8b, 0xac, 0xfb, 0x07, 0xe8, 0x65, 0x4a,
	0xc4, 0x91, 0x83, 0x32, 0x89, 0x23, 0x89, 0xec, 0x47, 0x68, 0x60, 0x09, 0xba, 0x5e, 0x1c, 0xb5,
	0x45, 0xc7, 0x34, 0x56, 0x8c, 0xb5, 0xb9, 0x8d, 0x75, 0xbb, 0xdf, 0x14, 0xdd, 0x8d, 0x7e, 0x15,
	0xfb, 0xeb, 0xf6, 0x90, 0xdc, 0x16, 0x11, 0x9d, 0x3a, 0x1e, 0x05, 0x98, 0x80, 0xff, 0x97, 0x3c,
	0x77, 0xb0, 0x8d, 0x88, 0xda, 0xb1, 0x79, 0xe6, 0xf8, 0x26, 0x43, 0x9d, 0x1f, 0xde, 0xa6, 0x15,
	0xb5, 0x63, 0xe7, 0xfc, 0xcb, 0x51, 0x30, 0x7b, 0x0e, 0x4c, 0x4f, 0x41, 0x44, 0x1d, 0x97, 0x7b,
	0x4a, 0xec, 0x0b, 0x25, 0x50, 0x9a, 0xd3, 0x2b, 0xd3, 0x6b, 0x73, 0x1b, 0xcd, 0x71, 0xbb, 0x3c,
	0xc9, 0x59, 0x9b, 0x39, 0xa9, 0x4b, 0x7b, 0x2c, 0x25, 0x47, 0x40, 0x81, 0x92, 0x3d, 0x87, 0x46,
	0xa9, 0xef, 0xed, 0x89, 0xc0, 0x4f, 0x31, 0x32, 0x67, 0x48, 0xfd, 0xe6, 0xc9, 0x8d, 0x2a, 0xb4,
	0xb7, 0x34, 0xe1, 0xe8, 0x53, 0xd4, 0x93, 0x43, 0xa1, 0x14, 0xa3, 0xd5, 0x0f, 0x55, 0x38, 0x3f,
	0xf2, 0x81, 0xd9, 0x43, 0xa8, 0xf5, 0x7b, 0x57, 0xcc, 0xe6, 0xda, 0xd1, 0x2d, 0xf3, 0x03, 0x35,
	0xb2, 0x65, 0xce, 0x80, 0xcb, 0x6e, 0xc1, 0x8c, 0xea, 0x26, 0x58, 0xb4, 0xfe, 0xca, 0xbf, 0x69,
	0xec, 0x74, 0x13, 0x74, 0x88, 0xc1, 0xee, 0x00, 0x48, 0xc5, 0x53, 0xe5, 0xea, 0xb3, 0x6f, 0x4e,
	0x13, 0x7f, 0xd9, 0xce, 0x8d, 0x61, 0x97, 0xc6, 0xb0, 0x77, 0x4a, 0x63, 0xdc, 0x9d, 0x79, 0xfd,
	0xc7, 0x25, 0xc3, 0xa9, 0x11, 0x47, 0xa3, 0x5a, 0xc0, 0x0b, 0x62, 0x89, 0xb9, 0xc0, 0xcc, 0xa4,
	0x02, 0xc4, 0x21, 0x81, 0x07, 0x50, 0x95, 0x8a, 0xab, 0x4c, 0x9a, 0x95, 0x15, 0x63, 0x6d, 0x71,
	0xc3, 0x3e, 0x5a, 0x3d, 0x99, 0x65, 0x64, 0x03, 0xb6, 0x89, 0xe5, 0x14, 0x6c, 0x76, 0x15, 0x16,
	0xf7, 0x84, 0x54, 0x71, 0xda, 0x75, 0x03, 0x8c, 0x3a, 0x6a, 0xcf, 0xac, 0xae, 0x18, 0x6b, 0xd3,
	0xce, 0x42, 0x81, 0x3e, 0x22, 0x90, 0xd9, 0x70, 0x36, 0xe1, 0x29, 0x46, 0xca, 0x8d, 0x78, 0x88,
	0x32, 0xe1, 0x1e, 0xba, 0xc2, 0x37, 0x67, 0x57, 0x8c, 0xb5, 0x9a, 0xb3, 0x94, 0x87, 0xbe, 0x2b,
	0x23, 0x2d, 0x9f, 0xed, 0x40, 0xa3, 0xc8, 0x1f, 0x8c, 0xea, 0x7f, 0xa7, 0x1d, 0x55, 0x3d, 0x97,
	0xe8, 0x03, 0xec, 0x21, 0x2c, 0x0e, 0x5c, 0x43, 0x9d, 0xab, 0x4d, 0xd8, 0xb9, 0x85, 0x3e, 0x8f,
	0xba, 0x77, 0x03, 0x66, 0x42, 0x0c, 0x63, 0x13, 0x88, 0xfe, 0xc9, 0x49, 0x25, 0x3d, 0xc6, 0x30,
	0x76, 0x28, 0x93, 0xfd, 0x00, 0x4b, 0x12, 0x79, 0xea, 0xed, 0xb9, 0x5c, 0xa9, 0x54, 0xec, 0x66,
	0x0a, 0xa5, 0x39, 0x47, 0xf4, 0x2f, 0xc6, 0xb9, 0x69, 0x9b, 0x48, 0x9b, 0x7d, 0x8e, 0xd3, 0x90,
	0xc7, 0x10, 0xf6, 0x3d, 0x2c, 0xf1, 0x4c, 0xc5, 0x6e, 0x8a, 0x12, 0x95, 0x9b, 0xc4, 0x22, 0x52,
	0xd2, 0x9c, 0x27, 0xe9, 0xab, 0x27, 0x5b, 0xc9, 0xd1, 0xd9, 0x4f, 0x28, 0xd9, 0xa9, 0x6b, 0xfe,
	0x21, 0x80, 0x7d, 0x09, 0x17, 0xf4, 0x7c, 0xd1, 0x55, 0x29, 0x8f, 0xa4, 0x28, 0x2e, 0xb3, 0x2c,
	0x52, 0xe6, 0x02, 0x4d, 0xf7, 0x1c, 0x45, 0x77, 0xfa, 0xc1, 0x2d, 0x1d, 0x5b, 0xfd, 0xab, 0x02,
	0x67, 0x47, 0xb8, 0x9f, 0x5d, 0x82, 0xb9, 0xe2, 0x0a, 0xe9, 0xea, 0xa1, 0x1b, 0x34, 0x74, 0x28,
	0xa1, 0x96, 0xcf, 0x5a, 0xb0, 0xd0, 0x4f, 0x98, 0xc4, 0x51, 0xa5, 0x3a, 0x39, 0x6a, 0x9e, 0x1f,
	0x5a, 0xb1, 0x4d, 0xa8, 0x50, 0x6d, 0x64, 0xaa, 0xc5, 0x8d, 0xeb, 0x27, 0x1c, 0xeb, 0x63, 0x65,
	0xea, 0x43, 0x8d, 0x4e, 0xce, 0x64, 0xd7, 0x61, 0x69, 0x0f, 0x79, 0xaa, 0x76, 0x91, 0x2b, 0xd7,
	0x47, 0xc5, 0x45, 0x20, 0xc9, 0x62, 0x35, 0xa7, 0xd1, 0x0f, 0xdc, 0xcb, 0x71, 0xf6, 0x04, 0xce,
	0x06, 0x5c, 0x2a, 0x77, 0xc0, 0xa0, 0x73, 0x55, 0x99, 0xf0, 0x5c, 0x2d, 0x69, 0xf2, 0xb7, 0x25,
	0x97, 0xce, 0xd6, 0x23, 0x20, 0xd0, 0x25, 0xb3, 0xa3, 0x9f, 0xeb, 0x55, 0x27, 0xd4, 0xab, 0x6b,
	0xea, 0x76, 0xce, 0x24, 0x35, 0x13, 0x66, 0xb9, 0xd2, 0x3d, 0x50, 0x64, 0xb6, 0x8a, 0x53, 0x2e,
	0xd9, 0x35, 0x68, 0x84, 0xfc, 0x40, 0x84, 0x59, 0xe8, 0x16, 0x90, 0x24, 0x8b, 0x55, 0x9c, 0x7a,
	0x81, 0x6f, 0x16, 0xb0, 0xf6, 0x8d, 0xf4, 0xf6, 0xd0, 0xcf, 0x82, 0xb2, 0x9e, 0x89, 0x7d, 0xd3,
	0xe7, 0x51, 0x35, 0x2d, 0xa8, 0xe3, 0x41, 0x22, 0x52, 0x3e, 0x70, 0x20, 0x4c, 0xa8, 0xb4, 0x38,
	0x20, 0x16, 0x17, 0xd8, 0x3c, 0xb5, 0xa9, 0xcd, 0x45, 0x90, 0xa5, 0x58, 0x78, 0xe9, 0xb3, 0x71,
	0x5e, 0x7a, 0x90, 0xa7, 0x3a, 0x73, 0x9a, 0x58, 0x2c, 0xd8, 0x0d, 0x38, 0x47, 0x3a, 0xda, 0x1b,
	0x98, 0xba, 0xc2, 0xc7, 0x48, 0x09, 0xd5, 0x25, 0x03, 0xd5, 0x1c, 0xa6, 0x63, 0x4f, 0x29, 0xd4,
	0x2a, 0x22, 0xab, 0xbf, 0x19, 0xd0, 0x38, 0x6e, 0x4b, 0xd6, 0x86, 0x45, 0x11, 0xf9, 0x78, 0x80,
	0xbe, 0xdb, 0x16, 0x18, 0xf8, 0xd2, 0x34, 0xe8, 0x65, 0x76, 0xe7, 0x34, 0xe6, 0xb6, 0x5b, 0xb9,
	0xc4, 0x03, 0x52, 0xb8, 0x1f, 0xa9, 0xb4, 0xeb, 0x2c, 0x88, 0xc3, 0xd8, 0xf2, 0x37, 0xc0, 0x86,
	0x93, 0x58, 0x03, 0xa6, 0x5f, 0x60, 0xb7, 0x70, 0x96, 0xfe, 0xc9, 0xce, 0x41, 0x65, 0x9f, 0x07,
	0x59, 0x6e, 0xa5, 0x9a, 0x93, 0x2f, 0x6e, 0x9f, 0xb9, 0x65, 0xac, 0xfe, 0x6a, 0xc0, 0x6c, 0xf9,
	0xf0, 0x26, 0xcc, 0x16, 0x1f, 0x39, 0x05, 0xb7, 0x5c, 0xb2, 0x0b, 0x50, 0x95, 0x71, 0x96, 0x7a,
	0xa5, 0x40, 0xb1, 0xd2, 0x5e, 0x96, 0x8a, 0x7b, 0x2f, 0xf4, 0xcd, 0xe0, 0xe5, 0x2e, 0xab, 0x39,
	0x40, 0xd0, 0x8e, 0x46, 0xd8, 0x57, 0x50, 0xf1, 0x78, 0x26, 0xcb, 0x97, 0xd2, 0x44, 0x03, 0xc9,
	0x19, 0xec, 0x32, 0xcc, 0x17, 0xd3, 0xcc, 0x6f, 0x81, 0x0a, 0x89, 0xcf, 0x15, 0x98, 0xb6, 0xf7,
	0xea, 0xab, 0x2a, 0x5c, 0xdc, 0xf4, 0xfd, 0xa1, 0x5b, 0xb1, 0xfc, 0xfc, 0xfa, 0x14, 0x80, 0xfa,
	0x45, 0xaf, 0x99, 0xe2, 0x99, 0x6a, 0x84, 0xe8, 0xb7, 0x0b, 0xfb, 0xc9, 0x00, 0xd3, 0xcb, 0xa4,
	0x8a, 0x43, 0x77, 0xf8, 0x36, 0x3e, 0x43, 0x03, 0xdb, 0x1e, 0x57, 0xf0, 0x98, 0xad, 0xed, 0x2d,
	0xd2, 0x3d, 0x1e, 0xce, 0x87, 0x78, 0xc1, 0x1b, 0x19, 0xa4, 0x7a, 0x64, 0x57, 0x2a, 0x1c, 0x55,
	0xcf, 0xf4, 0x7f, 0xab, 0x67, 0x9b, 0x74, 0x4f, 0xa8, 0x47, 0x8e, 0x0c, 0xb2, 0xe7, 0x30, 0x1b,
	0xf2, 0x24, 0x11, 0x51, 0xa7, 0xf8, 0x16, 0xbb, 0xf7, 0xb1, 0xbb, 0x3f, 0xce, 0x65, 0xf2, 0xed,
	0x4a, 0x51, 0x96, 0xc0, 0x45, 0xee, 0xfb, 0xee, 0x49, 0xdf, 0xb0, 0x95, 0x8f, 0xfd, 0x86, 0x35,
	0xb9, 0xef, 0x8f, 0x8c, 0x2c, 0xb7, 0xe0, 0xe2, 0x98, 0xc1, 0x9c, 0xc6, 0x38, 0x5a, 0x6a, 0x4c,
	0x4f, 0x4f, 0x25, 0x75, 0x1b, 0xe6, 0x0f, 0x37, 0xe8, 0x34, 0xdc, 0xbb, 0xcf, 0xde, 0xbc, 0xb3,
	0xa6, 0xde, 0xbe, 0xb3, 0xa6, 0x3e, 0xbc, 0xb3, 0x8c, 0x57, 0x3d, 0xcb, 0xf8, 0xb9, 0x67, 0x19,
	0xbf, 0xf7, 0x2c, 0xe3, 0x4d, 0xcf, 0x32, 0xfe, 0xec, 0x59, 0xc6, 0xdf, 0x3d, 0x6b, 0xea, 0x43,
	0xcf, 0x32, 0x5e, 0xbf, 0xb7, 0xa6, 0xde, 0xbc, 0xb7, 0xa6, 0xde, 0xbe, 0xb7, 0xa6, 0x9e, 0x5d,
	0xe9, 0xc4, 0x83, 0xb6, 0x8a, 0x78, 0xf8, 0x1f, 0xdc, 0xd7, 0x5e, 0x20, 0x76, 0xab, 0x74, 0xfd,
	0xde, 0xfc, 0x27, 0x00, 0x00, 0xff, 0xff, 0x5c, 0x9e, 0xd8, 0x26, 0xea, 0x0d, 0x00, 0x00,
}

func (this *DescribeWorkflowExecutionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeWorkflowExecutionResponse)
	if !ok {
		that2, ok := that.(DescribeWorkflowExecutionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ExecutionConfig.Equal(that1.ExecutionConfig) {
		return false
	}
	if !this.WorkflowExecutionInfo.Equal(that1.WorkflowExecutionInfo) {
		return false
	}
	if len(this.PendingActivities) != len(that1.PendingActivities) {
		return false
	}
	for i := range this.PendingActivities {
		if !this.PendingActivities[i].Equal(that1.PendingActivities[i]) {
			return false
		}
	}
	if len(this.PendingChildren) != len(that1.PendingChildren) {
		return false
	}
	for i := range this.PendingChildren {
		if !this.PendingChildren[i].Equal(that1.PendingChildren[i]) {
			return false
		}
	}
	return true
}
func (this *WorkflowExecutionInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WorkflowExecutionInfo)
	if !ok {
		that2, ok := that.(WorkflowExecutionInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	if !this.Type.Equal(that1.Type) {
		return false
	}
	if that1.StartTime == nil {
		if this.StartTime != nil {
			return false
		}
	} else if !this.StartTime.Equal(*that1.StartTime) {
		return false
	}
	if that1.CloseTime == nil {
		if this.CloseTime != nil {
			return false
		}
	} else if !this.CloseTime.Equal(*that1.CloseTime) {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.HistoryLength != that1.HistoryLength {
		return false
	}
	if this.ParentNamespaceId != that1.ParentNamespaceId {
		return false
	}
	if !this.ParentExecution.Equal(that1.ParentExecution) {
		return false
	}
	if that1.ExecutionTime == nil {
		if this.ExecutionTime != nil {
			return false
		}
	} else if !this.ExecutionTime.Equal(*that1.ExecutionTime) {
		return false
	}
	if !this.Memo.Equal(that1.Memo) {
		return false
	}
	if !this.SearchAttributes.Equal(that1.SearchAttributes) {
		return false
	}
	if !this.AutoResetPoints.Equal(that1.AutoResetPoints) {
		return false
	}
	if this.StateTransitionCount != that1.StateTransitionCount {
		return false
	}
	return true
}
func (this *PendingActivityInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PendingActivityInfo)
	if !ok {
		that2, ok := that.(PendingActivityInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ActivityId != that1.ActivityId {
		return false
	}
	if !this.ActivityType.Equal(that1.ActivityType) {
		return false
	}
	if this.State != that1.State {
		return false
	}
	if this.HeartbeatDetails != that1.HeartbeatDetails {
		return false
	}
	if that1.LastHeartbeatTime == nil {
		if this.LastHeartbeatTime != nil {
			return false
		}
	} else if !this.LastHeartbeatTime.Equal(*that1.LastHeartbeatTime) {
		return false
	}
	if that1.LastStartedTime == nil {
		if this.LastStartedTime != nil {
			return false
		}
	} else if !this.LastStartedTime.Equal(*that1.LastStartedTime) {
		return false
	}
	if this.Attempt != that1.Attempt {
		return false
	}
	if this.MaximumAttempts != that1.MaximumAttempts {
		return false
	}
	if that1.ScheduledTime == nil {
		if this.ScheduledTime != nil {
			return false
		}
	} else if !this.ScheduledTime.Equal(*that1.ScheduledTime) {
		return false
	}
	if that1.ExpirationTime == nil {
		if this.ExpirationTime != nil {
			return false
		}
	} else if !this.ExpirationTime.Equal(*that1.ExpirationTime) {
		return false
	}
	if !this.LastFailure.Equal(that1.LastFailure) {
		return false
	}
	if this.LastWorkerIdentity != that1.LastWorkerIdentity {
		return false
	}
	return true
}
func (this *SearchAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SearchAttributes)
	if !ok {
		that2, ok := that.(SearchAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.IndexedFields) != len(that1.IndexedFields) {
		return false
	}
	for i := range this.IndexedFields {
		if this.IndexedFields[i] != that1.IndexedFields[i] {
			return false
		}
	}
	return true
}
func (this *Failure) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Failure)
	if !ok {
		that2, ok := that.(Failure)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	if this.Source != that1.Source {
		return false
	}
	if this.StackTrace != that1.StackTrace {
		return false
	}
	if !this.Cause.Equal(that1.Cause) {
		return false
	}
	if this.FailureType != that1.FailureType {
		return false
	}
	return true
}
func (this *AddSearchAttributesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddSearchAttributesResponse)
	if !ok {
		that2, ok := that.(AddSearchAttributesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.IndexName != that1.IndexName {
		return false
	}
	if len(this.CustomSearchAttributes) != len(that1.CustomSearchAttributes) {
		return false
	}
	for i := range this.CustomSearchAttributes {
		if this.CustomSearchAttributes[i] != that1.CustomSearchAttributes[i] {
			return false
		}
	}
	if len(this.SystemSearchAttributes) != len(that1.SystemSearchAttributes) {
		return false
	}
	for i := range this.SystemSearchAttributes {
		if this.SystemSearchAttributes[i] != that1.SystemSearchAttributes[i] {
			return false
		}
	}
	if len(this.Mapping) != len(that1.Mapping) {
		return false
	}
	for i := range this.Mapping {
		if this.Mapping[i] != that1.Mapping[i] {
			return false
		}
	}
	if !this.AddWorkflowExecutionInfo.Equal(that1.AddWorkflowExecutionInfo) {
		return false
	}
	return true
}
func (this *DescribeWorkflowExecutionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&cli.DescribeWorkflowExecutionResponse{")
	if this.ExecutionConfig != nil {
		s = append(s, "ExecutionConfig: "+fmt.Sprintf("%#v", this.ExecutionConfig)+",\n")
	}
	if this.WorkflowExecutionInfo != nil {
		s = append(s, "WorkflowExecutionInfo: "+fmt.Sprintf("%#v", this.WorkflowExecutionInfo)+",\n")
	}
	if this.PendingActivities != nil {
		s = append(s, "PendingActivities: "+fmt.Sprintf("%#v", this.PendingActivities)+",\n")
	}
	if this.PendingChildren != nil {
		s = append(s, "PendingChildren: "+fmt.Sprintf("%#v", this.PendingChildren)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WorkflowExecutionInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 17)
	s = append(s, "&cli.WorkflowExecutionInfo{")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	if this.Type != nil {
		s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	}
	s = append(s, "StartTime: "+fmt.Sprintf("%#v", this.StartTime)+",\n")
	s = append(s, "CloseTime: "+fmt.Sprintf("%#v", this.CloseTime)+",\n")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	s = append(s, "HistoryLength: "+fmt.Sprintf("%#v", this.HistoryLength)+",\n")
	s = append(s, "ParentNamespaceId: "+fmt.Sprintf("%#v", this.ParentNamespaceId)+",\n")
	if this.ParentExecution != nil {
		s = append(s, "ParentExecution: "+fmt.Sprintf("%#v", this.ParentExecution)+",\n")
	}
	s = append(s, "ExecutionTime: "+fmt.Sprintf("%#v", this.ExecutionTime)+",\n")
	if this.Memo != nil {
		s = append(s, "Memo: "+fmt.Sprintf("%#v", this.Memo)+",\n")
	}
	if this.SearchAttributes != nil {
		s = append(s, "SearchAttributes: "+fmt.Sprintf("%#v", this.SearchAttributes)+",\n")
	}
	if this.AutoResetPoints != nil {
		s = append(s, "AutoResetPoints: "+fmt.Sprintf("%#v", this.AutoResetPoints)+",\n")
	}
	s = append(s, "StateTransitionCount: "+fmt.Sprintf("%#v", this.StateTransitionCount)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PendingActivityInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 16)
	s = append(s, "&cli.PendingActivityInfo{")
	s = append(s, "ActivityId: "+fmt.Sprintf("%#v", this.ActivityId)+",\n")
	if this.ActivityType != nil {
		s = append(s, "ActivityType: "+fmt.Sprintf("%#v", this.ActivityType)+",\n")
	}
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "HeartbeatDetails: "+fmt.Sprintf("%#v", this.HeartbeatDetails)+",\n")
	s = append(s, "LastHeartbeatTime: "+fmt.Sprintf("%#v", this.LastHeartbeatTime)+",\n")
	s = append(s, "LastStartedTime: "+fmt.Sprintf("%#v", this.LastStartedTime)+",\n")
	s = append(s, "Attempt: "+fmt.Sprintf("%#v", this.Attempt)+",\n")
	s = append(s, "MaximumAttempts: "+fmt.Sprintf("%#v", this.MaximumAttempts)+",\n")
	s = append(s, "ScheduledTime: "+fmt.Sprintf("%#v", this.ScheduledTime)+",\n")
	s = append(s, "ExpirationTime: "+fmt.Sprintf("%#v", this.ExpirationTime)+",\n")
	if this.LastFailure != nil {
		s = append(s, "LastFailure: "+fmt.Sprintf("%#v", this.LastFailure)+",\n")
	}
	s = append(s, "LastWorkerIdentity: "+fmt.Sprintf("%#v", this.LastWorkerIdentity)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SearchAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&cli.SearchAttributes{")
	keysForIndexedFields := make([]string, 0, len(this.IndexedFields))
	for k, _ := range this.IndexedFields {
		keysForIndexedFields = append(keysForIndexedFields, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForIndexedFields)
	mapStringForIndexedFields := "map[string]string{"
	for _, k := range keysForIndexedFields {
		mapStringForIndexedFields += fmt.Sprintf("%#v: %#v,", k, this.IndexedFields[k])
	}
	mapStringForIndexedFields += "}"
	if this.IndexedFields != nil {
		s = append(s, "IndexedFields: "+mapStringForIndexedFields+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Failure) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&cli.Failure{")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "Source: "+fmt.Sprintf("%#v", this.Source)+",\n")
	s = append(s, "StackTrace: "+fmt.Sprintf("%#v", this.StackTrace)+",\n")
	if this.Cause != nil {
		s = append(s, "Cause: "+fmt.Sprintf("%#v", this.Cause)+",\n")
	}
	s = append(s, "FailureType: "+fmt.Sprintf("%#v", this.FailureType)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AddSearchAttributesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&cli.AddSearchAttributesResponse{")
	s = append(s, "IndexName: "+fmt.Sprintf("%#v", this.IndexName)+",\n")
	keysForCustomSearchAttributes := make([]string, 0, len(this.CustomSearchAttributes))
	for k, _ := range this.CustomSearchAttributes {
		keysForCustomSearchAttributes = append(keysForCustomSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForCustomSearchAttributes)
	mapStringForCustomSearchAttributes := "map[string]string{"
	for _, k := range keysForCustomSearchAttributes {
		mapStringForCustomSearchAttributes += fmt.Sprintf("%#v: %#v,", k, this.CustomSearchAttributes[k])
	}
	mapStringForCustomSearchAttributes += "}"
	if this.CustomSearchAttributes != nil {
		s = append(s, "CustomSearchAttributes: "+mapStringForCustomSearchAttributes+",\n")
	}
	keysForSystemSearchAttributes := make([]string, 0, len(this.SystemSearchAttributes))
	for k, _ := range this.SystemSearchAttributes {
		keysForSystemSearchAttributes = append(keysForSystemSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSystemSearchAttributes)
	mapStringForSystemSearchAttributes := "map[string]string{"
	for _, k := range keysForSystemSearchAttributes {
		mapStringForSystemSearchAttributes += fmt.Sprintf("%#v: %#v,", k, this.SystemSearchAttributes[k])
	}
	mapStringForSystemSearchAttributes += "}"
	if this.SystemSearchAttributes != nil {
		s = append(s, "SystemSearchAttributes: "+mapStringForSystemSearchAttributes+",\n")
	}
	keysForMapping := make([]string, 0, len(this.Mapping))
	for k, _ := range this.Mapping {
		keysForMapping = append(keysForMapping, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMapping)
	mapStringForMapping := "map[string]string{"
	for _, k := range keysForMapping {
		mapStringForMapping += fmt.Sprintf("%#v: %#v,", k, this.Mapping[k])
	}
	mapStringForMapping += "}"
	if this.Mapping != nil {
		s = append(s, "Mapping: "+mapStringForMapping+",\n")
	}
	if this.AddWorkflowExecutionInfo != nil {
		s = append(s, "AddWorkflowExecutionInfo: "+fmt.Sprintf("%#v", this.AddWorkflowExecutionInfo)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringMessage(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *DescribeWorkflowExecutionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeWorkflowExecutionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeWorkflowExecutionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PendingChildren) > 0 {
		for iNdEx := len(m.PendingChildren) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PendingChildren[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMessage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.PendingActivities) > 0 {
		for iNdEx := len(m.PendingActivities) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PendingActivities[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMessage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.WorkflowExecutionInfo != nil {
		{
			size, err := m.WorkflowExecutionInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ExecutionConfig != nil {
		{
			size, err := m.ExecutionConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WorkflowExecutionInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WorkflowExecutionInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WorkflowExecutionInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.StateTransitionCount != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.StateTransitionCount))
		i--
		dAtA[i] = 0x68
	}
	if m.AutoResetPoints != nil {
		{
			size, err := m.AutoResetPoints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.SearchAttributes != nil {
		{
			size, err := m.SearchAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.Memo != nil {
		{
			size, err := m.Memo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.ExecutionTime != nil {
		n6, err6 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ExecutionTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExecutionTime):])
		if err6 != nil {
			return 0, err6
		}
		i -= n6
		i = encodeVarintMessage(dAtA, i, uint64(n6))
		i--
		dAtA[i] = 0x4a
	}
	if m.ParentExecution != nil {
		{
			size, err := m.ParentExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.ParentNamespaceId) > 0 {
		i -= len(m.ParentNamespaceId)
		copy(dAtA[i:], m.ParentNamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ParentNamespaceId)))
		i--
		dAtA[i] = 0x3a
	}
	if m.HistoryLength != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.HistoryLength))
		i--
		dAtA[i] = 0x30
	}
	if m.Status != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x28
	}
	if m.CloseTime != nil {
		n8, err8 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.CloseTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.CloseTime):])
		if err8 != nil {
			return 0, err8
		}
		i -= n8
		i = encodeVarintMessage(dAtA, i, uint64(n8))
		i--
		dAtA[i] = 0x22
	}
	if m.StartTime != nil {
		n9, err9 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartTime):])
		if err9 != nil {
			return 0, err9
		}
		i -= n9
		i = encodeVarintMessage(dAtA, i, uint64(n9))
		i--
		dAtA[i] = 0x1a
	}
	if m.Type != nil {
		{
			size, err := m.Type.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PendingActivityInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PendingActivityInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PendingActivityInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LastWorkerIdentity) > 0 {
		i -= len(m.LastWorkerIdentity)
		copy(dAtA[i:], m.LastWorkerIdentity)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.LastWorkerIdentity)))
		i--
		dAtA[i] = 0x62
	}
	if m.LastFailure != nil {
		{
			size, err := m.LastFailure.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.ExpirationTime != nil {
		n13, err13 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ExpirationTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExpirationTime):])
		if err13 != nil {
			return 0, err13
		}
		i -= n13
		i = encodeVarintMessage(dAtA, i, uint64(n13))
		i--
		dAtA[i] = 0x52
	}
	if m.ScheduledTime != nil {
		n14, err14 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime):])
		if err14 != nil {
			return 0, err14
		}
		i -= n14
		i = encodeVarintMessage(dAtA, i, uint64(n14))
		i--
		dAtA[i] = 0x4a
	}
	if m.MaximumAttempts != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.MaximumAttempts))
		i--
		dAtA[i] = 0x40
	}
	if m.Attempt != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x38
	}
	if m.LastStartedTime != nil {
		n15, err15 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.LastStartedTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastStartedTime):])
		if err15 != nil {
			return 0, err15
		}
		i -= n15
		i = encodeVarintMessage(dAtA, i, uint64(n15))
		i--
		dAtA[i] = 0x32
	}
	if m.LastHeartbeatTime != nil {
		n16, err16 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.LastHeartbeatTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbeatTime):])
		if err16 != nil {
			return 0, err16
		}
		i -= n16
		i = encodeVarintMessage(dAtA, i, uint64(n16))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.HeartbeatDetails) > 0 {
		i -= len(m.HeartbeatDetails)
		copy(dAtA[i:], m.HeartbeatDetails)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.HeartbeatDetails)))
		i--
		dAtA[i] = 0x22
	}
	if m.State != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x18
	}
	if m.ActivityType != nil {
		{
			size, err := m.ActivityType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ActivityId) > 0 {
		i -= len(m.ActivityId)
		copy(dAtA[i:], m.ActivityId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ActivityId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SearchAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SearchAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SearchAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.IndexedFields) > 0 {
		for k := range m.IndexedFields {
			v := m.IndexedFields[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintMessage(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Failure) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Failure) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Failure) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.FailureType) > 0 {
		i -= len(m.FailureType)
		copy(dAtA[i:], m.FailureType)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.FailureType)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Cause != nil {
		{
			size, err := m.Cause.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.StackTrace) > 0 {
		i -= len(m.StackTrace)
		copy(dAtA[i:], m.StackTrace)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.StackTrace)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Source) > 0 {
		i -= len(m.Source)
		copy(dAtA[i:], m.Source)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Source)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AddSearchAttributesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSearchAttributesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddSearchAttributesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AddWorkflowExecutionInfo != nil {
		{
			size, err := m.AddWorkflowExecutionInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Mapping) > 0 {
		for k := range m.Mapping {
			v := m.Mapping[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintMessage(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.SystemSearchAttributes) > 0 {
		for k := range m.SystemSearchAttributes {
			v := m.SystemSearchAttributes[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintMessage(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.CustomSearchAttributes) > 0 {
		for k := range m.CustomSearchAttributes {
			v := m.CustomSearchAttributes[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintMessage(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.IndexName) > 0 {
		i -= len(m.IndexName)
		copy(dAtA[i:], m.IndexName)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.IndexName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintMessage(dAtA []byte, offset int, v uint64) int {
	offset -= sovMessage(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *DescribeWorkflowExecutionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExecutionConfig != nil {
		l = m.ExecutionConfig.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.WorkflowExecutionInfo != nil {
		l = m.WorkflowExecutionInfo.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if len(m.PendingActivities) > 0 {
		for _, e := range m.PendingActivities {
			l = e.Size()
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	if len(m.PendingChildren) > 0 {
		for _, e := range m.PendingChildren {
			l = e.Size()
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	return n
}

func (m *WorkflowExecutionInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Type != nil {
		l = m.Type.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.StartTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.CloseTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.CloseTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovMessage(uint64(m.Status))
	}
	if m.HistoryLength != 0 {
		n += 1 + sovMessage(uint64(m.HistoryLength))
	}
	l = len(m.ParentNamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ParentExecution != nil {
		l = m.ParentExecution.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ExecutionTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExecutionTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Memo != nil {
		l = m.Memo.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.SearchAttributes != nil {
		l = m.SearchAttributes.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.AutoResetPoints != nil {
		l = m.AutoResetPoints.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.StateTransitionCount != 0 {
		n += 1 + sovMessage(uint64(m.StateTransitionCount))
	}
	return n
}

func (m *PendingActivityInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ActivityId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ActivityType != nil {
		l = m.ActivityType.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovMessage(uint64(m.State))
	}
	l = len(m.HeartbeatDetails)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.LastHeartbeatTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbeatTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.LastStartedTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastStartedTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Attempt != 0 {
		n += 1 + sovMessage(uint64(m.Attempt))
	}
	if m.MaximumAttempts != 0 {
		n += 1 + sovMessage(uint64(m.MaximumAttempts))
	}
	if m.ScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ExpirationTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExpirationTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.LastFailure != nil {
		l = m.LastFailure.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.LastWorkerIdentity)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *SearchAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.IndexedFields) > 0 {
		for k, v := range m.IndexedFields {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + 1 + len(v) + sovMessage(uint64(len(v)))
			n += mapEntrySize + 1 + sovMessage(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Failure) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.StackTrace)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Cause != nil {
		l = m.Cause.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.FailureType)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *AddSearchAttributesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.IndexName)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if len(m.CustomSearchAttributes) > 0 {
		for k, v := range m.CustomSearchAttributes {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + 1 + len(v) + sovMessage(uint64(len(v)))
			n += mapEntrySize + 1 + sovMessage(uint64(mapEntrySize))
		}
	}
	if len(m.SystemSearchAttributes) > 0 {
		for k, v := range m.SystemSearchAttributes {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + 1 + len(v) + sovMessage(uint64(len(v)))
			n += mapEntrySize + 1 + sovMessage(uint64(mapEntrySize))
		}
	}
	if len(m.Mapping) > 0 {
		for k, v := range m.Mapping {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + 1 + len(v) + sovMessage(uint64(len(v)))
			n += mapEntrySize + 1 + sovMessage(uint64(mapEntrySize))
		}
	}
	if m.AddWorkflowExecutionInfo != nil {
		l = m.AddWorkflowExecutionInfo.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func sovMessage(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMessage(x uint64) (n int) {
	return sovMessage(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *DescribeWorkflowExecutionResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForPendingActivities := "[]*PendingActivityInfo{"
	for _, f := range this.PendingActivities {
		repeatedStringForPendingActivities += strings.Replace(f.String(), "PendingActivityInfo", "PendingActivityInfo", 1) + ","
	}
	repeatedStringForPendingActivities += "}"
	repeatedStringForPendingChildren := "[]*PendingChildExecutionInfo{"
	for _, f := range this.PendingChildren {
		repeatedStringForPendingChildren += strings.Replace(fmt.Sprintf("%v", f), "PendingChildExecutionInfo", "v1.PendingChildExecutionInfo", 1) + ","
	}
	repeatedStringForPendingChildren += "}"
	s := strings.Join([]string{`&DescribeWorkflowExecutionResponse{`,
		`ExecutionConfig:` + strings.Replace(fmt.Sprintf("%v", this.ExecutionConfig), "WorkflowExecutionConfig", "v1.WorkflowExecutionConfig", 1) + `,`,
		`WorkflowExecutionInfo:` + strings.Replace(this.WorkflowExecutionInfo.String(), "WorkflowExecutionInfo", "WorkflowExecutionInfo", 1) + `,`,
		`PendingActivities:` + repeatedStringForPendingActivities + `,`,
		`PendingChildren:` + repeatedStringForPendingChildren + `,`,
		`}`,
	}, "")
	return s
}
func (this *WorkflowExecutionInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WorkflowExecutionInfo{`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v11.WorkflowExecution", 1) + `,`,
		`Type:` + strings.Replace(fmt.Sprintf("%v", this.Type), "WorkflowType", "v11.WorkflowType", 1) + `,`,
		`StartTime:` + strings.Replace(fmt.Sprintf("%v", this.StartTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`CloseTime:` + strings.Replace(fmt.Sprintf("%v", this.CloseTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`HistoryLength:` + fmt.Sprintf("%v", this.HistoryLength) + `,`,
		`ParentNamespaceId:` + fmt.Sprintf("%v", this.ParentNamespaceId) + `,`,
		`ParentExecution:` + strings.Replace(fmt.Sprintf("%v", this.ParentExecution), "WorkflowExecution", "v11.WorkflowExecution", 1) + `,`,
		`ExecutionTime:` + strings.Replace(fmt.Sprintf("%v", this.ExecutionTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Memo:` + strings.Replace(fmt.Sprintf("%v", this.Memo), "Memo", "v11.Memo", 1) + `,`,
		`SearchAttributes:` + strings.Replace(this.SearchAttributes.String(), "SearchAttributes", "SearchAttributes", 1) + `,`,
		`AutoResetPoints:` + strings.Replace(fmt.Sprintf("%v", this.AutoResetPoints), "ResetPoints", "v1.ResetPoints", 1) + `,`,
		`StateTransitionCount:` + fmt.Sprintf("%v", this.StateTransitionCount) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PendingActivityInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PendingActivityInfo{`,
		`ActivityId:` + fmt.Sprintf("%v", this.ActivityId) + `,`,
		`ActivityType:` + strings.Replace(fmt.Sprintf("%v", this.ActivityType), "ActivityType", "v11.ActivityType", 1) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`HeartbeatDetails:` + fmt.Sprintf("%v", this.HeartbeatDetails) + `,`,
		`LastHeartbeatTime:` + strings.Replace(fmt.Sprintf("%v", this.LastHeartbeatTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`LastStartedTime:` + strings.Replace(fmt.Sprintf("%v", this.LastStartedTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`MaximumAttempts:` + fmt.Sprintf("%v", this.MaximumAttempts) + `,`,
		`ScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.ScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`ExpirationTime:` + strings.Replace(fmt.Sprintf("%v", this.ExpirationTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`LastFailure:` + strings.Replace(this.LastFailure.String(), "Failure", "Failure", 1) + `,`,
		`LastWorkerIdentity:` + fmt.Sprintf("%v", this.LastWorkerIdentity) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SearchAttributes) String() string {
	if this == nil {
		return "nil"
	}
	keysForIndexedFields := make([]string, 0, len(this.IndexedFields))
	for k, _ := range this.IndexedFields {
		keysForIndexedFields = append(keysForIndexedFields, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForIndexedFields)
	mapStringForIndexedFields := "map[string]string{"
	for _, k := range keysForIndexedFields {
		mapStringForIndexedFields += fmt.Sprintf("%v: %v,", k, this.IndexedFields[k])
	}
	mapStringForIndexedFields += "}"
	s := strings.Join([]string{`&SearchAttributes{`,
		`IndexedFields:` + mapStringForIndexedFields + `,`,
		`}`,
	}, "")
	return s
}
func (this *Failure) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Failure{`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`Source:` + fmt.Sprintf("%v", this.Source) + `,`,
		`StackTrace:` + fmt.Sprintf("%v", this.StackTrace) + `,`,
		`Cause:` + strings.Replace(this.Cause.String(), "Failure", "Failure", 1) + `,`,
		`FailureType:` + fmt.Sprintf("%v", this.FailureType) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AddSearchAttributesResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForCustomSearchAttributes := make([]string, 0, len(this.CustomSearchAttributes))
	for k, _ := range this.CustomSearchAttributes {
		keysForCustomSearchAttributes = append(keysForCustomSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForCustomSearchAttributes)
	mapStringForCustomSearchAttributes := "map[string]string{"
	for _, k := range keysForCustomSearchAttributes {
		mapStringForCustomSearchAttributes += fmt.Sprintf("%v: %v,", k, this.CustomSearchAttributes[k])
	}
	mapStringForCustomSearchAttributes += "}"
	keysForSystemSearchAttributes := make([]string, 0, len(this.SystemSearchAttributes))
	for k, _ := range this.SystemSearchAttributes {
		keysForSystemSearchAttributes = append(keysForSystemSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSystemSearchAttributes)
	mapStringForSystemSearchAttributes := "map[string]string{"
	for _, k := range keysForSystemSearchAttributes {
		mapStringForSystemSearchAttributes += fmt.Sprintf("%v: %v,", k, this.SystemSearchAttributes[k])
	}
	mapStringForSystemSearchAttributes += "}"
	keysForMapping := make([]string, 0, len(this.Mapping))
	for k, _ := range this.Mapping {
		keysForMapping = append(keysForMapping, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMapping)
	mapStringForMapping := "map[string]string{"
	for _, k := range keysForMapping {
		mapStringForMapping += fmt.Sprintf("%v: %v,", k, this.Mapping[k])
	}
	mapStringForMapping += "}"
	s := strings.Join([]string{`&AddSearchAttributesResponse{`,
		`IndexName:` + fmt.Sprintf("%v", this.IndexName) + `,`,
		`CustomSearchAttributes:` + mapStringForCustomSearchAttributes + `,`,
		`SystemSearchAttributes:` + mapStringForSystemSearchAttributes + `,`,
		`Mapping:` + mapStringForMapping + `,`,
		`AddWorkflowExecutionInfo:` + strings.Replace(this.AddWorkflowExecutionInfo.String(), "WorkflowExecutionInfo", "WorkflowExecutionInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMessage(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *DescribeWorkflowExecutionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeWorkflowExecutionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeWorkflowExecutionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutionConfig == nil {
				m.ExecutionConfig = &v1.WorkflowExecutionConfig{}
			}
			if err := m.ExecutionConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecutionInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecutionInfo == nil {
				m.WorkflowExecutionInfo = &WorkflowExecutionInfo{}
			}
			if err := m.WorkflowExecutionInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingActivities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PendingActivities = append(m.PendingActivities, &PendingActivityInfo{})
			if err := m.PendingActivities[len(m.PendingActivities)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingChildren", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PendingChildren = append(m.PendingChildren, &v1.PendingChildExecutionInfo{})
			if err := m.PendingChildren[len(m.PendingChildren)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WorkflowExecutionInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WorkflowExecutionInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WorkflowExecutionInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v11.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Type == nil {
				m.Type = &v11.WorkflowType{}
			}
			if err := m.Type.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartTime == nil {
				m.StartTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloseTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CloseTime == nil {
				m.CloseTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.CloseTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= v12.WorkflowExecutionStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryLength", wireType)
			}
			m.HistoryLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HistoryLength |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentNamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentNamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ParentExecution == nil {
				m.ParentExecution = &v11.WorkflowExecution{}
			}
			if err := m.ParentExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutionTime == nil {
				m.ExecutionTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ExecutionTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Memo == nil {
				m.Memo = &v11.Memo{}
			}
			if err := m.Memo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SearchAttributes == nil {
				m.SearchAttributes = &SearchAttributes{}
			}
			if err := m.SearchAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AutoResetPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AutoResetPoints == nil {
				m.AutoResetPoints = &v1.ResetPoints{}
			}
			if err := m.AutoResetPoints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StateTransitionCount", wireType)
			}
			m.StateTransitionCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StateTransitionCount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PendingActivityInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PendingActivityInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PendingActivityInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActivityId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActivityId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActivityType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ActivityType == nil {
				m.ActivityType = &v11.ActivityType{}
			}
			if err := m.ActivityType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= v12.PendingActivityState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatDetails", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeartbeatDetails = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeatTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastHeartbeatTime == nil {
				m.LastHeartbeatTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.LastHeartbeatTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastStartedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastStartedTime == nil {
				m.LastStartedTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.LastStartedTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumAttempts", wireType)
			}
			m.MaximumAttempts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaximumAttempts |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduledTime == nil {
				m.ScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpirationTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpirationTime == nil {
				m.ExpirationTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ExpirationTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastFailure", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastFailure == nil {
				m.LastFailure = &Failure{}
			}
			if err := m.LastFailure.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastWorkerIdentity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastWorkerIdentity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SearchAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SearchAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SearchAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexedFields", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IndexedFields == nil {
				m.IndexedFields = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.IndexedFields[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Failure) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Failure: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Failure: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StackTrace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StackTrace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cause", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cause == nil {
				m.Cause = &Failure{}
			}
			if err := m.Cause.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailureType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FailureType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSearchAttributesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSearchAttributesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSearchAttributesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IndexName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomSearchAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CustomSearchAttributes == nil {
				m.CustomSearchAttributes = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CustomSearchAttributes[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemSearchAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SystemSearchAttributes == nil {
				m.SystemSearchAttributes = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SystemSearchAttributes[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mapping", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Mapping == nil {
				m.Mapping = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Mapping[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddWorkflowExecutionInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AddWorkflowExecutionInfo == nil {
				m.AddWorkflowExecutionInfo = &WorkflowExecutionInfo{}
			}
			if err := m.AddWorkflowExecutionInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMessage(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMessage
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMessage
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMessage
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMessage        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMessage          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMessage = fmt.Errorf("proto: unexpected end of group")
)
