// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/replication/v1/message.proto

package repication

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	v14 "go.temporal.io/api/common/v1"
	v15 "go.temporal.io/api/failure/v1"
	v13 "go.temporal.io/api/history/v1"
	v11 "go.temporal.io/api/namespace/v1"
	v12 "go.temporal.io/api/replication/v1"
	v1 "go.temporal.io/server/api/enums/v1"
	v16 "go.temporal.io/server/api/history/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type ReplicationTask struct {
	TaskType     v1.ReplicationTaskType `protobuf:"varint,1,opt,name=task_type,json=taskType,proto3,enum=temporal.server.api.enums.v1.ReplicationTaskType" json:"task_type,omitempty"`
	SourceTaskId int64                  `protobuf:"varint,2,opt,name=source_task_id,json=sourceTaskId,proto3" json:"source_task_id,omitempty"`
	// Types that are valid to be assigned to Attributes:
	//	*ReplicationTask_NamespaceTaskAttributes
	//	*ReplicationTask_HistoryTaskAttributes
	//	*ReplicationTask_SyncShardStatusTaskAttributes
	//	*ReplicationTask_SyncActivityTaskAttributes
	//	*ReplicationTask_HistoryMetadataTaskAttributes
	//	*ReplicationTask_HistoryTaskV2Attributes
	Attributes isReplicationTask_Attributes `protobuf_oneof:"attributes"`
}

func (m *ReplicationTask) Reset()      { *m = ReplicationTask{} }
func (*ReplicationTask) ProtoMessage() {}
func (*ReplicationTask) Descriptor() ([]byte, []int) {
	return fileDescriptor_edd9fae2af6b0532, []int{0}
}
func (m *ReplicationTask) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicationTask) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationTask.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicationTask) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationTask.Merge(m, src)
}
func (m *ReplicationTask) XXX_Size() int {
	return m.Size()
}
func (m *ReplicationTask) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationTask.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationTask proto.InternalMessageInfo

type isReplicationTask_Attributes interface {
	isReplicationTask_Attributes()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type ReplicationTask_NamespaceTaskAttributes struct {
	NamespaceTaskAttributes *NamespaceTaskAttributes `protobuf:"bytes,3,opt,name=namespace_task_attributes,json=namespaceTaskAttributes,proto3,oneof" json:"namespace_task_attributes,omitempty"`
}
type ReplicationTask_HistoryTaskAttributes struct {
	HistoryTaskAttributes *HistoryTaskAttributes `protobuf:"bytes,4,opt,name=history_task_attributes,json=historyTaskAttributes,proto3,oneof" json:"history_task_attributes,omitempty"`
}
type ReplicationTask_SyncShardStatusTaskAttributes struct {
	SyncShardStatusTaskAttributes *SyncShardStatusTaskAttributes `protobuf:"bytes,5,opt,name=sync_shard_status_task_attributes,json=syncShardStatusTaskAttributes,proto3,oneof" json:"sync_shard_status_task_attributes,omitempty"`
}
type ReplicationTask_SyncActivityTaskAttributes struct {
	SyncActivityTaskAttributes *SyncActivityTaskAttributes `protobuf:"bytes,6,opt,name=sync_activity_task_attributes,json=syncActivityTaskAttributes,proto3,oneof" json:"sync_activity_task_attributes,omitempty"`
}
type ReplicationTask_HistoryMetadataTaskAttributes struct {
	HistoryMetadataTaskAttributes *HistoryMetadataTaskAttributes `protobuf:"bytes,7,opt,name=history_metadata_task_attributes,json=historyMetadataTaskAttributes,proto3,oneof" json:"history_metadata_task_attributes,omitempty"`
}
type ReplicationTask_HistoryTaskV2Attributes struct {
	HistoryTaskV2Attributes *HistoryTaskV2Attributes `protobuf:"bytes,8,opt,name=history_task_v2_attributes,json=historyTaskV2Attributes,proto3,oneof" json:"history_task_v2_attributes,omitempty"`
}

func (*ReplicationTask_NamespaceTaskAttributes) isReplicationTask_Attributes()       {}
func (*ReplicationTask_HistoryTaskAttributes) isReplicationTask_Attributes()         {}
func (*ReplicationTask_SyncShardStatusTaskAttributes) isReplicationTask_Attributes() {}
func (*ReplicationTask_SyncActivityTaskAttributes) isReplicationTask_Attributes()    {}
func (*ReplicationTask_HistoryMetadataTaskAttributes) isReplicationTask_Attributes() {}
func (*ReplicationTask_HistoryTaskV2Attributes) isReplicationTask_Attributes()       {}

func (m *ReplicationTask) GetAttributes() isReplicationTask_Attributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *ReplicationTask) GetTaskType() v1.ReplicationTaskType {
	if m != nil {
		return m.TaskType
	}
	return v1.REPLICATION_TASK_TYPE_UNSPECIFIED
}

func (m *ReplicationTask) GetSourceTaskId() int64 {
	if m != nil {
		return m.SourceTaskId
	}
	return 0
}

func (m *ReplicationTask) GetNamespaceTaskAttributes() *NamespaceTaskAttributes {
	if x, ok := m.GetAttributes().(*ReplicationTask_NamespaceTaskAttributes); ok {
		return x.NamespaceTaskAttributes
	}
	return nil
}

func (m *ReplicationTask) GetHistoryTaskAttributes() *HistoryTaskAttributes {
	if x, ok := m.GetAttributes().(*ReplicationTask_HistoryTaskAttributes); ok {
		return x.HistoryTaskAttributes
	}
	return nil
}

func (m *ReplicationTask) GetSyncShardStatusTaskAttributes() *SyncShardStatusTaskAttributes {
	if x, ok := m.GetAttributes().(*ReplicationTask_SyncShardStatusTaskAttributes); ok {
		return x.SyncShardStatusTaskAttributes
	}
	return nil
}

func (m *ReplicationTask) GetSyncActivityTaskAttributes() *SyncActivityTaskAttributes {
	if x, ok := m.GetAttributes().(*ReplicationTask_SyncActivityTaskAttributes); ok {
		return x.SyncActivityTaskAttributes
	}
	return nil
}

func (m *ReplicationTask) GetHistoryMetadataTaskAttributes() *HistoryMetadataTaskAttributes {
	if x, ok := m.GetAttributes().(*ReplicationTask_HistoryMetadataTaskAttributes); ok {
		return x.HistoryMetadataTaskAttributes
	}
	return nil
}

func (m *ReplicationTask) GetHistoryTaskV2Attributes() *HistoryTaskV2Attributes {
	if x, ok := m.GetAttributes().(*ReplicationTask_HistoryTaskV2Attributes); ok {
		return x.HistoryTaskV2Attributes
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReplicationTask) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReplicationTask_NamespaceTaskAttributes)(nil),
		(*ReplicationTask_HistoryTaskAttributes)(nil),
		(*ReplicationTask_SyncShardStatusTaskAttributes)(nil),
		(*ReplicationTask_SyncActivityTaskAttributes)(nil),
		(*ReplicationTask_HistoryMetadataTaskAttributes)(nil),
		(*ReplicationTask_HistoryTaskV2Attributes)(nil),
	}
}

type ReplicationToken struct {
	ShardId int32 `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	// lastRetrievedMessageId is where the next fetch should begin with.
	LastRetrievedMessageId int64 `protobuf:"varint,2,opt,name=last_retrieved_message_id,json=lastRetrievedMessageId,proto3" json:"last_retrieved_message_id,omitempty"`
	// lastProcessedMessageId is the last messageId that is processed on the passive side.
	// This can be different than lastRetrievedMessageId if passive side supports prefetching messages.
	LastProcessedMessageId int64 `protobuf:"varint,3,opt,name=last_processed_message_id,json=lastProcessedMessageId,proto3" json:"last_processed_message_id,omitempty"`
}

func (m *ReplicationToken) Reset()      { *m = ReplicationToken{} }
func (*ReplicationToken) ProtoMessage() {}
func (*ReplicationToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_edd9fae2af6b0532, []int{1}
}
func (m *ReplicationToken) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicationToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationToken.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicationToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationToken.Merge(m, src)
}
func (m *ReplicationToken) XXX_Size() int {
	return m.Size()
}
func (m *ReplicationToken) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationToken.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationToken proto.InternalMessageInfo

func (m *ReplicationToken) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *ReplicationToken) GetLastRetrievedMessageId() int64 {
	if m != nil {
		return m.LastRetrievedMessageId
	}
	return 0
}

func (m *ReplicationToken) GetLastProcessedMessageId() int64 {
	if m != nil {
		return m.LastProcessedMessageId
	}
	return 0
}

type SyncShardStatus struct {
	StatusTime *time.Time `protobuf:"bytes,1,opt,name=status_time,json=statusTime,proto3,stdtime" json:"status_time,omitempty"`
}

func (m *SyncShardStatus) Reset()      { *m = SyncShardStatus{} }
func (*SyncShardStatus) ProtoMessage() {}
func (*SyncShardStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_edd9fae2af6b0532, []int{2}
}
func (m *SyncShardStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SyncShardStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SyncShardStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SyncShardStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncShardStatus.Merge(m, src)
}
func (m *SyncShardStatus) XXX_Size() int {
	return m.Size()
}
func (m *SyncShardStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncShardStatus.DiscardUnknown(m)
}

var xxx_messageInfo_SyncShardStatus proto.InternalMessageInfo

func (m *SyncShardStatus) GetStatusTime() *time.Time {
	if m != nil {
		return m.StatusTime
	}
	return nil
}

type ReplicationMessages struct {
	ReplicationTasks []*ReplicationTask `protobuf:"bytes,1,rep,name=replication_tasks,json=replicationTasks,proto3" json:"replication_tasks,omitempty"`
	// This can be different than the last taskId in the above list, because sender can decide to skip tasks (e.g. for completed workflows).
	LastRetrievedMessageId int64 `protobuf:"varint,2,opt,name=last_retrieved_message_id,json=lastRetrievedMessageId,proto3" json:"last_retrieved_message_id,omitempty"`
	// Hint for flow control.
	HasMore         bool             `protobuf:"varint,3,opt,name=has_more,json=hasMore,proto3" json:"has_more,omitempty"`
	SyncShardStatus *SyncShardStatus `protobuf:"bytes,4,opt,name=sync_shard_status,json=syncShardStatus,proto3" json:"sync_shard_status,omitempty"`
}

func (m *ReplicationMessages) Reset()      { *m = ReplicationMessages{} }
func (*ReplicationMessages) ProtoMessage() {}
func (*ReplicationMessages) Descriptor() ([]byte, []int) {
	return fileDescriptor_edd9fae2af6b0532, []int{3}
}
func (m *ReplicationMessages) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicationMessages) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationMessages.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicationMessages) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationMessages.Merge(m, src)
}
func (m *ReplicationMessages) XXX_Size() int {
	return m.Size()
}
func (m *ReplicationMessages) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationMessages.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationMessages proto.InternalMessageInfo

func (m *ReplicationMessages) GetReplicationTasks() []*ReplicationTask {
	if m != nil {
		return m.ReplicationTasks
	}
	return nil
}

func (m *ReplicationMessages) GetLastRetrievedMessageId() int64 {
	if m != nil {
		return m.LastRetrievedMessageId
	}
	return 0
}

func (m *ReplicationMessages) GetHasMore() bool {
	if m != nil {
		return m.HasMore
	}
	return false
}

func (m *ReplicationMessages) GetSyncShardStatus() *SyncShardStatus {
	if m != nil {
		return m.SyncShardStatus
	}
	return nil
}

type ReplicationTaskInfo struct {
	NamespaceId  string      `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId   string      `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId        string      `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	TaskType     v1.TaskType `protobuf:"varint,4,opt,name=task_type,json=taskType,proto3,enum=temporal.server.api.enums.v1.TaskType" json:"task_type,omitempty"`
	TaskId       int64       `protobuf:"varint,5,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	Version      int64       `protobuf:"varint,6,opt,name=version,proto3" json:"version,omitempty"`
	FirstEventId int64       `protobuf:"varint,7,opt,name=first_event_id,json=firstEventId,proto3" json:"first_event_id,omitempty"`
	NextEventId  int64       `protobuf:"varint,8,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	ScheduledId  int64       `protobuf:"varint,9,opt,name=scheduled_id,json=scheduledId,proto3" json:"scheduled_id,omitempty"`
}

func (m *ReplicationTaskInfo) Reset()      { *m = ReplicationTaskInfo{} }
func (*ReplicationTaskInfo) ProtoMessage() {}
func (*ReplicationTaskInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_edd9fae2af6b0532, []int{4}
}
func (m *ReplicationTaskInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicationTaskInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationTaskInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicationTaskInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationTaskInfo.Merge(m, src)
}
func (m *ReplicationTaskInfo) XXX_Size() int {
	return m.Size()
}
func (m *ReplicationTaskInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationTaskInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationTaskInfo proto.InternalMessageInfo

func (m *ReplicationTaskInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ReplicationTaskInfo) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *ReplicationTaskInfo) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *ReplicationTaskInfo) GetTaskType() v1.TaskType {
	if m != nil {
		return m.TaskType
	}
	return v1.TASK_TYPE_UNSPECIFIED
}

func (m *ReplicationTaskInfo) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *ReplicationTaskInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *ReplicationTaskInfo) GetFirstEventId() int64 {
	if m != nil {
		return m.FirstEventId
	}
	return 0
}

func (m *ReplicationTaskInfo) GetNextEventId() int64 {
	if m != nil {
		return m.NextEventId
	}
	return 0
}

func (m *ReplicationTaskInfo) GetScheduledId() int64 {
	if m != nil {
		return m.ScheduledId
	}
	return 0
}

type NamespaceTaskAttributes struct {
	NamespaceOperation v1.NamespaceOperation           `protobuf:"varint,1,opt,name=namespace_operation,json=namespaceOperation,proto3,enum=temporal.server.api.enums.v1.NamespaceOperation" json:"namespace_operation,omitempty"`
	Id                 string                          `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	Info               *v11.NamespaceInfo              `protobuf:"bytes,3,opt,name=info,proto3" json:"info,omitempty"`
	Config             *v11.NamespaceConfig            `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
	ReplicationConfig  *v12.NamespaceReplicationConfig `protobuf:"bytes,5,opt,name=replication_config,json=replicationConfig,proto3" json:"replication_config,omitempty"`
	ConfigVersion      int64                           `protobuf:"varint,6,opt,name=config_version,json=configVersion,proto3" json:"config_version,omitempty"`
	FailoverVersion    int64                           `protobuf:"varint,7,opt,name=failover_version,json=failoverVersion,proto3" json:"failover_version,omitempty"`
}

func (m *NamespaceTaskAttributes) Reset()      { *m = NamespaceTaskAttributes{} }
func (*NamespaceTaskAttributes) ProtoMessage() {}
func (*NamespaceTaskAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_edd9fae2af6b0532, []int{5}
}
func (m *NamespaceTaskAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceTaskAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceTaskAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceTaskAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceTaskAttributes.Merge(m, src)
}
func (m *NamespaceTaskAttributes) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceTaskAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceTaskAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceTaskAttributes proto.InternalMessageInfo

func (m *NamespaceTaskAttributes) GetNamespaceOperation() v1.NamespaceOperation {
	if m != nil {
		return m.NamespaceOperation
	}
	return v1.NAMESPACE_OPERATION_UNSPECIFIED
}

func (m *NamespaceTaskAttributes) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *NamespaceTaskAttributes) GetInfo() *v11.NamespaceInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *NamespaceTaskAttributes) GetConfig() *v11.NamespaceConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *NamespaceTaskAttributes) GetReplicationConfig() *v12.NamespaceReplicationConfig {
	if m != nil {
		return m.ReplicationConfig
	}
	return nil
}

func (m *NamespaceTaskAttributes) GetConfigVersion() int64 {
	if m != nil {
		return m.ConfigVersion
	}
	return 0
}

func (m *NamespaceTaskAttributes) GetFailoverVersion() int64 {
	if m != nil {
		return m.FailoverVersion
	}
	return 0
}

type HistoryTaskAttributes struct {
	TargetClusters []string     `protobuf:"bytes,1,rep,name=target_clusters,json=targetClusters,proto3" json:"target_clusters,omitempty"`
	NamespaceId    string       `protobuf:"bytes,2,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId     string       `protobuf:"bytes,3,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId          string       `protobuf:"bytes,4,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	FirstEventId   int64        `protobuf:"varint,5,opt,name=first_event_id,json=firstEventId,proto3" json:"first_event_id,omitempty"`
	NextEventId    int64        `protobuf:"varint,6,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	Version        int64        `protobuf:"varint,7,opt,name=version,proto3" json:"version,omitempty"`
	History        *v13.History `protobuf:"bytes,9,opt,name=history,proto3" json:"history,omitempty"`
	NewRunHistory  *v13.History `protobuf:"bytes,10,opt,name=new_run_history,json=newRunHistory,proto3" json:"new_run_history,omitempty"`
}

func (m *HistoryTaskAttributes) Reset()      { *m = HistoryTaskAttributes{} }
func (*HistoryTaskAttributes) ProtoMessage() {}
func (*HistoryTaskAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_edd9fae2af6b0532, []int{6}
}
func (m *HistoryTaskAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistoryTaskAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistoryTaskAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistoryTaskAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistoryTaskAttributes.Merge(m, src)
}
func (m *HistoryTaskAttributes) XXX_Size() int {
	return m.Size()
}
func (m *HistoryTaskAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_HistoryTaskAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_HistoryTaskAttributes proto.InternalMessageInfo

func (m *HistoryTaskAttributes) GetTargetClusters() []string {
	if m != nil {
		return m.TargetClusters
	}
	return nil
}

func (m *HistoryTaskAttributes) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *HistoryTaskAttributes) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *HistoryTaskAttributes) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *HistoryTaskAttributes) GetFirstEventId() int64 {
	if m != nil {
		return m.FirstEventId
	}
	return 0
}

func (m *HistoryTaskAttributes) GetNextEventId() int64 {
	if m != nil {
		return m.NextEventId
	}
	return 0
}

func (m *HistoryTaskAttributes) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *HistoryTaskAttributes) GetHistory() *v13.History {
	if m != nil {
		return m.History
	}
	return nil
}

func (m *HistoryTaskAttributes) GetNewRunHistory() *v13.History {
	if m != nil {
		return m.NewRunHistory
	}
	return nil
}

type HistoryMetadataTaskAttributes struct {
	TargetClusters []string `protobuf:"bytes,1,rep,name=target_clusters,json=targetClusters,proto3" json:"target_clusters,omitempty"`
	NamespaceId    string   `protobuf:"bytes,2,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId     string   `protobuf:"bytes,3,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId          string   `protobuf:"bytes,4,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	FirstEventId   int64    `protobuf:"varint,5,opt,name=first_event_id,json=firstEventId,proto3" json:"first_event_id,omitempty"`
	NextEventId    int64    `protobuf:"varint,6,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	Version        int64    `protobuf:"varint,7,opt,name=version,proto3" json:"version,omitempty"`
}

func (m *HistoryMetadataTaskAttributes) Reset()      { *m = HistoryMetadataTaskAttributes{} }
func (*HistoryMetadataTaskAttributes) ProtoMessage() {}
func (*HistoryMetadataTaskAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_edd9fae2af6b0532, []int{7}
}
func (m *HistoryMetadataTaskAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistoryMetadataTaskAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistoryMetadataTaskAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistoryMetadataTaskAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistoryMetadataTaskAttributes.Merge(m, src)
}
func (m *HistoryMetadataTaskAttributes) XXX_Size() int {
	return m.Size()
}
func (m *HistoryMetadataTaskAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_HistoryMetadataTaskAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_HistoryMetadataTaskAttributes proto.InternalMessageInfo

func (m *HistoryMetadataTaskAttributes) GetTargetClusters() []string {
	if m != nil {
		return m.TargetClusters
	}
	return nil
}

func (m *HistoryMetadataTaskAttributes) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *HistoryMetadataTaskAttributes) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *HistoryMetadataTaskAttributes) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *HistoryMetadataTaskAttributes) GetFirstEventId() int64 {
	if m != nil {
		return m.FirstEventId
	}
	return 0
}

func (m *HistoryMetadataTaskAttributes) GetNextEventId() int64 {
	if m != nil {
		return m.NextEventId
	}
	return 0
}

func (m *HistoryMetadataTaskAttributes) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

type SyncShardStatusTaskAttributes struct {
	SourceCluster string     `protobuf:"bytes,1,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	ShardId       int32      `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	StatusTime    *time.Time `protobuf:"bytes,3,opt,name=status_time,json=statusTime,proto3,stdtime" json:"status_time,omitempty"`
}

func (m *SyncShardStatusTaskAttributes) Reset()      { *m = SyncShardStatusTaskAttributes{} }
func (*SyncShardStatusTaskAttributes) ProtoMessage() {}
func (*SyncShardStatusTaskAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_edd9fae2af6b0532, []int{8}
}
func (m *SyncShardStatusTaskAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SyncShardStatusTaskAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SyncShardStatusTaskAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SyncShardStatusTaskAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncShardStatusTaskAttributes.Merge(m, src)
}
func (m *SyncShardStatusTaskAttributes) XXX_Size() int {
	return m.Size()
}
func (m *SyncShardStatusTaskAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncShardStatusTaskAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_SyncShardStatusTaskAttributes proto.InternalMessageInfo

func (m *SyncShardStatusTaskAttributes) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *SyncShardStatusTaskAttributes) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *SyncShardStatusTaskAttributes) GetStatusTime() *time.Time {
	if m != nil {
		return m.StatusTime
	}
	return nil
}

type SyncActivityTaskAttributes struct {
	NamespaceId        string              `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId         string              `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId              string              `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	Version            int64               `protobuf:"varint,4,opt,name=version,proto3" json:"version,omitempty"`
	ScheduledId        int64               `protobuf:"varint,5,opt,name=scheduled_id,json=scheduledId,proto3" json:"scheduled_id,omitempty"`
	ScheduledTime      *time.Time          `protobuf:"bytes,6,opt,name=scheduled_time,json=scheduledTime,proto3,stdtime" json:"scheduled_time,omitempty"`
	StartedId          int64               `protobuf:"varint,7,opt,name=started_id,json=startedId,proto3" json:"started_id,omitempty"`
	StartedTime        *time.Time          `protobuf:"bytes,8,opt,name=started_time,json=startedTime,proto3,stdtime" json:"started_time,omitempty"`
	LastHeartbeatTime  *time.Time          `protobuf:"bytes,9,opt,name=last_heartbeat_time,json=lastHeartbeatTime,proto3,stdtime" json:"last_heartbeat_time,omitempty"`
	Details            *v14.Payloads       `protobuf:"bytes,10,opt,name=details,proto3" json:"details,omitempty"`
	Attempt            int32               `protobuf:"varint,11,opt,name=attempt,proto3" json:"attempt,omitempty"`
	LastFailure        *v15.Failure        `protobuf:"bytes,12,opt,name=last_failure,json=lastFailure,proto3" json:"last_failure,omitempty"`
	LastWorkerIdentity string              `protobuf:"bytes,13,opt,name=last_worker_identity,json=lastWorkerIdentity,proto3" json:"last_worker_identity,omitempty"`
	VersionHistory     *v16.VersionHistory `protobuf:"bytes,14,opt,name=version_history,json=versionHistory,proto3" json:"version_history,omitempty"`
}

func (m *SyncActivityTaskAttributes) Reset()      { *m = SyncActivityTaskAttributes{} }
func (*SyncActivityTaskAttributes) ProtoMessage() {}
func (*SyncActivityTaskAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_edd9fae2af6b0532, []int{9}
}
func (m *SyncActivityTaskAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SyncActivityTaskAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SyncActivityTaskAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SyncActivityTaskAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncActivityTaskAttributes.Merge(m, src)
}
func (m *SyncActivityTaskAttributes) XXX_Size() int {
	return m.Size()
}
func (m *SyncActivityTaskAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncActivityTaskAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_SyncActivityTaskAttributes proto.InternalMessageInfo

func (m *SyncActivityTaskAttributes) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *SyncActivityTaskAttributes) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *SyncActivityTaskAttributes) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *SyncActivityTaskAttributes) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *SyncActivityTaskAttributes) GetScheduledId() int64 {
	if m != nil {
		return m.ScheduledId
	}
	return 0
}

func (m *SyncActivityTaskAttributes) GetScheduledTime() *time.Time {
	if m != nil {
		return m.ScheduledTime
	}
	return nil
}

func (m *SyncActivityTaskAttributes) GetStartedId() int64 {
	if m != nil {
		return m.StartedId
	}
	return 0
}

func (m *SyncActivityTaskAttributes) GetStartedTime() *time.Time {
	if m != nil {
		return m.StartedTime
	}
	return nil
}

func (m *SyncActivityTaskAttributes) GetLastHeartbeatTime() *time.Time {
	if m != nil {
		return m.LastHeartbeatTime
	}
	return nil
}

func (m *SyncActivityTaskAttributes) GetDetails() *v14.Payloads {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *SyncActivityTaskAttributes) GetAttempt() int32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

func (m *SyncActivityTaskAttributes) GetLastFailure() *v15.Failure {
	if m != nil {
		return m.LastFailure
	}
	return nil
}

func (m *SyncActivityTaskAttributes) GetLastWorkerIdentity() string {
	if m != nil {
		return m.LastWorkerIdentity
	}
	return ""
}

func (m *SyncActivityTaskAttributes) GetVersionHistory() *v16.VersionHistory {
	if m != nil {
		return m.VersionHistory
	}
	return nil
}

type HistoryTaskV2Attributes struct {
	// TODO remove this task_id attribute once kafka deprecation is done
	TaskId              int64                     `protobuf:"varint,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	NamespaceId         string                    `protobuf:"bytes,2,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId          string                    `protobuf:"bytes,3,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId               string                    `protobuf:"bytes,4,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	VersionHistoryItems []*v16.VersionHistoryItem `protobuf:"bytes,5,rep,name=version_history_items,json=versionHistoryItems,proto3" json:"version_history_items,omitempty"`
	Events              *v14.DataBlob             `protobuf:"bytes,6,opt,name=events,proto3" json:"events,omitempty"`
	// New run events does not need version history since there is no prior events.
	NewRunEvents *v14.DataBlob `protobuf:"bytes,7,opt,name=new_run_events,json=newRunEvents,proto3" json:"new_run_events,omitempty"`
}

func (m *HistoryTaskV2Attributes) Reset()      { *m = HistoryTaskV2Attributes{} }
func (*HistoryTaskV2Attributes) ProtoMessage() {}
func (*HistoryTaskV2Attributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_edd9fae2af6b0532, []int{10}
}
func (m *HistoryTaskV2Attributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistoryTaskV2Attributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistoryTaskV2Attributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistoryTaskV2Attributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistoryTaskV2Attributes.Merge(m, src)
}
func (m *HistoryTaskV2Attributes) XXX_Size() int {
	return m.Size()
}
func (m *HistoryTaskV2Attributes) XXX_DiscardUnknown() {
	xxx_messageInfo_HistoryTaskV2Attributes.DiscardUnknown(m)
}

var xxx_messageInfo_HistoryTaskV2Attributes proto.InternalMessageInfo

func (m *HistoryTaskV2Attributes) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *HistoryTaskV2Attributes) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *HistoryTaskV2Attributes) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *HistoryTaskV2Attributes) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *HistoryTaskV2Attributes) GetVersionHistoryItems() []*v16.VersionHistoryItem {
	if m != nil {
		return m.VersionHistoryItems
	}
	return nil
}

func (m *HistoryTaskV2Attributes) GetEvents() *v14.DataBlob {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *HistoryTaskV2Attributes) GetNewRunEvents() *v14.DataBlob {
	if m != nil {
		return m.NewRunEvents
	}
	return nil
}

func init() {
	proto.RegisterType((*ReplicationTask)(nil), "temporal.server.api.replication.v1.ReplicationTask")
	proto.RegisterType((*ReplicationToken)(nil), "temporal.server.api.replication.v1.ReplicationToken")
	proto.RegisterType((*SyncShardStatus)(nil), "temporal.server.api.replication.v1.SyncShardStatus")
	proto.RegisterType((*ReplicationMessages)(nil), "temporal.server.api.replication.v1.ReplicationMessages")
	proto.RegisterType((*ReplicationTaskInfo)(nil), "temporal.server.api.replication.v1.ReplicationTaskInfo")
	proto.RegisterType((*NamespaceTaskAttributes)(nil), "temporal.server.api.replication.v1.NamespaceTaskAttributes")
	proto.RegisterType((*HistoryTaskAttributes)(nil), "temporal.server.api.replication.v1.HistoryTaskAttributes")
	proto.RegisterType((*HistoryMetadataTaskAttributes)(nil), "temporal.server.api.replication.v1.HistoryMetadataTaskAttributes")
	proto.RegisterType((*SyncShardStatusTaskAttributes)(nil), "temporal.server.api.replication.v1.SyncShardStatusTaskAttributes")
	proto.RegisterType((*SyncActivityTaskAttributes)(nil), "temporal.server.api.replication.v1.SyncActivityTaskAttributes")
	proto.RegisterType((*HistoryTaskV2Attributes)(nil), "temporal.server.api.replication.v1.HistoryTaskV2Attributes")
}

func init() {
	proto.RegisterFile("temporal/server/api/replication/v1/message.proto", fileDescriptor_edd9fae2af6b0532)
}

var fileDescriptor_edd9fae2af6b0532 = []byte{
	// 1503 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x58, 0x3b, 0x6f, 0x1b, 0xc7,
	0x16, 0xd6, 0xf2, 0xcd, 0xe1, 0xd3, 0xa3, 0xab, 0x2b, 0x8a, 0x80, 0x68, 0x89, 0xb0, 0xaf, 0xe5,
	0x8b, 0x60, 0x69, 0x51, 0x45, 0x62, 0x3b, 0x08, 0x20, 0x39, 0x71, 0x44, 0x01, 0x76, 0x8c, 0xb5,
	0x60, 0x03, 0x69, 0x36, 0x23, 0xee, 0x90, 0x5c, 0x88, 0xdc, 0x25, 0x66, 0x86, 0x54, 0x98, 0x2a,
	0x40, 0x8a, 0x34, 0x09, 0xe0, 0xff, 0xe0, 0x20, 0x48, 0x95, 0xdf, 0xe1, 0xd2, 0x4d, 0x00, 0xa7,
	0x4a, 0x4c, 0x37, 0x29, 0xdd, 0xa5, 0x0d, 0xe6, 0xb1, 0xe4, 0x2e, 0x97, 0xa4, 0x19, 0x07, 0xae,
	0xd2, 0x71, 0xce, 0xe3, 0x3b, 0x33, 0x67, 0xce, 0x39, 0xdf, 0x2c, 0xc1, 0x0d, 0x86, 0x7b, 0x7d,
	0x97, 0xa0, 0x6e, 0x8d, 0x62, 0x32, 0xc4, 0xa4, 0x86, 0xfa, 0x76, 0x8d, 0xe0, 0x7e, 0xd7, 0x6e,
	0x22, 0x66, 0xbb, 0x4e, 0x6d, 0xb8, 0x5f, 0xeb, 0x61, 0x4a, 0x51, 0x1b, 0xeb, 0x7d, 0xe2, 0x32,
	0x17, 0x56, 0x3d, 0x0f, 0x5d, 0x7a, 0xe8, 0xa8, 0x6f, 0xeb, 0x3e, 0x0f, 0x7d, 0xb8, 0x5f, 0xbe,
	0xdc, 0x76, 0xdd, 0x76, 0x17, 0xd7, 0x84, 0xc7, 0xd9, 0xa0, 0x55, 0x63, 0x76, 0x0f, 0x53, 0x86,
	0x7a, 0x7d, 0x09, 0x52, 0xde, 0xb5, 0x70, 0x1f, 0x3b, 0x16, 0x76, 0x9a, 0x36, 0xa6, 0xb5, 0xb6,
	0xdb, 0x76, 0x85, 0x5c, 0xfc, 0x52, 0x26, 0xfa, 0xbc, 0x9d, 0x61, 0x67, 0xd0, 0xa3, 0x7c, 0x4f,
	0xfe, 0x80, 0xd2, 0xfe, 0xda, 0x52, 0x7b, 0x86, 0xe8, 0xb9, 0x32, 0x7c, 0x6f, 0x9e, 0x61, 0xc7,
	0xa6, 0xcc, 0x25, 0xa3, 0xd0, 0x71, 0xcb, 0x57, 0x26, 0xd6, 0xdc, 0xac, 0xe9, 0xf6, 0x7a, 0x73,
	0x92, 0xe2, 0x0b, 0xce, 0xad, 0x1c, 0xd4, 0xc3, 0xb4, 0x8f, 0x9a, 0x38, 0x6c, 0x78, 0x3d, 0x60,
	0xb8, 0x2c, 0xd1, 0xe5, 0xab, 0x01, 0xd3, 0x85, 0x1b, 0x0c, 0x9a, 0xb5, 0x90, 0xdd, 0x1d, 0x90,
	0x70, 0xe0, 0xea, 0x8f, 0x49, 0x50, 0x30, 0xa6, 0xe1, 0x4e, 0x11, 0x3d, 0x87, 0xf7, 0x41, 0x9a,
	0xe7, 0xc5, 0x64, 0xa3, 0x3e, 0x2e, 0x69, 0x3b, 0xda, 0x5e, 0xbe, 0xbe, 0xaf, 0xcf, 0xbb, 0x5e,
	0x91, 0x46, 0x7d, 0xb8, 0xaf, 0xcf, 0x20, 0x9c, 0x8e, 0xfa, 0xd8, 0x48, 0x31, 0xf5, 0x0b, 0x5e,
	0x01, 0x79, 0xea, 0x0e, 0x48, 0x13, 0x9b, 0x02, 0xd6, 0xb6, 0x4a, 0x91, 0x1d, 0x6d, 0x2f, 0x6a,
	0x64, 0xa5, 0x94, 0x7b, 0x34, 0x2c, 0x38, 0x02, 0x5b, 0x93, 0x04, 0x49, 0x43, 0xc4, 0x18, 0xb1,
	0xcf, 0x06, 0x0c, 0xd3, 0x52, 0x74, 0x47, 0xdb, 0xcb, 0xd4, 0x6f, 0xeb, 0x6f, 0x2e, 0x32, 0xfd,
	0xbe, 0x07, 0xc2, 0x71, 0x0f, 0x27, 0x10, 0xc7, 0x6b, 0xc6, 0xa6, 0x33, 0x5f, 0x05, 0x29, 0xd8,
	0x54, 0x79, 0x0c, 0x05, 0x8e, 0x89, 0xc0, 0x37, 0x57, 0x09, 0x7c, 0x2c, 0x21, 0x42, 0x61, 0x37,
	0x3a, 0xf3, 0x14, 0xf0, 0x7b, 0x0d, 0xec, 0xd2, 0x91, 0xd3, 0x34, 0x69, 0x07, 0x11, 0xcb, 0xa4,
	0x0c, 0xb1, 0x01, 0x0d, 0xc5, 0x8f, 0x8b, 0xf8, 0x87, 0xab, 0xc4, 0x7f, 0x38, 0x72, 0x9a, 0x0f,
	0x39, 0xd6, 0x43, 0x01, 0x15, 0xda, 0xc7, 0x36, 0x5d, 0x66, 0x00, 0xbf, 0xd1, 0x80, 0xb0, 0x30,
	0x51, 0x93, 0xd9, 0x43, 0x9b, 0x85, 0x73, 0x91, 0x10, 0x7b, 0xf9, 0x68, 0xd5, 0xbd, 0x1c, 0x2a,
	0x9c, 0xd0, 0x46, 0xca, 0x74, 0xa1, 0x16, 0x7e, 0xa7, 0x81, 0x1d, 0xef, 0x2e, 0x7a, 0x98, 0x21,
	0x0b, 0x31, 0x14, 0xda, 0x48, 0x72, 0xf5, 0xa4, 0xa8, 0x4b, 0xb9, 0xa7, 0xa0, 0xc2, 0x49, 0xe9,
	0x2c, 0x33, 0x80, 0x5f, 0x81, 0x72, 0xa0, 0x32, 0x86, 0x75, 0xff, 0x3e, 0x52, 0xab, 0x57, 0xa5,
	0xaf, 0x38, 0x1e, 0xd5, 0x83, 0x55, 0xd9, 0x99, 0xaf, 0x3a, 0xca, 0x02, 0x30, 0x8d, 0x55, 0x7d,
	0xaa, 0x81, 0xa2, 0xbf, 0xcd, 0xdc, 0x73, 0xec, 0xc0, 0x2d, 0x90, 0x92, 0xd5, 0x63, 0x5b, 0xa2,
	0x51, 0xe3, 0x46, 0x52, 0xac, 0x1b, 0x16, 0xbc, 0x09, 0xb6, 0xba, 0x88, 0x32, 0x93, 0x60, 0x46,
	0x6c, 0x3c, 0xc4, 0x96, 0xa9, 0x1a, 0x7f, 0xda, 0x7f, 0xff, 0xe5, 0x06, 0x86, 0xa7, 0xbf, 0x27,
	0xd5, 0x3e, 0xd7, 0x3e, 0x71, 0x9b, 0x98, 0xd2, 0xa0, 0x6b, 0x74, 0xea, 0xfa, 0xc0, 0xd3, 0x4f,
	0x5c, 0xab, 0xa7, 0xa0, 0x30, 0x53, 0x86, 0xf0, 0x10, 0x64, 0xbc, 0xda, 0xb6, 0x7b, 0x72, 0x9e,
	0x64, 0xea, 0x65, 0x5d, 0x52, 0x81, 0xee, 0x51, 0x81, 0x7e, 0xea, 0x51, 0xc1, 0x51, 0xec, 0xc9,
	0x6f, 0x97, 0x35, 0x03, 0x48, 0x27, 0x2e, 0xae, 0xfe, 0x1c, 0x01, 0xeb, 0xbe, 0xb3, 0xab, 0x70,
	0x14, 0x7e, 0x01, 0x2e, 0xf9, 0xd2, 0x2c, 0x6e, 0x88, 0x96, 0xb4, 0x9d, 0xe8, 0x5e, 0xa6, 0x7e,
	0xb0, 0xca, 0xa5, 0xcc, 0x8c, 0x2d, 0xa3, 0x48, 0x82, 0x02, 0xfa, 0x4f, 0xb2, 0xb8, 0x05, 0x52,
	0x1d, 0x44, 0xcd, 0x9e, 0x4b, 0xb0, 0x48, 0x5a, 0xca, 0x48, 0x76, 0x10, 0xbd, 0xe7, 0x12, 0x0c,
	0x4d, 0x70, 0x29, 0xd4, 0xf9, 0x6a, 0xd2, 0x1c, 0xbc, 0x45, 0xa7, 0x1b, 0x85, 0x99, 0xce, 0xae,
	0xfe, 0x12, 0x4c, 0x98, 0x98, 0xb0, 0x4e, 0xcb, 0x85, 0xbb, 0x20, 0x3b, 0x9d, 0xb1, 0xaa, 0x66,
	0xd2, 0x46, 0x66, 0x22, 0x6b, 0x58, 0xf0, 0x32, 0xc8, 0x5c, 0xb8, 0xe4, 0xbc, 0xd5, 0x75, 0x2f,
	0xbc, 0x33, 0xa6, 0x0d, 0xe0, 0x89, 0x1a, 0x16, 0xdc, 0x00, 0x09, 0x32, 0x70, 0xbc, 0x52, 0x48,
	0x1b, 0x71, 0x32, 0x70, 0x1a, 0x16, 0xbc, 0xe3, 0x27, 0x8d, 0x98, 0x20, 0x8d, 0xff, 0x2d, 0x27,
	0x8d, 0x39, 0x4c, 0xb1, 0x09, 0x92, 0x1e, 0x45, 0xc4, 0x45, 0x72, 0x13, 0x4c, 0x92, 0x43, 0x09,
	0x24, 0x87, 0x98, 0x50, 0xdb, 0x75, 0xc4, 0x14, 0x8a, 0x1a, 0xde, 0x92, 0x93, 0x4b, 0xcb, 0x26,
	0x94, 0x99, 0x78, 0x88, 0x1d, 0xc6, 0x3d, 0x93, 0x92, 0x5c, 0x84, 0xf4, 0x13, 0x2e, 0x6c, 0x58,
	0xb0, 0x0a, 0x72, 0x0e, 0xfe, 0xd2, 0x67, 0x94, 0x12, 0x46, 0x19, 0x2e, 0xf4, 0x6c, 0x76, 0x41,
	0x96, 0x36, 0x3b, 0xd8, 0x1a, 0x74, 0xb1, 0x68, 0xa8, 0xb4, 0x34, 0x99, 0xc8, 0x1a, 0x56, 0xf5,
	0x59, 0x14, 0x6c, 0x2e, 0xe0, 0x17, 0x88, 0xc0, 0xfa, 0x34, 0xb7, 0x6e, 0x1f, 0x13, 0x91, 0x7a,
	0xc5, 0x9f, 0x37, 0x96, 0xa7, 0x62, 0x82, 0xf9, 0x99, 0xe7, 0x67, 0x40, 0x27, 0x24, 0x83, 0x79,
	0x10, 0x99, 0x5c, 0x49, 0xc4, 0xb6, 0xe0, 0x87, 0x20, 0x66, 0x3b, 0x2d, 0x57, 0xb1, 0xe3, 0xde,
	0x34, 0x06, 0x07, 0x9f, 0xf8, 0x07, 0x02, 0xf0, 0x32, 0x30, 0x84, 0x17, 0x3c, 0x02, 0x89, 0xa6,
	0xeb, 0xb4, 0xec, 0xb6, 0x2a, 0xbd, 0xff, 0xaf, 0xe2, 0x7f, 0x47, 0x78, 0x18, 0xca, 0x13, 0xb6,
	0x00, 0xf4, 0x77, 0xa0, 0xc2, 0x93, 0xa4, 0xf5, 0x7e, 0x10, 0x6f, 0x11, 0x4d, 0xfb, 0xea, 0x54,
	0x81, 0xfb, 0x9b, 0x5a, 0x8a, 0xe0, 0x55, 0x90, 0x97, 0xd8, 0x66, 0xb0, 0x0c, 0x72, 0x52, 0xfa,
	0x48, 0x15, 0xc3, 0x75, 0x50, 0xe4, 0x2f, 0x1d, 0x77, 0x88, 0xc9, 0xc4, 0x50, 0x96, 0x43, 0xc1,
	0x93, 0x2b, 0xd3, 0xea, 0xd3, 0x28, 0xd8, 0x98, 0xcb, 0xd8, 0xf0, 0x1a, 0x28, 0x30, 0x44, 0xda,
	0x98, 0x99, 0xcd, 0xee, 0x80, 0x32, 0x4c, 0xe4, 0x4c, 0x49, 0x1b, 0x79, 0x29, 0xbe, 0xa3, 0xa4,
	0xa1, 0x6e, 0x8a, 0xbc, 0xb1, 0x9b, 0xa2, 0x4b, 0xba, 0x29, 0xe6, 0xef, 0xa6, 0x70, 0x55, 0xc7,
	0x57, 0xa9, 0xea, 0x44, 0xb8, 0xaa, 0x7d, 0x9d, 0x93, 0x0c, 0x76, 0xce, 0x2d, 0x90, 0x54, 0xd4,
	0x23, 0x4a, 0x3d, 0x53, 0xdf, 0x09, 0x5e, 0x98, 0x52, 0xfa, 0xd8, 0xcb, 0xf0, 0x1c, 0xe0, 0x31,
	0x28, 0x38, 0xf8, 0xc2, 0xe4, 0x5b, 0xf7, 0x30, 0xc0, 0x8a, 0x18, 0x39, 0x07, 0x5f, 0x18, 0x03,
	0x47, 0x2d, 0x4f, 0x62, 0xa9, 0x54, 0x31, 0x7d, 0x12, 0x4b, 0x65, 0x8a, 0xd9, 0x93, 0x58, 0x2a,
	0x5b, 0xcc, 0x9d, 0xc4, 0x52, 0xb9, 0x62, 0xfe, 0x24, 0x96, 0xca, 0x17, 0x0b, 0xd5, 0x6f, 0x23,
	0x60, 0x7b, 0x29, 0x85, 0xff, 0x5b, 0x6e, 0xab, 0xfa, 0x83, 0x06, 0xb6, 0x97, 0xbe, 0xf0, 0x78,
	0x8f, 0xa8, 0x67, 0xb6, 0xca, 0x84, 0x1a, 0xef, 0x39, 0x29, 0x55, 0x89, 0x08, 0xbc, 0x19, 0x22,
	0xc1, 0x37, 0xc3, 0x0c, 0x55, 0x47, 0xdf, 0x82, 0xaa, 0x7f, 0x8d, 0x83, 0xf2, 0xe2, 0xc7, 0xdf,
	0xbb, 0x24, 0x20, 0x5f, 0xea, 0x62, 0xc1, 0x42, 0x9f, 0x1d, 0xec, 0xf1, 0xd0, 0x60, 0x87, 0x9f,
	0x82, 0xfc, 0xd4, 0x44, 0x1c, 0x3e, 0xb1, 0xe2, 0xe1, 0x73, 0x13, 0x3f, 0xae, 0x81, 0xdb, 0x80,
	0x67, 0x83, 0x30, 0x19, 0x49, 0xde, 0x61, 0x5a, 0x49, 0x04, 0x4b, 0x66, 0x3d, 0xb5, 0x88, 0x92,
	0x5a, 0x31, 0x4a, 0x46, 0x79, 0x89, 0x18, 0x0f, 0xc0, 0xba, 0x78, 0x94, 0x74, 0x30, 0x22, 0xec,
	0x0c, 0x23, 0x26, 0xb1, 0xd2, 0x2b, 0x62, 0x5d, 0xe2, 0xce, 0xc7, 0x9e, 0xaf, 0x40, 0xbc, 0x05,
	0x92, 0x16, 0x66, 0xc8, 0xee, 0xd2, 0xf9, 0x6d, 0x2c, 0xbf, 0x6f, 0x79, 0x17, 0x3f, 0x40, 0xa3,
	0xae, 0x8b, 0x2c, 0x6a, 0x78, 0x0e, 0x3c, 0xef, 0x88, 0x71, 0x6b, 0x56, 0xca, 0xc8, 0x72, 0x52,
	0x4b, 0x7e, 0x58, 0xb1, 0x4f, 0xf5, 0xf1, 0x59, 0xca, 0xce, 0x83, 0x56, 0x4a, 0x8e, 0x7d, 0x57,
	0xfe, 0x34, 0x32, 0xdc, 0x4b, 0x2d, 0xe0, 0x0d, 0xf0, 0x1f, 0x01, 0xc2, 0x0b, 0x00, 0x13, 0xd3,
	0xb6, 0xb0, 0xc3, 0x6c, 0x36, 0x2a, 0xe5, 0xc4, 0xdd, 0x43, 0xae, 0x7b, 0x2c, 0x54, 0x0d, 0xa5,
	0x81, 0x8f, 0x41, 0x41, 0xdd, 0xfc, 0x64, 0x36, 0xe5, 0x45, 0x64, 0x7d, 0x2e, 0x09, 0xfb, 0x46,
	0x94, 0xe2, 0x06, 0x6f, 0x52, 0xe5, 0x87, 0x81, 0x75, 0xf5, 0xcf, 0x08, 0xd8, 0x5c, 0xf0, 0x8e,
	0xf7, 0xbf, 0x5c, 0xb4, 0xc0, 0xcb, 0xe5, 0x1d, 0x8e, 0x9d, 0x16, 0xd8, 0x98, 0x39, 0xa8, 0x69,
	0x33, 0xdc, 0xe3, 0x1f, 0x8d, 0xfc, 0x09, 0x5c, 0xff, 0x7b, 0xc7, 0x6d, 0x30, 0xdc, 0x33, 0xd6,
	0x87, 0x21, 0x19, 0x85, 0x1f, 0x80, 0x84, 0x98, 0x59, 0xde, 0x17, 0xe0, 0xc2, 0xe2, 0xf8, 0x18,
	0x31, 0x74, 0xd4, 0x75, 0xcf, 0x0c, 0x65, 0x0f, 0xef, 0x82, 0xbc, 0x47, 0x13, 0x0a, 0x21, 0xb9,
	0x22, 0x42, 0x56, 0xb2, 0x84, 0x98, 0x8b, 0xf4, 0xc8, 0x7e, 0xfe, 0xb2, 0xb2, 0xf6, 0xe2, 0x65,
	0x65, 0xed, 0xf5, 0xcb, 0x8a, 0xf6, 0xf5, 0xb8, 0xa2, 0xfd, 0x34, 0xae, 0x68, 0xcf, 0xc6, 0x15,
	0xed, 0xf9, 0xb8, 0xa2, 0xfd, 0x3e, 0xae, 0x68, 0x7f, 0x8c, 0x2b, 0x6b, 0xaf, 0xc7, 0x15, 0xed,
	0xc9, 0xab, 0xca, 0xda, 0xf3, 0x57, 0x95, 0xb5, 0x17, 0xaf, 0x2a, 0x6b, 0x9f, 0x1f, 0xb4, 0xdd,
	0x69, 0x1c, 0xdb, 0x5d, 0xfc, 0x57, 0xd6, 0x6d, 0x82, 0xfb, 0x6a, 0x75, 0x96, 0x10, 0x7d, 0x73,
	0xf0, 0x57, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xb4, 0x0f, 0x2d, 0x02, 0x13, 0x00, 0x00,
}

func (this *ReplicationTask) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationTask)
	if !ok {
		that2, ok := that.(ReplicationTask)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TaskType != that1.TaskType {
		return false
	}
	if this.SourceTaskId != that1.SourceTaskId {
		return false
	}
	if that1.Attributes == nil {
		if this.Attributes != nil {
			return false
		}
	} else if this.Attributes == nil {
		return false
	} else if !this.Attributes.Equal(that1.Attributes) {
		return false
	}
	return true
}
func (this *ReplicationTask_NamespaceTaskAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationTask_NamespaceTaskAttributes)
	if !ok {
		that2, ok := that.(ReplicationTask_NamespaceTaskAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.NamespaceTaskAttributes.Equal(that1.NamespaceTaskAttributes) {
		return false
	}
	return true
}
func (this *ReplicationTask_HistoryTaskAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationTask_HistoryTaskAttributes)
	if !ok {
		that2, ok := that.(ReplicationTask_HistoryTaskAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.HistoryTaskAttributes.Equal(that1.HistoryTaskAttributes) {
		return false
	}
	return true
}
func (this *ReplicationTask_SyncShardStatusTaskAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationTask_SyncShardStatusTaskAttributes)
	if !ok {
		that2, ok := that.(ReplicationTask_SyncShardStatusTaskAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SyncShardStatusTaskAttributes.Equal(that1.SyncShardStatusTaskAttributes) {
		return false
	}
	return true
}
func (this *ReplicationTask_SyncActivityTaskAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationTask_SyncActivityTaskAttributes)
	if !ok {
		that2, ok := that.(ReplicationTask_SyncActivityTaskAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SyncActivityTaskAttributes.Equal(that1.SyncActivityTaskAttributes) {
		return false
	}
	return true
}
func (this *ReplicationTask_HistoryMetadataTaskAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationTask_HistoryMetadataTaskAttributes)
	if !ok {
		that2, ok := that.(ReplicationTask_HistoryMetadataTaskAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.HistoryMetadataTaskAttributes.Equal(that1.HistoryMetadataTaskAttributes) {
		return false
	}
	return true
}
func (this *ReplicationTask_HistoryTaskV2Attributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationTask_HistoryTaskV2Attributes)
	if !ok {
		that2, ok := that.(ReplicationTask_HistoryTaskV2Attributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.HistoryTaskV2Attributes.Equal(that1.HistoryTaskV2Attributes) {
		return false
	}
	return true
}
func (this *ReplicationToken) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationToken)
	if !ok {
		that2, ok := that.(ReplicationToken)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.LastRetrievedMessageId != that1.LastRetrievedMessageId {
		return false
	}
	if this.LastProcessedMessageId != that1.LastProcessedMessageId {
		return false
	}
	return true
}
func (this *SyncShardStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SyncShardStatus)
	if !ok {
		that2, ok := that.(SyncShardStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.StatusTime == nil {
		if this.StatusTime != nil {
			return false
		}
	} else if !this.StatusTime.Equal(*that1.StatusTime) {
		return false
	}
	return true
}
func (this *ReplicationMessages) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationMessages)
	if !ok {
		that2, ok := that.(ReplicationMessages)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ReplicationTasks) != len(that1.ReplicationTasks) {
		return false
	}
	for i := range this.ReplicationTasks {
		if !this.ReplicationTasks[i].Equal(that1.ReplicationTasks[i]) {
			return false
		}
	}
	if this.LastRetrievedMessageId != that1.LastRetrievedMessageId {
		return false
	}
	if this.HasMore != that1.HasMore {
		return false
	}
	if !this.SyncShardStatus.Equal(that1.SyncShardStatus) {
		return false
	}
	return true
}
func (this *ReplicationTaskInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationTaskInfo)
	if !ok {
		that2, ok := that.(ReplicationTaskInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.TaskType != that1.TaskType {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.FirstEventId != that1.FirstEventId {
		return false
	}
	if this.NextEventId != that1.NextEventId {
		return false
	}
	if this.ScheduledId != that1.ScheduledId {
		return false
	}
	return true
}
func (this *NamespaceTaskAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NamespaceTaskAttributes)
	if !ok {
		that2, ok := that.(NamespaceTaskAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceOperation != that1.NamespaceOperation {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if !this.Info.Equal(that1.Info) {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	if !this.ReplicationConfig.Equal(that1.ReplicationConfig) {
		return false
	}
	if this.ConfigVersion != that1.ConfigVersion {
		return false
	}
	if this.FailoverVersion != that1.FailoverVersion {
		return false
	}
	return true
}
func (this *HistoryTaskAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryTaskAttributes)
	if !ok {
		that2, ok := that.(HistoryTaskAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.TargetClusters) != len(that1.TargetClusters) {
		return false
	}
	for i := range this.TargetClusters {
		if this.TargetClusters[i] != that1.TargetClusters[i] {
			return false
		}
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.FirstEventId != that1.FirstEventId {
		return false
	}
	if this.NextEventId != that1.NextEventId {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if !this.History.Equal(that1.History) {
		return false
	}
	if !this.NewRunHistory.Equal(that1.NewRunHistory) {
		return false
	}
	return true
}
func (this *HistoryMetadataTaskAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryMetadataTaskAttributes)
	if !ok {
		that2, ok := that.(HistoryMetadataTaskAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.TargetClusters) != len(that1.TargetClusters) {
		return false
	}
	for i := range this.TargetClusters {
		if this.TargetClusters[i] != that1.TargetClusters[i] {
			return false
		}
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.FirstEventId != that1.FirstEventId {
		return false
	}
	if this.NextEventId != that1.NextEventId {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	return true
}
func (this *SyncShardStatusTaskAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SyncShardStatusTaskAttributes)
	if !ok {
		that2, ok := that.(SyncShardStatusTaskAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if that1.StatusTime == nil {
		if this.StatusTime != nil {
			return false
		}
	} else if !this.StatusTime.Equal(*that1.StatusTime) {
		return false
	}
	return true
}
func (this *SyncActivityTaskAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SyncActivityTaskAttributes)
	if !ok {
		that2, ok := that.(SyncActivityTaskAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.ScheduledId != that1.ScheduledId {
		return false
	}
	if that1.ScheduledTime == nil {
		if this.ScheduledTime != nil {
			return false
		}
	} else if !this.ScheduledTime.Equal(*that1.ScheduledTime) {
		return false
	}
	if this.StartedId != that1.StartedId {
		return false
	}
	if that1.StartedTime == nil {
		if this.StartedTime != nil {
			return false
		}
	} else if !this.StartedTime.Equal(*that1.StartedTime) {
		return false
	}
	if that1.LastHeartbeatTime == nil {
		if this.LastHeartbeatTime != nil {
			return false
		}
	} else if !this.LastHeartbeatTime.Equal(*that1.LastHeartbeatTime) {
		return false
	}
	if !this.Details.Equal(that1.Details) {
		return false
	}
	if this.Attempt != that1.Attempt {
		return false
	}
	if !this.LastFailure.Equal(that1.LastFailure) {
		return false
	}
	if this.LastWorkerIdentity != that1.LastWorkerIdentity {
		return false
	}
	if !this.VersionHistory.Equal(that1.VersionHistory) {
		return false
	}
	return true
}
func (this *HistoryTaskV2Attributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryTaskV2Attributes)
	if !ok {
		that2, ok := that.(HistoryTaskV2Attributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if len(this.VersionHistoryItems) != len(that1.VersionHistoryItems) {
		return false
	}
	for i := range this.VersionHistoryItems {
		if !this.VersionHistoryItems[i].Equal(that1.VersionHistoryItems[i]) {
			return false
		}
	}
	if !this.Events.Equal(that1.Events) {
		return false
	}
	if !this.NewRunEvents.Equal(that1.NewRunEvents) {
		return false
	}
	return true
}
func (this *ReplicationTask) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&repication.ReplicationTask{")
	s = append(s, "TaskType: "+fmt.Sprintf("%#v", this.TaskType)+",\n")
	s = append(s, "SourceTaskId: "+fmt.Sprintf("%#v", this.SourceTaskId)+",\n")
	if this.Attributes != nil {
		s = append(s, "Attributes: "+fmt.Sprintf("%#v", this.Attributes)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReplicationTask_NamespaceTaskAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&repication.ReplicationTask_NamespaceTaskAttributes{` +
		`NamespaceTaskAttributes:` + fmt.Sprintf("%#v", this.NamespaceTaskAttributes) + `}`}, ", ")
	return s
}
func (this *ReplicationTask_HistoryTaskAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&repication.ReplicationTask_HistoryTaskAttributes{` +
		`HistoryTaskAttributes:` + fmt.Sprintf("%#v", this.HistoryTaskAttributes) + `}`}, ", ")
	return s
}
func (this *ReplicationTask_SyncShardStatusTaskAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&repication.ReplicationTask_SyncShardStatusTaskAttributes{` +
		`SyncShardStatusTaskAttributes:` + fmt.Sprintf("%#v", this.SyncShardStatusTaskAttributes) + `}`}, ", ")
	return s
}
func (this *ReplicationTask_SyncActivityTaskAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&repication.ReplicationTask_SyncActivityTaskAttributes{` +
		`SyncActivityTaskAttributes:` + fmt.Sprintf("%#v", this.SyncActivityTaskAttributes) + `}`}, ", ")
	return s
}
func (this *ReplicationTask_HistoryMetadataTaskAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&repication.ReplicationTask_HistoryMetadataTaskAttributes{` +
		`HistoryMetadataTaskAttributes:` + fmt.Sprintf("%#v", this.HistoryMetadataTaskAttributes) + `}`}, ", ")
	return s
}
func (this *ReplicationTask_HistoryTaskV2Attributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&repication.ReplicationTask_HistoryTaskV2Attributes{` +
		`HistoryTaskV2Attributes:` + fmt.Sprintf("%#v", this.HistoryTaskV2Attributes) + `}`}, ", ")
	return s
}
func (this *ReplicationToken) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&repication.ReplicationToken{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "LastRetrievedMessageId: "+fmt.Sprintf("%#v", this.LastRetrievedMessageId)+",\n")
	s = append(s, "LastProcessedMessageId: "+fmt.Sprintf("%#v", this.LastProcessedMessageId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SyncShardStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&repication.SyncShardStatus{")
	s = append(s, "StatusTime: "+fmt.Sprintf("%#v", this.StatusTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReplicationMessages) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&repication.ReplicationMessages{")
	if this.ReplicationTasks != nil {
		s = append(s, "ReplicationTasks: "+fmt.Sprintf("%#v", this.ReplicationTasks)+",\n")
	}
	s = append(s, "LastRetrievedMessageId: "+fmt.Sprintf("%#v", this.LastRetrievedMessageId)+",\n")
	s = append(s, "HasMore: "+fmt.Sprintf("%#v", this.HasMore)+",\n")
	if this.SyncShardStatus != nil {
		s = append(s, "SyncShardStatus: "+fmt.Sprintf("%#v", this.SyncShardStatus)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReplicationTaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&repication.ReplicationTaskInfo{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "TaskType: "+fmt.Sprintf("%#v", this.TaskType)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "FirstEventId: "+fmt.Sprintf("%#v", this.FirstEventId)+",\n")
	s = append(s, "NextEventId: "+fmt.Sprintf("%#v", this.NextEventId)+",\n")
	s = append(s, "ScheduledId: "+fmt.Sprintf("%#v", this.ScheduledId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NamespaceTaskAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&repication.NamespaceTaskAttributes{")
	s = append(s, "NamespaceOperation: "+fmt.Sprintf("%#v", this.NamespaceOperation)+",\n")
	s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	if this.Info != nil {
		s = append(s, "Info: "+fmt.Sprintf("%#v", this.Info)+",\n")
	}
	if this.Config != nil {
		s = append(s, "Config: "+fmt.Sprintf("%#v", this.Config)+",\n")
	}
	if this.ReplicationConfig != nil {
		s = append(s, "ReplicationConfig: "+fmt.Sprintf("%#v", this.ReplicationConfig)+",\n")
	}
	s = append(s, "ConfigVersion: "+fmt.Sprintf("%#v", this.ConfigVersion)+",\n")
	s = append(s, "FailoverVersion: "+fmt.Sprintf("%#v", this.FailoverVersion)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HistoryTaskAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&repication.HistoryTaskAttributes{")
	s = append(s, "TargetClusters: "+fmt.Sprintf("%#v", this.TargetClusters)+",\n")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "FirstEventId: "+fmt.Sprintf("%#v", this.FirstEventId)+",\n")
	s = append(s, "NextEventId: "+fmt.Sprintf("%#v", this.NextEventId)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	if this.History != nil {
		s = append(s, "History: "+fmt.Sprintf("%#v", this.History)+",\n")
	}
	if this.NewRunHistory != nil {
		s = append(s, "NewRunHistory: "+fmt.Sprintf("%#v", this.NewRunHistory)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HistoryMetadataTaskAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&repication.HistoryMetadataTaskAttributes{")
	s = append(s, "TargetClusters: "+fmt.Sprintf("%#v", this.TargetClusters)+",\n")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "FirstEventId: "+fmt.Sprintf("%#v", this.FirstEventId)+",\n")
	s = append(s, "NextEventId: "+fmt.Sprintf("%#v", this.NextEventId)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SyncShardStatusTaskAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&repication.SyncShardStatusTaskAttributes{")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "StatusTime: "+fmt.Sprintf("%#v", this.StatusTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SyncActivityTaskAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 18)
	s = append(s, "&repication.SyncActivityTaskAttributes{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "ScheduledId: "+fmt.Sprintf("%#v", this.ScheduledId)+",\n")
	s = append(s, "ScheduledTime: "+fmt.Sprintf("%#v", this.ScheduledTime)+",\n")
	s = append(s, "StartedId: "+fmt.Sprintf("%#v", this.StartedId)+",\n")
	s = append(s, "StartedTime: "+fmt.Sprintf("%#v", this.StartedTime)+",\n")
	s = append(s, "LastHeartbeatTime: "+fmt.Sprintf("%#v", this.LastHeartbeatTime)+",\n")
	if this.Details != nil {
		s = append(s, "Details: "+fmt.Sprintf("%#v", this.Details)+",\n")
	}
	s = append(s, "Attempt: "+fmt.Sprintf("%#v", this.Attempt)+",\n")
	if this.LastFailure != nil {
		s = append(s, "LastFailure: "+fmt.Sprintf("%#v", this.LastFailure)+",\n")
	}
	s = append(s, "LastWorkerIdentity: "+fmt.Sprintf("%#v", this.LastWorkerIdentity)+",\n")
	if this.VersionHistory != nil {
		s = append(s, "VersionHistory: "+fmt.Sprintf("%#v", this.VersionHistory)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HistoryTaskV2Attributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&repication.HistoryTaskV2Attributes{")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	if this.VersionHistoryItems != nil {
		s = append(s, "VersionHistoryItems: "+fmt.Sprintf("%#v", this.VersionHistoryItems)+",\n")
	}
	if this.Events != nil {
		s = append(s, "Events: "+fmt.Sprintf("%#v", this.Events)+",\n")
	}
	if this.NewRunEvents != nil {
		s = append(s, "NewRunEvents: "+fmt.Sprintf("%#v", this.NewRunEvents)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringMessage(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *ReplicationTask) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationTask) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationTask) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Attributes != nil {
		{
			size := m.Attributes.Size()
			i -= size
			if _, err := m.Attributes.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.SourceTaskId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.SourceTaskId))
		i--
		dAtA[i] = 0x10
	}
	if m.TaskType != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TaskType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ReplicationTask_NamespaceTaskAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationTask_NamespaceTaskAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.NamespaceTaskAttributes != nil {
		{
			size, err := m.NamespaceTaskAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *ReplicationTask_HistoryTaskAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationTask_HistoryTaskAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.HistoryTaskAttributes != nil {
		{
			size, err := m.HistoryTaskAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *ReplicationTask_SyncShardStatusTaskAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationTask_SyncShardStatusTaskAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.SyncShardStatusTaskAttributes != nil {
		{
			size, err := m.SyncShardStatusTaskAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *ReplicationTask_SyncActivityTaskAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationTask_SyncActivityTaskAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.SyncActivityTaskAttributes != nil {
		{
			size, err := m.SyncActivityTaskAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *ReplicationTask_HistoryMetadataTaskAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationTask_HistoryMetadataTaskAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.HistoryMetadataTaskAttributes != nil {
		{
			size, err := m.HistoryMetadataTaskAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *ReplicationTask_HistoryTaskV2Attributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationTask_HistoryTaskV2Attributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.HistoryTaskV2Attributes != nil {
		{
			size, err := m.HistoryTaskV2Attributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *ReplicationToken) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationToken) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationToken) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.LastProcessedMessageId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.LastProcessedMessageId))
		i--
		dAtA[i] = 0x18
	}
	if m.LastRetrievedMessageId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.LastRetrievedMessageId))
		i--
		dAtA[i] = 0x10
	}
	if m.ShardId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SyncShardStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SyncShardStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SyncShardStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.StatusTime != nil {
		n7, err7 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StatusTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StatusTime):])
		if err7 != nil {
			return 0, err7
		}
		i -= n7
		i = encodeVarintMessage(dAtA, i, uint64(n7))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReplicationMessages) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationMessages) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationMessages) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SyncShardStatus != nil {
		{
			size, err := m.SyncShardStatus.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.HasMore {
		i--
		if m.HasMore {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.LastRetrievedMessageId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.LastRetrievedMessageId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.ReplicationTasks) > 0 {
		for iNdEx := len(m.ReplicationTasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ReplicationTasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMessage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ReplicationTaskInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationTaskInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationTaskInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ScheduledId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ScheduledId))
		i--
		dAtA[i] = 0x48
	}
	if m.NextEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.NextEventId))
		i--
		dAtA[i] = 0x40
	}
	if m.FirstEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.FirstEventId))
		i--
		dAtA[i] = 0x38
	}
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x30
	}
	if m.TaskId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x28
	}
	if m.TaskType != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TaskType))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NamespaceTaskAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceTaskAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceTaskAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.FailoverVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.FailoverVersion))
		i--
		dAtA[i] = 0x38
	}
	if m.ConfigVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ConfigVersion))
		i--
		dAtA[i] = 0x30
	}
	if m.ReplicationConfig != nil {
		{
			size, err := m.ReplicationConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0x12
	}
	if m.NamespaceOperation != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.NamespaceOperation))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HistoryTaskAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryTaskAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistoryTaskAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.NewRunHistory != nil {
		{
			size, err := m.NewRunHistory.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.History != nil {
		{
			size, err := m.History.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x38
	}
	if m.NextEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.NextEventId))
		i--
		dAtA[i] = 0x30
	}
	if m.FirstEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.FirstEventId))
		i--
		dAtA[i] = 0x28
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.TargetClusters) > 0 {
		for iNdEx := len(m.TargetClusters) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.TargetClusters[iNdEx])
			copy(dAtA[i:], m.TargetClusters[iNdEx])
			i = encodeVarintMessage(dAtA, i, uint64(len(m.TargetClusters[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *HistoryMetadataTaskAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryMetadataTaskAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistoryMetadataTaskAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x38
	}
	if m.NextEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.NextEventId))
		i--
		dAtA[i] = 0x30
	}
	if m.FirstEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.FirstEventId))
		i--
		dAtA[i] = 0x28
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.TargetClusters) > 0 {
		for iNdEx := len(m.TargetClusters) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.TargetClusters[iNdEx])
			copy(dAtA[i:], m.TargetClusters[iNdEx])
			i = encodeVarintMessage(dAtA, i, uint64(len(m.TargetClusters[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SyncShardStatusTaskAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SyncShardStatusTaskAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SyncShardStatusTaskAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.StatusTime != nil {
		n14, err14 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StatusTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StatusTime):])
		if err14 != nil {
			return 0, err14
		}
		i -= n14
		i = encodeVarintMessage(dAtA, i, uint64(n14))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SyncActivityTaskAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SyncActivityTaskAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SyncActivityTaskAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VersionHistory != nil {
		{
			size, err := m.VersionHistory.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	if len(m.LastWorkerIdentity) > 0 {
		i -= len(m.LastWorkerIdentity)
		copy(dAtA[i:], m.LastWorkerIdentity)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.LastWorkerIdentity)))
		i--
		dAtA[i] = 0x6a
	}
	if m.LastFailure != nil {
		{
			size, err := m.LastFailure.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.Attempt != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x58
	}
	if m.Details != nil {
		{
			size, err := m.Details.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.LastHeartbeatTime != nil {
		n18, err18 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.LastHeartbeatTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbeatTime):])
		if err18 != nil {
			return 0, err18
		}
		i -= n18
		i = encodeVarintMessage(dAtA, i, uint64(n18))
		i--
		dAtA[i] = 0x4a
	}
	if m.StartedTime != nil {
		n19, err19 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartedTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime):])
		if err19 != nil {
			return 0, err19
		}
		i -= n19
		i = encodeVarintMessage(dAtA, i, uint64(n19))
		i--
		dAtA[i] = 0x42
	}
	if m.StartedId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.StartedId))
		i--
		dAtA[i] = 0x38
	}
	if m.ScheduledTime != nil {
		n20, err20 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime):])
		if err20 != nil {
			return 0, err20
		}
		i -= n20
		i = encodeVarintMessage(dAtA, i, uint64(n20))
		i--
		dAtA[i] = 0x32
	}
	if m.ScheduledId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ScheduledId))
		i--
		dAtA[i] = 0x28
	}
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HistoryTaskV2Attributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryTaskV2Attributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistoryTaskV2Attributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.NewRunEvents != nil {
		{
			size, err := m.NewRunEvents.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.Events != nil {
		{
			size, err := m.Events.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.VersionHistoryItems) > 0 {
		for iNdEx := len(m.VersionHistoryItems) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.VersionHistoryItems[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMessage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0x12
	}
	if m.TaskId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintMessage(dAtA []byte, offset int, v uint64) int {
	offset -= sovMessage(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ReplicationTask) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TaskType != 0 {
		n += 1 + sovMessage(uint64(m.TaskType))
	}
	if m.SourceTaskId != 0 {
		n += 1 + sovMessage(uint64(m.SourceTaskId))
	}
	if m.Attributes != nil {
		n += m.Attributes.Size()
	}
	return n
}

func (m *ReplicationTask_NamespaceTaskAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NamespaceTaskAttributes != nil {
		l = m.NamespaceTaskAttributes.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}
func (m *ReplicationTask_HistoryTaskAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HistoryTaskAttributes != nil {
		l = m.HistoryTaskAttributes.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}
func (m *ReplicationTask_SyncShardStatusTaskAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SyncShardStatusTaskAttributes != nil {
		l = m.SyncShardStatusTaskAttributes.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}
func (m *ReplicationTask_SyncActivityTaskAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SyncActivityTaskAttributes != nil {
		l = m.SyncActivityTaskAttributes.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}
func (m *ReplicationTask_HistoryMetadataTaskAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HistoryMetadataTaskAttributes != nil {
		l = m.HistoryMetadataTaskAttributes.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}
func (m *ReplicationTask_HistoryTaskV2Attributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HistoryTaskV2Attributes != nil {
		l = m.HistoryTaskV2Attributes.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}
func (m *ReplicationToken) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovMessage(uint64(m.ShardId))
	}
	if m.LastRetrievedMessageId != 0 {
		n += 1 + sovMessage(uint64(m.LastRetrievedMessageId))
	}
	if m.LastProcessedMessageId != 0 {
		n += 1 + sovMessage(uint64(m.LastProcessedMessageId))
	}
	return n
}

func (m *SyncShardStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StatusTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StatusTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *ReplicationMessages) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ReplicationTasks) > 0 {
		for _, e := range m.ReplicationTasks {
			l = e.Size()
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	if m.LastRetrievedMessageId != 0 {
		n += 1 + sovMessage(uint64(m.LastRetrievedMessageId))
	}
	if m.HasMore {
		n += 2
	}
	if m.SyncShardStatus != nil {
		l = m.SyncShardStatus.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *ReplicationTaskInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.TaskType != 0 {
		n += 1 + sovMessage(uint64(m.TaskType))
	}
	if m.TaskId != 0 {
		n += 1 + sovMessage(uint64(m.TaskId))
	}
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	if m.FirstEventId != 0 {
		n += 1 + sovMessage(uint64(m.FirstEventId))
	}
	if m.NextEventId != 0 {
		n += 1 + sovMessage(uint64(m.NextEventId))
	}
	if m.ScheduledId != 0 {
		n += 1 + sovMessage(uint64(m.ScheduledId))
	}
	return n
}

func (m *NamespaceTaskAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NamespaceOperation != 0 {
		n += 1 + sovMessage(uint64(m.NamespaceOperation))
	}
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ReplicationConfig != nil {
		l = m.ReplicationConfig.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ConfigVersion != 0 {
		n += 1 + sovMessage(uint64(m.ConfigVersion))
	}
	if m.FailoverVersion != 0 {
		n += 1 + sovMessage(uint64(m.FailoverVersion))
	}
	return n
}

func (m *HistoryTaskAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.TargetClusters) > 0 {
		for _, s := range m.TargetClusters {
			l = len(s)
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.FirstEventId != 0 {
		n += 1 + sovMessage(uint64(m.FirstEventId))
	}
	if m.NextEventId != 0 {
		n += 1 + sovMessage(uint64(m.NextEventId))
	}
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	if m.History != nil {
		l = m.History.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.NewRunHistory != nil {
		l = m.NewRunHistory.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *HistoryMetadataTaskAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.TargetClusters) > 0 {
		for _, s := range m.TargetClusters {
			l = len(s)
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.FirstEventId != 0 {
		n += 1 + sovMessage(uint64(m.FirstEventId))
	}
	if m.NextEventId != 0 {
		n += 1 + sovMessage(uint64(m.NextEventId))
	}
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	return n
}

func (m *SyncShardStatusTaskAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ShardId != 0 {
		n += 1 + sovMessage(uint64(m.ShardId))
	}
	if m.StatusTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StatusTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *SyncActivityTaskAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	if m.ScheduledId != 0 {
		n += 1 + sovMessage(uint64(m.ScheduledId))
	}
	if m.ScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.StartedId != 0 {
		n += 1 + sovMessage(uint64(m.StartedId))
	}
	if m.StartedTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.LastHeartbeatTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbeatTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Details != nil {
		l = m.Details.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Attempt != 0 {
		n += 1 + sovMessage(uint64(m.Attempt))
	}
	if m.LastFailure != nil {
		l = m.LastFailure.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.LastWorkerIdentity)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.VersionHistory != nil {
		l = m.VersionHistory.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *HistoryTaskV2Attributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TaskId != 0 {
		n += 1 + sovMessage(uint64(m.TaskId))
	}
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if len(m.VersionHistoryItems) > 0 {
		for _, e := range m.VersionHistoryItems {
			l = e.Size()
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	if m.Events != nil {
		l = m.Events.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.NewRunEvents != nil {
		l = m.NewRunEvents.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func sovMessage(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMessage(x uint64) (n int) {
	return sovMessage(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ReplicationTask) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicationTask{`,
		`TaskType:` + fmt.Sprintf("%v", this.TaskType) + `,`,
		`SourceTaskId:` + fmt.Sprintf("%v", this.SourceTaskId) + `,`,
		`Attributes:` + fmt.Sprintf("%v", this.Attributes) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicationTask_NamespaceTaskAttributes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicationTask_NamespaceTaskAttributes{`,
		`NamespaceTaskAttributes:` + strings.Replace(fmt.Sprintf("%v", this.NamespaceTaskAttributes), "NamespaceTaskAttributes", "NamespaceTaskAttributes", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicationTask_HistoryTaskAttributes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicationTask_HistoryTaskAttributes{`,
		`HistoryTaskAttributes:` + strings.Replace(fmt.Sprintf("%v", this.HistoryTaskAttributes), "HistoryTaskAttributes", "HistoryTaskAttributes", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicationTask_SyncShardStatusTaskAttributes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicationTask_SyncShardStatusTaskAttributes{`,
		`SyncShardStatusTaskAttributes:` + strings.Replace(fmt.Sprintf("%v", this.SyncShardStatusTaskAttributes), "SyncShardStatusTaskAttributes", "SyncShardStatusTaskAttributes", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicationTask_SyncActivityTaskAttributes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicationTask_SyncActivityTaskAttributes{`,
		`SyncActivityTaskAttributes:` + strings.Replace(fmt.Sprintf("%v", this.SyncActivityTaskAttributes), "SyncActivityTaskAttributes", "SyncActivityTaskAttributes", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicationTask_HistoryMetadataTaskAttributes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicationTask_HistoryMetadataTaskAttributes{`,
		`HistoryMetadataTaskAttributes:` + strings.Replace(fmt.Sprintf("%v", this.HistoryMetadataTaskAttributes), "HistoryMetadataTaskAttributes", "HistoryMetadataTaskAttributes", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicationTask_HistoryTaskV2Attributes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicationTask_HistoryTaskV2Attributes{`,
		`HistoryTaskV2Attributes:` + strings.Replace(fmt.Sprintf("%v", this.HistoryTaskV2Attributes), "HistoryTaskV2Attributes", "HistoryTaskV2Attributes", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicationToken) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicationToken{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`LastRetrievedMessageId:` + fmt.Sprintf("%v", this.LastRetrievedMessageId) + `,`,
		`LastProcessedMessageId:` + fmt.Sprintf("%v", this.LastProcessedMessageId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SyncShardStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SyncShardStatus{`,
		`StatusTime:` + strings.Replace(fmt.Sprintf("%v", this.StatusTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicationMessages) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForReplicationTasks := "[]*ReplicationTask{"
	for _, f := range this.ReplicationTasks {
		repeatedStringForReplicationTasks += strings.Replace(f.String(), "ReplicationTask", "ReplicationTask", 1) + ","
	}
	repeatedStringForReplicationTasks += "}"
	s := strings.Join([]string{`&ReplicationMessages{`,
		`ReplicationTasks:` + repeatedStringForReplicationTasks + `,`,
		`LastRetrievedMessageId:` + fmt.Sprintf("%v", this.LastRetrievedMessageId) + `,`,
		`HasMore:` + fmt.Sprintf("%v", this.HasMore) + `,`,
		`SyncShardStatus:` + strings.Replace(this.SyncShardStatus.String(), "SyncShardStatus", "SyncShardStatus", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicationTaskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicationTaskInfo{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`TaskType:` + fmt.Sprintf("%v", this.TaskType) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`FirstEventId:` + fmt.Sprintf("%v", this.FirstEventId) + `,`,
		`NextEventId:` + fmt.Sprintf("%v", this.NextEventId) + `,`,
		`ScheduledId:` + fmt.Sprintf("%v", this.ScheduledId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NamespaceTaskAttributes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NamespaceTaskAttributes{`,
		`NamespaceOperation:` + fmt.Sprintf("%v", this.NamespaceOperation) + `,`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`Info:` + strings.Replace(fmt.Sprintf("%v", this.Info), "NamespaceInfo", "v11.NamespaceInfo", 1) + `,`,
		`Config:` + strings.Replace(fmt.Sprintf("%v", this.Config), "NamespaceConfig", "v11.NamespaceConfig", 1) + `,`,
		`ReplicationConfig:` + strings.Replace(fmt.Sprintf("%v", this.ReplicationConfig), "NamespaceReplicationConfig", "v12.NamespaceReplicationConfig", 1) + `,`,
		`ConfigVersion:` + fmt.Sprintf("%v", this.ConfigVersion) + `,`,
		`FailoverVersion:` + fmt.Sprintf("%v", this.FailoverVersion) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HistoryTaskAttributes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HistoryTaskAttributes{`,
		`TargetClusters:` + fmt.Sprintf("%v", this.TargetClusters) + `,`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`FirstEventId:` + fmt.Sprintf("%v", this.FirstEventId) + `,`,
		`NextEventId:` + fmt.Sprintf("%v", this.NextEventId) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`History:` + strings.Replace(fmt.Sprintf("%v", this.History), "History", "v13.History", 1) + `,`,
		`NewRunHistory:` + strings.Replace(fmt.Sprintf("%v", this.NewRunHistory), "History", "v13.History", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HistoryMetadataTaskAttributes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HistoryMetadataTaskAttributes{`,
		`TargetClusters:` + fmt.Sprintf("%v", this.TargetClusters) + `,`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`FirstEventId:` + fmt.Sprintf("%v", this.FirstEventId) + `,`,
		`NextEventId:` + fmt.Sprintf("%v", this.NextEventId) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SyncShardStatusTaskAttributes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SyncShardStatusTaskAttributes{`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`StatusTime:` + strings.Replace(fmt.Sprintf("%v", this.StatusTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SyncActivityTaskAttributes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SyncActivityTaskAttributes{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`ScheduledId:` + fmt.Sprintf("%v", this.ScheduledId) + `,`,
		`ScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.ScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`StartedId:` + fmt.Sprintf("%v", this.StartedId) + `,`,
		`StartedTime:` + strings.Replace(fmt.Sprintf("%v", this.StartedTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`LastHeartbeatTime:` + strings.Replace(fmt.Sprintf("%v", this.LastHeartbeatTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Details:` + strings.Replace(fmt.Sprintf("%v", this.Details), "Payloads", "v14.Payloads", 1) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`LastFailure:` + strings.Replace(fmt.Sprintf("%v", this.LastFailure), "Failure", "v15.Failure", 1) + `,`,
		`LastWorkerIdentity:` + fmt.Sprintf("%v", this.LastWorkerIdentity) + `,`,
		`VersionHistory:` + strings.Replace(fmt.Sprintf("%v", this.VersionHistory), "VersionHistory", "v16.VersionHistory", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HistoryTaskV2Attributes) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForVersionHistoryItems := "[]*VersionHistoryItem{"
	for _, f := range this.VersionHistoryItems {
		repeatedStringForVersionHistoryItems += strings.Replace(fmt.Sprintf("%v", f), "VersionHistoryItem", "v16.VersionHistoryItem", 1) + ","
	}
	repeatedStringForVersionHistoryItems += "}"
	s := strings.Join([]string{`&HistoryTaskV2Attributes{`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`VersionHistoryItems:` + repeatedStringForVersionHistoryItems + `,`,
		`Events:` + strings.Replace(fmt.Sprintf("%v", this.Events), "DataBlob", "v14.DataBlob", 1) + `,`,
		`NewRunEvents:` + strings.Replace(fmt.Sprintf("%v", this.NewRunEvents), "DataBlob", "v14.DataBlob", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMessage(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ReplicationTask) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicationTask: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicationTask: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskType", wireType)
			}
			m.TaskType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskType |= v1.ReplicationTaskType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceTaskId", wireType)
			}
			m.SourceTaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SourceTaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceTaskAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NamespaceTaskAttributes{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Attributes = &ReplicationTask_NamespaceTaskAttributes{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryTaskAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HistoryTaskAttributes{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Attributes = &ReplicationTask_HistoryTaskAttributes{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SyncShardStatusTaskAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SyncShardStatusTaskAttributes{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Attributes = &ReplicationTask_SyncShardStatusTaskAttributes{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SyncActivityTaskAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SyncActivityTaskAttributes{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Attributes = &ReplicationTask_SyncActivityTaskAttributes{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryMetadataTaskAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HistoryMetadataTaskAttributes{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Attributes = &ReplicationTask_HistoryMetadataTaskAttributes{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryTaskV2Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HistoryTaskV2Attributes{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Attributes = &ReplicationTask_HistoryTaskV2Attributes{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicationToken) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicationToken: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicationToken: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastRetrievedMessageId", wireType)
			}
			m.LastRetrievedMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastRetrievedMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastProcessedMessageId", wireType)
			}
			m.LastProcessedMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastProcessedMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SyncShardStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SyncShardStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SyncShardStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatusTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StatusTime == nil {
				m.StatusTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StatusTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicationMessages) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicationMessages: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicationMessages: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplicationTasks = append(m.ReplicationTasks, &ReplicationTask{})
			if err := m.ReplicationTasks[len(m.ReplicationTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastRetrievedMessageId", wireType)
			}
			m.LastRetrievedMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastRetrievedMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasMore", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasMore = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SyncShardStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SyncShardStatus == nil {
				m.SyncShardStatus = &SyncShardStatus{}
			}
			if err := m.SyncShardStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicationTaskInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicationTaskInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicationTaskInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskType", wireType)
			}
			m.TaskType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskType |= v1.TaskType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstEventId", wireType)
			}
			m.FirstEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FirstEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextEventId", wireType)
			}
			m.NextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledId", wireType)
			}
			m.ScheduledId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduledId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NamespaceTaskAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NamespaceTaskAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NamespaceTaskAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceOperation", wireType)
			}
			m.NamespaceOperation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NamespaceOperation |= v1.NamespaceOperation(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Info == nil {
				m.Info = &v11.NamespaceInfo{}
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &v11.NamespaceConfig{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReplicationConfig == nil {
				m.ReplicationConfig = &v12.NamespaceReplicationConfig{}
			}
			if err := m.ReplicationConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigVersion", wireType)
			}
			m.ConfigVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConfigVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailoverVersion", wireType)
			}
			m.FailoverVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FailoverVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistoryTaskAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryTaskAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryTaskAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetClusters", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetClusters = append(m.TargetClusters, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstEventId", wireType)
			}
			m.FirstEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FirstEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextEventId", wireType)
			}
			m.NextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field History", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.History == nil {
				m.History = &v13.History{}
			}
			if err := m.History.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewRunHistory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NewRunHistory == nil {
				m.NewRunHistory = &v13.History{}
			}
			if err := m.NewRunHistory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistoryMetadataTaskAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryMetadataTaskAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryMetadataTaskAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetClusters", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetClusters = append(m.TargetClusters, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstEventId", wireType)
			}
			m.FirstEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FirstEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextEventId", wireType)
			}
			m.NextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SyncShardStatusTaskAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SyncShardStatusTaskAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SyncShardStatusTaskAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatusTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StatusTime == nil {
				m.StatusTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StatusTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SyncActivityTaskAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SyncActivityTaskAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SyncActivityTaskAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledId", wireType)
			}
			m.ScheduledId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduledId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduledTime == nil {
				m.ScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedId", wireType)
			}
			m.StartedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedTime == nil {
				m.StartedTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartedTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeatTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastHeartbeatTime == nil {
				m.LastHeartbeatTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.LastHeartbeatTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Details", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Details == nil {
				m.Details = &v14.Payloads{}
			}
			if err := m.Details.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastFailure", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastFailure == nil {
				m.LastFailure = &v15.Failure{}
			}
			if err := m.LastFailure.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastWorkerIdentity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastWorkerIdentity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionHistory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionHistory == nil {
				m.VersionHistory = &v16.VersionHistory{}
			}
			if err := m.VersionHistory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistoryTaskV2Attributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryTaskV2Attributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryTaskV2Attributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionHistoryItems", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VersionHistoryItems = append(m.VersionHistoryItems, &v16.VersionHistoryItem{})
			if err := m.VersionHistoryItems[len(m.VersionHistoryItems)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Events == nil {
				m.Events = &v14.DataBlob{}
			}
			if err := m.Events.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewRunEvents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NewRunEvents == nil {
				m.NewRunEvents = &v14.DataBlob{}
			}
			if err := m.NewRunEvents.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMessage(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMessage
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMessage
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMessage
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMessage        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMessage          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMessage = fmt.Errorf("proto: unexpected end of group")
)
