// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/adminservice/v1/service.proto

package adminservice

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

func init() {
	proto.RegisterFile("temporal/server/api/adminservice/v1/service.proto", fileDescriptor_cf5ca5e0c737570d)
}

var fileDescriptor_cf5ca5e0c737570d = []byte{
	// 661 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x96, 0x3f, 0x6f, 0xd3, 0x4e,
	0x18, 0xc7, 0x7d, 0xcb, 0x6f, 0x38, 0xfd, 0xf8, 0x23, 0x83, 0x2a, 0xd1, 0xe1, 0x40, 0xb0, 0x3b,
	0x6a, 0x91, 0x8a, 0x68, 0x41, 0x34, 0x4d, 0x4b, 0x2a, 0xd1, 0x20, 0x70, 0x10, 0x48, 0x2c, 0xe8,
	0xe2, 0x3c, 0x4d, 0xac, 0x3a, 0x39, 0x73, 0x77, 0x4e, 0xe9, 0x04, 0x23, 0x12, 0x12, 0x82, 0x15,
	0x09, 0x31, 0xb0, 0x30, 0xf0, 0x1a, 0x90, 0xd8, 0x18, 0x33, 0x76, 0x24, 0xce, 0xc2, 0xd8, 0x97,
	0x80, 0x82, 0x73, 0x8e, 0x93, 0x1e, 0xe5, 0xec, 0x74, 0xb3, 0xa5, 0xfb, 0x7c, 0x9f, 0xcf, 0x9d,
	0xf4, 0x3c, 0x77, 0x78, 0x49, 0x42, 0x27, 0x64, 0x9c, 0x06, 0x25, 0x01, 0xbc, 0x07, 0xbc, 0x44,
	0x43, 0xbf, 0x44, 0x9b, 0x1d, 0xbf, 0x3b, 0xfa, 0xf7, 0x3d, 0x28, 0xf5, 0x96, 0x4a, 0xe3, 0x4f,
	0x27, 0xe4, 0x4c, 0x32, 0xfb, 0x9a, 0x42, 0x9c, 0x04, 0x71, 0x68, 0xe8, 0x3b, 0x59, 0xc4, 0xe9,
	0x2d, 0x2d, 0xae, 0x9a, 0xe4, 0x72, 0x78, 0x1e, 0x81, 0x90, 0xcf, 0x38, 0x88, 0x90, 0x75, 0xc5,
	0xb8, 0xc0, 0xf2, 0xa7, 0x05, 0xfc, 0x7f, 0x79, 0xb4, 0xb4, 0x9e, 0x2c, 0xb5, 0x3f, 0x22, 0x7c,
	0x71, 0x13, 0x84, 0xc7, 0xfd, 0x06, 0xd4, 0x22, 0x49, 0x1b, 0x01, 0xd4, 0x25, 0x95, 0x60, 0xaf,
	0x3b, 0x06, 0x2e, 0x8e, 0x0e, 0x75, 0x93, 0xd2, 0x8b, 0xe5, 0x39, 0x12, 0x12, 0xe9, 0xab, 0x96,
	0xfd, 0x01, 0xe1, 0x0b, 0x6a, 0xc9, 0xb6, 0x2f, 0x24, 0xe3, 0x07, 0xdb, 0x4c, 0x48, 0xfb, 0x4e,
	0xae, 0xf0, 0x0c, 0xa9, 0xec, 0xd6, 0x8b, 0x07, 0xa4, 0x72, 0x2f, 0x31, 0xae, 0x04, 0x4c, 0x40,
	0xbd, 0x4d, 0x79, 0xd3, 0x5e, 0x31, 0x4a, 0x9c, 0x00, 0xca, 0xe4, 0x46, 0x6e, 0x2e, 0x2b, 0xe0,
	0x42, 0x87, 0xf5, 0xe0, 0x11, 0x15, 0x7b, 0x86, 0x02, 0x13, 0x20, 0x9f, 0x40, 0x96, 0x4b, 0x05,
	0xbe, 0x23, 0x7c, 0xa5, 0x0a, 0xf2, 0x09, 0xe3, 0x7b, 0xbb, 0x01, 0xdb, 0xdf, 0x7a, 0x01, 0x5e,
	0x24, 0x7d, 0xd6, 0x75, 0xe9, 0xfe, 0xf8, 0xc8, 0x1e, 0x2f, 0xdb, 0x3b, 0x46, 0xf9, 0xff, 0x8a,
	0x51, 0xb6, 0xb5, 0x53, 0x4a, 0x4b, 0xf7, 0xf0, 0x19, 0xe1, 0x85, 0x2a, 0x48, 0x17, 0xc2, 0xc0,
	0xf7, 0xe8, 0x68, 0x61, 0x0d, 0x84, 0xa0, 0x2d, 0x10, 0xf6, 0x86, 0x69, 0x2d, 0x0d, 0xac, 0x7c,
	0x2b, 0x73, 0x65, 0xa4, 0x96, 0xdf, 0x10, 0xbe, 0x5c, 0x05, 0x79, 0x9f, 0x76, 0x40, 0x84, 0xd4,
	0x03, 0x9d, 0xee, 0x3d, 0xd3, 0x52, 0x27, 0xa5, 0x28, 0xef, 0x9d, 0xd3, 0x09, 0x4b, 0x37, 0xf0,
	0x15, 0xe1, 0x4b, 0x55, 0x90, 0x9b, 0x3b, 0x0f, 0x75, 0xea, 0x5b, 0xa6, 0xd5, 0xf4, 0xbc, 0x92,
	0xbe, 0x3b, 0x6f, 0x4c, 0xaa, 0xfb, 0x1a, 0xe1, 0x33, 0x2e, 0xd0, 0x30, 0x0c, 0x0e, 0xb6, 0x7a,
	0xd0, 0x95, 0xc2, 0xbe, 0x69, 0xd8, 0x26, 0x19, 0x46, 0x69, 0xad, 0x16, 0x41, 0xa7, 0x66, 0x60,
	0xb9, 0xd9, 0xac, 0x03, 0xe5, 0x5e, 0xbb, 0x2c, 0x25, 0xf7, 0x1b, 0x91, 0x04, 0x61, 0x38, 0x03,
	0x35, 0x64, 0xbe, 0x19, 0xa8, 0x0d, 0x98, 0xea, 0x9e, 0x64, 0x34, 0x1c, 0xf3, 0xdb, 0xc8, 0x31,
	0x57, 0xfe, 0xa6, 0x58, 0x99, 0x2b, 0x63, 0xea, 0x08, 0xab, 0x20, 0x0b, 0x1e, 0xa1, 0x86, 0xcc,
	0x77, 0x84, 0xda, 0x80, 0x54, 0xee, 0x2d, 0xc2, 0xe7, 0xd4, 0x45, 0x53, 0x09, 0x22, 0x21, 0x81,
	0xdb, 0x6b, 0xb9, 0xae, 0xa7, 0x31, 0xa5, 0xa4, 0x6e, 0x15, 0x83, 0x53, 0xa1, 0x37, 0x08, 0x9f,
	0x4d, 0x7a, 0x24, 0xed, 0xcf, 0xd5, 0x1c, 0x8d, 0x35, 0xdb, 0x94, 0x6b, 0x85, 0xd8, 0xd4, 0xe6,
	0x3d, 0xc2, 0xe7, 0x1f, 0x44, 0xbc, 0x05, 0x59, 0x1f, 0xb3, 0x2d, 0xce, 0x62, 0xca, 0xe8, 0x76,
	0x41, 0x7a, 0xca, 0xa9, 0x06, 0x85, 0x9c, 0x66, 0xb1, 0x7c, 0x4e, 0xc7, 0xe9, 0xd4, 0x69, 0xf4,
	0x94, 0x73, 0x61, 0x97, 0x83, 0x68, 0xab, 0xab, 0x6f, 0x74, 0x5b, 0x0b, 0xc3, 0xa7, 0x9c, 0x0e,
	0xcd, 0xf7, 0x94, 0xd3, 0x27, 0xcc, 0x4c, 0x0a, 0x01, 0xdd, 0x66, 0x66, 0xf2, 0x26, 0x86, 0xa6,
	0x93, 0x42, 0x07, 0xe7, 0x9d, 0x14, 0xfa, 0x0c, 0x65, 0xb9, 0x11, 0xf4, 0x07, 0xc4, 0x3a, 0x1c,
	0x10, 0xeb, 0x68, 0x40, 0xd0, 0xab, 0x98, 0xa0, 0x2f, 0x31, 0x41, 0x3f, 0x62, 0x82, 0xfa, 0x31,
	0x41, 0x3f, 0x63, 0x82, 0x7e, 0xc5, 0xc4, 0x3a, 0x8a, 0x09, 0x7a, 0x37, 0x24, 0x56, 0x7f, 0x48,
	0xac, 0xc3, 0x21, 0xb1, 0x9e, 0xae, 0xb4, 0xd8, 0xa4, 0xbc, 0xcf, 0x4e, 0x78, 0x99, 0xaf, 0x65,
	0xff, 0x1b, 0xff, 0xfd, 0x79, 0x96, 0x5f, 0xff, 0x1d, 0x00, 0x00, 0xff, 0xff, 0xd3, 0x19, 0x50,
	0xae, 0x2c, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AdminServiceClient is the client API for AdminService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AdminServiceClient interface {
	// DescribeWorkflowExecution returns information about the internal states of workflow execution.
	DescribeMutableState(ctx context.Context, in *DescribeMutableStateRequest, opts ...grpc.CallOption) (*DescribeMutableStateResponse, error)
	// DescribeHistoryHost returns information about the internal states of a history host
	DescribeHistoryHost(ctx context.Context, in *DescribeHistoryHostRequest, opts ...grpc.CallOption) (*DescribeHistoryHostResponse, error)
	CloseShard(ctx context.Context, in *CloseShardRequest, opts ...grpc.CallOption) (*CloseShardResponse, error)
	RemoveTask(ctx context.Context, in *RemoveTaskRequest, opts ...grpc.CallOption) (*RemoveTaskResponse, error)
	// Returns the raw history of specified workflow execution.  It fails with 'NotFound' if specified workflow
	// execution in unknown to the service.
	// StartEventId defines the beginning of the event to fetch. The first event is inclusive.
	// EndEventId and EndEventVersion defines the end of the event to fetch. The end event is exclusive.
	GetWorkflowExecutionRawHistoryV2(ctx context.Context, in *GetWorkflowExecutionRawHistoryV2Request, opts ...grpc.CallOption) (*GetWorkflowExecutionRawHistoryV2Response, error)
	// GetReplicationMessages returns new replication tasks since the read level provided in the token.
	GetReplicationMessages(ctx context.Context, in *GetReplicationMessagesRequest, opts ...grpc.CallOption) (*GetReplicationMessagesResponse, error)
	// GetNamespaceReplicationMessages returns new namespace replication tasks since last retrieved task Id.
	GetNamespaceReplicationMessages(ctx context.Context, in *GetNamespaceReplicationMessagesRequest, opts ...grpc.CallOption) (*GetNamespaceReplicationMessagesResponse, error)
	// GetDLQReplicationMessages return replication messages based on DLQ info.
	GetDLQReplicationMessages(ctx context.Context, in *GetDLQReplicationMessagesRequest, opts ...grpc.CallOption) (*GetDLQReplicationMessagesResponse, error)
	// ReapplyEvents applies stale events to the current workflow and current run.
	ReapplyEvents(ctx context.Context, in *ReapplyEventsRequest, opts ...grpc.CallOption) (*ReapplyEventsResponse, error)
	// AddSearchAttributes add custom search attributes and returns comprehensive information about them.
	AddSearchAttributes(ctx context.Context, in *AddSearchAttributesRequest, opts ...grpc.CallOption) (*AddSearchAttributesResponse, error)
	// RemoveSearchAttributes removes custom search attributes and returns comprehensive information about them.
	RemoveSearchAttributes(ctx context.Context, in *RemoveSearchAttributesRequest, opts ...grpc.CallOption) (*RemoveSearchAttributesResponse, error)
	// GetSearchAttributes returns comprehensive information about search attributes.
	GetSearchAttributes(ctx context.Context, in *GetSearchAttributesRequest, opts ...grpc.CallOption) (*GetSearchAttributesResponse, error)
	// DescribeCluster returns information about Temporal cluster.
	DescribeCluster(ctx context.Context, in *DescribeClusterRequest, opts ...grpc.CallOption) (*DescribeClusterResponse, error)
	// GetDLQMessages returns messages from DLQ.
	GetDLQMessages(ctx context.Context, in *GetDLQMessagesRequest, opts ...grpc.CallOption) (*GetDLQMessagesResponse, error)
	// (-- api-linter: core::0165::response-message-name=disabled
	//     aip.dev/not-precedent:  --)
	// PurgeDLQMessages purges messages from DLQ.
	PurgeDLQMessages(ctx context.Context, in *PurgeDLQMessagesRequest, opts ...grpc.CallOption) (*PurgeDLQMessagesResponse, error)
	// MergeDLQMessages merges messages from DLQ.
	MergeDLQMessages(ctx context.Context, in *MergeDLQMessagesRequest, opts ...grpc.CallOption) (*MergeDLQMessagesResponse, error)
	// RefreshWorkflowTasks refreshes all tasks of a workflow.
	RefreshWorkflowTasks(ctx context.Context, in *RefreshWorkflowTasksRequest, opts ...grpc.CallOption) (*RefreshWorkflowTasksResponse, error)
	// ResendReplicationTasks requests replication tasks from remote cluster and apply tasks to current cluster.
	ResendReplicationTasks(ctx context.Context, in *ResendReplicationTasksRequest, opts ...grpc.CallOption) (*ResendReplicationTasksResponse, error)
}

type adminServiceClient struct {
	cc *grpc.ClientConn
}

func NewAdminServiceClient(cc *grpc.ClientConn) AdminServiceClient {
	return &adminServiceClient{cc}
}

func (c *adminServiceClient) DescribeMutableState(ctx context.Context, in *DescribeMutableStateRequest, opts ...grpc.CallOption) (*DescribeMutableStateResponse, error) {
	out := new(DescribeMutableStateResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/DescribeMutableState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) DescribeHistoryHost(ctx context.Context, in *DescribeHistoryHostRequest, opts ...grpc.CallOption) (*DescribeHistoryHostResponse, error) {
	out := new(DescribeHistoryHostResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/DescribeHistoryHost", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) CloseShard(ctx context.Context, in *CloseShardRequest, opts ...grpc.CallOption) (*CloseShardResponse, error) {
	out := new(CloseShardResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/CloseShard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) RemoveTask(ctx context.Context, in *RemoveTaskRequest, opts ...grpc.CallOption) (*RemoveTaskResponse, error) {
	out := new(RemoveTaskResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/RemoveTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) GetWorkflowExecutionRawHistoryV2(ctx context.Context, in *GetWorkflowExecutionRawHistoryV2Request, opts ...grpc.CallOption) (*GetWorkflowExecutionRawHistoryV2Response, error) {
	out := new(GetWorkflowExecutionRawHistoryV2Response)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/GetWorkflowExecutionRawHistoryV2", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) GetReplicationMessages(ctx context.Context, in *GetReplicationMessagesRequest, opts ...grpc.CallOption) (*GetReplicationMessagesResponse, error) {
	out := new(GetReplicationMessagesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/GetReplicationMessages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) GetNamespaceReplicationMessages(ctx context.Context, in *GetNamespaceReplicationMessagesRequest, opts ...grpc.CallOption) (*GetNamespaceReplicationMessagesResponse, error) {
	out := new(GetNamespaceReplicationMessagesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/GetNamespaceReplicationMessages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) GetDLQReplicationMessages(ctx context.Context, in *GetDLQReplicationMessagesRequest, opts ...grpc.CallOption) (*GetDLQReplicationMessagesResponse, error) {
	out := new(GetDLQReplicationMessagesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/GetDLQReplicationMessages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) ReapplyEvents(ctx context.Context, in *ReapplyEventsRequest, opts ...grpc.CallOption) (*ReapplyEventsResponse, error) {
	out := new(ReapplyEventsResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/ReapplyEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) AddSearchAttributes(ctx context.Context, in *AddSearchAttributesRequest, opts ...grpc.CallOption) (*AddSearchAttributesResponse, error) {
	out := new(AddSearchAttributesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/AddSearchAttributes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) RemoveSearchAttributes(ctx context.Context, in *RemoveSearchAttributesRequest, opts ...grpc.CallOption) (*RemoveSearchAttributesResponse, error) {
	out := new(RemoveSearchAttributesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/RemoveSearchAttributes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) GetSearchAttributes(ctx context.Context, in *GetSearchAttributesRequest, opts ...grpc.CallOption) (*GetSearchAttributesResponse, error) {
	out := new(GetSearchAttributesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/GetSearchAttributes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) DescribeCluster(ctx context.Context, in *DescribeClusterRequest, opts ...grpc.CallOption) (*DescribeClusterResponse, error) {
	out := new(DescribeClusterResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/DescribeCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) GetDLQMessages(ctx context.Context, in *GetDLQMessagesRequest, opts ...grpc.CallOption) (*GetDLQMessagesResponse, error) {
	out := new(GetDLQMessagesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/GetDLQMessages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) PurgeDLQMessages(ctx context.Context, in *PurgeDLQMessagesRequest, opts ...grpc.CallOption) (*PurgeDLQMessagesResponse, error) {
	out := new(PurgeDLQMessagesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/PurgeDLQMessages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) MergeDLQMessages(ctx context.Context, in *MergeDLQMessagesRequest, opts ...grpc.CallOption) (*MergeDLQMessagesResponse, error) {
	out := new(MergeDLQMessagesResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/MergeDLQMessages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) RefreshWorkflowTasks(ctx context.Context, in *RefreshWorkflowTasksRequest, opts ...grpc.CallOption) (*RefreshWorkflowTasksResponse, error) {
	out := new(RefreshWorkflowTasksResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/RefreshWorkflowTasks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminServiceClient) ResendReplicationTasks(ctx context.Context, in *ResendReplicationTasksRequest, opts ...grpc.CallOption) (*ResendReplicationTasksResponse, error) {
	out := new(ResendReplicationTasksResponse)
	err := c.cc.Invoke(ctx, "/temporal.server.api.adminservice.v1.AdminService/ResendReplicationTasks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AdminServiceServer is the server API for AdminService service.
type AdminServiceServer interface {
	// DescribeWorkflowExecution returns information about the internal states of workflow execution.
	DescribeMutableState(context.Context, *DescribeMutableStateRequest) (*DescribeMutableStateResponse, error)
	// DescribeHistoryHost returns information about the internal states of a history host
	DescribeHistoryHost(context.Context, *DescribeHistoryHostRequest) (*DescribeHistoryHostResponse, error)
	CloseShard(context.Context, *CloseShardRequest) (*CloseShardResponse, error)
	RemoveTask(context.Context, *RemoveTaskRequest) (*RemoveTaskResponse, error)
	// Returns the raw history of specified workflow execution.  It fails with 'NotFound' if specified workflow
	// execution in unknown to the service.
	// StartEventId defines the beginning of the event to fetch. The first event is inclusive.
	// EndEventId and EndEventVersion defines the end of the event to fetch. The end event is exclusive.
	GetWorkflowExecutionRawHistoryV2(context.Context, *GetWorkflowExecutionRawHistoryV2Request) (*GetWorkflowExecutionRawHistoryV2Response, error)
	// GetReplicationMessages returns new replication tasks since the read level provided in the token.
	GetReplicationMessages(context.Context, *GetReplicationMessagesRequest) (*GetReplicationMessagesResponse, error)
	// GetNamespaceReplicationMessages returns new namespace replication tasks since last retrieved task Id.
	GetNamespaceReplicationMessages(context.Context, *GetNamespaceReplicationMessagesRequest) (*GetNamespaceReplicationMessagesResponse, error)
	// GetDLQReplicationMessages return replication messages based on DLQ info.
	GetDLQReplicationMessages(context.Context, *GetDLQReplicationMessagesRequest) (*GetDLQReplicationMessagesResponse, error)
	// ReapplyEvents applies stale events to the current workflow and current run.
	ReapplyEvents(context.Context, *ReapplyEventsRequest) (*ReapplyEventsResponse, error)
	// AddSearchAttributes add custom search attributes and returns comprehensive information about them.
	AddSearchAttributes(context.Context, *AddSearchAttributesRequest) (*AddSearchAttributesResponse, error)
	// RemoveSearchAttributes removes custom search attributes and returns comprehensive information about them.
	RemoveSearchAttributes(context.Context, *RemoveSearchAttributesRequest) (*RemoveSearchAttributesResponse, error)
	// GetSearchAttributes returns comprehensive information about search attributes.
	GetSearchAttributes(context.Context, *GetSearchAttributesRequest) (*GetSearchAttributesResponse, error)
	// DescribeCluster returns information about Temporal cluster.
	DescribeCluster(context.Context, *DescribeClusterRequest) (*DescribeClusterResponse, error)
	// GetDLQMessages returns messages from DLQ.
	GetDLQMessages(context.Context, *GetDLQMessagesRequest) (*GetDLQMessagesResponse, error)
	// (-- api-linter: core::0165::response-message-name=disabled
	//     aip.dev/not-precedent:  --)
	// PurgeDLQMessages purges messages from DLQ.
	PurgeDLQMessages(context.Context, *PurgeDLQMessagesRequest) (*PurgeDLQMessagesResponse, error)
	// MergeDLQMessages merges messages from DLQ.
	MergeDLQMessages(context.Context, *MergeDLQMessagesRequest) (*MergeDLQMessagesResponse, error)
	// RefreshWorkflowTasks refreshes all tasks of a workflow.
	RefreshWorkflowTasks(context.Context, *RefreshWorkflowTasksRequest) (*RefreshWorkflowTasksResponse, error)
	// ResendReplicationTasks requests replication tasks from remote cluster and apply tasks to current cluster.
	ResendReplicationTasks(context.Context, *ResendReplicationTasksRequest) (*ResendReplicationTasksResponse, error)
}

// UnimplementedAdminServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAdminServiceServer struct {
}

func (*UnimplementedAdminServiceServer) DescribeMutableState(ctx context.Context, req *DescribeMutableStateRequest) (*DescribeMutableStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeMutableState not implemented")
}
func (*UnimplementedAdminServiceServer) DescribeHistoryHost(ctx context.Context, req *DescribeHistoryHostRequest) (*DescribeHistoryHostResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeHistoryHost not implemented")
}
func (*UnimplementedAdminServiceServer) CloseShard(ctx context.Context, req *CloseShardRequest) (*CloseShardResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloseShard not implemented")
}
func (*UnimplementedAdminServiceServer) RemoveTask(ctx context.Context, req *RemoveTaskRequest) (*RemoveTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveTask not implemented")
}
func (*UnimplementedAdminServiceServer) GetWorkflowExecutionRawHistoryV2(ctx context.Context, req *GetWorkflowExecutionRawHistoryV2Request) (*GetWorkflowExecutionRawHistoryV2Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkflowExecutionRawHistoryV2 not implemented")
}
func (*UnimplementedAdminServiceServer) GetReplicationMessages(ctx context.Context, req *GetReplicationMessagesRequest) (*GetReplicationMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReplicationMessages not implemented")
}
func (*UnimplementedAdminServiceServer) GetNamespaceReplicationMessages(ctx context.Context, req *GetNamespaceReplicationMessagesRequest) (*GetNamespaceReplicationMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNamespaceReplicationMessages not implemented")
}
func (*UnimplementedAdminServiceServer) GetDLQReplicationMessages(ctx context.Context, req *GetDLQReplicationMessagesRequest) (*GetDLQReplicationMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDLQReplicationMessages not implemented")
}
func (*UnimplementedAdminServiceServer) ReapplyEvents(ctx context.Context, req *ReapplyEventsRequest) (*ReapplyEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReapplyEvents not implemented")
}
func (*UnimplementedAdminServiceServer) AddSearchAttributes(ctx context.Context, req *AddSearchAttributesRequest) (*AddSearchAttributesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddSearchAttributes not implemented")
}
func (*UnimplementedAdminServiceServer) RemoveSearchAttributes(ctx context.Context, req *RemoveSearchAttributesRequest) (*RemoveSearchAttributesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveSearchAttributes not implemented")
}
func (*UnimplementedAdminServiceServer) GetSearchAttributes(ctx context.Context, req *GetSearchAttributesRequest) (*GetSearchAttributesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSearchAttributes not implemented")
}
func (*UnimplementedAdminServiceServer) DescribeCluster(ctx context.Context, req *DescribeClusterRequest) (*DescribeClusterResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeCluster not implemented")
}
func (*UnimplementedAdminServiceServer) GetDLQMessages(ctx context.Context, req *GetDLQMessagesRequest) (*GetDLQMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDLQMessages not implemented")
}
func (*UnimplementedAdminServiceServer) PurgeDLQMessages(ctx context.Context, req *PurgeDLQMessagesRequest) (*PurgeDLQMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeDLQMessages not implemented")
}
func (*UnimplementedAdminServiceServer) MergeDLQMessages(ctx context.Context, req *MergeDLQMessagesRequest) (*MergeDLQMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeDLQMessages not implemented")
}
func (*UnimplementedAdminServiceServer) RefreshWorkflowTasks(ctx context.Context, req *RefreshWorkflowTasksRequest) (*RefreshWorkflowTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RefreshWorkflowTasks not implemented")
}
func (*UnimplementedAdminServiceServer) ResendReplicationTasks(ctx context.Context, req *ResendReplicationTasksRequest) (*ResendReplicationTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResendReplicationTasks not implemented")
}

func RegisterAdminServiceServer(s *grpc.Server, srv AdminServiceServer) {
	s.RegisterService(&_AdminService_serviceDesc, srv)
}

func _AdminService_DescribeMutableState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeMutableStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).DescribeMutableState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/DescribeMutableState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).DescribeMutableState(ctx, req.(*DescribeMutableStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_DescribeHistoryHost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeHistoryHostRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).DescribeHistoryHost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/DescribeHistoryHost",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).DescribeHistoryHost(ctx, req.(*DescribeHistoryHostRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_CloseShard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseShardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).CloseShard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/CloseShard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).CloseShard(ctx, req.(*CloseShardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_RemoveTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).RemoveTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/RemoveTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).RemoveTask(ctx, req.(*RemoveTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_GetWorkflowExecutionRawHistoryV2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkflowExecutionRawHistoryV2Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).GetWorkflowExecutionRawHistoryV2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/GetWorkflowExecutionRawHistoryV2",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).GetWorkflowExecutionRawHistoryV2(ctx, req.(*GetWorkflowExecutionRawHistoryV2Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_GetReplicationMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReplicationMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).GetReplicationMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/GetReplicationMessages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).GetReplicationMessages(ctx, req.(*GetReplicationMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_GetNamespaceReplicationMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNamespaceReplicationMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).GetNamespaceReplicationMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/GetNamespaceReplicationMessages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).GetNamespaceReplicationMessages(ctx, req.(*GetNamespaceReplicationMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_GetDLQReplicationMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDLQReplicationMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).GetDLQReplicationMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/GetDLQReplicationMessages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).GetDLQReplicationMessages(ctx, req.(*GetDLQReplicationMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_ReapplyEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReapplyEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).ReapplyEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/ReapplyEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).ReapplyEvents(ctx, req.(*ReapplyEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_AddSearchAttributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddSearchAttributesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).AddSearchAttributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/AddSearchAttributes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).AddSearchAttributes(ctx, req.(*AddSearchAttributesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_RemoveSearchAttributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveSearchAttributesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).RemoveSearchAttributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/RemoveSearchAttributes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).RemoveSearchAttributes(ctx, req.(*RemoveSearchAttributesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_GetSearchAttributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSearchAttributesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).GetSearchAttributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/GetSearchAttributes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).GetSearchAttributes(ctx, req.(*GetSearchAttributesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_DescribeCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).DescribeCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/DescribeCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).DescribeCluster(ctx, req.(*DescribeClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_GetDLQMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDLQMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).GetDLQMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/GetDLQMessages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).GetDLQMessages(ctx, req.(*GetDLQMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_PurgeDLQMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeDLQMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).PurgeDLQMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/PurgeDLQMessages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).PurgeDLQMessages(ctx, req.(*PurgeDLQMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_MergeDLQMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeDLQMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).MergeDLQMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/MergeDLQMessages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).MergeDLQMessages(ctx, req.(*MergeDLQMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_RefreshWorkflowTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RefreshWorkflowTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).RefreshWorkflowTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/RefreshWorkflowTasks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).RefreshWorkflowTasks(ctx, req.(*RefreshWorkflowTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdminService_ResendReplicationTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResendReplicationTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServiceServer).ResendReplicationTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/temporal.server.api.adminservice.v1.AdminService/ResendReplicationTasks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServiceServer).ResendReplicationTasks(ctx, req.(*ResendReplicationTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AdminService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "temporal.server.api.adminservice.v1.AdminService",
	HandlerType: (*AdminServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DescribeMutableState",
			Handler:    _AdminService_DescribeMutableState_Handler,
		},
		{
			MethodName: "DescribeHistoryHost",
			Handler:    _AdminService_DescribeHistoryHost_Handler,
		},
		{
			MethodName: "CloseShard",
			Handler:    _AdminService_CloseShard_Handler,
		},
		{
			MethodName: "RemoveTask",
			Handler:    _AdminService_RemoveTask_Handler,
		},
		{
			MethodName: "GetWorkflowExecutionRawHistoryV2",
			Handler:    _AdminService_GetWorkflowExecutionRawHistoryV2_Handler,
		},
		{
			MethodName: "GetReplicationMessages",
			Handler:    _AdminService_GetReplicationMessages_Handler,
		},
		{
			MethodName: "GetNamespaceReplicationMessages",
			Handler:    _AdminService_GetNamespaceReplicationMessages_Handler,
		},
		{
			MethodName: "GetDLQReplicationMessages",
			Handler:    _AdminService_GetDLQReplicationMessages_Handler,
		},
		{
			MethodName: "ReapplyEvents",
			Handler:    _AdminService_ReapplyEvents_Handler,
		},
		{
			MethodName: "AddSearchAttributes",
			Handler:    _AdminService_AddSearchAttributes_Handler,
		},
		{
			MethodName: "RemoveSearchAttributes",
			Handler:    _AdminService_RemoveSearchAttributes_Handler,
		},
		{
			MethodName: "GetSearchAttributes",
			Handler:    _AdminService_GetSearchAttributes_Handler,
		},
		{
			MethodName: "DescribeCluster",
			Handler:    _AdminService_DescribeCluster_Handler,
		},
		{
			MethodName: "GetDLQMessages",
			Handler:    _AdminService_GetDLQMessages_Handler,
		},
		{
			MethodName: "PurgeDLQMessages",
			Handler:    _AdminService_PurgeDLQMessages_Handler,
		},
		{
			MethodName: "MergeDLQMessages",
			Handler:    _AdminService_MergeDLQMessages_Handler,
		},
		{
			MethodName: "RefreshWorkflowTasks",
			Handler:    _AdminService_RefreshWorkflowTasks_Handler,
		},
		{
			MethodName: "ResendReplicationTasks",
			Handler:    _AdminService_ResendReplicationTasks_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "temporal/server/api/adminservice/v1/service.proto",
}
