// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by MockGen. DO NOT EDIT.
// Source: request_rate_limiter.go

// Package quotas is a generated GoMock package.
package quotas

import (
	context "context"
	reflect "reflect"
	time "time"

	gomock "github.com/golang/mock/gomock"
)

// MockRequestRateLimiter is a mock of RequestRateLimiter interface.
type MockRequestRateLimiter struct {
	ctrl     *gomock.Controller
	recorder *MockRequestRateLimiterMockRecorder
}

// MockRequestRateLimiterMockRecorder is the mock recorder for MockRequestRateLimiter.
type MockRequestRateLimiterMockRecorder struct {
	mock *MockRequestRateLimiter
}

// NewMockRequestRateLimiter creates a new mock instance.
func NewMockRequestRateLimiter(ctrl *gomock.Controller) *MockRequestRateLimiter {
	mock := &MockRequestRateLimiter{ctrl: ctrl}
	mock.recorder = &MockRequestRateLimiterMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockRequestRateLimiter) EXPECT() *MockRequestRateLimiterMockRecorder {
	return m.recorder
}

// Allow mocks base method.
func (m *MockRequestRateLimiter) Allow(now time.Time, request Request) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Allow", now, request)
	ret0, _ := ret[0].(bool)
	return ret0
}

// Allow indicates an expected call of Allow.
func (mr *MockRequestRateLimiterMockRecorder) Allow(now, request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Allow", reflect.TypeOf((*MockRequestRateLimiter)(nil).Allow), now, request)
}

// Reserve mocks base method.
func (m *MockRequestRateLimiter) Reserve(now time.Time, request Request) Reservation {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Reserve", now, request)
	ret0, _ := ret[0].(Reservation)
	return ret0
}

// Reserve indicates an expected call of Reserve.
func (mr *MockRequestRateLimiterMockRecorder) Reserve(now, request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Reserve", reflect.TypeOf((*MockRequestRateLimiter)(nil).Reserve), now, request)
}

// Wait mocks base method.
func (m *MockRequestRateLimiter) Wait(ctx context.Context, request Request) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Wait", ctx, request)
	ret0, _ := ret[0].(error)
	return ret0
}

// Wait indicates an expected call of Wait.
func (mr *MockRequestRateLimiterMockRecorder) Wait(ctx, request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Wait", reflect.TypeOf((*MockRequestRateLimiter)(nil).Wait), ctx, request)
}
