// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/persistence/v1/namespaces.proto

package persistence

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	v1 "go.temporal.io/api/enums/v1"
	v11 "go.temporal.io/api/namespace/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// detail column
type NamespaceDetail struct {
	Info                        *NamespaceInfo              `protobuf:"bytes,1,opt,name=info,proto3" json:"info,omitempty"`
	Config                      *NamespaceConfig            `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ReplicationConfig           *NamespaceReplicationConfig `protobuf:"bytes,3,opt,name=replication_config,json=replicationConfig,proto3" json:"replication_config,omitempty"`
	ConfigVersion               int64                       `protobuf:"varint,4,opt,name=config_version,json=configVersion,proto3" json:"config_version,omitempty"`
	FailoverNotificationVersion int64                       `protobuf:"varint,5,opt,name=failover_notification_version,json=failoverNotificationVersion,proto3" json:"failover_notification_version,omitempty"`
	FailoverVersion             int64                       `protobuf:"varint,6,opt,name=failover_version,json=failoverVersion,proto3" json:"failover_version,omitempty"`
	FailoverEndTime             *time.Time                  `protobuf:"bytes,7,opt,name=failover_end_time,json=failoverEndTime,proto3,stdtime" json:"failover_end_time,omitempty"`
}

func (m *NamespaceDetail) Reset()      { *m = NamespaceDetail{} }
func (*NamespaceDetail) ProtoMessage() {}
func (*NamespaceDetail) Descriptor() ([]byte, []int) {
	return fileDescriptor_0486d93c2107d6bc, []int{0}
}
func (m *NamespaceDetail) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceDetail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceDetail.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceDetail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceDetail.Merge(m, src)
}
func (m *NamespaceDetail) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceDetail) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceDetail.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceDetail proto.InternalMessageInfo

func (m *NamespaceDetail) GetInfo() *NamespaceInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *NamespaceDetail) GetConfig() *NamespaceConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *NamespaceDetail) GetReplicationConfig() *NamespaceReplicationConfig {
	if m != nil {
		return m.ReplicationConfig
	}
	return nil
}

func (m *NamespaceDetail) GetConfigVersion() int64 {
	if m != nil {
		return m.ConfigVersion
	}
	return 0
}

func (m *NamespaceDetail) GetFailoverNotificationVersion() int64 {
	if m != nil {
		return m.FailoverNotificationVersion
	}
	return 0
}

func (m *NamespaceDetail) GetFailoverVersion() int64 {
	if m != nil {
		return m.FailoverVersion
	}
	return 0
}

func (m *NamespaceDetail) GetFailoverEndTime() *time.Time {
	if m != nil {
		return m.FailoverEndTime
	}
	return nil
}

type NamespaceInfo struct {
	Id          string            `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	State       v1.NamespaceState `protobuf:"varint,2,opt,name=state,proto3,enum=temporal.api.enums.v1.NamespaceState" json:"state,omitempty"`
	Name        string            `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Description string            `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	Owner       string            `protobuf:"bytes,5,opt,name=owner,proto3" json:"owner,omitempty"`
	Data        map[string]string `protobuf:"bytes,6,rep,name=data,proto3" json:"data,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *NamespaceInfo) Reset()      { *m = NamespaceInfo{} }
func (*NamespaceInfo) ProtoMessage() {}
func (*NamespaceInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_0486d93c2107d6bc, []int{1}
}
func (m *NamespaceInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceInfo.Merge(m, src)
}
func (m *NamespaceInfo) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceInfo.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceInfo proto.InternalMessageInfo

func (m *NamespaceInfo) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *NamespaceInfo) GetState() v1.NamespaceState {
	if m != nil {
		return m.State
	}
	return v1.NAMESPACE_STATE_UNSPECIFIED
}

func (m *NamespaceInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NamespaceInfo) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *NamespaceInfo) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *NamespaceInfo) GetData() map[string]string {
	if m != nil {
		return m.Data
	}
	return nil
}

type NamespaceConfig struct {
	Retention               *time.Duration   `protobuf:"bytes,1,opt,name=retention,proto3,stdduration" json:"retention,omitempty"`
	ArchivalBucket          string           `protobuf:"bytes,2,opt,name=archival_bucket,json=archivalBucket,proto3" json:"archival_bucket,omitempty"`
	BadBinaries             *v11.BadBinaries `protobuf:"bytes,3,opt,name=bad_binaries,json=badBinaries,proto3" json:"bad_binaries,omitempty"`
	HistoryArchivalState    v1.ArchivalState `protobuf:"varint,4,opt,name=history_archival_state,json=historyArchivalState,proto3,enum=temporal.api.enums.v1.ArchivalState" json:"history_archival_state,omitempty"`
	HistoryArchivalUri      string           `protobuf:"bytes,5,opt,name=history_archival_uri,json=historyArchivalUri,proto3" json:"history_archival_uri,omitempty"`
	VisibilityArchivalState v1.ArchivalState `protobuf:"varint,6,opt,name=visibility_archival_state,json=visibilityArchivalState,proto3,enum=temporal.api.enums.v1.ArchivalState" json:"visibility_archival_state,omitempty"`
	VisibilityArchivalUri   string           `protobuf:"bytes,7,opt,name=visibility_archival_uri,json=visibilityArchivalUri,proto3" json:"visibility_archival_uri,omitempty"`
}

func (m *NamespaceConfig) Reset()      { *m = NamespaceConfig{} }
func (*NamespaceConfig) ProtoMessage() {}
func (*NamespaceConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_0486d93c2107d6bc, []int{2}
}
func (m *NamespaceConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceConfig.Merge(m, src)
}
func (m *NamespaceConfig) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceConfig proto.InternalMessageInfo

func (m *NamespaceConfig) GetRetention() *time.Duration {
	if m != nil {
		return m.Retention
	}
	return nil
}

func (m *NamespaceConfig) GetArchivalBucket() string {
	if m != nil {
		return m.ArchivalBucket
	}
	return ""
}

func (m *NamespaceConfig) GetBadBinaries() *v11.BadBinaries {
	if m != nil {
		return m.BadBinaries
	}
	return nil
}

func (m *NamespaceConfig) GetHistoryArchivalState() v1.ArchivalState {
	if m != nil {
		return m.HistoryArchivalState
	}
	return v1.ARCHIVAL_STATE_UNSPECIFIED
}

func (m *NamespaceConfig) GetHistoryArchivalUri() string {
	if m != nil {
		return m.HistoryArchivalUri
	}
	return ""
}

func (m *NamespaceConfig) GetVisibilityArchivalState() v1.ArchivalState {
	if m != nil {
		return m.VisibilityArchivalState
	}
	return v1.ARCHIVAL_STATE_UNSPECIFIED
}

func (m *NamespaceConfig) GetVisibilityArchivalUri() string {
	if m != nil {
		return m.VisibilityArchivalUri
	}
	return ""
}

type NamespaceReplicationConfig struct {
	ActiveClusterName string   `protobuf:"bytes,1,opt,name=active_cluster_name,json=activeClusterName,proto3" json:"active_cluster_name,omitempty"`
	Clusters          []string `protobuf:"bytes,2,rep,name=clusters,proto3" json:"clusters,omitempty"`
}

func (m *NamespaceReplicationConfig) Reset()      { *m = NamespaceReplicationConfig{} }
func (*NamespaceReplicationConfig) ProtoMessage() {}
func (*NamespaceReplicationConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_0486d93c2107d6bc, []int{3}
}
func (m *NamespaceReplicationConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceReplicationConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceReplicationConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceReplicationConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceReplicationConfig.Merge(m, src)
}
func (m *NamespaceReplicationConfig) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceReplicationConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceReplicationConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceReplicationConfig proto.InternalMessageInfo

func (m *NamespaceReplicationConfig) GetActiveClusterName() string {
	if m != nil {
		return m.ActiveClusterName
	}
	return ""
}

func (m *NamespaceReplicationConfig) GetClusters() []string {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func init() {
	proto.RegisterType((*NamespaceDetail)(nil), "temporal.server.api.persistence.v1.NamespaceDetail")
	proto.RegisterType((*NamespaceInfo)(nil), "temporal.server.api.persistence.v1.NamespaceInfo")
	proto.RegisterMapType((map[string]string)(nil), "temporal.server.api.persistence.v1.NamespaceInfo.DataEntry")
	proto.RegisterType((*NamespaceConfig)(nil), "temporal.server.api.persistence.v1.NamespaceConfig")
	proto.RegisterType((*NamespaceReplicationConfig)(nil), "temporal.server.api.persistence.v1.NamespaceReplicationConfig")
}

func init() {
	proto.RegisterFile("temporal/server/api/persistence/v1/namespaces.proto", fileDescriptor_0486d93c2107d6bc)
}

var fileDescriptor_0486d93c2107d6bc = []byte{
	// 815 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0x41, 0x73, 0xe3, 0x34,
	0x18, 0x8d, 0x93, 0x34, 0x8b, 0x15, 0x36, 0xdd, 0x8a, 0xc2, 0x66, 0xc3, 0xe0, 0x0d, 0x19, 0xca,
	0x86, 0x8b, 0x4d, 0x5a, 0x06, 0x18, 0x3a, 0x30, 0x43, 0xda, 0x1e, 0x3a, 0x30, 0x65, 0xc6, 0x50,
	0x0e, 0xbd, 0x18, 0xc5, 0x56, 0x52, 0x51, 0x47, 0xf2, 0x48, 0x8a, 0x99, 0xde, 0xf8, 0x09, 0x3d,
	0xf2, 0x13, 0x38, 0xf3, 0x2b, 0x38, 0xf6, 0xd8, 0x1b, 0x34, 0xbd, 0x70, 0xe0, 0xd0, 0x23, 0x47,
	0xc6, 0x92, 0x6c, 0x27, 0x0d, 0x1d, 0x26, 0x37, 0xeb, 0xd3, 0x7b, 0x4f, 0x9f, 0xbe, 0xf7, 0xa2,
	0x80, 0x3d, 0x89, 0xa7, 0x09, 0xe3, 0x28, 0xf6, 0x04, 0xe6, 0x29, 0xe6, 0x1e, 0x4a, 0x88, 0x97,
	0x60, 0x2e, 0x88, 0x90, 0x98, 0x86, 0xd8, 0x4b, 0x07, 0x1e, 0x45, 0x53, 0x2c, 0x12, 0x14, 0x62,
	0xe1, 0x26, 0x9c, 0x49, 0x06, 0x7b, 0x39, 0xc9, 0xd5, 0x24, 0x17, 0x25, 0xc4, 0x5d, 0x20, 0xb9,
	0xe9, 0xa0, 0xe3, 0x4c, 0x18, 0x9b, 0xc4, 0xd8, 0x53, 0x8c, 0xd1, 0x6c, 0xec, 0x45, 0x33, 0x8e,
	0x24, 0x61, 0x54, 0x6b, 0x74, 0x5e, 0x3e, 0xdc, 0x97, 0x64, 0x8a, 0x85, 0x44, 0xd3, 0xc4, 0x00,
	0xde, 0x8d, 0x70, 0x82, 0x69, 0x84, 0x69, 0x48, 0xb0, 0xf0, 0x26, 0x6c, 0xc2, 0x54, 0x5d, 0x7d,
	0x19, 0xc8, 0x4e, 0xd1, 0x7c, 0xd6, 0x35, 0xa6, 0xb3, 0xa9, 0x58, 0xea, 0xd7, 0xc0, 0x5e, 0x2d,
	0xc1, 0x8a, 0xdd, 0x0c, 0x3a, 0xc5, 0x42, 0xa0, 0x89, 0x01, 0xf6, 0xfe, 0xa9, 0x81, 0xcd, 0x93,
	0x7c, 0xfb, 0x10, 0x4b, 0x44, 0x62, 0x78, 0x04, 0xea, 0x84, 0x8e, 0x59, 0xdb, 0xea, 0x5a, 0xfd,
	0xe6, 0xee, 0xc0, 0xfd, 0xff, 0xab, 0xbb, 0x85, 0xc4, 0x31, 0x1d, 0x33, 0x5f, 0xd1, 0xe1, 0x57,
	0xa0, 0x11, 0x32, 0x3a, 0x26, 0x93, 0x76, 0x55, 0x09, 0xed, 0xad, 0x25, 0x74, 0xa0, 0xa8, 0xbe,
	0x91, 0x80, 0x53, 0x00, 0x39, 0x4e, 0x62, 0x12, 0xaa, 0x81, 0x06, 0x46, 0xb8, 0xa6, 0x84, 0xbf,
	0x58, 0x4b, 0xd8, 0x2f, 0x65, 0xcc, 0x19, 0x5b, 0xfc, 0x61, 0x09, 0xee, 0x80, 0x96, 0x3e, 0x22,
	0x48, 0x33, 0x19, 0x46, 0xdb, 0xf5, 0xae, 0xd5, 0xaf, 0xf9, 0x4f, 0x75, 0xf5, 0x7b, 0x5d, 0x84,
	0x43, 0xf0, 0xce, 0x18, 0x91, 0x98, 0xa5, 0x98, 0x07, 0x94, 0x49, 0x32, 0xce, 0xfb, 0xcb, 0x59,
	0x1b, 0x8a, 0xf5, 0x76, 0x0e, 0x3a, 0x59, 0xc0, 0xe4, 0x1a, 0x1f, 0x80, 0x67, 0x85, 0x46, 0x4e,
	0x6b, 0x28, 0xda, 0x66, 0x5e, 0xcf, 0xa1, 0x5f, 0x83, 0xad, 0x02, 0x8a, 0x69, 0x14, 0x64, 0xf9,
	0x69, 0x3f, 0x51, 0x33, 0xe8, 0xb8, 0x3a, 0x5c, 0x6e, 0x1e, 0x2e, 0xf7, 0xbb, 0x3c, 0x5c, 0xc3,
	0xfa, 0xd5, 0x1f, 0x2f, 0xad, 0x52, 0xed, 0x88, 0x46, 0xd9, 0x5e, 0xef, 0xb7, 0x2a, 0x78, 0xba,
	0xe4, 0x1b, 0x6c, 0x81, 0x2a, 0x89, 0x94, 0xed, 0xb6, 0x5f, 0x25, 0x11, 0xdc, 0x07, 0x1b, 0x42,
	0x22, 0x89, 0x95, 0x81, 0xad, 0xdd, 0x9d, 0x72, 0xce, 0xd9, 0x80, 0x55, 0xf8, 0x96, 0x46, 0xfb,
	0x6d, 0x06, 0xf6, 0x35, 0x07, 0x42, 0x50, 0xcf, 0x72, 0xa7, 0x3c, 0xb2, 0x7d, 0xf5, 0x0d, 0xbb,
	0xa0, 0x19, 0x61, 0x11, 0x72, 0x92, 0xc8, 0x7c, 0xa6, 0xb6, 0xbf, 0x58, 0x82, 0xdb, 0x60, 0x83,
	0xfd, 0x44, 0x31, 0x57, 0x93, 0xb3, 0x7d, 0xbd, 0x80, 0xdf, 0x80, 0x7a, 0x84, 0x24, 0x6a, 0x37,
	0xba, 0xb5, 0x7e, 0x73, 0x77, 0x7f, 0xed, 0x44, 0xba, 0x87, 0x48, 0xa2, 0x23, 0x2a, 0xf9, 0xa5,
	0xaf, 0x84, 0x3a, 0x9f, 0x00, 0xbb, 0x28, 0xc1, 0x67, 0xa0, 0x76, 0x81, 0x2f, 0xcd, 0xbd, 0xb3,
	0xcf, 0xac, 0x8b, 0x14, 0xc5, 0x33, 0x7d, 0x71, 0xdb, 0xd7, 0x8b, 0xcf, 0xaa, 0x9f, 0x5a, 0xbd,
	0xbf, 0x17, 0x7f, 0x2f, 0x26, 0x2c, 0x9f, 0x03, 0x9b, 0x63, 0x89, 0xa9, 0xba, 0x93, 0xfe, 0xd1,
	0xbc, 0x58, 0xb1, 0xe3, 0xd0, 0xbc, 0x05, 0xc3, 0xfa, 0x2f, 0x99, 0x1b, 0x25, 0x03, 0xbe, 0x02,
	0x9b, 0x88, 0x87, 0xe7, 0x24, 0x45, 0x71, 0x30, 0x9a, 0x85, 0x17, 0x58, 0x9a, 0x63, 0x5b, 0x79,
	0x79, 0xa8, 0xaa, 0xf0, 0x18, 0xbc, 0x3e, 0x42, 0x51, 0x30, 0x22, 0x14, 0x71, 0x82, 0x85, 0x49,
	0xff, 0xfb, 0xcb, 0xae, 0x94, 0x2f, 0x41, 0x3a, 0x70, 0x87, 0x28, 0x1a, 0x1a, 0xb4, 0xdf, 0x1c,
	0x95, 0x0b, 0x78, 0x06, 0xde, 0x3a, 0x27, 0x42, 0x32, 0x7e, 0x19, 0x14, 0x67, 0x6b, 0xab, 0xeb,
	0xca, 0xea, 0xf7, 0x1e, 0xb1, 0xfa, 0x4b, 0x03, 0xd6, 0x4e, 0x6f, 0x1b, 0x8d, 0xa5, 0x2a, 0xfc,
	0x10, 0x6c, 0xaf, 0x68, 0xcf, 0x38, 0x31, 0x8e, 0xc2, 0x07, 0x9c, 0x53, 0x4e, 0xe0, 0x0f, 0xe0,
	0x45, 0x4a, 0x04, 0x19, 0x91, 0x98, 0xc8, 0x95, 0x86, 0x1a, 0x6b, 0x34, 0xf4, 0xbc, 0x94, 0x59,
	0xee, 0xe9, 0x63, 0xf0, 0xfc, 0xbf, 0x4e, 0xc8, 0xda, 0x7a, 0xa2, 0xda, 0x7a, 0x73, 0x95, 0x79,
	0xca, 0x49, 0xef, 0x1c, 0x74, 0x1e, 0x7f, 0x38, 0xa0, 0x0b, 0xde, 0x40, 0xa1, 0x24, 0x29, 0x0e,
	0xc2, 0x78, 0x26, 0x64, 0xf6, 0x08, 0x64, 0x89, 0xd7, 0x41, 0xda, 0xd2, 0x5b, 0x07, 0x7a, 0x27,
	0x53, 0x81, 0x1d, 0xf0, 0x9a, 0x01, 0x8a, 0x76, 0xb5, 0x5b, 0xeb, 0xdb, 0x7e, 0xb1, 0x1e, 0xfe,
	0x78, 0x7d, 0xeb, 0x54, 0x6e, 0x6e, 0x9d, 0xca, 0xfd, 0xad, 0x63, 0xfd, 0x3c, 0x77, 0xac, 0x5f,
	0xe7, 0x8e, 0xf5, 0xfb, 0xdc, 0xb1, 0xae, 0xe7, 0x8e, 0xf5, 0xe7, 0xdc, 0xb1, 0xfe, 0x9a, 0x3b,
	0x95, 0xfb, 0xb9, 0x63, 0x5d, 0xdd, 0x39, 0x95, 0xeb, 0x3b, 0xa7, 0x72, 0x73, 0xe7, 0x54, 0xce,
	0x3e, 0x9a, 0xb0, 0x72, 0x30, 0x84, 0x3d, 0xfe, 0x8f, 0xb6, 0xbf, 0xb0, 0x1c, 0x35, 0x54, 0x2a,
	0xf7, 0xfe, 0x0d, 0x00, 0x00, 0xff, 0xff, 0xb6, 0x1e, 0x04, 0xeb, 0x0a, 0x07, 0x00, 0x00,
}

func (this *NamespaceDetail) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NamespaceDetail)
	if !ok {
		that2, ok := that.(NamespaceDetail)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Info.Equal(that1.Info) {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	if !this.ReplicationConfig.Equal(that1.ReplicationConfig) {
		return false
	}
	if this.ConfigVersion != that1.ConfigVersion {
		return false
	}
	if this.FailoverNotificationVersion != that1.FailoverNotificationVersion {
		return false
	}
	if this.FailoverVersion != that1.FailoverVersion {
		return false
	}
	if that1.FailoverEndTime == nil {
		if this.FailoverEndTime != nil {
			return false
		}
	} else if !this.FailoverEndTime.Equal(*that1.FailoverEndTime) {
		return false
	}
	return true
}
func (this *NamespaceInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NamespaceInfo)
	if !ok {
		that2, ok := that.(NamespaceInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if this.State != that1.State {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Description != that1.Description {
		return false
	}
	if this.Owner != that1.Owner {
		return false
	}
	if len(this.Data) != len(that1.Data) {
		return false
	}
	for i := range this.Data {
		if this.Data[i] != that1.Data[i] {
			return false
		}
	}
	return true
}
func (this *NamespaceConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NamespaceConfig)
	if !ok {
		that2, ok := that.(NamespaceConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Retention != nil && that1.Retention != nil {
		if *this.Retention != *that1.Retention {
			return false
		}
	} else if this.Retention != nil {
		return false
	} else if that1.Retention != nil {
		return false
	}
	if this.ArchivalBucket != that1.ArchivalBucket {
		return false
	}
	if !this.BadBinaries.Equal(that1.BadBinaries) {
		return false
	}
	if this.HistoryArchivalState != that1.HistoryArchivalState {
		return false
	}
	if this.HistoryArchivalUri != that1.HistoryArchivalUri {
		return false
	}
	if this.VisibilityArchivalState != that1.VisibilityArchivalState {
		return false
	}
	if this.VisibilityArchivalUri != that1.VisibilityArchivalUri {
		return false
	}
	return true
}
func (this *NamespaceReplicationConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NamespaceReplicationConfig)
	if !ok {
		that2, ok := that.(NamespaceReplicationConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ActiveClusterName != that1.ActiveClusterName {
		return false
	}
	if len(this.Clusters) != len(that1.Clusters) {
		return false
	}
	for i := range this.Clusters {
		if this.Clusters[i] != that1.Clusters[i] {
			return false
		}
	}
	return true
}
func (this *NamespaceDetail) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&persistence.NamespaceDetail{")
	if this.Info != nil {
		s = append(s, "Info: "+fmt.Sprintf("%#v", this.Info)+",\n")
	}
	if this.Config != nil {
		s = append(s, "Config: "+fmt.Sprintf("%#v", this.Config)+",\n")
	}
	if this.ReplicationConfig != nil {
		s = append(s, "ReplicationConfig: "+fmt.Sprintf("%#v", this.ReplicationConfig)+",\n")
	}
	s = append(s, "ConfigVersion: "+fmt.Sprintf("%#v", this.ConfigVersion)+",\n")
	s = append(s, "FailoverNotificationVersion: "+fmt.Sprintf("%#v", this.FailoverNotificationVersion)+",\n")
	s = append(s, "FailoverVersion: "+fmt.Sprintf("%#v", this.FailoverVersion)+",\n")
	s = append(s, "FailoverEndTime: "+fmt.Sprintf("%#v", this.FailoverEndTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NamespaceInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&persistence.NamespaceInfo{")
	s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Description: "+fmt.Sprintf("%#v", this.Description)+",\n")
	s = append(s, "Owner: "+fmt.Sprintf("%#v", this.Owner)+",\n")
	keysForData := make([]string, 0, len(this.Data))
	for k, _ := range this.Data {
		keysForData = append(keysForData, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForData)
	mapStringForData := "map[string]string{"
	for _, k := range keysForData {
		mapStringForData += fmt.Sprintf("%#v: %#v,", k, this.Data[k])
	}
	mapStringForData += "}"
	if this.Data != nil {
		s = append(s, "Data: "+mapStringForData+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NamespaceConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&persistence.NamespaceConfig{")
	s = append(s, "Retention: "+fmt.Sprintf("%#v", this.Retention)+",\n")
	s = append(s, "ArchivalBucket: "+fmt.Sprintf("%#v", this.ArchivalBucket)+",\n")
	if this.BadBinaries != nil {
		s = append(s, "BadBinaries: "+fmt.Sprintf("%#v", this.BadBinaries)+",\n")
	}
	s = append(s, "HistoryArchivalState: "+fmt.Sprintf("%#v", this.HistoryArchivalState)+",\n")
	s = append(s, "HistoryArchivalUri: "+fmt.Sprintf("%#v", this.HistoryArchivalUri)+",\n")
	s = append(s, "VisibilityArchivalState: "+fmt.Sprintf("%#v", this.VisibilityArchivalState)+",\n")
	s = append(s, "VisibilityArchivalUri: "+fmt.Sprintf("%#v", this.VisibilityArchivalUri)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NamespaceReplicationConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&persistence.NamespaceReplicationConfig{")
	s = append(s, "ActiveClusterName: "+fmt.Sprintf("%#v", this.ActiveClusterName)+",\n")
	s = append(s, "Clusters: "+fmt.Sprintf("%#v", this.Clusters)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringNamespaces(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *NamespaceDetail) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceDetail) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceDetail) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.FailoverEndTime != nil {
		n1, err1 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.FailoverEndTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.FailoverEndTime):])
		if err1 != nil {
			return 0, err1
		}
		i -= n1
		i = encodeVarintNamespaces(dAtA, i, uint64(n1))
		i--
		dAtA[i] = 0x3a
	}
	if m.FailoverVersion != 0 {
		i = encodeVarintNamespaces(dAtA, i, uint64(m.FailoverVersion))
		i--
		dAtA[i] = 0x30
	}
	if m.FailoverNotificationVersion != 0 {
		i = encodeVarintNamespaces(dAtA, i, uint64(m.FailoverNotificationVersion))
		i--
		dAtA[i] = 0x28
	}
	if m.ConfigVersion != 0 {
		i = encodeVarintNamespaces(dAtA, i, uint64(m.ConfigVersion))
		i--
		dAtA[i] = 0x20
	}
	if m.ReplicationConfig != nil {
		{
			size, err := m.ReplicationConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNamespaces(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNamespaces(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNamespaces(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NamespaceInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		for k := range m.Data {
			v := m.Data[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintNamespaces(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintNamespaces(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintNamespaces(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Owner) > 0 {
		i -= len(m.Owner)
		copy(dAtA[i:], m.Owner)
		i = encodeVarintNamespaces(dAtA, i, uint64(len(m.Owner)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintNamespaces(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintNamespaces(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if m.State != 0 {
		i = encodeVarintNamespaces(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintNamespaces(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NamespaceConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.VisibilityArchivalUri) > 0 {
		i -= len(m.VisibilityArchivalUri)
		copy(dAtA[i:], m.VisibilityArchivalUri)
		i = encodeVarintNamespaces(dAtA, i, uint64(len(m.VisibilityArchivalUri)))
		i--
		dAtA[i] = 0x3a
	}
	if m.VisibilityArchivalState != 0 {
		i = encodeVarintNamespaces(dAtA, i, uint64(m.VisibilityArchivalState))
		i--
		dAtA[i] = 0x30
	}
	if len(m.HistoryArchivalUri) > 0 {
		i -= len(m.HistoryArchivalUri)
		copy(dAtA[i:], m.HistoryArchivalUri)
		i = encodeVarintNamespaces(dAtA, i, uint64(len(m.HistoryArchivalUri)))
		i--
		dAtA[i] = 0x2a
	}
	if m.HistoryArchivalState != 0 {
		i = encodeVarintNamespaces(dAtA, i, uint64(m.HistoryArchivalState))
		i--
		dAtA[i] = 0x20
	}
	if m.BadBinaries != nil {
		{
			size, err := m.BadBinaries.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNamespaces(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ArchivalBucket) > 0 {
		i -= len(m.ArchivalBucket)
		copy(dAtA[i:], m.ArchivalBucket)
		i = encodeVarintNamespaces(dAtA, i, uint64(len(m.ArchivalBucket)))
		i--
		dAtA[i] = 0x12
	}
	if m.Retention != nil {
		n6, err6 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.Retention, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Retention):])
		if err6 != nil {
			return 0, err6
		}
		i -= n6
		i = encodeVarintNamespaces(dAtA, i, uint64(n6))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NamespaceReplicationConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceReplicationConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceReplicationConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Clusters) > 0 {
		for iNdEx := len(m.Clusters) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Clusters[iNdEx])
			copy(dAtA[i:], m.Clusters[iNdEx])
			i = encodeVarintNamespaces(dAtA, i, uint64(len(m.Clusters[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ActiveClusterName) > 0 {
		i -= len(m.ActiveClusterName)
		copy(dAtA[i:], m.ActiveClusterName)
		i = encodeVarintNamespaces(dAtA, i, uint64(len(m.ActiveClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintNamespaces(dAtA []byte, offset int, v uint64) int {
	offset -= sovNamespaces(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *NamespaceDetail) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovNamespaces(uint64(l))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovNamespaces(uint64(l))
	}
	if m.ReplicationConfig != nil {
		l = m.ReplicationConfig.Size()
		n += 1 + l + sovNamespaces(uint64(l))
	}
	if m.ConfigVersion != 0 {
		n += 1 + sovNamespaces(uint64(m.ConfigVersion))
	}
	if m.FailoverNotificationVersion != 0 {
		n += 1 + sovNamespaces(uint64(m.FailoverNotificationVersion))
	}
	if m.FailoverVersion != 0 {
		n += 1 + sovNamespaces(uint64(m.FailoverVersion))
	}
	if m.FailoverEndTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.FailoverEndTime)
		n += 1 + l + sovNamespaces(uint64(l))
	}
	return n
}

func (m *NamespaceInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovNamespaces(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovNamespaces(uint64(m.State))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovNamespaces(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovNamespaces(uint64(l))
	}
	l = len(m.Owner)
	if l > 0 {
		n += 1 + l + sovNamespaces(uint64(l))
	}
	if len(m.Data) > 0 {
		for k, v := range m.Data {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovNamespaces(uint64(len(k))) + 1 + len(v) + sovNamespaces(uint64(len(v)))
			n += mapEntrySize + 1 + sovNamespaces(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *NamespaceConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Retention != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Retention)
		n += 1 + l + sovNamespaces(uint64(l))
	}
	l = len(m.ArchivalBucket)
	if l > 0 {
		n += 1 + l + sovNamespaces(uint64(l))
	}
	if m.BadBinaries != nil {
		l = m.BadBinaries.Size()
		n += 1 + l + sovNamespaces(uint64(l))
	}
	if m.HistoryArchivalState != 0 {
		n += 1 + sovNamespaces(uint64(m.HistoryArchivalState))
	}
	l = len(m.HistoryArchivalUri)
	if l > 0 {
		n += 1 + l + sovNamespaces(uint64(l))
	}
	if m.VisibilityArchivalState != 0 {
		n += 1 + sovNamespaces(uint64(m.VisibilityArchivalState))
	}
	l = len(m.VisibilityArchivalUri)
	if l > 0 {
		n += 1 + l + sovNamespaces(uint64(l))
	}
	return n
}

func (m *NamespaceReplicationConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ActiveClusterName)
	if l > 0 {
		n += 1 + l + sovNamespaces(uint64(l))
	}
	if len(m.Clusters) > 0 {
		for _, s := range m.Clusters {
			l = len(s)
			n += 1 + l + sovNamespaces(uint64(l))
		}
	}
	return n
}

func sovNamespaces(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozNamespaces(x uint64) (n int) {
	return sovNamespaces(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *NamespaceDetail) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NamespaceDetail{`,
		`Info:` + strings.Replace(this.Info.String(), "NamespaceInfo", "NamespaceInfo", 1) + `,`,
		`Config:` + strings.Replace(this.Config.String(), "NamespaceConfig", "NamespaceConfig", 1) + `,`,
		`ReplicationConfig:` + strings.Replace(this.ReplicationConfig.String(), "NamespaceReplicationConfig", "NamespaceReplicationConfig", 1) + `,`,
		`ConfigVersion:` + fmt.Sprintf("%v", this.ConfigVersion) + `,`,
		`FailoverNotificationVersion:` + fmt.Sprintf("%v", this.FailoverNotificationVersion) + `,`,
		`FailoverVersion:` + fmt.Sprintf("%v", this.FailoverVersion) + `,`,
		`FailoverEndTime:` + strings.Replace(fmt.Sprintf("%v", this.FailoverEndTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NamespaceInfo) String() string {
	if this == nil {
		return "nil"
	}
	keysForData := make([]string, 0, len(this.Data))
	for k, _ := range this.Data {
		keysForData = append(keysForData, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForData)
	mapStringForData := "map[string]string{"
	for _, k := range keysForData {
		mapStringForData += fmt.Sprintf("%v: %v,", k, this.Data[k])
	}
	mapStringForData += "}"
	s := strings.Join([]string{`&NamespaceInfo{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Description:` + fmt.Sprintf("%v", this.Description) + `,`,
		`Owner:` + fmt.Sprintf("%v", this.Owner) + `,`,
		`Data:` + mapStringForData + `,`,
		`}`,
	}, "")
	return s
}
func (this *NamespaceConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NamespaceConfig{`,
		`Retention:` + strings.Replace(fmt.Sprintf("%v", this.Retention), "Duration", "types.Duration", 1) + `,`,
		`ArchivalBucket:` + fmt.Sprintf("%v", this.ArchivalBucket) + `,`,
		`BadBinaries:` + strings.Replace(fmt.Sprintf("%v", this.BadBinaries), "BadBinaries", "v11.BadBinaries", 1) + `,`,
		`HistoryArchivalState:` + fmt.Sprintf("%v", this.HistoryArchivalState) + `,`,
		`HistoryArchivalUri:` + fmt.Sprintf("%v", this.HistoryArchivalUri) + `,`,
		`VisibilityArchivalState:` + fmt.Sprintf("%v", this.VisibilityArchivalState) + `,`,
		`VisibilityArchivalUri:` + fmt.Sprintf("%v", this.VisibilityArchivalUri) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NamespaceReplicationConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NamespaceReplicationConfig{`,
		`ActiveClusterName:` + fmt.Sprintf("%v", this.ActiveClusterName) + `,`,
		`Clusters:` + fmt.Sprintf("%v", this.Clusters) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringNamespaces(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *NamespaceDetail) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNamespaces
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NamespaceDetail: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NamespaceDetail: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Info == nil {
				m.Info = &NamespaceInfo{}
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &NamespaceConfig{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReplicationConfig == nil {
				m.ReplicationConfig = &NamespaceReplicationConfig{}
			}
			if err := m.ReplicationConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigVersion", wireType)
			}
			m.ConfigVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConfigVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailoverNotificationVersion", wireType)
			}
			m.FailoverNotificationVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FailoverNotificationVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailoverVersion", wireType)
			}
			m.FailoverVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FailoverVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailoverEndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FailoverEndTime == nil {
				m.FailoverEndTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.FailoverEndTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNamespaces(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthNamespaces
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthNamespaces
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NamespaceInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNamespaces
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NamespaceInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NamespaceInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= v1.NamespaceState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Owner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Owner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Data == nil {
				m.Data = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowNamespaces
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNamespaces
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthNamespaces
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthNamespaces
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNamespaces
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthNamespaces
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthNamespaces
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipNamespaces(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthNamespaces
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Data[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNamespaces(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthNamespaces
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthNamespaces
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NamespaceConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNamespaces
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NamespaceConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NamespaceConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Retention", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Retention == nil {
				m.Retention = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.Retention, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ArchivalBucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ArchivalBucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BadBinaries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BadBinaries == nil {
				m.BadBinaries = &v11.BadBinaries{}
			}
			if err := m.BadBinaries.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryArchivalState", wireType)
			}
			m.HistoryArchivalState = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HistoryArchivalState |= v1.ArchivalState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryArchivalUri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HistoryArchivalUri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityArchivalState", wireType)
			}
			m.VisibilityArchivalState = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.VisibilityArchivalState |= v1.ArchivalState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityArchivalUri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VisibilityArchivalUri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNamespaces(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthNamespaces
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthNamespaces
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NamespaceReplicationConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNamespaces
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NamespaceReplicationConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NamespaceReplicationConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActiveClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clusters", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNamespaces
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaces
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Clusters = append(m.Clusters, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNamespaces(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthNamespaces
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthNamespaces
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipNamespaces(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowNamespaces
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNamespaces
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthNamespaces
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupNamespaces
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthNamespaces
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthNamespaces        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowNamespaces          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupNamespaces = fmt.Errorf("proto: unexpected end of group")
)
