// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/checksum/v1/message.proto

package checksum

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"

	proto "github.com/gogo/protobuf/proto"
	v11 "go.temporal.io/api/enums/v1"
	v1 "go.temporal.io/server/api/enums/v1"
	v12 "go.temporal.io/server/api/history/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type MutableStateChecksumPayload struct {
	CancelRequested              bool                        `protobuf:"varint,1,opt,name=cancel_requested,json=cancelRequested,proto3" json:"cancel_requested,omitempty"`
	State                        v1.WorkflowExecutionState   `protobuf:"varint,2,opt,name=state,proto3,enum=temporal.server.api.enums.v1.WorkflowExecutionState" json:"state,omitempty"`
	Status                       v11.WorkflowExecutionStatus `protobuf:"varint,3,opt,name=status,proto3,enum=temporal.api.enums.v1.WorkflowExecutionStatus" json:"status,omitempty"`
	LastWriteVersion             int64                       `protobuf:"varint,4,opt,name=last_write_version,json=lastWriteVersion,proto3" json:"last_write_version,omitempty"`
	LastWriteEventId             int64                       `protobuf:"varint,5,opt,name=last_write_event_id,json=lastWriteEventId,proto3" json:"last_write_event_id,omitempty"`
	LastFirstEventId             int64                       `protobuf:"varint,6,opt,name=last_first_event_id,json=lastFirstEventId,proto3" json:"last_first_event_id,omitempty"`
	NextEventId                  int64                       `protobuf:"varint,7,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	LastProcessedEventId         int64                       `protobuf:"varint,8,opt,name=last_processed_event_id,json=lastProcessedEventId,proto3" json:"last_processed_event_id,omitempty"`
	SignalCount                  int64                       `protobuf:"varint,9,opt,name=signal_count,json=signalCount,proto3" json:"signal_count,omitempty"`
	WorkflowTaskAttempt          int32                       `protobuf:"varint,10,opt,name=workflow_task_attempt,json=workflowTaskAttempt,proto3" json:"workflow_task_attempt,omitempty"`
	WorkflowTaskVersion          int64                       `protobuf:"varint,11,opt,name=workflow_task_version,json=workflowTaskVersion,proto3" json:"workflow_task_version,omitempty"`
	WorkflowTaskScheduledId      int64                       `protobuf:"varint,12,opt,name=workflow_task_scheduled_id,json=workflowTaskScheduledId,proto3" json:"workflow_task_scheduled_id,omitempty"`
	WorkflowTaskStartedId        int64                       `protobuf:"varint,13,opt,name=workflow_task_started_id,json=workflowTaskStartedId,proto3" json:"workflow_task_started_id,omitempty"`
	PendingTimerStartedIds       []int64                     `protobuf:"varint,14,rep,packed,name=pending_timer_started_ids,json=pendingTimerStartedIds,proto3" json:"pending_timer_started_ids,omitempty"`
	PendingActivityScheduledIds  []int64                     `protobuf:"varint,15,rep,packed,name=pending_activity_scheduled_ids,json=pendingActivityScheduledIds,proto3" json:"pending_activity_scheduled_ids,omitempty"`
	PendingSignalInitiatedIds    []int64                     `protobuf:"varint,16,rep,packed,name=pending_signal_initiated_ids,json=pendingSignalInitiatedIds,proto3" json:"pending_signal_initiated_ids,omitempty"`
	PendingReqCancelInitiatedIds []int64                     `protobuf:"varint,17,rep,packed,name=pending_req_cancel_initiated_ids,json=pendingReqCancelInitiatedIds,proto3" json:"pending_req_cancel_initiated_ids,omitempty"`
	PendingChildInitiatedIds     []int64                     `protobuf:"varint,18,rep,packed,name=pending_child_initiated_ids,json=pendingChildInitiatedIds,proto3" json:"pending_child_initiated_ids,omitempty"`
	StickyTaskQueueName          string                      `protobuf:"bytes,19,opt,name=sticky_task_queue_name,json=stickyTaskQueueName,proto3" json:"sticky_task_queue_name,omitempty"`
	VersionHistories             *v12.VersionHistories       `protobuf:"bytes,20,opt,name=version_histories,json=versionHistories,proto3" json:"version_histories,omitempty"`
}

func (m *MutableStateChecksumPayload) Reset()      { *m = MutableStateChecksumPayload{} }
func (*MutableStateChecksumPayload) ProtoMessage() {}
func (*MutableStateChecksumPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_c8c4c1fd39c4866b, []int{0}
}
func (m *MutableStateChecksumPayload) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MutableStateChecksumPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MutableStateChecksumPayload.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MutableStateChecksumPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutableStateChecksumPayload.Merge(m, src)
}
func (m *MutableStateChecksumPayload) XXX_Size() int {
	return m.Size()
}
func (m *MutableStateChecksumPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_MutableStateChecksumPayload.DiscardUnknown(m)
}

var xxx_messageInfo_MutableStateChecksumPayload proto.InternalMessageInfo

func (m *MutableStateChecksumPayload) GetCancelRequested() bool {
	if m != nil {
		return m.CancelRequested
	}
	return false
}

func (m *MutableStateChecksumPayload) GetState() v1.WorkflowExecutionState {
	if m != nil {
		return m.State
	}
	return v1.WORKFLOW_EXECUTION_STATE_UNSPECIFIED
}

func (m *MutableStateChecksumPayload) GetStatus() v11.WorkflowExecutionStatus {
	if m != nil {
		return m.Status
	}
	return v11.WORKFLOW_EXECUTION_STATUS_UNSPECIFIED
}

func (m *MutableStateChecksumPayload) GetLastWriteVersion() int64 {
	if m != nil {
		return m.LastWriteVersion
	}
	return 0
}

func (m *MutableStateChecksumPayload) GetLastWriteEventId() int64 {
	if m != nil {
		return m.LastWriteEventId
	}
	return 0
}

func (m *MutableStateChecksumPayload) GetLastFirstEventId() int64 {
	if m != nil {
		return m.LastFirstEventId
	}
	return 0
}

func (m *MutableStateChecksumPayload) GetNextEventId() int64 {
	if m != nil {
		return m.NextEventId
	}
	return 0
}

func (m *MutableStateChecksumPayload) GetLastProcessedEventId() int64 {
	if m != nil {
		return m.LastProcessedEventId
	}
	return 0
}

func (m *MutableStateChecksumPayload) GetSignalCount() int64 {
	if m != nil {
		return m.SignalCount
	}
	return 0
}

func (m *MutableStateChecksumPayload) GetWorkflowTaskAttempt() int32 {
	if m != nil {
		return m.WorkflowTaskAttempt
	}
	return 0
}

func (m *MutableStateChecksumPayload) GetWorkflowTaskVersion() int64 {
	if m != nil {
		return m.WorkflowTaskVersion
	}
	return 0
}

func (m *MutableStateChecksumPayload) GetWorkflowTaskScheduledId() int64 {
	if m != nil {
		return m.WorkflowTaskScheduledId
	}
	return 0
}

func (m *MutableStateChecksumPayload) GetWorkflowTaskStartedId() int64 {
	if m != nil {
		return m.WorkflowTaskStartedId
	}
	return 0
}

func (m *MutableStateChecksumPayload) GetPendingTimerStartedIds() []int64 {
	if m != nil {
		return m.PendingTimerStartedIds
	}
	return nil
}

func (m *MutableStateChecksumPayload) GetPendingActivityScheduledIds() []int64 {
	if m != nil {
		return m.PendingActivityScheduledIds
	}
	return nil
}

func (m *MutableStateChecksumPayload) GetPendingSignalInitiatedIds() []int64 {
	if m != nil {
		return m.PendingSignalInitiatedIds
	}
	return nil
}

func (m *MutableStateChecksumPayload) GetPendingReqCancelInitiatedIds() []int64 {
	if m != nil {
		return m.PendingReqCancelInitiatedIds
	}
	return nil
}

func (m *MutableStateChecksumPayload) GetPendingChildInitiatedIds() []int64 {
	if m != nil {
		return m.PendingChildInitiatedIds
	}
	return nil
}

func (m *MutableStateChecksumPayload) GetStickyTaskQueueName() string {
	if m != nil {
		return m.StickyTaskQueueName
	}
	return ""
}

func (m *MutableStateChecksumPayload) GetVersionHistories() *v12.VersionHistories {
	if m != nil {
		return m.VersionHistories
	}
	return nil
}

func init() {
	proto.RegisterType((*MutableStateChecksumPayload)(nil), "temporal.server.api.checksum.v1.MutableStateChecksumPayload")
}

func init() {
	proto.RegisterFile("temporal/server/api/checksum/v1/message.proto", fileDescriptor_c8c4c1fd39c4866b)
}

var fileDescriptor_c8c4c1fd39c4866b = []byte{
	// 732 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x94, 0xcd, 0x4e, 0xdb, 0x4e,
	0x14, 0xc5, 0xe3, 0x7f, 0xfe, 0x50, 0x18, 0xbe, 0x82, 0xc3, 0x87, 0x1b, 0x2a, 0xd7, 0x45, 0x5d,
	0xa4, 0x2a, 0x38, 0x05, 0x5a, 0x55, 0x15, 0xaa, 0x2a, 0x1a, 0x81, 0x9a, 0x4a, 0xad, 0xa8, 0x41,
	0x45, 0xaa, 0x54, 0x59, 0x83, 0x7d, 0x49, 0x46, 0x71, 0xec, 0xc4, 0x33, 0x36, 0x64, 0xd7, 0x47,
	0xe8, 0x23, 0x74, 0xd9, 0x47, 0xe9, 0x92, 0x25, 0xcb, 0x12, 0x36, 0x5d, 0xf2, 0x08, 0xd5, 0x8c,
	0x3d, 0x24, 0x0e, 0x41, 0xdd, 0x59, 0xf7, 0xfc, 0xce, 0x99, 0xeb, 0x6b, 0xcf, 0x45, 0xeb, 0x0c,
	0x5a, 0xed, 0x20, 0xc4, 0x5e, 0x85, 0x42, 0x18, 0x43, 0x58, 0xc1, 0x6d, 0x52, 0x71, 0x1a, 0xe0,
	0x34, 0x69, 0xd4, 0xaa, 0xc4, 0x1b, 0x95, 0x16, 0x50, 0x8a, 0xeb, 0x60, 0xb6, 0xc3, 0x80, 0x05,
	0xea, 0x43, 0x89, 0x9b, 0x09, 0x6e, 0xe2, 0x36, 0x31, 0x25, 0x6e, 0xc6, 0x1b, 0xa5, 0xc7, 0x37,
	0x79, 0x3c, 0x08, 0xfc, 0xa8, 0x45, 0x79, 0xca, 0x69, 0x10, 0x36, 0x4f, 0xbc, 0xe0, 0x34, 0x89,
	0x29, 0xad, 0x8d, 0x3a, 0xb5, 0x41, 0x28, 0x0b, 0xc2, 0xee, 0xad, 0x43, 0x4b, 0x4f, 0x47, 0xd1,
	0x77, 0x44, 0xaf, 0xfe, 0x98, 0x44, 0x2b, 0x1f, 0x22, 0x86, 0x8f, 0x3d, 0x38, 0x60, 0x98, 0x41,
	0x35, 0x6d, 0x6e, 0x1f, 0x77, 0xbd, 0x00, 0xbb, 0xea, 0x13, 0x54, 0x70, 0xb0, 0xef, 0x80, 0x67,
	0x87, 0xd0, 0x89, 0x80, 0x32, 0x70, 0x35, 0xc5, 0x50, 0xca, 0x13, 0xd6, 0x5c, 0x52, 0xb7, 0x64,
	0x59, 0x7d, 0x8f, 0xc6, 0x28, 0x8f, 0xd0, 0xfe, 0x33, 0x94, 0xf2, 0xec, 0xe6, 0x73, 0x73, 0xd4,
	0xcb, 0x8b, 0x3e, 0xcc, 0x78, 0xc3, 0x3c, 0x4a, 0xfb, 0xd8, 0x3d, 0x03, 0x27, 0x62, 0x24, 0xf0,
	0xc5, 0xf1, 0x56, 0x12, 0xa1, 0xee, 0xa1, 0x71, 0xfe, 0x10, 0x51, 0x2d, 0x2f, 0xc2, 0xcc, 0x7e,
	0xd8, 0xbf, 0x53, 0x22, 0x6a, 0xa5, 0x6e, 0x75, 0x0d, 0xa9, 0x1e, 0xa6, 0xcc, 0x3e, 0x0d, 0x09,
	0x03, 0x3b, 0x86, 0x90, 0x92, 0xc0, 0xd7, 0xfe, 0x37, 0x94, 0x72, 0xde, 0x2a, 0x70, 0xe5, 0x88,
	0x0b, 0x9f, 0x93, 0xba, 0xba, 0x8e, 0x8a, 0x03, 0x34, 0xc4, 0xe0, 0x33, 0x9b, 0xb8, 0xda, 0xd8,
	0x10, 0xbe, 0xcb, 0x85, 0x9a, 0x7b, 0x83, 0x9f, 0x90, 0x90, 0xb2, 0x3e, 0x3e, 0xde, 0xc7, 0xf7,
	0xb8, 0x22, 0xf1, 0x55, 0x34, 0xe3, 0xc3, 0xd9, 0x00, 0x78, 0x4f, 0x80, 0x53, 0xbc, 0x28, 0x99,
	0x17, 0x68, 0x59, 0x44, 0xb6, 0xc3, 0xc0, 0x01, 0x4a, 0xc1, 0xed, 0xd3, 0x13, 0x82, 0x5e, 0xe0,
	0xf2, 0xbe, 0x54, 0xa5, 0xed, 0x11, 0x9a, 0xa6, 0xa4, 0xee, 0x63, 0xcf, 0x76, 0x82, 0xc8, 0x67,
	0xda, 0x64, 0x92, 0x9c, 0xd4, 0xaa, 0xbc, 0xa4, 0x6e, 0xa2, 0x45, 0xf9, 0xe9, 0x6d, 0x86, 0x69,
	0xd3, 0xc6, 0x8c, 0x8f, 0x94, 0x69, 0xc8, 0x50, 0xca, 0x63, 0x56, 0x51, 0x8a, 0x87, 0x98, 0x36,
	0x77, 0x12, 0xe9, 0xb6, 0x47, 0x0e, 0x70, 0x4a, 0xe4, 0x67, 0x3c, 0x72, 0x86, 0xdb, 0xa8, 0x94,
	0xf5, 0x50, 0xa7, 0x01, 0x6e, 0xe4, 0x81, 0xcb, 0x5f, 0x62, 0x5a, 0x18, 0x97, 0x07, 0x8d, 0x07,
	0x52, 0xaf, 0xb9, 0xea, 0x4b, 0xa4, 0x0d, 0x99, 0x19, 0x0e, 0x59, 0x62, 0x9d, 0x11, 0xd6, 0xc5,
	0x8c, 0x35, 0x51, 0x6b, 0xae, 0xfa, 0x0a, 0xdd, 0x6f, 0x83, 0xef, 0x12, 0xbf, 0x6e, 0x33, 0xd2,
	0x82, 0x70, 0xc0, 0x48, 0xb5, 0x59, 0x23, 0x5f, 0xce, 0x5b, 0x4b, 0x29, 0x70, 0xc8, 0xf5, 0x1b,
	0x27, 0x55, 0xab, 0x48, 0x97, 0x56, 0xec, 0x30, 0x12, 0x13, 0xd6, 0xcd, 0xf4, 0x4c, 0xb5, 0x39,
	0xe1, 0x5f, 0x49, 0xa9, 0x9d, 0x14, 0x1a, 0xe8, 0x9b, 0xaa, 0x6f, 0xd0, 0x03, 0x19, 0x92, 0x7e,
	0x08, 0xe2, 0x13, 0x46, 0xb0, 0x6c, 0xa1, 0x20, 0x22, 0x64, 0x8f, 0x07, 0x02, 0xa9, 0x49, 0x82,
	0x07, 0xec, 0x21, 0x43, 0x06, 0x84, 0xd0, 0xb1, 0xd3, 0x3b, 0x97, 0x0d, 0x99, 0x17, 0x21, 0xf2,
	0x20, 0x0b, 0x3a, 0x55, 0x41, 0x65, 0x72, 0x5e, 0x23, 0xd9, 0xa7, 0xed, 0x34, 0x88, 0xe7, 0x0e,
	0x45, 0xa8, 0x22, 0x42, 0x4b, 0x91, 0x2a, 0x27, 0x32, 0xf6, 0x2d, 0xb4, 0x44, 0x19, 0x71, 0x9a,
	0xdd, 0x64, 0xfc, 0x9d, 0x08, 0x22, 0xb0, 0x7d, 0xdc, 0x02, 0xad, 0x68, 0x28, 0xe5, 0x49, 0xab,
	0x98, 0xa8, 0x7c, 0xf8, 0x9f, 0xb8, 0xf6, 0x11, 0xb7, 0x40, 0xfd, 0x8a, 0xe6, 0xd3, 0x1f, 0xc3,
	0x4e, 0x96, 0x12, 0x01, 0xaa, 0x2d, 0x18, 0x4a, 0x79, 0x6a, 0xf3, 0xd9, 0xc8, 0x25, 0x90, 0xae,
	0x2e, 0x7e, 0x81, 0xd3, 0xdf, 0xe6, 0x9d, 0xf4, 0x59, 0x85, 0x78, 0xa8, 0xf2, 0xd6, 0x3d, 0xbf,
	0xd4, 0x73, 0x17, 0x97, 0x7a, 0xee, 0xfa, 0x52, 0x57, 0xbe, 0xf5, 0x74, 0xe5, 0x67, 0x4f, 0x57,
	0x7e, 0xf5, 0x74, 0xe5, 0xbc, 0xa7, 0x2b, 0xbf, 0x7b, 0xba, 0xf2, 0xa7, 0xa7, 0xe7, 0xae, 0x7b,
	0xba, 0xf2, 0xfd, 0x4a, 0xcf, 0x9d, 0x5f, 0xe9, 0xb9, 0x8b, 0x2b, 0x3d, 0xf7, 0xc5, 0xac, 0x07,
	0xfd, 0xb3, 0x49, 0x70, 0xc7, 0xbe, 0xde, 0x96, 0xcf, 0xc7, 0xe3, 0x62, 0x1f, 0x6e, 0xfd, 0x0d,
	0x00, 0x00, 0xff, 0xff, 0x60, 0xfa, 0xd9, 0x6d, 0xe2, 0x05, 0x00, 0x00,
}

func (this *MutableStateChecksumPayload) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MutableStateChecksumPayload)
	if !ok {
		that2, ok := that.(MutableStateChecksumPayload)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.CancelRequested != that1.CancelRequested {
		return false
	}
	if this.State != that1.State {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.LastWriteVersion != that1.LastWriteVersion {
		return false
	}
	if this.LastWriteEventId != that1.LastWriteEventId {
		return false
	}
	if this.LastFirstEventId != that1.LastFirstEventId {
		return false
	}
	if this.NextEventId != that1.NextEventId {
		return false
	}
	if this.LastProcessedEventId != that1.LastProcessedEventId {
		return false
	}
	if this.SignalCount != that1.SignalCount {
		return false
	}
	if this.WorkflowTaskAttempt != that1.WorkflowTaskAttempt {
		return false
	}
	if this.WorkflowTaskVersion != that1.WorkflowTaskVersion {
		return false
	}
	if this.WorkflowTaskScheduledId != that1.WorkflowTaskScheduledId {
		return false
	}
	if this.WorkflowTaskStartedId != that1.WorkflowTaskStartedId {
		return false
	}
	if len(this.PendingTimerStartedIds) != len(that1.PendingTimerStartedIds) {
		return false
	}
	for i := range this.PendingTimerStartedIds {
		if this.PendingTimerStartedIds[i] != that1.PendingTimerStartedIds[i] {
			return false
		}
	}
	if len(this.PendingActivityScheduledIds) != len(that1.PendingActivityScheduledIds) {
		return false
	}
	for i := range this.PendingActivityScheduledIds {
		if this.PendingActivityScheduledIds[i] != that1.PendingActivityScheduledIds[i] {
			return false
		}
	}
	if len(this.PendingSignalInitiatedIds) != len(that1.PendingSignalInitiatedIds) {
		return false
	}
	for i := range this.PendingSignalInitiatedIds {
		if this.PendingSignalInitiatedIds[i] != that1.PendingSignalInitiatedIds[i] {
			return false
		}
	}
	if len(this.PendingReqCancelInitiatedIds) != len(that1.PendingReqCancelInitiatedIds) {
		return false
	}
	for i := range this.PendingReqCancelInitiatedIds {
		if this.PendingReqCancelInitiatedIds[i] != that1.PendingReqCancelInitiatedIds[i] {
			return false
		}
	}
	if len(this.PendingChildInitiatedIds) != len(that1.PendingChildInitiatedIds) {
		return false
	}
	for i := range this.PendingChildInitiatedIds {
		if this.PendingChildInitiatedIds[i] != that1.PendingChildInitiatedIds[i] {
			return false
		}
	}
	if this.StickyTaskQueueName != that1.StickyTaskQueueName {
		return false
	}
	if !this.VersionHistories.Equal(that1.VersionHistories) {
		return false
	}
	return true
}
func (this *MutableStateChecksumPayload) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 24)
	s = append(s, "&checksum.MutableStateChecksumPayload{")
	s = append(s, "CancelRequested: "+fmt.Sprintf("%#v", this.CancelRequested)+",\n")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	s = append(s, "LastWriteVersion: "+fmt.Sprintf("%#v", this.LastWriteVersion)+",\n")
	s = append(s, "LastWriteEventId: "+fmt.Sprintf("%#v", this.LastWriteEventId)+",\n")
	s = append(s, "LastFirstEventId: "+fmt.Sprintf("%#v", this.LastFirstEventId)+",\n")
	s = append(s, "NextEventId: "+fmt.Sprintf("%#v", this.NextEventId)+",\n")
	s = append(s, "LastProcessedEventId: "+fmt.Sprintf("%#v", this.LastProcessedEventId)+",\n")
	s = append(s, "SignalCount: "+fmt.Sprintf("%#v", this.SignalCount)+",\n")
	s = append(s, "WorkflowTaskAttempt: "+fmt.Sprintf("%#v", this.WorkflowTaskAttempt)+",\n")
	s = append(s, "WorkflowTaskVersion: "+fmt.Sprintf("%#v", this.WorkflowTaskVersion)+",\n")
	s = append(s, "WorkflowTaskScheduledId: "+fmt.Sprintf("%#v", this.WorkflowTaskScheduledId)+",\n")
	s = append(s, "WorkflowTaskStartedId: "+fmt.Sprintf("%#v", this.WorkflowTaskStartedId)+",\n")
	s = append(s, "PendingTimerStartedIds: "+fmt.Sprintf("%#v", this.PendingTimerStartedIds)+",\n")
	s = append(s, "PendingActivityScheduledIds: "+fmt.Sprintf("%#v", this.PendingActivityScheduledIds)+",\n")
	s = append(s, "PendingSignalInitiatedIds: "+fmt.Sprintf("%#v", this.PendingSignalInitiatedIds)+",\n")
	s = append(s, "PendingReqCancelInitiatedIds: "+fmt.Sprintf("%#v", this.PendingReqCancelInitiatedIds)+",\n")
	s = append(s, "PendingChildInitiatedIds: "+fmt.Sprintf("%#v", this.PendingChildInitiatedIds)+",\n")
	s = append(s, "StickyTaskQueueName: "+fmt.Sprintf("%#v", this.StickyTaskQueueName)+",\n")
	if this.VersionHistories != nil {
		s = append(s, "VersionHistories: "+fmt.Sprintf("%#v", this.VersionHistories)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringMessage(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *MutableStateChecksumPayload) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MutableStateChecksumPayload) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MutableStateChecksumPayload) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VersionHistories != nil {
		{
			size, err := m.VersionHistories.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if len(m.StickyTaskQueueName) > 0 {
		i -= len(m.StickyTaskQueueName)
		copy(dAtA[i:], m.StickyTaskQueueName)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.StickyTaskQueueName)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if len(m.PendingChildInitiatedIds) > 0 {
		dAtA3 := make([]byte, len(m.PendingChildInitiatedIds)*10)
		var j2 int
		for _, num1 := range m.PendingChildInitiatedIds {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA3[j2] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j2++
			}
			dAtA3[j2] = uint8(num)
			j2++
		}
		i -= j2
		copy(dAtA[i:], dAtA3[:j2])
		i = encodeVarintMessage(dAtA, i, uint64(j2))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if len(m.PendingReqCancelInitiatedIds) > 0 {
		dAtA5 := make([]byte, len(m.PendingReqCancelInitiatedIds)*10)
		var j4 int
		for _, num1 := range m.PendingReqCancelInitiatedIds {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA5[j4] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j4++
			}
			dAtA5[j4] = uint8(num)
			j4++
		}
		i -= j4
		copy(dAtA[i:], dAtA5[:j4])
		i = encodeVarintMessage(dAtA, i, uint64(j4))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if len(m.PendingSignalInitiatedIds) > 0 {
		dAtA7 := make([]byte, len(m.PendingSignalInitiatedIds)*10)
		var j6 int
		for _, num1 := range m.PendingSignalInitiatedIds {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA7[j6] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j6++
			}
			dAtA7[j6] = uint8(num)
			j6++
		}
		i -= j6
		copy(dAtA[i:], dAtA7[:j6])
		i = encodeVarintMessage(dAtA, i, uint64(j6))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if len(m.PendingActivityScheduledIds) > 0 {
		dAtA9 := make([]byte, len(m.PendingActivityScheduledIds)*10)
		var j8 int
		for _, num1 := range m.PendingActivityScheduledIds {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA9[j8] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j8++
			}
			dAtA9[j8] = uint8(num)
			j8++
		}
		i -= j8
		copy(dAtA[i:], dAtA9[:j8])
		i = encodeVarintMessage(dAtA, i, uint64(j8))
		i--
		dAtA[i] = 0x7a
	}
	if len(m.PendingTimerStartedIds) > 0 {
		dAtA11 := make([]byte, len(m.PendingTimerStartedIds)*10)
		var j10 int
		for _, num1 := range m.PendingTimerStartedIds {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA11[j10] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j10++
			}
			dAtA11[j10] = uint8(num)
			j10++
		}
		i -= j10
		copy(dAtA[i:], dAtA11[:j10])
		i = encodeVarintMessage(dAtA, i, uint64(j10))
		i--
		dAtA[i] = 0x72
	}
	if m.WorkflowTaskStartedId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.WorkflowTaskStartedId))
		i--
		dAtA[i] = 0x68
	}
	if m.WorkflowTaskScheduledId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.WorkflowTaskScheduledId))
		i--
		dAtA[i] = 0x60
	}
	if m.WorkflowTaskVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.WorkflowTaskVersion))
		i--
		dAtA[i] = 0x58
	}
	if m.WorkflowTaskAttempt != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.WorkflowTaskAttempt))
		i--
		dAtA[i] = 0x50
	}
	if m.SignalCount != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.SignalCount))
		i--
		dAtA[i] = 0x48
	}
	if m.LastProcessedEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.LastProcessedEventId))
		i--
		dAtA[i] = 0x40
	}
	if m.NextEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.NextEventId))
		i--
		dAtA[i] = 0x38
	}
	if m.LastFirstEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.LastFirstEventId))
		i--
		dAtA[i] = 0x30
	}
	if m.LastWriteEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.LastWriteEventId))
		i--
		dAtA[i] = 0x28
	}
	if m.LastWriteVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.LastWriteVersion))
		i--
		dAtA[i] = 0x20
	}
	if m.Status != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x18
	}
	if m.State != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x10
	}
	if m.CancelRequested {
		i--
		if m.CancelRequested {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintMessage(dAtA []byte, offset int, v uint64) int {
	offset -= sovMessage(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *MutableStateChecksumPayload) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CancelRequested {
		n += 2
	}
	if m.State != 0 {
		n += 1 + sovMessage(uint64(m.State))
	}
	if m.Status != 0 {
		n += 1 + sovMessage(uint64(m.Status))
	}
	if m.LastWriteVersion != 0 {
		n += 1 + sovMessage(uint64(m.LastWriteVersion))
	}
	if m.LastWriteEventId != 0 {
		n += 1 + sovMessage(uint64(m.LastWriteEventId))
	}
	if m.LastFirstEventId != 0 {
		n += 1 + sovMessage(uint64(m.LastFirstEventId))
	}
	if m.NextEventId != 0 {
		n += 1 + sovMessage(uint64(m.NextEventId))
	}
	if m.LastProcessedEventId != 0 {
		n += 1 + sovMessage(uint64(m.LastProcessedEventId))
	}
	if m.SignalCount != 0 {
		n += 1 + sovMessage(uint64(m.SignalCount))
	}
	if m.WorkflowTaskAttempt != 0 {
		n += 1 + sovMessage(uint64(m.WorkflowTaskAttempt))
	}
	if m.WorkflowTaskVersion != 0 {
		n += 1 + sovMessage(uint64(m.WorkflowTaskVersion))
	}
	if m.WorkflowTaskScheduledId != 0 {
		n += 1 + sovMessage(uint64(m.WorkflowTaskScheduledId))
	}
	if m.WorkflowTaskStartedId != 0 {
		n += 1 + sovMessage(uint64(m.WorkflowTaskStartedId))
	}
	if len(m.PendingTimerStartedIds) > 0 {
		l = 0
		for _, e := range m.PendingTimerStartedIds {
			l += sovMessage(uint64(e))
		}
		n += 1 + sovMessage(uint64(l)) + l
	}
	if len(m.PendingActivityScheduledIds) > 0 {
		l = 0
		for _, e := range m.PendingActivityScheduledIds {
			l += sovMessage(uint64(e))
		}
		n += 1 + sovMessage(uint64(l)) + l
	}
	if len(m.PendingSignalInitiatedIds) > 0 {
		l = 0
		for _, e := range m.PendingSignalInitiatedIds {
			l += sovMessage(uint64(e))
		}
		n += 2 + sovMessage(uint64(l)) + l
	}
	if len(m.PendingReqCancelInitiatedIds) > 0 {
		l = 0
		for _, e := range m.PendingReqCancelInitiatedIds {
			l += sovMessage(uint64(e))
		}
		n += 2 + sovMessage(uint64(l)) + l
	}
	if len(m.PendingChildInitiatedIds) > 0 {
		l = 0
		for _, e := range m.PendingChildInitiatedIds {
			l += sovMessage(uint64(e))
		}
		n += 2 + sovMessage(uint64(l)) + l
	}
	l = len(m.StickyTaskQueueName)
	if l > 0 {
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.VersionHistories != nil {
		l = m.VersionHistories.Size()
		n += 2 + l + sovMessage(uint64(l))
	}
	return n
}

func sovMessage(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMessage(x uint64) (n int) {
	return sovMessage(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *MutableStateChecksumPayload) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MutableStateChecksumPayload{`,
		`CancelRequested:` + fmt.Sprintf("%v", this.CancelRequested) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`LastWriteVersion:` + fmt.Sprintf("%v", this.LastWriteVersion) + `,`,
		`LastWriteEventId:` + fmt.Sprintf("%v", this.LastWriteEventId) + `,`,
		`LastFirstEventId:` + fmt.Sprintf("%v", this.LastFirstEventId) + `,`,
		`NextEventId:` + fmt.Sprintf("%v", this.NextEventId) + `,`,
		`LastProcessedEventId:` + fmt.Sprintf("%v", this.LastProcessedEventId) + `,`,
		`SignalCount:` + fmt.Sprintf("%v", this.SignalCount) + `,`,
		`WorkflowTaskAttempt:` + fmt.Sprintf("%v", this.WorkflowTaskAttempt) + `,`,
		`WorkflowTaskVersion:` + fmt.Sprintf("%v", this.WorkflowTaskVersion) + `,`,
		`WorkflowTaskScheduledId:` + fmt.Sprintf("%v", this.WorkflowTaskScheduledId) + `,`,
		`WorkflowTaskStartedId:` + fmt.Sprintf("%v", this.WorkflowTaskStartedId) + `,`,
		`PendingTimerStartedIds:` + fmt.Sprintf("%v", this.PendingTimerStartedIds) + `,`,
		`PendingActivityScheduledIds:` + fmt.Sprintf("%v", this.PendingActivityScheduledIds) + `,`,
		`PendingSignalInitiatedIds:` + fmt.Sprintf("%v", this.PendingSignalInitiatedIds) + `,`,
		`PendingReqCancelInitiatedIds:` + fmt.Sprintf("%v", this.PendingReqCancelInitiatedIds) + `,`,
		`PendingChildInitiatedIds:` + fmt.Sprintf("%v", this.PendingChildInitiatedIds) + `,`,
		`StickyTaskQueueName:` + fmt.Sprintf("%v", this.StickyTaskQueueName) + `,`,
		`VersionHistories:` + strings.Replace(fmt.Sprintf("%v", this.VersionHistories), "VersionHistories", "v12.VersionHistories", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMessage(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *MutableStateChecksumPayload) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MutableStateChecksumPayload: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MutableStateChecksumPayload: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequested", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CancelRequested = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= v1.WorkflowExecutionState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= v11.WorkflowExecutionStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastWriteVersion", wireType)
			}
			m.LastWriteVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastWriteVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastWriteEventId", wireType)
			}
			m.LastWriteEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastWriteEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastFirstEventId", wireType)
			}
			m.LastFirstEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastFirstEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextEventId", wireType)
			}
			m.NextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastProcessedEventId", wireType)
			}
			m.LastProcessedEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastProcessedEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignalCount", wireType)
			}
			m.SignalCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SignalCount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskAttempt", wireType)
			}
			m.WorkflowTaskAttempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowTaskAttempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskVersion", wireType)
			}
			m.WorkflowTaskVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowTaskVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskScheduledId", wireType)
			}
			m.WorkflowTaskScheduledId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowTaskScheduledId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskStartedId", wireType)
			}
			m.WorkflowTaskStartedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowTaskStartedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.PendingTimerStartedIds = append(m.PendingTimerStartedIds, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMessage
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMessage
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.PendingTimerStartedIds) == 0 {
					m.PendingTimerStartedIds = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.PendingTimerStartedIds = append(m.PendingTimerStartedIds, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingTimerStartedIds", wireType)
			}
		case 15:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.PendingActivityScheduledIds = append(m.PendingActivityScheduledIds, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMessage
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMessage
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.PendingActivityScheduledIds) == 0 {
					m.PendingActivityScheduledIds = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.PendingActivityScheduledIds = append(m.PendingActivityScheduledIds, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingActivityScheduledIds", wireType)
			}
		case 16:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.PendingSignalInitiatedIds = append(m.PendingSignalInitiatedIds, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMessage
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMessage
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.PendingSignalInitiatedIds) == 0 {
					m.PendingSignalInitiatedIds = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.PendingSignalInitiatedIds = append(m.PendingSignalInitiatedIds, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingSignalInitiatedIds", wireType)
			}
		case 17:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.PendingReqCancelInitiatedIds = append(m.PendingReqCancelInitiatedIds, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMessage
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMessage
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.PendingReqCancelInitiatedIds) == 0 {
					m.PendingReqCancelInitiatedIds = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.PendingReqCancelInitiatedIds = append(m.PendingReqCancelInitiatedIds, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingReqCancelInitiatedIds", wireType)
			}
		case 18:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.PendingChildInitiatedIds = append(m.PendingChildInitiatedIds, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMessage
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMessage
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.PendingChildInitiatedIds) == 0 {
					m.PendingChildInitiatedIds = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.PendingChildInitiatedIds = append(m.PendingChildInitiatedIds, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingChildInitiatedIds", wireType)
			}
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StickyTaskQueueName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StickyTaskQueueName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionHistories", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionHistories == nil {
				m.VersionHistories = &v12.VersionHistories{}
			}
			if err := m.VersionHistories.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMessage(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMessage
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMessage
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMessage
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMessage        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMessage          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMessage = fmt.Errorf("proto: unexpected end of group")
)
