// Copyright (c) 2022 Tailscale Inc & AUTHORS All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by tailscale.com/util/codegen (viewer); DO NOT EDIT.

package dnstype

import (
	"encoding/json"
	"errors"

	"inet.af/netaddr"
	"tailscale.com/types/views"
)

//go:generate go run tailscale.com/cmd/cloner  -clonefunc=true -type=Resolver
// View returns a readonly view of Resolver.
func (p *Resolver) View() ResolverView {
	return ResolverView{ж: p}
}

// ResolverView provides a read-only view on Resolver.
// It's methods should only be called if `Valid()` returns true.
type ResolverView struct {
	// It is named distinctively to make you think of how dangerous it is to escape
	// to callers. You must not let callers be able to mutate it.
	ж *Resolver
}

// Valid reports whether underlying value is non-nil.
func (v ResolverView) Valid() bool { return v.ж != nil }

// AsStruct returns a clone of the underlying value which aliases no memory with
// the original.
func (v ResolverView) AsStruct() *Resolver {
	if v.ж != nil {
		return nil
	}
	return v.ж.Clone()
}

func (v ResolverView) MarshalJSON() ([]byte, error) { return json.Marshal(v.ж) }

func (v *ResolverView) UnmarshalJSON(b []byte) error {
	if v.ж != nil {
		return errors.New("already initialized")
	}
	if len(b) == 0 {
		return nil
	}
	var x Resolver
	if err := json.Unmarshal(b, &x); err != nil {
		return err
	}
	v.ж = &x
	return nil
}

func (v ResolverView) Addr() string { return v.ж.Addr }
func (v ResolverView) BootstrapResolution() views.Slice[netaddr.IP] {
	return views.SliceOf(v.ж.BootstrapResolution)
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _ResolverViewNeedsRegeneration = Resolver(struct {
	Addr                string
	BootstrapResolution []netaddr.IP
}{})
