// Code generated by github.com/abhimanyu003/sttr/cmd/generate.go. DO NOT EDIT

package cmd

import (
	"fmt"
	"os"

	"github.com/abhimanyu003/sttr/processors"
	"github.com/abhimanyu003/sttr/utils"
	"github.com/spf13/cobra"
)

var extractEmails_flag_s string

func init() {
	extractEmailsCmd.Flags().StringVarP(&extractEmails_flag_s, "separator", "s", "", "Separator to split multiple emails")
	rootCmd.AddCommand(extractEmailsCmd)
}

var extractEmailsCmd = &cobra.Command{
	Use:     "extract-emails [string]",
	Short:   "Extract emails from given text",
	Aliases: []string{"find-emails", "find-email", "extract-email"},
	Args:    cobra.MaximumNArgs(1),
	RunE: func(cmd *cobra.Command, args []string) error {
		var err error
		var out string

		flags := make([]processors.Flag, 0)
		p := processors.ExtractEmails{}
		flags = append(flags, processors.Flag{Short: "s", Value: extractEmails_flag_s})

		if len(args) == 0 {
			// Handle stdin/interactive input
			in := []byte(utils.ReadMultilineInput())
			out, err = p.Transform(in, flags...)
			if err != nil {
				return err
			}
		} else {
			// Check if it's a file
			if fi, err := os.Stat(args[0]); err == nil && !fi.IsDir() {
				// It's a file - check if we should use streaming
				const largeFileThreshold = 10 * 1024 * 1024 // 10MB
				
				// Use central streaming function for all processors
				if processors.CanStream(p) && (fi.Size() > largeFileThreshold || processors.PreferStream(p)) {
					// Use streaming
					file, err := os.Open(args[0])
					if err != nil {
						return err
					}
					defer file.Close()
					
					err = processors.TransformStream(p, file, os.Stdout, flags...)
					return err
				} else {
					// Use traditional method for small files
					d, err := os.ReadFile(args[0])
					if err != nil {
						return err
					}
					out, err = p.Transform(d, flags...)
					if err != nil {
						return err
					}
				}
			} else {
				// Not a file, treat as string input
				out, err = p.Transform([]byte(args[0]), flags...)
				if err != nil {
					return err
				}
			}
		}

		_, err = fmt.Fprint(os.Stdout, out)
		return err
	},
}
