// Code generated by github.com/abhimanyu003/sttr/cmd/generate.go. DO NOT EDIT

package cmd

import (
	"fmt"
	"os"

	"github.com/abhimanyu003/sttr/processors"
	"github.com/abhimanyu003/sttr/utils"
	"github.com/spf13/cobra"
)

var base64UrlEncode_flag_r bool

func init() {	
	base64UrlEncodeCmd.Flags().BoolVarP(&base64UrlEncode_flag_r, "raw", "r", false, "unpadded base64 encoding")
	rootCmd.AddCommand(base64UrlEncodeCmd)
}

var base64UrlEncodeCmd = &cobra.Command{
	Use:     "base64url-encode [string]",
	Short:   "Encode your text to Base64 with URL Safe",
	Aliases: []string{"b64url-enc", "b64url-encode"},
	Args:    cobra.MaximumNArgs(1),
	RunE: func(cmd *cobra.Command, args []string) error {
		var err error
		var in []byte
		var out string

		if len(args) == 0 {
			in = []byte(utils.ReadMultilineInput())
		} else {
			if fi, err := os.Stat(args[0]); err == nil && !fi.IsDir() {
				d, err := os.ReadFile(args[0])
				if err != nil {
					return err
				}
				in = d
			} else {
				in = []byte(args[0])
			}
		}

		flags := make([]processors.Flag, 0)
		p := processors.Base64URLEncode{}
		flags = append(flags, processors.Flag{Short: "r", Value: base64UrlEncode_flag_r})

		out, err = p.Transform(in, flags...)
		if err != nil {
			return err
		}

		_, err = fmt.Fprint(os.Stdout, out)
		return err
	},
}
