---
title: sttr
---
## sttr

sttr is a fast and flexible string/text converter

### Synopsis

sttr is a command line tool that allows you to quickly apply various
transformation operations on the input text.

Complete documentation is available at https://github.com/abhimanyu003/sttr

```
sttr [flags]
```

### Options

```
  -h, --help   help for sttr
```

### SEE ALSO

* [sttr base32-decode]({{< relref "sttr_base32-decode.md" >}})	 - Decode your Base32 text
* [sttr base32-encode]({{< relref "sttr_base32-encode.md" >}})	 - Encode your text to Base32
* [sttr base64-decode]({{< relref "sttr_base64-decode.md" >}})	 - Decode your Base64 text
* [sttr base64-encode]({{< relref "sttr_base64-encode.md" >}})	 - Encode your text to Base64
* [sttr bcrypt]({{< relref "sttr_bcrypt.md" >}})	 - Get the bcrypt hash of your text
* [sttr camel]({{< relref "sttr_camel.md" >}})	 - Transform your text to CamelCase
* [sttr completion]({{< relref "sttr_completion.md" >}})	 - generate the autocompletion script for the specified shell
* [sttr count-chars]({{< relref "sttr_count-chars.md" >}})	 - Find the length of your text (including spaces)
* [sttr count-lines]({{< relref "sttr_count-lines.md" >}})	 - Count the number of lines in your text
* [sttr count-words]({{< relref "sttr_count-words.md" >}})	 - Count the number of words in your text
* [sttr extract-emails]({{< relref "sttr_extract-emails.md" >}})	 - Extract emails from given text
* [sttr hex-encode]({{< relref "sttr_hex-encode.md" >}})	 - Encode your text Hex
* [sttr hex-rgb]({{< relref "sttr_hex-rgb.md" >}})	 - Convert a #hex-color code to RGB
* [sttr html-decode]({{< relref "sttr_html-decode.md" >}})	 - Unescape your HTML
* [sttr html-encode]({{< relref "sttr_html-encode.md" >}})	 - Escape your HTML
* [sttr interactive]({{< relref "sttr_interactive.md" >}})	 - Use sttr in interactive mode
* [sttr json]({{< relref "sttr_json.md" >}})	 - Format your text as JSON
* [sttr json-yaml]({{< relref "sttr_json-yaml.md" >}})	 - Convert JSON to YAML text
* [sttr kebab]({{< relref "sttr_kebab.md" >}})	 - Transform your text to kebab-case
* [sttr lower]({{< relref "sttr_lower.md" >}})	 - Transform your text to lower case
* [sttr markdown-html]({{< relref "sttr_markdown-html.md" >}})	 - Convert Markdown to HTML
* [sttr md5]({{< relref "sttr_md5.md" >}})	 - Get the MD5 checksum of your text
* [sttr reverse]({{< relref "sttr_reverse.md" >}})	 - Reverse Text ( txeT esreveR )
* [sttr rot13-encode]({{< relref "sttr_rot13-encode.md" >}})	 - Encode your text to ROT13
* [sttr sha1]({{< relref "sttr_sha1.md" >}})	 - Get the SHA-1 checksum of your text
* [sttr sha256]({{< relref "sttr_sha256.md" >}})	 - Get the SHA-256 checksum of your text
* [sttr sha512]({{< relref "sttr_sha512.md" >}})	 - Get the SHA-512 checksum of your text
* [sttr slug]({{< relref "sttr_slug.md" >}})	 - Transform your text to slug-case
* [sttr snake]({{< relref "sttr_snake.md" >}})	 - Transform your text to snake_case
* [sttr sort-lines]({{< relref "sttr_sort-lines.md" >}})	 - Sort lines alphabetically
* [sttr title]({{< relref "sttr_title.md" >}})	 - Transform your text to Title Case
* [sttr upper]({{< relref "sttr_upper.md" >}})	 - Transform your text to UPPER CASE
* [sttr url-decode]({{< relref "sttr_url-decode.md" >}})	 - Decode URL entities
* [sttr url-encode]({{< relref "sttr_url-encode.md" >}})	 - Encode URL entities
* [sttr version]({{< relref "sttr_version.md" >}})	 - Print the version of sttr
* [sttr yaml-json]({{< relref "sttr_yaml-json.md" >}})	 - Convert YAML to JSON text
* [sttr zeropad]({{< relref "sttr_zeropad.md" >}})	 - Pad a number with zeros

