// Code generated by github.com/abhimanyu003/sttr/cmd/generate.go. DO NOT EDIT

package cmd

import (
	"fmt"
	"os"

	"github.com/abhimanyu003/sttr/processors"
	"github.com/abhimanyu003/sttr/utils"
	"github.com/spf13/cobra"
)

var (
	escapeQuotes_flag_d bool
	escapeQuotes_flag_s bool
)

func init() {
	escapeQuotesCmd.Flags().BoolVarP(&escapeQuotes_flag_d, "double-quote", "d", true, "Escape double quote")
	escapeQuotesCmd.Flags().BoolVarP(&escapeQuotes_flag_s, "single-quote", "s", true, "Escape single quote")
	rootCmd.AddCommand(escapeQuotesCmd)
}

var escapeQuotesCmd = &cobra.Command{
	Use:     "escape-quotes [string]",
	Short:   "Escapes single and double quotes by default",
	Aliases: []string{"esc-quotes", "escape-quotes"},
	Args:    cobra.MaximumNArgs(1),
	RunE: func(cmd *cobra.Command, args []string) error {
		var err error
		var in []byte
		var out string

		if len(args) == 0 {
			in = []byte(utils.ReadMultilineInput())
		} else {
			if fi, err := os.Stat(args[0]); err == nil && !fi.IsDir() {
				d, err := os.ReadFile(args[0])
				if err != nil {
					return err
				}
				in = d
			} else {
				in = []byte(args[0])
			}
		}

		flags := make([]processors.Flag, 0)
		p := processors.EscapeQuotes{}
		flags = append(flags, processors.Flag{Short: "d", Value: escapeQuotes_flag_d})
		flags = append(flags, processors.Flag{Short: "s", Value: escapeQuotes_flag_s})

		out, err = p.Transform(in, flags...)
		if err != nil {
			return err
		}

		_, err = fmt.Fprint(os.Stdout, out)
		return err
	},
}
