## Description
At the Amazon S3 bucket level, you can configure permissions through a bucket policy making the objects accessible only through HTTPS.

## Rationale Statement
By default, Amazon S3 allows both HTTP and HTTPS requests. To achieve only allowing access to Amazon S3 objects through HTTPS you also have to explicitly deny access to HTTP requests. Bucket policies that allow HTTPS requests without explicitly denying HTTP requests will not comply with this recommendation.

## Remediation Procedure

### From Console:

1. Login to AWS Management Console and open the Amazon S3 console using https://console.aws.amazon.com/s3/
2. Select the Check box next to the Bucket.
3. Click on 'Permissions'.
4. Click 'Bucket Policy'
5. Add this to the existing policy filling in the required information
```
'{
            "Sid": <optional>,
            "Effect": "Deny",
            "Principal": "*",
            "Action": "s3:GetObject",
            "Resource": "arn:aws:s3:::<bucket_name>/*",
            "Condition": {
                "Bool": {
                    "aws:SecureTransport": "false"
                }'
```
6. Save
7. Repeat for all the buckets in your AWS account that contain sensitive data.

### Using AWS Policy Generator:

1. Repeat steps 1-4 above.
1. Click on Policy Generator at the bottom of the Bucket Policy Editor
1. Select Policy Type S3 Bucket Policy
1. Add Statements Effect = Deny Principal = * AWS Service = Amazon S3 Actions = GetObject Amazon Resource Name =
1. Generate Policy
1. Copy the text and add it to the Bucket Policy.

### From Command Line:

Export the bucket policy to a json file.
```bash
aws s3api get-bucket-policy --bucket <bucket_name> --query Policy --output text > policy.json
```

Modify the policy.json file by adding in this statement:
```
{
            "Sid": <optional>",
            "Effect": "Deny",
            "Principal": "*",
            "Action": "s3:GetObject",
            "Resource": "arn:aws:s3:::<bucket_name>/*",
            "Condition": {
                "Bool": {
                    "aws:SecureTransport": "false"
                }
            }
        }
```

Apply this modified policy back to the S3 bucket:
```bash
aws s3api put-bucket-policy --bucket <bucket_name> --policy file://policy.json
```

## References
- https://aws.amazon.com/premiumsupport/knowledge-center/s3-bucket-policy-for-config-rule/
- https://aws.amazon.com/blogs/security/how-to-use-bucket-policies-and-apply-defense-in-depth-to-help-secure-your-amazon-s3-data/
- https://awscli.amazonaws.com/v2/documentation/api/latest/reference/s3api/get-bucket-policy.html
