<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw instance`
This API allows you to manage your Instances.
  
- [Image management commands](#image-management-commands)
  - [Create an Instance image](#create-an-instance-image)
  - [Delete an Instance image](#delete-an-instance-image)
  - [Get an Instance image](#get-an-instance-image)
  - [List Instance images](#list-instance-images)
  - [Update image](#update-image)
  - [Wait for image to reach a stable state](#wait-for-image-to-reach-a-stable-state)
- [IP management commands](#ip-management-commands)
  - [Attach an IP to a given server](#attach-an-ip-to-a-given-server)
  - [Reserve a flexible IP](#reserve-a-flexible-ip)
  - [Delete a flexible IP](#delete-a-flexible-ip)
  - [Detach an ip from its server](#detach-an-ip-from-its-server)
  - [Get a flexible IP](#get-a-flexible-ip)
  - [List all flexible IPs](#list-all-flexible-ips)
  - [Update a flexible IP](#update-a-flexible-ip)
- [Placement group management commands](#placement-group-management-commands)
  - [Create a placement group](#create-a-placement-group)
  - [Delete the specified placement group](#delete-the-specified-placement-group)
  - [Get a placement group](#get-a-placement-group)
  - [Get placement group servers](#get-placement-group-servers)
  - [List placement groups](#list-placement-groups)
  - [Set placement group](#set-placement-group)
  - [Set placement group servers](#set-placement-group-servers)
  - [Update a placement group](#update-a-placement-group)
  - [Update placement group servers](#update-placement-group-servers)
- [Private NIC management commands](#private-nic-management-commands)
  - [Create a private NIC connecting an Instance to a Private Network](#create-a-private-nic-connecting-an-instance-to-a-private-network)
  - [Delete a private NIC](#delete-a-private-nic)
  - [Get a private NIC](#get-a-private-nic)
  - [List all private NICs](#list-all-private-nics)
  - [Update a private NIC](#update-a-private-nic)
- [Security group management commands](#security-group-management-commands)
  - [Remove all rules of a security group](#remove-all-rules-of-a-security-group)
  - [Create a security group](#create-a-security-group)
  - [Create rule](#create-rule)
  - [Delete a security group](#delete-a-security-group)
  - [Delete rule](#delete-rule)
  - [Edit all rules of a security group](#edit-all-rules-of-a-security-group)
  - [Get a security group](#get-a-security-group)
  - [Get rule](#get-rule)
  - [List security groups](#list-security-groups)
  - [Get default rules](#get-default-rules)
  - [List rules](#list-rules)
  - [Update all the rules of a security group](#update-all-the-rules-of-a-security-group)
  - [Update a security group](#update-a-security-group)
  - [Update security group rule](#update-security-group-rule)
- [Instance management commands](#instance-management-commands)
  - [Perform a raw API action on a server](#perform-a-raw-api-action-on-a-server)
  - [Attach an IP to a server](#attach-an-ip-to-a-server)
  - [Attach a volume to a server](#attach-a-volume-to-a-server)
  - [Backup server](#backup-server)
  - [Connect to the serial console of an instance](#connect-to-the-serial-console-of-an-instance)
  - [Create server](#create-server)
  - [Delete server](#delete-server)
  - [Detach an IP from a server](#detach-an-ip-from-a-server)
  - [Detach a volume from its server](#detach-a-volume-from-its-server)
  - [Migrate server to IP mobility](#migrate-server-to-ip-mobility)
  - [Get an Instance](#get-an-instance)
  - [Get your server rdp password and decrypt it using your ssh key](#get-your-server-rdp-password-and-decrypt-it-using-your-ssh-key)
  - [List all Instances](#list-all-instances)
  - [List Instance actions](#list-instance-actions)
  - [Reboot server](#reboot-server)
  - [SSH into a server](#ssh-into-a-server)
  - [Put server in standby mode](#put-server-in-standby-mode)
  - [Power on server](#power-on-server)
  - [Power off server](#power-off-server)
  - [Terminate server](#terminate-server)
  - [Update an Instance](#update-an-instance)
  - [Wait for server to reach a stable state](#wait-for-server-to-reach-a-stable-state)
- [Instance type management commands](#instance-type-management-commands)
  - [Get availability](#get-availability)
  - [List Instance types](#list-instance-types)
- [Snapshot management commands](#snapshot-management-commands)
  - [Migrate a volume and/or snapshots to SBS (Scaleway Block Storage)](#migrate-a-volume-andor-snapshots-to-sbs-(scaleway-block-storage))
  - [Create a snapshot from a specified volume or from a QCOW2 file](#create-a-snapshot-from-a-specified-volume-or-from-a-qcow2-file)
  - [Delete a snapshot](#delete-a-snapshot)
  - [Export a snapshot](#export-a-snapshot)
  - [Get a snapshot](#get-a-snapshot)
  - [List snapshots](#list-snapshots)
  - [Get a volume or snapshot's migration plan](#get-a-volume-or-snapshot's-migration-plan)
  - [Update a snapshot](#update-a-snapshot)
  - [Wait for snapshot to reach a stable state](#wait-for-snapshot-to-reach-a-stable-state)
- [SSH Utilities](#ssh-utilities)
  - [Add a public key to a server](#add-a-public-key-to-a-server)
  - [Install a ssh config with all your servers as host
It generate hosts for instance servers, baremetal, apple-silicon and bastions](#install-a-ssh-config-with-all-your-servers-as-host
it-generate-hosts-for-instance-servers,-baremetal,-apple-silicon-and-bastions)
  - [List manually added public keys](#list-manually-added-public-keys)
  - [Remove a manually added public key from a server](#remove-a-manually-added-public-key-from-a-server)
- [User data management commands](#user-data-management-commands)
  - [Delete user data](#delete-user-data)
  - [Get user data](#get-user-data)
  - [List user data](#list-user-data)
  - [Add/set user data](#addset-user-data)
- [Volume management commands](#volume-management-commands)
  - [Migrate a volume and/or snapshots to SBS (Scaleway Block Storage)](#migrate-a-volume-andor-snapshots-to-sbs-(scaleway-block-storage))
  - [Create a volume](#create-a-volume)
  - [Delete a volume](#delete-a-volume)
  - [Get a volume](#get-a-volume)
  - [List volumes](#list-volumes)
  - [Get a volume or snapshot's migration plan](#get-a-volume-or-snapshot's-migration-plan)
  - [Update a volume](#update-a-volume)
  - [Wait for volume to reach a stable state](#wait-for-volume-to-reach-a-stable-state)
- [Volume type management commands](#volume-type-management-commands)
  - [List volume types](#list-volume-types)

  
## Image management commands

Images are backups of your Instances.
One image will contain all the volumes of your Instance and can be used to restore your Instance and its data. You can also use it to create a series of Instances with a predefined configuration.
To copy not all but only one specified volume of an Instance, you can use the snapshot feature instead.


### Create an Instance image

Create an Instance image from the specified snapshot ID.

**Usage:**

```
scw instance image create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` | Name of the image |
| snapshot-id | Required | UUID of the snapshot that will be used as root volume in the image |
| arch | Required<br />One of: `unknown_arch`, `x86_64`, `arm`, `arm64` | Architecture of the image |
| additional-volumes.{index}.id |  | UUID of the snapshot to add |
| additional-volumes.{index}.name |  | Name of the additional snapshot |
| additional-volumes.{index}.size |  | Size of the additional snapshot |
| additional-volumes.{index}.volume-type | One of: `l_ssd`, `b_ssd`, `unified`, `scratch`, `sbs_volume`, `sbs_snapshot` | Underlying volume type of the additional snapshot |
| additional-volumes.{index}.project-id |  | Project ID that own the additional snapshot |
| ~~additional-volumes.{index}.organization-id~~ | Deprecated | Organization ID that own the additional snapshot |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| tags.{index} |  | Tags of the image |
| public |  | True to create a public image |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create an image named 'foobar' for x86_64 Instances from the specified snapshot ID
```
scw instance server image create name=foobar snapshot-id=11111111-1111-1111-1111-111111111111 arch=x86_64
```




### Delete an Instance image

Delete the image with the specified ID.

**Usage:**

```
scw instance image delete <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id | Required | UUID of the image you want to delete |
| with-snapshots |  | Delete the snapshots attached to this image |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete an image in the default zone with the specified ID
```
scw instance image delete 11111111-1111-1111-1111-111111111111
```

Delete an image in fr-par-1 zone with the specified ID
```
scw instance image delete 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Get an Instance image

Get details of an image with the specified ID.

**Usage:**

```
scw instance image get <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id | Required | UUID of the image you want to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get an image in the default zone with the specified ID
```
scw instance image get 11111111-1111-1111-1111-111111111111
```

Get an image in fr-par-1 zone with the specified ID
```
scw instance image get 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### List Instance images

List all existing Instance images.

**Usage:**

```
scw instance image list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  |  |
| public |  |  |
| arch |  |  |
| project-id |  |  |
| tags |  |  |
| organization-id |  |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all public images in the default zone
```
scw instance image list
```




### Update image

Update the properties of an image.

**Usage:**

```
scw instance image update <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id | Required | UUID of the image |
| name |  | Name of the image |
| arch | One of: `unknown_arch`, `x86_64`, `arm`, `arm64` | Architecture of the image |
| extra-volumes.{key}.id |  | UUID of the snapshot |
| tags.{index} |  | Tags of the image |
| public |  | True to set the image as public |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Wait for image to reach a stable state

Wait for image to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the image.

**Usage:**

```
scw instance image wait <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id | Required | ID of the image. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |
| timeout | Default: `1h0m0s` | Timeout of the wait |


**Examples:**


Wait for a image to reach a stable state
```
scw instance image wait 11111111-1111-1111-1111-111111111111
```




## IP management commands

A flexible IP address is an IP address which you hold independently of any Instance.
You can attach it to any of your Instances and do live migration of the IP address between your Instances.

Note that attaching a flexible IP address to an Instance removes its previous public IP and interrupts any ongoing public connection to the Instance. This does not apply if you have migrated your server to the new Network stack and have at least one flexible IP attached to the Instance.


### Attach an IP to a given server

Attach an IP to a given server.

**Usage:**

```
scw instance ip attach <ip ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip | Required | IP or UUID of the IP. |
| server-id | Required | UUID of the server to attach the IP to |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Attach an IP to the given server
```
scw instance ip attach 1.2.3.4 server-id=11111111-1111-1111-1111-111111111111
```




### Reserve a flexible IP

Reserve a flexible IP and attach it to the specified Instance.

**Usage:**

```
scw instance ip create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| tags.{index} |  | Tags of the IP |
| server |  | UUID of the Instance you want to attach the IP to |
| type | One of: `unknown_iptype`, `nat`, `routed_ipv4`, `routed_ipv6` | IP type to reserve (either 'routed_ipv4' or 'routed_ipv6', use of 'nat' is deprecated) |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create an IP in the default zone
```
scw instance ip create
```

Create an IP in fr-par-1 zone
```
scw instance ip create zone=fr-par-1
```

Create an IP and attach it to the specified Instance
```
scw instance ip create server=11111111-1111-1111-1111-111111111111
```




### Delete a flexible IP

Delete the IP with the specified ID.

**Usage:**

```
scw instance ip delete <ip ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip | Required | ID or address of the IP to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete an IP in the default zone with the specified ID
```
scw instance ip delete 11111111-1111-1111-1111-111111111111
```

Delete an IP in fr-par-1 zone with the specified ID
```
scw instance ip delete 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```

Delete an IP using directly the specified IP address
```
scw instance ip delete 51.15.253.183
```




### Detach an ip from its server

Detach an ip from its server.

**Usage:**

```
scw instance ip detach <ip ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip | Required | IP or UUID of the IP. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Detach an IP by using its UUID
```
scw instance ip detach 11111111-1111-1111-1111-111111111111
```

Detach an IP by using its IP address
```
scw instance ip detach 1.2.3.4
```




### Get a flexible IP

Get details of an IP with the specified ID or address.

**Usage:**

```
scw instance ip get <ip ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip | Required | IP ID or address to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get an IP in the default zone with the specified ID
```
scw instance ip get 11111111-1111-1111-1111-111111111111
```

Get an IP in fr-par-1 zone with the specified ID
```
scw instance ip get 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```

Get an IP, directly using the specified IP address
```
scw instance ip get 51.15.253.183
```




### List all flexible IPs

List all flexible IPs in a specified zone.

**Usage:**

```
scw instance ip list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID in which the IPs are reserved |
| tags |  | Filter IPs with these exact tags (to filter with several tags, use commas to separate them) |
| name |  | Filter on the IP address (Works as a LIKE operation on the IP address) |
| type |  | Filter on the IP Mobility IP type (whose value should be either 'routed_ipv4', 'routed_ipv6' or 'nat') |
| organization-id |  | Organization ID in which the IPs are reserved |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all IPs in the default zone
```
scw instance ip list
```

List all IPs in fr-par-1 zone
```
scw instance ip list zone=fr-par-1
```




### Update a flexible IP

Update a flexible IP in the specified zone with the specified ID.

**Usage:**

```
scw instance ip update <ip ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip | Required | IP ID or IP address |
| reverse |  | Reverse domain name |
| type | One of: `unknown_iptype`, `nat`, `routed_ipv4`, `routed_ipv6` | Convert a 'nat' IP to a 'routed_ipv4' |
| tags.{index} |  | An array of keywords you want to tag this IP with |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Update an IP in the default zone with the specified ID
```
scw instance ip update 11111111-1111-1111-1111-111111111111 reverse=example.com
```

Update an IP in fr-par-1 zone with the specified ID
```
scw instance ip update 11111111-1111-1111-1111-111111111111 zone=fr-par-1 reverse=example.com
```

Update an IP using directly the specified IP address
```
scw instance ip update 51.15.253.183 reverse=example.com
```




## Placement group management commands

Placement groups allow the user to express a preference regarding
the physical position of a group of Instances. The feature lets the user
choose to either group Instances on the same physical hardware for
best network throughput and low latency or to spread Instances across
physically distanced hardware to reduce the risk of physical failure.

The operating mode is selected by a `policy_type`. Two policy
types are available:
  - `low_latency` will group Instances on the same hypervisors
  - `max_availability` will spread Instances across physically distanced hypervisors

The `policy_type` is set to `max_availability` by default.

For each policy types, one of the two `policy_mode` may be selected:
  - `optional` will start your Instances even if the constraint is not respected
  - `enforced` guarantees that if the Instance starts, the constraint is respected

The `policy_mode` is set by default to `optional`.


### Create a placement group

Create a new placement group in a specified Availability Zone.

**Usage:**

```
scw instance placement-group create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` | Name of the placement group |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| tags.{index} |  | Tags of the placement group |
| policy-mode | One of: `optional`, `enforced` | Operating mode of the placement group |
| policy-type | One of: `max_availability`, `low_latency` | Policy type of the placement group |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create a placement group with default name
```
scw instance placement-group create
```

Create a placement group with the specified name
```
scw instance placement-group create name=foobar
```

Create an enforced placement group
```
scw instance placement-group create policy-mode=enforced
```

Create an optional placement group
```
scw instance placement-group create policy-mode=optional
```

Create an optional low latency placement group
```
scw instance placement-group create policy-mode=optional policy-type=low_latency
```

Create an enforced low latency placement group
```
scw instance placement-group create policy-mode=enforced policy-type=low_latency
```




### Delete the specified placement group

Delete the specified placement group.

**Usage:**

```
scw instance placement-group delete <placement-group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| placement-group-id | Required | UUID of the placement group you want to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete a placement group in the default zone with the specified ID
```
scw instance placement-group delete 11111111-1111-1111-1111-111111111111
```

Delete a placement group in fr-par-1 zone with the specified ID
```
scw instance placement-group delete 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Get a placement group

Get the specified placement group.

**Usage:**

```
scw instance placement-group get <placement-group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| placement-group-id | Required | UUID of the placement group you want to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get a placement group with the specified ID
```
scw instance placement-group get 6c15f411-3b6f-402d-8eba-ae24ef9254e9
```




### Get placement group servers

Get all Instances belonging to the specified placement group.

**Usage:**

```
scw instance placement-group get-servers <placement-group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| placement-group-id | Required | UUID of the placement group you want to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### List placement groups

List all placement groups in a specified Availability Zone.

**Usage:**

```
scw instance placement-group list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | List only placement groups of this Project ID |
| tags |  | List placement groups with these exact tags (to filter with several tags, use commas to separate them) |
| name |  | Filter placement groups by name (for eg. "cluster1" will return "cluster100" and "cluster1" but not "foo") |
| organization-id |  | List only placement groups of this Organization ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all placement groups in the default zone
```
scw instance placement-group list
```

List placement groups that match a specified name ('cluster1' will return 'cluster100' and 'cluster1' but not 'foo')
```
scw instance placement-group list name=cluster1
```




### Set placement group

Set all parameters of the specified placement group.

**Usage:**

```
scw instance placement-group set [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| placement-group-id | Required |  |
| name |  |  |
| policy-mode | One of: `optional`, `enforced` |  |
| policy-type | One of: `max_availability`, `low_latency` |  |
| project |  | Project ID to use. If none is passed the default project ID will be used |
| tags.{index} |  |  |
| organization |  | Organization ID to use. If none is passed the default organization ID will be used |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Set placement group servers

Set all Instances belonging to the specified placement group.

**Usage:**

```
scw instance placement-group set-servers [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| placement-group-id | Required | UUID of the placement group you want to set |
| servers.{index} | Required | An array of the Instances' UUIDs you want to configure |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Update the complete set of Instances in a specified placement group (all Instances must be shut down)
```
scw instance placement-group set-servers placement-group-id=ced0fd4d-bcf0-4479-85b6-7027e54456e6 servers.0=5a250608-24ec-4c31-9631-b3ded8c861cb servers.1=e54fd249-0787-4794-ab14-af6ee74df274
```




### Update a placement group

Update one or more parameter of the specified placement group.

**Usage:**

```
scw instance placement-group update <placement-group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| placement-group-id | Required | UUID of the placement group |
| name |  | Name of the placement group |
| tags.{index} |  | Tags of the placement group |
| policy-mode | One of: `optional`, `enforced` | Operating mode of the placement group |
| policy-type | One of: `max_availability`, `low_latency` | Policy type of the placement group |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Update the name of a placement group
```
scw instance placement-group update 95053f33-cd3c-4cdc-b2b0-57d2dda97b13 name=foobar
```

Update the policy mode of a placement group (all Instances in your placement group MUST be shut down)
```
scw instance placement-group update 1f883434-8c2d-40f0-b686-d0754b3a7bc0 policy-mode=enforced
```

Update the policy type of a placement group (all Instances in your placement group MUST be shutdown)
```
scw instance placement-group update 0954ec26-9917-47b6-8c5c-7bc81d7bb9d2 policy-type=low_latency
```




### Update placement group servers

Update all Instances belonging to the specified placement group.

**Usage:**

```
scw instance placement-group update-servers [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| placement-group-id | Required | UUID of the placement group you want to update |
| servers.{index} | Required | An array of the Instances' UUIDs you want to configure |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



## Private NIC management commands

A Private NIC is the network interface that connects an Instance to a
Private Network. An Instance can have multiple private NICs at the same
time, but each NIC must belong to a different Private Network.


### Create a private NIC connecting an Instance to a Private Network

Create a private NIC connecting an Instance to a Private Network.

**Usage:**

```
scw instance private-nic create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the Instance the private NIC will be attached to |
| private-network-id | Required | UUID of the private network where the private NIC will be attached |
| tags.{index} |  | Private NIC tags |
| ~~ip-ids.{index}~~ | Deprecated | Ip_ids defined from IPAM |
| ipam-ip-ids.{index} |  | UUID of IPAM ips, to be attached to the instance in the requested private network |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Delete a private NIC

Delete a private NIC.

**Usage:**

```
scw instance private-nic delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Instance to which the private NIC is attached |
| private-nic-id | Required | Private NIC unique ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Get a private NIC

Get private NIC properties.

**Usage:**

```
scw instance private-nic get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Instance to which the private NIC is attached |
| private-nic-id | Required | The private NIC unique ID or MAC address |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### List all private NICs

List all private NICs of a specified Instance.

**Usage:**

```
scw instance private-nic list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Instance to which the private NIC is attached |
| tags |  | Private NIC tags |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all private NICs on a specified server
```
scw instance private-nic list
```

List private NICs of the Instance ID 'my_server_id'
```
scw instance private-nic list server-id=my_server_id
```




### Update a private NIC

Update one or more parameter(s) of a specified private NIC.

**Usage:**

```
scw instance private-nic update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the Instance the private NIC will be attached to |
| private-nic-id | Required | Private NIC unique ID |
| tags.{index} |  | Tags used to select private NIC/s |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Update tags of a private NIC
```
scw instance private-nic update server-id=11111111-1111-1111-1111-111111111111 private-nic-id=11111111-1111-1111-1111-111111111111 tags.0=foo tags.1=bar
```




## Security group management commands

A security group is a set of firewall rules on a set of Instances.
Security groups enable you to create rules that either drop or allow incoming traffic from certain ports of your Instances.

Security groups are stateful by default which means return traffic is automatically allowed, regardless of any rules.
As a contrary, you have to switch in a stateless mode to define explicitly allowed.


### Remove all rules of a security group



**Usage:**

```
scw instance security-group clear [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required | ID of the security group to reset. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Remove all rules of the given security group
```
scw instance security-group clear security-group-id=11111111-1111-1111-1111-111111111111
```




### Create a security group

Create a security group with a specified name and description.

**Usage:**

```
scw instance security-group create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Name of the security group |
| description |  | Description of the security group |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| tags.{index} |  | Tags of the security group |
| ~~organization-default~~ | Deprecated | Defines whether this security group becomes the default security group for new Instances |
| project-default |  | Whether this security group becomes the default security group for new Instances |
| stateful | Default: `true` | Whether the security group is stateful or not |
| inbound-default-policy | Default: `accept`<br />One of: `unknown_policy`, `accept`, `drop` | Default policy for inbound rules |
| outbound-default-policy | Default: `accept`<br />One of: `unknown_policy`, `accept`, `drop` | Default policy for outbound rules |
| enable-default-security |  | True to block SMTP on IPv4 and IPv6. This feature is read only, please open a support ticket if you need to make it configurable |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create a security group with a specified name and description
```
scw instance security-group create name=foobar description=foobar foobar
```

Create a security group that will be applied as default on all Instances of this Project
```
scw instance security-group create project-default=true
```

Create a security group that will have a default drop inbound policy (traffic your Instance receives)
```
scw instance security-group create inbound-default-policy=drop
```

Create a security group that will have a default drop outbound policy (traffic your Instance transmits)
```
scw instance security-group create outbound-default-policy=drop
```

Create a stateless security group
```
scw instance security-group create
```




### Create rule

Create a rule in the specified security group ID.

**Usage:**

```
scw instance security-group create-rule [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required | UUID of the security group |
| protocol | Required<br />One of: `unknown_protocol`, `TCP`, `UDP`, `ICMP`, `ANY` |  |
| direction | Required<br />One of: `unknown_direction`, `inbound`, `outbound` |  |
| action | Required<br />One of: `unknown_action`, `accept`, `drop` |  |
| ip-range | Required<br />Default: `0.0.0.0/0` |  |
| dest-port-from |  | Beginning of the range of ports to apply this rule to (inclusive) |
| dest-port-to |  | End of the range of ports to apply this rule to (inclusive) |
| position |  | Position of this rule in the security group rules list |
| editable |  | Indicates if this rule is editable (will be ignored) |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Allow incoming SSH
```
scw instance security-group create-rule security-group-id=1248283f-17de-464a-b03b-3f975ada3fa8 protocol=TCP direction=inbound action=accept ip-range=<nil> dest-port-from=22
```

Allow HTTP
```
scw instance security-group create-rule security-group-id=e8ba77c1-9ccb-4c0c-b08d-555cfd7f57e4 protocol=TCP direction=inbound action=accept ip-range=<nil> dest-port-from=80
```

Allow HTTPS
```
scw instance security-group create-rule security-group-id=e5906437-8650-4fe2-8ca7-32e1d7320c1b protocol=TCP direction=inbound action=accept ip-range=<nil> dest-port-from=443
```

Allow a specified IP range
```
scw instance security-group create-rule security-group-id=b6a58155-a2f8-48bd-9da9-3ff9783fa0d4 protocol=ANY direction=inbound action=accept ip-range=10.0.0.0/16
```

Allow FTP
```
scw instance security-group create-rule security-group-id=9c46df03-83c2-46fb-936c-16ecb44860e1 protocol=TCP direction=inbound action=accept ip-range=<nil> dest-port-from=20 dest-port-to=21
```




### Delete a security group

Delete a security group with the specified ID.

**Usage:**

```
scw instance security-group delete <security-group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required | UUID of the security group you want to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete the security group with the specified ID
```
scw instance security-group delete 69e17c83-9945-47ac-8b29-8c1ad050ee83
```




### Delete rule

Delete a security group rule with the specified ID.

**Usage:**

```
scw instance security-group delete-rule [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required |  |
| security-group-rule-id | Required |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete a security group rule with the specified ID
```
scw instance security-group delete-rule security-group-id=a01a36e5-5c0c-42c1-ae06-167e587b7ac4 security-group-rule-id=b8c773ef-a6ea-4b50-a7c1-737864290a3f
```




### Edit all rules of a security group

This command starts your default editor to edit a marshaled version of your resource
Default editor will be taken from $VISUAL, then $EDITOR or an editor based on your system

**Usage:**

```
scw instance security-group edit <security-group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required | ID of the security group to reset. |
| mode | Default: `yaml`<br />One of: `yaml`, `json` | marshaling used when editing data |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Get a security group

Get the details of a security group with the specified ID.

**Usage:**

```
scw instance security-group get <security-group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required | UUID of the security group you want to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get a security group with the specified ID
```
scw instance security-group get a3244331-5d32-4e36-9bf9-b60233e201c7
```




### Get rule

Get details of a security group rule with the specified ID.

**Usage:**

```
scw instance security-group get-rule [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required |  |
| security-group-rule-id | Required |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get details of a security group rule with the specified ID
```
scw instance security-group get-rule security-group-id=d900fa38-2f0d-4b09-b6d7-f3e46a13f34c security-group-rule-id=1f9a16a5-7229-4c03-9327-253e257cf38a
```




### List security groups

List all existing security groups.

**Usage:**

```
scw instance security-group list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Name of the security group |
| project-id |  | Security group Project ID |
| tags |  | List security groups with these exact tags (to filter with several tags, use commas to separate them) |
| project-default |  | Filter security groups with this value for project_default |
| organization-id |  | Security group Organization ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all security groups that match the specified name
```
scw instance security-group list name=foobar
```




### Get default rules

Lists the default rules applied to all the security groups.

**Usage:**

```
scw instance security-group list-default-rules [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### List rules

List the rules of the a specified security group ID.

**Usage:**

```
scw instance security-group list-rules [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required | UUID of the security group |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update all the rules of a security group

Replaces the existing rules of the security group with the rules provided. This endpoint supports the update of existing rules, creation of new rules and deletion of existing rules when they are not passed in the request.

**Usage:**

```
scw instance security-group set-rules [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required | UUID of the security group to update the rules on |
| rules.{index}.id |  | UUID of the security rule to update. If no value is provided, a new rule will be created |
| rules.{index}.action | One of: `unknown_action`, `accept`, `drop` | Action to apply when the rule matches a packet |
| rules.{index}.protocol | One of: `unknown_protocol`, `TCP`, `UDP`, `ICMP`, `ANY` | Protocol family this rule applies to |
| rules.{index}.direction | One of: `unknown_direction`, `inbound`, `outbound` | Direction the rule applies to |
| rules.{index}.ip-range |  | Range of IP addresses these rules apply to |
| rules.{index}.dest-port-from |  | Beginning of the range of ports this rule applies to (inclusive). This value will be set to null if protocol is ICMP or ANY |
| rules.{index}.dest-port-to |  | End of the range of ports this rule applies to (inclusive). This value will be set to null if protocol is ICMP or ANY, or if it is equal to dest_port_from |
| rules.{index}.position |  | Position of this rule in the security group rules list. If several rules are passed with the same position, the resulting order is undefined |
| rules.{index}.editable |  | Indicates if this rule is editable. Rules with the value false will be ignored |
| rules.{index}.zone |  | Zone of the rule. This field is ignored |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Update a security group

Update the properties of security group.

**Usage:**

```
scw instance security-group update <security-group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required | UUID of the security group |
| name |  | Name of the security group |
| description |  | Description of the security group |
| enable-default-security |  | True to block SMTP on IPv4 and IPv6. This feature is read only, please open a support ticket if you need to make it configurable |
| inbound-default-policy | One of: `unknown_policy`, `accept`, `drop` | Default inbound policy |
| tags.{index} |  | Tags of the security group |
| ~~organization-default~~ | Deprecated | Please use project_default instead |
| project-default |  | True use this security group for future Instances created in this project |
| outbound-default-policy | One of: `unknown_policy`, `accept`, `drop` | Default outbound policy |
| stateful |  | True to set the security group as stateful |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Update security group rule

Update the properties of a rule from a specified security group.

**Usage:**

```
scw instance security-group update-rule [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required | UUID of the security group |
| security-group-rule-id | Required | UUID of the rule |
| protocol | One of: `unknown_protocol`, `TCP`, `UDP`, `ICMP`, `ANY` | Protocol family this rule applies to |
| direction | One of: `unknown_direction`, `inbound`, `outbound` | Direction the rule applies to |
| action | One of: `unknown_action`, `accept`, `drop` | Action to apply when the rule matches a packet |
| ip-range |  | Range of IP addresses these rules apply to |
| dest-port-from |  | Beginning of the range of ports this rule applies to (inclusive). If 0 is provided, unset the parameter. |
| dest-port-to |  | End of the range of ports this rule applies to (inclusive). If 0 is provided, unset the parameter. |
| position |  | Position of this rule in the security group rules list |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



## Instance management commands

Instances are computing units providing resources to run your applications on.
Scaleway offers various Instance types including **Virtual Instances** and **dedicated GPU Instances**.
**Note: Instances can be referenced as "servers" in API endpoints.**


### Perform a raw API action on a server



**Usage:**

```
scw instance server action <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| action | Required | The raw API action to perform, as listed with 'scw instance server list-actions' |
| server-id | Required | ID of the server affected by the action. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Start a server in the default zone with a given id
```
scw instance server action 11111111-1111-1111-1111-111111111111 action=poweron
```




### Attach an IP to a server



**Usage:**

```
scw instance server attach-ip <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| ip | Required | UUID of the IP to attach or its UUID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Attach an IP to a server
```
scw instance server attach-ip 11111111-1111-1111-1111-111111111111 ip=11111111-1111-1111-1111-111111111111
```

Attach an IP to a server
```
scw instance server attach-ip 11111111-1111-1111-1111-111111111111 ip=1.2.3.4
```




### Attach a volume to a server



**Usage:**

```
scw instance server attach-volume [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| volume-id | Required | ID of the volume to attach |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Attach a volume to a server
```
scw instance server attach-volume server-id=11111111-1111-1111-1111-111111111111 volume-id=22222222-1111-5555-2222-666666111111
```




### Backup server

Create a new image based on the server.

This command:
  - creates a snapshot of all attached volumes.
  - creates an image based on all these snapshots.

Once your image is ready you will be able to create a new server based on this image.


**Usage:**

```
scw instance server backup <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server to backup. |
| name | Default: `<generated>` | Name of your backup. |
| unified |  | Whether or not the type of the snapshot is unified. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create a new image based on a server
```
scw instance server backup 11111111-1111-1111-1111-111111111111
```




### Connect to the serial console of an instance



**Usage:**

```
scw instance server console <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to connect to |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Create server

Create an instance server.

**Usage:**

```
scw instance server create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image | Required<br />Default: `ubuntu_jammy` | Image ID or label of the server |
| type | Required | Server commercial type (help: https://www.scaleway.com/en/docs/compute/instances/reference-content/choosing-instance-type/) |
| name | Default: `<generated>` | Server name |
| root-volume |  | Local root volume of the server |
| additional-volumes.{index} |  | Additional local and block volumes attached to your server |
| ip | Default: `new` | Either an IP, an IP ID, ('new', 'ipv4', 'ipv6' or 'both') to create new IPs, 'dynamic' to use a dynamic IP or 'none' for no public IP (new | ipv4 | ipv6 | both | dynamic | none | <id> | <address>) |
| dynamic-ip-required | Default: `true` | Define if a dynamic IPv4 is required for the Instance. If server has no IPv4, a dynamic one will be allocated. |
| tags.{index} |  | Server tags |
| ipv6 |  | Enable IPv6, to be used with routed-ip-enabled=false |
| stopped |  | Do not start server after its creation |
| security-group-id |  | The security group ID used for this server |
| placement-group-id |  | The placement group ID in which the server has to be created |
| cloud-init |  | The cloud-init script to use |
| boot-type | Default: `local`<br />One of: `local`, `bootscript`, `rescue` | The boot type to use, if empty the local boot will be used. Will be overwritten to bootscript if bootscript-id is set. |
| admin-password-encryption-ssh-key-id |  | ID of the IAM SSH Key used to encrypt generated admin password. Required when creating a windows server. |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |


**Examples:**


Create and start an instance on Ubuntu Focal
```
scw instance server create image=ubuntu_focal
```

Create a GP1-XS instance, give it a name and add tags
```
scw instance server create image=ubuntu_focal type=GP1-XS name=foo tags.0=prod tags.1=blue
```

Create an instance with 2 additional block volumes (50GB and 100GB)
```
scw instance server create image=ubuntu_focal additional-volumes.0=block:50GB additional-volumes.1=block:100GB
```

Create an instance with 2 local volumes (10GB and 10GB)
```
scw instance server create image=ubuntu_focal root-volume=local:10GB additional-volumes.0=local:10GB
```

Create an instance with a SBS root volume (100GB and 15000 iops)
```
scw instance server create image=ubuntu_focal root-volume=sbs:100GB:15000
```

Create an instance with volumes from snapshots
```
scw instance server create image=ubuntu_focal root-volume=local:<snapshot_id> additional-volumes.0=block:<snapshot_id>
```

Create and start an instance from a snapshot
```
scw instance server create image=none root-volume=local:<snapshot_id>
```

Create and start an instance using existing volume
```
scw instance server create image=ubuntu_focal additional-volumes.0=<volume_id>
```

Use an existing IP
```
ip=$(scw instance ip create | grep id | awk '{ print $2 }')
scw instance server create image=ubuntu_focal ip=$ip
```




### Delete server

Delete a server with the given ID.

**Usage:**

```
scw instance server delete <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required |  |
| with-volumes | Default: `all`<br />One of: `none`, `local`, `block`, `root`, `all` | Delete the volumes attached to the server |
| with-ip |  | Delete the IP attached to the server |
| force-shutdown |  | Force shutdown of the instance server before deleting it |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete a server in the default zone with a given id
```
scw instance server delete 11111111-1111-1111-1111-111111111111
```

Delete a server in fr-par-1 zone with a given id
```
scw instance server delete 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Detach an IP from a server



**Usage:**

```
scw instance server detach-ip <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the server. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Detach IP from a given server
```
scw instance server detach-ip 11111111-1111-1111-1111-111111111111
```




### Detach a volume from its server



**Usage:**

```
scw instance server detach-volume [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | ID of the volume to detach |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Detach a volume from its server
```
scw instance server detach-volume volume-id=22222222-1111-5555-2222-666666111111
```




### Migrate server to IP mobility

Enable routed IP for this server and migrate the nat public IP to routed
Server will reboot !
https://www.scaleway.com/en/docs/compute/instances/api-cli/using-ip-mobility/


**Usage:**

```
scw instance server enable-routed-ip <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server affected by the action. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Migrate a server with legacy network to IP mobility
```
scw instance server enable-routed-ip 11111111-1111-1111-1111-111111111111
```




### Get an Instance

Get the details of a specified Instance.

**Usage:**

```
scw instance server get <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the Instance you want to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get the Instance with its specified ID
```
scw instance server get 94ededdf-358d-4019-9886-d754f8a2e78d
```




### Get your server rdp password and decrypt it using your ssh key



**Usage:**

```
scw instance server get-rdp-password <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to connect to |
| key | Default: `~/.ssh/id_rsa` | Path of the SSH key used to decrypt the rdp password |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |



### List all Instances

List all Instances in a specified Availability Zone, e.g. `fr-par-1`.

**Usage:**

```
scw instance server list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | List only Instances of this Project ID |
| name |  | Filter Instances by name (eg. "server1" will return "server100" and "server1" but not "foo") |
| ~~private-ip~~ | Deprecated | List Instances by private_ip |
| without-ip |  | List Instances that are not attached to a public IP |
| with-ip |  | List Instances by IP (both private_ip and public_ip are supported) |
| commercial-type |  | List Instances of this commercial type |
| state | One of: `running`, `stopped`, `stopped in place`, `starting`, `stopping`, `locked` | List Instances in this state |
| tags |  | List Instances with these exact tags (to filter with several tags, use commas to separate them) |
| private-network |  | List Instances in this Private Network |
| order | One of: `creation_date_desc`, `creation_date_asc`, `modification_date_desc`, `modification_date_asc` | Define the order of the returned servers |
| private-networks |  | List Instances from the given Private Networks (use commas to separate them) |
| private-nic-mac-address |  | List Instances associated with the given private NIC MAC address |
| servers |  | List Instances from these server ids (use commas to separate them) |
| organization-id |  | List only Instances of this Organization ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all Instances on your default zone
```
scw instance server list
```

List Instances of this commercial type
```
scw instance server list commercial-type=DEV1-S
```

List Instances that are not attached to a public IP
```
scw instance server list without-ip=true
```

List Instances that match the specified name ('server1' will return 'server100' and 'server1' but not 'foo')
```
scw instance server list name=server1
```




### List Instance actions

List all actions (e.g. power on, power off, reboot) that can currently be performed on an Instance.

**Usage:**

```
scw instance server list-actions [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Reboot server



**Usage:**

```
scw instance server reboot <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server affected by the action. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Reboot a server in the default zone with a given id
```
scw instance server reboot 11111111-1111-1111-1111-111111111111
```

Reboot a server in fr-par-1 zone with a given id
```
scw instance server reboot 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### SSH into a server

Connect to distant server via the SSH protocol.

**Usage:**

```
scw instance server ssh <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to SSH into |
| username | Default: `root` | Username used for the SSH connection |
| port | Default: `22` | Port used for the SSH connection |
| command |  | Command to execute on the remote server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Put server in standby mode



**Usage:**

```
scw instance server standby <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server affected by the action. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Put in standby a server in the default zone with a given id
```
scw instance server standby 11111111-1111-1111-1111-111111111111
```

Put in standby a server in fr-par-1 zone with a given id
```
scw instance server standby 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Power on server



**Usage:**

```
scw instance server start <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server affected by the action. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Start a server in the default zone with a given id
```
scw instance server start 11111111-1111-1111-1111-111111111111
```

Start a server in fr-par-1 zone with a given id
```
scw instance server start 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Power off server



**Usage:**

```
scw instance server stop <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server affected by the action. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Stop a server in the default zone with a given id
```
scw instance server stop 11111111-1111-1111-1111-111111111111
```

Stop a server in fr-par-1 zone with a given id
```
scw instance server stop 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Terminate server

Terminates a server with the given ID and all of its volumes.

**Usage:**

```
scw instance server terminate <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required |  |
| with-ip |  | Delete the IP attached to the server |
| with-block | Default: `prompt`<br />One of: `prompt`, `true`, `false` | Delete the Block Storage volumes attached to the server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Terminate a server in the default zone with a given id
```
scw instance server terminate 11111111-1111-1111-1111-111111111111
```

Terminate a server in fr-par-1 zone with a given id
```
scw instance server terminate 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```

Terminate a server and also delete its flexible IPs
```
scw instance server terminate 11111111-1111-1111-1111-111111111111 with-ip=true
```




### Update an Instance

Update the Instance information, such as name, boot mode, or tags.

**Usage:**

```
scw instance server update <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the Instance |
| name |  | Name of the Instance |
| ip |  | IP that should be attached to the server (use ip=none to detach) |
| cloud-init |  | The cloud-init script to use |
| boot-type | One of: `local`, `bootscript`, `rescue` |  |
| tags.{index} |  | Tags of the Instance |
| volumes.{key}.boot | Default: `false` | Force the Instance to boot on this volume |
| volumes.{key}.base-snapshot |  | ID of the snapshot on which this volume will be based |
| volumes.{key}.project |  | Project ID of the volume |
| volumes.{key}.organization |  | Organization ID of the volume |
| dynamic-ip-required |  |  |
| ~~routed-ip-enabled~~ | Deprecated | True to configure the instance so it uses the new routed IP mode (once this is set to True you cannot set it back to False) |
| public-ips.{index} |  | A list of reserved IP IDs to attach to the Instance |
| ~~enable-ipv6~~ | Deprecated |  |
| protected |  |  |
| security-group-id |  |  |
| volume-ids.{index} |  | Will update ALL volume IDs at once, including the root volume of the server (use volume-ids=none to detach all volumes) |
| placement-group-id |  | Placement group ID if Instance must be part of a placement group |
| private-nics.{index} |  | Instance private NICs |
| commercial-type |  | Set the commercial_type for this Instance. |
| admin-password-encryption-ssh-key-id |  | UUID of the SSH RSA key that will be used to encrypt the initial admin password for OS requiring it. Mandatory for Windows OS. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Update the name of a specified Instance
```
scw instance server update 11111111-1111-1111-1111-111111111111 name=foobar
```

Switch a specified Instance to rescue mode (reboot is required to access rescue mode)
```
scw instance server update 11111111-1111-1111-1111-111111111111 boot-type=rescue
```

Overwrite tags of a specified Instance
```
scw instance server update 11111111-1111-1111-1111-111111111111 tags.0=foo tags.1=bar
```

Apply the specified security group to a specified server
```
scw instance server server update 11111111-1111-1111-1111-111111111111 security-group-id=11111111-1111-1111-1111-111111111111
```

Put a specified Instance in the specified placement group. Instance must be off
```
scw instance server server update 11111111-1111-1111-1111-111111111111 placement-group-id=11111111-1111-1111-1111-111111111111
```




### Wait for server to reach a stable state

Wait for server to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the server.

**Usage:**

```
scw instance server wait <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| timeout | Default: `10m0s` | Timeout of the wait |
| server-id | Required | ID of the server affected by the action. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Wait for a server to reach a stable state
```
scw instance server wait 11111111-1111-1111-1111-111111111111
```




## Instance type management commands

All Instance types available in a specified zone.
Each type contains all the features of the Instance (CPU, RAM, Storage) as well as their associated pricing.


### Get availability

Get availability for all Instance types.

**Usage:**

```
scw instance server-type get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### List Instance types

List available Instance types and their technical details.

**Usage:**

```
scw instance server-type list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all server-types in the default zone
```
scw instance server-type list
```

List all server-types in fr-par-1 zone
```
scw instance server-type list zone=fr-par-1
```




## Snapshot management commands

Snapshots contain the data of a specified volume at a particular point in time.
The data can include the Instance's operating system,
configuration information and/or files stored on the volume.

A snapshot can be done from a specified volume, e.g. you
have one Instance with a volume containing the OS and another one
containing the application data, and you want to use different
snapshot strategies on both volumes.

A snapshot's volume type is its original volume's type (`l_ssd` or `b_ssd`).
Volumes can be created from snapshots of their own type.


### Migrate a volume and/or snapshots to SBS (Scaleway Block Storage)

To be used, the call to this endpoint must be preceded by a call to the [Get a volume or snapshot's migration plan](#path-volumes-get-a-volume-or-snapshots-migration-plan) endpoint. To migrate all resources mentioned in the migration plan, the validation_key returned in the plan must be provided.

**Usage:**

```
scw instance snapshot apply-migration <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id |  | The snapshot to migrate, along with potentially other resources, according to the migration plan generated with a call to the [Get a volume or snapshot's migration plan](#path-volumes-get-a-volume-or-snapshots-migration-plan) endpoint. |
| validation-key | Required | A value to be retrieved from a call to the [Get a volume or snapshot's migration plan](#path-volumes-get-a-volume-or-snapshots-migration-plan) endpoint, to confirm that the volume and/or snapshots specified in said plan should be migrated. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Create a snapshot from a specified volume or from a QCOW2 file

Create a snapshot from a specified volume or from a QCOW2 file in a specified Availability Zone.

**Usage:**

```
scw instance snapshot create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` | Name of the snapshot |
| volume-id |  | UUID of the volume |
| unified |  | Whether a snapshot is unified or not. |
| tags.{index} |  | Tags of the snapshot |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| bucket |  | Bucket name for snapshot imports |
| key |  | Object key for snapshot imports |
| size |  | Imported snapshot size, must be a multiple of 512 |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create a snapshot in the default zone from the specified volume ID
```
scw instance snapshot create volume-id=11111111-1111-1111-1111-111111111111
```

Create a snapshot in fr-par-1 zone from the specified volume ID
```
scw instance snapshot create zone=fr-par-1 volume-id=11111111-1111-1111-1111-111111111111
```

Create a named snapshot from the specified volume ID
```
scw instance snapshot create name=foobar volume-id=11111111-1111-1111-1111-111111111111
```

Import a QCOW file as an Instance snapshot
```
scw instance snapshot create zone=fr-par-1 name=my-imported-snapshot volume-type=b_ssd bucket=my-bucket key=my-qcow2-file-name
```




### Delete a snapshot

Delete the snapshot with the specified ID.

**Usage:**

```
scw instance snapshot delete <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required | UUID of the snapshot you want to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete a snapshot in the default zone with the specified ID
```
scw instance snapshot delete 11111111-1111-1111-1111-111111111111
```

Delete a snapshot in fr-par-1 zone with the specified ID
```
scw instance snapshot delete 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Export a snapshot

Export a snapshot to a specified Object Storage bucket in the same region.

**Usage:**

```
scw instance snapshot export [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| bucket |  | Object Storage bucket name |
| key |  | Object key |
| snapshot-id | Required | Snapshot ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Export a snapshot to an Object Storage bucket
```
scw instance snapshot export zone=fr-par-1 snapshot-id=11111111-1111-1111-1111-111111111111 bucket=my-bucket key=my-qcow2-file-name
```




### Get a snapshot

Get details of a snapshot with the specified ID.

**Usage:**

```
scw instance snapshot get <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required | UUID of the snapshot you want to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get a snapshot in the default zone with the specified ID
```
scw instance snapshot get 11111111-1111-1111-1111-111111111111
```

Get a snapshot in fr-par-1 zone with the specified ID
```
scw instance snapshot get 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### List snapshots

List all snapshots of an Organization in a specified Availability Zone.

**Usage:**

```
scw instance snapshot list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | List snapshots only for this Project ID |
| name |  | List snapshots of the requested name |
| tags |  | List snapshots that have the requested tag |
| base-volume-id |  | List snapshots originating only from this volume |
| organization-id |  | List snapshots only for this Organization ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all snapshots in the default zone
```
scw instance snapshot list
```

List all snapshots in fr-par-1 zone
```
scw instance snapshot list zone=fr-par-1
```




### Get a volume or snapshot's migration plan

Given a volume or snapshot, returns the migration plan but does not perform the actual migration. To perform the migration, you have to call the [Migrate a volume and/or snapshots to SBS](#path-volumes-migrate-a-volume-andor-snapshots-to-sbs-scaleway-block-storage) endpoint afterward.
The endpoint returns the resources that should be migrated together:
- the volume and any snapshots created from the volume, if the call was made to plan a volume migration.
- the base volume of the snapshot (if the volume is not deleted) and its related snapshots, if the call was made to plan a snapshot migration.
The endpoint also returns the validation_key, which must be provided to the [Migrate a volume and/or snapshots to SBS](#path-volumes-migrate-a-volume-andor-snapshots-to-sbs-scaleway-block-storage) endpoint to confirm that all resources listed in the plan should be migrated.

**Usage:**

```
scw instance snapshot plan-migration <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id |  | The snapshot for which the migration plan will be generated. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Update a snapshot

Update the properties of a snapshot.

**Usage:**

```
scw instance snapshot update <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required | UUID of the snapshot |
| name |  | Name of the snapshot |
| tags.{index} |  | Tags of the snapshot |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Wait for snapshot to reach a stable state

Wait for snapshot to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the snapshot.

**Usage:**

```
scw instance snapshot wait <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required | ID of the snapshot. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |
| timeout | Default: `1h0m0s` | Timeout of the wait |


**Examples:**


Wait for a snapshot to reach a stable state
```
scw instance snapshot wait 11111111-1111-1111-1111-111111111111
```




## SSH Utilities

Command utilities around server SSH
- Manage keys per server
- Generate ssh config


### Add a public key to a server

Key will be added to server's tags and added to root user on next restart.
Key is expected in openssh format "(format) (key) (comment)".
The comment will be used as key name or generated
Lookup /root/.ssh/authorized_keys on your server for more information

**Usage:**

```
scw instance ssh add-key [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id |  | Server to add your key to |
| public-key |  | Public key you want to add to your server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Install a ssh config with all your servers as host
It generate hosts for instance servers, baremetal, apple-silicon and bastions

Path of the config will be $HOME/.ssh/scaleway.config

**Usage:**

```
scw instance ssh install-config [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |



### List manually added public keys

List only keys added manually to a server using tags.
The key comment is used as key name or generated
Lookup /root/.ssh/authorized_keys on your server for more information

**Usage:**

```
scw instance ssh list-keys <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server to add your key to |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Remove a manually added public key from a server

Key will be remove from server's tags and removed from root user on next restart.
Keys are identified by their comment as in openssh format.
Lookup /root/.ssh/authorized_keys on your server for more information

**Usage:**

```
scw instance ssh remove-key [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server to add your key to |
| name |  | Name of the key you want to remove, has to be the key comment or the index |
| public-key |  | Public key you want to remove |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



## User data management commands

User data is a key/value store you can use to provide your instance with introspective data.

As an example of use, Scaleway images contain the `scw-generate-ssh-keys` script, which generates the SSH server’s host keys, then stores their fingerprints as user data under the `ssh-host-fingerprints` key.
This way, before connecting to the instance using SSH, one can query the fingerprints to ensure that the remote host is the expected one, thus avoiding any man-in-the-middle attack.

There are two ways of accessing user data:
 - **From within a running Instance**, by requesting the Metadata API at http://169.254.42.42/user_data (or http://[fd00:42::42]/user_data using IPv6).
   The `scaleway-ecosystem` package, installed by default on all OS images provided by Scaleway, ships with the `scw-userdata` helper command that allows you to easily query the user data from the instance.
   For security reasons, viewing and editing user data is only allowed to queries originating from a port below 1024 (by default, only the super-user can bind to ports below 1024).
   To specify the source port with cURL, use the `--local-port` option (e.g. `curl --local-port 1-1023 http://169.254.42.42/user_data`).
 - **From the Instance API** by using the methods described below.


### Delete user data

Delete the specified key from an Instance's user data.

**Usage:**

```
scw instance user-data delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the Instance |
| key | Required | Key of the user data to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Get user data

Get the content of a user data with the specified key on an Instance.

**Usage:**

```
scw instance user-data get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the Instance |
| key | Required | Key of the user data to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### List user data

List all user data keys registered on a specified Instance.

**Usage:**

```
scw instance user-data list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the Instance |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Add/set user data

Add or update a user data with the specified key on an Instance.

**Usage:**

```
scw instance user-data set [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the Instance |
| key | Required | Key of the user data to set |
| content | Required | Content of the user data |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



## Volume management commands

A volume is where you store your data inside your Instance. It
appears as a block device on Linux that you can use to create
a filesystem and mount it.

Two different types of volume (`volume_type`) are available:
  - `l_ssd` is a local block storage: your data is downloaded on
    the hypervisor and you need to power off your Instance to attach
    or detach a volume.
  - `b_ssd` is a remote block storage: your data is stored on a
    centralized cluster. You can plug and unplug a volume while
    your Instance is running.

Minimum and maximum volume sizes for each volume types can be queried
from the zone `/products/volumes` API endpoint. _I.e_ for:
  - `fr-par-1`  use https://api.scaleway.com/instance/v1/zones/fr-par-1/products/volumes
  - `nl-ams-1`  use https://api.scaleway.com/instance/v1/zones/nl-ams-1/products/volumes

Each type of volume is also subject to a global quota for the sum of all the
volumes. This quota depends of the level of support and may be
changed on demand.

Be wary that when terminating an Instance, if you want to keep
your block storage volume, **you must** detach it before you
issue the `terminate` call.

When using multiple block devices, it's advised to mount them by
using their UUID instead of their device name. A device name is
subject to change depending on the volumes order. Block devices
UUIDs can be found in `/dev/disk/by-id/`.


### Migrate a volume and/or snapshots to SBS (Scaleway Block Storage)

To be used, the call to this endpoint must be preceded by a call to the [Get a volume or snapshot's migration plan](#path-volumes-get-a-volume-or-snapshots-migration-plan) endpoint. To migrate all resources mentioned in the migration plan, the validation_key returned in the plan must be provided.

**Usage:**

```
scw instance volume apply-migration <volume-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id |  | The volume to migrate, along with potentially other resources, according to the migration plan generated with a call to the [Get a volume or snapshot's migration plan](#path-volumes-get-a-volume-or-snapshots-migration-plan) endpoint. |
| validation-key | Required | A value to be retrieved from a call to the [Get a volume or snapshot's migration plan](#path-volumes-get-a-volume-or-snapshots-migration-plan) endpoint, to confirm that the volume and/or snapshots specified in said plan should be migrated. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Create a volume

Create a volume of a specified type in an Availability Zone.

**Usage:**

```
scw instance volume create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` | Volume name |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| tags.{index} |  | Volume tags |
| volume-type | One of: `l_ssd`, `b_ssd`, `unified`, `scratch`, `sbs_volume`, `sbs_snapshot` | Volume type |
| size |  | Volume disk size, must be a multiple of 512 |
| base-snapshot |  | ID of the snapshot on which this volume will be based |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create a volume called 'my-volume'
```
scw instance volume create name=my-volume
```

Create a volume with a size of 50GB
```
scw instance volume create size=50GB
```




### Delete a volume

Delete the volume with the specified ID.

**Usage:**

```
scw instance volume delete <volume-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | UUID of the volume you want to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete a volume with the specified ID
```
scw instance volume delete af136619-bc59-4b48-a0ed-ed7dceaad9a6
```




### Get a volume

Get details of a volume with the specified ID.

**Usage:**

```
scw instance volume get <volume-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | UUID of the volume you want to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get a volume with the specified ID
```
scw instance volume get b70e9a0e-28b1-4542-bb9b-06d2d6debc0f
```




### List volumes

List volumes in the specified Availability Zone. You can filter the output by volume type.

**Usage:**

```
scw instance volume list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-type | One of: `l_ssd`, `b_ssd`, `unified`, `scratch`, `sbs_volume`, `sbs_snapshot` | Filter by volume type |
| project-id |  | Filter volume by Project ID |
| tags |  | Filter volumes with these exact tags (to filter with several tags, use commas to separate them) |
| name |  | Filter volume by name (for eg. "vol" will return "myvolume" but not "data") |
| organization-id |  | Filter volume by Organization ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all volumes
```
scw instance volume list
```

List all block storage volumes
```
scw instance volume list volume-type=b_ssd
```

List all local storage volumes
```
scw instance volume list volume-type=l_ssd
```

List all volumes that match a name
```
scw instance volume list name=foobar
```

List all block storage volumes that match a name
```
scw instance volume list volume-type=b_ssd name=foobar
```




### Get a volume or snapshot's migration plan

Given a volume or snapshot, returns the migration plan but does not perform the actual migration. To perform the migration, you have to call the [Migrate a volume and/or snapshots to SBS](#path-volumes-migrate-a-volume-andor-snapshots-to-sbs-scaleway-block-storage) endpoint afterward.
The endpoint returns the resources that should be migrated together:
- the volume and any snapshots created from the volume, if the call was made to plan a volume migration.
- the base volume of the snapshot (if the volume is not deleted) and its related snapshots, if the call was made to plan a snapshot migration.
The endpoint also returns the validation_key, which must be provided to the [Migrate a volume and/or snapshots to SBS](#path-volumes-migrate-a-volume-andor-snapshots-to-sbs-scaleway-block-storage) endpoint to confirm that all resources listed in the plan should be migrated.

**Usage:**

```
scw instance volume plan-migration <volume-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id |  | The volume for which the migration plan will be generated. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Update a volume

Replace the name and/or size properties of a volume specified by its ID, with the specified value(s). Any volume name can be changed, however only `b_ssd` volumes can currently be increased in size.

**Usage:**

```
scw instance volume update <volume-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | UUID of the volume |
| name |  | Volume name |
| tags.{index} |  | Tags of the volume |
| size |  | Volume disk size, must be a multiple of 512 |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Change the volume name
```
scw instance volume update 11111111-1111-1111-1111-111111111111 name=my-new-name
```

Change the volume disk size (bytes)
```
scw instance volume update 11111111-1111-1111-1111-111111111111 size=60GB
```

Change the volume name and disk size
```
scw instance volume update 11111111-1111-1111-1111-111111111111 name=a-new-name size=70GB
```




### Wait for volume to reach a stable state

Wait for volume to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the volume.

**Usage:**

```
scw instance volume wait <volume-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| timeout | Default: `10m0s` | Timeout of the wait |
| volume-id | Required | ID of the volume affected by the action. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Wait for a volume to reach a stable state
```
scw instance volume wait 11111111-1111-1111-1111-111111111111
```




## Volume type management commands

All volume types available in a specified zone.
Each of these types will contains all the capabilities and constraints of the volume (min size, max size, snapshot).


### List volume types

List all volume types and their technical details.

**Usage:**

```
scw instance volume-type list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all volume-types in the default zone
```
scw instance volume-type list
```

List all volume-types in fr-par-1 zone
```
scw instance volume-type list zone=fr-par-1
```




