<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw keymanager`
This API allows you to conveniently store and use cryptographic keys.
  
- [Key management commands](#key-management-commands)
  - [Create a key](#create-a-key)
  - [Decrypt data](#decrypt-data)
  - [Delete a key](#delete-a-key)
  - [Disable key](#disable-key)
  - [Enable key](#enable-key)
  - [Encrypt data](#encrypt-data)
  - [Generate a data encryption key](#generate-a-data-encryption-key)
  - [Get key metadata](#get-key-metadata)
  - [List keys](#list-keys)
  - [Apply key protection](#apply-key-protection)
  - [Rotate a key](#rotate-a-key)
  - [Remove key protection](#remove-key-protection)
  - [Update a key](#update-a-key)

  
## Key management commands

Keys are logical containers which store cryptographic keys.


### Create a key

Create a key in a given region specified by the `region` parameter. Keys only support symmetric encryption. You can use keys to encrypt or decrypt arbitrary payloads, or to generate data encryption keys that can be used without being stored in Key Manager.

**Usage:**

```
scw keymanager key create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name |  | (Optional) Name of the key |
| usage.symmetric-encryption | One of: `unknown_symmetric_encryption`, `aes_256_gcm` |  |
| description |  | (Optional) Description of the key |
| tags.{index} |  | (Optional) List of the key's tags |
| rotation-policy.rotation-period |  | Rotation period |
| rotation-policy.next-rotation-at |  | Key next rotation date |
| unprotected |  | (Optional) Defines whether key protection is applied to a key. Protected keys can be used but not deleted |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Decrypt data

Decrypt data using an existing key, specified by the `key_id` parameter. The maximum payload size that can be decrypted is the result of the encryption of 64KB of data (around 131KB).

**Usage:**

```
scw keymanager key decrypt [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to decrypt |
| ciphertext | Required | Base64 Ciphertext data to decrypt |
| associated-data |  | (Optional) Additional authenticated data |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a key

Delete an existing key specified by the `region` and `key_id` parameters. Deleting a key is permanent and cannot be undone. All data encrypted using this key, including data encryption keys, will become unusable.

**Usage:**

```
scw keymanager key delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Disable key

Disable a given key to be used for cryptographic operations. Disabling a key renders it unusable. You must specify the `region` and `key_id` parameters.

**Usage:**

```
scw keymanager key disable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to disable |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Enable key

Enable a given key to be used for cryptographic operations. Enabling a key allows you to make a disabled key usable again. You must specify the `region` and `key_id` parameters.

**Usage:**

```
scw keymanager key enable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to enable |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Encrypt data

Encrypt data using an existing key, specified by the `key_id` parameter. Only keys with a usage set to **symmetric_encryption** are supported by this method. The maximum payload size that can be encrypted is 64KB of plaintext.

**Usage:**

```
scw keymanager key encrypt [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to encrypt |
| plaintext | Required | Base64 Plaintext data to encrypt |
| associated-data |  | (Optional) Additional authenticated data |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Generate a data encryption key

Generate a new data encryption key to use for cryptographic operations outside of Key Manager. Note that Key Manager does not store your data encryption key. The data encryption key is encrypted and must be decrypted using the key you have created in Key Manager. The data encryption key's plaintext is returned in the response object, for immediate usage.

Always store the data encryption key's ciphertext, rather than its plaintext, which must not be stored. To retrieve your key's plaintext, call the Decrypt endpoint with your key's ID and ciphertext.

**Usage:**

```
scw keymanager key generate-data-key [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key |
| algorithm | One of: `unknown_symmetric_encryption`, `aes_256_gcm` | Symmetric encryption algorithm of the data encryption key |
| without-plaintext |  | (Optional) Defines whether to return the data encryption key's plaintext in the response object |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get key metadata

Retrieve the metadata of a key specified by the `region` and `key_id` parameters.

**Usage:**

```
scw keymanager key get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to target |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List keys

Retrieve the list of keys created within all Projects of an Organization or in a given Project. You must specify the `region`, and either the `organization_id` or the `project_id`.

**Usage:**

```
scw keymanager key list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | (Optional) Filter by Project ID |
| order-by | One of: `name_asc`, `name_desc`, `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc` |  |
| tags.{index} |  | (Optional) List of tags to filter on |
| name |  | (Optional) Filter by key name |
| organization-id |  | (Optional) Filter by Organization ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Apply key protection

Apply key protection to a given key specified by the `key_id` parameter. Applying key protection means that your key can be used and modified, but it cannot be deleted.

**Usage:**

```
scw keymanager key protect [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to apply key protection to |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Rotate a key

Generate a new version of an existing key with randomly generated key material. Rotated keys can still be used to decrypt previously encrypted data. The key's new material will be used for subsequent encryption operations and data key generation.

**Usage:**

```
scw keymanager key rotate [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to rotate |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Remove key protection

Remove key protection from a given key specified by the `key_id` parameter. Removing key protection means that your key can be deleted anytime.

**Usage:**

```
scw keymanager key unprotect [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to remove key protection from |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Update a key

Update a key's metadata (name, description and tags), specified by the `key_id` and `region` parameters.

**Usage:**

```
scw keymanager key update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to update |
| name |  | (Optional) Updated name of the key |
| description |  | (Optional) Updated description of the key |
| tags.{index} |  | (Optional) Updated list of the key's tags |
| rotation-policy.rotation-period |  | Rotation period |
| rotation-policy.next-rotation-at |  | Key next rotation date |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



