<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw fip`
Elastic Metal - Flexible IP API.
  
- [Flexible IP management commands](#flexible-ip-management-commands)
  - [Attach an existing flexible IP to a server](#attach-an-existing-flexible-ip-to-a-server)
  - [Create a new flexible IP](#create-a-new-flexible-ip)
  - [Delete an existing flexible IP](#delete-an-existing-flexible-ip)
  - [Detach an existing flexible IP from a server](#detach-an-existing-flexible-ip-from-a-server)
  - [Get an existing flexible IP](#get-an-existing-flexible-ip)
  - [List flexible IPs](#list-flexible-ips)
  - [Update an existing flexible IP](#update-an-existing-flexible-ip)
- [MAC address management commands](#mac-address-management-commands)
  - [Generate a virtual MAC address on an existing flexible IP](#generate-a-virtual-mac-address-on-an-existing-flexible-ip)
  - [Detach a given virtual MAC address from an existing flexible IP](#detach-a-given-virtual-mac-address-from-an-existing-flexible-ip)
  - [Duplicate a virtual MAC address to another flexible IP](#duplicate-a-virtual-mac-address-to-another-flexible-ip)
  - [Relocate an existing virtual MAC address to a different flexible IP](#relocate-an-existing-virtual-mac-address-to-a-different-flexible-ip)

  
## Flexible IP management commands

A flexible IP can be attached to any Elastic Metal server within the same zone.
Multiple flexible IPs can be attached to a server.


### Attach an existing flexible IP to a server

Attach an existing flexible IP to a specified Elastic Metal server.

**Usage:**

```
scw fip ip attach [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fips-ids.{index} | Required | List of flexible IP IDs to attach to a server |
| server-id | Required | ID of the server on which to attach the flexible IPs |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Create a new flexible IP

Generate a new flexible IP within a given zone, specifying its configuration including Project ID and description.

**Usage:**

```
scw fip ip create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| description |  | Flexible IP description (max. of 255 characters) |
| tags.{index} |  | Tags to associate to the flexible IP |
| server-id |  | ID of the server to which the newly created flexible IP will be attached. |
| reverse |  | Value of the reverse DNS |
| is-ipv6 |  | Defines whether the flexible IP has an IPv6 address. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Delete an existing flexible IP

Delete an existing flexible IP, specified by its ID and zone. Note that deleting a flexible IP is permanent and cannot be undone.

**Usage:**

```
scw fip ip delete <fip-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required | ID of the flexible IP to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Detach an existing flexible IP from a server

Detach an existing flexible IP from a specified Elastic Metal server.

**Usage:**

```
scw fip ip detach [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fips-ids.{index} | Required | List of flexible IP IDs to detach from a server. Multiple IDs can be provided. Note that flexible IPs must belong to the same MAC group. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Get an existing flexible IP

Retrieve information about an existing flexible IP, specified by its ID and zone. Its full details, including Project ID, description and status, are returned in the response object.

**Usage:**

```
scw fip ip get <fip-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required | ID of the flexible IP |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### List flexible IPs

List all flexible IPs within a given zone.

**Usage:**

```
scw fip ip list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of the returned flexible IPs |
| tags.{index} |  | Filter by tag, only flexible IPs with one or more matching tags will be returned |
| status.{index} | One of: `unknown`, `ready`, `updating`, `attached`, `error`, `detaching`, `locked` | Filter by status, only flexible IPs with this status will be returned |
| server-ids.{index} |  | Filter by server IDs, only flexible IPs with these server IDs will be returned |
| project-id |  | Filter by Project ID, only flexible IPs from this Project will be returned |
| organization-id |  | Filter by Organization ID, only flexible IPs from this Organization will be returned |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update an existing flexible IP

Update the parameters of an existing flexible IP, specified by its ID and zone. These parameters include tags and description.

**Usage:**

```
scw fip ip update <fip-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required | ID of the flexible IP to update |
| description |  | Flexible IP description (max. 255 characters) |
| tags.{index} |  | Tags associated with the flexible IP |
| reverse |  | Value of the reverse DNS |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



## MAC address management commands

MAC address management commands.


### Generate a virtual MAC address on an existing flexible IP

Generate a virtual MAC (Media Access Control) address on an existing flexible IP.

**Usage:**

```
scw fip mac create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required | ID of the flexible IP for which to generate a virtual MAC |
| mac-type | Required<br />One of: `unknown_type`, `vmware`, `xen`, `kvm` | TODO |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Detach a given virtual MAC address from an existing flexible IP

Detach a given MAC (Media Access Control) address from an existing flexible IP.

**Usage:**

```
scw fip mac delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required | ID of the flexible IP from which to delete the virtual MAC |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Duplicate a virtual MAC address to another flexible IP

Duplicate a virtual MAC address from a given flexible IP to another flexible IP attached to the same server.

**Usage:**

```
scw fip mac duplicate [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required | ID of the flexible IP on which to duplicate the virtual MAC |
| duplicate-from-fip-id | Required | ID of the flexible IP to duplicate the Virtual MAC from |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Relocate an existing virtual MAC address to a different flexible IP

Relocate a virtual MAC (Media Access Control) address from an existing flexible IP to a different flexible IP.

**Usage:**

```
scw fip mac move [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required |  |
| dst-fip-id |  |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



