<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw billing`
This API allows you to query your consumption.
  
- [Discounts management commands](#discounts-management-commands)
  - [List all user's discounts](#list-all-user's-discounts)
- [Invoices management commands](#invoices-management-commands)
  - [Download an invoice](#download-an-invoice)
  - [List invoices](#list-invoices)

  
## Discounts management commands

Discounts management commands.


### List all user's discounts

List all discounts for an organization and usable categories/products/offers/references/regions/zones where the discount can be applied.

**Usage:**

```
scw billing discount list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `creation_date_desc`, `creation_date_asc` | Order discounts in the response by their description |
| organization-id |  | ID of the organization |



## Invoices management commands

Invoices management commands.


### Download an invoice

Download a specific invoice, specified by its ID.

**Usage:**

```
scw billing invoice download [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| invoice-id | Required | Invoice ID |
| file-path | Default: `./` | Wanted file path |
| file-type | Default: `pdf` | Wanted file extension |
| force-replace | Default: `false` | Force file replacement |



### List invoices

List all your invoices, filtering by `start_date` and `invoice_type`. Each invoice has its own ID.

**Usage:**

```
scw billing invoice list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| started-after |  | Invoice's `start_date` is greater or equal to `started_after` |
| started-before |  | Invoice's `start_date` precedes `started_before` |
| invoice-type | One of: `unknown_type`, `periodic`, `purchase` | Invoice type. It can either be `periodic` or `purchase` |
| order-by | One of: `invoice_number_desc`, `invoice_number_asc`, `start_date_desc`, `start_date_asc`, `issued_date_desc`, `issued_date_asc`, `due_date_desc`, `due_date_asc`, `total_untaxed_desc`, `total_untaxed_asc`, `total_taxed_desc`, `total_taxed_asc`, `invoice_type_desc`, `invoice_type_asc` | How invoices are ordered in the response |
| organization-id |  | Organization ID to filter for, only invoices from this Organization will be returned |



