<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw vpc-gw`
Public Gateways API.
  
- [DHCP configuration management](#dhcp-configuration-management)
  - [Create a DHCP configuration](#create-a-dhcp-configuration)
  - [Delete a DHCP configuration](#delete-a-dhcp-configuration)
  - [Get a DHCP configuration](#get-a-dhcp-configuration)
  - [List DHCP configurations](#list-dhcp-configurations)
  - [Update a DHCP configuration](#update-a-dhcp-configuration)
- [DHCP entries management](#dhcp-entries-management)
  - [Create a DHCP entry](#create-a-dhcp-entry)
  - [Delete a DHCP entry](#delete-a-dhcp-entry)
  - [Get a DHCP entry](#get-a-dhcp-entry)
  - [List DHCP entries](#list-dhcp-entries)
  - [Set all DHCP reservations on a Gateway Network](#set-all-dhcp-reservations-on-a-gateway-network)
  - [Update a DHCP entry](#update-a-dhcp-entry)
- [Public Gateway management](#public-gateway-management)
  - [Create a Public Gateway](#create-a-public-gateway)
  - [Delete a Public Gateway](#delete-a-public-gateway)
  - [Get a Public Gateway](#get-a-public-gateway)
  - [List Public Gateways](#list-public-gateways)
  - [Refresh a Public Gateway's SSH keys](#refresh-a-public-gateway's-ssh-keys)
  - [Update a Public Gateway](#update-a-public-gateway)
  - [Upgrade a Public Gateway to the latest version](#upgrade-a-public-gateway-to-the-latest-version)
- [Gateway Networks management](#gateway-networks-management)
  - [Attach a Public Gateway to a Private Network](#attach-a-public-gateway-to-a-private-network)
  - [Detach a Public Gateway from a Private Network](#detach-a-public-gateway-from-a-private-network)
  - [Get a Public Gateway connection to a Private Network](#get-a-public-gateway-connection-to-a-private-network)
  - [List Public Gateway connections to Private Networks](#list-public-gateway-connections-to-private-networks)
  - [Update a Public Gateway's connection to a Private Network](#update-a-public-gateway's-connection-to-a-private-network)
- [Gateway types information](#gateway-types-information)
  - [List Public Gateway types](#list-public-gateway-types)
- [IP address management](#ip-address-management)
  - [Reserve an IP](#reserve-an-ip)
  - [Delete an IP](#delete-an-ip)
  - [Get an IP](#get-an-ip)
  - [List IPs](#list-ips)
  - [Update an IP](#update-an-ip)
- [PAT rules management](#pat-rules-management)
  - [Create a PAT rule](#create-a-pat-rule)
  - [Delete a PAT rule](#delete-a-pat-rule)
  - [Get a PAT rule](#get-a-pat-rule)
  - [List PAT rules](#list-pat-rules)
  - [Set all PAT rules](#set-all-pat-rules)
  - [Update a PAT rule](#update-a-pat-rule)

  
## DHCP configuration management

These objects define a DHCP configuration, i.e. how IP addresses should be assigned to devices on a Private Network attached to a Public Gateway. Definable parameters include the subnet for the DHCP server, the validity  period for DHCP entries, whether to use dynamic pooling, and more. A DHCP configuration object has a DHCP ID, which can then be used as part of a  call to create or update a Gateway Network. This lets you attach an existing DHCP configuration to a Public Gateway attached to a Private Network. Similarly, you can use a DHCP ID as a query parameter to list Gateway Networks which use this DHCP configuration object.


### Create a DHCP configuration

Create a new DHCP configuration object, containing settings for the assignment of IP addresses to devices on a Private Network attached to a Public Gateway. The response object includes the ID of the DHCP configuration object. You can use this ID as part of a call to `Create a Public Gateway connection to a Private Network` or `Update a Public Gateway connection to a Private Network` to directly apply this DHCP configuration.

**Usage:**

```
scw vpc-gw dhcp create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| subnet | Required | Subnet for the DHCP server |
| address |  | IP address of the DHCP server. This will be the gateway's address in the Private Network. Defaults to the first address of the subnet |
| pool-low |  | Low IP (inclusive) of the dynamic address pool. Must be in the config's subnet. Defaults to the second address of the subnet |
| pool-high |  | High IP (inclusive) of the dynamic address pool. Must be in the config's subnet. Defaults to the last address of the subnet |
| enable-dynamic |  | Defines whether to enable dynamic pooling of IPs. When false, only pre-existing DHCP reservations will be handed out. Defaults to true |
| valid-lifetime |  | How long DHCP entries will be valid for. Defaults to 1h (3600s) |
| renew-timer |  | After how long a renew will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s) |
| rebind-timer |  | After how long a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s) |
| push-default-route |  | Defines whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to true |
| push-dns-server |  | Defines whether the gateway should push custom DNS servers to clients. This allows for Instance hostname -> IP resolution. Defaults to true |
| dns-servers-override.{index} |  | Array of DNS server IP addresses used to override the DNS server list pushed to DHCP clients, instead of the gateway itself |
| dns-search.{index} |  | Array of search paths in addition to the pushed DNS configuration |
| dns-local-name |  | TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv` |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Delete a DHCP configuration

Delete a DHCP configuration object, identified by its DHCP ID. Note that you cannot delete a DHCP configuration object that is currently being used by a Gateway Network.

**Usage:**

```
scw vpc-gw dhcp delete <dhcp-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dhcp-id | Required | DHCP configuration ID to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Get a DHCP configuration

Get a DHCP configuration object, identified by its DHCP ID. The response object contains configuration settings for the assignment of IP addresses to devices on a Private Network attached to a Public Gateway. Note that the response does not contain the IDs of any Private Network / Public Gateway the configuration is attached to. Use the `List Public Gateway connections to Private Networks` method for that purpose, filtering on DHCP ID.

**Usage:**

```
scw vpc-gw dhcp get <dhcp-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dhcp-id | Required | ID of the DHCP configuration to fetch |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### List DHCP configurations

List DHCP configurations, optionally filtering by Organization, Project, Public Gateway IP address or more. The response is an array of DHCP configuration objects, each identified by a DHCP ID and containing configuration settings for the assignment of IP addresses to devices on a Private Network attached to a Public Gateway. Note that the response does not contain the IDs of any Private Network / Public Gateway the configuration is attached to. Use the `List Public Gateway connections to Private Networks` method for that purpose, filtering on DHCP ID.

**Usage:**

```
scw vpc-gw dhcp list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `subnet_asc`, `subnet_desc` | Order in which to return results |
| project-id |  | Include only DHCP configuration objects in this Project |
| address |  | Filter for DHCP configuration objects with this DHCP server IP address (the gateway's address in the Private Network) |
| has-address |  | Filter for DHCP configuration objects with subnets containing this IP address |
| organization-id |  | Include only DHCP configuration objects in this Organization |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update a DHCP configuration

Update a DHCP configuration object, identified by its DHCP ID.

**Usage:**

```
scw vpc-gw dhcp update <dhcp-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dhcp-id | Required | DHCP configuration to update |
| subnet |  | Subnet for the DHCP server |
| address |  | IP address of the DHCP server. This will be the Public Gateway's address in the Private Network. It must be part of config's subnet |
| pool-low |  | Low IP (inclusive) of the dynamic address pool. Must be in the config's subnet |
| pool-high |  | High IP (inclusive) of the dynamic address pool. Must be in the config's subnet |
| enable-dynamic |  | Defines whether to enable dynamic pooling of IPs. When false, only pre-existing DHCP reservations will be handed out. Defaults to true |
| valid-lifetime |  | How long DHCP entries will be valid for |
| renew-timer |  | After how long a renew will be attempted. Must be 30s lower than `rebind_timer` |
| rebind-timer |  | After how long a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime` |
| push-default-route |  | Defines whether the gateway should push a default route to DHCP clients, or only hand out IPs |
| push-dns-server |  | Defines whether the gateway should push custom DNS servers to clients. This allows for instance hostname -> IP resolution |
| dns-servers-override.{index} |  | Array of DNS server IP addresses used to override the DNS server list pushed to DHCP clients, instead of the gateway itself |
| dns-search.{index} |  | Array of search paths in addition to the pushed DNS configuration |
| dns-local-name |  | TLD given to hostnames in the Private Networks. If an instance with hostname `foo` gets a lease, and this is set to `bar`, `foo.bar` will resolve. Allowed characters are `a-z0-9-.` |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



## DHCP entries management

DHCP entries belong to a specified Gateway Network (Public Gateway / Private Network connection). A DHCP entry can hold either a dynamic DHCP lease (an IP address dynamically assigned by the Public Gateway to a device) or a static, user-created DHCP reservation.


### Create a DHCP entry

Create a static DHCP reservation, specifying the Gateway Network for the reservation, the MAC address of the target device and the IP address to assign this device. The response is a DHCP entry object, confirming the ID and configuration details of the static DHCP reservation.

**Usage:**

```
scw vpc-gw dhcp-entry create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-network-id |  | GatewayNetwork on which to create a DHCP reservation |
| mac-address |  | MAC address to give a static entry to |
| ip-address |  | IP address to give to the device |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Delete a DHCP entry

Delete a static DHCP reservation, identified by its DHCP entry ID. Note that you cannot delete DHCP entries of type `lease`, these are deleted automatically when their time-to-live expires.

**Usage:**

```
scw vpc-gw dhcp-entry delete <dhcp-entry-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dhcp-entry-id | Required | ID of the DHCP entry to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Get a DHCP entry

Get a DHCP entry, specified by its DHCP entry ID.

**Usage:**

```
scw vpc-gw dhcp-entry get <dhcp-entry-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dhcp-entry-id | Required | ID of the DHCP entry to fetch |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### List DHCP entries

List DHCP entries, whether dynamically assigned and/or statically reserved. DHCP entries can be filtered by the Gateway Network they are on, their MAC address, IP address, type or hostname.

**Usage:**

```
scw vpc-gw dhcp-entry list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `ip_address_asc`, `ip_address_desc`, `hostname_asc`, `hostname_desc` | Order in which to return results |
| gateway-network-id |  | Filter for entries on this GatewayNetwork |
| mac-address |  | Filter for entries with this MAC address |
| ip-address |  | Filter for entries with this IP address |
| hostname |  | Filter for entries with this hostname substring |
| type | One of: `unknown`, `reservation`, `lease` | Filter for entries of this type |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |



### Set all DHCP reservations on a Gateway Network

Set the list of DHCP reservations attached to a Gateway Network. Reservations are identified by their MAC address, and will sync the current DHCP entry list to the given list, creating, updating or deleting DHCP entries accordingly.

**Usage:**

```
scw vpc-gw dhcp-entry set [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-network-id |  | ID of the Gateway Network on which to set DHCP reservation list |
| dhcp-entries.{index}.mac-address |  | MAC address to give a static entry to |
| dhcp-entries.{index}.ip-address |  | IP address to give to the device |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Update a DHCP entry

Update the IP address for a DHCP entry, specified by its DHCP entry ID. You can update an existing DHCP entry of any type (`reservation` (static), `lease` (dynamic) or `unknown`), but in manually updating the IP address the entry will necessarily be of type `reservation` after the update.

**Usage:**

```
scw vpc-gw dhcp-entry update <dhcp-entry-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dhcp-entry-id | Required | ID of the DHCP entry to update |
| ip-address |  | New IP address to give to the device |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



## Public Gateway management

Public Gateways are building blocks for your infrastructure on Scaleway's shared public cloud. They provide a set of managed network services and features for Scaleway's Private Networks such as DHCP, NAT and routing.


### Create a Public Gateway

Create a new Public Gateway in the specified Scaleway Project, defining its **name**, **type** and other configuration details such as whether to enable SSH bastion.

**Usage:**

```
scw vpc-gw gateway create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Default: `<generated>` | Name for the gateway |
| tags.{index} |  | Tags for the gateway |
| type | Default: `VPC-GW-S` | Gateway type (commercial offer type) |
| upstream-dns-servers.{index} |  | Array of DNS server IP addresses to override the gateway's default recursive DNS servers |
| ip-id |  | Existing IP address to attach to the gateway |
| enable-smtp |  | Defines whether SMTP traffic should be allowed pass through the gateway |
| enable-bastion |  | Defines whether SSH bastion should be enabled the gateway |
| bastion-port |  | Port of the SSH bastion |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Delete a Public Gateway

Delete an existing Public Gateway, specified by its gateway ID. This action is irreversible.

**Usage:**

```
scw vpc-gw gateway delete <gateway-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id | Required | ID of the gateway to delete |
| cleanup-dhcp |  | Defines whether to clean up attached DHCP configurations (if any, and if not attached to another Gateway Network) |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Get a Public Gateway

Get details of a Public Gateway, specified by its gateway ID. The response object contains full details of the gateway, including its **name**, **type**, **status** and more.

**Usage:**

```
scw vpc-gw gateway get <gateway-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id | Required | ID of the gateway to fetch |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### List Public Gateways

List Public Gateways in a given Scaleway Organization or Project. By default, results are displayed in ascending order of creation date.

**Usage:**

```
scw vpc-gw gateway list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc`, `type_asc`, `type_desc`, `status_asc`, `status_desc` | Order in which to return results |
| project-id |  | Include only gateways in this Project |
| name |  | Filter for gateways which have this search term in their name |
| tags.{index} |  | Filter for gateways with these tags |
| type |  | Filter for gateways of this type |
| status | One of: `unknown`, `stopped`, `allocating`, `configuring`, `running`, `stopping`, `failed`, `deleting`, `deleted`, `locked` | Filter for gateways with this current status. Use `unknown` to include all statuses |
| private-network-id |  | Filter for gateways attached to this Private nNetwork |
| organization-id |  | Include only gateways in this Organization |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |



### Refresh a Public Gateway's SSH keys

Refresh the SSH keys of a given Public Gateway, specified by its gateway ID. This adds any new SSH keys in the gateway's Scaleway Project to the gateway itself.

**Usage:**

```
scw vpc-gw gateway refresh-ssh-keys <gateway-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id | Required | ID of the gateway to refresh SSH keys on |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Update a Public Gateway

Update the parameters of an existing Public Gateway, for example, its **name**, **tags**, **SSH bastion configuration**, and **DNS servers**.

**Usage:**

```
scw vpc-gw gateway update <gateway-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id | Required | ID of the gateway to update |
| name |  | Name for the gateway |
| tags.{index} |  | Tags for the gateway |
| upstream-dns-servers.{index} |  | Array of DNS server IP addresses to override the gateway's default recursive DNS servers |
| enable-bastion |  | Defines whether SSH bastion should be enabled the gateway |
| bastion-port |  | Port of the SSH bastion |
| enable-smtp |  | Defines whether SMTP traffic should be allowed to pass through the gateway |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Upgrade a Public Gateway to the latest version

Upgrade a given Public Gateway to the newest software version. This applies the latest bugfixes and features to your Public Gateway, but its service will be interrupted during the update.

**Usage:**

```
scw vpc-gw gateway upgrade <gateway-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id | Required | ID of the gateway to upgrade |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



## Gateway Networks management

A Gateway Network represents the connection of a Private Network to a Public Gateway. It holds configuration options relative to this specific connection, such as the DHCP configuration.


### Attach a Public Gateway to a Private Network

Attach a specific Public Gateway to a specific Private Network (create a GatewayNetwork). You can configure parameters for the connection including DHCP settings, whether to enable masquerade (dynamic NAT), and more.

**Usage:**

```
scw vpc-gw gateway-network create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id |  | Public Gateway to connect |
| private-network-id |  | Private Network to connect |
| enable-masquerade |  | Defines whether to enable masquerade (dynamic NAT) on the GatewayNetwork. |
| enable-dhcp |  | Defines whether to enable DHCP on this Private Network. |
| dhcp-id |  | ID of an existing DHCP configuration object to use for this GatewayNetwork |
| address |  | Static IP address in CIDR format to to use without DHCP |
| ipam-config.push-default-route |  | Enabling the default route also enables masquerading |
| ipam-config.ipam-ip-id |  | Use this IPAM-booked IP ID as the Gateway's IP in this Private Network |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Detach a Public Gateway from a Private Network

Detach a given Public Gateway from a given Private Network, i.e. delete a GatewayNetwork specified by a gateway_network_id.

**Usage:**

```
scw vpc-gw gateway-network delete <gateway-network-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-network-id | Required | ID of the GatewayNetwork to delete |
| cleanup-dhcp |  | Defines whether to clean up attached DHCP configurations (if any, and if not attached to another Gateway Network) |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Get a Public Gateway connection to a Private Network

Get details of a given connection between a Public Gateway and a Private Network (this connection = a GatewayNetwork), specified by its `gateway_network_id`. The response object contains details of the connection including the IDs of the Public Gateway and Private Network, the dates the connection was created/updated and its configuration settings.

**Usage:**

```
scw vpc-gw gateway-network get <gateway-network-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-network-id | Required | ID of the GatewayNetwork to fetch |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### List Public Gateway connections to Private Networks

List the connections between Public Gateways and Private Networks (a connection = a GatewayNetwork). You can choose to filter by `gateway-id` to list all Private Networks attached to the specified Public Gateway, or by `private_network_id` to list all Public Gateways attached to the specified Private Network. Other query parameters are also available. The result is an array of GatewayNetwork objects, each giving details of the connection between a given Public Gateway and a given Private Network.

**Usage:**

```
scw vpc-gw gateway-network list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `status_asc`, `status_desc` | Order in which to return results |
| gateway-id |  | Filter for GatewayNetworks connected to this gateway |
| private-network-id |  | Filter for GatewayNetworks connected to this Private Network |
| enable-masquerade |  | Filter for GatewayNetworks with this `enable_masquerade` setting |
| dhcp-id |  | Filter for GatewayNetworks using this DHCP configuration |
| status | One of: `unknown`, `created`, `attaching`, `configuring`, `ready`, `detaching`, `deleted` | Filter for GatewayNetworks with this current status this status. Use `unknown` to include all statuses |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update a Public Gateway's connection to a Private Network

Update the configuration parameters of a connection between a given Public Gateway and Private Network (the connection = a GatewayNetwork). Updatable parameters include DHCP settings and whether to enable traffic masquerade (dynamic NAT).

**Usage:**

```
scw vpc-gw gateway-network update <gateway-network-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-network-id | Required | ID of the GatewayNetwork to update |
| enable-masquerade |  | Defines whether to enable masquerade (dynamic NAT) on the GatewayNetwork. |
| enable-dhcp |  | Defines whether to enable DHCP on this Private Network. |
| dhcp-id |  | ID of the new DHCP configuration object to use with this GatewayNetwork |
| address |  | New static IP address |
| ipam-config.push-default-route |  | Enabling the default route also enables masquerading |
| ipam-config.ipam-ip-id |  | Use this IPAM-booked IP ID as the Gateway's IP in this Private Network |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



## Gateway types information

Public Gateways come in various shapes, sizes and prices, which are  described by gateway types. They represent the different commercial  offer types for Public Gateways available at Scaleway.


### List Public Gateway types

List the different Public Gateway commercial offer types available at Scaleway. The response is an array of objects describing the name and technical details of each available gateway type.

**Usage:**

```
scw vpc-gw gateway-type list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



## IP address management

Public, flexible IP addresses for Public Gateways, allowing the gateway to reach the public internet, as well as forward (masquerade) traffic from member devices of attached Private Networks.


### Reserve an IP

Create (reserve) a new flexible IP address that can be used for a Public Gateway in a specified Scaleway Project.

**Usage:**

```
scw vpc-gw ip create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| tags.{index} |  | Tags to give to the IP address |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Delete an IP

Delete a flexible IP address from your account. This action is irreversible.

**Usage:**

```
scw vpc-gw ip delete <ip-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip-id | Required | ID of the IP address to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Get an IP

Get details of a Public Gateway flexible IP address, identified by its IP ID. The response object contains information including which (if any) Public Gateway using this IP address, the reverse and various other metadata.

**Usage:**

```
scw vpc-gw ip get <ip-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip-id | Required | ID of the IP address to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### List IPs

List Public Gateway flexible IP addresses. A number of filter options are available for limiting results in the response.

**Usage:**

```
scw vpc-gw ip list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `ip_asc`, `ip_desc`, `reverse_asc`, `reverse_desc` | Order in which to return results |
| project-id |  | Filter for IP addresses in this Project |
| tags.{index} |  | Filter for IP addresses with these tags |
| reverse |  | Filter for IP addresses that have a reverse containing this string |
| is-free |  | Filter based on whether the IP is attached to a gateway or not |
| organization-id |  | Filter for IP addresses in this Organization |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update an IP

Update details of an existing flexible IP address, including its tags, reverse and the Public Gateway it is assigned to.

**Usage:**

```
scw vpc-gw ip update <ip-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip-id | Required | ID of the IP address to update |
| tags.{index} |  | Tags to give to the IP address |
| reverse |  | Reverse to set on the address. Empty string to unset |
| gateway-id |  | Gateway to attach the IP address to. Empty string to detach |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



## PAT rules management

PAT (Port Address Translation) rules, aka static NAT rules, belong to a specified Public Gateway.  They define the forwarding of a public port to a specific device on a Private Network, enabling enables ingress traffic from the public Internet  to reach the correct device in the Private Network.


### Create a PAT rule

Create a new PAT rule on a specified Public Gateway, defining the protocol to use, public port to listen on, and private port / IP address to map to.

**Usage:**

```
scw vpc-gw pat-rule create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id |  | ID of the Gateway on which to create the rule |
| public-port |  | Public port to listen on |
| private-ip |  | Private IP to forward data to |
| private-port |  | Private port to translate to |
| protocol | One of: `unknown`, `both`, `tcp`, `udp` | Protocol the rule should apply to |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Delete a PAT rule

Delete a PAT rule, identified by its PAT rule ID. This action is irreversible.

**Usage:**

```
scw vpc-gw pat-rule delete <pat-rule-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pat-rule-id | Required | ID of the PAT rule to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Get a PAT rule

Get a PAT rule, specified by its PAT rule ID. The response object gives full details of the PAT rule, including the Public Gateway it belongs to and the configuration settings in terms of public / private ports, private IP and protocol.

**Usage:**

```
scw vpc-gw pat-rule get <pat-rule-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pat-rule-id | Required | ID of the PAT rule to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### List PAT rules

List PAT rules. You can filter by gateway ID to list all PAT rules for a particular gateway, or filter for PAT rules targeting a specific IP address or using a specific protocol.

**Usage:**

```
scw vpc-gw pat-rule list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `public_port_asc`, `public_port_desc` | Order in which to return results |
| gateway-id |  | Filter for PAT rules on this Gateway |
| private-ip |  | Filter for PAT rules targeting this private ip |
| protocol | One of: `unknown`, `both`, `tcp`, `udp` | Filter for PAT rules with this protocol |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3`, `all` | Zone to target. If none is passed will use default zone from the config |



### Set all PAT rules

Set a definitive list of PAT rules attached to a Public Gateway. Each rule is identified by its public port and protocol. This will sync the current PAT rule list on the gateway with the new list, creating, updating or deleting PAT rules accordingly.

**Usage:**

```
scw vpc-gw pat-rule set [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id |  | ID of the gateway on which to set the PAT rules |
| pat-rules.{index}.public-port |  | Public port to listen on |
| pat-rules.{index}.private-ip |  | Private IP to forward data to |
| pat-rules.{index}.private-port |  | Private port to translate to |
| pat-rules.{index}.protocol | One of: `unknown`, `both`, `tcp`, `udp` | Protocol the rule should apply to |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



### Update a PAT rule

Update a PAT rule, specified by its PAT rule ID. Configuration settings including private/public port, private IP address and protocol can all be updated.

**Usage:**

```
scw vpc-gw pat-rule update <pat-rule-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pat-rule-id | Required | ID of the PAT rule to update |
| public-port |  | Public port to listen on |
| private-ip |  | Private IP to forward data to |
| private-port |  | Private port to translate to |
| protocol | One of: `unknown`, `both`, `tcp`, `udp` | Protocol the rule should apply to |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | Zone to target. If none is passed will use default zone from the config |



