<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw jobs`
Serverless Jobs API.
  
- [](#)
  - [Create jobs resources](#create-jobs-resources)
  - [Delete jobs resources](#delete-jobs-resources)
  - [Get jobs resources](#get-jobs-resources)
  - [List jobs resources](#list-jobs-resources)
  - [Start jobs resources](#start-jobs-resources)
  - [Update jobs resources](#update-jobs-resources)
- [](#)
  - [Get jobs resources](#get-jobs-resources)
  - [List jobs resources](#list-jobs-resources)
  - [Stop jobs resources](#stop-jobs-resources)

  
## 




### Create jobs resources

Create jobs resources.

**Usage:**

```
scw jobs definition create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` |  |
| cpu-limit | Required |  |
| memory-limit | Required |  |
| image-uri |  |  |
| command |  |  |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| environment-variables.{key} |  |  |
| description |  |  |
| job-timeout |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete jobs resources

Delete jobs resources.

**Usage:**

```
scw jobs definition delete <job-definition-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| job-definition-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get jobs resources

Get jobs resources.

**Usage:**

```
scw jobs definition get <job-definition-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| job-definition-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List jobs resources

List jobs resources.

**Usage:**

```
scw jobs definition list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` |  |
| project-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Start jobs resources

Start jobs resources.

**Usage:**

```
scw jobs definition start <job-definition-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| job-definition-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Update jobs resources

Update jobs resources.

**Usage:**

```
scw jobs definition update <job-definition-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| job-definition-id | Required |  |
| name |  |  |
| cpu-limit |  |  |
| memory-limit |  |  |
| image-uri |  |  |
| command |  |  |
| environment-variables.{key} |  |  |
| description |  |  |
| job-timeout |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## 




### Get jobs resources

Get jobs resources.

**Usage:**

```
scw jobs run get <job-run-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| job-run-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List jobs resources

List jobs resources.

**Usage:**

```
scw jobs run list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` |  |
| job-definition-id |  |  |
| project-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Stop jobs resources

Stop jobs resources.

**Usage:**

```
scw jobs run stop <job-run-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| job-run-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



